//============================================================================================
/**
 * @file	fushigi_data.c
 * @date	2006.04.28
 * @author	tamada / mitsuhara
 * @brief	ӂʐMpZ[uf[^֘A
 */
//============================================================================================

#include "savedata/savedata.h"
#include "savedata/fushigi_data.h"

#include "gflib/assert.h"

//============================================================================================
//============================================================================================

extern FUSHIGI_DATA * SaveData_GetFushigiData(SAVEDATA * sv);

#define UNIQ_TYPE			0xEDB88320L
#define FUSHIGI_DATA_NO_USED		0x00000000
#define FUSHIGI_DATA_MAX_EVENT		2048

#define FUSHIGI_MENU_FLAG		(FUSHIGI_DATA_MAX_EVENT - 1)

//------------------------------------------------------------------
/**
 * @brief	ӂf[^̒`
 */
//------------------------------------------------------------------
struct FUSHIGI_DATA{
  u8 recv_flag[FUSHIGI_DATA_MAX_EVENT / 8];		//256 * 8 = 2048 bit
  u32 deli_type[GIFT_DELIVERY_MAX];			// ₃`FbNpR[h
  u32 card_type[GIFT_CARD_MAX];
  GIFT_DELIVERY delivery[GIFT_DELIVERY_MAX];		// zBW
  GIFT_CARD card[GIFT_CARD_MAX];			// J[hR
};


//============================================================================================
//
//		ɃZ[uVXeĂ΂֐
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	Z[uf[^TCY̎擾
 * @return	int		ӂZ[uf[^̃TCY
 */
//------------------------------------------------------------------
int FUSHIGIDATA_GetWorkSize(void)
{
  return sizeof(FUSHIGI_DATA);
}
//------------------------------------------------------------------
/**
 * @brief	Z[uf[^
 * @param	fd		ӂZ[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
void FUSHIGIDATA_Init(FUSHIGI_DATA * fd)
{
#ifdef DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("ӂf[^\n");
  // ̏saveload_system.cSVDT_InitōsĂ̂ŉȂ
  MI_CpuClearFast(fd, sizeof(FUSHIGI_DATA));
#endif
}

//============================================================================================
//
//		p邽߂ɌĂ΂ANZX֐
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	zBf[^̎擾
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	index		zBf[^̃CfbNXiOIWj
 * @return	GIFT_DATA	zBf[^ւ̃|C^
 */
//------------------------------------------------------------------
GIFT_DELIVERY * FUSHIGIDATA_GetDeliData(FUSHIGI_DATA * fd, int index)
{
  GF_ASSERT(index < GIFT_DELIVERY_MAX);

  if(fd->deli_type[index] == UNIQ_TYPE){
    // f[^LȂ̂Ń|C^Ԃ
    return &fd->delivery[index];
  }
  // f[^݂Ȃ^ꂽ^ꂽĤŏNULLԂ
  fd->deli_type[index] = FUSHIGI_DATA_NO_USED;
  return (GIFT_DELIVERY *)NULL;
}

//------------------------------------------------------------------
/**
 * @brief	J[hf[^̎擾
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	index		蕨f[^̃CfbNXiOIWj
 * @return	GIFT_CARD	J[hf[^ւ̃|C^
 */
//------------------------------------------------------------------
GIFT_CARD *FUSHIGIDATA_GetCardData(FUSHIGI_DATA *fd, int index)
{
  GF_ASSERT(index < GIFT_CARD_MAX);
  if(fd->card_type[index] != FUSHIGI_DATA_NO_USED)
    return &fd->card[index];
  return NULL;
}

//------------------------------------------------------------------
/**
 * @brief	zBf[^Z[uf[^֓o^
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	p		f[^ւ̃|C^
 * @return	TRUE: Z[uł : FALSE: 󂫃Xbg
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_SetDeliData(FUSHIGI_DATA *fd, const void *p, int link)
{
  int i;

  // Z[uł̈悪΃Z[us
  if(FUSHIGIDATA_CheckDeliDataSpace(fd) == FALSE)	return FALSE;

  // ȍ~͗eʓIɂ̓Z[uɐ͂
  
  for(i = 0; i < GIFT_DELIVERY_MAX; i++){
    if(fd->deli_type[i] == FUSHIGI_DATA_NO_USED){
      MI_CpuCopy8(p, &fd->delivery[i], sizeof(GIFT_DELIVERY));
      fd->deli_type[i] = UNIQ_TYPE;
      fd->delivery[i].link = link;
      return TRUE;
    }
  }
  return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	J[hf[^Z[uf[^֓o^
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	p		f[^ւ̃|C^
 * @return	TRUE: Z[uł : FALSE: 󂫃Xbg
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_SetCardData(FUSHIGI_DATA *fd, const void *p)
{
  int i;
  GIFT_CARD *gc = (GIFT_CARD *)p;

  // Z[uł̈悪΃Z[us
  if(FUSHIGIDATA_CheckCardDataSpace(fd) == FALSE)	return FALSE;
  // zB܂ރf[^̏ꍇ͔zB`FbN
  if(gc->beacon.delivery_flag == TRUE &&
     FUSHIGIDATA_CheckDeliDataSpace(fd) == FALSE)	return FALSE;

  // ȍ~͗eʓIɂ̓Z[uɐ͂
  
  // J[hZ[u
  for(i = 0; i < GIFT_CARD_MAX; i++){
    if(fd->card_type[i] == FUSHIGI_DATA_NO_USED){
#ifdef DEBUG_ONLY_FOR_mituhara
      OS_TPrintf("J[hZ[u܂ [%d]\n", i);
#endif
      MI_CpuCopy8(gc, &fd->card[i], sizeof(GIFT_CARD));
      fd->card_type[i] = UNIQ_TYPE;

      // zBZ[u
      if(gc->beacon.delivery_flag == TRUE)
	FUSHIGIDATA_SetDeliData(fd, (const void *)&gc->gift_type, i+1);
  
      return TRUE;
    }
  }
  return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	zBf[^𖕏
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	index		zBf[^̃CfbNX
 * @return	TRUE: Z[uł : FALSE: 󂫃Xbg
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_RemoveDeliData(FUSHIGI_DATA *fd, int index)
{
  index--;                                         // k.ohno --ǉ
  GF_ASSERT(index < GIFT_DELIVERY_MAX);
  fd->deli_type[index] = FUSHIGI_DATA_NO_USED;
  fd->delivery[index].link = 0;
  return TRUE;
}

//------------------------------------------------------------------
/**
 * @brief	J[hf[^𖕏
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @return	TRUE: Z[uł : FALSE: 󂫃Xbg
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_RemoveCardData(FUSHIGI_DATA *fd, int index)
{
  GF_ASSERT(index < GIFT_CARD_MAX);
  fd->card_type[index] = FUSHIGI_DATA_NO_USED;
  // NĂJ[hꏏɖ
  FUSHIGIDATA_RemoveCardLinkDeli(fd, index + 1);

  return TRUE;
}

//------------------------------------------------------------------
/**
 * @brief	zBf[^Z[uł邩`FbN
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @return	TRUE: 󂫂 : FALSE: 󂫃Xbg
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_CheckDeliDataSpace(FUSHIGI_DATA *fd)
{
  int i;
  for(i = 0; i < GIFT_DELIVERY_MAX; i++){
    if(fd->deli_type[i] == FUSHIGI_DATA_NO_USED)
      return TRUE;
  }
  return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	J[hf[^Z[uł邩`FbN
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	size		f[^̃TCY
 * @return	TRUE: 󂫂 : FALSE: 󂫃Xbg
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_CheckCardDataSpace(FUSHIGI_DATA *fd)
{
  int i;
  for(i = 0; i < GIFT_CARD_MAX; i++){
    if(fd->card_type[i] == FUSHIGI_DATA_NO_USED)
      return TRUE;
  }
  return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	蕨f[^̑݃`FbN
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	index		蕨f[^̃CfbNXiOIWj
 * @return	BOOL	TRUE̎A݂
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_IsExistsDelivery(const FUSHIGI_DATA * fd, int index)
{
  GF_ASSERT(index < GIFT_DELIVERY_MAX);
  
  if(fd->deli_type[index] == FUSHIGI_DATA_NO_USED)
    return FALSE;
  // Ŗ{̓f[^CRC`FbNꂽȂ
  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	J[hf[^݂邩Ԃ
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @return	BOOL	TRUE̎A݂
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_IsExistsCard(const FUSHIGI_DATA * fd, int index)
{
  GF_ASSERT(index < GIFT_CARD_MAX);

  if(fd->card_type[index] == FUSHIGI_DATA_NO_USED)
    return FALSE;
  // Ŗ{̓f[^CRC`FbNꂽȂ
  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	Z[uf[^ɃJ[hf[^݂邩Ԃ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_IsExistsCardAll(const FUSHIGI_DATA *fd)
{
  int i;
  for(i = 0; i < GIFT_CARD_MAX; i++)
    if(FUSHIGIDATA_IsExistsCard(fd, i) == TRUE)
      return TRUE;
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	w̃J[hɃNĂzB݂邩
 * @param	index͂P`RL
 * @return	TRUE: zB݂͑ FALSE: ݂Ȃ
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_GetCardLinkDeli(const FUSHIGI_DATA *fd, int index)
{
  int i;

#if 0
  for(i = 0; i < GIFT_DELIVERY_MAX; i++)
    OS_TPrintf("Deli[%d] : %d\n", i, fd->delivery[i].link);
#endif
  
  if(index){
    for(i = 0; i < GIFT_DELIVERY_MAX; i++){
      if(fd->delivery[i].link == index)
	return TRUE;
    }
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	wJ[hɃNĂzB폜
 * @param	index͂P`RL(ΉȂ)
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_RemoveCardLinkDeli(const FUSHIGI_DATA *fd, int index)
{
  int i;
  if(index){
    for(i = 0; i < GIFT_DELIVERY_MAX; i++){
      if(fd->delivery[i].link == index){
#ifdef DEBUG_ONLY_FOR_mituhara
	OS_TPrintf("J[hƈꏏ %d Ԃ̂̂܂\n", i + 1);
#endif
	FUSHIGIDATA_RemoveDeliData((FUSHIGI_DATA *)fd, i + 1);
	return;
      }
    }
  }
}

//------------------------------------------------------------------
/**
 * @brief	w̃Cxg͂łɂԂ
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	num		Cxgԍ
 * @return	BOOL	TRUE̎AłɂĂ
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_IsEventRecvFlag(FUSHIGI_DATA * fd, int num)
{
  GF_ASSERT(num < FUSHIGI_DATA_MAX_EVENT);
  return !!(fd->recv_flag[num / 8] & (1 << (num & 7)));
}


//------------------------------------------------------------------
/**
 * @brief	w̃CxgtO𗧂Ă
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	num		Cxgԍ
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_SetEventRecvFlag(FUSHIGI_DATA * fd, int num)
{
  GF_ASSERT(num < FUSHIGI_DATA_MAX_EVENT);
  fd->recv_flag[num / 8] |= (1 << (num & 7));
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2008/09/03
// ͂񂪌ȂoȌC@\ǉ

//------------------------------------------------------------------
/**
 * @brief	w̃CxgtOONOFF
 * @param	fd		ӂZ[uf[^ւ̃|C^
 * @param	num		Cxgԍ
 * @return	NONE
 */
//------------------------------------------------------------------
static void FUSHIGIDATA_ToggleEventRecvFlag(FUSHIGI_DATA * fd, int num)
{
  GF_ASSERT(num < FUSHIGI_DATA_MAX_EVENT);
  fd->recv_flag[num / 8] ^= (1 << (num & 7));
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * @brief	ӂȂ̂\o邩H
 * @param	NONE
 * @return	TRUE: \@FALSE: \Ȃ
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_IsFushigiMenu(FUSHIGI_DATA *fd)
{
  return FUSHIGIDATA_IsEventRecvFlag(fd, FUSHIGI_MENU_FLAG);
}


//------------------------------------------------------------------
/**
 * @brief	ӂȂ̂̕\tOONɂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_SetFushigiMenu(FUSHIGI_DATA *fd)
{
  FUSHIGIDATA_SetEventRecvFlag(fd, FUSHIGI_MENU_FLAG);
}


//============================================================================================
//
//		ɏʂ̊֐Q@ɂĂł
//
//============================================================================================

static FUSHIGI_DATA *_fushigi_ptr = NULL;

//------------------------------------------------------------------
/**
 * @brief	ȉ̊֐g߂ɕKvȏ
 * @param	sv		Z[uf[^\ւ̃|C^
 * @param	heap_id		[N擾q[vID
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_InitSlot(SAVEDATA * sv, int heap_id)
{
  LOAD_RESULT result;

  if(_fushigi_ptr == NULL){
    _fushigi_ptr = SaveData_GetFushigiData(sv);
  }
}

//------------------------------------------------------------------
/**
 * @brief	ȉ̊֐gǏn
 * @param	sv		Z[uf[^\ւ̃|C^
 * @param	flag		TRUE: Z[u / FALSE: Z[uȂ
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_FinishSlot(SAVEDATA * sv, int flag)
{
  SAVE_RESULT result;
  if(_fushigi_ptr){
#if 0
    if(flag == TRUE)
      SaveData_Save(sv);
#endif
    _fushigi_ptr = NULL;
  }
}
     
//------------------------------------------------------------------
/**
 * @brief	XbgɃf[^邩Ԃ֐
 * @param	NONE
 * @return	BOOL	0..f[^Ȃ: 0..f[^
*/
//------------------------------------------------------------------
int FUSHIGIDATA_CheckSlotData(void)
{
  int i;
  for(i = 0; i < GIFT_DELIVERY_MAX; i++){
    if(FUSHIGIDATA_IsExistsDelivery(_fushigi_ptr, i) == TRUE)
      return i + 1;
  }
  return 0;
}

//------------------------------------------------------------------
/**
 * @brief	wԍ̃Xbgf[^̃^CvԂ
 * @param	index		Xbg̃CfbNXԍ
 * @return	int		MYSTERYGIFT_TYPE_xxxxx
 *
 * CfbNXԍFUSHIGIDATA_CheckSlotDataŕԂꂽl
*/
//------------------------------------------------------------------
int FUSHIGIDATA_GetSlotType(int index)
{
#if 0
  int i;
  GIFT_DELIVERY *dv;

  for(i = 0; i < GIFT_DELIVERY_MAX; i++){
    if(FUSHIGIDATA_IsExistsDelivery(_fushigi_ptr, i) == TRUE){
      dv = FUSHIGIDATA_GetDeliData(_fushigi_ptr, i);
      return (int)dv->gift_type;
    }
  }
  return MYSTERYGIFT_TYPE_NONE;
#else
  GIFT_DELIVERY *dv;

  if(index == 0)	return MYSTERYGIFT_TYPE_NONE;    //k.ohno --Oɏo
  index--;
  GF_ASSERT(index < GIFT_DELIVERY_MAX);
  if(FUSHIGIDATA_IsExistsDelivery(_fushigi_ptr, index) == TRUE){
    dv = FUSHIGIDATA_GetDeliData(_fushigi_ptr, index);
    if(dv){                              //k.ohno f[^ĂNULL
      return (int)dv->gift_type;
    }
  }
  return MYSTERYGIFT_TYPE_NONE;
#endif
}


//------------------------------------------------------------------
/**
 * @brief	wԍ̃Xbg\̂ւ̃|C^Ԃ
 * @param	index		Xbg̃CfbNXԍ
 * @return	GIFT_PRESENT	\̂ւ̃|C^
 *
 * CfbNXԍFUSHIGIDATA_CheckSlotDataŕԂꂽl
 */
//------------------------------------------------------------------
GIFT_PRESENT *FUSHIGIDATA_GetSlotPtr(int index)
{
  if(index){
    index--;                          // k.ohno 
    return &_fushigi_ptr->delivery[index].data;
  }
  return NULL;
}

//------------------------------------------------------------------
/**
 * @brief	w̃Xbg
 * @param	index		Xbg̃CfbNXԍ
 * @return	NONE
 *
 * CfbNXԍFUSHIGIDATA_CheckSlotDataŕԂꂽl
 */
//------------------------------------------------------------------
void FUSHIGIDATA_RemoveSlot(int index)
{
  FUSHIGIDATA_RemoveDeliData(_fushigi_ptr, index);
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2008/09/03
// ͂񂪌ȂoȌC@\ǉ

//------------------------------------------------------------------
/**
 * @brief	xtOgO
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_ToggleOneGetFlg(int flgIndex)
{
  FUSHIGIDATA_ToggleEventRecvFlag(_fushigi_ptr, flgIndex);
}

//------------------------------------------------------------------
/**
 * @brief	xtOONǂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
BOOL FUSHIGIDATA_IsOneGetFlg(int flgIndex)
{
  return FUSHIGIDATA_IsEventRecvFlag(_fushigi_ptr, flgIndex);
}

// ----------------------------------------------------------------------------




//------------------------------------------------------------------


#include "system/gamedata.h"         //k.ohno fobOpɒǉ
#include "savedata/regulation.h"      //k.ohno fobOpɒǉ
#include "regulation_local.h"       //k.ohno fobOpɒǉ
#include "system/msgdata.h"         //k.ohno fobOpɒǉ
#include "msgdata/msg.naix"         //k.ohno fobOpɒǉ
#include "msgdata/msg_debug_mitsuhara.h"  //k.ohno fobOpɒǉ
#include "msgdata/msg_debug_ohno.h"  //k.ohno fobOpɒǉ
#include "poketool/pokeparty.h"   //k.ohno fobOpɒǉ

static POKEMON_PARAM* _createPokeParam(u32 heapID );

//------------------------------------------------------------------
/**
 * @brief	fobOpɃ|Pf[^Zbg֐
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
void FUSHIGIDATA_DebugSetPokemon(void)
{
  REGULATION _dummycup = {
        {EOM_}, // gmmƂĂ
        80,//x̍vWO܂
        3,//RC
        30,//|P̃xRO܂
        -20,//gQDO
        -20,// ̏dQO
        0,// i|PQłȂ
        0,// ʂȃ|PQłȂ
        0,// |PQłȂ
        0,// Ȃ
        0,// Œ_[WZKs
    };
  int no;
  GIFT_DELIVERY gd;
  GIFT_PRESENT_ACCESSORY gpacc;
  GIFT_PRESENT_POKEMON po;
  POKEMON_PARAM* pp;
    
    
  if(_fushigi_ptr == NULL)	return;
  FUSHIGIDATA_Init(_fushigi_ptr);

  gd.gift_type = MYSTERYGIFT_TYPE_MEMBERSCARD;
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
  gd.gift_type = MYSTERYGIFT_TYPE_LETTER;
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
  gd.gift_type = MYSTERYGIFT_TYPE_WHISTLE;
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);

  // ۂ e
  gd.gift_type = MYSTERYGIFT_TYPE_POKEMON;
  po.parentType = MYSTERYPOKE_PARENTNAME_MY;
  pp = _createPokeParam(HEAPID_FIELD);
#if 0
  MI_CpuCopy8(pp, &po.monsno, PokemonParam_GetWorkSize());
#endif
  MI_CpuCopy8(&po, &gd.data, sizeof(GIFT_PRESENT_POKEMON));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
  sys_FreeMemoryEz(pp);

  // ۂ ê܂
  gd.gift_type = MYSTERYGIFT_TYPE_POKEMON;
#if 0
  po.parentType = MYSTERYPOKE_PARENTNAME_THROW;
#endif
  pp = _createPokeParam(HEAPID_FIELD);
#if 0
  MI_CpuCopy8(pp, &po.monsno, PokemonParam_GetWorkSize());
#endif
  MI_CpuCopy8(&po, &gd.data, sizeof(GIFT_PRESENT_POKEMON));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
  sys_FreeMemoryEz(pp);

    // ܂
  gd.gift_type = MYSTERYGIFT_TYPE_RANGEREGG;
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);

#if 0

    // SEAL
  gd.gift_type = MYSTERYGIFT_TYPE_ACCESSORY;
  gpacc.accType = MYSTERYGIFT_ACCTYPE_SEAL;
  gpacc.accNo = 79;//V[
  MI_CpuCopy8(&gpacc, &gd.data, sizeof(GIFT_PRESENT_ACCESSORY));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
  // CLIP
  gd.gift_type = MYSTERYGIFT_TYPE_ACCESSORY;
  gpacc.accType = MYSTERYGIFT_ACCTYPE_CLIP;
  gpacc.accNo = 99;//Ȃڂ
  MI_CpuCopy8(&gpacc, &gd.data, sizeof(GIFT_PRESENT_ACCESSORY));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
    // haikei
  gd.gift_type = MYSTERYGIFT_TYPE_ACCESSORY;
  gpacc.accType = MYSTERYGIFT_ACCTYPE_BG;
  gpacc.accNo = 2;//
  MI_CpuCopy8(&gpacc, &gd.data, sizeof(GIFT_PRESENT_ACCESSORY));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);

    // ۂ
  gd.gift_type = MYSTERYGIFT_TYPE_POKETCH;
  no = 1; //POKETCH_APPID_STOPWATCH
  MI_CpuCopy8(&no, &gd.data, sizeof(int));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
  {  // _~[M[V쐬
    MSGDATA_MANAGER* msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_mitsuhara_dat, HEAPID_FIELD);
    STRBUF* pStr = MSGMAN_AllocString( msgman, msg_regulation_dummy );
    gd.gift_type = MYSTERYGIFT_TYPE_RULE;
    Regulation_SetCupName(&_dummycup,pStr);
    MI_CpuCopy8(&_dummycup, &gd.data, sizeof(REGULATION));
    FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);
    MSGMAN_Delete(msgman);
    STRBUF_Delete(pStr);
  }

  gd.gift_type = MYSTERYGIFT_TYPE_ITEM;
  no = 80;
  MI_CpuCopy8(&no, &gd.data, sizeof(int));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);

  gd.gift_type = MYSTERYGIFT_TYPE_GOODS;
  no = 33;
  MI_CpuCopy8(&no, &gd.data, sizeof(int));
  FUSHIGIDATA_SetDeliData(_fushigi_ptr, (const void *)&gd, 0);

#endif

    
}

//----------------------------------------------------------------------------
/**
 *	@brief	fobOpɃ|P֐
 *	@param	heapID		    HEAP
 *	@return p_pp		|Pp
 */
//-----------------------------------------------------------------------------

static STRBUF* _dummyGetGmm(int heapID, int no)
{
    MSGDATA_MANAGER* msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_ohno_dat, heapID);
    STRBUF* pStr = MSGMAN_AllocString( msgman, msg_debugohno_name01+no );
    MSGMAN_Delete(msgman);
    return pStr;
}

// |P
typedef struct {
  u32 monsno;			// X^[io[
  u32 hp_rnd;			// HP
  u32 at_rnd;			// U
  u32 df_rnd;			// h䗐
  u32 sp_rnd;			// 
  u32 sa_rnd;			// U
  u32 sd_rnd;			// h
  u32 speabino;			// \
  u32	mons_id;		// ID
  u32 style;			// 悳
  u32 beautiful;		// 
  u32 cute;			// 킢
  u32 clever;			// 
  u32 strong;			// ܂
  u32 mons_rnd;			// ő̗
  u32 item;			// ACe
  u32 oya_sex;			// e
  u32 fur;			// щ
  u32 world_code;		// e̍R[h
} _DEBUG_POKEMON;

static POKEMON_PARAM* _createPokeParam(u32 heapID )
{
	STRBUF* str;
    POKEMON_PARAM* p_pp = PokemonParam_AllocWork( heapID );
    int level = 5;
    int trade_no = 0; 
    static _DEBUG_POKEMON debug_pokemon_data = {
    63,				// X^[io[(MONSNO_KEESHI)
    15,				// HP
    15,				// U
    15,				// h䗐
    20,				// 
    25,				// U
    25,				// h
    28,				// \(TOKUSYU_SINKURO)
    25643,			// ID
    0,				// 悳
    0,				// 
    0,				// 킢
    0,				// 
    0,				// ܂
    117,			// ő̗
    155,			// ACe(Î)
    1,				// e()
    0,				// щ
    1,				// e̍R[h(LANG_JAPAN)
  };

    
//	PokeParaInit(p_pp);
	// X^[io[@x@ő̗@IDݒ
	PokeParaSet( p_pp, 
			debug_pokemon_data.monsno,
			level, POW_RND, 
			RND_SET, debug_pokemon_data.mons_rnd,
			ID_SET, debug_pokemon_data.mons_id );

	// jbNl[
	str = _dummyGetGmm(HEAPID_EVENT,trade_no);
	PokeParaPut( p_pp, ID_PARA_nickname_buf, str );
	STRBUF_Delete(str);

	// e헐ݒ
	PokeParaPut( p_pp, ID_PARA_hp_rnd, &debug_pokemon_data.hp_rnd );
	PokeParaPut( p_pp, ID_PARA_pow_rnd, &debug_pokemon_data.at_rnd );
	PokeParaPut( p_pp, ID_PARA_def_rnd, &debug_pokemon_data.df_rnd );
	PokeParaPut( p_pp, ID_PARA_agi_rnd, &debug_pokemon_data.sp_rnd );
	PokeParaPut( p_pp, ID_PARA_spepow_rnd, &debug_pokemon_data.sa_rnd );
	PokeParaPut( p_pp, ID_PARA_spedef_rnd, &debug_pokemon_data.sd_rnd );

	// 
	PokeParaPut( p_pp, ID_PARA_speabino, &debug_pokemon_data.speabino );

	// 悳Ȃ
	PokeParaPut( p_pp, ID_PARA_style, &debug_pokemon_data.style );
	PokeParaPut( p_pp, ID_PARA_beautiful, &debug_pokemon_data.beautiful );
	PokeParaPut( p_pp, ID_PARA_cute, &debug_pokemon_data.cute );
	PokeParaPut( p_pp, ID_PARA_clever, &debug_pokemon_data.clever );
	PokeParaPut( p_pp, ID_PARA_strong, &debug_pokemon_data.strong );
	
	// ACe
	PokeParaPut( p_pp, ID_PARA_item, &debug_pokemon_data.item );

	// e̖O
 	str = _dummyGetGmm(HEAPID_EVENT,trade_no);
	PokeParaPut( p_pp, ID_PARA_oyaname_buf, str );
	STRBUF_Delete(str);

	// e̐	
	PokeParaPut( p_pp, ID_PARA_oyasex, &debug_pokemon_data.oya_sex );

	// R[h
	PokeParaPut( p_pp, ID_PARA_country_code, &debug_pokemon_data.world_code );
    return p_pp;
}



/*  */
