//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imageclip_data.c
 *	@brief		C[WNbvZ[uf[^
 *	@author		tomoya takahashi
 *	@data		2006.02.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "include/savedata/savedata_def.h"	//SAVEDATAQƂ̂
#include "include/savedata/savedata.h"
#include "include/gflib/system.h"
#include "include/gflib/assert.h"
#include <string.h>

#define	__IMAGECLIP_DATA_H_GLOBAL
#include "include/savedata/imageclip_data.h"


#include "include/gflib/strbuf_family.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_SAVEDATA_DATAINIT_FLAG	( 0x1234 )		// f[^i[̃tO
#define IMC_SAVEDATA_DATASET_FLAG	( 0x2345 )		// Z[uf[^i[̃tO

enum{
	IMC_ACCE_9_GET_NUM = 9,
	IMC_ACCE_1_GET_NUM = 1,
	
	IMC_ACCE_9_ARRY_IN = 8,		// 9pzu32ɓf[^̐
	IMC_ACCE_1_ARRY_IN = 32,	// 1pzu32ɓf[^̐
	IMC_BG_ARRY_IN	   = 4,		// BGpzu32ɓf[^̐
	IMC_ACCE_9_ARRY_BIT = 4,	// 9pz1f[^Ɏgrbg
	IMC_ACCE_1_ARRY_BIT = 1,	// 1pz1f[^Ɏgrbg
	IMC_BG_ARRY_BIT		= 8,	// BGpz1f[^Ɏgrbg
	
	IMC_ACCE_9_ARRY_NUM	= 8,	// 9ĂANZT̃tOz
	IMC_ACCE_1_ARRY_NUM = 2,	// 1ĂANZT̃tOz
	IMC_BG_ARRY_NUM = 6,		// BG̃tOz
};

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
//	|Pf[^
//=====================================
typedef struct _IMC_SAVEDATA_POKEMON{
	u32 personal_rnd;				///<|P̌
	u32 idno;						///<IDNo	A|Pp
	u16	monsno;						///<X^[io[
	u16 nickname[ IMC_SAVEDATA_NICKNAME_STR_NUM ];	///<jbNl[
	u16 oyaname[ IMC_SAVEDATA_OYANAME_STR_NUM ];	///<jbNl[
	s8 poke_pri;					///<|PD揇
	u8 poke_x;						///<|PW
	u8 poke_y;						///<|PW
	u8 form_id;					///<`Agr[g
	u8 oya_sex;						///<e
} ;

//-------------------------------------
//	ANZTf[^\
//=====================================
typedef struct _IMC_SAVEDATA_ACCESSORIE{
	u8 accessory_no;	///<ANZTio[
	u8 accessory_x;		///<ANZTW
	u8 accessory_y;		///<ANZTW
	s8 accessory_pri;	///<ANZT\D
} ;



//-------------------------------------
//	erǗpZ[uf[^[N
//=====================================
typedef struct _IMC_TELEVISION_SAVEDATA{
	u32 init_flag;					///<ް̃tO
	IMC_SAVEDATA_POKEMON	pokemon;///<|Pf[^
	u32 accessory_set_msk;			///<i[ANZT[}XN
	PMS_DATA title;					///<Nbv^Cg
	IMC_SAVEDATA_ACCESSORIE acce[ IMC_SAVEDATA_TELEVISION_ACCE_NUM ];	///<ANZT
	u8 bg_id;								///<bgio[	
	u8 country;	// R[h
} ;

//-------------------------------------
//	ReXgpZ[uf[^[N
//=====================================
typedef struct _IMC_CONTEST_SAVEDATA{
	u32 init_flag;					///<ް̃tO
	u32 rank_code;					///<ReXgNR[h
	IMC_SAVEDATA_POKEMON	pokemon;///<|Pf[^
	u32 accessory_set_msk;			///<i[ANZT[}XN
	IMC_SAVEDATA_ACCESSORIE acce[ IMC_SAVEDATA_CONTEST_ACCE_NUM ];	///<ANZT
	u8 bg_id;						///<bgio[	
} ;

//-------------------------------------
//	ACeێZ[uf[^[N
//=====================================
typedef struct _IMC_ITEM_SAVEDATA{
	u32 acce_9[ IMC_ACCE_9_ARRY_NUM ];		// 9ĂANZT@擾tO
	u32 acce_1[ IMC_ACCE_1_ARRY_NUM ];		// 1ĂANZT@擾tO
	u32 bg[ IMC_BG_ARRY_NUM ];				// BG擾ԃf[^
} ;


//-------------------------------------
//	Z[uf[^
//=====================================
struct _IMC_SAVEDATA{
	IMC_TELEVISION_SAVEDATA imc_television_savedata[ IMC_SAVEDATA_TELEVISION_SAVENUM ];	///<savef[^
	IMC_CONTEST_SAVEDATA	imc_contest_savedata[ IMC_SAVEDATA_CONTEST_SAVENUM ];		///<savef[^

	IMC_ITEM_SAVEDATA	imc_item_savedata;	///<ACeZ[uf[^
};


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbv[NĂȂ`FbN
 *
 *	@param	init_flag		f[^tO
 *
 *	@retval	TRUE		
 *	@retval FALSE	Ă
 */
//-----------------------------------------------------------------------------
static inline BOOL correct_savedata( u32 init_flag )
{
	if( (init_flag == IMC_SAVEDATA_DATAINIT_FLAG) ||
		(init_flag == IMC_SAVEDATA_DATASET_FLAG) ){

		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	erǗpZ[uf[^̐`FbN
 *	
 *	@param	wk	Z[uf[^
 *
 *	@retval	TRUE		
 *	@retval FALSE	Ă
 */
//-----------------------------------------------------------------------------
static inline BOOL correct_television_savedata( const IMC_TELEVISION_SAVEDATA* wk )
{
	return correct_savedata( wk->init_flag );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpZ[uf[^̐`FbN
 *	
 *	@param	wk	Z[uf[^
 *
 *	@retval	TRUE		
 *	@retval FALSE	Ă
 */
//-----------------------------------------------------------------------------
static inline BOOL correct_contest_savedata( const IMC_CONTEST_SAVEDATA* wk )
{
	return correct_savedata( wk->init_flag );
}

//----------------------------------------------------------------------------
/**
 *	@brief	erǗpZ[uf[^̏
 *	
 *	@param	wk	Z[uf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static inline void clean_television_savedata( IMC_TELEVISION_SAVEDATA* wk )
{
	memset( wk, 0, sizeof(IMC_TELEVISION_SAVEDATA) );
	wk->init_flag = IMC_SAVEDATA_DATAINIT_FLAG;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpZ[uf[^̏
 *	
 *	@param	wk	Z[uf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static inline void clean_contest_savedata( IMC_CONTEST_SAVEDATA* wk )
{
	memset( wk, 0, sizeof(IMC_CONTEST_SAVEDATA) );
	wk->init_flag = IMC_SAVEDATA_DATAINIT_FLAG;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P[Nf[^擾
 *
 *	@param	ip		|Pp[^
 *	@param	x		W擾
 *	@param	y		W擾
 *	@param	pri		\D揇
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static inline void get_poke_mat( IMC_POKE* ip, u8* x, u8* y, s8* pri )
{
	int gx, gy;
	int gpri;

	IMC_POKE_MatrixGet( ip, &gx, &gy );
	gpri = IMC_POKE_DrawPriorityGet( ip );
	GF_ASSERT( gx < 256 );
	GF_ASSERT( gy < 256 );
	GF_ASSERT( gpri > -128 );

	*x = gx;
	*y = gy;
	*pri = gpri;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pf[^̊i[
 *
 *	@param	p_pokemon	C[WNbv|PZ[u[N
 *	@param	pp			|Pp[^
 *	@param	x			W
 *	@param	y			W
 *	@param	pri			D揇
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ImcSaveData_SetPokeData_Local_Core( IMC_SAVEDATA_POKEMON* p_pokemon, POKEMON_PARAM* pp, u8 x, u8 y, s8 pri )
{
	p_pokemon->monsno   = PokeParaGet(pp, ID_PARA_monsno, NULL);
	PokeParaGet(pp, ID_PARA_nickname, p_pokemon->nickname);
//	PokeParaGet(pp, ID_PARA_oyaname, p_pokemon->oyaname);
	p_pokemon->personal_rnd = PokeParaGet(pp, ID_PARA_personal_rnd, NULL );
	p_pokemon->idno = PokeParaGet(pp, ID_PARA_id_no, NULL);
	p_pokemon->form_id = PokeParaGet(pp, ID_PARA_form_no, NULL);
//	p_pokemon->oya_sex = PokeParaGet(pp, ID_PARA_oyasex, NULL);
	p_pokemon->poke_x = x;
	p_pokemon->poke_y = y;
	p_pokemon->poke_pri = pri;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pf[^̊i[
 *
 *	@param	p_pokemon	C[WNbv|PZ[u[N
 *	@param	pp			|Pp[^
 *	@param	ip			C[WNbv|Pf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ImcSaveData_SetPokeData_Local( IMC_SAVEDATA_POKEMON* p_pokemon, POKEMON_PARAM* pp, IMC_POKE* ip )
{
	u8 x, y;
	s8 pri;
	get_poke_mat( ip, &x, &y, &pri );
	ImcSaveData_SetPokeData_Local_Core( p_pokemon, pp, x, y, pri );
}

//----------------------------------------------------------------------------
/**
 *	@brief	g[i[f[^ݒ
 *
 *	@param	p_pokemon		|Pf[^
 *	@param	pbuff			g[i[obt@
 *	@param	sex				
 */
//-----------------------------------------------------------------------------
static void ImcSaveData_SetTrData_Local( IMC_SAVEDATA_POKEMON* p_pokemon, const STRBUF* pbuff, int sex )
{
	STRBUF_GetStringCode( pbuff, p_pokemon->oyaname, IMC_SAVEDATA_OYANAME_STR_NUM );
	p_pokemon->oya_sex = sex;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pp[^̍쐬
 *	@param	p_pokemon		C[WNbv|PZ[uf[^
 *	@param	pp				|Pp[^i[
 */
//-----------------------------------------------------------------------------
static inline void imcsacedata_GetPokePara_Local( const IMC_SAVEDATA_POKEMON* p_pokemon, POKEMON_PARAM* pp )
{
	PokeParaSet( pp, p_pokemon->monsno, 0, 0, RND_SET, p_pokemon->personal_rnd, ID_SET, p_pokemon->idno );
	PokeParaPut( pp, ID_PARA_nickname, p_pokemon->nickname );
//	PokeParaPut( pp, ID_PARA_oyaname, p_pokemon->oyaname );
	PokeParaPut( pp, ID_PARA_form_no, &p_pokemon->form_id );
//	PokeParaPut( pp, ID_PARA_oyasex, &p_pokemon->oya_sex );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTf[^i[
 *
 *	@param	p_acce		ANZT[N
 *	@param	acce_no		ANZTio[
 *	@param	x			W
 *	@param	y			W
 *	@param	pri			D揇
 */
//-----------------------------------------------------------------------------
static void imcsavedata_SetAcce_Local( IMC_SAVEDATA_ACCESSORIE* p_acce, u8 acce_no, u8 x, u8 y, u8 pri )
{
	p_acce->accessory_no	= acce_no;
	p_acce->accessory_x		= x;
	p_acce->accessory_y		= y;
	p_acce->accessory_pri	= pri;
}



//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێݒ
 *
 *	@param	p_arry		ANZTz
 *	@param	set_data	ݒ萔
 *	@param	idx			CfbNX
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void imcsavedata_Acce9Set( u32* p_arry, u8 set_data, u8 idx )
{
	u8 arry_idx;
	u8 bit_idx;

	// idx傫
	GF_ASSERT( idx < IMC_ACCE_GET_9_NUM );
	arry_idx = idx / IMC_ACCE_9_ARRY_IN;
	
	bit_idx = idx % IMC_ACCE_9_ARRY_IN;
	bit_idx *= IMC_ACCE_9_ARRY_BIT;

	// ̈N[
	p_arry[ arry_idx ] &= ~(0xf << bit_idx);
	// ݒ
	p_arry[ arry_idx ] |= (set_data << bit_idx);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێ擾
 *
 *	@param	p_arry		ANZTz
 *	@param	idx			CfbNX	
 *
 *	@return	ێ
 */
//-----------------------------------------------------------------------------
static u8 imcsavedata_Acce9Get( const u32* p_arry, u8 idx )
{
	u8 now;
	u8 arry_idx;
	u8 bit_idx;
	
	// idx傫
	GF_ASSERT( idx < IMC_ACCE_GET_9_NUM );

	arry_idx = idx / IMC_ACCE_9_ARRY_IN;
	bit_idx = idx % IMC_ACCE_9_ARRY_IN;
	bit_idx *= IMC_ACCE_9_ARRY_BIT;
	now = (p_arry[ arry_idx ] >> bit_idx) & 0xf;

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/16
	// ANZT700ȏ㎝ĂƁAhXAbvŃt[Ys̏C
	// localize_spec_mark(LANG_ALL) imatake 2007/01/24
	// include/bugfix.h ̃XCb`Ő؂芷悤ɕύX

#if AFTERMASTER_070112_IMAGECLIP_ACCE_BUG_FIX
	// 9ȏ͂Ȃ̂ŁA9ɂ
	// 2007/01/09@oOZ9傫Ă\邽ߏC@
	if( now > IMC_ACCE_9_GET_NUM ){
		now = IMC_ACCE_9_GET_NUM;
	}
#endif

	// ----------------------------------------------------------------------------

	return now;
}

//----------------------------------------------------------------------------
/**
 *	@brief	1bittOz̃tOݒ
 *
 *	@param	p_arry		z|C^
 *	@param	set_data	ݒ萔@0 or 1
 *	@param	idx			CfbNX 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void imcsavedata_1bitArry_set( u32* p_arry, u8 set_data, u8 idx )
{
	u8 arry_idx;
	u8 bit_idx;

	// l傫
	GF_ASSERT( set_data < 2 );

	arry_idx = idx / IMC_ACCE_1_ARRY_IN;
	bit_idx = idx % IMC_ACCE_1_ARRY_IN;
	bit_idx *= IMC_ACCE_1_ARRY_BIT;

	// ̈N[
	p_arry[ arry_idx ] &= ~(0x1 << bit_idx);
	// ݒ
	p_arry[ arry_idx ] |= (set_data << bit_idx);
}

//----------------------------------------------------------------------------
/**
 *	@brief	1rbgtOz̒l擾֐
 *
 *	@param	p_arry	1rbgz
 *	@param	idx		CfbNX
 *
 *	@return	l
 */
//-----------------------------------------------------------------------------
static u8 imcsavedata_1bitArry_get( const u32* p_arry, u8 idx )
{
	u8 arry_idx;
	u8 bit_idx;

	arry_idx = idx / IMC_ACCE_1_ARRY_IN;
	bit_idx = idx % IMC_ACCE_1_ARRY_IN;
	bit_idx *= IMC_ACCE_1_ARRY_BIT;

	return (p_arry[ arry_idx ] >> bit_idx) & 0x1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGz̃tOݒ
 *
 *	@param	p_arry		z|C^
 *	@param	set_data	ݒ萔
 *	@param	idx			CfbNX 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void imcsavedata_BGArry_set( u32* p_arry, u8 set_data, u8 idx )
{
	u8 arry_idx;
	u8 bit_idx;

	// l傫
	GF_ASSERT( set_data <= IMC_BG_RIGHT_MAX );

	arry_idx = idx / IMC_BG_ARRY_IN;
	bit_idx = idx % IMC_BG_ARRY_IN;
	bit_idx *= IMC_BG_ARRY_BIT;

	// ̈N[
	p_arry[ arry_idx ] &= ~(0xff << bit_idx);
	// ݒ
	p_arry[ arry_idx ] |= (set_data << bit_idx);
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGtOz̒l擾֐
 *
 *	@param	p_arry	BGz
 *	@param	idx		CfbNX
 *
 *	@return	l
 */
//-----------------------------------------------------------------------------
static u8 imcsavedata_BGArry_get( const u32* p_arry, u8 idx )
{
	u8 arry_idx;
	u8 bit_idx;

	arry_idx = idx / IMC_BG_ARRY_IN;
	bit_idx = idx % IMC_BG_ARRY_IN;
	bit_idx *= IMC_BG_ARRY_BIT;

	return (p_arry[ arry_idx ] >> bit_idx) & 0xff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ێĂf[^擾
 *
 *	@param	p_arry		BGz
 *
 *	@return	ێ
 */
//-----------------------------------------------------------------------------
static u8 imcsavedata_BGArry_FlagOnDataNumGet( const u32* p_arry )
{
	int i;
	int count;

	count = 0;
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){

		if( imcsavedata_BGArry_get( p_arry, i ) != IMC_BG_RIGHT_MAX ){
			count ++;
		}
	}
	return count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃ANZT9ێANZT`FbN
 *
 *	@param	acce_no		ANZTio[
 *
 *	@retval	TRUE	9ێo
 *	@retval	FALSE	1ێł
 */
//-----------------------------------------------------------------------------
static inline BOOL imcsavedata_AcceNo_9Check( u32 acce_no )
{
	if( acce_no < IMC_ACCE_GET_1_START ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTio[1ێANZT̐ɕύX
 *
 *	@param	acce_no		ANZTio[
 *
 *	@return	1ێANZT̐
 */
//-----------------------------------------------------------------------------
static inline u8 imcsavedata_AcceNo_1Get( u32 acce_no )
{
	GF_ASSERT( acce_no >= IMC_ACCE_GET_1_START );

	return acce_no - IMC_ACCE_GET_1_START;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ACeZ[ü̏
 *
 *	@param	wk	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static inline void clean_item_savedata( IMC_ITEM_SAVEDATA* wk )
{
	int i;
	memset( wk, 0, sizeof(IMC_ITEM_SAVEDATA) );

	// BG̗͍̈ŏɍő吔i[Ă
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		imcsavedata_BGArry_set( wk->bg, IMC_BG_RIGHT_MAX, i );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pio[@|P̍W擾
 */
//-----------------------------------------------------------------------------
static void ImcSaveData_ImcPokeObjContestMatGet( POKEMON_PARAM* pp, u8* x, u8* y )
{
	u8 height = PokeParaHeightGet( pp, PARA_FRONT );

	*x = IMC_POKE_INIT_X - (IMC_SEENFADE_MOVE_ADD_X*IMC_SEENFADE_MOVE_COUNT);

	// 1܂Nbv̂Ђ傤ɂ
	*y = (IMC_RBOX_AREA_Y + IMC_RBOX_AREA_HEIGHT) - ((SOFT_SPRITE_SIZE_Y/2) - height) + IMC_POKE_MAT_CONTEST_Y_OFS;
	// 2̌AZ[ûЂ傤ɂ	erpƃReXgp̃Z[ůW킹邽
	*y += (IMC_SEENFADE_MOVE_ADD_Y*IMC_SEENFADE_MOVE_COUNT);
}


//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbv[N̏
 *
 *	@param	iw	C[WNbv[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_Init(IMC_SAVEDATA * iw)
{
	int i;

	for( i=0; i<IMC_SAVEDATA_TELEVISION_SAVENUM; i++ ){
		clean_television_savedata( &iw->imc_television_savedata[ i ] );
	}
	for( i=0; i<IMC_SAVEDATA_CONTEST_SAVENUM; i++ ){
		clean_contest_savedata( &iw->imc_contest_savedata[ i ] );
	}
	clean_item_savedata( &iw->imc_item_savedata );
}


//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvZ[uf[^[NTCY̎擾
 *
 *	@param	none
 *
 *	@return	[NTCY
 */
//-----------------------------------------------------------------------------
int ImcSaveData_GetWorkSize(void)
{
	return sizeof(IMC_SAVEDATA);
}

//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvp[N̐
 *
 *	@param	heapID		q[vID
 *
 *	@return	C[WNbv[Ñ|C^
 */
//-----------------------------------------------------------------------------
IMC_SAVEDATA * ImcSaveData_AllocWork(u32 heapID)
{
	IMC_SAVEDATA * iw;
	iw = sys_AllocMemory(heapID, sizeof(IMC_SAVEDATA));
	ImcSaveData_Init(iw);
	return iw;
}

//----------------------------------------------------------------------------
/**
 *	@brief	erp[NTCY擾
 *
 *	@param	none
 *
 *	@return	[NTCY
 */
//-----------------------------------------------------------------------------
int ImcSaveData_GetTelevisionWorkSize(void)
{
	return sizeof(IMC_TELEVISION_SAVEDATA);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp[NTCY擾
 *
 *	@param	none
 *
 *	@return	[NTCY
 */
//-----------------------------------------------------------------------------
int ImcSaveData_GetContestWorkSize(void)
{
	return sizeof(IMC_CONTEST_SAVEDATA);
}


//----------------------------------------------------------------------------
/**
 *	@brief	erp[N쐬
 *
 *	@param	heapID	q[v
 *
 *	@return	[N|C^
 */
//-----------------------------------------------------------------------------
IMC_TELEVISION_SAVEDATA* ImcSaveData_TelevisionAllocWork(u32 heapID)
{
	IMC_TELEVISION_SAVEDATA* iow;

	iow = sys_AllocMemory(heapID, sizeof(IMC_TELEVISION_SAVEDATA));
	clean_television_savedata( iow );
	return iow;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp[N쐬
 *
 *	@param	heapID	q[v
 *
 *	@return	[N|C^
 */
//-----------------------------------------------------------------------------
IMC_CONTEST_SAVEDATA* ImcSaveData_ContestAllocWork(u32 heapID)
{
	IMC_CONTEST_SAVEDATA* iow;

	iow = sys_AllocMemory(heapID, sizeof(IMC_CONTEST_SAVEDATA));
	clean_contest_savedata( iow );
	return iow;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ACep[N쐬
 *
 *	@param	heapID	q[v
 *
 *	@return	[N|C^
 */
//-----------------------------------------------------------------------------
IMC_ITEM_SAVEDATA* ImcSaveData_ItemAllocWork(u32 heapID)
{
	IMC_ITEM_SAVEDATA* iow;

	iow = sys_AllocMemory(heapID, sizeof(IMC_ITEM_SAVEDATA));
	clean_item_savedata( iow );
	
	return iow;
}


//-----------------------------------------------------------------------------
//	[Nf[^ǂݏ
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvf[^̃erW1擾
 *
 *	@param	iw		C[WNbv[N
 *	@param	no		擾CfbNX
 *
 *	@return	erW1̃f[^
 */
//-----------------------------------------------------------------------------
IMC_TELEVISION_SAVEDATA* ImcSaveData_GetTelevisionSaveData(IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_SAVENUM );		///<ző吔`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( &iw->imc_television_savedata[ no ] ) );
	
	return &iw->imc_television_savedata[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpZ[uf[^1擾
 *
 *	@param	iw		C[WNbv[N
 *	@param	no		擾CfbNX
 *
 *	@return	ReXgpZ[uf[^
 */
//-----------------------------------------------------------------------------
IMC_CONTEST_SAVEDATA* ImcSaveData_GetContestSaveData(IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_SAVENUM );		///<ző吔`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( &iw->imc_contest_savedata[ no ] ) );
	
	return &iw->imc_contest_savedata[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^ACeێZ[u[N擾
 *
 *	@param	iw		C[WNbv[N
 *
 *	@return	ACeZ[uf[^
 */
//-----------------------------------------------------------------------------
IMC_ITEM_SAVEDATA* ImcSaveData_GetItemSaveData(IMC_SAVEDATA* iw)
{
	return &iw->imc_item_savedata;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃erǗpZ[uf[^̈ɃZ[uĂ邩
 *
 *	@param	iw	C[WNbv[N
 *	@param	no	`FbNCfbNX
 *
 *	@retval	TRUE	Z[uς
 *	@retval	FALSE	Z[
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckTelevisionSaveData(const IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_SAVENUM );		///<ző吔`FbN

	return ImcSaveData_CheckTelevisionData( &iw->imc_television_savedata[ no ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃erǗpZ[uf[^̈ɃZ[uĂ邩
 *
 *	@param	iw	C[WNbv[N
 *	@param	no	`FbNCfbNX
 *
 *	@retval	TRUE	Z[uς
 *	@retval	FALSE	Z[
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckContestSaveData(const IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_SAVENUM );		///<ző吔`FbN

	return ImcSaveData_CheckContestData( &iw->imc_contest_savedata[ no ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTǉł邩`FbN
 *
 *	@param	p_iow		Z[uf[^[N
 *	@param	acce_no		ANZT[N
 *	@param	num			ANZT
 *
 *	@retval	TRUE	ǉ\
 *	@retval	FALSE	ǉs\
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckAcceAdd( const IMC_ITEM_SAVEDATA* p_iow, u32 acce_no, u32 num )
{
	u32 get;
	BOOL ret = TRUE;

	// ێ擾
	get = ImcSaveData_GetAcceFlag( p_iow, acce_no );
	
	// 9Ă邩1Ă邩`FbN
	if( imcsavedata_AcceNo_9Check( acce_no ) ){
		// 9
		get += num;
		if( get > 9 ){
			ret = FALSE;
		}
	}else{
		// 1
		get += num;
		if( get > 1 ){
			ret = FALSE;
		}
	}
	return ret;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێĂ邩`FbN
 *
 *	@param	p_iow		Z[uf[^[N
 *	@param	acce_no		ANZTio[ 
 *
 *	@retval	TRUE	ێ
 *	@retval	FALSE	ĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckAcceGet( const IMC_ITEM_SAVEDATA* p_iow, u32 acce_no )
{
	u32 get;

	// ێ擾
	get = ImcSaveData_GetAcceFlag( p_iow, acce_no );

	if( get > 0 ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGwiێĂ邩`FbN
 *
 *	@param	p_iow		Z[uf[^[N
 *	@param	bg_no		BGio[
 *	
 *	@retval	TRUE	ێ
 *	@retval	FALSE	ĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckBgGet( const IMC_ITEM_SAVEDATA* p_iow, u32 bg_no )
{
	u32 get;

	// ێԎ擾
	get = ImcSaveData_GetBGFlag( p_iow, bg_no );

	if( get != IMC_BG_RIGHT_MAX ){
		return TRUE;
	}
	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	ANZTtOĂ邩`FbN
 *
 *	@param	cp_iow		ACeZ[u[N
 *	@param	acce_no		ANZTio[
 *
 *	@return	ێ
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetAcceFlag( const IMC_ITEM_SAVEDATA* cp_iow, u32 acce_no )
{
	u32 num;
	
	// ANZT
	GF_ASSERT( acce_no < IMC_ACCE_MAX );

	// 9Ă邩1Ă邩`FbN
	if( imcsavedata_AcceNo_9Check( acce_no ) ){
		// 9
		num = imcsavedata_Acce9Get( cp_iow->acce_9, acce_no );
	}else{
		// 1
		acce_no = imcsavedata_AcceNo_1Get( acce_no );	// ANZTNo1ێANZT̐ɕύX
		num = imcsavedata_1bitArry_get( cp_iow->acce_1, acce_no );
	}

	return num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGێtO擾
 *
 *	@param	cp_iow	ACeZ[uf[^
 *	@param	bg_no	BGio[
 *	
 *	@return	ێ
 *	@retval	IMC_BG_RIGHT_MAX̂Ƃ͂܂ێĂȂ
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetBGFlag( const IMC_ITEM_SAVEDATA* cp_iow, u32 bg_no )
{
	BOOL get;
	
	// wi
	GF_ASSERT( bg_no < IMC_BG_RIGHT_MAX );
	get = imcsavedata_BGArry_get( cp_iow->bg, bg_no );

	return get;
}


//----------------------------------------------------------------------------
/**
 *	@brief	ANZT@wi@SẴACeێԂ
 *
 *	@param	cp_iow	ACeZ[uf[^
 *
 *	@return	ێ
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetAcceBGAllNum( const IMC_ITEM_SAVEDATA* cp_iow )
{
	u32 count;

	count = ImcSaveData_GetAcceAllNum( cp_iow );
	count += ImcSaveData_GetBGAllNum( cp_iow );
	return count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT@SẴACeێԂ
 *
 *	@param	cp_iow	ACeZ[uf[^
 *
 *	@return	ێ
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetAcceAllNum( const IMC_ITEM_SAVEDATA* cp_iow )
{
	int i;	
	int count;
	count = 0;
	for( i=0; i<IMC_ACCE_MAX; i++ ){
		count += ImcSaveData_GetAcceFlag( cp_iow, i );
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	wi@SẴACeێԂ
 *
 *	@param	cp_iow	ACeZ[uf[^
 *
 *	@return	ێ
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetBGAllNum( const IMC_ITEM_SAVEDATA* cp_iow )
{
	int i;
	int count = 0;
	
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){

		if( ImcSaveData_GetBGFlag( cp_iow, i ) != IMC_BG_RIGHT_MAX ){
			count ++;
		}
	}
	return count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێZbg
 *
 *	@param	p_iow		ACeZ[ü
 *	@param	acce_no		ANZTio[
 *	@param	num			ݒ萔
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetAcceFlag( IMC_ITEM_SAVEDATA* p_iow, u32 acce_no, u32 num )
{
	// ANZT
	GF_ASSERT( acce_no < IMC_ACCE_MAX );

	// 9Ă邩1Ă邩`FbN
	if( imcsavedata_AcceNo_9Check( acce_no ) ){
		// 9ȏɂȂ
		if( num > IMC_ACCE_9_GET_NUM ){
			num = IMC_ACCE_9_GET_NUM;
		}
		imcsavedata_Acce9Set( p_iow->acce_9, num, acce_no );
	}else{
		// 1ȏɂȂ
		if( num > IMC_ACCE_1_GET_NUM ){
			num = IMC_ACCE_1_GET_NUM;
		}
		acce_no = imcsavedata_AcceNo_1Get( acce_no );	// ANZTNo1ێANZT̐ɕύX
		imcsavedata_1bitArry_set( p_iow->acce_1, num, acce_no );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێ̑Z
 *
 *	@param	p_iow		ACeZ[ü
 *	@param	acce_no		ANZTio[
 *	@param	num			l
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ImcSaveData_AddAcceFlag( IMC_ITEM_SAVEDATA* p_iow, u32 acce_no, u32 num )
{
	u8 now_num;
	
	// ANZT
	GF_ASSERT( acce_no < IMC_ACCE_MAX );

	// 9Ă邩1Ă邩`FbN
	if( imcsavedata_AcceNo_9Check( acce_no ) ){
		now_num = imcsavedata_Acce9Get( p_iow->acce_9, acce_no );
		// 9ȏɂȂ
		now_num += num;
		if( now_num > IMC_ACCE_9_GET_NUM ){
			now_num = IMC_ACCE_9_GET_NUM;
		}
		imcsavedata_Acce9Set( p_iow->acce_9, now_num, acce_no );
	}else{
		now_num = imcsavedata_1bitArry_get( p_iow->acce_1, acce_no );
		// 1ȏɂȂ
		now_num += num;
		if( now_num > IMC_ACCE_1_GET_NUM ){
			now_num = IMC_ACCE_1_GET_NUM;
		}
		acce_no = imcsavedata_AcceNo_1Get( acce_no );	// ANZTNo1ێANZT̐ɕύX
		imcsavedata_1bitArry_set( p_iow->acce_1, now_num, acce_no );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێ̈Z
 *
 *	@param	p_iow		ACeZ[ü
 *	@param	acce_no		ANZTio[
 *	@param	num			l
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SubAcceFlag( IMC_ITEM_SAVEDATA* p_iow, u32 acce_no, u32 num )
{
	u8 now_num;
	
	// ANZT
	GF_ASSERT( acce_no < IMC_ACCE_MAX );

	// 9Ă邩1Ă邩`FbN
	if( imcsavedata_AcceNo_9Check( acce_no ) ){
		now_num = imcsavedata_Acce9Get( p_iow->acce_9, acce_no );
		if( now_num > num){
			now_num -= num;
		}else{
			now_num = 0;
		}
		imcsavedata_Acce9Set( p_iow->acce_9, now_num, acce_no );
	}else{
		now_num = 0;
		acce_no = imcsavedata_AcceNo_1Get( acce_no );	// ANZTNo1ێANZT̐ɕύX
		imcsavedata_1bitArry_set( p_iow->acce_1, now_num, acce_no );
	}
}

//----------------------------------------------------------------------------
/**	
 *	@brief	BGێtOݒ
 *
 *	@param	p_iow		ACeZ[ü惏[N
 *	@param	bg_no		BGio[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetBGFlag( IMC_ITEM_SAVEDATA* p_iow, u32 bg_no )
{
	u8 get_no;
	
	// wi
	GF_ASSERT( bg_no < IMC_BG_RIGHT_MAX );

	// łɕێĂȂ`FbN
	if( imcsavedata_BGArry_get( p_iow->bg, bg_no ) == IMC_BG_RIGHT_MAX ){

		// ݒ肷ێԂ擾
		get_no = imcsavedata_BGArry_FlagOnDataNumGet( p_iow->bg );

		// ݒ
		imcsavedata_BGArry_set( p_iow->bg, get_no, bg_no );
	}
	
}





//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^ɒlݒς݂`FbN
 *
 *	@param	iow	C[WNbv[N
 *
 *	@retval	TRUE	Z[uς
 *	@retval	FALSE	Z[
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckTelevisionData(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	if( iow->init_flag == IMC_SAVEDATA_DATASET_FLAG ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[utOݒ肷
 *
 *	@param	iw	C[WNbv[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetComplateFlagTelevisionData(IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	iow->init_flag = IMC_SAVEDATA_DATASET_FLAG;
	iow->country = CasetteLanguage;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^
 *
 *	@param	iw		C[WNbv[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_ClaenTelevisionData(IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	// [N̏
	clean_television_savedata( iow );
}
	
//----------------------------------------------------------------------------
/**
 *	@brief	|Pf[^o^
 *
 *	@param	iow		C[WNbv[N
 *	@param	pp		|Pp[^
 *	@param	ip		C[WNbv|Pf[^
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetTelevisionPokeData(IMC_TELEVISION_SAVEDATA* iow, POKEMON_PARAM* pp, IMC_POKE* ip)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	// |Pf[^i[
	ImcSaveData_SetPokeData_Local( &iow->pokemon, pp, ip );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTf[^ݒ
 *
 *	@param	iow		C[WNbv[N	
 *	@param	ao		ANZT[f[^
 *	@param	no		ANZT[io[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetTelevisionAcceData(IMC_TELEVISION_SAVEDATA* iow, const IMC_ACCESSORIE_OBJ* ao, int no)
{
	NNSG2dSVec2 mat = SWSP_GetSpritePos( ao->drawObj );
	int pri = SWSP_GetSpritePriority( ao->drawObj );
	
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<ző吔`FbN
	GF_ASSERT( mat.x < 256 );		// u8ɓ悤
	GF_ASSERT( mat.y < 256 );		// u8ɓ悤
	GF_ASSERT( pri > -128 );		// u8ɓ悤
	GF_ASSERT( !(iow->accessory_set_msk & (1 << no)) );	///<do^`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	
	//@f[^ݒ
	imcsavedata_SetAcce_Local( &iow->acce[ no ],
			ao->accessorie_no,
			mat.x,
			mat.y,
			pri);

	// }XNݒ
	iow->accessory_set_msk |= 1 << no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGID̐ݒ
 *
 *	@param	iow		C[WNbv[N
 *	@param	bg		BGID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetTelevisionBgId(IMC_TELEVISION_SAVEDATA* iow, u8 bg)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	iow->bg_id = bg;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Nbṽ^Cgi[
 *
 *	@param	iow		C[WNbv[N
 *	@param	str		^CgP
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetTelevisionTitle( IMC_TELEVISION_SAVEDATA* iow, const PMS_DATA* str )
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	PMSDAT_Copy( &iow->title, str );
}

//----------------------------------------------------------------------------
/**
 *	@brief	^CgPݒ
 *
 *	@param	iow		[N
 *	@param	word	ȈՒPID
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetTelevisionTitlePmsWord( IMC_TELEVISION_SAVEDATA* iow, PMS_WORD word )
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	PMSDAT_Clear( &iow->title );
	PMSDAT_SetWord( &iow->title, 0, word );
}

//----------------------------------------------------------------------------
/**
 *	@brief	erǃNbvf[^Rs[֐
 *
 *	@param	iow			[N
 *	@param	set_iow		ݒ肷f[^[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_CopyTelevision( IMC_TELEVISION_SAVEDATA* iow, const IMC_TELEVISION_SAVEDATA* set_iow )
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	memcpy( iow, set_iow, sizeof(IMC_TELEVISION_SAVEDATA) );
}

//----------------------------------------------------------------------------
/**
 *	@brief	g[i[f[^ݒ
 *
 *	@param	iow		[N
 *	@param	pbuff	g[i[f[^
 *	@param	sex		
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetTelevisionTrData( IMC_TELEVISION_SAVEDATA* iow, const STRBUF* pbuff, int sex )
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	ImcSaveData_SetTrData_Local( &iow->pokemon, pbuff, sex );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃CfbNX̃ANZTo^Ă邩`FbN
 *
 *	@param	iow		PZ[uf[^
 *	@param	no		ANZTi[zCfbNX
 *
 *	@retval	TRUE	o^ς
 *	@retval	FALSE	o^
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckTelevisionAcceDataSet(const IMC_TELEVISION_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<ző吔`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	return iow->accessory_set_msk & (1 << no);
}


//----------------------------------------------------------------------------
/**
 *	@brief	erǗp[N|PZ[uf[^擾
 *
 *	@param	iow		[N
 *
 *	@return	|PZ[uf[^
 */
//-----------------------------------------------------------------------------
const IMC_SAVEDATA_POKEMON* ImcSaveData_GetTelevisionPokemon(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return &iow->pokemon;
}

//----------------------------------------------------------------------------
/**
 *	@brief	erǃ[NANZTZ[uf[^擾
 *
 *	@param	iow		[N
 *	@param	no		ANZTio[
 *
 *	@return	ANZTZ[uf[^
 */
//-----------------------------------------------------------------------------
const IMC_SAVEDATA_ACCESSORIE* ImcSaveData_GetTelevisionAcce(const IMC_TELEVISION_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return &iow->acce[no];
}

//----------------------------------------------------------------------------
/**
 *	@brief	X^[io[擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	X^[io[
 */
//-----------------------------------------------------------------------------
u16 ImcSaveData_GetTelevisionPokeMonsNo(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeMonsNo(&iow->pokemon);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PjbNl[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	i[obt@@vf@IMC_SAVEDATA_STRBUF_NUMKv
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetTelevisionPokeNickName(const IMC_TELEVISION_SAVEDATA* iow, STRBUF* pbuff)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	ImcSaveData_GetUtilPokeNickName(&iow->pokemon, pbuff);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̐el[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	i[obt@@vf@IMC_SAVEDATA_STRBUF_NUMKv
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetTelevisionPokeOyaName(const IMC_TELEVISION_SAVEDATA* iow, STRBUF* pbuff)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	ImcSaveData_GetUtilPokeOyaName(&iow->pokemon, pbuff);
}

//----------------------------------------------------------------------------
/**
 *	@brief	eʎ擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	e
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetTelevisionPokeOyaSex(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeOyaSex(&iow->pokemon);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetTelevisionPokeRnd(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeRnd( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PIDio[擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	IDNo
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetTelevisionPokeIDNo(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeIDNo( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P`io[̎擾
 *
 *	@param	iow
 *
 *	@return	`io[
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetTelevisionPokeFormID(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeFormID( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbND揇ʎ擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetTelevisionPokePri(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokePri(&iow->pokemon);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbN\W擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	XW
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetTelevisionPokeX(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeX( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNW擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetTelevisionPokeY(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilPokeY( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pp[^擾
 *
 *	@param	iow		C[WNbvZ[uf[^
 *	@param	pp		|Pp[^
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetTelevisionPokePara(const IMC_TELEVISION_SAVEDATA* iow, POKEMON_PARAM* pp)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	imcsacedata_GetPokePara_Local( &iow->pokemon, pp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTio[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *	
 *	@return	ANZTio[
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetTelevisionAcceNo(const IMC_TELEVISION_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilAcceNo( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTXW擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *	
 *	@return	ANZT\W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetTelevisionAcceMatX(const IMC_TELEVISION_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return ImcSaveData_GetUtilAcceMatX( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTW擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	ANZT\W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetTelevisionAcceMatY(const IMC_TELEVISION_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	return ImcSaveData_GetUtilAcceMatY( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT\D揇ʎ擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	ANZT\D揇
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetTelevisionAccePri(const IMC_TELEVISION_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_TELEVISION_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	return ImcSaveData_GetUtilAccePri( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGID擾
 *	
 *	@param	iow		C[WNbv[N
 *
 *	@return	BGID
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetTelevisionBgId(const IMC_TELEVISION_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	return iow->bg_id;
}

//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbv^Cg擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	i[obt@
 *
 *	@return	none	
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetTelevisionTitle( const IMC_TELEVISION_SAVEDATA* iow, PMS_DATA* pbuff )
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );
	PMSDAT_Copy(pbuff, &iow->title);
}

//----------------------------------------------------------------------------
/**
 *	@brief	er^Cg@ȈՉbP
 *
 *	@param	iow		Z[u[N
 *
 *	@return	PID
 */
//-----------------------------------------------------------------------------
PMS_WORD ImcSaveData_GetTelevisionTitlePmsWord( const IMC_TELEVISION_SAVEDATA* iow )
{
	PMS_WORD work = PMSDAT_GetWordNumber( &iow->title, 0 );
	return work;
}

//----------------------------------------------------------------------------
/**
 *	@brief	R[h擾
 *
 *	@param	iow 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetCountryCode( const IMC_TELEVISION_SAVEDATA* iow )
{
	//`FbN
	GF_ASSERT( correct_television_savedata( iow ) );

	return iow->country;
}
	

//-----------------------------------------------------------------------------
//	IMC_CONTEST_SAVEDATA֐
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	[NɃReXgZ[uf[^i[Ă邩`FbN
 *
 *	@param	iow		C[WNbv[N
 *
 *	@retval	TRUE	Z[uς
 *	@retval	FALSE	Z[
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckContestData(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	if( iow->init_flag == IMC_SAVEDATA_DATASET_FLAG ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[utOݒ
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetComplateFlagContestData(IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	iow->init_flag = IMC_SAVEDATA_DATASET_FLAG;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_ClaenContestData(IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	// [N̏
	clean_contest_savedata( iow );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp[N|Pf[^̐ݒ
 *
 *	@param	iow		C[WNbv[N
 *	@param	pp		|Pp[^
 *	@param	ip		C[WNbv|P[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestPokeData(IMC_CONTEST_SAVEDATA* iow, POKEMON_PARAM* pp, IMC_POKE* ip)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	// |Pf[^i[
	ImcSaveData_SetPokeData_Local( &iow->pokemon, pp, ip );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpANZTf[^̐ݒ
 *
 *	@param	iow		C[WNbv[N
 *	@param	ao		ANZTf[^
 *	@param	no		i[[NCfbNX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestAcceData(IMC_CONTEST_SAVEDATA* iow, const IMC_ACCESSORIE_OBJ* ao, int no)
{
	NNSG2dSVec2 mat = SWSP_GetSpritePos( ao->drawObj );
	int pri = SWSP_GetSpritePriority( ao->drawObj );
	
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<ző吔`FbN
	GF_ASSERT( mat.x < 256 );		// u8ɓ悤
	GF_ASSERT( mat.y < 256 );		// u8ɓ悤
	GF_ASSERT( pri > -128 );		// u8ɓ悤
	GF_ASSERT( !(iow->accessory_set_msk & (1 << no)) );	///<do^`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	
	//@f[^ݒ
	imcsavedata_SetAcce_Local( &iow->acce[ no ],
			ao->accessorie_no,
			mat.x,
			mat.y,
			pri);

	// }XNݒ
	iow->accessory_set_msk |= 1 << no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpBGIDݒ
 *
 *	@param	iow		C[WNbv[N
 *	@param	bg		BGID
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestBgId(IMC_CONTEST_SAVEDATA* iow, u8 bg)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	iow->bg_id = bg;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp[N@ReXgNi[
 *
 *	@param	iow			C[WNbv[N
 *	@param	rank_code	NR[h
 *	
 *	@return	none
 *	
 *	rank_code
		///ReXgNFm[}N
		CONRANK_NORMAL		(0)
		///ReXgNFX[p[N
		CONRANK_SUPER		(1)
		///ReXgNFnCp[N
		CONRANK_HYPER		(2)
		///ReXgNF}X^[N
		CONRANK_MASTER		(3)
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestRank(IMC_CONTEST_SAVEDATA* iow, u32 rank_code)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	iow->rank_code = rank_code;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXg[Ñf[^Rs[ݒ
 *
 *	@param	iow			[N
 *	@param	set_iow		ݒ胏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_CopyContest( IMC_CONTEST_SAVEDATA* iow, const IMC_CONTEST_SAVEDATA* set_iow )
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	memcpy( iow, set_iow, sizeof(IMC_CONTEST_SAVEDATA) );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pf[^ݒ
 *
 *	@param	iow		Z[uf[^
 *	@param	pp		|Pp[^
 *	@param	pri		D揇
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestPokeData_Easy( IMC_CONTEST_SAVEDATA* iow, POKEMON_PARAM* pp, s8 pri )
{
	u8 x;
	u8 y;

	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	// |Pp[^|PTCY擾
	ImcSaveData_ImcPokeObjContestMatGet( pp, &x, &y );

	// |Pf[^i[
	ImcSaveData_SetPokeData_Local_Core( &iow->pokemon, pp, x, y, pri );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTf[^ݒ
 *
 *	@param	iow			Z[u[N
 *	@param	acce_idx	ANZTzCfbNX
 *	@param	acce_no		ANZTio[
 *	@param	x			W
 *	@param	y			W
 *	@param	pri			D揇
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestAcceData_Easy( IMC_CONTEST_SAVEDATA* iow, u32 acce_idx, u8 acce_no, u8 x, u8 y, s8 pri )
{
	GF_ASSERT( acce_idx < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<ző吔`FbN
	GF_ASSERT( acce_no < IMC_ACCE_MAX );		///<ANZTő吔`FbN
	GF_ASSERT( x < 256 );		// u8ɓ悤
	GF_ASSERT( y < 256 );		// u8ɓ悤
	GF_ASSERT( pri > -128 );		// u8ɓ悤
	GF_ASSERT( !(iow->accessory_set_msk & (1 << acce_idx)) );	///<do^`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	// ANZT̗D揇ʂAIɃ|P
	if( iow->pokemon.poke_pri >= pri ){
		pri = iow->pokemon.poke_pri + 1;
	}
	
	//@f[^ݒ
	imcsavedata_SetAcce_Local( &iow->acce[ acce_idx ],
			acce_no,
			x,
			y,
			pri);

	// }XNݒ
	iow->accessory_set_msk |= 1 << acce_idx;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃CfbNX̃ANZTo^Ă邩`FbN
 *
 *	@param	iow		PZ[uf[^
 *	@param	no		ANZTi[zCfbNX
 *
 *	@retval	TRUE	o^ς
 *	@retval	FALSE	o^
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckContestAcceDataSet(const IMC_CONTEST_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<ző吔`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	if( (iow->accessory_set_msk & (1 << no)) != 0 ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXg@g[i[f[^
 *	
 *	@param	iow		[N
 *	@param	pbuff	g[i[
 *	@param	sex		
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetContestTrData( IMC_CONTEST_SAVEDATA* iow, const STRBUF* pbuff, int sex )
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	ImcSaveData_SetTrData_Local( &iow->pokemon, pbuff, sex );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp[N|PZ[uf[^擾
 *
 *	@param	iow		[N
 *
 *	@return	|PZ[uf[^
 */
//-----------------------------------------------------------------------------
const IMC_SAVEDATA_POKEMON* ImcSaveData_GetContestPokemon(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return &iow->pokemon;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXg[NANZTZ[uf[^擾
 *
 *	@param	iow		[N
 *	@param	no		[Nio[
 *
 *	@return	ANZTZ[uf[^
 */
//-----------------------------------------------------------------------------
const IMC_SAVEDATA_ACCESSORIE* ImcSaveData_GetContestAcce(const IMC_CONTEST_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	return &iow->acce[ no ];
}


//----------------------------------------------------------------------------
/**
 *	@brief	|Pio[
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	|Pio[
 */
//-----------------------------------------------------------------------------
u16 ImcSaveData_GetContestPokeMonsNo(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeMonsNo(&iow->pokemon);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PjbNl[
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	i[obt@@vf@IMC_SAVEDATA_STRBUF_NUMKv
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetContestPokeNickName(const IMC_CONTEST_SAVEDATA* iow, STRBUF* pbuff)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	ImcSaveData_GetUtilPokeNickName(&iow->pokemon, pbuff);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp|PeO擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	Oi[̈
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetContestPokeOyaName(const IMC_CONTEST_SAVEDATA* iow, STRBUF* pbuff)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	ImcSaveData_GetUtilPokeOyaName(&iow->pokemon, pbuff);
}

//----------------------------------------------------------------------------
/**
 *	@brief	eʎ擾
 *
 *	@param	iow	[N
 *
 *	@return	e
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetContestPokeOyaSex(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeOyaSex(&iow->pokemon);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@|Pő̗擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	ő̗
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetContestPokeRnd(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeRnd( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@|PIDNo擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	|PIDNo
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetContestPokeIDNo(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeIDNo( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@`io[擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	`io[
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetContestPokeFormID(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeFormID( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@|P\D揇	擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	\D揇
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetContestPokePri(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokePri(&iow->pokemon);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@|PW	擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetContestPokeX(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeX( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@|PW	擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetContestPokeY(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return ImcSaveData_GetUtilPokeY( &iow->pokemon );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pp[^쐬
 *
 *	@param	iow		C[WNbv[N
 *	@param	pp		|Pp[^i[
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetContestPokePara(const IMC_CONTEST_SAVEDATA* iow, POKEMON_PARAM* pp)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	imcsacedata_GetPokePara_Local( &iow->pokemon, pp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp	ANZTio[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	ANZTio[
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetContestAcceNo(const IMC_CONTEST_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	return ImcSaveData_GetUtilAcceNo( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@ANZTW擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetContestAcceMatX(const IMC_CONTEST_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	return ImcSaveData_GetUtilAcceMatX( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpANZTW擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZT[CfbNX
 *
 *	@return	ANZTW
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetContestAcceMatY(const IMC_CONTEST_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	return ImcSaveData_GetUtilAcceMatY( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@ANZT\D揇	擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	\D揇
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetContestAccePri(const IMC_CONTEST_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_CONTEST_ACCE_NUM );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );

	return ImcSaveData_GetUtilAccePri( &iow->acce[no] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@BGID擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	BGID
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetContestBgId(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return iow->bg_id;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgNR[h擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	NR[h
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetContestRank(const IMC_CONTEST_SAVEDATA* iow)
{
	//`FbN
	GF_ASSERT( correct_contest_savedata( iow ) );
	return iow->rank_code;
}



//-------------------------------------
//	|Pf[^擾
//=====================================
//----------------------------------------------------------------------------
/**
 *	@brief	|PX^[io[擾
 *
 *	@param* iow		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
u16 ImcSaveData_GetUtilPokeMonsNo(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->monsno;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PjbNl[擾
 *
 *	@param	iow		[N
 *	@param	pbuff	i[obt@@vf@IMC_SAVEDATA_STRBUF_NUMKv
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetUtilPokeNickName(const IMC_SAVEDATA_POKEMON* iow, STRBUF* pbuff)
{
	STRBUF_SetStringCode(pbuff, iow->nickname);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PeO擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	Oi[̈
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetUtilPokeOyaName(const IMC_SAVEDATA_POKEMON* iow, STRBUF* pbuff)
{
	STRBUF_SetStringCode(pbuff, iow->oyaname);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pő̗擾
 *
 *	@param	iow		[N
 *
 *	@return	ő̗
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetUtilPokeRnd(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->personal_rnd;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PIDNo擾
 *
 *	@param	iow		[N	
 *
 *	@return	|PIDNo
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetUtilPokeIDNo(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->idno;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`io[擾
 *
 *	@param	iow		[N
 *
 *	@return	`io[
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetUtilPokeFormID(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->form_id;
}

//----------------------------------------------------------------------------
/**
 *	@brief	eʎ擾
 *
 *	@param	iow		[N
 *
 *	@return	e
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetUtilPokeOyaSex(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->oya_sex;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P\D揇	擾
 *
 *	@param	iow		[N
 *
 *	@return	\D揇
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetUtilPokePri(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->poke_pri;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PW	擾
 *
 *	@param	iow		[N
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetUtilPokeX(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->poke_x;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PW	擾
 *
 *	@param	iow		[N
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetUtilPokeY(const IMC_SAVEDATA_POKEMON* iow)
{
	return iow->poke_y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pp[^쐬
 *
 *	@param	iow		C[WNbv[N
 *	@param	pp		|Pp[^i[
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetUtilPokePara(const IMC_SAVEDATA_POKEMON* iow, POKEMON_PARAM* pp)
{
	imcsacedata_GetPokePara_Local( iow, pp );
}


//-------------------------------------
//	ANZTf[^擾
//=====================================
//----------------------------------------------------------------------------
/**
 *	@brief	ANZTio[擾
 *
 *	@param	iow		[N
 *
 *	@return	ANZTio[
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetUtilAcceNo(const IMC_SAVEDATA_ACCESSORIE* iow)
{
	return iow->accessory_no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTXW擾
 *
 *	@param	iow		[N
 *	
 *	@return	ANZT\W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetUtilAcceMatX(const IMC_SAVEDATA_ACCESSORIE* iow)
{
	return iow->accessory_x;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTW擾
 *
 *	@param	iow		[N
 *
 *	@return	ANZT\W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetUtilAcceMatY(const IMC_SAVEDATA_ACCESSORIE* iow)
{
	return iow->accessory_y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT\D揇ʎ擾
 *
 *	@param	iow		[N
 *
 *	@return	ANZT\D揇
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetUtilAccePri(const IMC_SAVEDATA_ACCESSORIE* iow)
{
	return iow->accessory_pri;
}

//-------------------------------------
//	R[h
//=====================================
// Z[u邩`FbN֐
static BOOL imcSaveData_RecordMixSaveCheck( IMC_SAVEDATA* iw, const IMC_TELEVISION_SAVEDATA* cp_src )
{
	int i;
	const void* cp_checkdata;
	u32 hash_0, hash_1;
	MATHCRC32Table hash_tbl;
	BOOL ret_val = TRUE;
	
	// Z[uf[^i[Ă郏[N`FbN
	if( ImcSaveData_CheckTelevisionData( cp_src ) == TRUE ){

		MATH_CRC32InitTable( &hash_tbl );
		hash_0 = MATH_CalcCRC32( &hash_tbl, cp_src, sizeof(IMC_TELEVISION_SAVEDATA) );

		// ێĂ郏[N̒ɓf[^Ȃ`FbN
		for( i=0; i<IMC_SAVEDATA_TELEVISION_SAVENUM; i++ ){
			cp_checkdata = ImcSaveData_GetTelevisionSaveData( iw, i );
			MATH_CRC32InitTable( &hash_tbl );
			hash_1 = MATH_CalcCRC32( &hash_tbl, cp_checkdata, sizeof(IMC_TELEVISION_SAVEDATA) );

			// nbVlvƂA
			// f[^XVȂ
			if( hash_1 == hash_0 ){
				ret_val = FALSE;
				break;
			}
		}
	}else{
		ret_val = FALSE;
	}
	return ret_val;
}


//----------------------------------------------------------------------------
/**
 *	@brief	R[h
 *
 *	@param	datanum		R[hf[^ő吔
 *	@param	myid		ID
 *	@param	iw			Z[uf[^
 *	@param	cpp_arry	f[^z
 */
//-----------------------------------------------------------------------------
void ImcSaveData_RecordMix( u8 datanum, int myid, IMC_SAVEDATA* iw, const void** cpp_arry )
{
	int data_num;	// f[^
	IMC_TELEVISION_SAVEDATA* p_dest;
	const IMC_TELEVISION_SAVEDATA* cp_src;
	int i;
	int count;
	
	// f[^`FbN
	data_num = 0;
	for( i=0; i<datanum; i++ ){

		// ̓pX
		if( i==myid ){
			continue;
		}
		
		if( cpp_arry[ i ] != NULL ){
			cp_src = cpp_arry[ i ];
			// f[^L
			if( imcSaveData_RecordMixSaveCheck( iw, cp_src ) == TRUE ){
				data_num ++;
			}
		}
	}

	// oŊi[Ă
	// f[^data_numÂ炷	
	for( i=IMC_SAVEDATA_TELEVISION_SAVENUM - 1; i>=IMC_SAVEDATA_TELEVISION_OTHER_S; i-- ){
		
		// ړ̃obt@ȂRs[
		if( i+data_num < IMC_SAVEDATA_TELEVISION_SAVENUM ){
			p_dest = ImcSaveData_GetTelevisionSaveData( iw, i+data_num );
			cp_src = ImcSaveData_GetTelevisionSaveData( iw, i );
			ImcSaveData_CopyTelevision( p_dest, cp_src );
		}
	}

	// IMC_SAVEDATA_TELEVISION_OTHER_S̃Z[uf[^
	// Ƀf[^ݒ肵Ă
	count = IMC_SAVEDATA_TELEVISION_OTHER_S;	// Z[uobt@
	for( i=0; i<datanum; i++ ){

		// ̓pX
		if( i==myid ){
			continue;
		}
		
		if( cpp_arry[ i ] != NULL ){
			cp_src = cpp_arry[ i ];
			// f[^L
			if( imcSaveData_RecordMixSaveCheck( iw, cp_src ) == TRUE ){
				p_dest = ImcSaveData_GetTelevisionSaveData( iw, count );
				count ++;
				ImcSaveData_CopyTelevision( p_dest, cp_src );
			}
		}
	}
}



//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	C[WNbv[Nւ̃|C^
 */
//----------------------------------------------------------
IMC_SAVEDATA * SaveData_GetImcSaveData(SAVEDATA * sv)
{
	IMC_SAVEDATA * is = NULL;
	is = SaveData_Get(sv, GMDATA_ID_IMAGECLIPDATA);
	return is;
}

//----------------------------------------------------------
//	fobOp
//----------------------------------------------------------
#ifdef PM_DEBUG
void Debug_ImcSaveData_Make(IMC_SAVEDATA * iw, int option)
{
	int i;
	IMC_ITEM_SAVEDATA* p_item;

	p_item = ImcSaveData_GetItemSaveData( iw );
	
	// ACef[^SĒǉ
	for( i=0; i<IMC_ACCE_MAX; i++ ){

		if( i < IMC_ACCE_GET_1_START ){
			ImcSaveData_SetAcceFlag( p_item, i, IMC_ACCE_9_GET_NUM );
		}else{
			ImcSaveData_SetAcceFlag( p_item, i, IMC_ACCE_1_GET_NUM );
		}
	}
	// BG
/*	for( i=IMC_BG_RIGHT_MAX; i>0; i-- ){
		ImcSaveData_SetBGFlag( p_item, i - 1 );
	}//*/
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		ImcSaveData_SetBGFlag( p_item, i );
	}
}

void Debug_ImcSaveData_SetItemData(IMC_ITEM_SAVEDATA* iow)
{
	int i;

	// ACef[^SĒǉ
	for( i=0; i<IMC_ACCE_MAX; i++ ){

		if( i < IMC_ACCE_GET_1_START ){
			ImcSaveData_SetAcceFlag( iow, i, IMC_ACCE_9_GET_NUM );
		}else{
			ImcSaveData_SetAcceFlag( iow, i, IMC_ACCE_1_GET_NUM );
		}
	}
	// BG
/*	for( i=IMC_BG_RIGHT_MAX; i>0; i-- ){
		ImcSaveData_SetBGFlag( iow, i - 1 );
	}//*/
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		ImcSaveData_SetBGFlag( iow, i );
	}
}

static void debug_PokeDataSet( IMC_SAVEDATA_POKEMON* p_poke, POKEMON_PARAM* p_pp )
{
	p_poke->monsno = PokeParaGet(p_pp, ID_PARA_monsno, NULL);
	PokeParaGet(p_pp, ID_PARA_nickname, p_poke->nickname);
	PokeParaGet(p_pp, ID_PARA_oyaname, p_poke->oyaname);
	p_poke->personal_rnd = PokeParaGet(p_pp, ID_PARA_personal_rnd, NULL );
	p_poke->idno = PokeParaGet(p_pp, ID_PARA_id_no, NULL);
	p_poke->form_id = PokeParaGet(p_pp, ID_PARA_form_no, NULL);
	p_poke->oya_sex = PokeParaGet(p_pp, ID_PARA_oyasex, NULL);
	p_poke->poke_x		= IMC_RBOX_END_SX + (IMC_RBOX_AREA_WIDTH/2);
	p_poke->poke_y		= IMC_RBOX_END_SY + (IMC_RBOX_AREA_HEIGHT/2);
	p_poke->poke_pri	= 5;
}
static void debug_AcceDataSet( IMC_SAVEDATA_ACCESSORIE* p_acce, u32 rnd )
{
	int acce_no;
	int x, y;
	int pri;

	// o邾|P̍Wɂ킹
	acce_no = (rnd * 555) % IMC_ACCE_MAX;
	x = (IMC_RBOX_END_SX + (IMC_RBOX_AREA_WIDTH/2) - 40) + ((rnd * 9) % 80);
	y = (IMC_RBOX_END_SY + (IMC_RBOX_AREA_HEIGHT/2) - 40) + ((rnd * 2) % 80);
	pri = (rnd * 15) % 20;
	imcsavedata_SetAcce_Local( p_acce, acce_no, x, y, pri );
}

void Debug_ImcSaveData_MakeTelevisionDummyData(IMC_TELEVISION_SAVEDATA* iow, POKEMON_PARAM* p_pp, u32 acce_num )
{
	int i;
	
	// 
	ImcSaveData_ClaenTelevisionData( iow );

	// |Po^
	debug_PokeDataSet( &iow->pokemon, p_pp );

	// ANZTf[^ݒ
	for( i=0; i<acce_num; i++ ){
		debug_AcceDataSet( &iow->acce[i], iow->pokemon.personal_rnd * (i+1) );
		iow->accessory_set_msk |= 1 << i;
	}
	iow->bg_id = 0;

	// Z[u
	ImcSaveData_SetComplateFlagTelevisionData( iow );
}

void Debug_ImcSaveData_MakeContestDummyData(IMC_CONTEST_SAVEDATA* iow, POKEMON_PARAM* p_pp, u32 acce_num, u32 rank_code )
{
	int i;
	
	// 
	ImcSaveData_ClaenContestData( iow );

	// |Po^
	debug_PokeDataSet( &iow->pokemon, p_pp );

	// ANZTf[^ݒ
	for( i=0; i<acce_num; i++ ){
		debug_AcceDataSet( &iow->acce[i], iow->pokemon.personal_rnd * (i+1) );
		iow->accessory_set_msk |= 1 << i;
	}

	iow->rank_code = rank_code;
	iow->bg_id = 0;

	// Z[u
	ImcSaveData_SetComplateFlagContestData( iow );
}


#endif

