/**
 *	@file	mail.c
 *	@brief	[Z[uf[^@
 *	@author	Miyuki Iwasawa
 *	@date	06.02.09
 *
 *	[Z[uf[^f菇
 *	1,MAIL_SearchNullID()ŋ󂫗̈Af[^ID擾
 *	2,MailData_CreateWork()Ń_~[f[^쐬p[NGA擾
 *	3,MailData_CreateDataFromSave()Ȃǂgă[NɃf[^\z
 *	4,MAIL_AddDataFromWork()Ǝ擾ς݂̃f[^ID,[Ñf[^gāA
 *	@Z[üɃf[^𔽉f
 *	5,_~[[NGAJ
 */

#include "common.h"
#include "savedata/savedata.h"
#include "savedata/mail.h"
#include "savedata/mail_local.h"
#include "savedata/mystatus.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/pokeicon.h"
#include "system/pms_data.h"
#include "system/buflen.h"
#include "system/pm_str.h"

/**
 *	@brief	[f[^TCY擾
 *
 *	[f[^ʂ̃TCY
 */
int MailData_GetDataWorkSize(void)
{
	return sizeof(MAIL_DATA);
}
/**
 *	@brief	[f[^NA(f[^Zbg)
 */
void MailData_Clear(MAIL_DATA* dat)
{
	int i;
	
	dat->writerID = 0;
	dat->sex = PM_MALE;
	dat->region = CasetteLanguage;
	dat->version = CasetteVersion;
	dat->design = MAIL_DESIGN_NULL;

	PM_strclearEOM_(dat->name,BUFLEN_PERSON_NAME);

	for(i = 0;i < MAILDAT_ICONMAX;i++){
		dat->icon[i].dat = MAIL_ICON_NULL;
	}
	for(i = 0;i < MAILDAT_MSGMAX;i++){
		PMSDAT_Clear(&dat->msg[i]);
	}
}

/**
 *	@brief	[f[^LǂԂ
 *	@retval	FALSE	
 *	@retval	TRUE	L
 */
BOOL MailData_IsEnable(MAIL_DATA* dat)
{
	if(	dat->design >= MAIL_DESIGN_START &&
		dat->design <= MAIL_DESIGN_END){
		return TRUE;
	}
	return FALSE;
}

/**
 *	@brief	[f[^̃[N擾ĕԂ
 *
 *	ĂяoӔCĉ邱
 *	
 */
MAIL_DATA* MailData_CreateWork(int heapID)
{
	MAIL_DATA* p;

	p = sys_AllocMemoryLo(heapID,sizeof(MAIL_DATA));
	MailData_Clear(p);

	return p;
}

/**
 *	@brief	[f[^̍\̃Rs[
 */
void MailData_Copy(MAIL_DATA* src,MAIL_DATA* dest)
{
	MI_CpuCopy8(src,dest,sizeof(MAIL_DATA));
}

/**
 *	@brief	fUCNo,|P̃|WVAZ[uf[^w肵ă[VK쐬Ԃɏ
 *	@param	dat	f[^쐬MAIL_DATA\̌^ւ̃|C^
 *	@param	design_no	[̃C[WNo
 *	@param	pos		[|P̎莝̃|WV
 *	@param	save	Z[uf[^ւ̃|C^
 */
void MailData_CreateFromSaveData(MAIL_DATA* dat,u8 design_no,u8 pos,SAVEDATA* save)
{
	u8	i,ct,pal;
	u16	monsno;
	u32 icon,egg,form;
	MYSTATUS	*my;
	POKEPARTY	*party;
	POKEMON_PARAM* pp;
	
	MailData_Clear(dat);
	dat->design = design_no;

	//Z[uf[^
	party = SaveData_GetTemotiPokemon(save);
	my = SaveData_GetMyStatus(save);

	//@̖O
	PM_strcpy(dat->name,MyStatus_GetMyName(my));
	//
	dat->sex = (u8)MyStatus_GetMySex(my);
	//g[i[ID
	dat->writerID = MyStatus_GetID(my);

	//|PACR擾
	for(i=pos,ct = 0;i < PokeParty_GetPokeCount(party);i++){
		pp = PokeParty_GetMemberPointer(party,i);
		monsno = PokeParaGet(pp,ID_PARA_monsno,NULL);
		egg = PokeParaGet(pp,ID_PARA_tamago_flag,NULL);
		form = PokeParaGet(pp,ID_PARA_form_no,NULL);
		icon = PokeIconCgxArcIndexGetByPP(pp);
//		pal = PokeIconPaletteNumberGet(monsno,egg);
		pal = PokeIconPalNumGet(monsno,form,egg);
		
		dat->icon[ct].cgxID = (u16)icon;
		dat->icon[ct++].palID = pal;
		if(ct >= MAILDAT_ICONMAX){
			break;
		}
	}
}

/**
 *	@brief	[f[^@g[i[ID擾
 */
u32	MailData_GetWriterID(const MAIL_DATA* dat)
{
	return dat->writerID;
}
/**
 *	@brief	[f[^@g[i[IDKp
 */
void MailData_SetWriterID(MAIL_DATA* dat,u32 id)
{
	dat->writerID = id;
}

/**
 *	@brief	[f[^@C^[擾
 */
STRCODE* MailData_GetWriterName(MAIL_DATA* dat)
{
	return &(dat->name[0]);
}
/**
 *	@brief	[f[^@C^[Kp
 */
void MailData_SetWriterName(MAIL_DATA* dat,STRCODE* name)
{
	PM_strcpy(dat->name,name);
}

/**
 *	@brief	[f[^@C^[̐ʂ擾
 */
u8	MailData_GetWriterSex(const MAIL_DATA* dat)
{
	return dat->sex;
}
/**
 *	@brief	[f[^@C^[̐ʂKp
 */
void MailData_SetWriterSex(MAIL_DATA* dat,const u8 sex)
{
	dat->sex = sex;
}

/**
 *	@brief	[f[^@fUCNo擾
 */
u8	MailData_GetDesignNo(const MAIL_DATA* dat)
{
	return dat->design;
}
/**
 *	@brief	[f[^@fUCNoKp
 */
void MailData_SetDesignNo(MAIL_DATA* dat,const u8 design)
{
	if(design >= MAIL_DESIGN_MAX){
		return;
	}
	dat->design = design;
}

/**
 *	@brief	[f[^@R[h擾
 */
u8	MailData_GetCountryCode(const MAIL_DATA* dat)
{
	return dat->region;
}
/**
 *	@brief	[f[^@R[hKp
 */
void MailData_SetCountryCode(MAIL_DATA* dat,const u8 code)
{
	dat->region = code;
}

/**
 *	@brief	[f[^@JZbgo[W擾
 */
u8	MailData_GetCasetteVersion(const MAIL_DATA* dat)
{
	return dat->version;
}
/**
 *	@brief	[f[^@JZbgo[WKp
 */
void MailData_SetCasetteVersion(MAIL_DATA* dat,const u8 version)
{
	dat->version = version;
}

/**
 *	@brief	[f[^@[ACRp[^̎擾(CfbNXw)
 *
 *	@param	mode	MAIL_ICONPRM_CGX:cgxNo̎擾
 *					MAIL_ICONPRM_PAL:pltNo̎擾
 *					MAIL_ICONPRM_ALL:u16^(MAIL_ICON^փLXg)őo̒lԂ
 *
 *	ACRCgxIDƃX^[No͓ł͂܂BӁI
 */
u16	MailData_GetIconParamByIndex(const MAIL_DATA* dat,u8 index,u8 mode)
{
	if(index < MAILDAT_ICONMAX){
		switch(mode){
		case MAIL_ICONPRM_CGX:
			return dat->icon[index].cgxID;
		case MAIL_ICONPRM_PAL:
			return dat->icon[index].palID;
		case MAIL_ICONPRM_ALL:
		default:
			return dat->icon[index].dat;
		}
	}else{
		return 0;
	}
}
/**
 *	@brief	[f[^@[ACRp[^̃Zbg(CfbNXw)
 *
 *	@param	id		Zbgf[^ID
 *	@param	mode	MAIL_ICONPRM_CGX:cgxNõZbg
 *					MAIL_ICONPRM_PAL:pltNõZbg
 *					MAIL_ICONPRM_ALL:u16^(MAIL_ICON^փLXg)őo̒lԂ
 *
 *	ACRCgxIDƃX^[No͓ł͂܂BӁI
 */
void MailData_SetIconParamByIndex(MAIL_DATA* dat,u16 id,u8 index,u8 mode)
{
	if(index >= MAILDAT_ICONMAX){
		return;
	}
	switch(mode){
	case MAIL_ICONPRM_CGX:
		dat->icon[index].cgxID = id;
	case MAIL_ICONPRM_PAL:
		dat->icon[index].palID = id;
	case MAIL_ICONPRM_ALL:
	default:
		dat->icon[index].dat = id;
	}
}

/**
 *	@brief	[f[^@[ACRf[^̎擾(CfbNXw)
 *
 *	@param	index	f[^擾JnCfbNXNo(index<MAILDAT_ICONMAX)
 *	@param	pi		f[^i[ꏊւ̃|C^
 *	@param	num		f[^擾
 *	
 *	ACRNoƃX^[No͓ł͂܂BӁI
 *	CfbNXsꍇANULLACRf[^i[ĕԂ܂
 */
void MailData_GetIconArray(MAIL_DATA* dat,u8 index,MAIL_ICON* pi,u8 num)
{
	u8	i;
	
	for(i = 0;i < num;i++){
		if(i  < MAILDAT_ICONMAX){
			pi[i].dat = dat->icon[i].dat;
		}else{
			pi[i].dat = MAIL_ICON_NULL;
		}
	}
}

/**
 *	@brief	[f[^@ȈՕ擾(CfbNXw)
 */
PMS_DATA*	MailData_GetMsgByIndex(MAIL_DATA* dat,u8 index)
{
	if(index < MAILDAT_MSGMAX){
		return &(dat->msg[index]);
	}else{
		return &(dat->msg[0]);
	}
}
/**
 *	@brief	[f[^@ȈՕZbg(CfbNXw)
 */
void MailData_SetMsgByIndex(MAIL_DATA* dat,PMS_DATA* pms,u8 index)
{
	if(index >= MAILDAT_MSGMAX){
		return;
	}
	PMSDAT_Copy(&dat->msg[index],pms);
}

/**
 *	@brief	[f[^@ȈՕ擾(CfbNXw)
 *
 *	@param	dat	MAIL_DATA*
 *	@param	index	ȈՕCfbNX
 *	@param	buf		擾|C^̊i[ꏊ
 *
 *	@retval	FALSE	̎擾Ɏs(܂͊ȈՕLȃf[^ł͂Ȃ)
 *	
 *	@li	bufɑ΂ēŃmۂĂ̂ŁAĂяoIɉ邱
 *	@li	FALSEԂꍇAbufNULLNA
 */
BOOL MailData_GetMsgStrByIndex(const MAIL_DATA* dat,u8 index,STRBUF* buf,int heapID)
{
	if(index >= MAILDAT_MSGMAX){
		buf = NULL;
		return FALSE;
	}
	
	if(!PMSDAT_IsEnabled(&dat->msg[index])){
		buf = NULL;
		return FALSE;
	}

	buf = PMSDAT_ToString(&dat->msg[index],heapID);
	return TRUE;
}

//=================================================================
//
//=================================================================
//[J֐vg^Cv
static int mail_GetNullData(MAIL_DATA* array,int num);
static int mail_GetNumEnable(MAIL_DATA* array,int num);
static MAIL_DATA* mail_GetAddress(MAIL_BLOCK* bloc,MAILBLOCK_ID blockID,int dataID);

/**
 *	@brief	Z[uf[^ubNւ̃|C^擾
 */
MAIL_BLOCK* SaveData_GetMailBlock(SAVEDATA* sv)
{
	return SaveData_Get(sv,GMDATA_ID_MAILDATA);
}

/**
 *	@brief	[Z[uf[^ubNTCY擾
 *
 *	[f[^ʂ̃TCYł͂Ȃ̂ŒӁI
 */
int MAIL_GetBlockWorkSize(void)
{
	return sizeof(MAIL_DATA)*MAIL_STOCK_MAX;
}
/**
 *	@brief	[Z[uf[^ubN
 */
void MAIL_Init(MAIL_BLOCK* dat)
{
	int i = 0;

#if 0
	for(i = 0;i < MAIL_STOCK_TEMOTI;i++){
		MailData_Clear(&dat->temoti[i]);
	}
	for(i = 0;i < MAIL_STOCK_EXTRADE;i++){
		MailData_Clear(&dat->extrade[i]);
	}
	for(i = 0;i < MAIL_STOCK_SODATEYA;i++){
		MailData_Clear(&dat->sodateya[i]);
	}
#endif
	for(i = 0;i < MAIL_STOCK_PASOCOM;i++){
		MailData_Clear(&dat->paso[i]);
	}
}

/**
 *	@brief	󂢂Ă郁[f[^ID擾
 *
 *	@param	id ǉ[ubNID
 *
 *	@return	int	f[^ǉłꍇ͎QID
 *				ǉłȂꍇ̓}CiXlԂ
 */
int MAIL_SearchNullID(MAIL_BLOCK* block,MAILBLOCK_ID id)
{
	switch(id){
#if 0
	case MAILBLOCK_TEMOTI:
		return mail_GetNullData(block->temoti,MAIL_STOCK_TEMOTI);
	case MAILBLOCK_EXTRADE:
		return mail_GetNullData(block->extrade,MAIL_STOCK_EXTRADE);
	case MAILBLOCK_SODATEYA:
		return mail_GetNullData(block->sodateya,MAIL_STOCK_SODATEYA);
#endif
	case MAILBLOCK_PASOCOM:
		return mail_GetNullData(block->paso,MAIL_STOCK_PASOCOM);
	default:
		return MAILDATA_NULLID;
	}
	return MAILDATA_NULLID;
}

/**
 *	@brief	[f[^폜
 *
 *	@param	blockID	ubNID
 *	@param	dataID	f[^ID
 */
void MAIL_DelMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID)
{
	MAIL_DATA* pd = NULL;
	
	pd = mail_GetAddress(block,blockID,dataID);
	if(pd != NULL){
		MailData_Clear(pd);
	}
}

/**
 *	@brief	[f[^Z[uubNɒǉ
 *
 *	nMAIL_DATA\̌^f[^̒gZ[uf[^ɔf̂
 *	@ȃf[^Ȃ悤ɒӁI
 */
void MAIL_AddMailFormWork(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID,MAIL_DATA* src)
{
	MAIL_DATA* pd = NULL;
	
	pd = mail_GetAddress(block,blockID,dataID);
	if(pd != NULL){
		MailData_Copy(src,pd);
	}
}

/**
 *	@brief	wubNɗLf[^邩Ԃ
 */
int MAIL_GetEnableDataNum(MAIL_BLOCK* block,MAILBLOCK_ID blockID)
{
	switch(blockID){
#if 0
	case MAILBLOCK_TEMOTI:
		return mail_GetNumEnable(block->temoti,MAIL_STOCK_TEMOTI);
	case MAILBLOCK_EXTRADE:
		return mail_GetNumEnable(block->extrade,MAIL_STOCK_EXTRADE);
	case MAILBLOCK_SODATEYA:
		return mail_GetNumEnable(block->sodateya,MAIL_STOCK_SODATEYA);
#endif
	case MAILBLOCK_PASOCOM:
		return mail_GetNumEnable(block->paso,MAIL_STOCK_PASOCOM);
	default:
		return 0;
	}
	return 0;

}

/**
 *	@brief	[f[^̃Rs[擾
 *
 *	Ńmۂ̂ŁAĂяoӔCė̈J邱
 *	IDw肵ꍇAf[^Ԃ
 */
MAIL_DATA* MAIL_AllocMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID,int heapID)
{
	MAIL_DATA* src = NULL;
	MAIL_DATA* dest;
	
	src = mail_GetAddress(block,blockID,dataID);
	dest = MailData_CreateWork(heapID);
	if(src != NULL){
		MailData_Copy(src,dest);
	}
	return dest;
}

/**
 *	@brief	[f[^̃Rs[擾
 *
 *	炩ߊmۂMAIL_DATA^ɃZ[uf[^Rs[Ď擾
 */
void MAIL_GetMailData(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID,MAIL_DATA* dest)
{
	MAIL_DATA* src = NULL;
	
	src = mail_GetAddress(block,blockID,dataID);
	if(src == NULL){
		MailData_Clear(dest);
	}else{
		MailData_Copy(src,dest);
	}
}

//=================================================================
//
//=================================================================

/**
 *	@brief	莝ubN̋󂫂TĕԂ
 *
 *	@param	array	[f[^zւ̃|C^
 *	@param	num		œnz̗vf
 */
static int mail_GetNullData(MAIL_DATA* array,int num)
{
	int i = 0;

	for(i = 0;i < num;i++){
		if(!MailData_IsEnable(&array[i])){
			return i;
		}
	}
	return MAILDATA_NULLID;
}

/**
 *	@brief	Lf[^̐TĕԂ
 */
static int mail_GetNumEnable(MAIL_DATA* array,int num)
{
	int i = 0;
	int ct = 0;
	
	for(i = 0;i < num;i++){
		if(MailData_IsEnable(&array[i])){
			ct++;
		}
	}
	return ct;
}

/**
 *	@brief	wIDubÑ[f[^ւ̃|C^Ԃ
 */
static MAIL_DATA* mail_GetAddress(MAIL_BLOCK* block,MAILBLOCK_ID blockID,int dataID)
{
	MAIL_DATA* pd = NULL;
	
	switch(blockID){
#if 0
	case MAILBLOCK_TEMOTI:
		if(dataID < MAIL_STOCK_TEMOTI){
			pd = &(block->temoti[dataID]);
		}
		break;
	case MAILBLOCK_EXTRADE:
		if(dataID < MAIL_STOCK_EXTRADE){
			pd = &(block->extrade[dataID]);
		}
		break;
	case MAILBLOCK_SODATEYA:
		if(dataID >= MAIL_STOCK_SODATEYA){
			pd = &(block->sodateya[dataID]);
		}
		break;
#endif
	case MAILBLOCK_PASOCOM:
		if(dataID < MAIL_STOCK_PASOCOM){
			pd = &(block->paso[dataID]);
		}
		break;
	default:
		break;
	}
	return pd;
}
