//============================================================================================
/**
 * @file	misc.c
 * @brief	ރZ[uf[^̃ANZX
 * @author	tamada	GAME FREAK Inc.
 * @date	2006.01.26
 *
 * ނĂȂZ[uf[^͂Ƃ肠ɒǉB
 * AvP[VxAZ[uf[^ANZX֐x
 * MISC\̂oƂ͂łȂB
 * MISC\̂̓oɎ\̂ւ̃ANZX񋟂邾
 * C^[tFCXƂċ@\ĂB
 *
 * Z[uf[^ƂĂ̐ƒ`ł悤ɂȂ_ŁA
 * ̃Z[u\̂͂ƕʃ\[Xɐ؂蕪邱ƂɂȂB
 *
 * 2006.06.02
 * Ԑ؂ŕނ킩̂͂ɒǉ邱Ƃɂ܂B
 * OB
 */
//============================================================================================

#include "common.h"
#include "gflib/system.h"

#include "system/gamedata.h"

#include "savedata/savedata.h"

#include "savedata/misc.h"
#include "misc_local.h"

#include "seedbed_local.h"
#include "savedata/seedbed.h"
#include "gimmickwork_local.h"
#include "savedata/gimmickwork.h"


#include "gflib/strbuf_family.h"
#include "system/pm_str.h"

//============================================================================================
//============================================================================================

//---------------------------------------------------------------------------
/**
 * @brief	MISC\̂̒`
 *
 * L̂悤ȃZ[uf[^ubŃAMISC̃o[ƂĊmۂB
 * -ǂɕނׂAfɖ́B͕ނۗĂ
 * -K͂Â߂ɃZ[uubNmۂ̂Ȃ
 */
//---------------------------------------------------------------------------
struct _MISC {
	SEEDBED seedbed[SEEDBED_MAX];
	GIMMICKWORK gimmick;
	STRCODE rivalname[PERSON_NAME_SIZE + EOM_SIZE];
	STRCODE monument_name[MONUMENT_NAME_SIZE + EOM_SIZE];
};

#ifdef	PM_DEBUG
#if	PM_VERSION == VERSION_DIAMOND
static const STRCODE RivalName[] = {PA_, bou_,RU_, EOM_ };
#elif	PM_VERSION == VERSION_PEARL
static const STRCODE RivalName[] = {DA_, I_, YA_, EOM_ };
#endif
#endif
//============================================================================================
//============================================================================================

//---------------------------------------------------------------------------
/**
 * @brief	MISC\̂̃TCY擾
 * @return	int		MISC\̂̃TCY
 */
//---------------------------------------------------------------------------
int MISC_GetWorkSize(void)
{
	return sizeof(MISC);
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
void MISC_Copy(const MISC * from, MISC * to)
{
	MI_CpuCopy8(from ,to, sizeof(MISC));
}

//============================================================================================
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	FXZ[uf[^ێ[N̏
 * @param	misc	FXZ[uf[^ێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
void MISC_Init(MISC * misc)
{
	MI_CpuClearFast(misc, sizeof(MISC));
	/* ȉɌʕ̏ */
	SEEDBED_Init(misc->seedbed);
	GIMMICKWORK_Init(&misc->gimmick);
	MI_CpuFill16(misc->rivalname, EOM_, PERSON_NAME_SIZE + EOM_SIZE);
	MI_CpuFill16(misc->monument_name, EOM_, MONUMENT_NAME_SIZE + EOM_SIZE);
#ifdef	PM_DEBUG
	PM_strcpy(misc->rivalname, RivalName);
#endif
}

//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	MISCZ[uf[^̎擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	MISC\̂ւ̃|C^
 */
//---------------------------------------------------------------------------
MISC * SaveData_GetMisc(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_MISC);
}

//---------------------------------------------------------------------------
/**
 * @brief	MISCZ[uf[^̎擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	MISC\̂ւ̃|C^
 */
//---------------------------------------------------------------------------
const MISC * SaveData_GetMiscReadOnly(const SAVEDATA * sv)
{
	return SaveData_GetReadOnlyData(sv, GMDATA_ID_MISC);
}

//---------------------------------------------------------------------------
/**
 * @brief	̂ݏԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	CONFIG		ݒێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
SEEDBED * SaveData_GetSeedBed(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return misc->seedbed;
}

//---------------------------------------------------------------------------
/**
 * @brief	}bvŗL̎d|[Nւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	GIMMICKWORK	d|p[Nւ̃|C^
 */
//---------------------------------------------------------------------------
GIMMICKWORK * SaveData_GetGimmickWork(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return &misc->gimmick;
}

//============================================================================================
//============================================================================================
//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
const STRCODE * MISC_GetRivalName(const MISC * misc)
{
	return misc->rivalname;
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
void MISC_SetRivalName(MISC * misc, STRBUF * str)
{
	STRBUF_GetStringCode( str, misc->rivalname, PERSON_NAME_SIZE + EOM_SIZE );
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
const STRCODE * MISC_GetMonumentName(const MISC * misc)
{
	return misc->monument_name;
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
void MISC_SetMonumentName(MISC * misc, STRBUF * str)
{
	STRBUF_GetStringCode( str, misc->monument_name, MONUMENT_NAME_SIZE + EOM_SIZE );
}

