//============================================================================================
/**
 * @file	mystatus.c
 * @brief	ԃf[^ANZXp\[X
 * @author	tamada GAME FREAK inc.
 * @date	2005.10.27
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"

#include "mystatus_local.h"

#include "savedata/mystatus.h"

#include "system/pm_str.h"

#include "gflib/strbuf_family.h"

#define TR_LOW_MASK		(0xffff)

//============================================================================================
//============================================================================================

enum {
	MY_GOLD_MAX	= 999999,
};



//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԕێ[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int MyStatus_GetWorkSize(void)
{
	return sizeof(MYSTATUS);
}

//----------------------------------------------------------
/**
 * @brief	ԕێ[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	MYSTATUS	擾[Nւ̃|C^
 */
//----------------------------------------------------------
MYSTATUS * MyStatus_AllocWork(u32 heapID)
{
	MYSTATUS * my;
	my = sys_AllocMemory(heapID, sizeof(MYSTATUS));
	MyStatus_Init(my);


	return my;
}

//----------------------------------------------------------
/**
 * @brief	MYSTATUS̃Rs[
 * @param	from	Rs[MYSTATUSւ̃|C^
 * @param	to		Rs[MYSTATUSւ̃|C^
 */
//----------------------------------------------------------
void MyStatus_Copy(const MYSTATUS * from, MYSTATUS * to)
{
	MI_CpuCopy8(from, to, sizeof(MYSTATUS));
}

//============================================================================================
//
//	MYSTATUŜ߂̊֐
//
//============================================================================================

//----------------------------------------------------------
/**
 * @brief		ԃf[^̏
 * @param	my		ԕێ[Nւ̃|C^
 */
//----------------------------------------------------------
void MyStatus_Init(MYSTATUS * my)
{
	memset(my, 0, sizeof(MYSTATUS));

	// JZbǧR[h𖄂ߍ
	my->region_code = PM_LANG;		

#ifdef PM_DEBUG

	// fobOő̐lɂȂ肷܂B
	if(sys.cont&PAD_BUTTON_L){
		MyStatus_SetRegionCode(my, LANG_JAPAN );
	}else if(sys.cont&PAD_BUTTON_R){
		MyStatus_SetRegionCode(my, LANG_ENGLISH );
	}else if(sys.cont&PAD_BUTTON_SELECT){
		MyStatus_SetRegionCode(my, LANG_FRANCE	 );
	}else if(sys.cont&PAD_BUTTON_START){
		MyStatus_SetRegionCode(my, LANG_ITALY	 );
	}else if(sys.cont&PAD_KEY_UP){
		MyStatus_SetRegionCode(my, LANG_GERMANY );
	}else if(sys.cont&PAD_KEY_LEFT){
		MyStatus_SetRegionCode(my, LANG_SPAIN	 );
	}

#endif
}

//----------------------------------------------------------
/**
 * @brief	̖OZbg
 * @param	my		ԕێ[Nւ̃|C^
 * @param	name	Oւ̃|C^
 */
//----------------------------------------------------------
void MyStatus_SetMyName(MYSTATUS * my, const STRCODE * name)
{
	int len;
	len = PM_strlen(name);
	GF_ASSERT(len < PERSON_NAME_SIZE + EOM_SIZE)
	PM_strcpy(my->name, name);
}

//----------------------------------------------------------
/**
 * @brief	̖OZbg(STRBUFŁj
 * @param	my		ԕێ[Nւ̃|C^
 * @param	str		Oێobt@ւ̃|C^
 */
//----------------------------------------------------------
void MyStatus_SetMyNameFromString(MYSTATUS * my, const STRBUF * str)
{
	STRBUF_GetStringCode( str, my->name, PERSON_NAME_SIZE + EOM_SIZE );
}

//----------------------------------------------------------
/**
 * @brief	̖O擾
 * @param	my		ԕێ[Nւ̃|C^
 * @return	STRCODE		Oւ̃|C^
 */
//----------------------------------------------------------
const STRCODE * MyStatus_GetMyName(const MYSTATUS * my)
{
	return my->name;
}

//----------------------------------------------------------
/**
 * @brief	̖O擾iSTRBUFɃRs[j
 * @param	my		ԕێ[Nւ̃|C^
 * @param	buf		Rs[STRBUFւ̃|C^ieœe͊mۂĂ鎖Oj
 * @return	none
 */
//----------------------------------------------------------
void MyStatus_CopyNameString( const MYSTATUS * my, STRBUF *buf )
{
	STRBUF_SetStringCode( buf, my->name );
}

//----------------------------------------------------------
/**
 * @brief	̖O擾iSTRBUF𐶐j
 * @param	my		ԕێ[Nւ̃|C^
 * @param	heapID	STRBUF𐶐q[vID
 * @return	STRBUF	Oi[STRBUFւ̃|C^
 */
//----------------------------------------------------------
STRBUF * MyStatus_CreateNameString(const MYSTATUS * my, int heapID)
{
	STRBUF * tmpBuf = STRBUF_Create(PERSON_NAME_SIZE + EOM_SIZE, heapID);
//	STRBUF_SetStringCode( tmpBuf, my->name );
	MyStatus_CopyNameString( my, tmpBuf );
	return tmpBuf;
}


//----------------------------------------------------------
/**
 * @brief	̂hcZbg
 * @param	my		ԕێ[Nւ̃|C^
 * @param	id		hcw	
 */
//----------------------------------------------------------
void MyStatus_SetID(MYSTATUS * my, u32 id)
{
	my->id = id;
}
//----------------------------------------------------------
/**
 * @brief	̂hc擾
 * @param	my		ԕێ[Nւ̃|C^
 * @return	int		̂hc	
 */
//----------------------------------------------------------
u32 MyStatus_GetID(const MYSTATUS * my)
{
	return my->id;
}

//----------------------------------------------------------
/**
 * @brief	̂hc擾(ʂQoCg)
 * @param	my		ԕێ[Nւ̃|C^
 * @return	int		̂hc	
 */
//----------------------------------------------------------
u16 MyStatus_GetID_Low(const MYSTATUS * my)
{
	return (u16)(my->id&TR_LOW_MASK);
}

//----------------------------------------------------------
/**
 * @brief	̐ʃZbg
 * @param	my		ԕێ[Nւ̃|C^
 * @param	sex		̐
 */
//----------------------------------------------------------
void MyStatus_SetMySex(MYSTATUS * my, int sex)
{
	my->sex = sex;
}
//----------------------------------------------------------
/**
 * @brief	̐ʎ擾
 * @param	my		ԕێ[Nւ̃|C^
 * @return	sex		̐
 */
//----------------------------------------------------------
u32 MyStatus_GetMySex(const MYSTATUS * my)
{
	return my->sex;
}

//----------------------------------------------------------
/**
 * @brief	obWێԂ̎擾
 * @param	my			ԕێ[Nւ̃|C^
 * @param	badge_id	obW̎w
 * @return	BOOL	obWĂ邩ǂ
 */
//----------------------------------------------------------
BOOL MyStatus_GetBadgeFlag(const MYSTATUS * my, int badge_id)
{
	if (my->badge & (1 << badge_id)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//----------------------------------------------------------
/**
 * @brief	obW擾̃Zbg
 * @param	my			ԕێ[Nւ̃|C^
 * @param	badge_id	obW̎w
 */
//----------------------------------------------------------
void MyStatus_SetBadgeFlag(MYSTATUS * my, int badge_id)
{
	my->badge |= (1 << badge_id);
}

//----------------------------------------------------------
/**
 * @brief	ĂobW̐擾
 * @param	my			ԕێ[Nւ̃|C^
 * @return	int		ĂobW̐iO`Wj
 */
//----------------------------------------------------------
int MyStatus_GetBadgeCount(const MYSTATUS * my)
{
	int count = 0;
	u32 badge;
	
	for (badge = my->badge; badge != 0; badge >>= 1) {
		if (badge & 1) {
			count ++;
		}
	}
	return count;
}
//----------------------------------------------------------
/**
 * @brief	Ăz擾
 * @param	my		ԕێ[Nւ̃|C^
 * @return	u32		Ăz
 */
//----------------------------------------------------------
u32 MyStatus_GetGold(const MYSTATUS * my)
{
	return my->gold;
}

//----------------------------------------------------------
/**
 * @brief
 * @param	my		ԕێ[Nւ̃|C^
 * @param	gold	Zbgz
 * @return	u32		݂̎莝z
 */
//----------------------------------------------------------
u32 MyStatus_SetGold(MYSTATUS * my, u32 gold)
{
	if (gold > MY_GOLD_MAX) {
		gold = MY_GOLD_MAX;
	}
	my->gold = gold;
	return my->gold;
}

//==============================================================================
/**
 * $brief   g[i[ƂČ鎞̔ԍԂijI[pj
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @retval  u8		g[i[ƂĂ̎̌
 */
//==============================================================================
u8 MyStatus_GetTrainerView( const MYSTATUS *my )
{
	return my->trainer_view;
}

//==============================================================================
/**
 * $brief   g[i[ƂČ鎞̔ԍZbgijI[pj
 *
 * @param   my		ԕێ[Nւ̃|C^
 * @param   view	g[i[ڔԍ
 *
 * @retval  none
 */
//==============================================================================
void MyStatus_SetTrainerView( MYSTATUS *my, u8 view )
{
	my->trainer_view = view;
}

//----------------------------------------------------------
/**
 * @brief
 * @param	my		ԕێ[Nւ̃|C^
 * @param	add		z
 * @return	u32		݂̎莝z
 */
//----------------------------------------------------------
u32 Mystatus_AddGold(MYSTATUS * my, u32 add)
{
	if (add > MY_GOLD_MAX) {
		my->gold = MY_GOLD_MAX;
	} else {
		my->gold += add;
	}
	if (my->gold > MY_GOLD_MAX) {
		my->gold = MY_GOLD_MAX;
	}
	return my->gold;
}

//----------------------------------------------------------
/**
 * @brief
 * @param	my		ԕێ[Nւ̃|C^
 * @param	sub		oz
 * @return	u32		݂̎莝z
 */
//----------------------------------------------------------
u32 Mystatus_SubGold(MYSTATUS * my, u32 sub)
{
	if (my->gold < sub) {
		my->gold = 0;
	} else {
		my->gold -= sub;
	}
	return my->gold;
}



//==============================================================================
/**
 * $brief   qnlo[WR[hԂ
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @retval  u8		0:_C 1:p[
 */
//==============================================================================
u8  MyStatus_GetRomCode( const MYSTATUS * my )
{
	return my->rom_code;
}

//==============================================================================
/**
 * $brief   qnlo[WR[hݒ肷
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @param  rom_code		0:_C 1:p[
 */
//==============================================================================
void  MyStatus_SetRomCode( MYSTATUS * my, u8 rom_code )
{
	my->rom_code = rom_code;
}

//==============================================================================
/**
 * $brief   [WR[hԂ
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @retval  u8		[WR[h
 */
//==============================================================================
u8  MyStatus_GetRegionCode( const MYSTATUS * my )
{
	return my->region_code;
}

//==============================================================================
/**
 * $brief   [WR[hݒ肷
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @param  region_code		
 */
//==============================================================================
void  MyStatus_SetRegionCode( MYSTATUS * my, u8 region_code )
{
	my->region_code = region_code;
}

//==============================================================================
/**
 * @brief   DPNAĂ邩tÕZbg
 *
 * @param   my		
 * @param   flag	0:ĂȂ	1:NAĂ
 *
 * @retval  none		
 */
//==============================================================================
void MyStatus_SetDpClearFlag( MYSTATUS * my )
{
	my->dp_clear = 1;
}

int MyStatus_GetDpClearFlag( MYSTATUS * my )
{
	return my->dp_clear;
}

//==============================================================================
/**
 * @brief   DPS}ӂĂtÕZbg
 *
 * @param   my		
 * @param   flag	0:VIE}	1:S}
 *
 * @retval  none		
 */
//==============================================================================
void MyStatus_SetDpZenkokuFlag( MYSTATUS * my )
{
	my->dp_zenkoku = 1;
}

int MyStatus_GetDpZenkokuFlag( MYSTATUS * my )
{
	return my->dp_zenkoku;
}





//----------------------------------------------------------
/**
 * @brief	myStatusm̂ǂ𒲂ׂ
 * @param	my		ԕێ[Nւ̃|C^
 * @param	target	̎ԕێ[Nւ̃|C^
 * @return	vTRUE
 */
//----------------------------------------------------------
BOOL MyStatus_Compare(const MYSTATUS * my, const MYSTATUS * target)
{
    if(0 == PM_strncmp(my->name, target->name, PERSON_NAME_SIZE)){
        if(my->id == target->id){
            return TRUE;
        }
    }
    return FALSE;
}



//============================================================================================
//	fobOp
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	fobOpFԃZbg
 * @param	my		ԕێ[Nւ̃|C^
 * @param	name	Oւ̃|C^
 * @param	sex		ʎw
 */
//----------------------------------------------------------
void Debug_MyStatus_Make(MYSTATUS * mystatus, const STRCODE * name, int sex)
{
	MyStatus_SetMyName(mystatus, name);
	MyStatus_SetMySex(mystatus, sex);
}

// OQƃCfbNX鎞̂ݗL(Q[͖)
#ifdef CREATE_INDEX
void *Index_Get_Mystatus_Name_Offset(MYSTATUS *my){ return &my->name; }
void *Index_Get_Mystatus_Id_Offset(MYSTATUS *my){ return &my->id; }
void *Index_Get_Mystatus_Sex_Offset(MYSTATUS *my){ return &my->sex; }
#endif
