//============================================================================================
/**
 * @file	perapvoice.c
 * @brief
 * @date	2006.04.06
 */
//============================================================================================


#include "savedata/savedata.h"
#include "savedata/perapvoice.h"
#include "perapvoice_local.h"

#include "gflib/assert.h"
#include "gflib/heapsys.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	IE|P̐f[^Z[u[N̒`
 */
//----------------------------------------------------------
struct PERAPVOICE {
	BOOL exist_flag;
	s8 voicedata[PERAPVOICE_LENGTH];
};

//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	؃bv̐[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int PERAPVOICE_GetWorkSize(void)
{
	return sizeof(PERAPVOICE);
}

//----------------------------------------------------------
/**
 * @brief	؃bv̐[N̏
 * @param	pv		PERAPVOICEf[^ւ̃|C^
 */
//----------------------------------------------------------
void PERAPVOICE_Init(PERAPVOICE * pv)
{
	MI_CpuClear32(pv, sizeof(PERAPVOICE));
	pv->exist_flag = FALSE;
}

//----------------------------------------------------------
/**
 * @brief	؃bv̐[N̏
 * @param	heapID		mۂȂq[vw
 * @return	PERAPVOICE	擾[Nւ̃|C^
 */
//----------------------------------------------------------
PERAPVOICE * PERAPVOICE_AllocWork(int heapID)
{
	PERAPVOICE *pv = sys_AllocMemory(heapID, sizeof(PERAPVOICE));
	PERAPVOICE_Init(pv);
	return pv;
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	؃bv̐Z[uf[^̎擾
 * @param	sv		Z[uf[^ւ̃|C^
 * @return	PERAPVOICEf[^ւ̃|C^
 */
//----------------------------------------------------------
PERAPVOICE * SaveData_GetPerapVoice(SAVEDATA * sv)
{
	return (PERAPVOICE*)SaveData_Get(sv, GMDATA_ID_PERAPVOICE);
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	f[^݂邩ǂ̃`FbN
 * @param	pv		f[^ւ̃|C^
 * @return	BOOL	TRUEF݂AFALSEF݂Ȃ
 */
//----------------------------------------------------------
BOOL PERAPVOICE_GetExistFlag(const PERAPVOICE * pv)
{
	return pv->exist_flag;
}

//==============================================================================
/**
 * @brief   f[^̑݃tO𗎂Ƃ
 *
 * @param   pv		f[^ւ̃|C^
 *
 * @retval  none		
 */
//==============================================================================
void PERAPVOICE_ClearExistFlag( PERAPVOICE * pv )
{
	pv->exist_flag = 0;
}

//----------------------------------------------------------
/**
 * @brief	f[^̎擾
 * @param	pv		f[^ւ̃|C^
 * @return	f[^ւ̃|C^
 */
//----------------------------------------------------------
const void * PERAPVOICE_GetVoiceData(const PERAPVOICE * pv)
{
	return pv->voicedata;
}

//==============================================================================
/**
 * $brief   f[^̓WJ
 *
 * @param   des		WJ
 * @param   src		ybv{CX̃|C^
 *
 * @retval  none		
 *
 * 06/04/15_ł̓ybv{CX4bit,2khz,1bTvO=1k
 * ̃f[^8bitɐL΂2kɂĊi[
 */
//==============================================================================
void PERAPVOICE_ExpandVoiceData( s8 *des, const s8 *src )
{
	int i,count=0;
	s8 tmp;
	u8 dat;

	// 4bit1kbyte8bit2kbyteɐL΂
	for(i=0;i<PERAPVOICE_LENGTH;i++){
		dat = src[i]&0x0f;
		tmp = dat-8;
		
		des[count]   = tmp*16;

		dat = src[i]>>4;
		tmp = dat-8;
		des[count+1]   = tmp*16;


//		des[count  ] = src[i];
//		des[count+1] = src[i]>>4;
		count += 2;
	}
}

//----------------------------------------------------------
/**
 * @brief	f[^̃Zbg
 * @param	pv		f[^ւ̃|C^
 * @param	src		Zbgf[^ւ̃|C^
 *
 * 06/04/15_ł̓ybv{CX8bit,2khz,1bTvO=2k
 * ̃f[^4bitɏk߂1kɂĊi[
 *
 */
//----------------------------------------------------------
void PERAPVOICE_SetVoiceData(PERAPVOICE * pv, const s8 * src)
{
	int i,count;
	s8 tmp;
	u8 dat;

	// i[tO𗧂Ă
	pv->exist_flag = TRUE;

	// 2khz8bit4bitɂĊi[
	count = 0;
	for(i=0;i<PERAPVOICE_LENGTH*2;i+=2){
		tmp = (src[i]/16);
		dat = tmp+8;
		pv->voicedata[count]   = dat;
//		pv->voicedata[count]  =  src[i];

		tmp = (src[i+1]/16);
		dat = tmp+8;

		pv->voicedata[count] |= (dat<<4);
//		pv->voicedata[count] |= (src[i+1]<<4);
		count++;
	}

//	MI_CpuCopy32(src, (void *)pv->voicedata, PERAPVOICE_LENGTH);
}

//==============================================================================
/**
 * $brief   f[^̃Rs[
 *
 * @param   des		Rs[携f[^̃|C^
 * @param   src		Rs[f[^̃|C^
 *
 * @retval  none	
 */
//==============================================================================
void PERAPVOICE_CopyData(PERAPVOICE * des, const PERAPVOICE * src)
{
	MI_CpuCopyFast(src, des,  sizeof(PERAPVOICE));
}
