//============================================================================================
/**
 * @file	player_data.c
 * @date	2006.06.01
 * @author	tamada
 * @brief	vC[֘AZ[uf[^
 */
//============================================================================================

#include "savedata/savedata.h"
#include "savedata/playerdata_local.h"

#include "gflib/assert.h"

#include "gflib/msg_print.h"
#include "system/buflen.h"

#include "savedata/mystatus.h"
#include "mystatus_local.h"
#include "config_local.h"
#include "savedata/config.h"
#include "mystatus_local.h"
#include "savedata/mystatus.h"
#include "coin_local.h"
#include "savedata/coin.h"
#include "playtime_local.h"
#include "savedata/playtime.h"

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	vC[Z[uf[^̒`
 */
//------------------------------------------------------------------
struct PLAYER_DATA {
	CONFIG config;
	MYSTATUS mystatus;
	COIN mycoin;
	PLAYTIME playtime;
};

//============================================================================================
//
//		ɃZ[uVXeĂ΂֐
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	Z[uf[^TCY̎擾
 * @return	int		vC[Z[uf[^̃TCY
 */
//------------------------------------------------------------------
int PLAYERDATA_GetWorkSize(void)
{
	return sizeof(PLAYER_DATA);
}

//------------------------------------------------------------------
/**
 * @brief	Z[uf[^
 * @param	pd		vC[Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
void PLAYERDATA_Init(PLAYER_DATA * pd)
{
	MI_CpuClearFast(pd, sizeof(PLAYER_DATA));
	/* ȉɌʕ̏ */
	CONFIG_Init(&pd->config);
	MyStatus_Init(&pd->mystatus);
	COIN_Init(&pd->mycoin);
	PLAYTIME_Init(&pd->playtime);
}

//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	MYSTATUS	ԕێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
MYSTATUS * SaveData_GetMyStatus(SAVEDATA * sv)
{
	PLAYER_DATA * pd;
	pd = SaveData_Get(sv, GMDATA_ID_PLAYER_DATA);
	return &pd->mystatus;
}

//---------------------------------------------------------------------------
/**
 * @brief	ݒf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	CONFIG		ݒێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
CONFIG * SaveData_GetConfig(SAVEDATA * sv)
{
	PLAYER_DATA * pd;
	pd = SaveData_Get(sv, GMDATA_ID_PLAYER_DATA);
	return &pd->config;
}

//---------------------------------------------------------------------------
/**
 * @brief	RCf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	coin	RCf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
COIN * SaveData_GetMyCoin(SAVEDATA * sv)
{
	PLAYER_DATA * pd;
	pd = SaveData_Get(sv, GMDATA_ID_PLAYER_DATA);
	return &pd->mycoin;
}

//---------------------------------------------------------------------------
/**
 * @brief	vCԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	playtime	vCԃf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
PLAYTIME * SaveData_GetPlayTime(SAVEDATA * sv)
{
	PLAYER_DATA * pd;
	pd = SaveData_Get(sv, GMDATA_ID_PLAYER_DATA);
	return &pd->playtime;
}

