//============================================================================================
/**
 * @file	randomgroup.c
 * @brief	̎O[v\[X
 * @author	mori GAME FREAK inc.
 * @date	2006.03.22
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/randomgroup.h"
#include "randomgroup_local.h"

#include "system/pm_str.h"

#include "gflib/strbuf_family.h"

//============================================================================================
//============================================================================================


RANDOM_GROUP * DebugRandomGroupPtr;


//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԕێ[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int RandomGroup_GetWorkSize(void)
{
	return sizeof(RANDOM_GROUP);
}

//==============================================================================
/**
 * $brief   _O[vł̃Rs[if[^Ŝ̃Rs[ł͂Ȃj
 *
 * @param   randomgroup		
 * @param   from		
 * @param   to		
 *
 * @retval  none		
 */
//==============================================================================
void RandomGroup_Copy( RANDOM_GROUP *randomgroup, int from, int to )
{
	randomgroup->group[to] = randomgroup->group[from];
}


//==============================================================================
/**
 * $brief   _O[v
 *
 * @param   randomgroup		
 *
 * @retval  none		
 */
//==============================================================================
void RandomGroup_Init(RANDOM_GROUP * randomgroup )
{
	int i;
	
	MI_CpuClearFast(randomgroup, sizeof(RANDOM_GROUP));

	for(i=0;i<RANDOMGROUP_MAX;i++){
		randomgroup->group[i].group_name[0] = EOM_;
		randomgroup->group[i].name[0]       = EOM_;
	}

	DebugRandomGroupPtr = randomgroup;
	
}

//==============================================================================
/**
 * @brief	̎XV
 *
 * @param	randomgroup
 * @param	days			o
 *
 * o߂̉񐔂_̃^lXVB
 */
//==============================================================================
void RandomGroup_Update(RANDOM_GROUP * randomgroup, u32 days)
{
	u32 no, times;
	for (no = 0; no < RANDOMGROUP_MAX; no++) {
		for (times = 0; times < days; times++) {
			//RandomGroup_SetRandom(randomgroup, no);
			randomgroup->group[no].random = gf_fix_rand( randomgroup->group[no].random );
		}
	}
}

//==============================================================================
/**
 * $brief   ̎擾(قƂǌĂ΂Ȃ낤j
 *
 * @param   randomgroup		
 * @param   no		
 *
 * @retval  u32		
 */
//==============================================================================
u32  RandomGroup_GetRandomSeed( RANDOM_GROUP* randomgroup, int no )
{
	return randomgroup->group[no].seed;
}

//==============================================================================
/**
 * $brief   ̎̐ݒiO[v쐬Ɉ񂾂Ăԁj
 *
 * @param   randomgroup		O[v\
 * @param   no				Ԗڂ
 * @param   seed			l
 *
 * @retval  u32		
 */
//==============================================================================
void  RandomGroup_SetRandomSeed( RANDOM_GROUP* randomgroup, int no, u32 seed )
{
	// ̎i[iQxƍXVȂj
	randomgroup->group[no].seed = seed;

	// i[Ă
	randomgroup->group[no].random = gf_fix_rand( seed );

}

//==============================================================================
/**
 * $brief   ς闐l擾
 *
 * @param   randomgroup		
 * @param   no				
 *
 * @retval  u32		
 */
//==============================================================================
u32  RandomGroup_GetRandom( RANDOM_GROUP* randomgroup, int no )
{
	return randomgroup->group[no].random;
}

//==============================================================================
/**
 * @brief   ς闐l擾iftHgj
 *
 * @param	randomgroup
 *
 * @return	u32
 *
 * {IɃQ[ŎQƂũ^lv͂̊֐ɂĎ擾B
 */
//==============================================================================
u32  RandomGroup_GetDefaultRandom( RANDOM_GROUP* randomgroup )
{
	return randomgroup->group[RANDOMGROUP_MYUSE].random;
}

//==============================================================================
/**
 * $brief   XV(PPXVj
 *          ݕێĂ闐̒lV̎Ȃ̂ŊOp[^͖Ȃ
 *
 * @param   randomgroup		
 * @param   no				
 *
 * @retval  none			
 */
//==============================================================================
void RandomGroup_SetRandom( RANDOM_GROUP* randomgroup, int no )
{
	u32 temp = randomgroup->group[no].random;
	randomgroup->group[no].random = gf_fix_rand( randomgroup->group[no].random );

	OS_TPrintf("XV no=%d from=%08x, to=%08x\n",no,temp,randomgroup->group[no].random);
}


//==============================================================================
/**
 * $brief   O[vE̓[_[̃|C^擾
 *
 * @param   randomgroup		
 * @param   no		
 * @param   type		
 *
 * @retval  const STRCODE *		
 */
//==============================================================================
const STRCODE *RandomGroup_GetNamePtr( const RANDOM_GROUP *randomgroup, int no, int type )
{
	if(type==RANDOMGROUP_NAME_GROUP){
		return randomgroup->group[no].group_name;
	}
	return randomgroup->group[no].name;

}

//==============================================================================
/**
 * $brief   O[vE܂̓[_[̃Zbg
 *
 * @param   randomgroup		
 * @param   no		
 * @param   type		
 * @param   str		
 *
 * @retval  none		
 */
//==============================================================================
void  RandomGroup_SetName( RANDOM_GROUP *randomgroup, int no, int type, STRBUF *str )
{
	STRCODE *name;

	if(type==RANDOMGROUP_NAME_GROUP){
		name = randomgroup->group[no].group_name;
		STRBUF_GetStringCode( str, name, GROUP_NAME_SIZE + EOM_SIZE );
	}else{
		name = randomgroup->group[no].name;
		STRBUF_GetStringCode( str, name, PERSON_NAME_SIZE + EOM_SIZE );
	}
	
}

//==============================================================================
/**
 * @brief	ʂZbg
 *
 * @param   randomgroup		
 * @param   no		
 */
//==============================================================================
void RandomGroup_SetSex( RANDOM_GROUP *randomgroup, int no, int sex)
{
	randomgroup->group[no].sex = sex;
}

//==============================================================================
/**
 * @brief	ʂ擾
 *
 * @param   randomgroup		
 * @param   no		
 * @return	int		ʃR[h
 */
//==============================================================================
int RandomGroup_GetSex( const RANDOM_GROUP *randomgroup, int no)
{
	return randomgroup->group[no].sex;
}

//==============================================================================
/**
 * @brief	[WR[h擾
 *
 * @param   randomgroup		
 * @param   no		
 * @return	int		[WR[h
 */
//==============================================================================
int RandomGroup_GetRegionCode( const RANDOM_GROUP *randomgroup, int no)
{
	return randomgroup->group[no].region_code;
}

//==============================================================================
/**
 * @brief	[WR[hZbg
 *
 * @param   randomgroup		
 * @param   no		
 */
//==============================================================================
void RandomGroup_SetRegionCode( RANDOM_GROUP *randomgroup, int no, int region_code )
{
	randomgroup->group[no].region_code = region_code;
}

//==============================================================================
/**
 * $brief   ̎O[ṽ|C^Ԃ
 *
 * @param   sv		
 *
 * @retval  RANDOM_GROUP *		
 */
//==============================================================================
RANDOM_GROUP *SaveData_GetRandomGroup(SAVEDATA * sv)
{
	return (RANDOM_GROUP *)SaveData_Get(sv, GMDATA_ID_RANDOMGROUP);
}


//==============================================================================
/**
 * @brief	O[vf[^̑݃`FbN
 *
 * @param   randomgroup		
 * @param   no				`FbNf[^ID
 * @retval	TRUE			݂
 * @retval	FALSE			݂Ȃ
 */
//==============================================================================
BOOL RandomGroup_ExistCheck(const RANDOM_GROUP * rg, int no)
{
	const RANDOM_SEED * rs = &rg->group[no];
	return !(RandomGroup_IsNullData(rs));
}

//==============================================================================
/**
 * @brief	O[vf[^̓o^Ăf[^ǂ̃`FbN
 *
 * @param   randomgroup		
 * @param   no				rf[^ID
 * @retval	TRUE			v
 * @retval	FALSE			vȂ
 */
//==============================================================================
BOOL RandomGroup_EntryCheck(const RANDOM_GROUP * rg, int no)
{
	const RANDOM_SEED * rs1, * rs2;
	rs1 = &rg->group[RANDOMGROUP_MYUSE];
	rs2 = &rg->group[no];
	return RandomGroup_Compare(rs1, rs2);
}

//==============================================================================
/**
 * @brief	w肵O[v݂邩ǂ̃`FbN
 * @param	rg
 * @param	group_name
 * @return	BOOL	TRUÊƂAv閼O
 */
//==============================================================================
BOOL RandomGroup_SameGroupNameCheck(const RANDOM_GROUP * rg, const STRCODE * group_name)
{
	int index;
	const RANDOM_SEED * rs;

	if (*group_name == EOM_) {
		//O݂Ȃ
		return FALSE;
	}
	for (index = 0; index < RANDOMGROUP_MAX; index ++ ) {
		rs = &rg->group[index];
		if (!PM_strncmp(group_name, rs->group_name, GROUP_NAME_SIZE + EOM_SIZE)) {
			return TRUE;
		}
	}
	return FALSE;
}

//============================================================================================
//
//		_O[vł̂ݎgp֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	f[^݂邩ǂ̃`FbN
 * @param	rs
 * @retval	TRUE	݂Ȃ
 * @retval	FALSE	݂
 */
//----------------------------------------------------------
BOOL RandomGroup_IsNullData(const RANDOM_SEED * rs)
{
	if (rs->group_name[0] == EOM_) {
		return TRUE;
	}
	if (rs->name[0] == EOM_) {
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	_̃^lǂ`FbN
 * @param	s1			_̃^l̂P
 * @param	s2			_̃^l̂Q
 * @retval	TRUE		v
 * @retval	FALSE		Ⴄf[^
 */
//----------------------------------------------------------
BOOL RandomGroup_Compare(const RANDOM_SEED * s1, const RANDOM_SEED * s2)
{
	int i;
	if (PM_strncmp(s1->name, s2->name, PERSON_NAME_SIZE + EOM_SIZE)) {
		return FALSE;
	}
	if (PM_strncmp(s1->group_name, s2->group_name, GROUP_NAME_SIZE + EOM_SIZE)) {
		return FALSE;
	}
	if (s1->sex != s2->sex) {
		return FALSE;
	}
	if (s1->region_code != s2->region_code) {
		return FALSE;
	}
	if (s1->seed != s2->seed) {
		return FALSE;
	}
	/*
	 * if (s1->random != s2->random) {
	 *		͂ǂ悤c
	 * }
	 */
	return TRUE;
}

