//============================================================================================
/**
 * @file	record.c
 * @brief	Q[JEg֘A
 * @author	tamada
 * @date	2006.03.28
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "savedata/savedata.h"

#include "savedata/record.h"


#include "gflib/assert.h"

//============================================================================================
//============================================================================================
struct RECORD{
	u32 large_rec[LARGE_REC_NUM];
	u16 small_rec[SMALL_REC_NUM];
};
#ifdef _NITRO
// \̂z̃TCYƂȂĂ邩`FbN
SDK_COMPILER_ASSERT(sizeof(RECORD) == 332);
#endif

//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int RECORD_GetWorkSize(void)
{
	return sizeof(RECORD);
}

//----------------------------------------------------------
/**
 * @brief	R[h
 * @param	rec		R[hf[^ւ̃|C^
 */
//----------------------------------------------------------
void RECORD_Init(RECORD * rec)
{
	MI_CpuClear32(rec, sizeof(RECORD));
}

//----------------------------------------------------------
/**
 * @brief
 * @param	sv
 * @return	RECORDւ̃|C^
 */
//----------------------------------------------------------
RECORD * SaveData_GetRecord(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_RECORD);
}

//============================================================================================
//
//
//			֐
//
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	l̎擾
 * @param	rec		RECORDւ̃|C^
 * @param	id		R[hڎwID
 * @return	u32		݂̒l
 */
//----------------------------------------------------------
static u32 get_value(const RECORD * rec, int id)
{
	if (id < LARGE_REC_MAX) {
		return rec->large_rec[id];
	} else if (id < SMALL_REC_MAX) {
		return rec->small_rec[id - LARGE_REC_MAX];
	}
	GF_ASSERT_MSG(0, "record: id error\n");
	return 0;
}

//----------------------------------------------------------
/**
 * @brief	lZbg
 * @param	rec		RECORDւ̃|C^
 * @param	id		R[hڎwID
 * @param	value	Zbgl
 * @return	u32		݂̒l
 */
//----------------------------------------------------------
static u32 set_value(RECORD * rec, int id, u32 value)
{
	if (id < LARGE_REC_MAX) {
		rec->large_rec[id] = value;
	} else if (id < SMALL_REC_MAX) {
		rec->small_rec[id - LARGE_REC_MAX] = value;
	} else {
		GF_ASSERT_MSG(0, "record: id error\n");
	}
	return get_value(rec, id);
}

//----------------------------------------------------------
/**
 * @brief	R[hڂƂ̏擾
 * @param	id		R[hڎwID
 * @return	u32		̒l
 */
//----------------------------------------------------------
static u32 get_limit(int id)
{
	static u8 limit[SMALL_REC_MAX] = {
		1,	//RECID_SCORE
		//4byte
		1,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,	//1-16
		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	//17-32
		1,1,1,1,1,1,1,1,0,0,0,	//33-43
		//2byte
		1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,	//44-59
		0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,	//60-75
		0,0,0,0,0,0,0,0,0,1,	//76-85
	};

	if (id < LARGE_REC_MAX) {
		if(limit[id]){
			return 999999999;
		}else{
			return 999999;
		}
	} else if (id < SMALL_REC_MAX) {
		if(limit[id]){
			return 0xffff;
		}else{
			return 9999;
		}
	}
	GF_ASSERT_MSG(0, "record: id error\n");
	return 0;
}

//----------------------------------------------------------
//----------------------------------------------------------
static int get_score_number(int score_id)
{
	static const u16 num[SCOREID_MAX] = { 
		1,		//SCORE_ID_GET_NUTS					XRAF݂̂
		1,		//SCORE_ID_HONEY_TREE				XRAF؂ɖh
		1,		//SCORE_ID_WRITE_MAIL				XRAF[
		1,		//SCORE_ID_INTERVIEW				XRAFerC^r[ɓ
		1,		//SCORE_ID_WRITE_SIGN				XRAFTC
		1,		//SCORE_ID_PLAY_SLOT				XRAFXbgn߂
		2,		//SCORE_ID_CUSTOM_CAPSULE			XRAFJX^JvZ
		2,		//SCORE_ID_MAKE_CLIP				XRAFNbv
		2,		//SCORE_ID_WILD_BATTLE_WIN			XRAF쐶GJEg
		2,		//SCORE_ID_POKE_GET_SINOU			XRAF|PQbgiVIEj
		3,		//SCORE_ID_POKE_GET_WORLD			XRAF|PQbgiVIEOj
		3,		//SCORE_ID_TRAINER_BATTLE_WIN		XRAFg[i[폟
		3,		//SCORE_ID_MINIGAME_NUTS			XRAF؂̎(1l)
		7,		//SCORE_ID_CONTEST_GRANDPRIX		XRAFReXgD
		7,		//SCORE_ID_BTOWER_7WIN				XRAFog^[7l
		7,		//SCORE_ID_EGG_HATCHING				XRAF^}Sz
		10,		//SCORE_ID_COMM_TRADE_POKE			XRAFʐM(Wifi/_CNg)
		10,		//SCORE_ID_CLEAR_POKEPARK			XRAF|Pp[NNA
		11,		//SCORE_ID_COMM_MINIGAME_NUTS		XRAF؂̎iʐMj
		11,		//SCORE_ID_COMM_CONTEST_GRANDPRIX	XRAFReXgDiʐMj
		11,		//SCORE_ID_COMM_RECORD_CORNER		XRAFR[hR[i[
		11,		//SCORE_ID_COMM_BATTLE_COUNT		XRAFʐMΐ(Wifi/_CNg/jI)
		20,		//SCORE_ID_ZUKAN_ENTRY				XRAFo^
		30,		//SCORE_ID_GYM_LEADER_WIN			XRAFW[_[ɏ
		35,		//SCORE_ID_DENDOU					XRAFa肵
		40,		//SCORE_ID_WORLD_TRADE				XRAFEʐM
		500,	//SCORE_ID_COMMENDATION_A			XRAF\A
		10000,	//SCORE_ID_COMMENDATION_B			XRAF\B

		30,		//SCORE_ID_NEW_FLAG_TAKE_OUT		XRAFYz VA
		30,		//SCORE_ID_FLAG_TAKE_OUT			XRAFYz A
		2,		//SCORE_ID_GET_FOSSIL				XRAFYz Δ@
		5,		//SCORE_ID_ITEM_DEPOSIT				XRAFYz ɓa
		1,		//SCORE_ID_HELLO					XRAFYz 
		1,		//SCORE_ID_QUESTION					XRAFYz ₷
		5,		//SCORE_ID_RESCUE					XRAFYz 㩂珕
		3,		//SCORE_ID_MAKE_BASE				XRAFYz n
		1,		//SCORE_ID_MINE_IN					XRAFYz nɗ
		1,		//SCORE_ID_WLAK_100					XRAFYz 100邭
	};
	return num[score_id];
}

//============================================================================================
//
//
//				֐
//
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	R[hZbg
 * @param	rec		RECORDւ̃|C^
 * @param	id		ڂw肷ID
 * @param	value	Zbgl
 * @return	u32		̍ڂ̒l
 */
//----------------------------------------------------------
u32 RECORD_Set(RECORD * rec, int id, u32 value)
{
	u32	limit = get_limit(id);
	
	if (value < limit) {
		return set_value(rec, id, value);
	} else {
		return set_value(rec, id, limit);
	}
}

//----------------------------------------------------------
/**
 * @brief	傫΃R[hXV
 * @param	rec		RECORDւ̃|C^
 * @param	id		ڂw肷ID
 * @param	value	Zbgl
 * @return	u32		̍ڂ̒l
 */
//----------------------------------------------------------
u32 RECORD_SetIfLarge(RECORD * rec, int id, u32 value)
{
	u32	limit = get_limit(id);
	u32 now = get_value(rec, id);

	if(value > limit){
		value = limit;	//`FbN
	}
	if (now < value) {
		return set_value(rec, id, value);
	} else {
		if(now > limit){
			return set_value(rec, id, limit);
		}
		return now;
	}
}

//----------------------------------------------------------
/**
 * @brief	R[hCNg
 * @param	rec		RECORDւ̃|C^
 * @param	id		ڂw肷ID
 * @param	value	Zbgl
 * @return	u32		̍ڂ̒l
 */
//----------------------------------------------------------
u32 RECORD_Inc(RECORD * rec, int id)
{
	u32	limit = get_limit(id);
	u32 now = get_value(rec, id);
	if (now + 1 < limit) {
		return set_value(rec, id, now + 1);
	} else {
		return set_value(rec, id, limit);
	}
}

//----------------------------------------------------------
/**
 * @brief	R[hɒl
 * @param	rec		RECORDւ̃|C^
 * @param	id		ڂw肷ID
 * @param	value	l
 * @return	u32		̍ڂ̒l
 */
//----------------------------------------------------------
u32 RECORD_Add(RECORD * rec, int id, u32 add_value)
{
	u32	limit = get_limit(id);
	u32 now = get_value(rec, id);
	if (now + add_value < limit) {
		return set_value(rec, id, now + add_value);
	} else {
		return set_value(rec, id, limit);
	}
}

//----------------------------------------------------------
/**
 * @brief	R[h擾
 * @param	rec		RECORDւ̃|C^
 * @param	id		ڂw肷ID
 * @return	u32		̍ڂ̒l
 */
//----------------------------------------------------------
u32 RECORD_Get(const RECORD * rec, int id)
{
	u32	limit = get_limit(id);
	u32	value = get_value(rec, id);

	if(value > limit){
		return limit;
	}else{
		return value;
	}
}

//----------------------------------------------------------
/**
 * @brief	XRẢZ
 * @param	rec		RECORDւ̃|C^
 * @param	id		XRAwID
 */
//----------------------------------------------------------
void RECORD_Score_Add(RECORD * rec, int id)
{
	u32 score;
	
	GF_ASSERT(id < SCOREID_MAX);
	
	//JXg`FbN
	score = RECORD_Get(rec, RECID_SCORE);
	if ( score+get_score_number(id) > SCORE_MAX ){
		RECORD_Set(rec, RECID_SCORE, SCORE_MAX);
	}else{
		RECORD_Add(rec, RECID_SCORE, get_score_number(id));
	}
}


//----------------------------------------------------------
/**
 * @brief	XRA̎擾
 * @param	rec		RECORDւ̃|C^
 * @return	u32		݂̃XRA
 */
//----------------------------------------------------------
u32 RECORD_Score_Get(const RECORD * rec)
{
	return RECORD_Get(rec, RECID_SCORE);
}

//----------------------------------------------------------
/**
 * @brief	}ӃXRẢZ
 * @param	rec		RECORDւ̃|C^
 * @param	zw		񃏁[Nւ̃|C^
 * @param	monsno	|Pio[
 */
//----------------------------------------------------------
void RECORD_Score_AddZukanScore(RECORD * rec, const ZUKAN_WORK * zw, u16 const inMonsno)
{
	if ( !ZukanWork_GetPokeGetFlag(zw, inMonsno) ){
		RECORD_Score_Add(rec, SCORE_ID_ZUKAN_ENTRY);
	}
}

#ifdef PM_DEBUG
//----------------------------------------------------------
/**
 * @brief	XRÃZbg
 * @param	rec		RECORDւ̃|C^
 * @param	inScore	ZbgXRA
 */
//----------------------------------------------------------
void RECORD_Score_DebugSet(RECORD * rec, const u32 inScore)
{
	u32 score;

	score = inScore;
	
	//JXg`FbN
	if ( score > SCORE_MAX ){
		score = SCORE_MAX;
	}

	RECORD_Set(rec, RECID_SCORE, score);
}

#endif	//PM_DEBUG


