//============================================================================================
/**
 * @file	regulation_data.c
 * @brief	ogM[Vf[^ANZXp\[X
 * @author	k.ohno
 * @date	2006.5.24
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/regulation.h"
#include "regulation_local.h"

#include "system/pm_str.h"

#include "gflib/strbuf_family.h"

#include "msgdata/msg.naix"
#include "system/wordset.h"
#include "msgdata/msg_directbattlecorner.h"

#include "savedata/regulation_data.h"

//============================================================================================
//============================================================================================

REGULATION _cup[] = {
    {
        {EOM_},  //  // X^_[hJbv OgmmĂ
        0,     // vȂ
        3,      // 3C
        50,     // LV50
        0,      // gȂ
        0,      // ̏dȂ
        1,      // i|POK
        0,      // s
        0,      // |Ps
        0,      // s
        0,// Œ_[WZKs
    },
    {
        {EOM_},// t@V[Jbv
        80,//x̍vWO܂
        3,//RC
        30,//|P̃xRO܂
        -20,//gQDO
        -20,// ̏dQO
        0,// i|PQłȂ
        0,// ʂȃ|PQłȂ
        0,// |PQłȂ
        0,// Ȃ
        0,// Œ_[WZKs
    },
    {
        {EOM_},// gJbv
        0,//x̍vȂ
        3,//RC
        5,//|P̃xT܂
        0,// gȂ
        0,// ̏dȂ
        0,// i|PQłȂ
        0,// ʂȃ|PQłȂ
        0,// |PQłȂ
        0,// Ȃ 
        1,//ʃ[Fイ̂A\jbNu[̖OɂȂB
    },
    {
        {EOM_},// CgJbv
        0,//x̍vȂ
        3,//RC
        50,//|P̃xTO܂
        0,// gȂ
        -99,// ̏dXX
        0,// i|PQłȂ
        0,// ʂȃ|PQłȂ
        0,// |PQłȂ
        0,// Ȃ
        0,// Œ_[WZKs
    },
    {
        {EOM_},// _uJbv
        0,//@Ex̍v
        4,//ERC
        50,//@E|P̃xTO܂
        0,//E gȂ
        0,//E ̏dXX傤
        1,//E i|PQł
        0,//E ʂȃ|PQłȂ
        0,//E |PQłȂ
        0,//E Ȃ
        0,// Œ_[WZKs
    },
};


//----------------------------------------------------------
/**
 * @brief	M[Vf[^ւ̃|C^擾
 * @param	Z[uf[^ێ[Nւ̃|C^
 * @param	{ڂ̃M[Vf[^
 * @return	REGULATION	[Nւ̃|C^
 */
//----------------------------------------------------------
const REGULATION* Data_GetRegulation(SAVEDATA* pSave, int regNo)
{
	REGULATION_DATA* pRegData = NULL;

    if(regNo < NELEMS(_cup)){
        return &_cup[regNo];
    }
    pRegData = SaveData_Get(pSave, GMDATA_ID_REGULATION);
    return &pRegData->regulation_buff[0];  // Z[uf[^ɂ1{Ȃ
}

//----------------------------------------------------------
/**
 * @brief	M[Vf[^ւ̃|C^擾
 * @param	Z[uf[^ێ[Nւ̃|C^
 * @param	{ڂ̃M[Vf[^
 * @param	REGULATION	[Nւ̃|C^
 */
//----------------------------------------------------------
void Data_GetRegulationName(SAVEDATA* pSave, int regNo, STRBUF* pStrBuff, int HeapID)
{
    MSGDATA_MANAGER* msgman;
	REGULATION_DATA* pRegData = NULL;

    if(regNo < NELEMS(_cup)){
		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_directbattlecorner_dat, HeapID);
        MSGMAN_GetString(msgman, msg_dbc_rule01+regNo, pStrBuff);
        MSGMAN_Delete(msgman);
    }
    else{
        Regulation_GetCupName(SaveData_GetRegulation(pSave,0), pStrBuff);
    }
}

