//============================================================================================
/**
 * @file	savedata.c
 * @brief	Z[uf[^Ǘ
 * @author	tamada	GAME FREAK Inc.
 * @date	2005.10.12
 *
 * @li		2006.04.17	Z[u[hVXesaveload_system.cɕ
 */
//============================================================================================

#include "common.h"
#include "gflib/system.h"


#include "system/gamedata.h"

#include "savedata/savedata.h"
#include "savedata_local.h"


//Z[uf[^êɕKvȊ֐QƂ̂߂̃wb_

#include "poketool/poke_tool.h"
#include "../poketool/poke_tool_def.h"

#include "savedata/system_data.h"
#include "playerdata_local.h"
#include "poketool/pokeparty.h"
#include "itemtool/myitem.h"
#include "field/eventflag.h"
#include "field/poketch_data.h"
#include "field/situation.h"
#include "savedata/zukanwork.h"
#include "savedata/sodateyadata.h"
#include "savedata/friendlist.h"
#include "savedata/undergrounddata.h"
#include "savedata/regulation.h"
#include "savedata/imageclip_data.h"
#include "savedata/honeytree_data.h"
#include "savedata/wifilist.h"
#include "savedata/randomgroup.h"
#include "savedata/fnote_mem.h"
#include "savedata/trainercard_data.h"
#include "savedata/wifihistory.h"

#include "savedata/mail_util.h"
#include "savedata/poruto_util.h"
#include "poketool/boxdata.h"
#include "savedata/record.h"
#include "savedata/guinness.h"

#include "savedata/custom_ball.h"
#include "savedata/contest_savedata.h"

#include "savedata/misc.h"
#include "misc_local.h"

#include "savedata/perapvoice.h"
#include "savedata/perapvoice_local.h"
#include "savedata/b_tower.h"
#include "savedata/b_tower_local.h"

#include "savedata/sp_ribbon.h"
#include "savedata/dendou_data.h"
#include "savedata/encount.h"
#include "savedata/fushigi_data.h"
#include "savedata/worldtrade_data.h"
#include "savedata/tv_work.h"
#include "savedata/pokepark_data.h"
#include "system/pms_word.h"


//=============================================================================
//=============================================================================

//============================================================================================
//
//
//		f[^
//
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^e`
 */
//---------------------------------------------------------------------------
const SAVEDATA_TABLE SaveDataTable[] = {
//m[}f[^O[v
	{	//VXef[^
		GMDATA_ID_SYSTEM_DATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)SYSTEMDATA_GetWorkSize,
		(FUNC_INIT_WORK)SYSTEMDATA_Init,
	},
	{	//vC[f[^
		GMDATA_ID_PLAYER_DATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)PLAYERDATA_GetWorkSize,
		(FUNC_INIT_WORK)PLAYERDATA_Init,
	},
	{	//莝|P
		GMDATA_ID_TEMOTI_POKE,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)PokeParty_GetWorkSize,
		(FUNC_INIT_WORK)PokeParty_InitWork,
	},
	{	//莝ǂ
		GMDATA_ID_TEMOTI_ITEM,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)MyItem_GetWorkSize,
		(FUNC_INIT_WORK)MyItem_Init,
	},
	{	//Cxg[N
		GMDATA_ID_EVENT_WORK,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)EventWork_GetWorkSize,
		(FUNC_INIT_WORK)EventWork_Init,
	},
	{	//|Pb`f[^
		GMDATA_ID_POKETCH_DATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)PoketchData_GetWorkSize,
		(FUNC_INIT_WORK)PoketchData_Init,
	},
	{	//󋵃f[^
		GMDATA_ID_SITUATION,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)Situation_GetWorkSize,
		(FUNC_INIT_WORK)Situation_Init,
	},
	{	//f[^
		GMDATA_ID_ZUKANWORK,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)ZukanWork_GetWorkSize,
		(FUNC_INIT_WORK)ZukanWork_Init,
	},
	{	//ĉf[^
		GMDATA_ID_SODATEYA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)SodateyaWork_GetWorkSize,
		(FUNC_INIT_WORK)SodateyaWork_Init,
	},
	{	//肠O[v
		GMDATA_ID_FRIEND,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)FriendList_GetWorkSize,
		(FUNC_INIT_WORK)FriendList_Init,
	},
	{	//̑f[^
		GMDATA_ID_MISC,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)MISC_GetWorkSize,
		(FUNC_INIT_WORK)MISC_Init,
	},
	{	//tB[hOBJZ[u
		GMDATA_ID_FIELDOBJSV,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)FieldObjSv_GetWorkSize,
		(FUNC_INIT_WORK)FieldObjSv_Init,
	},
	{	//nACef[^+閧nf[^
		GMDATA_ID_UNDERGROUNDDATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)UnderGroundData_GetWorkSize,
		(FUNC_INIT_WORK)UnderGroundData_Init,
	},
    {  // M[Vf[^
        GMDATA_ID_REGULATION,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)RegulationData_GetWorkSize,
		(FUNC_INIT_WORK)RegulationData_Init,
    },
	{	//C[WNbṽf[^
		GMDATA_ID_IMAGECLIPDATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)ImcSaveData_GetWorkSize,
		(FUNC_INIT_WORK)ImcSaveData_Init,
	},
	{	//[̃f[^
		GMDATA_ID_MAILDATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)MAIL_GetBlockWorkSize,
		(FUNC_INIT_WORK)MAIL_Init,
	},
	{	//|g̃f[^
		GMDATA_ID_PORUTODATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)PORUTO_GetSaveWorkSize,
		(FUNC_INIT_WORK)PORUTO_Init,
	},
	{	// ̎O[v
		GMDATA_ID_RANDOMGROUP,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)RandomGroup_GetWorkSize,
		(FUNC_INIT_WORK)RandomGroup_Init,
	},
	{	//`m[g̃f[^
		GMDATA_ID_FNOTE,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)FNOTE_GetWorkSize,
		(FUNC_INIT_WORK)FNOTE_InitAll,
	},
	{	//g[i[J[h
		GMDATA_ID_TRCARD,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)TRCSave_GetSaveDataSize,
		(FUNC_INIT_WORK)TRCSave_InitSaveData,
	},
	{	//R[hpJEgAbvf[^
		GMDATA_ID_RECORD,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)RECORD_GetWorkSize,
		(FUNC_INIT_WORK)RECORD_Init,
	},
	{	//JX^{[
		GMDATA_ID_CUSTOM_BALL,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)CustomBall_GetWorkSize,
		(FUNC_INIT_WORK)CustomBall_Init,
	},
	{	//؃bvf[^
		GMDATA_ID_PERAPVOICE,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)PERAPVOICE_GetWorkSize,
		(FUNC_INIT_WORK)PERAPVOICE_Init,
	},
	{	//og^[f[^
		GMDATA_ID_BTLTOWER,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)TowerData_GetWorkSize,
		(FUNC_INIT_WORK)TowerData_Init,
	},
	{	//zz{f[^
		GMDATA_ID_SP_RIBBON,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)SP_RIBBON_GetWorkSize,
		(FUNC_INIT_WORK)SP_RIBBON_Init,
	},
	{
		// GJEg֘Af[^
		GMDATA_ID_ENCOUNT,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)EncDataSave_GetWorkSize,
		(FUNC_INIT_WORK)EncDataSave_InitSaveData,
	},
	{	//Ef[^
		GMDATA_ID_WORLDTRADEDATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)WorldTradeData_GetWorkSize,
		(FUNC_INIT_WORK)WorldTradeData_Init,
	},
	{	//TVf[^
		GMDATA_ID_TVWORK,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)TVWORK_GetWorkSize,
		(FUNC_INIT_WORK)TVWORK_Init,
	},
	{	//MlXz[f[^
		GMDATA_ID_GUINNESS,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)GuinnessData_GetWorkSize,
		(FUNC_INIT_WORK)GuinnessData_Init,
	},
	{	// WifipAEFB
		GMDATA_ID_WIFILIST,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)WifiList_GetWorkSize,
		(FUNC_INIT_WORK)WifiList_Init,
	},

	{	//WiFiʐMf[^
		GMDATA_ID_WIFIHISTORY,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)WIFIHISTORY_GetWorkSize,
		(FUNC_INIT_WORK)WIFIHISTORY_Init,
	},
	{	//ӂȑ蕨f[^
		GMDATA_ID_FUSHIGIDATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)FUSHIGIDATA_GetWorkSize,
		(FUNC_INIT_WORK)FUSHIGIDATA_Init,
	},
	{	//|Pp[Np|Pf[^
		GMDATA_ID_POKEPARKDATA,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)POKEPARKDATA_GetWorkSize,
		(FUNC_INIT_WORK)POKEPARKDATA_Init,
	},
	{	//ReXg
		GMDATA_ID_CONTEST,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)CONDATA_GetWorkSize,
		(FUNC_INIT_WORK)CONDATA_Init,
	},
	{	// ȈՉbP
		GMDATA_ID_PMS,
		SVBLK_ID_NORMAL,
		(FUNC_GET_SIZE)PMSW_GetSaveDataSize,
		(FUNC_INIT_WORK)PMSW_InitSaveData,
	},
//{bNXf[^O[v
	{	//|P{bNX̃f[^
		GMDATA_ID_BOXDATA,
		SVBLK_ID_BOX,
		(FUNC_GET_SIZE)BOXDAT_GetTotalSize,
		(FUNC_INIT_WORK)BOXDAT_Init,
	},

};

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
const int SaveDataTableMax = NELEMS(SaveDataTable);



//============================================================================================
//
//
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	erf[^̃|C^擾
 * @param	sv			Z[uf[^\ւ̃|C^
 * @return	BOX_DATA	erf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
TV_WORK * SaveData_GetTvWork(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_TVWORK);
}

//---------------------------------------------------------------------------
/**
 * @brief	{bNXf[^̃|C^擾
 * @param	sv			Z[uf[^\ւ̃|C^
 * @return	BOX_DATA	{bNXf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
BOX_DATA * SaveData_GetBoxData(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_BOXDATA);
}

//---------------------------------------------------------------------------
/**
 * @brief	ӂȑ蕨pZ[uf[^ւ̃|C^擾
 * @param	sv				Z[uf[^\ւ̃|C^
 * @return	FUSHIGI_DATA	ӂȑ蕨f[^ւ̃|C^
 */
//---------------------------------------------------------------------------
FUSHIGI_DATA * SaveData_GetFushigiData(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_FUSHIGIDATA);
}

//---------------------------------------------------------------------------
/**
 * @brief	|Pp[NpZ[uf[^ւ̃|C^擾
 * @param	sv				Z[uf[^\ւ̃|C^
 * @return	POKEPARK_DATA	|Pp[NpZ[uf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
POKEPARK_DATA * SaveData_GetPokeParkData(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_POKEPARKDATA);
}

//============================================================================================
//
//
//			Z[uf[^
//
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̒`e[u
 */
//---------------------------------------------------------------------------
const EXSAVEDATA_TABLE ExtraSaveDataTable[] = {
	{
		// af[^
		EXDATA_ID_DENDOU,
		SAVE_PAGE_MAX + 0,
		(FUNC_GET_SIZE)DendouData_GetWorkSize,
		(FUNC_INIT_WORK)DendouData_Init,
	},

	{	//ӂ蕨f[^
		EXDATA_ID_FUSHIGIDATA,
		SAVE_PAGE_MAX + 3,
		(FUNC_GET_SIZE)FUSHIGIDATA_GetWorkSize,
		(FUNC_INIT_WORK)FUSHIGIDATA_Init,
	},

};
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̃e[u
 */
//---------------------------------------------------------------------------
const int ExtraSaveDataTableMax = NELEMS(ExtraSaveDataTable);



//============================================================================================
//
//
//			ʂ̓Z[uf[^ANZX֐
//
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^[hFaf[^
 * @param	sv			Z[uf[^\ւ̃|C^
 * @param	heap_id		[N擾q[vID
 * @param	result
 * @return	void *	擾Z[uf[^ڂ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
DENDOU_SAVEDATA * SaveData_Extra_LoadDendouData(SAVEDATA * sv, int heap_id, LOAD_RESULT * result)
{
	return SaveData_Extra_LoadAlloc(sv, heap_id, EXDATA_ID_DENDOU, result);
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^Z[uFaf[^
 * @param	sv			Z[uf[^\ւ̃|C^
 * @param	data		af[^ւ̃|C^
 * @retval	SAVE_RESULT_OK		Z[u
 * @retval	SAVE_RESULT_NG		Z[us
 */
//---------------------------------------------------------------------------
SAVE_RESULT SaveData_Extra_SaveDendouData(SAVEDATA * sv, DENDOU_SAVEDATA * data)
{
	return SaveData_Extra_Save(sv, EXDATA_ID_DENDOU, data);
}


#if 0

ʏZ[uf[^Ɋ܂܂悤ɂȂ߂ɍ폜

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^[hFӂȂ
 * @param	sv			Z[uf[^\ւ̃|C^
 * @param	heap_id		[N擾q[vID
 * @param	result		[hʎ擾p̃[N
 * @return	void *	擾Z[uf[^ڂ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
FUSHIGI_DATA * SaveData_Extra_LoadFushigiData(SAVEDATA * sv, int heap_id, LOAD_RESULT * result)
{
	return SaveData_Extra_LoadAlloc(sv, heap_id, EXDATA_ID_FUSHIGIDATA, result);
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^Z[uFӂȂ
 * @param	sv			Z[uf[^\ւ̃|C^
 * @param	data		af[^ւ̃|C^
 * @retval	SAVE_RESULT_OK		Z[u
 * @retval	SAVE_RESULT_NG		Z[us
 */
//---------------------------------------------------------------------------
SAVE_RESULT SaveData_Extra_SaveFushigiData(SAVEDATA * sv, FUSHIGI_DATA * data)
{
	return SaveData_Extra_Save(sv, EXDATA_ID_FUSHIGIDATA, data);
}
#endif


