//============================================================================================
/**
 * @file	sodateyadata.c
 * @brief	}ӏԃANZXp\[X
 * @author	mori GAME FREAK inc.
 * @date	2005.12.21
 */
//============================================================================================

// fobOpɃ^}Šʂ݂̂̒lɂ
//#define EGG_PERSONAL_RND_TEST


#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/mail.h"

#include "savedata/savedata.h"

#include "poketool/poke_tool.h"
#include "poketool/poke_tool_def.h"
#include "savedata/sodateyadata.h"

#include "poketool/monsno.h"

//============================================================================================
//============================================================================================

//----------------------------------------------------------
/**
 * @brief	ĉf[^^`
 */
//----------------------------------------------------------

// ʐM[
struct SIO_MAIL_DATA{									//R[hR[i[Ή[\
	MAIL_DATA	Mail;									//[f[^
	STRCODE oyaname[PERSON_NAME_SIZE+1];				//[̖̎O
	STRCODE pokename[MONS_NAME_SIZE+1];					//[̂Ă|P̖O
	u8 bLang:4;
	u8 bLangPoke:4;
};

// ĉ|P̕
struct SODATEYA_POKE{
	POKEMON_PASO_PARAM	Poke;							///<aĂ|P
	SIO_MAIL_DATA		Mail;                   		///<R[hR[i[p[\
	u32					WalkCount;              		///<JEg
};

// ĉ[N
struct SODATEYA_WORK{
	SODATEYA_POKE		SodatePoke[SODATEYA_POKE_MAX];	///<ĉ|P[N
	u32					Egg;							///<^}S(0= 0ȊO=L=̃^l
	u8					EggCount;						///<^}SzJEg
};




//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ĉf[^p[ÑTCY擾
 * @return	int		ZUKAN_WORK̃TCY
 */
//----------------------------------------------------------
int SodateyaWork_GetWorkSize(void)
{
	return sizeof(SODATEYA_WORK);
}
//----------------------------------------------------------
/**
 * @brief	ĉf[^p[N̐
 * @param	heapID		gpq[v̎w
 * @return	ZUKAN_WORK	SODATEAYA_WORKւ̃|C^
 */
//----------------------------------------------------------
SODATEYA_WORK * SodateyaWork_AllocWork(u32 heapID)
{
	SODATEYA_WORK * sw;
	sw = sys_AllocMemory(heapID, sizeof(SODATEYA_WORK));
	SodateyaWork_Init(sw);
	return sw;
}

//----------------------------------------------------------
/**
 * @brief	ĉf[^p[ÑRs[
 * @param	from	Rs[ZUKAN_WORKւ̃|C^
 * @param	to		Rs[ZUKAN_WORKւ̃|C^
 */
//----------------------------------------------------------
void SodateyaWork_Copy(const SODATEYA_WORK * from, SODATEYA_WORK * to)
{
	MI_CpuCopy8(from, to, sizeof(SODATEYA_WORK));
}

//============================================================================================
//
//				֐
//
//============================================================================================

//============================================================================================
//
//			ĉf[^񑀍p̊OJ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief		ĉ[N̏
 * @param	zw	ĉ[Nւ̃|C^
 */
//----------------------------------------------------------
void SodateyaWork_Init(SODATEYA_WORK * sw)
{
	memset(sw, 0, sizeof(SODATEYA_WORK));

	PokePasoParaInit(&sw->SodatePoke[0].Poke);
	PokePasoParaInit(&sw->SodatePoke[1].Poke);

	sw->Egg      = 0;
	sw->EggCount = 0;
}


//==============================================================================
/**
 * aĂPOKE_PASO_PARAM̃|C^Ԃ
 *
 * @param   sw		ĉ[Nւ̃|C^
 *
 * @retval  int		aĂ|P̐
 */
//==============================================================================
SODATEYA_POKE *SodateyaWork_GetSodateyaPokePointer( SODATEYA_WORK *sw, int no )
{
	return &(sw->SodatePoke[no]);
}

//==============================================================================
/**
 * aĂPOKE_PASO_PARAM̃|C^Ԃ
 *
 * @param   sw		ĉ[Nւ̃|C^
 *
 * @retval  int		aĂ|P̐
 */
//==============================================================================
POKEMON_PASO_PARAM *SodateyaPoke_GetPokePasoPointer( SODATEYA_POKE *sp )
{
	return &(sp->Poke);
}


SIO_MAIL_DATA *SodateyaPoke_GetSioMailPointer( SODATEYA_POKE *sp )
{
	return &(sp->Mail);
}

//==============================================================================
/**
 * |Paĉڂ̎擾
 *
 * @param   sw		
 * @param   no		
 *
 * @retval  int		
 */
//==============================================================================
u32 SodateyaPoke_GetWalkCount( const SODATEYA_POKE *sp )
{
	return sp->WalkCount;
}




//==============================================================================
/**
 * ĉ|Pf[^ʐMp[f[^|C^擾
 *
 * @param   mail		
 *
 * @retval  MAIL_DATA *		
 */
//==============================================================================
MAIL_DATA *SodateyaMail_GetMailPointer( SIO_MAIL_DATA *mail )
{
	return &(mail->Mail);
}

//==============================================================================
/**
 * ʐMp[f[^̒疼O擾
 *
 * @param   mail		
 * @param   flag		SIOMAIL_FLAG_OYA(ejSIOMAIL_FLAG_POKE(|Pj
 *
 * @retval  STRCODE *		
 */
//==============================================================================
STRCODE *SodateyaMail_GetNamePointer( SIO_MAIL_DATA *mail, int flag )
{
	if( flag == SIOMAIL_FLAG_OYA ){
		return mail->oyaname;
	}
	// SIOMAIL_FLAG_POKE
	return mail->pokename;
}

//==============================================================================
/**
 * ĉ[̒ɂ閼O̍R[h擾
 *
 * @param   mail		
 * @param   flag		SIOMAIL_FLAG_OYA(ejSIOMAIL_FLAG_POKE(|Pj
 *
 * @retval  int		
 */
//==============================================================================
int SodateyaMail_GetLanguage( SIO_MAIL_DATA *mail, int flag )
{
	if( flag == SIOMAIL_FLAG_OYA ){
		return mail->bLang;
	}
	// SIOMAIL_FLAG_POKE
	return mail->bLangPoke;
	
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/05/11

/* ĉ̃^}StO̎łȂ߁A
   |Pb`ƃXNvgu16u8Ŏ擾ĂOPŔ肵Ă܂Ă̂
   ĉ̕ŏC邱Ƃɂ */

#if AFTER_MASTER_SODATEYA_EGGFLAG_FIX
//==============================================================================
/**
 * ^}S܂Ă邩̎擾
 *
 * @param   sw		ĉ[N
 *
 * @retval  int		^}S܂Ă΂PAȂ΂O
 */
//==============================================================================
int SodateyaWork_GetEggFlag( const SODATEYA_WORK *sw )
{
	// ^}S̗i[Ă΂P
	if(sw->Egg!=0){
		return 1;
	}
	// 0^}S͐܂ĂȂ
	return 0;
}

//==============================================================================
/**
 * @brief   ܂ꂽ^}Sp̌̎擾
 *
 * @param   sw		
 *
 * @retval  int		0:^}S  0ȊO:܂|Pp̌
 */
//==============================================================================
int SodateyaWork_GetEggPersonalRnd( const SODATEYA_WORK *sw )
{
	return sw->Egg;
}

#else

//==============================================================================
/**
 * ^}S܂Ă邩̎擾
 *
 * @param   sw		
 *
 * @retval  int		0:^}S  0ȊO:܂|Pp̌
 */
//==============================================================================
int SodateyaWork_GetEggFlag( const SODATEYA_WORK *sw )
{
		return sw->Egg;
}

#endif

// ----------------------------------------------------------------------------

//==============================================================================
/**
 * z̎擾
 *
 * @param   sw		
 *
 * @retval  int		0255Ń[v
 */
//==============================================================================
int SodateyaWork_GetEggCount( const SODATEYA_WORK *sw )
{
	return sw->EggCount;
}


//==============================================================================
//==============================================================================
//==============================================================================
//
// ݒ֐Q
//
//==============================================================================



//==============================================================================
/**
 * POKE_PASO_PARAMRs[
 *
 * @param   sw		ĉ[Nւ̃|C^
 *
 * @retval  int		aĂ|P̐
 */
//==============================================================================
void SodateyaWork_CopyPokePasoParam( SODATEYA_WORK *sw, const POKEMON_PARAM *pp, int no )
{
	sw->SodatePoke[no].Poke = pp->ppp;


//	memcpy(&(sw->SodatePoke[no].Poke), &(pp->ppp), PokemonPasoParamSizeGet());
}

//==============================================================================
/**
 * |Paĉڂݒ
 *
 * @param   sw		
 * @param   no		
 *
 * @retval  int		|P̗aĂ
 */
//==============================================================================
void SodateyaPoke_SetWalkCount( SODATEYA_POKE *sp, int num )
{
	sp->WalkCount = num;
}

//==============================================================================
/**
 * JEgionj𑫂
 *
 * @param   sp		
 * @param   num		
 *
 * @retval  none		
 */
//==============================================================================
void SodateyaPoke_AddWalkCount( SODATEYA_POKE *sp, int num )
{
	sp->WalkCount += num;
}


//==============================================================================
/**
 * ^}S܂Ă邩ݒ(ݒ肷j
 *
 * @param   sw		
 * @param   flag	i0:^}S͖ 0ȊO:܂^}Šj
 *
 * @retval  none
 */
//==============================================================================
void SodateyaWork_SetEggFlag( SODATEYA_WORK *sw, int Flag)
{
#ifdef EGG_PERSONAL_RND_TEST
	sw->Egg = Flag&0xffff0000;
#else
	sw->Egg = Flag;
#endif
}

//==============================================================================
/**
 * z̐ݒ
 *
 * @param   sw		
 *
 * @retval  none
 */
//==============================================================================
void SodateyaWork_SetEggCount( SODATEYA_WORK *sw, int Count )
{
	sw->EggCount = Count;
}


//==============================================================================
/**
 * @brief   ĉɗaĂ|PɈႤ̃|P邩H
 *
 * @param   sw		
 *
 * @retval  BOOL	TRUE:Ⴄ|PaĂ
 */
//==============================================================================
BOOL  SodateyaWork_GetRareFlag( SODATEYA_WORK *sw )
{
	int country1, country2;
	country1 = PokePasoParaGet( &sw->SodatePoke[0].Poke, ID_PARA_country_code, NULL);
	country2 = PokePasoParaGet( &sw->SodatePoke[1].Poke, ID_PARA_country_code, NULL);

	// ̂QC͈ႤR[h̃|PH
	if(country1!=country2){
		return TRUE;
	}
	
	return FALSE;
}

//==============================================================================
/**
 * @brief   ĉ̃|PRs[
 *
 * @param   des		
 * @param   src		
 *
 * @retval  none		
 */
//==============================================================================
void SodateyaPoke_Copy( SODATEYA_POKE *des, const SODATEYA_POKE *src)
{
	*des = *src;
}



// =================================================================
/**
 * @brief ʐM[\̏
 * @param  smd
 * @retval  none
 */
// =================================================================
void SioMailDataInit( SIO_MAIL_DATA	*smd )
{
	int i;
	
	//e̖O
	for(i=0;i<PERSON_NAME_SIZE+EOM_SIZE;i++) {
		smd->oyaname[i] = 0;						
	}


	//|P̖O
	for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){	
		smd->pokename[i] = 0;						
	}
	smd->oyaname[0]  = EOM_;
	smd->pokename[0] = EOM_;



}

//--------------------------------------------------------------------------
/**
 * ĉ|Pf[^
 *
 * @param   poke		
 *
 * @retval  none		
 *
 *
 */
//--------------------------------------------------------------------------
void SodateyaPoke_Init(SODATEYA_POKE *poke)
{

	PokePasoParaInit(&poke->Poke);
	poke->WalkCount = 0;
	SioMailDataInit(&poke->Mail);
	
}


//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	ZUKAN_WORK	񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
SODATEYA_WORK * SaveData_GetSodateyaWork(SAVEDATA * sv)
{
	SODATEYA_WORK * sw;
	sw = SaveData_Get(sv, GMDATA_ID_SODATEYA);
	return sw;
}

//============================================================================================
//============================================================================================



