//============================================================================================
/**
 * @file	system_data.c
 * @brief	ރZ[uf[^̃ANZX
 * @author	tamada	GAME FREAK Inc.
 * @date	2006.01.26
 *
 */
//============================================================================================

#include "savedata/savedata.h"
#include "savedata/system_data.h"

#include "gflib/assert.h"

//#include "common.h"
//#include "gflib/system.h"

//#include "system/gamedata.h"

//#include "savedata/savedata.h"

#include "savedata/gametime.h"




//============================================================================================
//============================================================================================

//---------------------------------------------------------------------------
/**
 * @brief	SYSTEMDATA\̂̒`
 *
 */
//---------------------------------------------------------------------------
struct SYSTEMDATA {
	s64 RTCOffset;			///<DS{̂RTCItZbgiRTC𑀍삵lj
	u8 MacAddress[6];		///<DS{̂MACAhX
	u8 birth_month;			///<DS{̂ɃvC[͂a
	u8 birth_day;			///<DS{̂ɃvC[͂a
	GMTIME gametime;		///<Q[ԃf[^ւ̃|C^
	u8 WiFiMPOpenFlag;		///<Wi-Fisvcȑ蕨I[vtO
	u8 BeaconMPOpenFlag;	///<r[Rsvcȑ蕨I[vtO
	s32 profileId;			///< GTSEWifiog^[OCpGameSpyIDi߂Ď擾GameSpyIdۑj
	u32 reserve[3];			///<\̈
};

//============================================================================================
//
//		ɃZ[uVXeĂ΂֐
//
//============================================================================================

//---------------------------------------------------------------------------
/**
 * @brief	SYSTEMDATA\̂̃TCY擾
 * @return	int		SYSTEMDATA\̂̃TCY
 */
//---------------------------------------------------------------------------
int SYSTEMDATA_GetWorkSize(void)
{
	return sizeof(SYSTEMDATA);
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^
 * @param	sys		VXeZ[uf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
void SYSTEMDATA_Init(SYSTEMDATA * sys)
{
	MI_CpuClearFast(sys, sizeof(SYSTEMDATA));
	GMTIME_Init(&sys->gametime);	//Ô
}


//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	VXef[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	SYSTEMDATA	VXef[^[Nւ̃|C^
 */
//---------------------------------------------------------------------------
SYSTEMDATA * SaveData_GetSystemData(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_SYSTEM_DATA);
}

//---------------------------------------------------------------------------
/**
 * @brief	Q[ԃ[Nւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	GMTIME		Q[ԗp[Nւ̃|C^@
 */
//---------------------------------------------------------------------------
GMTIME * SaveData_GetGameTime(SAVEDATA * sv)
{
	SYSTEMDATA * system;

	system = SaveData_GetSystemData(sv);
	return &system->gametime;
}

//============================================================================================
//
//			VXe񑀍EQƊ֐
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	݂DS񂩂VXef[^XV
 */
//---------------------------------------------------------------------------
void SYSTEMDATA_Update(SYSTEMDATA * sysdt)
{
	OSOwnerInfo info;
	sysdt->RTCOffset = OS_GetOwnerRtcOffset();
	OS_GetMacAddress(sysdt->MacAddress);
	OS_GetOwnerInfo(&info);
	sysdt->birth_month = info.birthday.month;
	sysdt->birth_day = info.birthday.day;
}

//---------------------------------------------------------------------------
/**
 * @brief	ێĂMACAhXƌ݂DSMACAhXr
 * @param	sysdt		VXef[^ւ̃|C^
 * @retval	TRUE		MACAhXv
 * @retval	FALSE		MACAhXvȂ
 */
//---------------------------------------------------------------------------
BOOL SYSTEMDATA_IdentifyMACAddress(const SYSTEMDATA * sysdt)
{
	int i;
	u8 adr[6];
	OS_GetMacAddress(adr);
	for (i = 0; i < 6; i++) {
		if (sysdt->MacAddress[i] != adr[i]) {
			return FALSE;
		}
	}
	return TRUE;
}

//---------------------------------------------------------------------------
/**
 * @brief	MACAhX̎擾
 * @param	sysdt		VXef[^ւ̃|C^
 * @return	u8 * MACAhXzւ̃|C^
 */
//---------------------------------------------------------------------------
const u8 * SYSTEMDATA_GetMacAddress(const SYSTEMDATA * sysdt)
{
	return sysdt->MacAddress;
}

//---------------------------------------------------------------------------
/**
 * @brief	ێĂRTCItZbgƌ݂DSRTCItZbgr
 * @param	sysdt		VXef[^ւ̃|C^
 * @retval	TRUE		RTCItZbgv
 * @retval	FALSE		RTCItZbgvȂ
 */
//---------------------------------------------------------------------------
BOOL SYSTEMDATA_IdentifyRTCOffset(const SYSTEMDATA * sysdt)
{
	return (OS_GetOwnerRtcOffset() == sysdt->RTCOffset);
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
u8 SYSTEMDATA_GetBirthMonth(const SYSTEMDATA * sysdt)
{
	return sysdt->birth_month;
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
u8 SYSTEMDATA_GetBirthDay(const SYSTEMDATA * sysdt)
{
	return sysdt->birth_day;
}

//---------------------------------------------------------------------------
/**
 * @brief	Wi-Fisvcȑ蕨I[vtO̎擾
 * @param	sysdt		VXef[^ւ̃|C^
 * @retval	BOOL
 */
//---------------------------------------------------------------------------
BOOL SYSTEMDATA_GetBeaconMPOpenFlag(const SYSTEMDATA * sysdt)
{
	return sysdt->BeaconMPOpenFlag;
}

//---------------------------------------------------------------------------
/**
 * @brief	Wi-Fisvcȑ蕨I[vtO̎擾
 * @param	sysdt		VXef[^ւ̃|C^
 * @param	flag		ZbgBOOLl
 */
//---------------------------------------------------------------------------
void SYSTEMDATA_SetBeaconMPOpenFlag(SYSTEMDATA * sysdt, BOOL flag)
{
	sysdt->BeaconMPOpenFlag = flag;
}

//---------------------------------------------------------------------------
/**
 * @brief	Wi-Fisvcȑ蕨I[vtO̎擾
 * @param	sysdt		VXef[^ւ̃|C^
 * @retval	BOOL
 */
//---------------------------------------------------------------------------
BOOL SYSTEMDATA_GetWifiMPOpenFlag(const SYSTEMDATA * sysdt)
{
	return sysdt->WiFiMPOpenFlag;
}

//---------------------------------------------------------------------------
/**
 * @brief	Wi-Fisvcȑ蕨I[vtO̎擾
 * @param	sysdt		VXef[^ւ̃|C^
 * @param	flag		ZbgBOOLl
 */
//---------------------------------------------------------------------------
void SYSTEMDATA_SetWifiMPOpenFlag(SYSTEMDATA * sysdt, BOOL flag)
{
	sysdt->WiFiMPOpenFlag = flag;
}


//---------------------------------------------------------------------------
/**
 * @brief	GTSEWifiog^[pId̎擾
 * @param	sysdt		VXef[^ւ̃|C^
 * @param	profileId	[out]GameSpyvt@CIDo͂|C^
 * @param	FriendKey	[out]ƂR[ho͂|C^
 * @param	u64			ƂR[h̒li߂Ď擾FriendKeyƕێj
 */
//---------------------------------------------------------------------------
s32 SYSTEMDATA_GetDpwInfo( const SYSTEMDATA * sysdt )
{

	return sysdt->profileId;

}

//---------------------------------------------------------------------------
/**
 * @brief	GTSEWifiog^[pId̐ݒ(̂ݑłj
 * @param	sysdt		VXef[^ւ̃|C^
 * @param	none
 */
//---------------------------------------------------------------------------
void SYSTEMDATA_SetDpwInfo( SYSTEMDATA * sysdt, s32 profileId )
{

	// GTSEWifiog^[pIDEƂR[h
	// o^ĂȂꍇo^
	if( sysdt->profileId==0 ){

		// xo^AGameSpyIdύXɂȂĂςȂ
		sysdt->profileId = profileId;

	}
}

//============================================================================================
//
//
//			Q[ԎQƁE֐
//
//
//============================================================================================
#include "system/pm_rtc.h"
//------------------------------------------------------------------
/**
 * @brief	Ԋ֘Af[^̎擾
 */
//------------------------------------------------------------------
void GMTIME_Init(GMTIME * gt)
{
	gt->use_flag = TRUE;
	GF_RTC_GetDateTime(&gt->sv_date, &gt->sv_time);
	gt->sv_day = RTC_ConvertDateToDay(&gt->sv_date);
	gt->start_sec = RTC_ConvertDateTimeToSecond(&gt->sv_date, &gt->sv_time);
	gt->clear_sec = 0;
	gt->penalty_time = 0;
}

//------------------------------------------------------------------
/**
 * @brief	yieB[hǂ̎擾
 * @param	gt		Q[Ԃւ̃|C^
 * @return	BOOL	TRUÊƂAyieB[h
 */
//------------------------------------------------------------------
BOOL GMTIME_IsPenaltyMode(const GMTIME * gt)
{
	if (gt->penalty_time != 0) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//------------------------------------------------------------------
/**
 * @brief	yieBԂ炷
 * @param	gt			Q[Ԃւ̃|C^
 * @param	diff_minute	炷
 */
//------------------------------------------------------------------
void GMTIME_CountDownPenaltyTime(GMTIME * gt, int diff_minute)
{
	//Z[uf[^ɃS~Ăꍇ̑΍
	if (gt->penalty_time > 24 * 60) {
		gt->penalty_time = 24 * 60;
	}

	if (gt->penalty_time < diff_minute) {
		gt->penalty_time = 0;
	} else {
		gt->penalty_time -= diff_minute;
	}
}

//------------------------------------------------------------------
/**
 * @brief	yieBԂZbg
 * @param	gt			Q[Ԃւ̃|C^
 *
 * 24ԃyieBI
 */
//------------------------------------------------------------------
void GMTIME_SetPenaltyTime(GMTIME * gt)
{
	//yieBԂZbg
	gt->penalty_time = 60 * 24;	//24

	//Ԍo߂ɂ
	GF_RTC_GetDateTime(&gt->sv_date, &gt->sv_time);
	gt->sv_day = RTC_ConvertDateToDay(&gt->sv_date);
}

// OQƃCfbNX鎞̂ݗL(Q[͖)
#ifdef CREATE_INDEX
void *Index_Get_Profile_Offset(SYSTEMDATA *sys){ return &sys->profileId; }
#endif
