//============================================================================================
/**
 * @file	tvwork_local.h
 * @brief	erf[^̃R[hR[i[鏈
 * @author	tamada GAME FREAK inc.
 * @date	2006.05.31
 */
//============================================================================================

#ifndef	__TVWORK_LOCAL_H__
#define	__TVWORK_LOCAL_H__

#include "savedata/tv_work.h"

//----------------------------------------------------------
//----------------------------------------------------------
enum {
	MY_TOPIC_COMMON_MAX = 4,
	MY_WATCH_MAX = MY_TOPIC_COMMON_MAX,
	MY_RECORD_MAX = MY_TOPIC_COMMON_MAX,
	MY_QANDA_MAX = MY_TOPIC_COMMON_MAX,

	OTHER_WATCH_MAX = 16,
	OTHER_RECORD_MAX = 8,
	OTHER_QANDA_MAX = 8,

	USED_TOPIC_MAX = 4,
};

#define	BROADCAST_MAX		3

//----------------------------------------------------------
/**
 * @brief	gsbNf[^{
 */
//----------------------------------------------------------
struct TVTOPIC{
	u8 topic_id;			///<gsbNID
	u8 see_count;			///<񐔃JE^
	GF_DATE date;			///<t
	u8 data[TOPIC_DATA_SIZE];
};

//----------------------------------------------------------
/**
 * @brief	gsbNf[^
 *
 * gsbNf[^ȊOɕt̂͂Ȃ
 */
//----------------------------------------------------------
struct MY_TOPIC{
	TVTOPIC topic;		///<gsbNf[^{
};

//----------------------------------------------------------
/**
 * @brief	lgsbNf[^
 *
 * gsbNf[^{ҏȂǂt
 */
//----------------------------------------------------------
struct OTHER_TOPIC{
	u32 owner_id;			///<ID
	u8 sex;					///<Ґ
	u8 rom_ver;				///<ROMo[W
	u8 region_code;			///<ROMR[h
	STRCODE owner_name[PERSON_NAME_SIZE + EOM_SIZE];	///<Җ
	TVTOPIC topic;		///<gsbNf[^{
};

//----------------------------------------------------------
/**
 * @brief	erZ[uf[^
 */
//----------------------------------------------------------
struct TV_WORK {
	u8 used_index[USED_TOPIC_MAX];				///<ς݃f[^CfbNX
	int minute_count;							///<ԗpJE^
	u8 end_flag;								///<fItO

	MY_TOPIC MyWatchTopic[MY_WATCH_MAX];		///<gsbNf[^FĎ^ԑg
	MY_TOPIC MyRecordTopic[MY_RECORD_MAX];		///<gsbNf[^FMlX^ԑg
	MY_TOPIC MyQandATopic[MY_QANDA_MAX];		///<gsbNf[^F^ԑg

	OTHER_TOPIC OtherWatchTopic[OTHER_WATCH_MAX];	///<lgsbNf[^FĎ^ԑg
	OTHER_TOPIC OtherRecordTopic[OTHER_RECORD_MAX];	///<lgsbNf[^FMlX^ԑg
	OTHER_TOPIC OtherQandATopic[OTHER_QANDA_MAX];	///<lgsbNf[^F^ԑg

	TOPICTEMP_CONTEST ContestTemp;			///<^FReXgp󋵕ێ[N
	TOPICTEMP_PARK ParkTemp;				///<^FAp󋵕ێ[N
	TOPICTEMP_PORUTO PorutoTemp;			///<^F|gp󋵕ێ[N
	TOPICTEMP_BTOWER BTowerTemp;			///<^Fog^[p󋵕ێ[N
	TOPICTEMP_SAFARI SafariTemp;			///<Ď^FTt@p󋵕ێ[N
};

#endif	//__TVWORK_LOCAL_H__

