//============================================================================================
/**
 * @file	undergrounddata.c
 * @brief	nACef[^ANZXp\[X
 * @author	k.ohno
 * @date	2006.2.21
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/undergrounddata.h"
#include "undergrounddata_local.h"

#include "field/ug_itemtype.h"
#include "../fielddata/base_goods/goods_id_def.h"
#include "itemtool/itemsym.h"
#include "system/pm_rtc.h"

//============================================================================================
//============================================================================================



u16 _convertList[] = {
    ITEM_MANMARUISI,         //܂܂	KASEKI_SUN
    ITEM_KANAMEISI,         //Ȃ	KASEKI_SUN
    ITEM_TAIYOUNOISI,        //悤̂	KASEKI_SUN
    ITEM_HOSINOKAKERA,       //ق̂	KASEKI_STAR
    ITEM_TUKINOISI,          //̂	KASEKI_MOON
    ITEM_KATAIISI,           //	KASEKI_HARD
    ITEM_KAMINARINOISI,      //݂Ȃ̂	KASEKI_KAMINARI
    ITEM_KAWARAZUNOISI,      //炸̂	KASEKI_KAWARAZU
    ITEM_HONOONOISI,         //ق̂̂	KASEKI_HONOO
    ITEM_MIZUNOISI,          //݂̂	KASEKI_MIZU
    ITEM_RIIHUNOISI,         //[t̂	KASEKI_REAF
    ITEM_KINNOTAMA,          //̂	KASEKI_GOLD
    ITEM_KAINOKASEKI,        //̃JZL	KASEKI_KAI
    ITEM_KOURANOKASEKI,      //̃JZL	KASEKI_KOURA
    ITEM_TUMENOKASEKI,       //c̃JZL	KASEKI_TSUME
    ITEM_NEKKONOKASEKI,      //˂̃JZL	KASEKI_NEKKO
    ITEM_HIMITUNOKOHAKU,     //Ђ݂̃RnN	KASEKI_KOHAKU
    ITEM_KITYOUNAHONE,          //傤ȃzl	KASEKI_BONE
    ITEM_GENKINOKAKERA,   // 񂫂̂
    ITEM_GENKINOKATAMARI,  // 񂫂̂܂
    ITEM_AKAIKAKERA,				// 
    ITEM_AOIKAKERA,				// 
    ITEM_KIIROIKAKERA,			// 낢
    ITEM_MIDORINOKAKERA,				// ݂ǂ̂
    ITEM_HAATONOUROKO,			// n[g̃ER
    ITEM_TATENOKASEKI,				// ẴJZL
    ITEM_ZUGAINOKASEKI,				// ̃JZL
    ITEM_HIKARINONENDO,// Ђ̂˂
    ITEM_KUROITEKKYUU,				// 낢Ăイ
    ITEM_TUMETAIIWA,				// ߂
    ITEM_SARASARAIWA,			// 炳炢
    ITEM_ATUIIWA,			// 
    ITEM_SIMETTAIWA,				// ߂
    ITEM_HINOTAMAPUREETO,			// Ђ̂܃v[g
    ITEM_SIZUKUPUREETO,			// v[g
    ITEM_IKAZUTIPUREETO,				// v[g
    ITEM_MIDORINOPUREETO,				// ݂ǂ̃v[g
    ITEM_TURARANOPUREETO,				// ̃v[g
    ITEM_KOBUSINOPUREETO,				// Ԃ̃v[g
    ITEM_MOUDOKUPUREETO,				// ǂv[g
    ITEM_DAITINOPUREETO,				// ̃v[g
    ITEM_AOZORAPUREETO,				// v[g
    ITEM_HUSIGINOPUREETO,				// ӂ̃v[g
    ITEM_TAMAMUSIPUREETO,				// ܂ނv[g
    ITEM_GANSEKIPUREETO,				// 񂹂v[g
    ITEM_MONONOKEPUREETO,				// ̂̂v[g
    ITEM_RYUUNOPUREETO,				// イ̃v[g
    ITEM_KOWAMOTEPUREETO,				// ăv[g
    ITEM_KOUTETUPUREETO,				// Ăv[g
};

static void _addEntryGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex, int add);


//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int UnderGroundData_GetWorkSize(void)
{
    return sizeof(UNDERGROUNDDATA);
}

//----------------------------------------------------------
/**
 * @brief	nACe[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	UNDERGROUNDDATA*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
UNDERGROUNDDATA* UnderGroundData_AllocWork(u32 heapID)
{
	UNDERGROUNDDATA* reg;
	reg = sys_AllocMemory(heapID, sizeof(UNDERGROUNDDATA));
	UnderGroundData_Init(reg);
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	UNDERGROUNDDATÃRs[
 * @param	from	Rs[UNDERGROUNDDATAւ̃|C^
 * @param	to		Rs[UNDERGROUNDDATAւ̃|C^
 */
//----------------------------------------------------------
void UnderGroundData_Copy(const UNDERGROUNDDATA *pFrom, UNDERGROUNDDATA* pTo)
{
	MI_CpuCopy8(pFrom, pTo, sizeof(UNDERGROUNDDATA));
}

//----------------------------------------------------------
/**
 * @brief	[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int SecretBaseData_GetWorkSize(void)
{
	return sizeof(SECRETBASEDATA);
}

//----------------------------------------------------------
/**
 * @brief	nXe[^X[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	SECRETBASEDATA*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
SECRETBASEDATA* SecretBaseData_AllocWork(u32 heapID)
{
	SECRETBASEDATA* reg;
	reg = sys_AllocMemory(heapID, sizeof(SECRETBASEDATA));
	SecretBaseData_Init(reg);
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	R[h̃[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int SecretBaseRecord_GetWorkSize(void)
{
	return sizeof(SB_RECORD_DATA);
}

//----------------------------------------------------------
/**
 * @brief	nXe[^XR[h[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	SB_RECORD_DATA*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
SB_RECORD_DATA* SecretBaseRecord_AllocWork(u32 heapID)
{
	SB_RECORD_DATA* reg;
	reg = sys_AllocMemory(heapID, sizeof(SB_RECORD_DATA));
	MI_CpuFill8(reg, 0, sizeof(SB_RECORD_DATA));
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	SECRETBASEDATÃRs[
 * @param	from	Rs[SECRETBASEDATAւ̃|C^
 * @param	to		Rs[SECRETBASEDATAւ̃|C^
 */
//----------------------------------------------------------
void SecretBaseData_Copy(const SECRETBASEDATA *pFrom, SECRETBASEDATA* pTo)
{
	MI_CpuCopy8(pFrom, pTo, sizeof(SECRETBASEDATA));
}


//============================================================================================
//
//	UNDERGROUNDDATÂ߂̊֐
//
//============================================================================================

//----------------------------------------------------------
/**
 * @brief	nXe[^Xf[^̏
 * @param	pSBData		UNDERGROUNDDATA[Nւ̃|C^
 */
//----------------------------------------------------------
void UnderGroundData_Init(UNDERGROUNDDATA* pSBData)
{
    u32 randSeed = 0;
    RTCDate date;
    RTCTime time;

    GF_RTC_GetDateTime(&date, &time);
    randSeed = (((((((u32)date.year * 32ULL + date.month) * 32ULL)
                   + date.day) * 32ULL + time.hour) * 32ULL + time.minute)
                * 32ULL + (time.second + sys.vsync_counter));
    MI_CpuFill8(pSBData, 0, sizeof(UNDERGROUNDDATA));
    pSBData->randSeed = randSeed;
#ifdef DEBUG_ONLY_FOR_ohno

    UnderGroundAddStoneBagItem(pSBData, STONE_TYPE_DIAMOND, 10);
    UnderGroundAddStoneBagItem(pSBData, STONE_TYPE_PEARL, 10);
    UnderGroundAddStoneBagItem(pSBData, STONE_TYPE_RED, 20);
    UnderGroundAddStoneBagItem(pSBData, STONE_TYPE_BLUE, 20);
    UnderGroundAddStoneBagItem(pSBData, STONE_TYPE_GREEN, 20);

    UnderGroundAddGoodsBagItem(pSBData, GOODS_BOX01);
    UnderGroundAddGoodsBagItem(pSBData, GOODS_TABLE02_2);
    UnderGroundAddGoodsBagItem(pSBData, GOODS_CHAIR_L01);
    UnderGroundAddGoodsBagItem(pSBData, GOODS_SHELF02);
    UnderGroundAddGoodsBagItem(pSBData, GOODS_UG_POKE_22);
#endif
    pSBData->bNewDay = TRUE;
}


static int _getBagTreasureItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    for(i = 0;i < SECRETBASE_GOODS_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] != GOODS_INVALID ){
            return i;
        }
    }
    return -1;
}

static int _getBagGoodsItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagGoods[i] != GOODS_INVALID ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreeBagGoodsItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagGoods[i] == GOODS_INVALID ){
            return i;
        }
    }
    return -1;
}

static int _getFreeBagStoneItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagStone[i] == STONE_TYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getBagStoneItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagStone[i] != STONE_TYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreeBagTreasureItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] == STONE_TYPE_NONE ){
            return i;
        }
    }
    return -1;
}

static int _getFreeBagTrapItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTrap[i] == UG_TRAPTYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getBagTrapItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTrap[i] != UG_TRAPTYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

//----------------------------------------------------------
/**
 * @brief	nf[^̓Ɋ֌W
 * @param   pSave        Z[uf[^\
 * @param	diff_days    oߓ
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundDataDayUpdate(SAVEDATA* pSave, int diff_days)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);
    MATHRandContext16 rand;
    u8 upper[]={0,2,2,4,4,5};
    u8 add[]={0,1,1,3,3,5};
    int day,dayMax,carat,type,i;
    
    if(diff_days <= 0){  // ̓tXVɂǂ邩͕s
        return;
    }
    dayMax = diff_days;   // ʂ̐͂XX܂łȂ̂łȏ̓Jbg
    if(diff_days > UG_STONE_CARAT_MAX){
        dayMax = UG_STONE_CARAT_MAX;
    }
    MATH_InitRand16(&rand, pUGData->randSeed);
    for(day = 0; day < dayMax; day++){
        for(i = 0; i < UG_STONE_PLACE_NUM_MAX; i++){
            if(pUGData->groundStoneType[i] != STONE_TYPE_NONE){
                type = pUGData->groundStoneType[i];
                carat = MATH_Rand16(&rand, upper[type]) + add[type];
                if((pUGData->groundStoneCaratAdd[i] + carat) < UG_STONE_CARAT_MAX){
                    pUGData->groundStoneCaratAdd[i] += carat;
                }
                else{
                    pUGData->groundStoneCaratAdd[i] = UG_STONE_CARAT_MAX;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// TCY99̃^}ȍ~̃^}Ȃs̏C𔽉f
#if !(AFTERMASTER_070207_UNDERGROUND_STONEUPDATE_FIX)
                    break;
#endif
// ----------------------------------------------------------------------------
                }
            }
        }
    }
    pUGData->randSeed = gf_fix_rand(pUGData->randSeed + diff_days);
    pUGData->bNewDay = TRUE;
}

//----------------------------------------------------------
/**
 * @brief	nf[^̎ԂɊ֌W
 * @param   pSave        Z[uf[^\
 * @param	diff_minute    oߕ
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundDataMinUpdate(SAVEDATA* pSave, s32 diff_minute, BOOL bPenaltyMode)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);

    if( (diff_minute < 0)  || (bPenaltyMode) ){  // ɂ͑ΉȂyieB[ɂ̓JEgȂ
        return;
    }
    if( pUGData->sendGoodsMinTimer < diff_minute ) {
        pUGData->sendGoodsMinTimer = 0;
    }
    else{
        pUGData->sendGoodsMinTimer -= diff_minute;
    }
}

//----------------------------------------------------------
/**
 * @brief	nf[^̃[hɌĂԏ
 * @param   pSave        Z[uf[^\
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundDataLoadUpdate(SAVEDATA* pSave)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);

    if((pUGData->sendGoodsMinTimer == 0) &&
       (pUGData->sendGoodsSaveInfo == _GOODS_SEND_NOT)){
        pUGData->sendGoodsSaveInfo = _GOODS_SEND_NONE;
    }
    if((pUGData->sendGoodsMinTimer == 0) &&
       (pUGData->sendGoodsSaveInfo == _GOODS_SEND_UNDERIN)){
        pUGData->sendGoodsMinTimer = _PENALTY_TIME;
    }
    if(pUGData->sendGoodsSaveInfo == _GOODS_SEND_UNDERIN){
        pUGData->sendGoodsSaveInfo = _GOODS_SEND_NOT;
    }
}

//----------------------------------------------------------
/**
 * @brief	nɍsSAVEOɌĂԏ
 * @param   pSave        Z[uf[^\
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundDataBeforeUGSave(SAVEDATA* pSave)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);

    if(pUGData->sendGoodsSaveInfo == _GOODS_SEND_NONE){
        pUGData->sendGoodsSaveInfo = _GOODS_SEND_UNDERIN;
    }
}

//----------------------------------------------------------
/**
 * @brief	n甲oꍇ̏
 * @param   pSave        Z[uf[^\
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundDataAfterUG(SAVEDATA* pSave)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);

    if(pUGData->sendGoodsSaveInfo == _GOODS_SEND_UNDERIN){
        pUGData->sendGoodsSaveInfo = _GOODS_SEND_NONE;
    }
}

//----------------------------------------------------------
/**
 * @brief	ObYԂǂ
 * @param   pSave        Z[uf[^\
 * @return	none
 */
//----------------------------------------------------------

BOOL UnderGroundDataIsGoodsSend(SAVEDATA* pSave)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);

    if(pUGData->sendGoodsSaveInfo == _GOODS_SEND_NOT){
        return FALSE;
    }
    return TRUE;
}


//----------------------------------------------------------
/**
 * @brief	nŃfBAKpLA|ONɂ
 * @param   pUGData        nf[^\
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundSetDiamondPearlEvent(UNDERGROUNDDATA* pUGData)
{
    pUGData->groundStoneGetBit = TRUE;
}

BOOL UnderGroundIsDiamondPearlEvent(UNDERGROUNDDATA* pUGData)
{
    return pUGData->groundStoneGetBit;
}

//----------------------------------------------------------
/**
 * @brief	ǉ
 * @param   pUGData      nACef[^\
 * @param	pMyStatus    ƂlMYSTATUS
 * @return	none   K
 *  AFTERMASTER_070125_UNDERGROUND_PCFLAGLIST_FIXL͏d͓Ȃ
 */
//----------------------------------------------------------

void UnderGroundAddFlag(UNDERGROUNDDATA* pUGData, const MYSTATUS* pMyStatus)
{
	int i = pUGData->newFlagNo;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// u@Ƃn^vXVȂƂ̓JEgAbvȂ悤

#if AFTERMASTER_070125_UNDERGROUND_PCFLAGLIST_FIX
    int k;
    
    for(k=0;k<UG_FLAG_NUM_MAX;k++){
        if(pUGData->id[k] == MyStatus_GetID(pMyStatus)){
            return;
        }
    }
#endif

// ----------------------------------------------------------------------------

    GF_ASSERT_RETURN(i < UG_FLAG_NUM_MAX,);
    MI_CpuCopy8(MyStatus_GetMyName(pMyStatus), pUGData->name[i], (sizeof(STRCODE) * (PERSON_NAME_SIZE+EOM_SIZE)));
    pUGData->id[i] = MyStatus_GetID(pMyStatus);
    pUGData->region_code[i] = MyStatus_GetRegionCode(pMyStatus);
    pUGData->rom_code[i] = MyStatus_GetRomCode(pMyStatus);
    pUGData->newFlagNo++;
    if(pUGData->newFlagNo >= UG_FLAG_NUM_MAX){
        pUGData->newFlagNo = 0;
    }
}

//----------------------------------------------------------
/**
 * @brief	ǂݍ
 * @param   pUGData      nACef[^\
 * @param   heapID       HEAP
 * @param	index        o
 * @return	MYSTATUS*    ̏ꍇNULL
 */
//----------------------------------------------------------

MYSTATUS* UnderGroundGetFlag(const UNDERGROUNDDATA* pUGData,int heapID,int index)
{
    int size = (sizeof(STRCODE) * (PERSON_NAME_SIZE+EOM_SIZE));
    int i;
    MYSTATUS* pMy;
    int no = pUGData->newFlagNo - index - 1;

    if(no < 0){
        no += UG_FLAG_NUM_MAX;
    }
    if(pUGData->name[no][0] != 0){
        pMy = MyStatus_AllocWork(heapID);
        MyStatus_SetMyName(pMy, pUGData->name[no]);
        MyStatus_SetRomCode(pMy, pUGData->rom_code[no]);
        MyStatus_SetRegionCode(pMy, pUGData->region_code[no]);
        MyStatus_SetID(pMy, pUGData->id[no]);
        return pMy;
    }
    return NULL;
}


//----------------------------------------------------------
/**
 * @brief	ɂĕς闐V[h𓾂
 * @param   pUGData      nACef[^\
 * @return	ɂĕς闐V[h
 */
//----------------------------------------------------------
u32 UnderGroundGetDayRandSeed(UNDERGROUNDDATA* pUGData)
{
    return pUGData->randSeed;
}

//----------------------------------------------------------
/**
 * @brief	܂ACeo
 * @param   pUGData      nACef[^\
 * @param	bDelete      ۂɎoĂ疳ȂꍇTRUE ǂ݂̏ꍇFALSE
 * @return	ITEM_TYPE ɂȂ ITEM_DUMMY_DATA
 */
//----------------------------------------------------------
int UnderGroundGetTreasureBagItem(UNDERGROUNDDATA* pUGData, BOOL bDelete)
{
    int i = _getBagTreasureItemIndex(pUGData);
    int ugitem;

    if(i == -1){
        return ITEM_DUMMY_DATA;
    }
    ugitem = pUGData->bagTreasure[i];
    GF_ASSERT_RETURN(DIG_PARTS_TREASURE_MIN <= ugitem, ITEM_HUTOIHONE);
    GF_ASSERT_RETURN(ugitem < DIG_PARTS_TREASURE_MAX, ITEM_HUTOIHONE);
    ugitem -= DIG_PARTS_TREASURE_MIN;
    if(bDelete){
        pUGData->bagTreasure[i] = DIG_PARTS_NONE;  // 
    }
    return _convertList[ugitem];
}

//----------------------------------------------------------
/**
 * @brief	灄ACeϊ
 * @return	ITEM_TYPE ɂȂ ITEM_DUMMY_DATA
 */
//----------------------------------------------------------
int UnderGroundTreasureItem2Item(int treasureType)
{
    GF_ASSERT_RETURN(DIG_PARTS_TREASURE_MIN <= treasureType, ITEM_HUTOIHONE);
    GF_ASSERT_RETURN(treasureType < DIG_PARTS_TREASURE_MAX, ITEM_HUTOIHONE);
    treasureType -= DIG_PARTS_TREASURE_MIN;
    return _convertList[treasureType];
}

//----------------------------------------------------------
/**
 * @brief	p\R̃ObY֒ǉ
 * @param   pUGData      nACef[^\
 * @param	goodsNo      ObYԍ
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddGoodsPCItem(UNDERGROUNDDATA* pUGData, int goodsNo)
{
    int i;

    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcGoods[i] == GOODS_INVALID ){
            pUGData->pcGoods[i] = goodsNo;
            return TRUE;
        }
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	p\R̃ObY֒ǉł邩`FbN
 * @param   pUGData      nACef[^\
 * @param	goodsNo      ObYԍ(_~[j
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddChkGoodsPCItem(UNDERGROUNDDATA* pUGData, int goodsNo)
{
    int i;

    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcGoods[i] == GOODS_INVALID ){
            return TRUE;
        }
    }
    return FALSE;
}



//----------------------------------------------------------
/**
 * @brief	p\RɃObYĂ邩mF
 * @param   pUGData      nACef[^\
 * @return	ObY
 */
//----------------------------------------------------------
int UnderGroundGetNumGoodsPCItem(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcGoods[i] == GOODS_INVALID ){
            break;
        }
    }
    return i;
}

//----------------------------------------------------------
/**
 * @brief	p\R̃ObYmF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ObYԍ ꍇ GOODS_INVALID
 */
//----------------------------------------------------------
int UnderGroundGetGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    return pUGData->pcGoods[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	p\RObYƂ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ObYԍ ꍇ GOODS_INVALID
 */
//----------------------------------------------------------
int UnderGroundDelGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    // Ă̂oȂ̂ł炩ߌ邱
    GF_ASSERT_RETURN(!UnderGroundIsEntryGoodsPCItem(pUGData, listIndex),);

    ix = listIndex;
    type = pUGData->pcGoods[ix];
    for(i = ix ; i < UG_ITEM_PC_NUM_MAX-1; i++){
        pUGData->pcGoods[i] = pUGData->pcGoods[i+1];
    }
    pUGData->pcGoods[UG_ITEM_PC_NUM_MAX-1] = GOODS_INVALID;

    _addEntryGoodsPCItem(pUGData, listIndex, -1); //Gg[Ԃ
    return type;
}

//----------------------------------------------------------
/**
 * @brief	p\R̃ObYԕύX
 * @param   pUGData      nACef[^\
 * @param	listIndex       ̈ʒu
 * @param	nextIndex       ẍʒu
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundChangeGoodsPcItem(UNDERGROUNDDATA* pUGData, int listIndex,int nextIndex)
{
    int i,j=0,cnt = 0,change = -1;
    u8 pcGoods[UG_ITEM_PC_NUM_MAX];

    MI_CpuCopy8(pUGData->pcGoods,pcGoods,UG_ITEM_PC_NUM_MAX);
    for(i = 0 ; i < UG_ITEM_PC_NUM_MAX; i++){
        if(i != listIndex){
            pUGData->pcGoods[j] = pcGoods[i];
            j++;
        }
        if(i == nextIndex){
            pUGData->pcGoods[j] = pcGoods[listIndex];
            j++;
        }
    }

    for(i = 0; i < SECRETBASE_GOODS_NUM_MAX; i++){
        if(pUGData->secretBasePlace[ i ] == (listIndex+1)){
            change = i;
            break;
        }
    }
	
	_addEntryGoodsPCItem(pUGData, nextIndex, 1); //Gg[Ԃ
    _addEntryGoodsPCItem(pUGData, listIndex, -1); //Gg[Ԃ
    
    if(change != -1){
        if(listIndex<nextIndex){
            pUGData->secretBasePlace[ change ] = nextIndex+1;
        }
        else{
            pUGData->secretBasePlace[ change ] = nextIndex+2;
        }
    }
}


//----------------------------------------------------------
/**
 * @brief	p\RObYׂɂƂ肾
 *          ۂɂ͎oA}[N܂
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ObYԍ ꍇ GOODS_INVALID
 */
//----------------------------------------------------------
int UnderGroundEntryGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex, int goodsIndex)
{
    int i,ix;

    GF_ASSERT_RETURN(goodsIndex >= SECRETBASE_PC_NUM_MAX, GOODS_INVALID);
    GF_ASSERT_RETURN(goodsIndex <= SECRETBASE_GOODS_NUM_MAX, GOODS_INVALID);
    pUGData->secretBasePlace[goodsIndex - SECRETBASE_PC_NUM_MAX] = listIndex + 1;
    return pUGData->pcGoods[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	Xgԍ̃ACeĂ邩ǂԂ܂
 * @param   pUGData       nACef[^\
 * @param	listIndex     j[Xg̏ UnderGroundEntryGoodsPCItemœn̂Ɠ
 * @return	ĂꍇTRUE
 */
//----------------------------------------------------------

BOOL UnderGroundIsEntryGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;
    for(i = 0; i < SECRETBASE_GOODS_NUM_MAX; i++){
        if(pUGData->secretBasePlace[ i ] == (listIndex+1)){
            return TRUE;
        }
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	p\R֏ĂObYǂ
 * @param   pUGData      nACef[^\
 * @param	goodsIndex	ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundTrashGoodsPCItem(UNDERGROUNDDATA* pUGData, int goodsIndex)
{
    if((goodsIndex - SECRETBASE_PC_NUM_MAX) >= SECRETBASE_GOODS_NUM_MAX){
        return;
    }
    pUGData->secretBasePlace[goodsIndex - SECRETBASE_PC_NUM_MAX] = 0;
}

//----------------------------------------------------------
/**
 * @brief	p\R֏ĂObYSǂ
 * @param   pUGData      nACef[^\
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundTrashAllGoodsPCItem(UNDERGROUNDDATA* pUGData)
{
    MI_CpuFill8(pUGData->secretBasePlace, 0, SECRETBASE_GOODS_NUM_MAX);
}

//----------------------------------------------------------
/**
 * @brief	Ăf[^indexadd܂
 * @param   pUGData       nACef[^\
 * @param	listIndex     ̃ACe𔲂ôŁ@ȍ~indexύX
 * @return	none
 */
//----------------------------------------------------------

static void _addEntryGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex, int add)
{
    int i;
    for(i = 0; i < SECRETBASE_GOODS_NUM_MAX; i++){
        if(pUGData->secretBasePlace[ i ] > (listIndex+1)){
            pUGData->secretBasePlace[ i ] += add;
        }
    }
}

//----------------------------------------------------------
/**
 * @brief	obOɃObYĂ邩mF
 * @param   pUGData      nACef[^\
 * @return	ObY
 */
//----------------------------------------------------------
int UnderGroundGetNumGoodsBagItem(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagGoods[i] == GOODS_INVALID ){
            break;
        }
    }
    return i;
}

//----------------------------------------------------------
/**
 * @brief	obÕObYmF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ObYԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetGoodsBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    return pUGData->bagGoods[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	obOObYƂ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @return	ObYԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelGoodsBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = listIndex;
    type = pUGData->bagGoods[ix];
    for(i = ix ; i < UG_ITEM_BAG_NUM_MAX-1; i++){
        pUGData->bagGoods[i] = pUGData->bagGoods[i+1];
    }
    pUGData->bagGoods[UG_ITEM_BAG_NUM_MAX-1] = GOODS_INVALID;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	obOփObYǉ
 * @param   pUGData      nACef[^\
 * @param	goodsType    ObYType
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddGoodsBagItem(UNDERGROUNDDATA* pUGData, int goodsType)
{
    int i;

    i = _getFreeBagGoodsItemIndex(pUGData);
    if(i != -1){
        pUGData->bagGoods[i] = goodsType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obOփObYǉ\`FbN
 * @param   pUGData      nACef[^\
 * @param	goodsType    ObYType
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddChkGoodsBagItem(UNDERGROUNDDATA* pUGData, int goodsType)
{
    int i;

    i = _getFreeBagGoodsItemIndex(pUGData);
    if(i != -1){
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obÕObYԕύX
 * @param   pUGData      nACef[^\
 * @param	listIndex       ̈ʒu
 * @param	nextIndex       ẍʒu
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundChangeGoodsBagItem(UNDERGROUNDDATA* pUGData, int listIndex,int nextIndex)
{
    int i,j=0,cnt = 0;
    u8 bagGoods[UG_ITEM_BAG_NUM_MAX];

    MI_CpuCopy8(pUGData->bagGoods,bagGoods,UG_ITEM_BAG_NUM_MAX);
    for(i = 0 ; i < UG_ITEM_BAG_NUM_MAX; i++){
        if(i != listIndex){
            pUGData->bagGoods[j] = bagGoods[i];
            j++;
        }
        if(i == nextIndex){
            pUGData->bagGoods[j] = bagGoods[listIndex];
            j++;
        }
    }
}

//----------------------------------------------------------
/**
 * @brief	΂ɂ܂Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	ܐ
 */
//----------------------------------------------------------
int UnderGroundGetNumStoneBagItem(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagStone[i] == STONE_TYPE_NONE ){
            break;
        }
    }
    return i;
}

//----------------------------------------------------------
/**
 * @brief	΂̂܂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ܔԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetStoneBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    return pUGData->bagStone[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	΂̂܂̂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	Caratԍ ꍇ1
 */
//----------------------------------------------------------
int UnderGroundGetStoneCaratBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    return pUGData->bagStoneCarat[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	΂񂩂炽܂Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ܔԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelStoneBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = listIndex;
    type = pUGData->bagStone[ix];
    for(i = ix ; i < UG_ITEM_BAG_NUM_MAX-1; i++){
        pUGData->bagStone[i] = pUGData->bagStone[i+1];
        pUGData->bagStoneCarat[i] = pUGData->bagStoneCarat[i+1];
    }
    pUGData->bagStone[UG_ITEM_BAG_NUM_MAX-1] = STONE_TYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	΂񂽂܂֒ǉ
 * @param   pUGData      nACef[^\
 * @param	stoneType    ^}Type
 * @param	carat        ^}̑傫
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddStoneBagItem(UNDERGROUNDDATA* pUGData, int stoneType, int carat)
{
    int i;

    i = _getFreeBagStoneItemIndex(pUGData);
    if(i != -1){
        pUGData->bagStone[i] = stoneType;
        pUGData->bagStoneCarat[i] = carat;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obÔ܂ԕύX
 * @param   pUGData      nACef[^\
 * @param	listIndex       ̈ʒu
 * @param	nextIndex       ẍʒu
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundChangeStoneBagItem(UNDERGROUNDDATA* pUGData, int listIndex,int nextIndex)
{
    int i,j=0,cnt = 0;
    u8 bagStone[UG_ITEM_BAG_NUM_MAX];
    u8 bagStoneCarat[UG_ITEM_BAG_NUM_MAX];

    MI_CpuCopy8(pUGData->bagStone,bagStone,UG_ITEM_BAG_NUM_MAX);
    MI_CpuCopy8(pUGData->bagStoneCarat,bagStoneCarat,UG_ITEM_BAG_NUM_MAX);
    for(i = 0 ; i < UG_ITEM_BAG_NUM_MAX; i++){
        if(i != listIndex){
            pUGData->bagStone[j] = bagStone[i];
            pUGData->bagStoneCarat[j] = bagStoneCarat[i];
            j++;
        }
        if(i == nextIndex){
            pUGData->bagStone[j] = bagStone[listIndex];
            pUGData->bagStoneCarat[j] = bagStoneCarat[listIndex];
            j++;
        }
    }
}

//----------------------------------------------------------
/**
 * @brief	obOɂ炪Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	琔
 */
//----------------------------------------------------------
int UnderGroundGetNumTreasureBagItem(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] == STONE_TYPE_NONE ){
            break;
        }
    }
    return i;
}

//----------------------------------------------------------
/**
 * @brief	obÔmF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetTreasureBagItem_List(UNDERGROUNDDATA* pUGData, int listIndex)
{
    return pUGData->bagTreasure[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	obO炨Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelTreasureBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = listIndex;
    type = pUGData->bagTreasure[ix];
    for(i = ix ; i < UG_ITEM_BAG_NUM_MAX-1; i++){
        pUGData->bagTreasure[i] = pUGData->bagTreasure[i+1];
    }
    pUGData->bagTreasure[UG_ITEM_BAG_NUM_MAX-1] = STONE_TYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	obOւǉ
 * @param   pUGData      nACef[^\
 * @param	treasureType    Type
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddTreasureBagItem(UNDERGROUNDDATA* pUGData, int treasureType)
{
    int i;

    i = _getFreeBagTreasureItemIndex(pUGData);
    if(i != -1){
        pUGData->bagTreasure[i] = treasureType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obÔԕύX
 * @param   pUGData      nACef[^\
 * @param	listIndex       ̈ʒu
 * @param	nextIndex       ẍʒu
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundChangeTreasureBagItem(UNDERGROUNDDATA* pUGData, int listIndex,int nextIndex)
{
    int i,j=0,cnt = 0;
    u8 bagTreasure[UG_ITEM_BAG_NUM_MAX];

    MI_CpuCopy8(pUGData->bagTreasure,bagTreasure,UG_ITEM_BAG_NUM_MAX);
    for(i = 0 ; i < UG_ITEM_BAG_NUM_MAX; i++){
        if(i != listIndex){
            pUGData->bagTreasure[j] = bagTreasure[i];
            j++;
        }
        if(i == nextIndex){
            pUGData->bagTreasure[j] = bagTreasure[listIndex];
            j++;
        }
    }
}

//----------------------------------------------------------
/**
 * @brief	obO㩂Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	㩐
 */
//----------------------------------------------------------
int UnderGroundGetNumTrapBagItem(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTrap[i] == UG_TRAPTYPE_NONE ){
            break;
        }
    }
    return i;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	㩔ԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetTrapBagItem_List(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    return pUGData->bagTrap[listIndex];
}

//----------------------------------------------------------
/**
 * @brief	obO㩂Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @return	㩔ԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelTrapBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = listIndex;
    type = pUGData->bagTrap[ix];
    for(i = ix ; i < UG_ITEM_BAG_NUM_MAX-1; i++){
        pUGData->bagTrap[i] = pUGData->bagTrap[i+1];
    }
    pUGData->bagTrap[UG_ITEM_BAG_NUM_MAX-1] = UG_TRAPTYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂ǉ
 * @param   pUGData      nACef[^\
 * @param	treasureType    Type
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddTrapBagItem(UNDERGROUNDDATA* pUGData, int trapType)
{
    int i;

    i = _getFreeBagTrapItemIndex(pUGData);
    if(i != -1){
        pUGData->bagTrap[i] = trapType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂ԕύX
 * @param   pUGData      nACef[^\
 * @param	listIndex       ̈ʒu
 * @param	nextIndex       ẍʒu
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundChangeTrapBagItem(UNDERGROUNDDATA* pUGData, int listIndex,int nextIndex)
{
    int i,j=0,cnt = 0;
    u8 bagTrap[UG_ITEM_BAG_NUM_MAX];

    MI_CpuCopy8(pUGData->bagTrap,bagTrap,UG_ITEM_BAG_NUM_MAX);
    for(i = 0 ; i < UG_ITEM_BAG_NUM_MAX; i++){
        if(i != listIndex){
            pUGData->bagTrap[j] = bagTrap[i];
            j++;
        }
        if(i == nextIndex){
            pUGData->bagTrap[j] = bagTrap[listIndex];
            j++;
        }
    }
}


#define UG_TRAP_PLACE_NUM_MAX (16)  // zu㩂̍ő吔
//----------------------------------------------------------
/**
 * @brief	nʂ֎R㩂ǉ
 * @param   pUGData      nACef[^\
 * @param	trapType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundAddNatureTrapGroundItem(UNDERGROUNDDATA* pUGData, int trapType,int index, int x,int z)
{
    GF_ASSERT_RETURN(index < UG_NATURETRAP_PLACE_NUM_MAX,);
    pUGData->groundNatureTrapType[index]=trapType;
    pUGData->groundNatureTrapPos[index][0] = x;
    pUGData->groundNatureTrapPos[index][1] = ((x & 0xf00) >> 8) + ((z & 0xf00) >> 4);
    pUGData->groundNatureTrapPos[index][2] = z;
}

//----------------------------------------------------------
/**
 * @brief	nʂւ㩃^Cvo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	㩃^Cv
 */
//----------------------------------------------------------

int UnderGroundGetNatureTrapGroundItemType(UNDERGROUNDDATA* pUGData,int index)
{
    GF_ASSERT_RETURN(index < UG_NATURETRAP_PLACE_NUM_MAX,0);
    return pUGData->groundNatureTrapType[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂXWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	XW
 */
//----------------------------------------------------------

int UnderGroundGetNatureTrapGroundItemX(UNDERGROUNDDATA* pUGData,int index)
{
    int pos;
    GF_ASSERT_RETURN(index < UG_NATURETRAP_PLACE_NUM_MAX,0);
    pos = pUGData->groundNatureTrapPos[index][0];
    pos += (pUGData->groundNatureTrapPos[index][1] << 8) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	nʂZWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	ZW
 */
//----------------------------------------------------------

int UnderGroundGetNatureTrapGroundItemZ(UNDERGROUNDDATA* pUGData,int index)
{
    int pos;
    GF_ASSERT_RETURN(index < UG_NATURETRAP_PLACE_NUM_MAX,0);
    pos = pUGData->groundNatureTrapPos[index][2];
    pos += (pUGData->groundNatureTrapPos[index][1] << 4) & 0xf00;
    return pos;
}


//----------------------------------------------------------
/**
 * @brief	R㩂
 * @param   pUGData      nACef[^\
 * @param	trapType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundDelNatureTrapGroundItem(UNDERGROUNDDATA* pUGData, int index)
{
    GF_ASSERT_RETURN(index < UG_NATURETRAP_PLACE_NUM_MAX,);
    pUGData->groundNatureTrapType[index] = UG_TRAPTYPE_NONE;
    MI_CpuClear8(pUGData->groundNatureTrapPos[index],3);
}

//----------------------------------------------------------
/**
 * @brief	nʂ㩂ǉ
 * @param   pUGData      nACef[^\
 * @param	trapType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundAddTrapGroundItem(UNDERGROUNDDATA* pUGData, int trapType,int index, int x,int z,int order)
{
    GF_ASSERT_RETURN(index < UG_TRAP_PLACE_NUM_MAX,);
    pUGData->groundTrapType[index]=trapType;
    pUGData->groundTrapPos[index][0] = x;
    pUGData->groundTrapPos[index][1] = ((x & 0xf00) >> 8) + ((z & 0xf00) >> 4);
    pUGData->groundTrapPos[index][2] = z;
    pUGData->groundTrapOrder[index]=order;
}

//----------------------------------------------------------
/**
 * @brief	nʂւ㩃^Cvo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	㩃^Cv
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemType(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundTrapType[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂXWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	XW
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemX(UNDERGROUNDDATA* pUGData,int index)
{
    int pos = pUGData->groundTrapPos[index][0];

    pos += (pUGData->groundTrapPos[index][1] << 8) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	nʂZWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	ZW
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemZ(UNDERGROUNDDATA* pUGData,int index)
{
    int pos = pUGData->groundTrapPos[index][2];

    pos += (pUGData->groundTrapPos[index][1] << 4) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	nʂ琶Ԃo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	order
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemOrder(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundTrapOrder[index];
}


//----------------------------------------------------------
/**
 * @brief	nʂ֐΂߂
 * @param   pUGData      nACef[^\
 * @param	stoneType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundAddStoneGroundItem(UNDERGROUNDDATA* pUGData, int stoneType,int index, int x,int z,int carat, int addCarat)
{
    GF_ASSERT_RETURN(index < UG_STONE_PLACE_NUM_MAX,);
    pUGData->groundStoneType[index] = stoneType;
    pUGData->groundStonePos[index][0] = x;
    pUGData->groundStonePos[index][1] = ((x & 0xf00) >> 8) + ((z & 0xf00) >> 4);
    pUGData->groundStonePos[index][2] = z;
    pUGData->groundStoneCarat[index] = carat;
    pUGData->groundStoneCaratAdd[index] = addCarat;
}

//----------------------------------------------------------
/**
 * @brief	nʂ֐΂𖄂߂  ߂Ƃɂ͐O
 * @param   pUGData      nACef[^\
 * @param	stoneType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundBuryStoneGroundItem(UNDERGROUNDDATA* pUGData, int stoneType,int index, int x,int z,int carat)
{
    UnderGroundAddStoneGroundItem(pUGData, stoneType, index, x, z, carat, 0);
}

//----------------------------------------------------------
/**
 * @brief	nʂւ΃^Cvo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	㩃^Cv
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemType(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneType[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂXWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	XW
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemX(UNDERGROUNDDATA* pUGData,int index)
{
    int pos = pUGData->groundStonePos[index][0];

    pos += (pUGData->groundStonePos[index][1] << 8) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	nʂZWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	ZW
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemZ(UNDERGROUNDDATA* pUGData,int index)
{
    int pos = pUGData->groundStonePos[index][2];

    pos += (pUGData->groundStonePos[index][1] << 4) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	nʂ΂̑傫o
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	΂̑傫
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemCarat(UNDERGROUNDDATA* pUGData,int index)
{
    int carat = pUGData->groundStoneCarat[index]+pUGData->groundStoneCaratAdd[index];

    if(carat > UG_STONE_CARAT_MAX){
        carat = UG_STONE_CARAT_MAX;
    }
    return carat;
}

//----------------------------------------------------------
/**
 * @brief	nʂ΂̃IWȋ傫o
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	΂̑傫
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemCaratOrg(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneCarat[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂ΂̑o
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	΂̑傫
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemCaratMul(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneCaratAdd[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂ։΂L^
 * @param   pUGData      nACef[^\
 * @param	x,z  ʒuL
 * @return	index
 */
//----------------------------------------------------------
int UnderGroundAddFossilGroundItem(UNDERGROUNDDATA* pUGData, int x,int z)
{
    int i;
    
    for(i = 0;i < UG_FOSSIL_PLACE_NUM_MAX;i++){
        if((pUGData->groundFossilPos[i][0] == 0) &&
           (pUGData->groundFossilPos[i][1] == 0) &&
           (pUGData->groundFossilPos[i][2] == 0) ){
            pUGData->groundFossilPos[i][0] = x;
            pUGData->groundFossilPos[i][1] = ((x & 0xf00) >> 8) + ((z & 0xf00) >> 4);
            pUGData->groundFossilPos[i][2] = z;
            return i;
        }
    }
    return 0;
}

//----------------------------------------------------------
/**
 * @brief	΃f[^
 * @param   pUGData      nACef[^\
 * @param	x,z  ʒuL
 * @return	index
 */
//----------------------------------------------------------
void UnderGroundDelFossilGroundItem(UNDERGROUNDDATA* pUGData, int index)
{
    GF_ASSERT_RETURN(index < UG_FOSSIL_PLACE_NUM_MAX,);
    MI_CpuFill8( pUGData->groundFossilPos[index] , 0, 3);
}

//----------------------------------------------------------
/**
 * @brief	nʂXWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	XW
 */
//----------------------------------------------------------

int UnderGroundGetFossilGroundItemX(UNDERGROUNDDATA* pUGData,int index)
{
    int pos = pUGData->groundFossilPos[index][0];

    pos += (pUGData->groundFossilPos[index][1] << 8) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	nʂZWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	ZW
 */
//----------------------------------------------------------

int UnderGroundGetFossilGroundItemZ(UNDERGROUNDDATA* pUGData,int index)
{
    int pos = pUGData->groundFossilPos[index][2];

    pos += (pUGData->groundFossilPos[index][1] << 4) & 0xf00;
    return pos;
}

//----------------------------------------------------------
/**
 * @brief	΂@̂͏߂Ăǂ
 * @param   pUGData      nACef[^\
 * @return	TRUEȂ牻Δzu
 */
//----------------------------------------------------------

BOOL UnderGroundIsFirstFossil(UNDERGROUNDDATA* pUGData)
{
    return (pUGData->bFossilFirst==FALSE);
}

//----------------------------------------------------------
/**
 * @brief	΂@̂͏߂FLGON
 * @param   pUGData      nACef[^\
 * @return	TRUEȂ牻Δzu
 */
//----------------------------------------------------------

void UnderGroundSetFirstFossil(UNDERGROUNDDATA* pUGData)
{
    pUGData->bFossilFirst = TRUE;
}

//----------------------------------------------------------
/**
 * @brief	΂Vzu邩ǂ
 * @param   pUGData      nACef[^\
 * @return	TRUEȂ牻Δzu
 */
//----------------------------------------------------------

BOOL UnderGroundIsNewDay(UNDERGROUNDDATA* pUGData)
{
    return pUGData->bNewDay;
}

//----------------------------------------------------------
/**
 * @brief	΂zuItO
 * @param   pUGData      nACef[^\
 * @return  none
 */
//----------------------------------------------------------

void UnderGroundResetNewDay(UNDERGROUNDDATA* pUGData)
{
    pUGData->bNewDay = FALSE;
}

//----------------------------------------------------------
/**
 * @brief	@΂L^ iAv[gLj
 * @param   pUGData      nACef[^\
 * @param   type         @Ύ
 * @return  none
 */
//----------------------------------------------------------

void UnderGroundSetFossilDig(UNDERGROUNDDATA* pUGData,int type)
{
    if((DIG_PARTS_PLATE_FIRE > type) || (type > DIG_PARTS_PLATE_IRON)){
        return;
    }
    pUGData->digBit |= (0x0001 << (type - DIG_PARTS_PLATE_FIRE));
}

//----------------------------------------------------------
/**
 * @brief	̉΂oĂ悢̂
 * @param   pUGData      nACef[^\
 * @param   type         @Ύ
 * @return  none
 */
//----------------------------------------------------------

BOOL UnderGroundIsFossilAdvent(UNDERGROUNDDATA* pUGData,int type)
{
    if((DIG_PARTS_PLATE_FIRE > type) || (type > DIG_PARTS_PLATE_IRON)){
        return TRUE;
    }
    if((pUGData->digBit & (0x0001 << (type - DIG_PARTS_PLATE_FIRE))) ){
        return FALSE;
    }
    return TRUE;
}

//----------------------------------------------------------
/**
 * @brief	nJEg
 * @param   pUGData      nACef[^\
 * @return	order
 */
//----------------------------------------------------------

void UnderGroundCountWalk(UNDERGROUNDDATA* pUGData)
{
    if(pUGData->walk >= (_MAX_WALK_COUNT-1)){
        pUGData->walk = 0;
    }
    else{
        pUGData->walk++;
    }
}

//----------------------------------------------------------
/**
 * @brief	noiPOOŃZbgj
 * @param   pUGData      nACef[^\
 * @return	
 */
//----------------------------------------------------------

int UnderGroundGetWalkNum(UNDERGROUNDDATA* pUGData)
{
    return pUGData->walk;
}

//----------------------------------------------------------
/**
 * @brief	nXe[^Xf[^̏
 * @param	pSBData		SECRETBASEDATA[Nւ̃|C^
 */
//----------------------------------------------------------
void SecretBaseData_Init(SECRETBASEDATA* pSBData)
{
	MI_CpuFill8(pSBData, 0, sizeof(SECRETBASEDATA));
}

//----------------------------------------------------------
/**
 * @brief	nXe[^Xf[^̏(R[hȊO)
 * @param	pSBData		SECRETBASEDATA[Nւ̃|C^
 */
//----------------------------------------------------------

void SecretBaseData_Reform(SECRETBASEDATA* pSBData)
{
    MI_CpuClear8(pSBData->goodsPos,SECRETBASE_GOODS_NUM_MAX*sizeof(SB_GOODS));
    MI_CpuClear8(pSBData->rockPos,SECRETBASE_LOCK_NUM_MAX*sizeof(SB_LOCK));
    pSBData->xpos=0;         // hÄʒu
    pSBData->zpos=0;
    pSBData->dir=0;        // OɏoĂhA̕
    pSBData->bMake=0;     //  ǂ
}

//----------------------------------------------------------
/**
 * @brief	閧nꎞIɏ
 * @param	pSBData	 SECRETBASEDATA[N|C^
 */
//----------------------------------------------------------

void SecretBaseData_SetMakeDown(SECRETBASEDATA* pSBData)
{
    pSBData->bMake = FALSE;     //  ǂ
}

//----------------------------------------------------------
/**
 * @brief	ObŸʒuݒ肷  ꍇɂ͑SO    p~\
 * @param	pSBData	 SECRETBASEDATA[N|C^
 * @param	goodsIndex	ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @param   type    ObY^Cv
 * @param	x,z      ʒu
 */
//----------------------------------------------------------
void SecretBaseData_SetGoodsPosition(SECRETBASEDATA* pSBData, int goodsIndex, int type, int x, int z)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,);
    GF_ASSERT_RETURN(x < 32,);
    GF_ASSERT_RETURN(z < 32,);
    GF_ASSERT_RETURN(pSBData,);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return;  // p\R̈ʒu͗vȂ
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].x = x;
        pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].z = z;
        pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].type = type;
    }
    else{  // c͊
        pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].x = x;
        pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].z = z;
    }
}

//----------------------------------------------------------
/**
 * @brief	ObŸʒuύX  ꍇɂ͑SO
 * @param	pSBData	 SECRETBASEDATA[N|C^
 * @param	goodsIndex	ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @param	x,z      ʒu
 */
//----------------------------------------------------------
void SecretBaseData_ChangeGoodsPosition(SECRETBASEDATA* pSBData, int goodsIndex, int x, int z)
{
    int type = SecretBaseData_GetGoodsType(pSBData, goodsIndex);
    SecretBaseData_SetGoodsPosition(pSBData, goodsIndex, type, x, z);
}

//----------------------------------------------------------
/**
 * @brief	p\Rtype𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	ObY^Cv+p\R^Cv
 */
//----------------------------------------------------------

static int _getPCType(const SECRETBASEDATA* pSBData)
{
    int num = pSBData->recordData.flagDeliveryCount;
    
    if(FLAG_PLATINA_LV_NUM <= num){
        return GOODS_FLAG_PLATINA_PC;
    }
    else if(FLAG_GOLD_LV_NUM <= num){
        return GOODS_FLAG_GOLD_PC;
    }
    else if(FLAG_SILVER_LV_NUM <= num){
        return GOODS_FLAG_SILVER_PC;
    }
    else if(FLAG_BRONZE_LV_NUM <= num){
        return GOODS_FLAG_BRONZE_PC;
    }
    return GOODS_FLAG_NORMAL_PC;
}

//----------------------------------------------------------
/**
 * @brief	ObYtype𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	goodsIndex	  ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return 	ObY^Cv
 */
//----------------------------------------------------------
int SecretBaseData_GetGoodsType(const SECRETBASEDATA* pSBData, int goodsIndex)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,GOODS_INVALID);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return _getPCType(pSBData);
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        return pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].type;
    }
    else if( (pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].x != _INVALID_POS)
             && (pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].z != _INVALID_POS) ){
        // c͊
        return GOODS_BIG_ROCK;
    }
    return GOODS_INVALID;
}

//----------------------------------------------------------
/**
 * @brief	ObYxʒu𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	goodsIndex	  ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return 	ObYxW
 */
//----------------------------------------------------------
int SecretBaseData_GetGoodsXPos(const SECRETBASEDATA* pSBData, int goodsIndex)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,_PCPOS_X);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return _PCPOS_X;
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        return pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].x;
    }
      // c͊
    return pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].x;
}

//----------------------------------------------------------
/**
 * @brief	ObYzʒu𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	goodsIndex	  ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return 	ObYzW
 */
//----------------------------------------------------------
int SecretBaseData_GetGoodsZPos(const SECRETBASEDATA* pSBData, int goodsIndex)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,_PCPOS_Z);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return _PCPOS_Z;
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        return pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].z;
    }
    // c͊
    return pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].z;
}

//----------------------------------------------------------
/**
 * @brief	ǂ̂炢ێĂȂƂȂԂ
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	ێ
 */
//----------------------------------------------------------
int SecretBaseData_GetPlaceRockLimit(const SECRETBASEDATA* pSBData)
{
    if(pSBData->recordData.flagDeliveryCount >=  FLAG_PLATINA_LV_NUM){
        return 0;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_GOLD_LV_NUM){
        return 6;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_SILVER_LV_NUM){
        return 11;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_BRONZE_LV_NUM){
        return 15;
    }
    return 16;
}

//----------------------------------------------------------
/**
 * @brief	zu܂ŒuĂ̂Ԃ
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	uĂObY̐
 */
//----------------------------------------------------------
int SecretBaseData_GetPlaceGoodsLimit(const SECRETBASEDATA* pSBData)
{
    if(pSBData->recordData.flagDeliveryCount >=  FLAG_PLATINA_LV_NUM){
        return 15;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_GOLD_LV_NUM){
        return 15;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_SILVER_LV_NUM){
        return 15;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_BRONZE_LV_NUM){
        return 12;
    }
    return 10;
}

//==============================================================================
/**
 * |Cg	ƂA㩂ɂƂɂ炦|CgB
 * @param   none
 * @retval  |Cg
 */
//==============================================================================
int SecretBaseRecordGetPoint(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->pointCount;
}

//==============================================================================
/**
 * n̍
 * @param   none
 * @retval  RANK
 */
//==============================================================================
int SecretBaseRecordGetUGRank(const SB_RECORD_DATA* pSBRecord)
{

    if(4 == SecretBaseRecordGetFlagType(pSBRecord)){
        return UG_RANK_MASTER;
    }
    return UG_RANK_BEGINNER;
}


//==============================================================================
/**
 * |Cg	ƂA㩂ɂƂɂ炦|CgZ
 * @param   add  Z   Z|Cg
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetPoint(SB_RECORD_DATA* pSBRecord, int add)
{
    pSBRecord->pointCount = add;
}

//==============================================================================
/**
 * łl̐l	ʐMƘb񐔂łBlłPO܂ŃJEg܂B
 * @param   none
 * @retval  łl̐l
 */
//==============================================================================
int SecretBaseRecordGetTalkNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->talkCount;
}

//==============================================================================
/**
 * łl̐l	ʐMƘb񐔂łBlłPO܂ŃJEg܂B
 * @param   
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetTalkNum(SB_RECORD_DATA* pSBRecord, int meetNetID)
{
    if(pSBRecord->talkCount < _MAX){
        pSBRecord->talkCount++;
    }
}

//==============================================================================
/**
 * 	Nɓグ񐔁BlɂĂJEg܂B
 * @param   
 * @retval  none
 */
//==============================================================================
int SecretBaseRecordGetSendItemNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->sendItemCount;
}

//==============================================================================
/**
 * 	Nɓグ񐔁BlɂĂJEg܂B
 * @param   
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetSendItemNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->sendItemCount < _MAX){
        pSBRecord->sendItemCount++;
    }
}

//==============================================================================
/**
 * n^Ƃ	̃n^Ƃ񐔂łBlłJEg܂B
 * @param   none
 * @retval  n^Ƃ
 */
//==============================================================================
int SecretBaseRecordGetFlagConquerNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagConquerCount;
}

//==============================================================================
/**
 * n^Ƃ	̃n^Ƃ񐔂łBlłJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetFlagConquerNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagConquerCount < _MAX){
        pSBRecord->flagConquerCount++;
    }
}

//----------------------------------------------------------
/**
 * @brief	p\R̊type𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	n^N
 */
//----------------------------------------------------------

int SecretBaseRecordGetFlagType(const SB_RECORD_DATA* pSBRecord)
{
    int num = pSBRecord->flagDeliveryCount;
    
    if(FLAG_PLATINA_LV_NUM <= num){
        return 4;
    }
    else if(FLAG_GOLD_LV_NUM <= num){
        return 3;
    }
    else if(FLAG_SILVER_LV_NUM <= num){
        return 2;
    }
    else if(FLAG_BRONZE_LV_NUM <= num){
        return 1;
    }
    return 0;
}

//==============================================================================
/**
 * n^[i	̃n^[i񐔂łBlłJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
int SecretBaseRecordGetFlagDeliveryNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagDeliveryCount;
}

//==============================================================================
/**
 * n^[i	̃n^[i񐔂łBlłJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetFlagDeliveryNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagDeliveryCount < _MAX){
        pSBRecord->flagDeliveryCount++;
    }
}

//==============================================================================
/**
 * n^[i	̃n^[i񐔂łBlłJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
#ifdef PM_DEBUG
void D_SecretBaseRecordSetFlagDeliveryNum(SB_RECORD_DATA* pSBRecord,int num)
{
    pSBRecord->flagDeliveryCount = num;
}
#endif

//==============================================================================
/**
 * ^}@	~jQ[ŁA^}@o񐔂łB߂^}@oĂJEg܂B
 * @param   none
 * @retval  ^}@
 */
//==============================================================================
int SecretBaseRecordGetStoneNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->stoneCount;
}

//==============================================================================
/**
 * ^}@	~jQ[ŁA^}@o񐔂łB߂^}@oĂJEg܂B
 * @param   add  
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetStoneNum(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->stoneCount > (_MAX - add))){
        pSBRecord->stoneCount = _MAX;
    }
    else{
        pSBRecord->stoneCount += add;
    }
}

//==============================================================================
/**
 * ΂@	΂@񐔂łB~jQ[Ŏɓꂽ΂̐łB
 * @param   none
 * @retval  ^}@
 */
//==============================================================================
int SecretBaseRecordGetFossilNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->fossilCount;
}

//==============================================================================
/**
 * ΂@	΂@񐔂łB~jQ[Ŏɓꂽ΂̐łB
 * @param   add   
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetFossilNum(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->fossilCount > (_MAX - add))){
        pSBRecord->fossilCount = _MAX;
    }
    else{
        pSBRecord->fossilCount += add;
    }
}

//==============================================================================
/**
 * @	@񐔂łB~jQ[Ŏɓꂽ̐łB
 * @param   none
 * @retval  @
 */
//==============================================================================

int SecretBaseRecordGetTreasureNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->treasureCount;
}

//==============================================================================
/**
 * @	@񐔂łB~jQ[Ŏɓꂽ̐łB
 * @param   add   
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTreasureNum(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->treasureCount > (_MAX - add))){
        pSBRecord->treasureCount = _MAX;
    }
    else{
        pSBRecord->treasureCount += add;
    }
}

//==============================================================================
/**
 * gbv	gbvɂ񐔂łB
 * @param   none
 * @retval  gbv
 */
//==============================================================================

int SecretBaseRecordGetTrapConquerNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->trapConquerCount;
}

//==============================================================================
/**
 * gbv	gbvɂ񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTrapConquerNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->trapConquerCount < _MAX){
        pSBRecord->trapConquerCount++;
    }
}

//==============================================================================
/**
 * gbvɂ	gbvɂ񐔂łB
 * @param   none
 * @retval  gbvɂ
 */
//==============================================================================

int SecretBaseRecordGetTrapTumbleNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->trapTumbleCount;
}

//==============================================================================
/**
 * gbvɂ	gbvɂ񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTrapTumbleNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->trapTumbleCount < _MAX){
        pSBRecord->trapTumbleCount++;
    }
}

//==============================================================================
/**
 * l	gbvɂĂl񐔂łB
 * @param   none
 * @retval  l
 */
//==============================================================================

int SecretBaseRecordGetTrapRescueNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->trapRescueCount;
}

//==============================================================================
/**
 * l	gbvɂĂl񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTrapRescueNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->trapRescueCount < _MAX){
        pSBRecord->trapRescueCount++;
    }
}

//==============================================================================
/**
 * 	Nɓ񐔂łBЂƂĂAJEg܂B
 * @param   none
 * @retval  
 */
//==============================================================================

int SecretBaseRecordGetItemRecvNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->itemRecvCount;
}

//==============================================================================
/**
 * 	Nɓ񐔂łBЂƂĂAJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetItemRecvNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->itemRecvCount < _MAX){
        pSBRecord->itemRecvCount++;
    }
}

//==============================================================================
/**
 * Ƃꂽ	NɃn^Ƃꂽ񐔂łB
 * @param   none
 * @retval  Ƃꂽ
 */
//==============================================================================

int SecretBaseRecordGetFlagStealNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagStealCount;
}

//==============================================================================
/**
 * Ƃꂽ	NɃn^Ƃꂽ񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetFlagStealNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagStealCount < _MAX){
        pSBRecord->flagStealCount++;
    }
}

//==============================================================================
/**
 * Ԃ	n^Ԃ񐔂łB
 * @param   none
 * @retval  Ƃꂽ
 */
//==============================================================================

int SecretBaseRecordGetFlagReverseNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagReverseCount;
}

void SecretBaseRecordSetFlagReverseNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagReverseCount < _MAX){
        pSBRecord->flagReverseCount++;
    }
}

//==============================================================================
/**
 * z	z񐔂łB
 * @param   none
 * @retval  z
 */
//==============================================================================

int SecretBaseRecordGetRelocateNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->relocateCount;
}

void SecretBaseRecordSetRelocateNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->relocateCount < _MAX){
        pSBRecord->relocateCount++;
    }
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒuݒ肷
 * @param	pSec			閧nf[^
 * @param	x,z,dir			ȍꏊ
 * @return	none
 */
//---------------------------------------------------------------------------
void SecretBaseSetSecretBasePosition(SECRETBASEDATA* pSec,int x,int z,int dir)
{
    pSec->xpos = x;         // hÄʒu
    pSec->zpos = z;
    pSec->dir = dir;        // OɏoĂhA̕
    pSec->bMake = TRUE;     //  ǂ
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒuX𓾂邷
 * @param	pSec			閧nf[^
 * @param	x,z,dir			ȍꏊ
 * @return	none
 */
//---------------------------------------------------------------------------
int SecretBaseGetSecretBasePositionX(const SECRETBASEDATA* pSec)
{
    return pSec->xpos;         // hÄʒu
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒuZ𓾂邷
 * @param	pSec			閧nf[^
 * @return	z			ȍꏊ
 */
//---------------------------------------------------------------------------
int SecretBaseGetSecretBasePositionZ(const SECRETBASEDATA* pSec)
{
    return pSec->zpos;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒu𓾂邷
 * @param	pSec			閧nf[^
 * @return	dir			ȍꏊ
 */
//---------------------------------------------------------------------------
int SecretBaseGetSecretBasePositionDir(const SECRETBASEDATA* pSec)
{
    return pSec->dir;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nƂ邩ǂ
 * @param	pSec			閧nf[^
 * @return	ĂTRUE
 */
//---------------------------------------------------------------------------
BOOL SecretBaseIsSecretBaseMake(const SECRETBASEDATA* pSec)
{
    return pSec->bMake;     //  ǂ
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nf[^o
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	SECRETBASEDATA	閧nf[^|C^
 */
//---------------------------------------------------------------------------
SECRETBASEDATA* SaveData_GetSecretBaseData(SAVEDATA * sv)
{
	UNDERGROUNDDATA* ugd;
	ugd = SaveData_Get(sv, GMDATA_ID_UNDERGROUNDDATA);
	return &ugd->base;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nR[hf[^o
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	SB_RECORD_DATA	閧nR[hf[^|C^
 */
//---------------------------------------------------------------------------
SB_RECORD_DATA* SaveData_GetSecretBaseRecord(SAVEDATA * sv)
{
	UNDERGROUNDDATA* ugd;
	ugd = SaveData_Get(sv, GMDATA_ID_UNDERGROUNDDATA);
	return &ugd->base.recordData;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nR[hf[^o
 * @param	pSec			閧nf[^
 * @return	SB_RECORD_DATA	閧nR[hf[^|C^
 */
//---------------------------------------------------------------------------
SB_RECORD_DATA* SecretBaseGetSecretBaseRecord(SECRETBASEDATA* pSec)
{
	return &pSec->recordData;
}

//---------------------------------------------------------------------------
/**
 * @brief	nACef[^Z[uo
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	UNDERGROUNDDATA	nACef[^|C^
 */
//---------------------------------------------------------------------------
UNDERGROUNDDATA* SaveData_GetUnderGroundData(SAVEDATA * sv)
{
	UNDERGROUNDDATA* ugd;
	ugd = SaveData_Get(sv, GMDATA_ID_UNDERGROUNDDATA);
	return ugd;
}


#ifdef PM_DEBUG

//----------------------------------------------------------
/**
 * @brief	fobOpFn󕨂΂
 * @param	pSBData	      UNDERGROUNDDATA[N|C^
 * @param	type     nACe^Cv
 */
//----------------------------------------------------------
void Debug_UnderGroundData_AddTreasure(UNDERGROUNDDATA* pUGData, int type)
{
    int i = _getFreeBagTreasureItemIndex(pUGData);
    if(i == -1){
        return;
    }
    GF_ASSERT(DIG_PARTS_TREASURE_MIN <= type);
    GF_ASSERT(type < DIG_PARTS_TREASURE_MAX);
    pUGData->bagTreasure[i] = type;
}

static SB_LOCK* _getFreeLockBuff(SECRETBASEDATA* pSBData)
{
    int i;
    for(i = 0;i < SECRETBASE_LOCK_NUM_MAX; i++){
        if( (pSBData->rockPos[i].x == _INVALID_POS) &&
            (pSBData->rockPos[i].z == _INVALID_POS) ){
            return &pSBData->rockPos[i];
        }
    }
    return NULL;
}

static SB_GOODS* _getFreeGoodsBuff(SECRETBASEDATA* pSBData)
{
    int i;
    for(i = 0;i < SECRETBASE_GOODS_NUM_MAX; i++){
        if( pSBData->goodsPos[i].type == GOODS_INVALID ){
            return &pSBData->goodsPos[i];
        }
    }
    return NULL;
}

//----------------------------------------------------------
/**
 * @brief	fobOpFObYݒu  (p\Rւo^܂)
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	name	Oւ̃|C^
 * @param	sex		ʎw
 */
//----------------------------------------------------------
void Debug_SecretBaseData_AddGoods(SECRETBASEDATA* pSBData, int goodsType, int x, int z)
{
    if(GOODS_BIG_ROCK == goodsType){
        SB_LOCK* pLock = _getFreeLockBuff(pSBData);
        if(pLock != NULL){
            pLock->x = x;
            pLock->z = z;
        }
    }
    else if(goodsType < GOODS_BIG_ROCK){  // p\R͌Œʒu
    }
    else{
        SB_GOODS* pGoods = _getFreeGoodsBuff(pSBData);
        if(pGoods != NULL){
            pGoods->type = goodsType;
            pGoods->x = x;
            pGoods->z = z;
        }
    }
}


#endif //PM_DEBUG
