//============================================================================================
/**
 * @file	wifihistory_local.h
 * @brief
 * @date	2006.03.25
 */
//============================================================================================


#include "savedata/savedata.h"
#include "savedata/wifihistory.h"
#include "wifihistory_local.h"

#include "gflib/assert.h"

//============================================================================================
//============================================================================================


//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	WiFiʐM[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int WIFIHISTORY_GetWorkSize(void)
{
	return sizeof(WIFI_HISTORY);
}

//----------------------------------------------------------
/**
 * @brief	WiFiʐM[N̏
 * @param	hist
 * @return	WIFI_HISTORY	擾[Nւ̃|C^
 */
//----------------------------------------------------------
void WIFIHISTORY_Init(WIFI_HISTORY * hist)
{
	MI_CpuClear32(hist, sizeof(WIFI_HISTORY));
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	WiFiʐMZ[uf[^̎擾
 * @param	sv		Z[uf[^ւ̃|C^
 * @return	WIFI_HISTORYf[^ւ̃|C^
 */
//----------------------------------------------------------
WIFI_HISTORY * SaveData_GetWifiHistory(SAVEDATA * sv)
{
	return (WIFI_HISTORY*)SaveData_Get(sv, GMDATA_ID_WIFIHISTORY);
}

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	̍AnZbg
 * @param	wh			WIFIf[^ւ̃|C^
 * @param	nation		wR[h
 * @param	area		nwR[h
 */
//----------------------------------------------------------
void WIFIHISTORY_SetMyNationArea(WIFI_HISTORY * wh, int nation, int area)
{
	GF_ASSERT(nation < WIFI_NATION_MAX);
	GF_ASSERT(area < WIFI_AREA_MAX);
	wh->my_nation = nation;
	wh->my_area = area;
	WIFIHISTORY_SetStat(wh, nation, area, WIFIHIST_STAT_MINE);
}

//----------------------------------------------------------
/**
 * @brief	̍R[h擾
 * @param	wh			WIFIf[^ւ̃|C^
 * @return	int			wR[h
 */
//----------------------------------------------------------
int WIFIHISTORY_GetMyNation(const WIFI_HISTORY * wh)
{
	return wh->my_nation;
}

//----------------------------------------------------------
/**
 * @brief	̒nR[h擾
 * @param	wh			WIFIf[^ւ̃|C^
 * @return	int			nwR[h
 */
//----------------------------------------------------------
int WIFIHISTORY_GetMyArea(const WIFI_HISTORY * wh)
{
	return wh->my_area;
}

//----------------------------------------------------------
/**
 * @brief	ԃR[h̎擾
 * @param	wh			WIFIf[^ւ̃|C^
 * @param	nation		wR[h
 * @param	area		nwR[h
 * @return	WIFIHIST_STAT	ԎwID
 */
//----------------------------------------------------------
WIFIHIST_STAT WIFIHISTORY_GetStat(const WIFI_HISTORY * wh, int nation, int area)
{
	WIFIHIST_STAT stat;
	GF_ASSERT(nation < WIFI_NATION_MAX);
	GF_ASSERT(area < WIFI_AREA_MAX);

	if (nation == 0) {
		return WIFIHIST_STAT_NODATA;
	}
	stat = (wh->data[(nation - 1) * NATION_DATA_SIZE + area / 4] >> ((area % 4) * 2)) & 3;

	return stat;
}

//----------------------------------------------------------
/**
 * @param	wh			WIFIf[^ւ̃|C^
 * @param	nation		wR[h
 * @param	area		nwR[h
 * @param	stat		ԎwID
 */
//----------------------------------------------------------
void WIFIHISTORY_SetStat(WIFI_HISTORY * wh, int nation, int area, WIFIHIST_STAT stat)
{
	u8 * p;
	u8 mask = 3;
	u8 data;

	GF_ASSERT(stat < WIFIHIST_STAT_MAX);
	GF_ASSERT(nation < WIFI_NATION_MAX);
	GF_ASSERT(area < WIFI_AREA_MAX);

	if (nation == 0) {
		return;
	}
	p = &wh->data[(nation - 1) * NATION_DATA_SIZE + area / 4];

	*p &= ((mask << ((area % 4) * 2))^0xff);
	*p |= stat << ((area % 4) * 2);
	
	if (nation != WIFI_NATION_JAPAN) {
		WIFIHISTORY_SetWorldFlag(wh, TRUE);
	}
}


//----------------------------------------------------------
/**
 * @brief	E[hǂ̃tO擾
 * @param	wh			WIFIf[^ւ̃|C^
 * @return	BOOL		TRUÊƂAE[h
 */
//----------------------------------------------------------
BOOL WIFIHISTORY_GetWorldFlag(const WIFI_HISTORY * wh)
{
	return wh->world_flag;
}


//----------------------------------------------------------
/**
 * @brief	E[h̃tOZbg
 * @param	wh			WIFIf[^ւ̃|C^
 * @param	flag		ݒ肷liTRUE/FALSEj
 */
//----------------------------------------------------------
void WIFIHISTORY_SetWorldFlag(WIFI_HISTORY * wh, BOOL flag)
{
	wh->world_flag = flag;
}


//----------------------------------------------------------
/**
 * @brief	tXVœeXV
 * @param	wh			WIFIf[^ւ̃|C^
 */
//----------------------------------------------------------
void WIFIHISTORY_Update(WIFI_HISTORY * wh)
{
	int i, j;
	u8 data;
	for (i = 0; i < (WIFI_NATION_MAX - 1) * NATION_DATA_SIZE; i++) {
		data = wh->data[i];
		for (j = 0; j < 8; j+=2) {
			if (((data >> j) & 3) == WIFIHIST_STAT_NEW) {
				data &= ((3 << j)^0xff);
				data |= (WIFIHIST_STAT_EXIST << j);
			}
		}
		wh->data[i] = data;
	}
}


