//============================================================================================
/**
 * @file	worldtrade_data.c
 * @brief	EZ[uf[^
 * @author	mori GAME FREAK inc.
 * @date	2006.04.30
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"

#include "savedata/worldtrade_data.h"

#define POKEMON_DATA_SIZE		(236)

//============================================================================================
//============================================================================================

struct WORLDTRADE_DATA{
	u8 PokemonData[POKEMON_DATA_SIZE];	// a|P̃f[^
	u16 		flag;					// aĂ邩tO
	u16 		toBox;					// {bNXmni莝̏ꍇRETURN_POSITION_TEMOTIj
	GF_DATE		lastExchangeDate;		// ŏIt
};



//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
WORLDTRADE_DATA * SaveData_GetWorldTradeData(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_WORLDTRADEDATA);
}


//----------------------------------------------------------
/**
 * @brief	ԕێ[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int WorldTradeData_GetWorkSize(void)
{
	return sizeof(WORLDTRADE_DATA);
}

//==============================================================================
/**
 * $brief   Eԕۑf[^̊m
 *
 * @param   heapID		
 *
 * @retval  WORLDTRADE_DATA *		
 */
//==============================================================================
WORLDTRADE_DATA * WorldTradeData_AllocWork(u32 heapID)
{
	WORLDTRADE_DATA * WorldTradeData;
	WorldTradeData = sys_AllocMemory(heapID, sizeof(WORLDTRADE_DATA));
	
	WorldTradeData_Init( WorldTradeData );

	return WorldTradeData;
	
}

//==============================================================================
/**
 * $brief   f[^
 *
 * @param   randomgroup		
 *
 * @retval  none		
 */
//==============================================================================
void WorldTradeData_Init(WORLDTRADE_DATA * WorldTradeData )
{
	
	MI_CpuClearFast(WorldTradeData, sizeof(WORLDTRADE_DATA));
	
}


//==============================================================================
/**
 * $brief   aĂ邩H
 *
 * @param   WorldTradeData		
 *
 * @retval  int		0:aĂȂ	1:aĂ
 */
//==============================================================================
int  WorldTradeData_GetFlag( WORLDTRADE_DATA* WorldTradeData )
{
	return WorldTradeData->flag;
}
//==============================================================================
/**
 * $brief   aĂtȎ
 *
 * @param   WorldTradeData		
 *
 * @retval  int		
 */
//==============================================================================
void  WorldTradeData_SetFlag( WORLDTRADE_DATA* WorldTradeData, int flag )
{
	WorldTradeData->flag = flag;
}


//==============================================================================
/**
 * $brief   |Pf[^o
 *
 * @param   WorldTradeData		
 * @param   poke		
 *
 * @retval  none		
 */
//==============================================================================
void  WorldTradeData_GetPokemonData( WORLDTRADE_DATA* WorldTradeData, POKEMON_PARAM *poke )
{
	MI_CpuCopyFast( WorldTradeData->PokemonData, (void*)poke, POKEMON_DATA_SIZE );
}

//==============================================================================
/**
 * $brief   |PâŁARs[ۑĂ
 *
 * @param   WorldTradeData		
 * @param   poke		
 *
 * @retval  none		
 */
//==============================================================================
void  WorldTradeData_SetPokemonData( WORLDTRADE_DATA* WorldTradeData, POKEMON_PARAM *poke, int boxno )
{
	MI_CpuCopyFast( (void*)poke, WorldTradeData->PokemonData, POKEMON_DATA_SIZE );
}


//==============================================================================
/**
 * $brief   Ō̓𓾂
 *
 * @param   WorldTradeData		
 *
 * @retval  int		0:aĂȂ	1:aĂ
 */
//==============================================================================
GF_DATE  WorldTradeData_GetLastDate( WORLDTRADE_DATA* WorldTradeData )
{
	return WorldTradeData->lastExchangeDate;
}
//==============================================================================
/**
 * $brief   Ō̓L^
 *
 * @param   WorldTradeData		
 *
 * @retval  int		
 */
//==============================================================================
void  WorldTradeData_SetLastDate( WORLDTRADE_DATA* WorldTradeData, GF_DATE date )
{
	WorldTradeData->lastExchangeDate = date;
}

//==============================================================================
/**
 * @brief   |PaĂBOXNOiĂRETURN_POSITION_TEMOTIj擾
 *
 * @param   WorldTradeData		
 *
 * @retval  int		
 */
//==============================================================================
int WorldTradeData_GetBoxNo( WORLDTRADE_DATA* WorldTradeData )
{
	return WorldTradeData->toBox;
}

