//============================================================================================
/**
 * @file	zukanwork.c
 * @brief	}ӏԃANZXp\[X
 * @author	tamada GAME FREAK inc.
 * @date	2005.12.15
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"
#include "poketool/poke_tool.h"

#include "savedata/zukanwork.h"

#include "poketool/monsno.h"
#include "include/application/zukanlist/zkn_world_text_data.h"
#include "src/application/zukanlist/zkn_worldtext.h"

//============================================================================================
//============================================================================================
enum {
	POKEZUKAN_ARRAY_LEN = 16,	///<|P}ӃtOẑ16 * 32 = 512܂őv

	POKEZUKAN_UNKNOWN_NUM = UNK_END,///<Am[

	MAGIC_NUMBER = 0xbeefcafe,

	POKEZUKAN_DEOKISISU_MSK = 0xf,	// bit}XN
};

//----------------------------------------------------------
/**
 * @brief	ԃf[^^`
 */
//----------------------------------------------------------
struct _ZUKAN_WORK {
	u32 zukan_magic;						///<}WbNio[
	u32 get_flag[POKEZUKAN_ARRAY_LEN];		///<߂܂tOp[N
	u32 see_flag[POKEZUKAN_ARRAY_LEN];		///<tOp[N
	u32 sex_flag[2][POKEZUKAN_ARRAY_LEN];	///<IXXtOp[N
	u32 PachiRandom;						///<pb`[pێ[N
	u8 SiiusiTurn;							///<V[EVpێ[N		2bitKv	1bit*2
	u8 SiidorugoTurn;						///<V[hSpێ[N	2bitKv	1bit*2
	u8 MinomuttiTurn;						///<~mb`pێ[N	6bitKv	2bit*3
	u8 MinomesuTurn;						///<~mXpێ[N		6bitKv	2bit*3
	u8 UnknownTurn[ POKEZUKAN_UNKNOWN_NUM ];///<Am[ԍ
	u8 GraphicVersionUp;					///<OtBbNo[Wp@\gtO
	u8 TextVersionUp[ ZKN_WORLD_TEXT_POKE_NUM ];	///<o[WAbv}XN
	u8 TextVersionUpMasterFlag;				///<o[WAbvMastertO
	u8 zukan_get;							///<擾tO
	u8 zenkoku_flag;						///<S}ӕێtO
};

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	f[^p[ÑTCY擾
 * @return	int		ZUKAN_WORK̃TCY
 */
//----------------------------------------------------------
int ZukanWork_GetWorkSize(void)
{
	return sizeof(ZUKAN_WORK);
}
//----------------------------------------------------------
/**
 * @brief	f[^p[N̐
 * @param	heapID		gpq[v̎w
 * @return	ZUKAN_WORK	ZUKAN_WORKւ̃|C^
 */
//----------------------------------------------------------
ZUKAN_WORK * ZukanWork_AllocWork(u32 heapID)
{
	ZUKAN_WORK * zw;
	zw = sys_AllocMemory(heapID, sizeof(ZUKAN_WORK));
	ZukanWork_Init(zw);
	return zw;
}

//----------------------------------------------------------
/**
 * @brief	f[^p[ÑRs[
 * @param	from	Rs[ZUKAN_WORKւ̃|C^
 * @param	to		Rs[ZUKAN_WORKւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_Copy(const ZUKAN_WORK * from, ZUKAN_WORK * to)
{
	MI_CpuCopy8(from, to, sizeof(ZUKAN_WORK));
}

//============================================================================================
//
//				֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	񃏁[N̐`FbN
 */
//----------------------------------------------------------
static inline void zukan_incorrect(const ZUKAN_WORK * zw)
{
	GF_ASSERT(zw->zukan_magic == MAGIC_NUMBER);
}
//----------------------------------------------------------
/**
 * @brief	|Pio[͈̔̓`FbN
 */
//----------------------------------------------------------
static inline BOOL monsno_incorrect(u16 monsno)
{
	if (monsno == 0 || monsno > MONSNO_END) {
		GF_ASSERT_MSG(0, "|Pio[ُF%d\n", monsno);
		return TRUE;
	} else {
		return FALSE;
	}
}

//----------------------------------------------------------
/**
 * @brief	ėprbg`FbN
 */
//----------------------------------------------------------
static inline BOOL check_bit(const u8 * array, u16 flag_id)
{
	flag_id --;
	return 0 != (array[flag_id >> 3] & (1 << (flag_id & 7)));
}
//----------------------------------------------------------
/**
 * @brief	ėprbgZbg
 */
//----------------------------------------------------------
static inline void set_bit(u8 * array, u16 flag_id)
{
	flag_id --;
	array[flag_id >> 3] |= 1 << (flag_id & 7);
}
//----------------------------------------------------------
/**
 * @brief	ėp1rbgf[^Zbg
 * ̃rbgN[ɂĂݒ肵܂
 */
//----------------------------------------------------------
static inline void setnum_bit(u8 * array, u8 num, u16 flag_id)
{
	GF_ASSERT( num < 2 );
	flag_id --;

	array[flag_id >> 3] &= ~(1 << (flag_id & 7));
	array[flag_id >> 3] |= num << (flag_id & 7);
}

#if 0
static inline void reset_bit(u8 * array, u16 flag_id)
{
	array[flag_id >> 3] &= (1 << (flag_id & 7)) ^ 0xff;
}
#endif
//----------------------------------------------------------
/**
 * @brief	ėprbgJEg
 */
//----------------------------------------------------------
static inline u16 count_bit(const u32 * array, u32 array_max)
{
	int count, idx;
	u32 item;
	count = 0;
	for (idx = 0; idx < array_max; idx ++) {
		for (item = array[idx]; item != 0; item >>= 1) {
			if (item & 1) {
				count ++;
			}
		}
	}
	return count;
}

//----------------------------------------------------------
/**
 * @brief	ėp2rbg`FbN
 * 1bitł1`xw肷悤ɂȂĂ
 * 2bitł0`xw肷悤ɂ
 */
//----------------------------------------------------------
static inline u32 check_bit2(const u8 * array, u16 flag_id)
{
	return (array[flag_id >> 2] >> ((flag_id & 3)*2)) & 0x3;
}
//----------------------------------------------------------
/**
 * @brief	ėp2rbgf[^Zbg
 * ̃rbgN[ɂĂݒ肵܂
 */
//----------------------------------------------------------
static inline void setnum_bit2(u8 * array, u8 num, u16 flag_id)
{
	GF_ASSERT( num < 4 );

	array[flag_id >> 2] &= ~(0x3 << ((flag_id & 3)*2) );
	array[flag_id >> 2] |= num << ((flag_id & 3)*2);
}


//----------------------------------------------------------
/**
 * @brief	݂rbgݒ
 */
//----------------------------------------------------------
static inline void set_see_bit(ZUKAN_WORK * zw, u16 flag_id)
{
	set_bit((u8*)zw->see_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	܂rbgݒ
 */
//----------------------------------------------------------
static inline void set_get_bit(ZUKAN_WORK * zw, u16 flag_id)
{
	set_bit((u8*)zw->get_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	ʃrbgݒ	ۂɐݒ
 * ŏ̐ʐݒ2vfڂ̔zɂlݒ肷
 * ɂ2vfڂl͈̎Ⴄʂ̃|P݂ĂȂ
 * ƂƂɂȂ
 */
//----------------------------------------------------------
static inline void set_sex_bit_first_second(ZUKAN_WORK * zw, u8 num, u8 no, u16 flag_id)
{
	if( no == ZUKAN_WORK_SEX_FIRST ){
		setnum_bit((u8*)zw->sex_flag[ZUKAN_WORK_SEX_SECOND], num, flag_id);
	}
	setnum_bit((u8*)zw->sex_flag[no], num, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	ʃrbgݒ
 */
//----------------------------------------------------------
static inline void set_sex_bit(ZUKAN_WORK * zw, u8 num, u8 no, u16 monsno)
{
	GF_ASSERT_MSG( num <= 2, "num = %d", num );	// j@@sȊO܂
	if( num == PARA_UNK ){		// UNKNOW
		num = PARA_MALE;		// jɂ
	}
	set_sex_bit_first_second(zw, num, no, monsno);
}
//----------------------------------------------------------
/**
 * @brief	݂rbgONOFF`FbN
 */
//----------------------------------------------------------
static inline BOOL check_see_bit(const ZUKAN_WORK * zw, u16 flag_id)
{
	return check_bit((const u8*)zw->see_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	܂rbgONOFF`FbN
 */
//----------------------------------------------------------
static inline BOOL check_get_bit(const ZUKAN_WORK * zw, u16 flag_id)
{
	return check_bit((const u8*)zw->get_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	ʃrbgONOFF`FbN
 */
//----------------------------------------------------------
static inline u8 check_sex_bit(const ZUKAN_WORK * zw, u16 flag_id, u8 first_second)
{
	return check_bit((const u8*)zw->sex_flag[first_second], flag_id);
}

//----------------------------------------------------------
/**
 * @brief	ő̗ݒ
 */
//----------------------------------------------------------
static inline void SetZukanRandom(ZUKAN_WORK * zw, u16 monsno, u32 rand)
{
	if (monsno == MONSNO_PATTIIRU) {
		zw->PachiRandom = rand;
	}
}

//----------------------------------------------------------
/**
 * @brief	Am[̌ݐݒ萔擾
 */
//----------------------------------------------------------
static inline int get_zukan_unknown_turn_num( const ZUKAN_WORK * zw )
{
	int i;
	for( i=0; i<POKEZUKAN_UNKNOWN_NUM; i++ ){
		if( zw->UnknownTurn[i] == 0xff ){
			break;
		}
	}
	return i;
}
//----------------------------------------------------------
/**
 * @brief	Am[tH[ݒς݂`FbN
 */
//----------------------------------------------------------
static inline BOOL check_zukan_unknown_turn_set( const ZUKAN_WORK * zw, u8 form )
{
	int i;
	for( i=0; i<POKEZUKAN_UNKNOWN_NUM; i++ ){
		if( zw->UnknownTurn[i] == form ){
			return TRUE;
		}
	}
	return FALSE;
}
//----------------------------------------------------------
/**
 * @brief	Am[f[^̍ŌɌ`IDݒ
 */
//----------------------------------------------------------
static inline void SetZukanUnknownTurn( ZUKAN_WORK * zw, int form)
{
	int set_idx;

	// ݒς݂`FbN
	if( check_zukan_unknown_turn_set( zw, form ) ){
		return;
	}

	set_idx = get_zukan_unknown_turn_num( zw );
	if( set_idx < POKEZUKAN_UNKNOWN_NUM ){
		zw->UnknownTurn[ set_idx ] = form;
	}
}

//----------------------------------------------------------
/**
 * @brief	V[EV@V[hŠݐݒ萔擾
 */
//----------------------------------------------------------
static int get_zukan_siiusi_turn_num( const ZUKAN_WORK * zw, u32 monsno )
{
	u32 first_form;
	u32 second_form;
	const u8* arry;
	GF_ASSERT( (monsno == MONSNO_SIIUSI) || (monsno == MONSNO_SIIDORUGO) );
	
	// ĂȂƂ0
	if( ZukanWork_GetPokeSeeFlag( zw, monsno ) == FALSE ){	
		return 0;
	}

	if( monsno == MONSNO_SIIUSI ){
		arry = &zw->SiiusiTurn;
	}else{
		arry = &zw->SiidorugoTurn;
	}
	first_form = check_bit( arry, 1 );	
	second_form = check_bit( arry, 2 );	

	if( first_form == second_form ){	// ŏƂQ߂ꏏȂP񂾂
		return 1;
	}
	return 2;
}
//----------------------------------------------------------
/**
 * @brief	~mb`@~mX@tH[ݒς݂`FbN
 * @param	form	0 or 1
 * * 0or1ō쐬Ă܂B
 */
//----------------------------------------------------------
static BOOL check_zukan_siiusi_turn_set( const ZUKAN_WORK * zw, u32 monsno, u8 form )
{
	u32 get_form;
	u32 i;
	u32 roop_num;
	const u8* arry;
	GF_ASSERT( (monsno == MONSNO_SIIUSI) || (monsno == MONSNO_SIIDORUGO) );
	
	// ĂȂƂ͐ݒ肳Ă킯Ȃ
	if( ZukanWork_GetPokeSeeFlag( zw, monsno ) == FALSE ){	
		return FALSE;
	}

	if( monsno == MONSNO_SIIUSI ){
		arry = &zw->SiiusiTurn;
	}else{
		arry = &zw->SiidorugoTurn;
	}

	// ݒ萔`FbN
	// P񂵂ĂȂƂ͂Qڂ̃rbǵA
	// _~[f[^Ȃ̂ŁAȂ
	roop_num = get_zukan_siiusi_turn_num( zw, monsno );
	for( i=0; i<roop_num; i++ ){
		get_form = check_bit( arry, i+1 );	
		if( get_form == form ){
			return TRUE;
		}
	}
	return FALSE;
}
//----------------------------------------------------------
/**
 * @brief	V[EV@V[hSf[^̍ŌɌ`IDݒ
 * * 0or1ō쐬Ă܂B
 */
//----------------------------------------------------------
static void SetZukanSiiusiTurn( ZUKAN_WORK * zw, u32 monsno, int form)
{
	int set_idx;
	u8* arry;
	GF_ASSERT( (monsno == MONSNO_SIIUSI) || (monsno == MONSNO_SIIDORUGO) );

	// ݒς݂`FbN
	if( check_zukan_siiusi_turn_set( zw, monsno, form ) ){
		return;
	}

	if( monsno == MONSNO_SIIUSI ){
		arry = &zw->SiiusiTurn;
	}else{
		arry = &zw->SiidorugoTurn;
	}

	set_idx = get_zukan_siiusi_turn_num( zw, monsno );
	if( set_idx < 2 ){	// 0Ȃŏɐݒ@1Ȃ2߂ɐݒ 2Ȃݒ肵Ȃ
		setnum_bit( arry, form, set_idx+1 );
		if( set_idx == 0 ){
			setnum_bit( arry, form, set_idx+2 );	// Gŕۑ
		}
	}
}

//----------------------------------------------------------
/**
 * @brief	~mb`@~mX̌ݐݒ萔擾
 * `0`2
 */
//----------------------------------------------------------
static int get_zukan_minomutti_turn_num( const ZUKAN_WORK * zw, u32 monsno )
{
	u32 get_form;
	int i;
	const u8* arry;

	GF_ASSERT( (monsno == MONSNO_MINOMUTTI) || (monsno == MONSNO_MINOMESU) );
	// ĂȂƂ0
	if( ZukanWork_GetPokeSeeFlag( zw, monsno ) == FALSE ){	
		return 0;
	}

	if( monsno == MONSNO_MINOMUTTI ){
		arry = &zw->MinomuttiTurn;
	}else{
		arry = &zw->MinomesuTurn;
	}
	for( i=0; i<3; i++ ){
		get_form = check_bit2( arry, i );
		if( get_form == 3 ){
			break;
		}
	}
	return i;
}
//----------------------------------------------------------
/**
 * @brief	~mb`@~mX@tH[ݒς݂`FbN
 * @param	form	0 or 1 or 2
 * `0`2
 */
//----------------------------------------------------------
static BOOL check_zukan_minomutti_turn_set( const ZUKAN_WORK * zw, u32 monsno, u8 form )
{
	u32 get_form;
	int i;
	const u8* arry;

	GF_ASSERT( (monsno == MONSNO_MINOMUTTI) || (monsno == MONSNO_MINOMESU) );
	// ĂȂƂFALSE
	if( ZukanWork_GetPokeSeeFlag( zw, monsno ) == FALSE ){	
		return FALSE;
	}

	if( monsno == MONSNO_MINOMUTTI ){
		arry = &zw->MinomuttiTurn;
	}else{
		arry = &zw->MinomesuTurn;
	}
	for( i=0; i<3; i++ ){
		get_form = check_bit2( arry, i );
		if( get_form == form ){
			return TRUE;
		}
	}
	return FALSE;
}
//----------------------------------------------------------
/**
 * @brief	~mb`@~mXf[^̍ŌɌ`IDݒ
 * `0`2
 */
//----------------------------------------------------------
static void SetZukanMinomuttiTurn( ZUKAN_WORK * zw, u32 monsno, int form)
{
	int set_idx;
	u8* arry;
	GF_ASSERT( (monsno == MONSNO_MINOMUTTI) || (monsno == MONSNO_MINOMESU) );

	// ݒς݂`FbN
	if( check_zukan_minomutti_turn_set( zw, monsno, form ) ){
		return;
	}

	if( monsno == MONSNO_MINOMUTTI ){
		arry = &zw->MinomuttiTurn;
	}else{
		arry = &zw->MinomesuTurn;
	}

	set_idx = get_zukan_minomutti_turn_num( zw, monsno );
	if( set_idx < 3 ){
		setnum_bit2( arry, form, set_idx );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	fILVXtHݒ
 *
 *	@param	p_arry	i[̈
 *	@param	no	fILVXtH
 *	@param	num	Ԑݒ
 */
//-----------------------------------------------------------------------------
static inline void setDeokisisuFormNoCore( u32* p_arry, u8 no, u8 num )
{
	u32 shift = (24 + (num * 4));
	u32 msk = ~(POKEZUKAN_DEOKISISU_MSK << shift);
	p_arry[ POKEZUKAN_ARRAY_LEN - 1 ] &= msk;
	p_arry[ POKEZUKAN_ARRAY_LEN - 1 ] |= (no << shift);
}

//----------------------------------------------------------------------------
/**
 *	@brief	fILVXtHݒ
 *
 *	@param	zw	}Ӄ[N
 *	@param	no	fILVXtH
 *	@param	num	Ԑݒ
 */
//-----------------------------------------------------------------------------
static void setDEOKISISUFormNo( ZUKAN_WORK * zw, u8 no, u8 num )
{
	GF_ASSERT( num < ZUKAN_WORK_DEOKISISU_FORM_NUM );
	GF_ASSERT( no <= POKEZUKAN_DEOKISISU_INIT );
	// fILVXio[ݒ
	// ߂܂tǑ15bit󂢂Ă̂
	// 4bitɃf[^o^Ă
	if( num < ZUKAN_WORK_DEOKISISU_FORM_SAVEDATA_CUTNUM ){
		setDeokisisuFormNoCore( zw->get_flag, no, num );
	}else{
		setDeokisisuFormNoCore( zw->see_flag, no, num-ZUKAN_WORK_DEOKISISU_FORM_SAVEDATA_CUTNUM );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	fILVXtH擾
 *
 *	@param	p_arry	i[̈
 *	@param	num	Ԑݒ
 *
 *	@retval	tHio[
 */
//-----------------------------------------------------------------------------
static inline u32 getDeokisisuFormNoCore( const u32* p_arry, u8 num )
{
	u32 shift = (24 + (num * 4));
	u32 ret = (p_arry[ POKEZUKAN_ARRAY_LEN - 1 ] >> shift) & POKEZUKAN_DEOKISISU_MSK;
	return ret;
}
//----------------------------------------------------------------------------
/**
 *	@brief	fILVXtH擾
 *
 *	@param	zw	}Ӄ[N
 *	@retval	fILVXtH
 */
//-----------------------------------------------------------------------------
static inline u32 getDEOKISISUFormNo( const ZUKAN_WORK * zw, u8 num )
{
	u32 form;
	// fILVXio[ݒ
	// ߂܂tǑ15bit󂢂Ă̂
	// 4bitɃf[^o^Ă
	if( num < ZUKAN_WORK_DEOKISISU_FORM_SAVEDATA_CUTNUM ){
		form = getDeokisisuFormNoCore( zw->get_flag, num );
	}else{
		form = getDeokisisuFormNoCore( zw->see_flag, num - ZUKAN_WORK_DEOKISISU_FORM_SAVEDATA_CUTNUM );
	}
	return form;
}

//----------------------------------------------------------------------------
/**
 *	@brief	܂łɌfILVX̐Ԃ
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	܂łɌfILVX̐Ԃ
 */
//-----------------------------------------------------------------------------
static u32 nowGetDeokisisuFormNum( const ZUKAN_WORK * zw )
{
	int i;

	for( i=0; i<ZUKAN_WORK_DEOKISISU_FORM_NUM; i++ ){
		if( getDEOKISISUFormNo( zw, i ) == POKEZUKAN_DEOKISISU_INIT  ){
			break;
		}
	}
	return i;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ȑOɂ̌`̃fILVXĂ邩`FbN
 *
 *	@param	zw	}Ӄ[N
 *	@param	formno `
 *
 *	@retval	TRUE	
 *	@retval	FALSE	ĂȂ
 */
//-----------------------------------------------------------------------------
static BOOL checkSeeDeokisisuFormNo( const ZUKAN_WORK * zw, u32 formno )
{
	int i;
	for( i=0; i<ZUKAN_WORK_DEOKISISU_FORM_NUM; i++ ){
		if( getDEOKISISUFormNo( zw, i ) == formno  ){
			return TRUE;
		}
	}
	return FALSE;
}



//----------------------------------------------------------------------------
/**
 *	@brief	tH[io[ݒ@pbN
 */
//-----------------------------------------------------------------------------
static void SetDeokisisuFormNo( ZUKAN_WORK * zw, u16 monsno, POKEMON_PARAM* pp  )
{
	u8 form = PokeParaGet( pp, ID_PARA_form_no, NULL );
	u32 setno;

	if( monsno == MONSNO_DEOKISISU ){
		// ܂ĂȂ`FbN
		if( checkSeeDeokisisuFormNo( zw, form ) == FALSE ){
			setno = nowGetDeokisisuFormNum( zw );	// ݒʒu
			setDEOKISISUFormNo( zw, form, setno );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	fILVXtHio[obt@
 *
 *	@param	zw	}Ӄ[N
 */
//-----------------------------------------------------------------------------
static void InitDeokisisuFormNo( ZUKAN_WORK * zw )
{
	int i;
	for( i=0; i<ZUKAN_WORK_DEOKISISU_FORM_NUM; i++ ){
		setDEOKISISUFormNo( zw, 0xf, i );	// 0xfŏ
	}
}





//----------------------------------------------------------
/**
 * @brief	ȃ|P̌f[^̕ۑ
 */
//----------------------------------------------------------
static void SetZukanSpecialTurn(ZUKAN_WORK * zw, u16 monsno, POKEMON_PARAM* pp)
{
	int form;
	
	// Am[@E~EV@~mV̏Ԃ̐ݒ
	if( monsno == MONSNO_ANNOON ){
		form = PokeParaUnknownFormGet( pp );
		SetZukanUnknownTurn( zw, form );
	}else if( monsno == MONSNO_MINOMUTTI ){
		form = PokeParaGet( pp, ID_PARA_form_no, NULL );
		SetZukanMinomuttiTurn( zw, monsno, form );
	}else if( monsno == MONSNO_MINOMESU ){
		form = PokeParaGet( pp, ID_PARA_form_no, NULL );
		SetZukanMinomuttiTurn( zw, monsno, form );
	}else if( monsno == MONSNO_SIIUSI ){
		form = PokeParaGet( pp, ID_PARA_form_no, NULL );
		SetZukanSiiusiTurn( zw, monsno, form );
	}else if( monsno == MONSNO_SIIDORUGO ){
		form = PokeParaGet( pp, ID_PARA_form_no, NULL );
		SetZukanSiiusiTurn( zw, monsno, form );
	}else if( monsno == MONSNO_DEOKISISU ){
		SetDeokisisuFormNo( zw, monsno, pp );	// fILVX̃tHۑ
	}
}

//----------------------------------------------------------
/**
 * @brief	eLXgo[WzCfbNXX^[io[擾
 */
//----------------------------------------------------------
static inline int get_zukan_textversion_idx(u16 monsno)
{
	return ZKN_WT_GetMonsNo_TEXTVERPokeNum( monsno );
}
//----------------------------------------------------------
/**
 * @brief	eLXgo[WtOݒ
 */
//----------------------------------------------------------
static void SetZukanTextVersionUp(ZUKAN_WORK * zw, u16 monsno, u32 lang)
{
	int idx;
	int zkn_world_text_code;
	
	
	idx = get_zukan_textversion_idx( monsno );
	zkn_world_text_code = ZKN_WT_GetLANG_Code_ZKN_WORLD_TEXT_Code( lang );

	// ̃|PɊOf[^͂Ȃ
	if(idx == ZKN_WORLD_TEXT_POKE_NUM){ return; }

	// ̍̊Of[^͂Ȃ
	if(zkn_world_text_code == ZKN_WORLD_TEXT_NUM){ return; }

	zw->TextVersionUp[ idx ] |= 1 << zkn_world_text_code;
}
//----------------------------------------------------------
/**
 * @brief	ʏ̃|Pʎ擾
 */
//----------------------------------------------------------
static u32 get_normal_poke_sex( const ZUKAN_WORK * zw, u16 monsno, int first_second )
{
	u32 sex_first, sex_second;
	u32 ret_sex;

	// ΂ɕsȃ|Pfirst͕ssecond̓G[Ԃ
	if( PokePersonalParaGet(monsno,ID_PER_sex) == MONS_UNKNOWN ){
		if( first_second == ZUKAN_WORK_SEX_FIRST ){
			return PARA_UNK;
		}else{
			return ZUKAN_WORK_GET_SEX_ERR;
		}
	}
	
	// Ɍʂݒ肳Ă̂`FbN邽߂
	// ǂ̏ꍇłŏɌʂ擾
	sex_first = check_sex_bit( zw, monsno, ZUKAN_WORK_SEX_FIRST );

	// Ɍʂ擾Ȃ玟Ɍʂ擾
	if( first_second == ZUKAN_WORK_SEX_SECOND ){
		sex_second = check_sex_bit( zw, monsno, ZUKAN_WORK_SEX_SECOND );

		// ŏɌʂƈꏏ==܂ĂȂ
		if( sex_second == sex_first ){
			ret_sex = ZUKAN_WORK_GET_SEX_ERR;
		}else{
			ret_sex = sex_second;
		}
	}else{
		ret_sex = sex_first;
	}

	return ret_sex;
}

//----------------------------------------------------------
/**
 * @brief	Am[Ԏ擾
 */
//----------------------------------------------------------
static inline int get_unknown_see_form( const ZUKAN_WORK * zw, int idx )
{
	return zw->UnknownTurn[ idx ];
}

//----------------------------------------------------------
/**
 * @brief	V[EV@V[hSԎ擾
 * 0or1ō쐬Ă܂B
 */
//----------------------------------------------------------
static inline int get_siiusi_see_form( const ZUKAN_WORK * zw, u32 monsno, int idx )
{
	const u8* arry;
	GF_ASSERT( (monsno == MONSNO_SIIUSI) || (monsno == MONSNO_SIIDORUGO) );
	GF_ASSERT( idx < 2 );
	
	if( monsno == MONSNO_SIIUSI ){
		arry = &zw->SiiusiTurn;
	}else{
		arry = &zw->SiidorugoTurn;
	}
	return check_bit( arry, idx+1 );
}

//----------------------------------------------------------
/**
 * @brief	~mb`@~mXԎ擾
 * 0`2ō쐬Ă܂B
 */
//----------------------------------------------------------
static inline int get_minomutti_see_form( const ZUKAN_WORK * zw, u32 monsno, int idx )
{
	const u8* arry;
	GF_ASSERT( (monsno == MONSNO_MINOMUTTI) || (monsno == MONSNO_MINOMESU) );
	GF_ASSERT( idx < 3 );
	
	if( monsno == MONSNO_MINOMUTTI ){
		arry = &zw->MinomuttiTurn;
	}else{
		arry = &zw->MinomesuTurn;
	}
	return check_bit2( arry, idx );
}


//----------------------------------------------------------------------------
/**
 *	@brief	[RN}ӊɕKvȃ|P`FbN
 */
//-----------------------------------------------------------------------------
static BOOL check_ZenkokuCompMonsno( u16 monsno )
{
	int i;
	BOOL cut_check;
	static const u16 cut_check_monsno[ ZUKAN_WORK_ZENKOKU_COMP_NOPOKE_NUM ] = {
		MONSNO_MYUU,
		MONSNO_RUGIA,
		MONSNO_HOUOU,
		MONSNO_SEREBHI,
		MONSNO_ZIRAATI,
		MONSNO_DEOKISISU,
		MONSNO_ERUFI,
		MONSNO_MANAFI,
		MONSNO_DAAKU,
		MONSNO_EURISU,
		MONSNO_AUSU,
	};

	// `FbNO|P`FbN
	cut_check = TRUE;
	for( i=0; i<ZUKAN_WORK_ZENKOKU_COMP_NOPOKE_NUM; i++ ){
		if( cut_check_monsno[ i ] == monsno ){
			cut_check = FALSE;
		}
	}
	return cut_check;
}

//----------------------------------------------------------------------------
/**
 *	@brief	VIE}ӊɕKvȃ|P`FbN
 */
//-----------------------------------------------------------------------------
static BOOL check_ShinouCompMonsno( u16 monsno )
{
	int i;
	BOOL cut_check;
	static const u16 cut_check_monsno[ZUKAN_WORK_SHINOU_COMP_NOPOKE_NUM] = {
		MONSNO_MANAFI,
	};

	// `FbNO|P`FbN
	cut_check = TRUE;
	for( i=0; i<ZUKAN_WORK_SHINOU_COMP_NOPOKE_NUM; i++ ){
		if( cut_check_monsno[ i ] == monsno ){
			cut_check = FALSE;
		}
	}
	return cut_check;
}

//============================================================================================
//
//			񑀍p̊OJ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief		񃏁[N̏
 * @param	zw		񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_Init(ZUKAN_WORK * zw)
{
	memset(zw, 0, sizeof(ZUKAN_WORK));
	zw->zukan_magic = MAGIC_NUMBER;
	zw->zenkoku_flag = FALSE;

	// ߂܂ԃtOɃ_~[f[^ݒ
	memset( zw->UnknownTurn, 0xff, sizeof(u8) *  POKEZUKAN_UNKNOWN_NUM );
	zw->SiiusiTurn = 0xff;		
	zw->SiidorugoTurn = 0xff;	
	zw->MinomuttiTurn = 0xff;	
	zw->MinomesuTurn = 0xff;	

	// fILVXtH^Cvۑ̈̏
	InitDeokisisuFormNo( zw );
}

//----------------------------------------------------------
/**
 * @brief	|P܂̎擾
 * @param	zw		񃏁[Nւ̃|C^
 * @return	u16		߂܂
 */
//----------------------------------------------------------
u16 ZukanWork_GetPokeGetCount(const ZUKAN_WORK * zw)
{
	int i;
	int count;

	zukan_incorrect(zw);
	count= 0;
	for( i=1; i<=MONSNO_END; i++ ){
		if( ZukanWork_GetPokeGetFlag( zw, i ) == TRUE ){
			count ++;
		}
	}
	return count;

	// łAfILVXtOget_flaǧɓꂽ̂ŁAgpł܂
//	return count_bit(zw->get_flag, POKEZUKAN_ARRAY_LEN);

}

//----------------------------------------------------------
/**
 * @brief	|P̎擾
 * @param	zw		񃏁[Nւ̃|C^
 * @return	u16		
 */
//----------------------------------------------------------
u16 ZukanWork_GetPokeSeeCount(const ZUKAN_WORK * zw)
{
	int i;
	int count;

	zukan_incorrect(zw);
	count= 0;
	for( i=1; i<=MONSNO_END; i++ ){
		if( ZukanWork_GetPokeSeeFlag( zw, i ) == TRUE ){
			count ++;
		}
	}
	return count;

	// łAfILVXtOget_flaǧɓꂽ̂ŁAgpł܂
//	return count_bit(zw->see_flag, POKEZUKAN_ARRAY_LEN);
}

//----------------------------------------------------------------------------
/**
 *	@brief	݂̐}Ӱނ̃|P߂܂擾
 *	@param	zw		}Ӄ[Nւ̃|C^
 *	@return	߂܂
 */
//-----------------------------------------------------------------------------
u16 ZukanWork_GetZukanPokeGetCount(const ZUKAN_WORK * zw)
{
	if( ZukanWork_GetZenkokuZukanFlag( zw ) ){
		return ZukanWork_GetPokeGetCount( zw );
	}
	return ZukanWork_GetShinouPokeGetCount( zw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	݂̐}Ӱނ̃|P擾
 *	@param	zw		}Ӄ[Nւ̃|C^
 *	@return 
 */
//-----------------------------------------------------------------------------
u16 ZukanWork_GetZukanPokeSeeCount(const ZUKAN_WORK * zw)
{
	if( ZukanWork_GetZenkokuZukanFlag( zw ) ){
		return ZukanWork_GetPokeSeeCount( zw );
	}
	return ZukanWork_GetShinouPokeSeeCount( zw );
}

//----------------------------------------------------------
/**
 * yVIEz
 * @brief	|P܂̎擾
 * @param	zw		񃏁[Nւ̃|C^
 * @return	u16		߂܂
 */
//----------------------------------------------------------
u16 ZukanWork_GetShinouPokeGetCount(const ZUKAN_WORK * zw)
{
	int i;
	int count;
	zukan_incorrect(zw);
	count= 0;
	for( i=1; i<=MONSNO_END; i++ ){
		if( ZukanWork_GetPokeGetFlag( zw, i ) == TRUE ){
			// ݵ޶݂ɂ邩`FbN
			if( PokeZenkokuNo2ShinouNo( i ) != 0 ){
				count ++;
			}
		}
	}
	return count;
}

//----------------------------------------------------------
/**
 * yVIEz
 * @brief	|P̎擾
 * @param	zw		񃏁[Nւ̃|C^
 * @return	u16		
 */
//----------------------------------------------------------
u16 ZukanWork_GetShinouPokeSeeCount(const ZUKAN_WORK * zw)
{
	int i;
	int count;
	zukan_incorrect(zw);
	count= 0;
	for( i=1; i<=MONSNO_END; i++ ){
		if( ZukanWork_GetPokeSeeFlag( zw, i ) == TRUE ){
			// ݵ޶݂ɂ邩`FbN
			if( PokeZenkokuNo2ShinouNo( i ) != 0 ){
				count ++;
			}
		}
	}
	return count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	S}ӂ`FbN
 *
 *	@param	zw	}Ӄ[N
 *
 *	@retval	TRUE	
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_CheckZenkokuComp(const ZUKAN_WORK * zw)
{
	u16 num;

	// [RN}ӊɕKvȃ|PC߂܂
	num = ZukanWork_GetZenkokuGetCompCount( zw );

	if( num >= ZUKAN_WORK_ZENKOKU_COMP_NUM ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	VIE}ӂ`FbN
 *
 *	@param	zw	}Ӄ[N
 *
 *	@retval	TRUE	
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_CheckShinouComp(const ZUKAN_WORK * zw)
{
	u16 num;

	// VIE}ӊɕKvȃ|PC
	num = ZukanWork_GetShinouSeeCompCount( zw );

	if( num >= ZUKAN_WORK_SHINOU_COMP_NUM ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	[RN}Ӂ@ɕKvȃ|P߂܂
 *
 *	@param	zw		}Ӄ[N
 *	@return	ɕKvȃ|P߂܂
 */
//-----------------------------------------------------------------------------
u16 ZukanWork_GetZenkokuGetCompCount(const ZUKAN_WORK * zw)
{
	int i;
	u16 num;
	// GtB@}itB@_[N@GEX@AEX
	// ȊO߂܂ĂOK
	num = 0;
	for( i=1; i<=ZUKAN_WORK_ZENKOKU_MONSMAX; i++ ){
		if( ZukanWork_GetPokeGetFlag( zw, i ) == TRUE ){
			if( check_ZenkokuCompMonsno( i ) == TRUE ){
				num ++;
			}
		}
	}
	return num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	VIE}Ӂ@ɕKvȃ|P
 *
 *	@param	zw		}Ӄ[N
 *	@return	ɕKvȃ|P
 */
//-----------------------------------------------------------------------------
u16 ZukanWork_GetShinouSeeCompCount(const ZUKAN_WORK * zw)
{
	int i;
	u16 num;
	u32 monsno;

	// GtB@}itB@_[N@GEX@AEX
	// ȊO߂܂ĂOK
	num = 0;
	for( i=1; i<=ZUKAN_WORK_ZENKOKU_MONSMAX; i++ ){
		if( ZukanWork_GetPokeSeeFlag( zw, i ) == TRUE ){
			monsno = PokeZenkokuNo2ShinouNo( i );
			if( monsno != 0 ){
				if( check_ShinouCompMonsno( i ) == TRUE ){
					num ++;
				}
			}
		}
	}
	return num;
}

//----------------------------------------------------------
/**
 * @brief	|P߂܂ǂ̃tO擾
 * @param	zw		񃏁[Nւ̃|C^
 * @param	monsno	|Pio[
 * @return	BOOL	tO
 */
//----------------------------------------------------------
BOOL ZukanWork_GetPokeGetFlag(const ZUKAN_WORK * zw, u16 monsno)
{
	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return FALSE;
	}
	if (check_get_bit(zw, monsno) && check_see_bit(zw, monsno)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//----------------------------------------------------------
/**
 * @brief	|Pǂ̃tO擾
 * @param	zw		񃏁[Nւ̃|C^
 * @param	monsno	|Pio[
 * @return	BOOL	tO
 */
//----------------------------------------------------------
BOOL ZukanWork_GetPokeSeeFlag(const ZUKAN_WORK * zw, u16 monsno)
{
	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return FALSE;
	}
	return check_see_bit(zw, monsno);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̌擾
 *
 *	@param	zw			}Ӄ[Nւ̃|C^
 *	@param	random_poke	擾|P
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeRandomFlag(const ZUKAN_WORK * zw, u8 random_poke)
{
	u32 random;
	
	zukan_incorrect(zw);

	switch( random_poke ){
	case ZUKAN_WORK_RANDOM_PACHI:		// pb`[
		random = zw->PachiRandom;
		break;
		
	default:
		GF_ASSERT_MSG( 0, "random_poke = %d\n", random_poke );
		break;
	}

	return random;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P\Ƃ̐ʎ擾
 *
 *	@param	zw				񃏁[Nւ̃|C^
 *	@param	monsno			|Pio[
 *	@param	first_second	ŏɌʂɌʂ
 *
 *	@retval	PARA_MALE		IX
 *	@retval	PARA_FEMALE		X
 *	@retval	PARA_UNK		s	
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ʂ܂
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeSexFlag(const ZUKAN_WORK * zw, u16 monsno, int first_second )
{
	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return ZUKAN_WORK_GET_SEX_ERR;
	}
	// ĂȂƂ̓G[R[hԂ
	if( !check_see_bit(zw, monsno) ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}

	// m[}|P
	return get_normal_poke_sex( zw, monsno, first_second );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Am[ݒ
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Am[	(0`27)
 *	
 *	@retval	Am[tH[io[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeAnoonForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);
	// ̐̃Am[tHĂ邩`FbN
	if( get_zukan_unknown_turn_num( zw ) <= count ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}

	// tHԂ
	return get_unknown_see_form( zw, count );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Am[
 *
 *	@param	zw		}Ӄ[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeAnoonSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return get_zukan_unknown_turn_num( zw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	V[EVtH擾
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Ԑ	
 *
 *	@retval	̏ԂɌtH
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeSiiusiForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);

	// ̐̃V[EVtHĂ邩`FbN
	if( get_zukan_siiusi_turn_num( zw, MONSNO_SIIUSI ) <= count ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}
	return get_siiusi_see_form( zw, MONSNO_SIIUSI, count );
}

//----------------------------------------------------------------------------
/**
 *	@brief	V[EṼtH
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	tH
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeSiiusiSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return get_zukan_siiusi_turn_num( zw, MONSNO_SIIUSI );
}

//----------------------------------------------------------------------------
/**
 *	@brief	V[hStHio[擾
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Ԑ	
 *
 *	@retval	̏ԂɌtHio[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeSiidorugoForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);
	
	// ̐̃V[hStHĂ邩`FbN
	if( get_zukan_siiusi_turn_num( zw, MONSNO_SIIDORUGO ) <= count ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}
	return get_siiusi_see_form( zw, MONSNO_SIIDORUGO, count );
}

//----------------------------------------------------------------------------
/**
 *	@brief	V[hS̃tH
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	tH
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeSiidorugoSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return get_zukan_siiusi_turn_num( zw, MONSNO_SIIDORUGO );
}

//----------------------------------------------------------------------------
/**
 *	@brief	~mb`tHio[擾
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Ԑ	
 *
 *	@retval	̏ԂɌtHio[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeMinomuttiForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);

	// ̐̃~mb`tHĂ邩`FbN
	if( get_zukan_minomutti_turn_num( zw, MONSNO_MINOMUTTI ) <= count ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}
	return get_minomutti_see_form( zw, MONSNO_MINOMUTTI, count );
}

//----------------------------------------------------------------------------
/**
 *	@brief	~mb`̃tH
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	tH
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeMinomuttiSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return get_zukan_minomutti_turn_num( zw, MONSNO_MINOMUTTI );
}

//----------------------------------------------------------------------------
/**
 *	@brief	~mXn`tHio[擾
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Ԑ	
 *
 *	@retval	̏ԂɌtHio[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeMinomesuForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);

	// ̐̃~mXtHĂ邩`FbN
	if( get_zukan_minomutti_turn_num( zw, MONSNO_MINOMESU ) <= count ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}
	return get_minomutti_see_form( zw, MONSNO_MINOMESU, count );
}

//----------------------------------------------------------------------------
/**
 *	@brief	~mX̃tH
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	tH
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeMinomesuSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return get_zukan_minomutti_turn_num( zw, MONSNO_MINOMESU );
}

//----------------------------------------------------------------------------
/**
 *	@brief	fILVXtH@擾
 *
 *	@param	zw	}Ӄ[N
 *	@param	countJEg
 *
 *	@return	fILVXtHio[
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeDeokisisuForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);
	return getDEOKISISUFormNo( zw, count );
}

//----------------------------------------------------------------------------
/**	
 *	@brief	fILVXtH@擾
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeDeokisisuFormSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return nowGetDeokisisuFormNum( zw );
}


//----------------------------------------------------------
/**
 * @brief	f[^Zbgij
 * @param	zw		񃏁[Nւ̃|C^
 * @param	pp		|PPOKEMON_PARAMւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_SetPokeSee(ZUKAN_WORK * zw, POKEMON_PARAM * pp)
{
	u16 monsno = PokeParaGet(pp, ID_PARA_monsno, NULL);
	u32 rand = PokeParaGet(pp, ID_PARA_personal_rnd, NULL);
	u32 sex = PokeSexGet(pp);
	u32 first_sex;	// ŏɌ

	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return;
	}
	if (!check_see_bit(zw, monsno)) {
		SetZukanRandom(zw, monsno, rand);			// ő̗
		set_sex_bit( zw, sex, ZUKAN_WORK_SEX_FIRST, monsno );			// ŏɌ
	}else{
		// ŏɌʂƈႤƂZJhɓo^
		first_sex = check_sex_bit( zw, monsno, ZUKAN_WORK_SEX_FIRST );
		if( first_sex != sex ){
			set_sex_bit( zw, sex, ZUKAN_WORK_SEX_SECOND, monsno );			// Ɍ
		}
	}
	SetZukanSpecialTurn(zw, monsno, pp);		// |P̌Ԑݒ
	set_see_bit(zw, monsno);
}

//----------------------------------------------------------
/**
 * @brief	f[^Zbgi߂܂j
 * @param	zw		񃏁[Nւ̃|C^
 * @param	pp		߂܂|PPOKEMON_PARAMւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_SetPokeGet(ZUKAN_WORK * zw, POKEMON_PARAM * pp)
{
	u16 monsno = PokeParaGet(pp, ID_PARA_monsno, NULL);
	u32 lang = PokeParaGet(pp, ID_PARA_country_code, NULL);
	u32 rand = PokeParaGet(pp, ID_PARA_personal_rnd, NULL);
	u32 sex = PokeSexGet(pp);
	u32 first_sex;	// ŏɌ

	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return;
	}
	if (!check_see_bit(zw, monsno)) {
		SetZukanRandom(zw, monsno, rand);			// ő̗
		set_sex_bit( zw, sex, ZUKAN_WORK_SEX_FIRST, monsno );			// \
	}else{
		// ŏɌʂƈႤƂZJhɓo^
		first_sex = check_sex_bit( zw, monsno, ZUKAN_WORK_SEX_FIRST );
		if( first_sex != sex ){
			set_sex_bit( zw, sex, ZUKAN_WORK_SEX_SECOND, monsno );			// \
		}
	}
	SetZukanSpecialTurn(zw, monsno, pp);		// |P̌Ԑݒ
	SetZukanTextVersionUp(zw, monsno, lang);	// R[h
	set_get_bit(zw, monsno);
	set_see_bit(zw, monsno);
}

//----------------------------------------------------------
/**
 * @brief	S񃂁[hZbg
 * @param	zw		񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_SetZenkokuZukanFlag(ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	zw->zenkoku_flag = TRUE;
}

//----------------------------------------------------------
/**
 * @brief	S񃂁[hǂH̖₢킹
 * @param	zw		񃏁[Nւ̃|C^
 * @retval	TRUE	S񃂁[hI[v
 * @retval	FALSE	VIE񃂁[h
 */
//----------------------------------------------------------
BOOL ZukanWork_GetZenkokuZukanFlag(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return zw->zenkoku_flag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNo[Wp@\gtO擾
 *
 *	@param	zw		񃏁[Nւ̃|C^
 *
 *	@retval	TRUE	o[WAbv
 *	@retval	FALSE	o[WAbv
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetGraphicVersionUpFlag(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return zw->GraphicVersionUp;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNo[Wp@\gtOݒ
 *
 *	@param	zw		}Ӄ[Nւ̃|C^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZukanWork_SetGraphicVersionUpFlag(ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	zw->GraphicVersionUp = 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӃeLXgo[W`FbN
 *
 *	@param	zw
 *	@param	monsno
 *	@param	country_code		R[h
 *
 *	@retval	TRUE	̍̃o[W\Ă悢
 *	@retval	FALSE	̍̃o[W\Ă͂Ȃ
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetTextVersionUpFlag(const ZUKAN_WORK * zw, u16 monsno, u32 country_code)
{
	int idx;


	GF_ASSERT( country_code < 8 );		// R[hő吔
	
	zukan_incorrect(zw);
	// eLXgo[Ŵ|P`FbN
	idx = get_zukan_textversion_idx(monsno);
	if( idx == ZKN_WORLD_TEXT_POKE_NUM ){ return FALSE; }

	// OeLXgpio[ɕϊ
	country_code = ZKN_WT_GetLANG_Code_ZKN_WORLD_TEXT_Code( country_code );

	// ̌̃tOĂ邩`FbN
	return (zw->TextVersionUp[idx] & (1<<country_code));
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӊOo[W@MastertO
 *
 *	@param	zw	}Ӄ[N
 *	̃tOĂȂƁAO}ӂ̓I[vȂ
 */
//-----------------------------------------------------------------------------
void ZukanWork_SetTextVersionUpMasterFlag( ZUKAN_WORK * zw )
{
	zw->TextVersionUpMasterFlag = TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӊOo[W@MastertO擾
 *
 *	@param	zw	}Ӄ[N
 *
 *	@retval	TRUE	o[WAbvς
 *	@retval	FALSE	o[WAbvĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetTextVersionUpMasterFlag(const ZUKAN_WORK * zw)
{
	return zw->TextVersionUpMasterFlag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӕێtO擾
 *
 *	@param	zw	}Ӄ[Nւ̃|C^
 *
 *	@retval	TRUE	ێ
 *	@retval	FALSE	ێĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetZukanGetFlag(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return zw->zukan_get;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӕێtOݒ
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZukanWork_SetZukanGetFlag(ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	zw->zukan_get = TRUE;
}

//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	ZUKAN_WORK	񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
ZUKAN_WORK * SaveData_GetZukanWork(SAVEDATA * sv)
{
	ZUKAN_WORK * zs;
	zs = SaveData_Get(sv, GMDATA_ID_ZUKANWORK);
	return zs;
}

//============================================================================================
//============================================================================================
// Am[@E~EV@~mV@̌ԂĂ
static void set_debag_special_poke_see_no( ZUKAN_WORK * zw, int monsno )
{
	int i;
	
	// Am[@E~EV@~mV̏Ԃ̐ݒ
	if( monsno == MONSNO_ANNOON ){
		for( i=0; i<POKEZUKAN_UNKNOWN_NUM; i++ ){
			SetZukanUnknownTurn( zw, i );
		}
	}else if( (monsno == MONSNO_MINOMUTTI) || (monsno == MONSNO_MINOMESU) ){
		for( i=ZUKAN_WORK_MINOMUSHI_FORM_NUM - 1; i>=0; i-- ){
			SetZukanMinomuttiTurn( zw, monsno, i );
		}
	}else if( (monsno == MONSNO_SIIUSI) || (monsno == MONSNO_SIIDORUGO) ){
		for( i=ZUKAN_WORK_UMIUSHI_FORM_NUM - 1; i>=0; i-- ){
			SetZukanSiiusiTurn( zw, monsno, i );
		}
	}else if( (monsno == MONSNO_DEOKISISU) ){
		for( i=ZUKAN_WORK_DEOKISISU_FORM_NUM - 1; i>=0; i-- ){
			setDEOKISISUFormNo( zw, i, ZUKAN_WORK_DEOKISISU_FORM_NUM-(i+1) );
		}
	}
	
}

// ʐݒ
static void set_debug_poke_sex( ZUKAN_WORK * zw, int monsno )
{
	int sex = PokePersonalParaGet( monsno, ID_PER_sex );
	
	if( sex == MONS_MALE ){
		// ʐݒ
		set_sex_bit( zw, PARA_MALE, ZUKAN_WORK_SEX_FIRST, monsno );
		return;
	}
	if( sex == MONS_FEMALE ){
		// ʐݒ
		set_sex_bit( zw, PARA_FEMALE, ZUKAN_WORK_SEX_FIRST, monsno );
		return;
	}
	if( sex == MONS_UNKNOWN ){
		// ʐݒ
		set_sex_bit( zw, PARA_UNK, ZUKAN_WORK_SEX_FIRST, monsno );
		return;
	}

	// ʐݒ
	if( monsno % 2 ){
		set_sex_bit( zw, PARA_MALE, ZUKAN_WORK_SEX_FIRST, monsno );
		set_sex_bit( zw, PARA_FEMALE, ZUKAN_WORK_SEX_SECOND, monsno );
	}else{
		set_sex_bit( zw, PARA_FEMALE, ZUKAN_WORK_SEX_FIRST, monsno );
		set_sex_bit( zw, PARA_MALE, ZUKAN_WORK_SEX_SECOND, monsno );
	}
}

//----------------------------------------------------------
/**
 * @brief	fobOpFf[^
 * @param	zw			񃏁[Nւ̃|C^
 * @param	option
 */
//----------------------------------------------------------
extern void Debug_ZukanWork_Make(ZUKAN_WORK * zw, int start, int end, BOOL see_flg)
{
	int i;
	zukan_incorrect(zw);

	GF_ASSERT( start > 0 );
	GF_ASSERT( end <= MONSNO_END );
	
	for (i = start; i <= end; i++) {
		if( see_flg == TRUE ){
			set_see_bit(zw, i);
		}else{
		
			set_get_bit(zw, i);
			set_see_bit(zw, i);

			// O}Ӑݒ
			SetZukanTextVersionUp(zw, i, LANG_JAPAN);
			SetZukanTextVersionUp(zw, i, LANG_ENGLISH);
			SetZukanTextVersionUp(zw, i, LANG_FRANCE);
			SetZukanTextVersionUp(zw, i, LANG_ITALY);
			SetZukanTextVersionUp(zw, i, LANG_GERMANY);
			SetZukanTextVersionUp(zw, i, LANG_SPAIN);
		}

		// ݒ
		SetZukanRandom( zw, i, 0 );

		// ꌩԐݒ
		set_debag_special_poke_see_no( zw, i );

		// 	
		set_debug_poke_sex( zw, i );
	}

	// OtBbNo[WAbv
	ZukanWork_SetGraphicVersionUpFlag(zw);
	ZukanWork_SetTextVersionUpMasterFlag(zw);
}

//----------------------------------------------------------------------------
/**
 *	@brief	fILVXobNAbv
 *
 *	@param	zw	}Ӄ[N
 */
//-----------------------------------------------------------------------------
void Debug_ZukanWork_DeokisisuBuckUp( ZUKAN_WORK * zw )
{
	// fILVXtHIDobt@
	InitDeokisisuFormNo( zw );
		
	// fILVXێĂ邩`FbN
	if( ZukanWork_GetPokeSeeFlag( zw, MONSNO_DEOKISISU ) == TRUE ){
		// tHio[OŃZ[u
		setDEOKISISUFormNo( zw, 0, 0 );
	}
}


// OQƃCfbNX鎞̂ݗL(Q[͖)
#ifdef CREATE_INDEX
void *Index_Get_Zukan_Offset(ZUKAN_WORK *zw){ return &zw->zukan_get; }
void *Index_Get_Zenkoku_Zukan_Offset(ZUKAN_WORK *zw){ return &zw->zenkoku_flag; }
void *Index_Get_Get_Flag_Offset(ZUKAN_WORK *zw){ return &zw->get_flag; }
void *Index_Get_See_Flag_Offset(ZUKAN_WORK *zw){ return &zw->see_flag; }
void *Index_Get_Sex_Flag_Offset(ZUKAN_WORK *zw){ return &zw->sex_flag; }
#endif




//------------------------------------------------------------------
/**
 * S|ṔA߂܂tHio[Ԃ
 *
 * @param   zw			
 * @param   monsno		
 * @param   count		
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32 ZukanWork_GetPokeForm( const ZUKAN_WORK* zw, int monsno, int count )
{
	OS_TPrintf("monsno:%d\n", monsno);
	switch( monsno ){
	case MONSNO_ANNOON:
		OS_TPrintf("  Annoon\n");
		if( count < ZukanWork_GetPokeAnoonSeeNum(zw) )
		{
			OS_TPrintf("   CheckForm\n");
			return ZukanWork_GetPokeAnoonForm( zw, count );
		}
		break;

	case MONSNO_SIIUSI:
		if( count < ZukanWork_GetPokeSiiusiSeeNum(zw) )
		{
			return ZukanWork_GetPokeSiiusiForm( zw, count );
		}
		break;

	case MONSNO_SIIDORUGO:
		if( count < ZukanWork_GetPokeSiidorugoSeeNum(zw) )
		{
			return ZukanWork_GetPokeSiidorugoForm( zw, count );
		}
		break;

	case MONSNO_MINOMUTTI:
		if( count < ZukanWork_GetPokeMinomuttiSeeNum(zw) )
		{
			return ZukanWork_GetPokeMinomuttiForm( zw, count );
		}
		break;

	case MONSNO_MINOMESU:
		if( count < ZukanWork_GetPokeMinomesuSeeNum(zw) )
		{
			return ZukanWork_GetPokeMinomesuForm( zw, count );
		}
		break;

	case MONSNO_DEOKISISU:
		if( count < ZukanWork_GetPokeDeokisisuFormSeeNum(zw) )
		{
			return ZukanWork_GetPokeDeokisisuForm( zw, count );
		}
		break;

	}

	return 0;

}
