//=============================================================================
/**
 * @file	bmp_list.c	
 * @brief	rbg}bvafł̃Xg\VXe
 * @author	GAME FREAK inc.
 * @date	tetsu
 */
//=============================================================================
#include <nitro.h>
#include <nnsys.h>
#include "common.h"
#include "fntsys.h"
#include "system/fontproc.h"
#include "system/bmp_cursor.h"

#define __BMP_LIST_H_GLOBAL__
#include "system/bmp_list.h"


/********************************************************************/
/*                                                                  */
/*				gp`											*/
/*                                                                  */
/********************************************************************/
enum {
	LIST_UP = 0,
	LIST_DOWN
};


typedef struct {
	u8	f_col:4;		// \F
	u8	b_col:4;		// \wiF
	u8	s_col:4;		// \eF
	u8	msg_spc:6;		// Ԋuw
	u8	dummy:6;		// gp
	u8	font:7;			// w
	u8	sw:1;			// ꎞύXXCb`
}BMPLIST_TMP;

///Xg[N\
struct _BMPLIST_WORK {

	BMPLIST_HEADER	hed;	//\f[^wb_

	BMPLIST_TMP		tmp;	// ꎞύXf[^

	BMPCURSOR * cursor;		// BMPJ[\f[^

	u16	lp;			//Xgʒu
	u16	cp;			//J[\ʒu
	u8	seq;		//V[PX
	u8	scrwork;	//XN[[N
	u8	cur_actID;	//
	u8	work;		//ړigĂȂ悤Ȃ̂Łj

	u8	mode;		// 擾[h
};


/********************************************************************/
/*                                                                  */
/*				[J֐錾									*/
/*                                                                  */
/********************************************************************/
static void LocalMsgPrint( BMPLIST_WORK * lw, void * msg, u8 x, u8 y );
static void ListScreenPut( BMPLIST_WORK * lw, u16 print_p, u16 line, u16 len );
static void ListCursorPut( BMPLIST_WORK * lw );
static void ListCursorCls( BMPLIST_WORK * lw, u16 p );
static u8 ListCursorMoveUpDown( BMPLIST_WORK * lw, u8 mode );
static void ListScrollMoveUpDown( BMPLIST_WORK * lw, u8 len, u8 mode );
static u8 ListMoveUpDownCheck( BMPLIST_WORK * lw, u8 print_f, u8 req_line, u8 mode );
static void CallBackSet( BMPLIST_WORK * lw, u8 mode );



//--------------------------------------------------------------------------------------------
/**
 * ݒ֐
 *
 * @param	bmplist		\Xgwb_|C^
 * @param	list_p		Xgʒu
 * @param	cursor_p	J[\ʒu
 * @param	mode		擾[h
 *
 * @return	BMPXg[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 */
//--------------------------------------------------------------------------------------------
BMPLIST_WORK * BmpListSet(
					const BMPLIST_HEADER * bmplist, u16 list_p, u16 cursor_p, u8 mode )
{
	BMPLIST_WORK * lw = (BMPLIST_WORK *)sys_AllocMemory( mode, sizeof(BMPLIST_WORK) );

	// {ݒ
	lw->hed       = *bmplist;
	lw->cursor    = BMPCURSOR_Create( mode );
	lw->lp        = list_p;
	lw->cp        = cursor_p;
	lw->seq       = 0;
	lw->scrwork   = 0;
	lw->cur_actID = 0xff;
	lw->work      = 0;
	lw->mode      = mode;

	// e|
	lw->tmp.f_col   = lw->hed.f_col;	// \F
	lw->tmp.b_col   = lw->hed.b_col;	// \wiF
	lw->tmp.s_col   = lw->hed.s_col;	// \eF
	lw->tmp.msg_spc = lw->hed.msg_spc;	// Ԋuw
	lw->tmp.font    = lw->hed.font;		// w
	lw->tmp.sw      = 0;				// ꎞύXXCb`

	// ڐ\w胉C菭Ȃꍇ́A\w胉Cڐɂ킹
	if( lw->hed.count < lw->hed.line ){
		lw->hed.line = lw->hed.count;
	}

	// BMPJ[\FύX
	BMPCURSOR_ChangeColor(
		lw->cursor, GF_PRINTCOLOR_MAKE(lw->hed.f_col,lw->hed.s_col,lw->hed.b_col) );

	// XgLf[^
	GF_BGL_BmpWinDataFill( lw->hed.win, lw->hed.b_col );
	ListScreenPut( lw, lw->lp, 0, lw->hed.line );		// S̃Xg`
	ListCursorPut( lw );								// J[\`

	CallBackSet( lw, 1 );

	GF_BGL_BmpWinOn( bmplist->win );

	return lw;
}

//--------------------------------------------------------------------------------------------
/**
 * C֐
 *
 * @param	lw		BMPXg[N
 *
 * @retval	"param = Ip[^"
 * @retval	"BMPLIST_NULL = I"
 * @retval	"BMPLIST_CANCEL	= LZ(a{^)"
 */
//--------------------------------------------------------------------------------------------
u32 BmpListMain( BMPLIST_WORK * lw )
{
	u16	skip_u, skip_d;

	lw->work = BMPLIST_MOVE_NONE;

	if( sys.trg & PAD_BUTTON_DECIDE ){
		return lw->hed.list[lw->lp + lw->cp].param;
	}
	if( sys.trg & PAD_BUTTON_CANCEL ){
		return BMPLIST_CANCEL;
	}
	if( sys.repeat & PAD_KEY_UP ){
		if( ListMoveUpDownCheck( lw, 1, 1, LIST_UP ) == 0 ){
			lw->work = BMPLIST_MOVE_UP;
		}
		return BMPLIST_NULL;
	}
	if( sys.repeat & PAD_KEY_DOWN ){
		if( ListMoveUpDownCheck( lw, 1, 1, LIST_DOWN ) == 0 ){
			lw->work = BMPLIST_MOVE_DOWN;
		}
		return BMPLIST_NULL;
	}
	//XLbvtO
	switch( lw->hed.page_skip ){
	default:
	case BMPLIST_NO_SKIP:
		skip_u = 0;
		skip_d = 0;
		break;
	case BMPLIST_LRKEY_SKIP:
		skip_u = ( sys.repeat & PAD_KEY_LEFT );
		skip_d = ( sys.repeat & PAD_KEY_RIGHT );
		break;
	case BMPLIST_LRBTN_SKIP:
		skip_u = ( sys.repeat & PAD_BUTTON_L );
		skip_d = ( sys.repeat & PAD_BUTTON_R );
		break;
	}
	if( skip_u ){
		if( ListMoveUpDownCheck( lw, 1, (u8)lw->hed.line, LIST_UP ) == 0 ){
			lw->work = BMPLIST_MOVE_UP_SKIP;
		}
		return BMPLIST_NULL;
	}
	if( skip_d ){
		if( ListMoveUpDownCheck( lw, 1, (u8)lw->hed.line, LIST_DOWN ) == 0 ){
			lw->work = BMPLIST_MOVE_DOWN_SKIP;
		}
		return BMPLIST_NULL;
	}

	return BMPLIST_NULL;
}


//--------------------------------------------------------------------------------------------
/**
 * I֐
 *
 * @param	lw			BMPXg[N
 * @param	list_bak	XgʒuobNAbv[N|C^
 * @param	cursor_bak	J[\ʒuobNAbv[N|C^
 *
 * @return	none
 *
 * @li	lwsys_FreeMemoryŊJ
 * @li	obNAbv[ŃANULLwŕۑȂ
 */
//--------------------------------------------------------------------------------------------
void BmpListExit( BMPLIST_WORK * lw, u16 * list_bak, u16 * cursor_bak )
{
	if( list_bak != NULL ){
		*list_bak = lw->lp;
	}
	if( cursor_bak != NULL ){
		*cursor_bak = lw->cp;
	}
/*
	if( lw->cur_actID != 0xff ){
		CursorListActorDel( lw->cur_actID, lw->lh.c_disp_f - 2 );
	}
*/
	BMPCURSOR_Delete( lw->cursor );
	sys_FreeMemory( lw->mode, lw );
}

//--------------------------------------------------------------------------------------------
/**
 * Xgĕ`
 *
 * @param	lw		BMPXg[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListRewrite( BMPLIST_WORK * lw )
{
	// XgLf[^
	GF_BGL_BmpWinDataFill( lw->hed.win, lw->hed.b_col );

	ListScreenPut( lw, lw->lp, 0, lw->hed.line );	// S̃Xg`
	ListCursorPut( lw );							// J[\`
	GF_BGL_BmpWinOn( lw->hed.win );
}


//--------------------------------------------------------------------------------------------
/**
 * FύX֐
 *
 * @param	lw			BMPXg[N
 * @param	f_col		F
 * @param	b_col		wiF
 * @param	s_col		eF
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListColorControl( BMPLIST_WORK * lw, u8 f_col, u8 b_col, u8 s_col )
{
	lw->hed.f_col = f_col;	//Fio[
	lw->hed.b_col = b_col;	//wiFio[
	lw->hed.s_col = s_col;	//eF@io[
}

//--------------------------------------------------------------------------------------------
/**
 * \ʒuύX֐
 *
 * @param	lw			BMPXg[N
 * @param	x			\wW(LP)
 * @param	y			\xW(LP)
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListMoveControl( BMPLIST_WORK * lw, u8 x, u8 y )
{
	GF_BGL_BmpWinSet_PosX( lw->hed.win, x );
	GF_BGL_BmpWinSet_PosY( lw->hed.win, y );
}


//--------------------------------------------------------------------------------------------
/**
 * ORg[֐(`ER[obNw)
 *
 * @param	lw			BMPXg[N
 * @param	lh			\Xgwb_|C^
 * @param	list_p		Xgʒu
 * @param	cursor_p	J[\ʒu
 * @param	print		`tO
 * @param	direct		w(L[`)
 * @param	list_bak	XgʒuobNAbv[N|C^
 * @param	cursor_bak	J[\ʒuobNAbv[N|C^
 *
 * @return	BMPLIST_NULL	
 *
 * Xg֐삵ĂȂƂAO̎wɂ
 * J[\ʒu̕ϓ`FbNAwobNAbv[Nɕۑ
 */
//--------------------------------------------------------------------------------------------
u32 BmpListMainOutControlEx(
		BMPLIST_WORK * lw, BMPLIST_HEADER * bmplist,
		u16 list_p, u16 cursor_p, u16 print, u16 direct, u16 * list_bak, u16 * cursor_bak )
{
    if( bmplist ){
		lw->hed = *bmplist;
	}
	lw->lp		= list_p;
	lw->cp		= cursor_p;
	lw->seq		= 0;
	lw->scrwork	= 0;

	if( direct == PAD_KEY_UP ){
		ListMoveUpDownCheck( lw, print, 1, LIST_UP );
	}else if( direct == PAD_KEY_DOWN ){
		ListMoveUpDownCheck( lw, print, 1, LIST_DOWN );
	}
	if( list_bak != NULL ){
		*list_bak = lw->lp;
	}
	if( cursor_bak != NULL ){
		*cursor_bak = lw->cp;
	}

	return BMPLIST_NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * ORg[֐(J[\ړ)
 *
 * @param	lw			BMPXg[N
 * @param	bmplist		\Xgwb_|C^
 * @param	list_p		Xgʒu
 * @param	cursor_p	J[\ʒu
 * @param	direct		w(L[`)
 * @param	list_bak	XgʒuobNAbv[N|C^
 * @param	cursor_bak	J[\ʒuobNAbv[N|C^
 *
 * @return	BMPLIST_NULL	
 *
 * Xg֐삵ĂȂƂAO̎wɂ
 * J[\ʒu̕ϓ`FbNAwobNAbv[Nɕۑ
 */
//--------------------------------------------------------------------------------------------
u32 BmpListMainOutControl(
		BMPLIST_WORK * lw, BMPLIST_HEADER * bmplist,
		u16 list_p, u16 cursor_p, u16 direct, u16 * list_bak, u16 * cursor_bak )
{
	return BmpListMainOutControlEx(lw,bmplist,list_p,cursor_p,0,direct,list_bak,cursor_bak);
/*
    if(bmplist){
        lw->hed		= *bmplist;
    }
	lw->lp		= list_p;
	lw->cp		= cursor_p;
	lw->seq		= 0;
	lw->scrwork	= 0;

	if( direct == PAD_KEY_UP ){
		ListMoveUpDownCheck( lw, 0, 1, LIST_UP );
	}else if( direct == PAD_KEY_DOWN ){
		ListMoveUpDownCheck( lw, 0, 1, LIST_DOWN );
	}
	if( list_bak != NULL ){
		*list_bak = lw->lp;
	}
	if( cursor_bak != NULL ){
		*cursor_bak = lw->cp;
	}

	return BMPLIST_NULL;
*/
}

//--------------------------------------------------------------------------------------------
/**
 * FꎞύX
 *
 * @param	lw		BMPXg[N
 * @param	f_col	F
 * @param	b_col	wiF
 * @param	s_col	eF
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListTmpColorChange( BMPLIST_WORK * lw, u8 f_col, u8 b_col, u8 s_col )
{
	lw->tmp.f_col = f_col;		// Fio[
	lw->tmp.b_col = b_col;		// wiFio[
	lw->tmp.s_col = s_col;		// eF@io[
	lw->tmp.sw = 1;	
}

//--------------------------------------------------------------------------------------------
/**
 * BMPXg̑S̈ʒu擾
 *
 * @param	lw			BMPXg[N
 * @param	pos_bak		S̃XgʒuobNAbv[N|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListDirectPosGet( BMPLIST_WORK * lw, u16 * pos_bak )
{
	*pos_bak = (u16)(lw->lp + lw->cp);
}

//--------------------------------------------------------------------------------------------
/**
 * BMPXg̃XgʒuAJ[\ʒu擾
 *
 * @param	lw			BMPXg[N
 * @param	list_bak	XgʒuobNAbv[N|C^
 * @param	cursor_bak	J[\ʒuobNAbv[N|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListPosGet( BMPLIST_WORK * lw, u16 * list_bak, u16 * cursor_bak )
{
	if( list_bak != NULL ){
		*list_bak = lw->lp;
	}
	if( cursor_bak != NULL ){
		*cursor_bak = lw->cp;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * BMPXg̃J[\YW擾
 *
 * @param	lw		BMPXg[N
 *
 * @return	J[\YW
 */
//--------------------------------------------------------------------------------------------
u16 BmpListCursorYGet( BMPLIST_WORK * lw )
{
	u8	yblk = FontHeaderGet( lw->hed.font, FONT_HEADER_SIZE_Y ) + lw->hed.line_spc;
	return  (u16)((lw->cp * yblk) + lw->hed.line_y);
}

//--------------------------------------------------------------------------------------------
/**
 * BMPXg̃J[\ړ擾
 *
 * @param	lw		BMPXg[N
 *
 * @return	J[\ړ擾
 */
//--------------------------------------------------------------------------------------------
u8 BmpListMoveSiteGet( BMPLIST_WORK * lw )
{
	return lw->work;
}

//--------------------------------------------------------------------------------------------
/**
 * wʒũp[^擾
 *
 * @param	lw		BMPXg[N
 * @param	pos		ʒu
 *
 * @return	p[^
 */
//--------------------------------------------------------------------------------------------
u32 BmpListPosParamGet( BMPLIST_WORK * lw, u16 pos )
{
	return lw->hed.list[ pos ].param;
}

//--------------------------------------------------------------------------------------------
/**
 * p[^擾֐
 *
 * @param	lw		BMPXg[N
 * @param	mode	p[^擾hc
 *
 * @retval	"0xffffffff = G["
 * @retval	"0xffffffff != p[^"
 */
//--------------------------------------------------------------------------------------------
u32	BmpListParamGet( BMPLIST_WORK * lw, u8 mode )
{
	u32	ret;

	switch( mode ){
	case BMPLIST_ID_CALLBACK:	// J[\ړƂ̃R[obN֐
		ret = (u32)lw->hed.call_back;
		break;
	case BMPLIST_ID_ICONFUNC:	// \Ƃ̃R[obN֐
		ret = (u32)lw->hed.icon;
		break;
	case BMPLIST_ID_COUNT:		// Xgڐ
		ret = (u32)lw->hed.count;
		break;
	case BMPLIST_ID_LINE:		// \ő區ڐ
		ret = (u32)lw->hed.line;
		break;
	case BMPLIST_ID_RABEL_X:	// x\wW
		ret = (u32)lw->hed.rabel_x;
		break;
	case BMPLIST_ID_DATA_X:		// ڕ\wW
		ret = (u32)lw->hed.data_x;
		break;
	case BMPLIST_ID_CURSOR_X:	// J[\\wW
		ret = (u32)lw->hed.cursor_x;
		break;
	case BMPLIST_ID_LINE_Y:		// \xW
		ret = (u32)lw->hed.line_y;
		break;
	case BMPLIST_ID_LINE_YBLK:		//PsVtgʎ擾(tHg̑傫{xԊu)
		ret = (u32)FontHeaderGet( lw->hed.font, FONT_HEADER_SIZE_Y ) + lw->hed.line_spc;
		break;
	case BMPLIST_ID_F_COL:		// \F
		ret = (u32)lw->hed.f_col;
		break;
	case BMPLIST_ID_B_COL:		// \wiF
		ret = (u32)lw->hed.b_col;
		break;
	case BMPLIST_ID_S_COL:		// \eF
		ret = (u32)lw->hed.s_col;
		break;
	case BMPLIST_ID_MSG_SPC:	// Ԋuw
		ret = (u32)lw->hed.msg_spc;
		break;
	case BMPLIST_ID_LINE_SPC:	// Ԋux
		ret = (u32)lw->hed.line_spc;
		break;
	case BMPLIST_ID_PAGE_SKIP:	// y[WXLbv^Cv
		ret = (u32)lw->hed.page_skip;
		break;
	case BMPLIST_ID_FONT:		// w
		ret = (u32)lw->hed.font;
		break;
	case BMPLIST_ID_C_DISP_F:	// afJ[\(allow)\tO
		ret = (u32)lw->hed.c_disp_f;
		break;
	case BMPLIST_ID_WIN:		// EBhEf[^
		ret = (u32)lw->hed.win;
		break;
	case BMPLIST_ID_WORK:		// [N
		ret = (u32)lw->hed.work;
		break;

	default:
		ret = 0xffffffff;
	}
	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * p[^ύX֐
 *
 * @param	lw		BMPXg[N
 * @param	mode	p[^擾hc
 * @param	param	ύXl
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListParamSet( BMPLIST_WORK * lw, u8 mode, u32 param )
{
	switch( mode ){
	case BMPLIST_ID_CALLBACK:	// J[\ړƂ̃R[obN֐
		lw->hed.call_back = (void *)param;
		break;
	case BMPLIST_ID_ICONFUNC:	// \Ƃ̃R[obN֐
		lw->hed.icon = (void *)param;
		break;
	case BMPLIST_ID_COUNT:		// Xgڐ
		lw->hed.count = (u16)param;
		break;
	case BMPLIST_ID_LINE:		// \ő區ڐ
		lw->hed.line = (u16)param;
		break;
	case BMPLIST_ID_RABEL_X:	// x\wW
		lw->hed.rabel_x = (u8)param;
		break;
	case BMPLIST_ID_DATA_X:		// ڕ\wW
		lw->hed.data_x = (u8)param;
		break;
	case BMPLIST_ID_CURSOR_X:	// J[\\wW
		lw->hed.cursor_x = (u8)param;
		break;
	case BMPLIST_ID_LINE_Y:		// \xW
		lw->hed.line_y = (u8)param;
		break;
	case BMPLIST_ID_F_COL:		// \F
		lw->hed.f_col = (u8)param;
		break;
	case BMPLIST_ID_B_COL:		// \wiF
		lw->hed.b_col = (u8)param;
		break;
	case BMPLIST_ID_S_COL:		// \eF
		lw->hed.s_col = (u8)param;
		break;
	case BMPLIST_ID_MSG_SPC:	// Ԋuw
		lw->hed.msg_spc = (u8)param;
		break;
	case BMPLIST_ID_LINE_SPC:	// Ԋux
		lw->hed.line_spc = (u8)param;
		break;
	case BMPLIST_ID_PAGE_SKIP:	// y[WXLbv^Cv
		lw->hed.page_skip = (u8)param;
		break;
	case BMPLIST_ID_FONT:		// w
		lw->hed.font = (u8)param;
		break;
	case BMPLIST_ID_C_DISP_F:	// afJ[\(allow)\tO
		lw->hed.c_disp_f = (u8)param;
		break;
	case BMPLIST_ID_WIN:		// EBhEf[^
		lw->hed.win = (GF_BGL_BMPWIN *)param;
		break;
	case BMPLIST_ID_WORK:		// [N
		lw->hed.work = (void *)param;
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * BMP_MENULIST_DATAēxݒ肷
 *
 * @param	BMP_MENULIST_DATA			BMPMENUXg|C^
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpListSetMenuListData(BMPLIST_WORK * lw, BMP_MENULIST_DATA* pList)
{
    lw->hed.list = pList;
}




/********************************************************************/
/*                                                                  */
/*                                                                  */
/*					֐									*/
/*                                                                  */
/*                                                                  */
/********************************************************************/
#include "gflib/strbuf.h"

//------------------------------------------------------------------
//		bZ[W\
//------------------------------------------------------------------
static void LocalMsgPrint( BMPLIST_WORK * lw, void * msg, u8 x, u8 y )
{
    if(msg==NULL){
        return;
    }
    
	if( lw->tmp.sw )					// ꎞύXXCb`
	{
		GF_STR_PrintExpand( lw->hed.win, lw->tmp.font, msg, x, y, MSG_NO_PUT, 
				GF_PRINTCOLOR_MAKE(lw->tmp.f_col, lw->tmp.s_col, lw->tmp.b_col),
				lw->tmp.msg_spc, 0, NULL );
	}
	else
	{
		GF_STR_PrintExpand( lw->hed.win, lw->hed.font, msg, x, y, MSG_NO_PUT, 
				GF_PRINTCOLOR_MAKE(lw->hed.f_col, lw->hed.s_col, lw->hed.b_col),
				lw->hed.msg_spc, 0, NULL );
	}
}


//------------------------------------------------------------------
//		Xg\
//------------------------------------------------------------------
static void ListScreenPut( BMPLIST_WORK * lw, u16 print_p, u16 line, u16 len )
{
	int	i;
	u8	x,y,yblk;

	yblk = FontHeaderGet(lw->hed.font,FONT_HEADER_SIZE_Y) + lw->hed.line_spc;

	for( i=0; i<len ;i++ ){
		if( lw->hed.list[print_p].param != BMPLIST_RABEL ){
			x = lw->hed.data_x;		// `wItZbg
		}else{
			x = lw->hed.rabel_x;	// `wItZbg
		}
		y = (u8)(((i + line) * yblk) + lw->hed.line_y);//`xItZbg
		if( lw->hed.icon != NULL ){
			lw->hed.icon( lw, lw->hed.list[print_p].param,y );
		}
		LocalMsgPrint( lw, (void*)lw->hed.list[print_p].str, x, y );
		print_p++;
	}
}


//------------------------------------------------------------------
//		J[\\
//static u8 ListCursorActorSet(BMPLIST_WORK* lw,int mode);
//------------------------------------------------------------------
static void ListCursorPut( BMPLIST_WORK * lw )
{
	u8	x,y,yblk;

	yblk = FontHeaderGet(lw->hed.font,FONT_HEADER_SIZE_Y) + lw->hed.line_spc;
	x = lw->hed.cursor_x;	//`wItZbg
	y = (u8)((lw->cp * yblk) + lw->hed.line_y);//`xItZbg

	switch(lw->hed.c_disp_f){
	case 0:
		BMPCURSOR_Print( lw->cursor, lw->hed.win, x, y );
		break;
	case 1:
		break;
	case 2:
/*
		if(lw->cur_actID == 0xff){
			//(VKݒ)
			lw->cur_actID = ListCursorActorSet(lw,0);
		}
		CursorListActorPosSet(	lw->cur_actID,
								BMPWIN_StatusGet(lw->lh.index,BMPWIN_GET_POS_X) * 8 - 1,
								BMPWIN_StatusGet(lw->lh.index,BMPWIN_GET_POS_Y) * 8 + y - 1,
								0);
*/
		break;
	case 3:
/*
		if(lw->cur_actID == 0xff){
			//(VKݒ)
			lw->cur_actID = ListCursorActorSet(lw,1);
		}
		CursorListActorPosSet(	lw->cur_actID,
								BMPWIN_StatusGet(lw->lh.index,BMPWIN_GET_POS_X) * 8 + x,
								BMPWIN_StatusGet(lw->lh.index,BMPWIN_GET_POS_Y) * 8 + y,
								1);
*/
		break;
	}
}

/*
static u8 ListCursorActorSet(BMPLIST_WORK* lw,int mode)
{
	ACT_CURSORLIST_HEADER header;

	header.x		= 0;		//\ʒuw
	header.y		= 160;		//\ʒux
	header.xsize	= BMPWIN_StatusGet(lw->lh.index,BMPWIN_GET_SIZ_X) * 8 + 2;	//\TCYw
	header.ysize	= FontHeaderGet(lw->lh.font,FONT_HEADER_SIZE_Y) + 2;		//\TCYx
	header.cellID	= 0x4000;		//J[\Zhc
	header.palID	= ACT_OAMPAL;	//J[\pbghc
	header.palnum	= 15;			//J[\pbgw̏ꍇɎgp

	return CursorListActorSet(&header,mode);

	return 0;
}
*/

//------------------------------------------------------------------
//		J[\
//------------------------------------------------------------------
static void ListCursorCls( BMPLIST_WORK * lw, u16 p )
{
	u8	yblk;

	switch(lw->hed.c_disp_f){
	case 0:
		yblk = FontHeaderGet(lw->hed.font,FONT_HEADER_SIZE_Y) + lw->hed.line_spc;

		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/04/12
		// J[\̂߂̕`̈AJ[\i6jɍ킹ďk
		GF_BGL_BmpWinFill(
				lw->hed.win,						//\EChEINDEX
				(u8)lw->hed.b_col,					//wiFf[^
				lw->hed.cursor_x,					//wW
				(u16)(p * yblk + lw->hed.line_y),	//xW
				7, 16 );
		// ----------------------------------------------------------------------------
		break;
	case 1:
	case 2:
	case 3:
		break;
	}
}

//------------------------------------------------------------------
//		J[\ړ
//------------------------------------------------------------------
static u8 ListCursorMoveUpDown( BMPLIST_WORK * lw, u8 mode )
{
	u16	list_p,cursor_p,check_p;

	cursor_p	= lw->cp;
	list_p		= lw->lp;

	if(mode == LIST_UP){

		//XN[n_(Xg̔߂)
		if(lw->hed.line == 1){
			check_p = 0;
		}else{
			check_p = (u16)(lw->hed.line - ((lw->hed.line / 2) + (lw->hed.line % 2)) - 1);
/*
			if( ( lw->hed.line & 1 ) != 0 ){
				check_p = (u16)((lw->hed.line / 2));
			}else{
				check_p = (u16)(lw->hed.line - ((lw->hed.line / 2) + (lw->hed.line % 2)) - 1);
			}
*/
		}

		if(list_p == 0){	//Xgŏ̕
			while(cursor_p > 0){
				cursor_p--;
				if(lw->hed.list[list_p + cursor_p].param != BMPLIST_RABEL){
					lw->cp = cursor_p;
					return 1;
				}
			}
			return 0;
		}
		while(cursor_p > check_p){
			cursor_p--;
			if(lw->hed.list[list_p + cursor_p].param != BMPLIST_RABEL){
				lw->cp = cursor_p;
				return 1;
			}
		}
		list_p--;
		lw->cp = check_p;
		lw->lp = list_p;

	}else{

		//XN[n_(Xg̔߂)
		if(lw->hed.line == 1){
			check_p = 0;
		}else{
			check_p = (u16)((lw->hed.line / 2) + (lw->hed.line % 2));
/*
			if( ( lw->hed.line & 1 ) != 0 ){
				check_p = (u16)((lw->hed.line / 2));
			}else{
				check_p = (u16)((lw->hed.line / 2) + (lw->hed.line % 2));
			}
*/
		}

		if(list_p == (lw->hed.count - lw->hed.line)){//XgŌ̕
			while(cursor_p < (lw->hed.line - 1)){
				cursor_p++;
				if(lw->hed.list[list_p + cursor_p].param != BMPLIST_RABEL){
					lw->cp = cursor_p;
					return 1;
				}
			}
			return 0;
		}
		while(cursor_p < check_p){
			cursor_p++;
			if(lw->hed.list[list_p + cursor_p].param != BMPLIST_RABEL){
				lw->cp = cursor_p;
				return 1;
			}
		}
		list_p++;
		lw->cp = check_p;
		lw->lp = list_p;

	}

	return 2;
}

//------------------------------------------------------------------
//		ʃXN[ړ
//------------------------------------------------------------------
static void ListScrollMoveUpDown( BMPLIST_WORK * lw, u8 len, u8 mode )
{
	u8	yblk;
	u16	ypos;

	if( len >= lw->hed.line ){
		GF_BGL_BmpWinDataFill( lw->hed.win, lw->hed.b_col );
		ListScreenPut( lw, lw->lp, 0, lw->hed.line );	//C`
		return;
	}
	//PsVtgʎ擾(tHg̑傫{xԊu)
	yblk = FontHeaderGet( lw->hed.font, FONT_HEADER_SIZE_Y ) + lw->hed.line_spc;

	if( mode == LIST_UP ){
		//f[^Vtg
		GF_BGL_BmpWinShift(
			lw->hed.win, GF_BGL_BMPWIN_SHIFT_D,
			(u8)(len * yblk), (u8)((lw->hed.b_col<<4)|lw->hed.b_col) );

		ListScreenPut( lw, lw->lp, 0, len );	//ǉC`

		ypos = (u16)( lw->hed.line * yblk + lw->hed.line_y );

		//
		GF_BGL_BmpWinFill(
			lw->hed.win,					//\EChEINDEX
			(u8)lw->hed.b_col,				//wiFf[^
			0, ypos,
			(u16)(GF_BGL_BmpWinGet_SizeX( lw->hed.win ) * 8),
			(u16)(GF_BGL_BmpWinGet_SizeY( lw->hed.win ) * 8 - ypos) );

	}else{
		//f[^Vtg
		GF_BGL_BmpWinShift(
				lw->hed.win, GF_BGL_BMPWIN_SHIFT_U,
				(u8)(len * yblk), (u8)((lw->hed.b_col<<4)|lw->hed.b_col) );
		//ǉC`
		ListScreenPut(
			lw, (u16)(lw->lp + (lw->hed.line-len)), (u16)(lw->hed.line - len), (u16)len );
		//㕔
		GF_BGL_BmpWinFill(
			lw->hed.win,
			(u8)lw->hed.b_col,				//wiFf[^
			0, 0,
			(u16)(GF_BGL_BmpWinGet_SizeX( lw->hed.win ) * 8),
			(u16)lw->hed.line_y );
	}
}



//------------------------------------------------------------------
//		Xgړ
//------------------------------------------------------------------
static u8 ListMoveUpDownCheck( BMPLIST_WORK * lw, u8 print_f, u8 req_line, u8 mode )
{
	u16	cursor_bak;	//J[\ʒu
	u8	write_flg,write_req;	//]tO
	u8	reqcount,linecount;		//JEg

	cursor_bak	= lw->cp;	//J[\ʒuۑ
	linecount = 0;
	write_req = 0;

	for(reqcount=0;reqcount<req_line;reqcount++){
		do{
			write_flg = ListCursorMoveUpDown( lw, mode );	//ړ
			write_req |= write_flg;
			if(write_flg != 2){
				break;
			}
			linecount++;
		//J[\ʒuxɂȂȂ܂ňړ
		}while(lw->hed.list[lw->lp + lw->cp].param == BMPLIST_RABEL);
	}

	if(print_f){	//\XCb`
		//Lf[^쐬
		switch(write_req){
		//ړs
		default:
		case 0:
			return 1;
			break;
		//J[\݈̂ړ
		case 1:
			ListCursorCls( lw, cursor_bak );
			ListCursorPut( lw );
			CallBackSet( lw, 0 );
			GF_BGL_BmpWinOn( lw->hed.win );
			break;
		//\Xgړ or Xg{J[\ړ
		case 2:
		case 3:
			ListCursorCls( lw, cursor_bak );
			ListScrollMoveUpDown( lw, linecount, mode );
			ListCursorPut( lw );
			CallBackSet( lw, 0 );
			GF_BGL_BmpWinOn( lw->hed.win );
			break;
		}
	}

	return 0;
}



//------------------------------------------------------------------
//		R[obN֐Ăяo( mode = 1,ʏ퓮쎞 mode = 0)
//------------------------------------------------------------------
static void CallBackSet( BMPLIST_WORK * lw, u8 mode )
{
	if( lw->hed.call_back != NULL){
		lw->hed.call_back( lw, lw->hed.list[lw->lp + lw->cp].param, mode );
	}
}



// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/09
// Xg̕\s֐ǉiɌĂ΂R[obN֐g߁j

void BmpListWinOn( BMPLIST_WORK *lw) {
	GF_BGL_BmpWinOn( lw->hed.win );
}

// ----------------------------------------------------------------------------
