//=============================================================================
/**
 * @file	builddate.c
 * @brief	\[Xt@CSʂɕύXmake悤ɂĂ݂
            {̓fobOpɂȂ̂A
            buildTime킩ƍ邱Ƃ邩Ȃ̂łĂ
 * @author	Katsumi Ohno
 * @date    2005.10.03
 */
//=============================================================================

#include "common.h"
#include "system/builddate.h"

#ifdef PM_DEBUG		// Debug ROM

char BuildDate[]=__DATE__;
char BuildTime[]=__TIME__;


void DebugBuildTimeDisp(void)
{
    OS_TPrintf("build %s %s\n", BuildDate, BuildTime);
}


void WORDSET_DebugBuildTime(WORDSET * ws)
{
    char* month[]={"Jan","Feb","Mar","Apl","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
    int i;
    STRCODE temp[20];
    int monNum = 0;
    int dayNum = 0;
    int timNum = 0;
    int minNum = 0;
    int secNum = 0;
    
    for(i = 0; i < 12; i++){  // 3r
        if(strncmp(month[i], BuildDate, 3)==0){
            monNum = i+1;
        }
    }
    dayNum = atoi(&BuildDate[4]);
    timNum = atoi(&BuildTime[0]);
    minNum = atoi(&BuildTime[3]);
    secNum = atoi(&BuildTime[6]);

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/29
// ̕\e̒Zk`ɕύX
// localize_spec_mark(LANG_KOREA) imatake 2007/09/20
// ؍ł͓{ꓯl̐\L
#if PM_LANG == LANG_KOREA
	WORDSET_RegisterNumber(ws, 0, monNum, 2, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
#else
	WORDSET_RegisterMonthName(ws, 0, monNum);
#endif
// ----------------------------------------------------------------------------
	WORDSET_RegisterNumber(ws, 1, dayNum, 2, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
	WORDSET_RegisterNumber(ws, 2, timNum, 2, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
	WORDSET_RegisterNumber(ws, 3, minNum, 2, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
	DebugBuildTimeDisp();
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/03/13
// rhԂł͂ȂAR}hCw肳ꂽCVS̃^O\悤

#include "gflib/strbuf_family.h"

char BuildTag[] = PG5_BUILDTAG;


static void strcpy_maxlen(char *dst, const char *src, int maxlen) {
	int i;

	for (i = 0; i < maxlen - 1; ++i) {
		if (*src == '\0') break;
		*dst++ = *src++;
	}

	*dst = '\0';
}

void getBuildTag(STRBUF *strbuf) {
	char tag_ascii[TAG_MAXLEN];
	STRCODE tag_strcode[TAG_MAXLEN];

	strcpy_maxlen(tag_ascii, BuildTag, TAG_MAXLEN);
	ASCIIcode2DSuni(0, (u8 *)tag_ascii, tag_strcode);

	STRBUF_SetStringCode(strbuf, tag_strcode);
}

// ----------------------------------------------------------------------------

#if 0
void DebugGetBuildTime(STRCODE* buf)
{
    char* month[]={"Jan","Feb","Mar","Apl","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
    int i;
    STRCODE temp[20];
    int monNum = 0;
    int dayNum = 0;
    int timNum = 0;
    int minNum = 0;
    int secNum = 0;
    STRCODE* pStr = buf;
    
    for(i = 0; i < 12; i++){  // 3r
        if(strncmp(month[i], BuildDate, 3)==0){
            monNum = i+1;
        }
    }
    dayNum = atoi(&BuildDate[4]);
    timNum = atoi(&BuildTime[0]);
    minNum = atoi(&BuildTime[3]);
    secNum = atoi(&BuildTime[6]);

//    OS_TPrintf("%d %d %d %d %d\n", monNum, dayNum, timNum, minNum, secNum);

    pStr = PM_NumMsgSet(pStr, monNum, NUM_MODE_SPACE, 2);
    pStr = PM_NumMsgSet(pStr, dayNum, NUM_MODE_SPACE, 3);
    pStr = PM_NumMsgSet(pStr, timNum, NUM_MODE_SPACE, 3);
    pStr = PM_NumMsgSet(pStr, minNum, NUM_MODE_SPACE, 3);
    PM_NumMsgSet(pStr, secNum, NUM_MODE_SPACE, 3);
}
#endif

#else


char BuildDate[]="";
char BuildTime[]="";


void DebugBuildTimeDisp(void)
{
}

   
#endif

