//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		clact_util_res.c
 *@brief	ZAN^[[eBeBVXe
 *@author	tomoya takahashi	
 *@data		2005.09.01
 *
 *
 * ̃VXéACLACTȒPɎgpł悤\[XǗ
 * VXe܂Ƃ߂łB
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "res_manager.h"
#include "include/system/arc_tool.h"
#include "include/system/arc_util.h"

#define __CLACT_UTIL_H_RES_GLOBAL
#include "include/system/clact_util_res.h"


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	ZAN^[\[X}l[W
//	IuWF
//	
//=====================================
typedef struct _CLACT_U_RES_OBJ{
	RES_OBJ_PTR		res_obj;		// \[XIuWF
	int				type;			// \[X^Cv
	void*			res_ex;			// gf[^	(ApbÑf[^i[A
									// ꂼ̃\[XɈႤf[^i[)
} CLACT_U_RES_OBJ;

//-------------------------------------
//	
//	\[X}l[W[Ǘ\
//	
//=====================================
typedef struct _CLACT_U_RES_MANAGER{
	RES_MANAGER_PTR res_manager;	// gp郊\[X}l[W[
	CLACT_U_RES_OBJ*	resObj;		// \[XIuWFNg
	int					tbl_num;	// e[u
	int					tbl_now;	// ̓o^
	int					type;		// \[X^Cv
} CLACT_U_RES_MANAGER;

//-------------------------------------
//	
//	f[^Ǘwb_[
//	
//=====================================
typedef struct _CLACT_U_RES_HEADER_SUB{
	int		id;
	char	file_path[64];
	int		ex[2];			// gf[^
} CLACT_U_RES_HEADER_SUB;

//-------------------------------------
//	
//	A[JCuf[^Ǘwb_[
//	
//=====================================
typedef struct _CLACT_U_RES_HEADER_SUBARC{
	int		arcFile;		// A[JCut@CID
	int		dataIdx;		// f[^idx
	BOOL	compFlag;		// ktO
	int		id;
	int		ex[2];			// gf[^
} CLACT_U_RES_HEADER_SUBARC;

//-------------------------------------
//	
//	\[X}l[W[wb_[\
//	
//=====================================
typedef struct _CLACT_U_RES_HEADER{
	void*			tbl;			// wb_[e[u
	int				tbl_num;		// e[u
	int				type;			// \[X^Cv
	u8				arc_flag;		// A[JCuꂽf[^
} CLACT_U_RES_HEADER;

//-----------------------------------------------
//
//	X̊gf[^
//
//==============================================
//-------------------------------------
//	
//	LN^
//	
//=====================================
typedef struct {
	NNSG2dCharacterData* pCharData;		// LN^f[^
	int	vram_type;						// Vram^Cv
} CLACT_U_RES_EX_CHAR;

//-------------------------------------
//	
//	pbg
//	
//=====================================
typedef struct {
	NNSG2dPaletteData* pPlttData;		// pbgf[^
	int	vram_type;						// Vram^Cv
	int	pltt_num;						// pbgio[
} CLACT_U_RES_EX_PLTT;

//-------------------------------------
//	
//	Z
//	
//=====================================
typedef struct {
	NNSG2dCellDataBank* pCellData;		// Zf[^
} CLACT_U_RES_EX_CELL;

//-------------------------------------
//	
//	ZAj
//	
//=====================================
typedef struct {
	NNSG2dAnimBankData* pCellANMData;	// ZAjf[^
} CLACT_U_RES_EX_CELLANM;

//-------------------------------------
//	
//	}`Z
//	
//=====================================
typedef struct {
	NNSG2dMultiCellDataBank* pMultiData;	// }`Zf[^
} CLACT_U_RES_EX_MULTI;

//-------------------------------------
//	
//	}`ZAj
//	
//=====================================
typedef struct {
	NNSG2dAnimBankData* pMultiANMData;		// }`ZAjf[^
} CLACT_U_RES_EX_MULTIANM;
//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//	e[up
static CLACT_U_RES_OBJ_PTR getCleanResObj(CLACT_U_RES_MANAGER_PTR resm);
static void loadOneData(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, const char* path, int id, int vram, int pltt_num, int type, int heap);
static void SetArcOneData(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, int arcFile, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int type, int heap, u32 alloc_type);
static void SetArcOneData_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int type, int heap, u32 alloc_type);
static void* ArcHandle_Load(ARCHANDLE* p_handle, u32 dataIdx, BOOL compressedFlag, u32 heapID, u32 alloc_type);


// ꂼ̊gf[^쐬
static void makeExData(CLACT_U_RES_OBJ_PTR resObj, int type, int vram_type, int pltt_num, int heap);
static CLACT_U_RES_EX_CHAR* makeExChar(void* res, int vram_type, int heap);
static CLACT_U_RES_EX_PLTT* makeExPltt(void* res, int vram_type, int pltt_num, int heap);
static CLACT_U_RES_EX_CELL* makeExCell(void* res, int heap);
static CLACT_U_RES_EX_CELLANM*	makeExCellAnm(void* res, int heap);
static CLACT_U_RES_EX_MULTI*	makeExMulti(void* res, int heap);
static CLACT_U_RES_EX_MULTIANM* makeExMultiAnm(void* res, int heap);

static void* getExData( CONST_CLACT_U_RES_OBJ_PTR resObj );


// ꂼ̊gf[^j
static void delExData(CLACT_U_RES_OBJ_PTR resObj);


// wb_[ǂݍ݂悤
static int getHeaderType(char* buff);
static int getHeaderArc(char* buff);

static int getHeaderNum(char* buff, int type, int arcFlag);
static int getHeaderNumBinary( const CLACT_U_RES_HEADER_SUBARC* buff );
static void loadHeaderData(char* buff, int type, void* tbl, int num, int arcFlag);

static void loadHeaderCore(char* buff, char** file_path, char** id, char** vram, char** pltt, int type);
static void loadCharHeaderCore(char* buff, char** path, char** id, char** type);
static void loadPlttHeaderCore(char* buff, char** path, char** id, char** type, char** pltt_num);
static void loadKindCellHeaderCore(char* buff, char** path, char** id);
static void setDataHeader(CLACT_U_RES_HEADER_SUB* head, char* path, char* id, char* type, char* pltt_num);

static void loadHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id, char** vram, char** pltt, int type);
static void loadCharHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id, char** type);
static void loadPlttHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id, char** type, char** pltt_num);
static void loadKindCellHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id);
static void setDataHeaderArc(CLACT_U_RES_HEADER_SUBARC* head, char* arcFile, char* dataIdx, char* compFlag, char* id, char* type, char* pltt_num);

static char* makeCopyStr(const char* buff, int heap);
static void delCopyStr(char* copy);


//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XǗ}l[W[
 *
 *@param	tbl_num			f[^o^
 *@param	res_type		\[X^Cv
 *@param	heap			gpq[v
 *
 *@return	CLACT_RES_MANAGER_PTR	ZAN^[[eBeB\[X}l[W[|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_MANAGER_PTR CLACT_U_ResManagerInit(int tbl_num, int res_type, int heap)
{
	CLACT_U_RES_MANAGER_PTR	resm;
	int	i;	// [vp
	

	// \[XǗf[^i[쐬
	resm = sys_AllocMemory(heap, sizeof(CLACT_U_RES_MANAGER));
	
	// \[X}l[W[쐬
	resm->res_manager = RESM_Init(tbl_num, heap);

	// IuWFo^e[u쐬
	resm->resObj = sys_AllocMemory(heap, sizeof(CLACT_U_RES_OBJ)*tbl_num);
	memset(resm->resObj, 0, sizeof(CLACT_U_RES_OBJ)*tbl_num);
	
	resm->tbl_num = tbl_num;
	resm->tbl_now = 0;
	
	// \[X^Cv
	resm->type	= res_type;
	
	return resm;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[W[̔j
 *
 *@param	resm	\[X}l[W[
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerDelete(CLACT_U_RES_MANAGER_PTR resm)
{
	GF_ASSERT(resm);
	GF_ASSERT(resm->res_manager);
	GF_ASSERT(resm->resObj);
	
	// o^Ăf[^SĔj
	CLACT_U_ResManagerResDeleteAll(resm);
	
	// mۂ
	// \[X}l[W[j
	RESM_Delete(resm->res_manager);
	resm->res_manager = NULL;

	// IuWFo^e[u쐬
	sys_FreeMemoryEz(resm->resObj);
	resm->resObj = NULL;
	 
	// \[XǗf[^i[쐬
	sys_FreeMemoryEz(resm);
	resm = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xf[^wb_[ǂݍށiPj
 *
 *@param	resm	\[X}l[W[
 *@param	head	wb_[
 *@param	no		wb_[̉Ԗڂǂݍނ
 *@param	heap	gpq[v
 *
 *@return	ǂݍ񂾃f[^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddHd(CLACT_U_RES_MANAGER_PTR resm, const CLACT_U_RES_HEADER_PTR head, int no, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;
	CLACT_U_RES_HEADER_SUB*		hs;
	CLACT_U_RES_HEADER_SUBARC*	harc;
	

	GF_ASSERT(resm);
	GF_ASSERT(head);
	GF_ASSERT(head->tbl_num > no);
	GF_ASSERT_MSG(resm->type == head->type, "\[X^CvႢ܂" );
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj,  "󂫂̃e[u܂" );
	if(head->arc_flag == 0){
		// A[JCupwb_
		hs = (CLACT_U_RES_HEADER_SUB*)head->tbl + no;
		GF_ASSERT_MSG( (CLACT_U_ResManagerCheckID(resm, hs->id) == TRUE), "IDdĂ܂")
		loadOneData(resm, obj, hs->file_path, hs->id, hs->ex[0], hs->ex[1], head->type, heap);
	}else{
		// A[JCupwb_
		harc = (CLACT_U_RES_HEADER_SUBARC*)head->tbl + no;
		GF_ASSERT_MSG( (CLACT_U_ResManagerCheckID(resm, harc->id) == TRUE), "IDdĂ܂")
		SetArcOneData(resm, obj, harc->arcFile, harc->dataIdx, harc->compFlag, harc->id, harc->ex[0], harc->ex[1], head->type, heap, ALLOC_TOP);
	}
	resm->tbl_now++;

	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^̓o^
 *
 *@param	resm			LN^pɍ쐬\[X}l[W[
 *@param	path			t@CpX
 *@param	id				Ǘhc
 *@param	vram			u^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddChar(CLACT_U_RES_MANAGER_PTR resm, const char* path, int id, int vram, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG((resm->type == CLACT_U_CHAR_RES), "\[X^CvႢ܂");
	GF_ASSERT_MSG( CLACT_U_ResManagerCheckID(resm, id) == TRUE, "IDdĂ܂")
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	loadOneData(resm, obj, path, id, vram, 0, CLACT_U_CHAR_RES, heap);
	resm->tbl_now++;

	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^̓o^
 *
 *@param	resm			pbgpɍ쐬\[X}l[W[
 *@param	path			t@CpX
 *@param	id				Ǘhc
 *@param	vram			u^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *@param	pltt_num		Kvȃpbgio[
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddPltt(CLACT_U_RES_MANAGER_PTR resm, const char* path, int id, int vram, int pltt_num, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES , "\[X^CvႢ܂");
	GF_ASSERT_MSG( CLACT_U_ResManagerCheckID(resm, id) == TRUE, "IDdĂ܂")
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	loadOneData(resm, obj, path, id, vram, pltt_num, CLACT_U_PLTT_RES, heap);
	resm->tbl_now++;

	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAZAjA}`ZA}`ZAjf[^̓o^
 *
 *@param	resm			pbgpɍ쐬\[X}l[W[
 *@param	path			t@CpX
 *@param	id				Ǘhc
 *@param	type			\[X^Cv
 *@param	heap			gpq[v
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddKindCell(CLACT_U_RES_MANAGER_PTR resm, const char* path, int id, int type, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG( CLACT_U_ResManagerCheckID(resm, id) == TRUE , "IDdĂ܂");
	GF_ASSERT(type == resm->type);
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	loadOneData(resm, obj, path, id, 0, 0, type, heap);
	resm->tbl_now++;
	
	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	A[JCuꂽLN^f[^̓o^
 *
 *@param	resm			LN^pɍ쐬\[X}l[W[
 *@param	arcFile			A[JCut@CID
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩
 *@param	id				Ǘhc
 *@param	vram			u^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcChar(CLACT_U_RES_MANAGER_PTR resm, int arcFile, int dataIdx, BOOL compFlag, int id, int vram, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData(resm, obj, arcFile, dataIdx, compFlag, id, vram, 0, CLACT_U_CHAR_RES, heap, ALLOC_TOP);

	resm->tbl_now++;

	return obj;
}
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcChar_AllocType(CLACT_U_RES_MANAGER_PTR resm, int arcFile, int dataIdx, BOOL compFlag, int id, int vram, int heap, ALLOC_TYPE alloc_type)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData(resm, obj, arcFile, dataIdx, compFlag, id, vram, 0, CLACT_U_CHAR_RES, heap, alloc_type);

	resm->tbl_now++;

	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^̓o^
 *
 *@param	resm			pbgpɍ쐬\[X}l[W[
 *@param	arcFile			A[JCut@CID
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩
 *@param	id				Ǘhc
 *@param	vram			u^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *@param	pltt_num		Kvȃpbg̖{iP{PUF)
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcPltt(CLACT_U_RES_MANAGER_PTR resm, int arcFile, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData(resm, obj, arcFile, dataIdx, compFlag, id, vram, pltt_num, CLACT_U_PLTT_RES, heap, ALLOC_TOP);

	resm->tbl_now++;
	return obj;
}
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcPltt_AllocType(CLACT_U_RES_MANAGER_PTR resm, int arcFile, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int heap, ALLOC_TYPE alloc_type)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData(resm, obj, arcFile, dataIdx, compFlag, id, vram, pltt_num, CLACT_U_PLTT_RES, heap, alloc_type);

	resm->tbl_now++;
	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAZAjA}`ZA}`ZAjf[^̓o^
 *
 *@param	resm			pbgpɍ쐬\[X}l[W[
 *@param	arcFile			A[JCut@CID
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩
 *@param	id				Ǘhc
 *@param	type			\[X^Cv(CLACT_U_CELL_RESCLACT_U_CELLANM_RES)
 *@param	heap			gpq[v
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcKindCell(CLACT_U_RES_MANAGER_PTR resm, int arcFile, int dataIdx, BOOL compFlag, int id, int type, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData(resm, obj, arcFile, dataIdx, compFlag, id, 0, 0, type, heap, ALLOC_TOP);

	resm->tbl_now++;
	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	A[JCuꂽLN^f[^̃\[XύX
 *
 *@param	resm			LN^p\[X}l[W|C^
 *@param	resObj			ύX郊\[XIuWF
 *@param	arcFile			A[JCut@CID
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩
 *
 * @return none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResChgArcChar(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, int arcFile, int dataIdx, BOOL compFlag, int heap)
{
	int vram_type;	// Vram]
	int id;			// ID
	
	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");
	GF_ASSERT(resObj);
	GF_ASSERT_MSG(resObj->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");

	// ܂ł̃f[^ۑ
	id = CLACT_U_ResManagerGetResObjID( resObj );
	vram_type =	CLACT_U_ResManagerGetResObjVramType( resObj );
	
	// ܂ł̃f[^j
	CLACT_U_ResManagerResDelete( resm, resObj );

	// ̃f[^e[uɐVf[^ǂݍ
	SetArcOneData(resm, resObj, arcFile, dataIdx, compFlag, id, vram_type, 0, CLACT_U_CHAR_RES, heap, ALLOC_TOP);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^̃\[XύX
 *
 *@param	resm			pbgp\[X}l[W|C^
 *@param	resObj			ύX郊\[XIuWF
 *@param	arcFile			A[JCut@CID
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩
 *@param	heap			gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResChgArcPltt(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, int arcFile, int dataIdx, BOOL compFlag, int heap)
{
	int vram_type;	// Vram]
	int pltt_num;	// pbg]
	int id;			// ID
	
	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");
	GF_ASSERT(resObj);
	GF_ASSERT_MSG(resObj->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");

	// ܂ł̃f[^ۑ
	id = CLACT_U_ResManagerGetResObjID( resObj );
	vram_type =	CLACT_U_ResManagerGetResObjVramType( resObj );
	pltt_num = CLACT_U_ResManagerGetResObjPlttNum( resObj );
	
	// ܂ł̃f[^j
	CLACT_U_ResManagerResDelete( resm, resObj );

	// ̃f[^e[uɐVf[^ǂݍ
	SetArcOneData(resm, resObj, arcFile, dataIdx, compFlag, id, vram_type, pltt_num, CLACT_U_PLTT_RES, heap, ALLOC_TOP);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAZAjA}`ZA}`ZAjf[^̃\[XύX
 *
 *@param	resm			ύX郊\[Xp\[X}l[W|C^
 *@param	resObj			ύX郊\[XIuWF
 *@param	arcFile			A[JCut@CID
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩
 *@param	type			\[X^Cv
 *@param	heap			gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResChgArcKindCell(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, int arcFile, int dataIdx, BOOL compFlag, int type, int heap)
{
	int id;			// ID
	
	GF_ASSERT(resm);
	GF_ASSERT(resObj);

	// ܂ł̃f[^ۑ
	id = CLACT_U_ResManagerGetResObjID( resObj );
	
	// ܂ł̃f[^j
	CLACT_U_ResManagerResDelete( resm, resObj );

	// ̃f[^e[uɐVf[^ǂݍ
	SetArcOneData(resm, resObj, arcFile, dataIdx, compFlag, id, 0, 0, type, heap, ALLOC_TOP);
}

//----------------------------------------------------------------------------
/**
 * A[JCunh
 *
 *@brief	A[JCuꂽLN^f[^̓o^
 *
 *@param	resm			LN^pɍ쐬\[X}l[W[
 *@param	arcHandle		A[JCut@Cnh
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩	(TRUE k  @@FALSE 񈳏k)
 *@param	id				Ǘhc		idȂ悤Ƀ[U[ݒj
 *@param	vram			u^Cv
 *@param	heap			gpq[v
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 * Vram^Cv
	mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN
	subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB
	ɓo^FNNS_G2D_VRAM_TYPE_2DMAX
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcChar_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int vram, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	
	SetArcOneData_ArcHandle(resm, obj, arcHandle, dataIdx, compFlag, id, vram, 0, CLACT_U_CHAR_RES, heap, ALLOC_TOP);

	resm->tbl_now++;

	return obj;
}
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcChar_ArcHandle_AllocType(CLACT_U_RES_MANAGER_PTR resm, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int vram, int heap, ALLOC_TYPE alloc_type)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	
	SetArcOneData_ArcHandle(resm, obj, arcHandle, dataIdx, compFlag, id, vram, 0, CLACT_U_CHAR_RES, heap, alloc_type);

	resm->tbl_now++;

	return obj;
}

//----------------------------------------------------------------------------
/**
 * A[JCunh
 *
 *@brief	pbgf[^̓o^
 *
 *@param	resm			pbgpɍ쐬\[X}l[W[
 *@param	arcHandle		A[JCut@Cnh
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩	(TRUE k  @@FALSE 񈳏k)
 *@param	id				Ǘhc		idȂ悤Ƀ[U[ݒj
 *@param	vram			u^Cv
 *@param	pltt_num		pbgǂݍݖ{
 *@param	heap			gpq[v
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 * Vram^Cv
	mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN
	subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB
	ɓo^FNNS_G2D_VRAM_TYPE_2DMAX
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcPltt_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData_ArcHandle(resm, obj, arcHandle, dataIdx, compFlag, id, vram, pltt_num, CLACT_U_PLTT_RES, heap, ALLOC_TOP);

	resm->tbl_now++;
	return obj;
}
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcPltt_ArcHandle_AllocType(CLACT_U_RES_MANAGER_PTR resm, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int heap, ALLOC_TYPE alloc_type )
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData_ArcHandle(resm, obj, arcHandle, dataIdx, compFlag, id, vram, pltt_num, CLACT_U_PLTT_RES, heap, alloc_type);

	resm->tbl_now++;
	return obj;
}

//----------------------------------------------------------------------------
/**
 * A[JCunh
 *
 *@brief	ZAZAjA}`ZA}`ZAjf[^̓o^
 *
 *@param	resm			pbgpɍ쐬\[X}l[W[
 *@param	arcHandle		A[JCut@Cnh
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩	(TRUE k  @@FALSE 񈳏k)
 *@param	id				Ǘhc		idȂ悤Ƀ[U[ݒj
 *@param	type			\[X^Cv
 *@param	heap			gpq[v
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF|C^
 *
 * \[X^Cv
	enum{
		CLACT_U_CHAR_RES,		// LN^\[XǗ
		CLACT_U_PLTT_RES,		// pbg\[XǗ
		CLACT_U_CELL_RES,		// Z\[XǗ
		CLACT_U_CELLANM_RES,	// ZAj\[XǗ
		CLACT_U_MULTI_RES,		// }`Z\[XǗ
		CLACT_U_MULTIANM_RES,	// }`ZAj\[XǗ
		CLACT_U_RES_MAX			// ő
	};
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerResAddArcKindCell_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int type, int heap)
{
	CLACT_U_RES_OBJ_PTR obj;

	GF_ASSERT(resm);
	
	obj = getCleanResObj(resm);
	GF_ASSERT_MSG(obj, "󂫂̃e[u܂");
	SetArcOneData_ArcHandle(resm, obj, arcHandle, dataIdx, compFlag, id, 0, 0, type, heap, ALLOC_TOP);

	resm->tbl_now++;
	return obj;
}

//----------------------------------------------------------------------------
/**
 * A[JCunh
 *
 *@brief	A[JCuꂽLN^f[^̃\[XύX
 *
 *@param	resm			LN^p\[X}l[W|C^
 *@param	resObj			ύX郊\[XIuWF
 *@param	arcHandle		A[JCut@Cnh
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩	(TRUE k  @@FALSE 񈳏k)
 *@param	heap			gpq[v
 *
 * @return none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResChgArcChar_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int heap)
{
	int vram_type;	// Vram]
	int id;			// ID
	
	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");
	GF_ASSERT(resObj);
	GF_ASSERT_MSG(resObj->type == CLACT_U_CHAR_RES, "\[X^CvႢ܂");

	// ܂ł̃f[^ۑ
	id = CLACT_U_ResManagerGetResObjID( resObj );
	vram_type =	CLACT_U_ResManagerGetResObjVramType( resObj );
	
	// ܂ł̃f[^j
	CLACT_U_ResManagerResDelete( resm, resObj );

	// ̃f[^e[uɐVf[^ǂݍ
	SetArcOneData_ArcHandle(resm, resObj, arcHandle, dataIdx, compFlag, id, vram_type, 0, CLACT_U_CHAR_RES, heap, ALLOC_TOP);
}


//----------------------------------------------------------------------------
/**
 * A[JCunh
 *
 *@brief	pbgf[^̃\[XύX
 *
 *@param	resm			pbgp\[X}l[W|C^
 *@param	resObj			ύX郊\[XIuWF
 *@param	arcHandle		A[JCut@Cnh
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩	(TRUE k  @@FALSE 񈳏k)
 *@param	heap			gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResChgArcPltt_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int heap)
{
	int vram_type;	// Vram]
	int pltt_num;	// pbg]
	int id;			// ID
	
	GF_ASSERT(resm);
	GF_ASSERT_MSG(resm->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");
	GF_ASSERT(resObj);
	GF_ASSERT_MSG(resObj->type == CLACT_U_PLTT_RES, "\[X^CvႢ܂");

	// ܂ł̃f[^ۑ
	id = CLACT_U_ResManagerGetResObjID( resObj );
	vram_type =	CLACT_U_ResManagerGetResObjVramType( resObj );
	pltt_num = CLACT_U_ResManagerGetResObjPlttNum( resObj );
	
	// ܂ł̃f[^j
	CLACT_U_ResManagerResDelete( resm, resObj );

	// ̃f[^e[uɐVf[^ǂݍ
	SetArcOneData_ArcHandle(resm, resObj, arcHandle, dataIdx, compFlag, id, vram_type, pltt_num, CLACT_U_PLTT_RES, heap, ALLOC_TOP);
}

//----------------------------------------------------------------------------
/**
 * A[JCunh
 *
 *@brief	ZAZAjA}`ZA}`ZAjf[^̃\[XύX
 *
 *@param	resm			ύX郊\[Xp\[X}l[W|C^
 *@param	resObj			ύX郊\[XIuWF
 *@param	arcHandle		A[JCut@Cnh
 *@param	detaIdx			f[^CfbNX
 *@param	compFlag		kĂ邩	(TRUE k  @@FALSE 񈳏k)
 *@param	type			\[X^Cv
 *@param	heap			gpq[v
 *
 *@return	none
 *
 * \[X^Cv
	enum{
		CLACT_U_CHAR_RES,		// LN^\[XǗ
		CLACT_U_PLTT_RES,		// pbg\[XǗ
		CLACT_U_CELL_RES,		// Z\[XǗ
		CLACT_U_CELLANM_RES,	// ZAj\[XǗ
		CLACT_U_MULTI_RES,		// }`Z\[XǗ
		CLACT_U_MULTIANM_RES,	// }`ZAj\[XǗ
		CLACT_U_RES_MAX			// ő
	};
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResChgArcKindCell_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int type, int heap)
{
	int id;			// ID
	
	GF_ASSERT(resm);
	GF_ASSERT(resObj);

	// ܂ł̃f[^ۑ
	id = CLACT_U_ResManagerGetResObjID( resObj );
	
	// ܂ł̃f[^j
	CLACT_U_ResManagerResDelete( resm, resObj );

	// ̃f[^e[uɐVf[^ǂݍ
	SetArcOneData_ArcHandle(resm, resObj, arcHandle, dataIdx, compFlag, id, 0, 0, type, heap, ALLOC_TOP);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xf[^wb_[ǂݍ
 *
 *@param	resm		\[X}l[W[|C^
 *@param	head		wb_[
 *@param	p_ro_tbl	mۍς݃\[XIuWFe[u
 *@param	heap		gpq[v
 *
 *@return	int			ǂݍݐ
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerResAddsHd(CLACT_U_RES_MANAGER_PTR resm, const CLACT_U_RES_HEADER_PTR head, CLACT_U_RES_OBJ_TBL* p_ro_tbl, int heap )
{
	GF_ASSERT(resm);
	GF_ASSERT(head);

	CLACT_U_ResManagerResAddsHdEx(resm, head, 0, head->tbl_num, p_ro_tbl, heap);
	return head->tbl_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xf[^wb_[ǂݍ(ǂݍސw)
 *
 *@param	resm		\[X}l[W[|C^
 *@param	head		wb_[
 *@param	start		ǂݍ݊Jne[uio[
 *@param	num			ǂݍݐ
 *@param	p_ro_tbl	mۍς݃\[XIuWFe[u
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResAddsHdEx(CLACT_U_RES_MANAGER_PTR resm, const CLACT_U_RES_HEADER_PTR head, int start, int num, CLACT_U_RES_OBJ_TBL* p_ro_tbl,int heap)
{
	int i;
	CLACT_U_RES_OBJ_PTR obj;

	
	for(i=start;i<start+num;i++){
		obj = CLACT_U_ResManagerResAddHd(resm, head, i, heap);

		// ǂݍ񂾃\[Xi[
		if(p_ro_tbl != NULL){
			if(p_ro_tbl->tbl_num > p_ro_tbl->tbl_now){	// o^\Ȃo^
				p_ro_tbl->tbl[ p_ro_tbl->tbl_now ] = obj;// o^IuWFݒ
				p_ro_tbl->tbl_now++;	// o^JEg
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFe[u쐬
 *
 *@param	num		e[u
 *@param	heap	gpq[v
 *
 *@return	CLACT_U_RES_OBJ_TBL* 쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_TBL* CLACT_U_ResManagerResObjTblMake(int num, int heap)
{
	CLACT_U_RES_OBJ_TBL* resTbl;

	// \[XIuWFi[̈쐬
	resTbl = sys_AllocMemory(heap, sizeof(CLACT_U_RES_OBJ_TBL));
	resTbl->tbl = sys_AllocMemory(heap, sizeof(CLACT_U_RES_OBJ_PTR)*num);
	resTbl->tbl_num = num;
	resTbl->tbl_now = 0;

	return resTbl;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFe[uj
 *
 *@param	tbl		je[u
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResObjTblDelete(CLACT_U_RES_OBJ_TBL* tbl)
{
	sys_FreeMemoryEz(tbl->tbl);
	sys_FreeMemoryEz(tbl);
	tbl = NULL;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	co^\擾
 *
 *@param	resm		\[X}l[W[|C^
 *
 *@return	int		co^\
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerRest(CLACT_U_RES_MANAGER_PTR resm)
{
	GF_ASSERT(resm);
	return resm->tbl_num - resm->tbl_now;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ID̃f[^邩`FbN
 *
 *@param	resm	\[X}l[W
 *@param	id		`FbNID
 *
 *@retval	TRUE	ID̃f[^
 *@retval	FALSE	ID̃f[^
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_ResManagerCheckID(CONST_CLACT_U_RES_MANAGER_PTR resm, int id)
{
	GF_ASSERT(resm);
	
	return RESM_CheckID(resm->res_manager, id);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[XIuWF̓ǂݍłf[^̂ݔj
 *			ID⃊\[X^CvȂǂ͕̏ێ܂
 *
 *	@param	res_obj		\[XIuWF
 *
 *	@return	none
 *
 * ̊֐ĂԂVramւ̃\[X̓]ȂǂsȂȂ܂B
 * 
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResOnlyDelete( CLACT_U_RES_OBJ_PTR res_obj )
{
	GF_ASSERT( res_obj );
	
	// gf[^j
	delExData(res_obj);

	// \[X̐f[^j
	RESM_SetRes(res_obj->res_obj, NULL);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xj
 *
 *@param	resm		ZAN^[[eBeB\[X}l[W[|C^
 *@param	res_obj		\[XIuWF
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResDelete(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR res_obj)
{
	GF_ASSERT(resm);
	GF_ASSERT(resm->resObj);

	// gf[^j
	delExData(res_obj);

	// \[XjAf[^e[uɂ
	RESM_DeleteRes(resm->res_manager, res_obj->res_obj);
	res_obj->res_obj = NULL;
	
	resm->tbl_now--;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XSj
 *
 *@param	resm		ZAN^[[eBeB\[X}l[W[|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerResDeleteAll(CLACT_U_RES_MANAGER_PTR resm)
{
	int i;		// [vp

	for(i=0;i<resm->tbl_num;i++){
		if(resm->resObj[i].res_obj != NULL){
			CLACT_U_ResManagerResDelete(resm, resm->resObj + i);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ID̃\[X擾
 *
 *@param	id		擾郊\[XIuWF|C^ɐݒ肳ĂǗhc
 *	
 *@return	CLACT_U_RES_OBJ_PTR		\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerGetIDResObjPtr(CONST_CLACT_U_RES_MANAGER_PTR resm, int id)
{
	int i;		// [vp
	int ret_id;	// id

	GF_ASSERT(resm);

	for(i=0;i<resm->tbl_num;i++){
		if(resm->resObj[i].res_obj){
			ret_id = RESM_GetID(resm->resObj[i].res_obj);

			if(ret_id == id){
				return (resm->resObj + i);
			}
		}

	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFhc擾
 *
 *@param	resObj	\[XIuWF
 *	
 *@return	int		Ǘhc
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerGetResObjID(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	GF_ASSERT(resObj);
	return RESM_GetID(resObj->res_obj);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFhcݒ
 *
 *@param	resm	ύXIuWF̓o^Ă郊\[X}l[W
 *@param	resObj	\[XIuWF
 *@param	id		ݒ肷ID
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerSetResObjID(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, int id)
{
	GF_ASSERT(resObj);

	RESM_SetID(resm->res_manager, resObj->res_obj, id);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWF̃\[X擾
 *
 *@param	resObj	\[XIuWF
 *	
 *@return	void*	\[X|C^
 *
 * ApbN֎~łB
 * ApbNς݃t@C擾֐pӂĂ邽߁A
 * gpĂB
 *
 */
//-----------------------------------------------------------------------------
void* CLACT_U_ResManagerGetResObjRes(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	void* buff;
	
	GF_ASSERT(resObj);
	buff = RESM_GetRes(resObj->res_obj);

	// CLACT_U_ResManagerResOnlyDeleteŃf[^jׁA
	// f[^܂B
	GF_ASSERT( buff );
	
	return buff;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^擾	\[Xf[^ApbNĂ擾
 *
 *@param	resObj	LN^\[XIuWF
 *
 *@return	LN^\[Xf[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dCharacterData* CLACT_U_ResManagerGetResObjResChar(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	CLACT_U_RES_EX_CHAR* data;
	
	GF_ASSERT(resObj->type == CLACT_U_CHAR_RES);

	data = (CLACT_U_RES_EX_CHAR*)getExData( resObj );

	return data->pCharData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^擾	\[Xf[^ApbNĂ擾
 *
 *@param	resObj	pbg\[XIuWF
 *
 *@return	pbg\[Xf[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dPaletteData* CLACT_U_ResManagerGetResObjResPltt(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	CLACT_U_RES_EX_PLTT* data;
	
	GF_ASSERT(resObj->type == CLACT_U_PLTT_RES);

	data = (CLACT_U_RES_EX_PLTT*)getExData( resObj ); 

	return data->pPlttData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Zf[^擾	\[Xf[^ApbNĂ擾
 *
 *@param	resObj	Z\[XIuWF
 *
 *@return	Z\[Xf[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dCellDataBank* CLACT_U_ResManagerGetResObjResCell(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	CLACT_U_RES_EX_CELL* data;
	
	GF_ASSERT(resObj->type == CLACT_U_CELL_RES);

	data = (CLACT_U_RES_EX_CELL*)getExData( resObj );

	return data->pCellData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAjf[^擾	\[Xf[^ApbNĂ擾
 *
 *@param	resObj	ZAj\[XIuWF
 *
 *@return	ZAj\[Xf[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dCellAnimBankData* CLACT_U_ResManagerGetResObjResCellAnm(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	CLACT_U_RES_EX_CELLANM* data;
	
	GF_ASSERT(resObj->type == CLACT_U_CELLANM_RES);

	data = (CLACT_U_RES_EX_CELLANM*)getExData( resObj );

	return data->pCellANMData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	}`Zf[^擾	\[Xf[^ApbNĂ擾
 *
 *@param	resObj	}`Z\[XIuWF
 *
 *@return	}`Z\[Xf[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dMultiCellDataBank* CLACT_U_ResManagerGetResObjResMultiCell(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	CLACT_U_RES_EX_MULTI* data;
	
	GF_ASSERT(resObj->type == CLACT_U_MULTI_RES);

	data = (CLACT_U_RES_EX_MULTI*)getExData( resObj );

	return data->pMultiData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	}`ZAjf[^擾	\[Xf[^ApbNĂ擾
 *
 *@param	resObj	}`ZAj\[XIuWF
 *
 *@return	}`ZAj\[Xf[^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dMultiCellAnimBankData* CLACT_U_ResManagerGetResObjResMultiCellAnim(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	CLACT_U_RES_EX_MULTIANM* data;
	
	GF_ASSERT(resObj->type == CLACT_U_MULTIANM_RES);

	data = (CLACT_U_RES_EX_MULTIANM*)getExData( resObj );

	return data->pMultiANMData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFɐݒ肳Ă郊\[X̃^Cv擾
 *
 *@param	resObj	\[XIuWF
 *	
 *@return	int		\[X^Cv
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerGetResObjResType(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	GF_ASSERT(resObj);
	return resObj->type;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFɐݒ肳ĂVram^Cv擾
 *
 *@param	resObj	\[XIuWF
 *	
 *@return	int		Vram^CviLN^Bpbĝ݁j
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerGetResObjVramType(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	GF_ASSERT(resObj);

	if(resObj->type == CLACT_U_CHAR_RES){
		CLACT_U_RES_EX_CHAR* chardata;
		chardata = getExData( resObj );
		return chardata->vram_type;
	}
	
	if(resObj->type == CLACT_U_PLTT_RES){
		CLACT_U_RES_EX_PLTT* plttdata;
		plttdata = getExData( resObj );
		return plttdata->vram_type;
	}
	
	return 0;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFɐݒ肳Ăpbgǂݍݐ擾
 *
 *@param	resObj	\[XIuWF
 *	
 *@return	int		Vram^Cvipbĝ݁j
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerGetResObjPlttNum(CONST_CLACT_U_RES_OBJ_PTR resObj)
{
	GF_ASSERT(resObj);

	if(resObj->type == CLACT_U_PLTT_RES){
		CLACT_U_RES_EX_PLTT* plttdata;
		plttdata = getExData( resObj );
		return plttdata->pltt_num;
	}
	
	return 0;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFɐݒ肳Ăvram^Cv擾
 *
 *@param	resobj	\[XIuWF
 *@param	vram	vram^Cv	C:1	Tu:2
 *	
 *@return	int		vram^CviLN^Bpbĝ݁j
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerSetResObjVramType(CLACT_U_RES_OBJ_PTR resObj, int vram)
{
	GF_ASSERT(resObj);

	if(resObj->type == CLACT_U_CHAR_RES){
		CLACT_U_RES_EX_CHAR* chardata;
		chardata = getExData( resObj );
		chardata->vram_type = vram;
	}
	
	if(resObj->type == CLACT_U_PLTT_RES){
		CLACT_U_RES_EX_PLTT* plttdata;
		plttdata = getExData( resObj );
		plttdata->vram_type = vram;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFɐݒ肳Ăpbgǂݍݐ擾
 *
 *@param	resObj	\[XIuWF
 *@param	pltt	pbgǂݍݐ
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerSetResObjPlttNum(CLACT_U_RES_OBJ_PTR resObj, int pltt)
{
	GF_ASSERT(resObj);

	if(resObj->type == CLACT_U_PLTT_RES){
		CLACT_U_RES_EX_PLTT* plttdata;
		plttdata = getExData( resObj );
		plttdata->pltt_num = pltt;
	}
}






//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[TCY擾
 *
 *@param	none
 *
 *@return	int		TCY
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerGetHeaderSize(void)
{
	return sizeof(CLACT_U_RES_HEADER);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xwb_[zŊmۂƂ̊evf̃f[^
 *			擾֐
 *
 *@param	head	wb_[f[^izj
 *@param	no		vf
 *
 *@return	CLACT_U_RES_HEADER_PTR
 *
 * noz̗vf傫Asȃ|C^ԂĂ܂܂B
 *
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_HEADER_PTR CLACT_U_ResManagerGetHeaderNoData(CLACT_U_RES_HEADER_PTR head, int no)
{
	return (head + no);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[[eBeB\[X}l[Wwb_[ǂݍ
 *
 *@param	path		wb_[t@CpX
 *@param	head		wb_[i[
 *@param	heap		gpq[v
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderLoad(const char* path, CLACT_U_RES_HEADER_PTR head,int heap)
{
	char* tmp;				// p
	char* buff;				// t@Cf[^
	int	i;					// [vp

	GF_ASSERT(head);		// wb_[̈mۂĂ


	// t@Cǂݍ
	tmp = sys_LoadFile(heap, path);
	GF_ASSERT_MSG(tmp, "wb_[ǂݍݎs");

	// [Nobt@
	buff = makeCopyStr(tmp, heap);
	
	// \[X^Cv擾
	head->type = getHeaderType(buff);
	delCopyStr(buff);			// j
	buff = makeCopyStr(tmp, heap);	// ăRs[

	// A[JCu^Cv擾
	head->arc_flag = getHeaderArc(buff);
	delCopyStr(buff);			// j
	buff = makeCopyStr(tmp, heap);	// ăRs[

	// f[^̎擾
	head->tbl_num = getHeaderNum(buff, head->type, head->arc_flag);
	delCopyStr(buff);			// j
	buff = makeCopyStr(tmp, heap);	// ăRs[
	
	// f[^̗̊m
	if(head->tbl_num > 0){
		if(head->arc_flag == 0){
			head->tbl = sys_AllocMemory(heap, sizeof(CLACT_U_RES_HEADER_SUB)*head->tbl_num);
		}else{
			head->tbl = sys_AllocMemory(heap, sizeof(CLACT_U_RES_HEADER_SUBARC)*head->tbl_num);
		}
	}else{
		head->tbl = NULL;
	}
	
	// f[^i[
	if(head->tbl){
		loadHeaderData(buff, head->type, head->tbl, head->tbl_num, head->arc_flag);	
	}
	
	// ǂݍ݃t@Cj
	delCopyStr(buff);
	sys_FreeMemoryEz(tmp);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[[eBeB\[X}l[WoCiwb_[ǂݍ
 *
 *@param	cp_bindata		oCif[^
 *@param	head			wb_[i[
 *@param	heap			gpq[v
 *
 *@return	none
 *
 * Binaryf[^		Sf[^4byte؂
 *	\[X^Cv
 *	A[JCut@Cidx
 *	f[^idx
 *	ktO
 *	ǗID
 *	Vram^Cv				ȂƂ̓_~[f[^
 *	  pbgǂݍݖ{	ȂƂ̓_~[f[^
 *
 * LN^\[X̎
 * pbg\[X̎
 *	
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderLoadBinary(const void* cp_bindata, CLACT_U_RES_HEADER_PTR head,int heap)
{
	int	i;					// [vp
	const int* view;		// oCif[^QƗp

	GF_ASSERT(head);		// wb_[̈mۂĂ

	// QƂł悤int*^Ō
	view = cp_bindata;

	// \[X^Cv擾
	head->type = view[0];		// 擪4byte \[X^Cv

	head->arc_flag = 1;			// A[JCut@CŒ

	// f[^̎擾
	head->tbl_num = getHeaderNumBinary( (const CLACT_U_RES_HEADER_SUBARC*)(view + 1) );
	
	// f[^̗̈̊m
	if(head->tbl_num > 0){
		head->tbl = sys_AllocMemory(heap, sizeof(CLACT_U_RES_HEADER_SUBARC)*head->tbl_num);
	}else{
		head->tbl = NULL;
	}
	
	// f[^i[
	if(head->tbl){
		memcpy( head->tbl, view + 1, sizeof(CLACT_U_RES_HEADER_SUBARC)*head->tbl_num );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[Wwb_[j
 *
 *@param	head		wb_[|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderFree(CLACT_U_RES_HEADER_PTR head)
{
	if(head->tbl){
		sys_FreeMemoryEz(head->tbl);
	}
	head->tbl = NULL;
	head->tbl_num = 0;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[W[wb_[ɓǂݍ܂Ăf[^擾
 *
 *@param	head		\[Xwb_
 *
 *@return	int		ǂݍ܂Ăf[^
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderSetDataNum(CONST_CLACT_U_RES_HEADER_PTR head)
{
	GF_ASSERT(head);
	return head->tbl_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[W[wb_[ɓǂݍ܂Ăf[^̃\[X^Cv
 *
 *@param	head		\[Xwb_
 *
 *@return	int		\[X^Cv
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderSetDataResType(CONST_CLACT_U_RES_HEADER_PTR head)
{
	GF_ASSERT(head);
	return head->type;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[W[wb_[ɓǂݍ܂Ăf[^̓A[JCuĂ邩
 *
 *@param	head		\[Xwb_
 *
 *@return	int			0FĂȂ	1FĂ
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderSetDataArc(CONST_CLACT_U_RES_HEADER_PTR head)
{
	GF_ASSERT(head);
	return head->arc_flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wb_ɓo^Ăf[^IDύX
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *	@param	param		ݒ肷ID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderDataIDSet( CLACT_U_RES_HEADER_PTR head, int no, int param )
{
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 0){
		CLACT_U_RES_HEADER_SUB* data = head->tbl;

		data[ no ].id = param;
	}else{
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		data[ no ].id = param;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wb_ɓo^Ăf[^ID擾
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *
 *	@return	int		ǗID
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderDataIDGet( CONST_CLACT_U_RES_HEADER_PTR head, int no )
{
	int ret_id;		// ߂lp
	
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 0){
		CLACT_U_RES_HEADER_SUB* data = head->tbl;

		ret_id = data[ no ].id;
	}else{
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		ret_id = data[ no ].id;
	}

	return ret_id;
}

//----------------------------------------------------------------------------
/**
 *	A[JCut@Cp
 *
 *	@brief	wb_ɓo^ĂA[JCut@CIDύX
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *	@param	param		ݒ肷A[JCut@CID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderArcFileSet( CLACT_U_RES_HEADER_PTR head, int no, int param )
{
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 1){
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		data[ no ].arcFile = param;
	}
}

//----------------------------------------------------------------------------
/**
 *	A[JCut@Cp
 *
 *	@brief	wb_ɓo^Ăf[^̃A[JCut@CID擾
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *
 *	@return	int		A[JCut@CID
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderArcFileGet( CONST_CLACT_U_RES_HEADER_PTR head, int no )
{
	int ret_id;		// ߂lp
	
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 1){
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		ret_id = data[ no ].arcFile;
	}

	return ret_id;
}

//----------------------------------------------------------------------------
/**
 *	A[JCut@Cp
 *
 *	@brief	wb_ɓo^ĂA[JCuidxύX
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *	@param	param		ݒ肷A[JCut@CID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderDataIdxSet( CLACT_U_RES_HEADER_PTR head, int no, int param )
{
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 1){
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		data[ no ].dataIdx = param;
	}
}

//----------------------------------------------------------------------------
/**
 *	A[JCut@Cp
 *
 *	@brief	wb_ɓo^Ăf[^̃f[^idx擾
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *
 *	@return	int			f[^idx
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderDataIdxGet( CONST_CLACT_U_RES_HEADER_PTR head, int no )
{
	int ret_id;		// ߂lp
	
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 1){
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		ret_id = data[ no ].dataIdx;
	}

	return ret_id;
}

//----------------------------------------------------------------------------
/**
 *	A[JCut@Cp
 *
 *	@brief	wb_ɓo^Ă鈳kt@CtOύX
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *	@param	param		ݒ肷tO	iTRUE@FALSEj
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderCompFlagSet( CLACT_U_RES_HEADER_PTR head, int no, int param )
{
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 1){
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		data[ no ].compFlag = param;
	}
}

//----------------------------------------------------------------------------
/**
 *	A[JCut@Cp
 *
 *	@brief	wb_ɓo^Ăf[^̃f[^idx擾
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *
 *	@return	int			ktO	iTRUE@FALSEj
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderCompFlagGet( CONST_CLACT_U_RES_HEADER_PTR head, int no )
{
	int ret_id;		// ߂lp
	
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 1){
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		ret_id = data[ no ].compFlag;
	}

	return ret_id;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wb_ɓo^ĂVRam^CvύX
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *	@param	param		ݒ肷VRam^Cv
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderVramTypeSet( CLACT_U_RES_HEADER_PTR head, int no, int param )
{
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 0){
		CLACT_U_RES_HEADER_SUB* data = head->tbl;

		data[ no ].ex[0]= param;
	}else{
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		data[ no ].ex[0] = param;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wb_ɓo^Ăf[^VramType擾
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *
 *	@return	int		VramType
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderVramTypeGet( CONST_CLACT_U_RES_HEADER_PTR head, int no )
{
	int ret_id;		// ߂lp
	
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 0){
		CLACT_U_RES_HEADER_SUB* data = head->tbl;

		ret_id = data[ no ].ex[0];
	}else{
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		ret_id = data[ no ].ex[0];
	}

	return ret_id;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wb_ɓo^ĂpbgǂݍݐύX
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *	@param	param		ݒ肷pbgǂݍݐ
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_ResManagerHeaderPlttNumSet( CLACT_U_RES_HEADER_PTR head, int no, int param )
{
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 0){
		CLACT_U_RES_HEADER_SUB* data = head->tbl;

		data[ no ].ex[1]= param;
	}else{
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		data[ no ].ex[1] = param;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wb_ɓo^Ăf[^̃pbgǂݍݐ擾
 *
 *	@param	head		\[Xwb_[
 *	@param	no			\[Xwb_[ɓo^Ăf[^io[
 *
 *	@return	int		VramType
 *
 *
 */
//-----------------------------------------------------------------------------
int CLACT_U_ResManagerHeaderPlttNumGet( CONST_CLACT_U_RES_HEADER_PTR head, int no )
{
	int ret_id;		// ߂lp
	
	GF_ASSERT( head );
	GF_ASSERT( head->tbl_num > no );
	
	if(head->arc_flag == 0){
		CLACT_U_RES_HEADER_SUB* data = head->tbl;

		ret_id = data[ no ].ex[1];
	}else{
		CLACT_U_RES_HEADER_SUBARC* data = head->tbl;

		ret_id = data[ no ].ex[1];
	}

	return ret_id;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	󂢂Ă郊\[XIuWFe[u擾
 *
 *@param	none
 *
 *@return	CLACT_U_RES_OBJ_PTR	\[XIuWF
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_OBJ_PTR getCleanResObj(CLACT_U_RES_MANAGER_PTR resm)
{
	int i;

	for(i=0;i<resm->tbl_num;i++){
		if(resm->resObj[i].res_obj == NULL){
			return resm->resObj + i;
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	gf[^쐬
 *
 *@param	resObj		\[XIuWF
 *@param	type		\[X^Cv
 *@param	vram_type	Vram^Cv
 *@param	pltt_num	pbg
 *@param	heap		q[vio[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void makeExData(CLACT_U_RES_OBJ_PTR resObj, int type, int vram_type, int pltt_num, int heap)
{
	void* res;

	res = RESM_GetRes(resObj->res_obj);		// \[X擾
	
	switch(type){
	case CLACT_U_CHAR_RES:
		resObj->res_ex = makeExChar(res, vram_type, heap);
		break;
	case CLACT_U_PLTT_RES:
		resObj->res_ex = makeExPltt(res, vram_type, pltt_num, heap);
		break;
	case CLACT_U_CELL_RES:
		resObj->res_ex = makeExCell(res, heap);
		break;
	case CLACT_U_CELLANM_RES:
		resObj->res_ex = makeExCellAnm(res, heap);
		break;
	case CLACT_U_MULTI_RES:
		resObj->res_ex = makeExMulti(res, heap);
		break;
	case CLACT_U_MULTIANM_RES:
		resObj->res_ex = makeExMultiAnm(res, heap);
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^gf[^쐬
 *
 *@param	res			\[X|C^
 *@param	vram_type	vram^Cv
 *@param	heap		gpq[v
 *
 *@return	CLACT_U_RES_EX_CHAR*	쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_EX_CHAR* makeExChar(void* res, int vram_type, int heap)
{
	CLACT_U_RES_EX_CHAR* data;

	data = sys_AllocMemory(heap, sizeof(CLACT_U_RES_EX_CHAR));
	NNS_G2dGetUnpackedCharacterData(res, &data->pCharData);
	data->vram_type = vram_type;
	
	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbggf[^쐬
 *
 *@param	res			\[X|C^
 *@param	vram_type	Vram^Cv
 *@param	pltt_num	pbg
 *@param	heap		gpq[v
 *
 *@return	CLACT_U_RES_EX_PLTT* 쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_EX_PLTT* makeExPltt(void* res, int vram_type, int pltt_num, int heap)
{
	CLACT_U_RES_EX_PLTT* data;

	data = sys_AllocMemory(heap, sizeof(CLACT_U_RES_EX_PLTT));
	NNS_G2dGetUnpackedPaletteData(res, &data->pPlttData);
	data->vram_type = vram_type;
	data->pltt_num	= pltt_num;

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Zgf[^쐬
 *
 *@param	res		\[X|C^
 *@param	heap	gpq[v
 *
 *@return	CLACT_U_RES_EX_CELL*	쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_EX_CELL* makeExCell(void* res, int heap)
{
	CLACT_U_RES_EX_CELL* data;

	data = sys_AllocMemory(heap, sizeof(CLACT_U_RES_EX_CELL));
	NNS_G2dGetUnpackedCellBank(res, &data->pCellData);

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAjgf[^쐬
 *
 *@param	res		\[X|C^
 *@param	heap	gpq[v
 *
 *@return	CLACT_U_RES_EX_CELLANM*	쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_EX_CELLANM*	makeExCellAnm(void* res, int heap)
{
	CLACT_U_RES_EX_CELLANM* data;

	data = sys_AllocMemory(heap, sizeof(CLACT_U_RES_EX_CELLANM));
	NNS_G2dGetUnpackedAnimBank(res, &data->pCellANMData);

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	}`Zgf[^쐬
 *
 *@param	res		\[X|C^
 *@param	heap	gpq[v
 *
 *@return	CLACT_U_RES_EX_MULTI*	쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_EX_MULTI*	makeExMulti(void* res, int heap)
{
	CLACT_U_RES_EX_MULTI* data;

	data = sys_AllocMemory(heap, sizeof(CLACT_U_RES_EX_MULTI));
	NNS_G2dGetUnpackedMultiCellBank(res, &data->pMultiData);

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	}`ZAjgf[^쐬
 *
 *@param	res		\[X|C^
 *@param	heap	gpq[v
 *
 *@return	CLACT_U_RES_EX_MULTIANM* 쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_EX_MULTIANM* makeExMultiAnm(void* res, int heap)
{
	CLACT_U_RES_EX_MULTIANM* data;

	data = sys_AllocMemory(heap, sizeof(CLACT_U_RES_EX_MULTIANM));
	NNS_G2dGetUnpackedMCAnimBank(res, &data->pMultiANMData);

	return data;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ꂼ̊gf[^j
 *
 *@param	\[XIuWF	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delExData(CLACT_U_RES_OBJ_PTR resObj)
{
	if( resObj->res_ex ){
		sys_FreeMemoryEz(resObj->res_ex);
	}
	resObj->res_ex = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	gf[^擾
 *
 *	@param	resObj	\[XIuWF
 *
 *	@return	egf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static void* getExData( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	GF_ASSERT( resObj );

	// CLACT_U_ResManagerResOnlyDeleteŃf[^jׁA
	// f[^܂B
	GF_ASSERT( resObj->res_ex );
	
	return resObj->res_ex;
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	P̃f[^ǂݍ
 *
 *@param	resm	\[X}l[W[
 *@param	resObj	\[XIuWF
 *@param	path	t@CpX
 *@param	id		ǗID
 *@param	vram	vram^Cv
 *@param	pltt_numpbggp
 *@param	type	\[X^Cv
 *@param	heap	gpq[v
 *
 *@return	CLACT_U_RES_OBJ_PTR		\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadOneData(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, const char* path, int id, int vram, int pltt_num, int type, int heap)
{
	resObj->res_obj = RESM_AddRes(resm->res_manager, path, id, heap);	// \[Xǂݍ
	
	resObj->type = type;	// \[X^Cv
	
	// ̑f[^ݒ
	makeExData(resObj, type, vram, pltt_num, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	P̃A[JCuf[^\[X}l[Wɐݒ肷
 *
 *@param	resm		\[X}l[Wf[^
 *@param	resObj		f[^i[惊\[XIuWF
 *@param	arcFile		A[JCut@CI
 *@param	dataIdx		f[^Idx	
 *@param	compFlag	ktO
 *@param	id			ǗID
 *@param	vram		Vram^Cv
 *@param	pltt_num	pbgǂݍݐ
 *@param	type		\[X^Cv
 *@param	heap		gpq[v
 *@param	alloc_type	AP[g^Cv
 *	ALLOC_TOP = 0,			///< q[v̐擪
 *	ALLOC_BOTTOM = 1,		///< q[v̏I[
 *
 *@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
static void SetArcOneData(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, int arcFile, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int type, int heap, u32 alloc_type)
{
	void* res;
	
	// \[Xǂݍ
	res = ArcUtil_Load(arcFile, dataIdx, compFlag, heap, alloc_type);

	// \[X}l[W[ɐݒ
	resObj->res_obj = RESM_AddResNormal(resm->res_manager, res, id);

	// \[X^Cv
	resObj->type = type;
	
	// ̑f[^ݒ
	makeExData(resObj, type, vram, pltt_num, heap);
}

//----------------------------------------------------------------------------
/**
 *
 * A[JCunh
 *
 *@brief	P̃A[JCuf[^\[X}l[Wɐݒ肷
 *
 *@param	resm		\[X}l[Wf[^
 *@param	resObj		f[^i[惊\[XIuWF
 *@param	arcHandle	A[JCut@Cnh
 *@param	dataIdx		f[^Idx	
 *@param	compFlag	ktO
 *@param	id			ǗID
 *@param	vram		Vram^Cv
 *@param	pltt_num	pbgǂݍݐ
 *@param	type		\[X^Cv
 *@param	heap		gpq[v
 *@param	alloc_type	mۃ^Cv
 *
 *@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
static void SetArcOneData_ArcHandle(CLACT_U_RES_MANAGER_PTR resm, CLACT_U_RES_OBJ_PTR resObj, ARCHANDLE* arcHandle, int dataIdx, BOOL compFlag, int id, int vram, int pltt_num, int type, int heap, u32 alloc_type)
{
	void* res;
	
	res = ArcHandle_Load( arcHandle, dataIdx, compFlag, heap, alloc_type);

	// \[X}l[W[ɐݒ
	resObj->res_obj = RESM_AddResNormal(resm->res_manager, res, id);

	// \[X^Cv
	resObj->type = type;
	
	// ̑f[^ݒ
	makeExData(resObj, type, vram, pltt_num, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xf[^^Cv擾
 *
 *@param	buff	wb_[f[^
 *
 *@return	int		\[X^Cv
 *
 *
 */
//-----------------------------------------------------------------------------
static int getHeaderType(char* buff)
{
	int no;
	char* tok;
	
	// 擪ɂ
	tok	= strtok(buff, ",");
	
	no = atoi(tok);

	return no;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	A[JCuꂽt@Cp擾
 *
 *@param	buff	wb_[f[^
 *
 *@return	int		A[JCuꂽf[^悤
 *
 *
 */
//-----------------------------------------------------------------------------
static int getHeaderArc(char* buff)
{
	int no;
	char* tok;
	
	// 擪QԖ
	tok	= strtok(buff, ",");
	tok	= strtok(NULL, ",");
	
	no = atoi(tok);

	return no;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[ɓo^Ăf[^擾
 *
 *@param	buff	wb_[f[^
 *@param	type	wb_[^Cv
 *@param	arcFlag	A[JCut@Cǂ̃tO
 *
 *@return	int		wb_[
 *
 *
 */
//-----------------------------------------------------------------------------
static int getHeaderNum(char* buff, int type, int arcFlag)
{
	int count;			// f[^JEg
	char* path_or_arc;	// t@CpXA[JCut@C
	char* data_idx;		// f[^CfbNX
	char* commpFlag;	// kꂽf[^
	char* id;			// ID
	char* vram;			// vram
	char* pltt;			// pltt

	// ŏ̂P̓\[X̎ނȂ̂Ŕ΂
	strtok(buff, ",");
	strtok(NULL, ",");
	strtok(NULL, "\n");
	
	count = 0;
	if(arcFlag == 0){
		loadHeaderCore(NULL, &path_or_arc,&id, &vram, &pltt, type);	// P̃f[^i[
	}else{
		loadHeaderCoreArc(NULL, &path_or_arc,&data_idx,&commpFlag,&id,&vram,&pltt,type);
	}
	
	// pX'0'̃f[^I[
	while(path_or_arc[0] != 'e'){
		count++;

		if(arcFlag == 0){
			loadHeaderCore(NULL, &path_or_arc, &id, &vram, &pltt, type);	// Pڈȍ~NULLOK
		}else{
			loadHeaderCoreArc(NULL, &path_or_arc,&data_idx,&commpFlag,&id,&vram,&pltt,type);
		}

		if(path_or_arc == NULL){
			GF_ASSERT(0);		// I[R[h
		}
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	oCif[^̃wb_[e[u擾
 *
 *	@param	buff	oCif[^
 *
 *	@return	IR[hȂe[u
 *
 *
 */
//-----------------------------------------------------------------------------
static int getHeaderNumBinary( const CLACT_U_RES_HEADER_SUBARC* buff )
{
	int count;

	count = 0;
	while( buff[count].arcFile != CLACT_U_RES_HEADER_MAKE_END_CODE ){
		count++;
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[f[^ǂݍ
 *
 *@param	buff	wb_[f[^
 *@param	type	\[X^Cv
 *@param	tbl		ǂݍݐ
 *@param	num		ǂݍ݂
 *@param	arcFlag	A[JCut@Cǂ
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadHeaderData(char* buff, int type, void* tbl, int num, int arcFlag)
{
	int i;		// [vp
	char* path_or_arc;	// t@CpXA[JCut@C
	char* data_idx;		// f[^CfbNX
	char* commpFlag;	// kꂽf[^
	char* id;			// ID
	char* vram;			// vram
	char* pltt;			// pltt

	// ŏ̂P̓\[X̎ނȂ̂Ŕ΂
	strtok(buff, ",");
	strtok(NULL, ",");
	strtok(NULL, "\n");

	// ǂݍ
	for(i=0;i<num;i++){
		if(arcFlag == 0){
			loadHeaderCore(NULL, &path_or_arc, &id, &vram, &pltt, type);	// P̃f[^i[
			setDataHeader((CLACT_U_RES_HEADER_SUB*)tbl + i, path_or_arc, id, vram, pltt);
		}else{
			loadHeaderCoreArc(NULL, &path_or_arc,&data_idx,&commpFlag,&id,&vram,&pltt,type);
			setDataHeaderArc((CLACT_U_RES_HEADER_SUBARC*)tbl + i, path_or_arc, data_idx, commpFlag, id, vram, pltt);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	P̃f[^ǂݍł
 *
 *@param	buff		wb_[f[^
 *@param	file_path	pXi[
 *@param	id			IDi[
 *@param	vram		u^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *@param	pltt		pbgi[
 *@param	type		\[X^Cv
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadHeaderCore(char* buff, char** file_path, char** id, char** vram, char** pltt, int type)
{
	switch(type){
	case CLACT_U_CHAR_RES:
		loadCharHeaderCore(buff, file_path, id, vram);
		*pltt = NULL;
		break;
	case CLACT_U_PLTT_RES:
		loadPlttHeaderCore(buff, file_path, id, vram, pltt);
		break;
	case CLACT_U_CELL_RES:
	case CLACT_U_CELLANM_RES:
	case CLACT_U_MULTI_RES:
	case CLACT_U_MULTIANM_RES:
		loadKindCellHeaderCore(buff, file_path, id);
		*vram = NULL;
		*pltt = NULL;
		break;
	default:
		GF_ASSERT_MSG(0, "sȃtH[}bgł\n");
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	P̃LN^f[^ǂݍ
 *
 *@param	buff	wb_[f[^
 *@param	path	pXi[
 *@param	id		IDi[
 *@param	type	Vram^Cvi[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadCharHeaderCore(char* buff, char** path, char** id, char** type)
{
	*path	= strtok(buff, ",");
	*id		= strtok(NULL, ",");
	*type	= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbĝP̃f[^擾
 *
 *@param	buff		wb_[f[^
 *@param	path		pXi[
 *@param	id			hci[
 *@param	type		u^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *@param	pltt_num	pbg
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadPlttHeaderCore(char* buff, char** path, char** id, char** type, char** pltt_num)
{
	*path		= strtok(buff, ",");
	*id			= strtok(NULL, ",");
	*type		= strtok(NULL, ",");
	*pltt_num	= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Zނ̃wb_[f[^i[
 *	
 *@param	buff	wb_[f[^
 *@param	path	pXi[
 *@param	id		hci[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadKindCellHeaderCore(char* buff, char** path, char** id)
{
	*path		= strtok(buff, ",");
	*id			= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	f[^ݒ
 *
 *@param	head	ݒ
 *@param	path	ݒpX
 *@param	id		ݒhc
 *@param	vram	ݒu^Cv(NNS_G2D_VRAM_TYPE_2DMAIN,NNS_G2D_VRAM_TYPE_2DSUB,NNS_G2D_VRAM_TYPE_2DMAX)
 *@param	pltt	ݒpbgio[
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setDataHeader(CLACT_U_RES_HEADER_SUB* head, char* path, char* id, char* vram, char* pltt)
{
	strcpy(head->file_path, path);
	head->id = atoi(id);
	if(vram != NULL){
		head->ex[0] = atoi(vram);
	}else{
		head->ex[0] = 0;
	}
	if(pltt != NULL){
		head->ex[1] = atoi(pltt);
	}else{
		head->ex[1] = 0;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	A[JCut@Cpwb_[ǂݍ݊֐
 *
 *@param	buff		wb_[f[^
 *@param	srcFile		A[JCut@CIDi[
 *@param	dataIdx		f[^CfbNXi[
 *@param	compFlag	ktOi[
 *@param	id			ǗIDi[
 *@param	vram		Vram^Cvi[
 *@param	pltt		pbggpʊi[
 *@param	type		\[X^Cv
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id, char** vram, char** pltt, int type)
{
	switch(type){
	case CLACT_U_CHAR_RES:
		loadCharHeaderCoreArc(buff, srcFile, dataIdx, compFlag, id, vram);
		*pltt = NULL;
		break;
	case CLACT_U_PLTT_RES:
		loadPlttHeaderCoreArc(buff, srcFile, dataIdx, compFlag, id, vram, pltt);
		break;
	case CLACT_U_CELL_RES:
	case CLACT_U_CELLANM_RES:
	case CLACT_U_MULTI_RES:
	case CLACT_U_MULTIANM_RES:
		loadKindCellHeaderCoreArc(buff, srcFile, dataIdx, compFlag, id);
		*vram = NULL;
		*pltt = NULL;
		break;
	default:
		GF_ASSERT_MSG(0, "sȃtH[}bgł\n");
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^ǂݍ
 *
 *@param	buff		wb_[f[^
 *@param	srcFile		A[JCut@CID
 *@param	dataIdx		f[^CfbNX
 *@param	compFlag	ktO
 *@param	id			ǗID
 *@param	type		Vram^Cv
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadCharHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id, char** type)
{
	*srcFile	= strtok(buff, ",");
	*dataIdx	= strtok(NULL, ",");
	*compFlag	= strtok(NULL, ",");
	*id			= strtok(NULL, ",");
	*type		= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	A[JCuppbgwb_[f[^ǂݍ
 *
 *@param	buff		wb_[f[^
 *@param	srcFile		A[JCut@CID
 *@param	dataIdx		f[^CfbNX
 *@param	compFlag	ktO
 *@param	id			ǗID
 *@param	type		Vram^Cv
 *@param	pltt_num	pbggp
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadPlttHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id, char** type, char** pltt_num)
{
	*srcFile	= strtok(buff, ",");
	*dataIdx	= strtok(NULL, ",");
	*compFlag	= strtok(NULL, ",");
	*id			= strtok(NULL, ",");
	*type		= strtok(NULL, ",");
	*pltt_num	= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAZAjA}`ZA}`ZAj
			A[JCut@Cpǂݍ
 *
 *@param	buff		wb_[f[^
 *@param	srcFile		A[JCut@CID
 *@param	dataIdx		f[^CfbNX
 *@param	compFlag	ktO
 *@param	id			ǗID
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadKindCellHeaderCoreArc(char* buff, char** srcFile, char** dataIdx, char** compFlag, char** id)
{
	*srcFile	= strtok(buff, ",");
	*dataIdx	= strtok(NULL, ",");
	*compFlag	= strtok(NULL, ",");
	*id			= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_Ƀf[^i[
 *
 *@param	head		i[wb_
 *@param	srcFile		A[JCut@CID
 *@param	dataIdx		f[^CfbNX
 *@param	compFlag	ktO
 *@param	id			ǗID
 *@param	type		Vram^Cv
 *@param	pltt_num	pbggp
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setDataHeaderArc(CLACT_U_RES_HEADER_SUBARC* head, char* arcFile, char* dataIdx, char* compFlag, char* id, char* type, char* pltt_num)
{
	head->arcFile	= atoi(arcFile);
	head->dataIdx	= atoi(dataIdx);
	head->compFlag	= atoi(compFlag);
	head->id		= atoi(id);
	if(type){
		head->ex[0]		= atoi(type);
	}else{
		head->ex[0]		= 0;
	}
	if(pltt_num){
		head->ex[1]		= atoi(pltt_num);
	}else{
		head->ex[1]		= 0;
	}
}

//------------------------------------------------------------------
/**
 * A[JCuf[^̓ǂݏoimۂj
 *
 * @param	p_handle		A[JCunh
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   compressedFlag	kĂ邩H
 * @param	heapID			gpq[v
 * @param	alloc_type		AbN^Cv
 *
 * @retval  void*			ǂݏö|C^
 */
//------------------------------------------------------------------
static void* ArcHandle_Load(ARCHANDLE* p_handle, u32 dataIdx, BOOL compressedFlag, u32 heapID, u32 alloc_type)
{
	void* arcData;
	
	arcData = ArchiveDataLoadAllocByHandle( p_handle, dataIdx, heapID );

	if( arcData != NULL )
	{
		if( compressedFlag )
		{
			void* data;

			if( alloc_type == ALLOC_TOP ){
				data = sys_AllocMemory( heapID, MI_GetUncompressedSize( arcData ) );
			}else{
				data = sys_AllocMemoryLo( heapID, MI_GetUncompressedSize( arcData ) );
			}

			if( data )
			{
				MI_UncompressLZ8( arcData, data );
				sys_FreeMemoryEz( arcData );
			}
			arcData = data;
		}
	}

	return arcData;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	obt@̃Rs[쐬
 *
 *@param	buff	Rs[obt@
 *@param	heap	gpq[v
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
char* makeCopyStr(const char* buff, int heap)
{
	int size;
	char* copy;

	size = strlen(buff);
	size++;

	copy = sys_AllocMemoryLo(heap, size);
	strcpy(copy, buff);

	return copy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Rs[j
 *
 *@param	copy	Rs[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void delCopyStr(char* copy)
{
	sys_FreeMemoryEz(copy);
}
