//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		clact_util_vram.c
 *@brief	ZAN^[[eBeB\[X}l[W[gpLN^f[^Apbgf[^Vramɓ]VXe
 *@author	tomoya takahashi
 *@data		2005.09.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "assert.h"

#include "char_manager.h"
#include "pltt_manager.h"

#define __CLACT_UTIL_VRAM_H_GLOBAL
#include "include/system/clact_util_vram.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------


//////////////////////////////////////////////////////////////////////////////
// LN^f[^]֐
// ItZbg^Cv
// ォ珇ɋl߂Vramɓ]Ă܂B
// ȂǂĂ̈FāA
// ̗̈ɍēxႤLN^]Ȃǂł܂B
//////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒ
 *
 *@param	resObj	\[XIuWF
 *
 *@retval	TRUE	
 *@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_CharManagerSet( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	CHAR_MANAGER_HEADER char_data;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);
	
	// LN^f[^擾
	char_data.res_file = CLACT_U_ResManagerGetResObjResChar(resObj);

	char_data.type = CLACT_U_ResManagerGetResObjVramType(resObj);
	char_data.id	= CLACT_U_ResManagerGetResObjID(resObj);
	char_data.cont_type = CHARM_CONT_OFFSET;

	// o^
	return CharSet(&char_data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒij
 *
 *@param	resTbl		\[XIuWFe[ũ|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerSets( const CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;		// [vp
	BOOL check;
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){

		if( resTbl->tbl[i] ){
			check = CLACT_U_CharManagerSet(resTbl->tbl[i]);
			GF_ASSERT_MSG( check, "LN^f[^o^s\n" );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒ
 *				}bsO[h̏ԂɕύX郂[h
 *
 *@param	resObj	\[XIuWF
 *
 *@retval	TRUE	
 *@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_CharManagerSetCharModeAdjust( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	CHAR_MANAGER_HEADER char_data;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);
	
	// LN^f[^擾
	char_data.res_file = CLACT_U_ResManagerGetResObjResChar(resObj);

	char_data.type = CLACT_U_ResManagerGetResObjVramType(resObj);
	char_data.id	= CLACT_U_ResManagerGetResObjID(resObj);
	char_data.cont_type = CHARM_CONT_OFFSET;

	// o^
	return CharSetCharModeAdjust(&char_data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒij
 *				}bsO[h̏ԂɕύX郂[h
 *
 *@param	resTbl		\[XIuWFz̃|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerSetsCharModeAdjust( const CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;		// [vp
	BOOL check;	// p
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){
		if( resTbl->tbl[ i ] ){
			check = CLACT_U_CharManagerSetCharModeAdjust(resTbl->tbl[i]);
			GF_ASSERT_MSG( check, "LN^f[^o^s\n" );
		}
	}
}



//////////////////////////////////////////////////////////////////////////////
// LN^f[^]֐
// GARg[^Cv
// vramGAPLƂɊǗz쐬āA
// 󂫗̈悩gpłvramGA܂B
//////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒ
 *
 *@param	resObj	\[XIuWF
 *
 *@retval	TRUE	
 *@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_CharManagerSetAreaCont( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	CHAR_MANAGER_HEADER char_data;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);
	
	// LN^f[^擾
	char_data.res_file = CLACT_U_ResManagerGetResObjResChar(resObj);

	char_data.type = CLACT_U_ResManagerGetResObjVramType(resObj);
	char_data.id	= CLACT_U_ResManagerGetResObjID(resObj);
	char_data.cont_type = CHARM_CONT_AREACONT;

	// o^
	return CharSet(&char_data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒij
 *
 *@param	resTbl		\[XIuWFe[ũ|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerSetsAreaCont( const CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;		// [vp
	BOOL check;	// p
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){

		if( resTbl->tbl[i] ){
			check = CLACT_U_CharManagerSetAreaCont(resTbl->tbl[i]);
			GF_ASSERT_MSG( check, "LN^f[^o^s" );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒ
 *				}bsO[h̏ԂɕύX郂[h
 *
 *@param	resObj	\[XIuWF
 *
 *@retval	TRUE	
 *@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_CharManagerSetCharModeAdjustAreaCont( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	CHAR_MANAGER_HEADER char_data;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);
	
	// LN^f[^擾
	char_data.res_file = CLACT_U_ResManagerGetResObjResChar(resObj);

	char_data.type = CLACT_U_ResManagerGetResObjVramType(resObj);
	char_data.id	= CLACT_U_ResManagerGetResObjID(resObj);
	char_data.cont_type = CHARM_CONT_AREACONT;

	// o^
	return CharSetCharModeAdjust(&char_data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[Ƀ\[XIuWFȂ̃LN^f[^ݒij
 *				}bsO[h̏ԂɕύX郂[h
 *
 *@param	resTbl		\[XIuWFz̃|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerSetsCharModeAdjustAreaCont( const CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;		// [vp
	BOOL check;	// p
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){
		if( resTbl->tbl[ i ] ){
			check = CLACT_U_CharManagerSetCharModeAdjustAreaCont(resTbl->tbl[i]);
			GF_ASSERT_MSG( check, "LN^f[^o^s\n" );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^ύX
 *
 *	@param	nowTbl		̃LN^f[^
 *	@param	newTbl		ύXLN^f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerChg( CONST_CLACT_U_RES_OBJ_PTR nowTbl, CONST_CLACT_U_RES_OBJ_PTR newTbl )
{
	int id;
	NNSG2dCharacterData* data;
	
	GF_ASSERT(nowTbl);
	GF_ASSERT(newTbl);

	// vNVƃLN^f[^擾
	id = CLACT_U_ResManagerGetResObjID( nowTbl );
	data = CLACT_U_ResManagerGetResObjResChar( newTbl );

	// ւ
	CharDataChg(id, data);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^̍ē]s
 *
 *	@param	resObj	\[XIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerReTrans( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	int id;
	NNSG2dCharacterData* data;

	GF_ASSERT(resObj);

	// vNVƃLN^f[^擾
	id = CLACT_U_ResManagerGetResObjID( resObj );
	data = CLACT_U_ResManagerGetResObjResChar( resObj );
	
	CharDataChg(id, data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[烊\[XIuWFID̃LN^f[^j
 *
 *@param	resObj		\[XIuWF̃|C^
 *
 *@return none
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerDelete( CLACT_U_RES_OBJ_PTR resObj )
{
	int id;
	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);
	
	id = CLACT_U_ResManagerGetResObjID(resObj);
	DelChar(id);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^}lW[烊\[XIuWFe[uɑΉf[^j
 *
 *@param	resTbl		\[XIuWFe[u
 *
 *@return none
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerDeletes( CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;		// [vp
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){
		if( resTbl->tbl[ i ] ){
			CLACT_U_CharManagerDelete(resTbl->tbl[i]);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C[WvNV擾
 *
 *@param	resObj	\[XIuWF
 *
 *@return	NNSG2dImageProxy*	C[WvNV
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImageProxy* CLACT_U_CharManagerGetProxy( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	int id;
	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);

	id = CLACT_U_ResManagerGetResObjID(resObj);
	return GetCharIDProxy( id );	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	QD}bvLN^ǂݍ
 *
 *	@param	resObj		\[XIuWF
 *	@param	proxy		]f[^i[vNV
 *	@param	base_addr	Vramx[XAhX
 * 
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_2DmapCharLoad( CONST_CLACT_U_RES_OBJ_PTR resObj, NNSG2dImageProxy* proxy, int base_addr )
{
	NNSG2dCharacterData* char_data;
	int	vram_type;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_CHAR_RES);
	
	// LN^f[^擾
	char_data = CLACT_U_ResManagerGetResObjResChar(resObj);
	vram_type = CLACT_U_ResManagerGetResObjVramType(resObj);

	
	// ǂݍ
	NNS_G2dLoadImage2DMapping( 
			char_data,
			base_addr,
			vram_type,
			proxy );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Vram]p̃C[WvNV擾
 *
 *@param	charObj	LN^\[XIuWF
 *@param	cellObj	Z\[XIuWF
 *
 *@return	NNSG2dImageProxy*	C[WvNV
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImageProxy* CLACT_U_CharManagerGetVramTransferProxy( CONST_CLACT_U_RES_OBJ_PTR charObj, CONST_CLACT_U_RES_OBJ_PTR cellObj )
{
	int id;
	NNSG2dCellDataBank* cellData;
	NNSG2dImageProxy* proxy;
	
	GF_ASSERT(charObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(charObj) == CLACT_U_CHAR_RES);
	GF_ASSERT(cellObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(cellObj) == CLACT_U_CELL_RES);
	
	
	// LN^f[^ID擾
	id = CLACT_U_ResManagerGetResObjID(charObj);

	// Zf[^擾
	cellData = CLACT_U_ResManagerGetResObjResCell(cellObj);
	
	proxy = GetCharVramTransData( id, cellData->pVramTransferData->szByteMax );	
	if(proxy == NULL){
		NNSG2dImageProxy* org;
		org = GetCharIDProxy( id );
		// Rs[쐬
		proxy = GetCharVramTransProxyCopy( org );
	}

	return proxy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZVram]AjVram̈J
 *
 *@param	pImage		Vram]pɍ쐬ꂽC[WvNV
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CharManagerDeleteVramTransferProxy( const NNSG2dImageProxy* pImage )
{
	GF_ASSERT(pImage);
	
	DelVramTransData( pImage );	
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}l[W[Ƀ\[XIuWF̃pbgf[^ݒ
 *
 *@param	resObj	\[XIuWF
 *
 *@retval	TRUE	
 *@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_PlttManagerSet( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	PLTT_MANAGER_HEADER pltt_data;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_PLTT_RES);
	
	// \[X擾
	pltt_data.res_file = CLACT_U_ResManagerGetResObjResPltt(resObj);

	pltt_data.type		= CLACT_U_ResManagerGetResObjVramType(resObj);
	pltt_data.id		= CLACT_U_ResManagerGetResObjID(resObj);
	pltt_data.pltt_num	= CLACT_U_ResManagerGetResObjPlttNum(resObj);

	// o^
	return PlttSet(&pltt_data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}lW[Ƀ\[XIuWFȂ̃pbgf[^ݒij
	 *
 *@param	resTbl		\[XIuWFe[u|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_PlttManagerSets( const CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;
	BOOL check;
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){
		if( resTbl->tbl[ i ] ){
			check = CLACT_U_PlttManagerSet(resTbl->tbl[i]);
			GF_ASSERT_MSG( check ,"pbg]s\n" );
		}
	}
}

// 󂫗̈ē]܂
// A̓]֐gpĂ̌ɓ]
// ㏑܂B
//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}l[W[Ƀ\[XIuWF̃pbgf[^ݒ
 *
 *@param	resObj	\[XIuWF
 *
 *@retval	TRUE	
 *@retval	FALSE	s
 *
 * CLACT_U_RES_OBJ_PTR	\[XIuWF
 * CLACT_U_ResManagerResAddPltt֐Ȃǂ̖߂l
 * ǂݍ񂾃\[X̃f[^@ǗIDȂǂi[Ă܂B
 *
 */
//-----------------------------------------------------------------------------
BOOL CLACT_U_PlttManagerSetCleanArea( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	PLTT_MANAGER_HEADER pltt_data;

	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_PLTT_RES);
	
	// \[X擾
	pltt_data.res_file = CLACT_U_ResManagerGetResObjResPltt(resObj);

	pltt_data.type		= CLACT_U_ResManagerGetResObjVramType(resObj);
	pltt_data.id		= CLACT_U_ResManagerGetResObjID(resObj);
	pltt_data.pltt_num	= CLACT_U_ResManagerGetResObjPlttNum(resObj);

	// o^
	return PlttSetCleanArea(&pltt_data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}lW[Ƀ\[XIuWFȂ̃pbgf[^ݒij
 *
 *@param	resTbl		\[XIuWFe[u|C^
 *
 *@return	none
 *
 * CLACT_U_RES_OBJ_TBL@\[XIuWFe[u
	typedef struct {
		CLACT_U_RES_OBJ_PTR*	tbl;// |C^i[e[ũ|C^
		int		tbl_num;			// e[uvf
		int		tbl_now;			// ݊i[
	} CLACT_U_RES_OBJ_TBL;
	̍\̂̊֐ō쐬ł܂B
	GLOBAL CLACT_U_RES_OBJ_TBL* CLACT_U_ResManagerResObjTblMake(int inResObjNum, int heap);
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_PlttManagerSetsCleanArea( const CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;
	BOOL check;
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){
		if( resTbl->tbl[ i ] ){
			check = CLACT_U_PlttManagerSetCleanArea(resTbl->tbl[i]);
			GF_ASSERT_MSG( check, "pbg]s\n" );
		}
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^ύX
 *
 *	@param	nowObj		̃pbgf[^̃\[XIuWF
 *	@param	newObj		ύXpbg̃\[XIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_PlttManagerChg( CONST_CLACT_U_RES_OBJ_PTR nowObj, CONST_CLACT_U_RES_OBJ_PTR newObj )
{
	NNSG2dPaletteData* data;
	int id;
	int trans_num;
	
	GF_ASSERT(nowObj);
	GF_ASSERT(newObj);

	// vNVƃpbgf[^擾
	id = CLACT_U_ResManagerGetResObjID( nowObj );
	
	data = CLACT_U_ResManagerGetResObjResPltt( newObj );
	
	// ւ
	PlttDataChg(id, data );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^̍ē]s
 *
 *	@param	resObj	\[XIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_PlttManagerReTrans( CONST_CLACT_U_RES_OBJ_PTR resObj )
{
	NNSG2dPaletteData* data;
	int id;
	int trans_num;
	
	GF_ASSERT(resObj);

	// vNVƃpbgf[^擾
	id = CLACT_U_ResManagerGetResObjID( resObj );
	
	data = CLACT_U_ResManagerGetResObjResPltt( resObj );

	// ւ
	PlttDataChg(id, data );

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}lW[烊\[XIuWFID̃pbgf[^j
 *
 *@param	resObj		\[XIuWF̃|C^
 *
 *@return none
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_PlttManagerDelete( CLACT_U_RES_OBJ_PTR resObj )
{
	int id;
	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_PLTT_RES);
	
	id = CLACT_U_ResManagerGetResObjID(resObj);
	DelPltt(id);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}lW[烊\[XIuWFID̃pbgf[^j
 *
 *@param	resTbl		\[XIuWFe[ũ|C^
 *
 *@return none
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_PlttManagerDeletes( CLACT_U_RES_OBJ_TBL* resTbl )
{
	int i;		// [vp
	
	GF_ASSERT(resTbl);

	for(i=0;i<resTbl->tbl_num;i++){

		if( resTbl->tbl[ i ] ){
			CLACT_U_PlttManagerDelete(resTbl->tbl[i]);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgvNV擾
 *
 *@param	resObj	\[XIuWFp[^
 *@param	pImage	֘AC[WvNV
 *
 *@return	pbgvNV
 *
 *
 */
//-----------------------------------------------------------------------------
const NNSG2dImagePaletteProxy* CLACT_U_PlttManagerGetProxy( CONST_CLACT_U_RES_OBJ_PTR resObj, NNSG2dImageProxy* pImage )
{
	int id;
	GF_ASSERT(resObj);
	GF_ASSERT(CLACT_U_ResManagerGetResObjResType(resObj) == CLACT_U_PLTT_RES);

	id = CLACT_U_ResManagerGetResObjID(resObj);

	if( pImage ){
		return GetPlttIDProxyJoin(id, pImage);
	}

	return GetPlttIDProxy( id );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	o^ĂpbgԂ̃pbgɓ]Ă邩Ԃ
 *
 *	@param	resObj		\[XIuWF
 *	@param	vram		vram^Cv
 *
 *	@retval	CLACT_U_PLTT_NO_NONEȊO	]ꂽpbgԍ
 *	@retval	CLACT_U_PLTT_NO_NONE		pbg]ĂȂ
 *
 * vram^Cv
 *	NNS_G2D_VRAM_TYPE_2DMAIN    QcOtBbNXGW`p
 *  NNS_G2D_VRAM_TYPE_2DSUB     QcOtBbNXGWap
 *
 * resObj
 *	GLOBAL CLACT_U_RES_OBJ_PTR CLACT_U_ResManagerGetIDResObjPtr(CONST_CLACT_U_RES_MANAGER_PTR resm, int id);
 *	֐Ŏ擾ĂB
 *
 *
 */
//-----------------------------------------------------------------------------
u32 CLACT_U_PlttManagerGetPlttNo( CONST_CLACT_U_RES_OBJ_PTR resObj, NNS_G2D_VRAM_TYPE type )
{
	int no;
	const NNSG2dImagePaletteProxy* imgpltt;

	imgpltt = CLACT_U_PlttManagerGetProxy( resObj, NULL );
	no =  NNS_G2dGetImagePaletteLocation( imgpltt, type );

	// addr->noɂ
	if( no != CLACT_U_PLTT_NO_NONE ){
		no /= 32;
	}

	return no;
}
