//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		laster.c
 *	@brief		X^[VXe
 *	@author		tomoya takahashi
 *	@data		2005.12.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <string.h>
#include "system.h"
#include "assert.h"
#include "system/tcbman.h"

#define __LASTER_H_GLOBAL
#include "system/laster.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	X^[VXe\
//	
//=====================================
typedef struct _LASTER_SYS{
	// X^[f[^obt@
	void* laster_buff[2];

	// X^[f[^̏ݗpobt@wtO
	u8	write_buff;	// zvfw肵܂ (0 or 1)

	// obt@XCb`tO
	u8	switch_flag;	
/* 	LASTER_SWITCH_ON,	// obt@XCb`L
 	LASTER_SWITCH_OFF	// obt@XCb`*/
	u8 dummy[2];

} LASTER_SYS;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[VXe
 *
 *	@param	heap	gpq[v
 *	@param	p_buff1	obt@P
 *	@param	p_buff2	obt@Q
 *
 *	@return	쐬X^[VXe
 *
 */
//-----------------------------------------------------------------------------
LASTER_SYS_PTR LASTER_Init( int heap, void* p_buff1, void* p_buff2 )
{
	LASTER_SYS_PTR p_laster;

	p_laster = sys_AllocMemory( heap, sizeof(LASTER_SYS) );
	memset( p_laster, 0, sizeof(LASTER_SYS) );

	// XCb`ON
	p_laster->switch_flag = LASTER_SWITCH_ON;

	// XCb`obt@i[
	p_laster->laster_buff[ 0 ] = p_buff1;
	p_laster->laster_buff[ 1 ] = p_buff2;

	return p_laster;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[VXej
 *
 *	@param	lster	j郉X^[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_Delete( LASTER_SYS_PTR p_laster )
{
	GF_ASSERT( p_laster );

	sys_FreeMemoryEz( p_laster );
	p_laster = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ݗpX^[obt@擾
 *
 *	@param	cp_laster	X^[XXe
 *
 *	@return	ݗpX^[obt@
 *
 *
 */
//-----------------------------------------------------------------------------
void* LASTER_GetWriteBuff( CONST_LASTER_SYS_PTR cp_laster )
{
	GF_ASSERT( cp_laster );
	
	return cp_laster->laster_buff[ cp_laster->write_buff ];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	QƗpX^[obt@擾
 *
 *	@param	cp_laster	X^[VXe
 *
 *	@return	QƗpX^[obt@
 *
 *
 */
//-----------------------------------------------------------------------------
const void* LASTER_GetReadBuff( CONST_LASTER_SYS_PTR cp_laster )
{
	GF_ASSERT( cp_laster );
	
	return cp_laster->laster_buff[ cp_laster->write_buff ^ 1 ];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	obt@XCb`tOݒ肵܂B
 *
 *	@param	p_laster	X^[VXe
 *	@param	switch_flag	XCb`tO
 *
 *	@return	none
 *
 * switch_flag	
 *	LASTER_SWITCH_ON,	// obt@XCb`L
 *	LASTER_SWITCH_OFF	// obt@XCb`
 *
 *	LASTERE_Init֐Ă񂾏ԂŃobt@XCb`͗LɂȂĂ܂B
 * 
 */
//-----------------------------------------------------------------------------
void LASTER_SwitchFlagSet( LASTER_SYS_PTR p_laster, u8 switch_flag )
{
	GF_ASSERT( p_laster );
	
	p_laster->switch_flag = switch_flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[@VuN֐
 *
 *	@param	p_laster	X^[VXe
 *
 *	@return	none
 *
 * obt@XCb`tOL̂Ƃ
 *		ݗpobt@QƗp
 *		QƗpobt@ݗpɁ@ύX܂B
 *
 *		ύX@V݂悤ɂȂobt@Oŏ܂B
 *
 */
//-----------------------------------------------------------------------------
void LASTER_VBlank( LASTER_SYS_PTR p_laster )
{
	if( p_laster == NULL ){
		return ;
	}
	
	// obt@XCb`L`FbN
	if( p_laster->switch_flag == LASTER_SWITCH_OFF ){
		return ;
	}

	// X^[obt@XCb`
	p_laster->write_buff ^= 1;
}



//-----------------------------------------------------------------------------
/**
 *
 *		X^[HuNDMA]֐
 * 
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[ŎgpDMA~
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_DmaStop( void )
{
	MI_StopDma( LASTER_USE_DMA );
	MI_WaitDma( LASTER_USE_DMA );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuNDMA]p[^ݒ
 *
 *	@param	p_src		]
 *	@param	p_dest		]
 *	@param	szbyte		]TCY	iP̓]œ]TCYj
 *	@param	dma_type
 *
 *	@return	none
 *
 *	LASTER_DMA_TYPE16,	16bitP
 *	LASTER_DMA_TYPE32	32bitP
 *
 */
//-----------------------------------------------------------------------------
void LASTER_DmaSet( const void* p_src, void* p_dest, int szbyte, int dma_type )
{
	
	// ]^Cv`FbN
	if( dma_type == LASTER_DMA_TYPE32 ){
		MI_HBlankDmaCopy32( LASTER_USE_DMA, p_src, p_dest, szbyte );
	}else{
		MI_HBlankDmaCopy16( LASTER_USE_DMA, p_src, p_dest, szbyte );
	}
}


//-----------------------------------------------------------------------------
/**
 *		X^[XN[
 *			DMA]gp
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	X^[XN[[N
//	
//=====================================
typedef struct _LASTER_SCROLL{
	// X^[obt@
	u32	buff1[ LASTER_SCROLL_BUFF_SIZE ];
	u32 buff2[ LASTER_SCROLL_BUFF_SIZE ];

	LASTER_SYS_PTR p_laster;	// X^[VXe
	TCB_PTR	p_tcb;				// tcb[N
	BOOL	end_flag;			// ItO


	// TCJ[ue[u
	s16 sinTbl[ LASTER_SCROLL_BUFF_SIZE ];

	u8 start;	// XN[fJnYW
	u8 end;		// XN[fIYW
	
	u32	addr;		// DMA]
	u32	init_num;	// [Nl
	
	s16 scr_now;	// X[݈ʒu
	s16 scr_sp;	// XN[Xs[h	*100 ꂽ

} LASTER_SCROLL;

// DMA]RAPPER
static void LASTER_ScrollDmaStop( void );
static void LASTER_ScrollDmaSet( CONST_LASTER_SCROLL_PTR cp_lstscr );


// X^[p
static void LASTER_ScrollTcb( TCB_PTR tcb, void* work );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[IuWF
 *
 *	@param	heap	q[v
 *
 *	@return	쐬X^[XN[IuWF
 *
 *
 */
//-----------------------------------------------------------------------------
LASTER_SCROLL_PTR LASTER_ScrollInit( int heap )
{
	LASTER_SCROLL_PTR p_lstscr;

	// IuWFNg
	p_lstscr = sys_AllocMemory( heap, sizeof(LASTER_SCROLL) );
	memset( p_lstscr, 0, sizeof(LASTER_SCROLL) );
	
	// X^[VXe
	p_lstscr->p_laster = LASTER_Init( heap, p_lstscr->buff1, p_lstscr->buff2 );

	return p_lstscr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[Jn
 *
 *	@param	start		X^[XN[JnW
 *	@param	end			X^[XN[IW
 *	@param	add_r		sinJ[ue[u쐬̊px𑫂Ăl(0`65535)
 *	@param	r_w			sinJ[u̔a
 *	@param	scr_sp		X^[XN[Xs[h	*100l	}CiXL
 *	@param	bg_no		X^[BG̔ԍ
 *	@param	init_num	[Nl
 *	@param	tsk_pri		^XND揇
 *
 *	@return	none
 *
 * bg_no
 * 		LASTER_SCROLL_MBG0,
 *		LASTER_SCROLL_MBG1,
 *		LASTER_SCROLL_MBG2,
 *		LASTER_SCROLL_MBG3,
 *		LASTER_SCROLL_SBG0,
 *		LASTER_SCROLL_SBG1,
 *		LASTER_SCROLL_SBG2,
 *		LASTER_SCROLL_SBG3
 *
 */
//-----------------------------------------------------------------------------
void LASTER_ScrollStart( LASTER_SCROLL_PTR p_lstscr, u8 start, u8 end, u16 add_r, fx32 r_w, s16 scr_sp, u32 bg_no, u32 init_num, u32 tsk_pri )
{
	GF_ASSERT( p_lstscr );
	GF_ASSERT_MSG( p_lstscr->p_tcb == NULL, "tcbo^ς݂ł." );

	// p[^ݒ
	p_lstscr->start		= start;
	p_lstscr->end		= end;
	p_lstscr->scr_now	= 0;
	p_lstscr->scr_sp	= scr_sp;
	p_lstscr->addr		= bg_no;
	p_lstscr->init_num	= init_num;

	// sinJ[u쐬
	LASTER_ScrollMakeSinTbl( p_lstscr->sinTbl, LASTER_SCROLL_BUFF_SIZE, add_r, r_w );

	// tcbo^
	p_lstscr->p_tcb = TCB_Add( LASTER_ScrollTcb, p_lstscr, tsk_pri );	

	// [N
	MI_CpuFill32( p_lstscr->buff1, p_lstscr->init_num, sizeof(u32) * LASTER_SCROLL_BUFF_SIZE );
	MI_CpuFill32( p_lstscr->buff2, p_lstscr->init_num, sizeof(u32) * LASTER_SCROLL_BUFF_SIZE );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[I
 *
 *	@param	p_lstscr	I郉X^[XN[[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_ScrollEnd( LASTER_SCROLL_PTR p_lstscr )
{
	void* buff;
	
	GF_ASSERT( p_lstscr );
	
	if( p_lstscr->p_tcb ){
		// TCB̔j
		TCB_Delete( p_lstscr->p_tcb );
		p_lstscr->p_tcb = NULL;

		// ɊJnƂ̂߂
		// ݗpobt@̏
		buff = LASTER_GetWriteBuff( p_lstscr->p_laster );
		memset( buff, p_lstscr->init_num, sizeof(u32) * LASTER_SCROLL_BUFF_SIZE );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[j
 *
 *	@param	p_lstscr	X^[XN[[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_ScrollDelete( LASTER_SCROLL_PTR p_lstscr )
{
	// ^XNI
	LASTER_ScrollEnd( p_lstscr );

	// DMAI
	LASTER_ScrollDmaStop();
	
	// X^[VXej
	LASTER_Delete( p_lstscr->p_laster );

	// Sf[^j
	sys_FreeMemoryEz( p_lstscr );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	obt@擾
 *
 *	@param	p_lstscr	X^[XN[[N
 *
 *	@return	obt@|C^
 *
 *
 */
//-----------------------------------------------------------------------------
void* LASTER_GetScrollWriteBuff( LASTER_SCROLL_PTR p_lstscr )
{
	return LASTER_GetWriteBuff( p_lstscr->p_laster );
}
const void* LASTER_GetScrollReadBuff( LASTER_SCROLL_PTR p_lstscr )
{
	return LASTER_GetReadBuff( p_lstscr->p_laster );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[VuN֐
 *
 *	@param	p_lstscr	X^[XN[[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
//	obt@XCb`
void LASTER_ScrollVBuffSwitch( LASTER_SCROLL_PTR p_lstscr )
{
	void* buff;
	
	if( p_lstscr == NULL ){
		return ;
	}
	
	// ^XNĂƂ
	// _uobt@O̎s
	if( p_lstscr->p_tcb ){
		// X^[VXeVBlank֐s
		LASTER_VBlank( p_lstscr->p_laster );

		// [N
		buff = LASTER_GetWriteBuff( p_lstscr->p_laster );
		MI_CpuFill32( buff, p_lstscr->init_num, sizeof(u32) * LASTER_SCROLL_BUFF_SIZE );
	}
}

// DMAݒ
void LASTER_ScrollVDma( LASTER_SCROLL_PTR p_lstscr )
{
	if( p_lstscr == NULL ){
		return ;
	}
	
	// ^XNĂƂ
	// HuNDMA̐ݒ
	if( p_lstscr->p_tcb ){

		// DMA~
		LASTER_ScrollDmaStop();
		// DMA]ݒ
		LASTER_ScrollDmaSet( p_lstscr );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[TCe[u쐬
 *
 *	@param	sinTbl	TCe[u
 *	@param	num		zvf	u16 buff[ 10 ]; Ȃ10w
 *	@param	add_r	]p̑l
 *	@param	r_w		a
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_ScrollMakeSinTbl( s16* sinTbl, u32 num, u16 add_r, fx32 r_w )
{
	int i;	// [vp
	u16 rota;

	// obt@TCYadd_ri߂sinJ[u
	// obt@Ɋi[
	rota = 0;
	for( i=0; i<num; i++ ){
		sinTbl[ i ] = FX_Mul( FX_SinIdx( rota ), r_w) >> FX32_SHIFT;
		rota += add_r;	// 0`65535[v
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	XN[vZTCB
 *
 *	@param	tcb		tcb[N
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void LASTER_ScrollTcb( TCB_PTR tcb, void* work )
{
	LASTER_SCROLL_PTR p_lstscr = work;
	int i;			// [vp
	u32* w_buff;	// ݗpobt@
	u8 write;		// ݗvf
	s16	mat_x;		// xW
	u16 mat_y;		// yW

	// ݗpobt@擾
	w_buff = LASTER_GetWriteBuff( p_lstscr->p_laster );
	
	// obt@Ƀf[^ݒ
	write = p_lstscr->scr_now / 100;
	for( i=p_lstscr->start; i<=p_lstscr->end; i++ ){
		// ̒l擾
		mat_x = w_buff[ i ] & 0xffff;
		mat_y = w_buff[ i ] >> 16;
		
		// TCJ[uf
		mat_x += p_lstscr->sinTbl[ write ];
		
		// lݒ
		w_buff[ i ] = (mat_y << 16) | (mat_x & 0xffff);
		
		write = (write + 1) % LASTER_SCROLL_BUFF_SIZE;
	}

	// XN[ʒuvZ
	p_lstscr->scr_now += p_lstscr->scr_sp;
	if( p_lstscr->scr_now >= (LASTER_SCROLL_BUFF_SIZE * 100) ){
		p_lstscr->scr_now %= (LASTER_SCROLL_BUFF_SIZE * 100);
	}else{
		if( p_lstscr->scr_now < 0 ){
			p_lstscr->scr_now += (LASTER_SCROLL_BUFF_SIZE * 100);
		}
	}
}

// DMA]RAPPER
//----------------------------------------------------------------------------
/**
 *
 *	@brief	DMA]I
 *
 *	@param	none
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_ScrollDmaStop( void )
{
	LASTER_DmaStop();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuNDMA]ݒ
 *
 *	@param	cp_lstscr	X^[XN[[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void LASTER_ScrollDmaSet( CONST_LASTER_SCROLL_PTR cp_lstscr )
{
	const void* buff;

	GF_ASSERT( cp_lstscr );
	
	// QƗpobt@擾
	buff = LASTER_GetReadBuff( cp_lstscr->p_laster );

	// tbVW
	DC_FlushRange( buff, sizeof(u32) * LASTER_SCROLL_BUFF_SIZE );
	
	// HBlankDMA]ɐݒ
	LASTER_DmaSet( buff, (void*)cp_lstscr->addr, sizeof(u32), LASTER_DMA_TYPE32 );
}
