//=============================================================================
/**
 * @file	main.c
 * @brief	|PcoC
 * @author	GAME FREAK Inc.
 */
//=============================================================================

#include "common.h"
#include "snd_system.h"
#include "communication/communication.h"
#include "communication/comm_state.h"

#include "system/main.h"

#include "gflib\apptimer.h"
#include "system\fontproc.h"
#include "system/brightness.h"
#include "system/pm_rtc.h"
#include "gflib/gf_gx.h"

#include "system/savedata.h"
#include "system/pm_overlay.h"

#include "demo/title.h"

#include "system/wipe.h"
#include "wifi/dwc_rap.h"
#include "system/playtime_ctrl.h"

#include "system/debug_flag.h"
#include "system/pm_debug_wifi.h"

#include "application/backup.h"
#include "system/gamestart.h"

#include "savedata/config.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/09/08
// version t@C PG5_MARUMIX = yes 錾ĂA
// Marumi-Xp̃wb_CN[h

#ifdef PG5_MARUMIX
#include "localize/SendRAMData.h"
#endif

// ----------------------------------------------------------------------------

static void Main_CallProc(void);
static void ResetUpdateVBlank(void);
static void ResetLoop(int resetNo);
static void ResetFunc(int resetNo);
static void ResetErrorFunc(int resetNo, int messageType);
static void ErrorCheckComm(void);
void sleepFunc(void);

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌ŗp̃wb_t@CE֐`

#ifdef PG5_TRIAL

#include "system/arc_util.h"
#include "system/msgdata.h"

#include "msgdata/msg.naix"
#include "demo/intro/intro.naix"
#include "msgdata/msg_dp_festa.h"

static void LocalVBlankIntr(void);
void ForceEndResetCall( int heapID );

#endif

// ----------------------------------------------------------------------------

//=============================================================================
//=============================================================================
//#define TEST_60_FRAME

//--- fobOp  `x𔭐


// -------------------------------------------------------------------------
#ifdef	PM_DEBUG



#ifdef DEBUG_ONLY_FOR_ohno

#define _DELAY_DEBUG
static void delayDebug(void);

#endif // DEBUG_ONLY_FOR_ohno



// WIFI@ΐAUTOӰރfobN
#ifdef _WIFI_DEBUG_TUUSHIN
static void wifiDebug(void);
WIFI_DEBUG_BATTLE_WK WIFI_DEBUG_BATTLE_Work;
#endif	// _WIFI_DEBUG_TUUSHIN


// A{^0.6bɂP񉟂
//#define PAD_DEBUG
#ifdef PAD_DEBUG
static void DebugPad();

#endif // PAD_DEBUG

#endif // PM_DEBUG


// -------------------------------------------------------------------------

//---------------------------------------------------------------------------
/**
 * @brief	Cp[N
 */
//---------------------------------------------------------------------------
typedef struct {
	FSOverlayID ov_id;				///<݂̃CvZX̃I[o[CID
	PROC * proc;					///<݂̃CvZX̃|C^
	FSOverlayID next_ov_id;			///<̃CvZX̃I[o[CID
	const PROC_DATA * next_data;	///<̃CvZXf[^ւ̃|C^
	MAINWORK work;					///<CvZXp[Nimain.hŒ`j
}SYSWORK;

static SYSWORK main;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// ÑobNCgݒLĂ悤
static PMBackLightSwitch backlightDefault;
// ----------------------------------------------------------------------------

#ifdef	PM_DEBUG
DEBUG_FLAG_DATA	DebugFlagData;		///<fobOf[^
#endif

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
int AGBCartridge_TriggerFlag;
#endif
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łŁAE^CAbvs߂̕ϐE萔E֐

#ifdef PG5_TRIAL

static BOOL trialPlayFlag;		// ̌vCiԂJEgjȂTRUE
static int noInputTime;			// p
static int trialPlayTime;		// ̌vČoߎ

enum {
	NO_INPUT_TIME_MAX		=  2*60*30,		// 삾ƃZbg鎞ԁi2j
	TRIAL_PLAY_TIME_MAX		= 10*60*30,		// ̌vCł؂鎞ԁi10j
};

void SetTrialPlayFlag(BOOL flag);

void SetTrialPlayFlag(BOOL flag) {
	trialPlayFlag = flag;
}

#endif

// ----------------------------------------------------------------------------

//=============================================================================
//
//				C
//
//=============================================================================
extern const PROC_DATA TitleProcData;
extern const PROC_DATA OpDemoProcData;
FS_EXTERN_OVERLAY( title );

//---------------------------------------------------------------------------
/**
 * @brief	C֐
 */
//---------------------------------------------------------------------------
void NitroMain(void)
{
	//===========================
	//		
	//===========================
	GF_AssertInit();

    sys_InitSystem();
    sys_InitVRAM();
    sys_InitKeyRead();
	sys_InitAgbCasetteVer(0);
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/24
	// ÑobNCgݒLĂ悤
	// localize_spec_mark(LANG_ALL) imatake 2007/02/09
	// ̌łłIPLݒ𖳎AobNCgON
#ifdef PG5_TRIAL
	backlightDefault = PM_BACKLIGHT_ON;
#else
	PM_GetBackLight(&backlightDefault,NULL);
#endif
	// ----------------------------------------------------------------------------

	GF_GX_Init();
	GF_RTC_Init();

	Main_Init();

	// tHgf[^̃[h
	FontProcInit();
	FontProc_LoadFont( FONT_SYSTEM, HEAPID_BASE_APP );
	FontProc_LoadFont( FONT_TALK, HEAPID_BASE_APP );
	FontProc_LoadFont( FONT_UNKNOWN, HEAPID_BASE_APP );

	main.work.select_id = -1;
	main.work.savedata = SaveData_System_Init();

	Snd_AllInit(SaveData_GetPerapVoice(main.work.savedata),SaveData_GetConfig(main.work.savedata) );

	APTM_Init();

    if( DWC_INIT_RESULT_DESTROY_OTHER_SETTING == mydwc_init(HEAPID_BASE_APP) ){ //dwc
        DWClibWarningCall(HEAPID_BASE_APP,0); //dwc̃G[\
    }

//obNAbvtbVȂƂ̏͐iłł̂ݗLɂ
#ifndef	PM_DEBUG
	if (SaveData_GetFlashExistsFlag(main.work.savedata) == FALSE) {
		//obNAbvtbV݂̑F߂ȂƂ
		//G[ʂɑJڂ
		//Main_SetNextProc(NO_OVERLAY_ID, &BackupErrorProcData);
		BackupErrorWarningCall( 0 );
	} else
#endif
	{
		switch (OS_GetResetParameter()) {
		case _SOFT_RESET_NORMAL:
			main.work.comm_error_flag = FALSE;
			Main_SetNextProc( FS_OVERLAY_ID(title), &OpDemoProcData);
			break;
		case _SOFT_RESET_NETERROR:
			main.work.comm_error_flag = TRUE;
			Main_SetNextProc( OVERLAY_ID_GAMESTART, &ContinueGameStartProcData);
			break;
		default:
			GF_ASSERT_MSG(0, "`ȃZbg`Ԃ܂I\n");
		};
	}

	sys.DS_Boot_Flag = TRUE;		//u[gtO

	sys.vsync_flame_counter = 0;
	Main_InitRandom();

	//PxύX\̏
	BrightnessChgInit();

	// vCԃJEg
	PlayTimeCtrl_Init();

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
	AGBCartridge_TriggerFlag = FALSE;
#endif
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł̏ǉ

#ifdef PG5_TRIAL
	trialPlayFlag = FALSE;
	noInputTime = 0;
	trialPlayTime = 0;

	// ̌ł͋NɃ_Ńo[W؂ւ
	if( gf_mtRand() & 1 ){
		CasetteVersion = VERSION_DIAMOND;
	} else {
		CasetteVersion = VERSION_PEARL;
	}

	sys_SleepNG(SLEEPTYPE_TRIAL);	// ̌ł̓X[vȂ
#endif

// ----------------------------------------------------------------------------

	//===========================
	//	C[v
	//===========================
	while (1) {
        ErrorCheckComm(); // ʐMG[

        sleepFunc();   // X[v@\

		sys_MainKeyRead();	//L[ǂݎ

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/09/08
// version t@C PG5_MARUMIX = yes 錾ĂA
// LR Marumi-X Ƀf[^]

#ifdef PG5_MARUMIX
		if (sys.trg_org & (PAD_BUTTON_L | PAD_BUTTON_R)) {
			if (sys.cont_org == (PAD_BUTTON_L | PAD_BUTTON_R)) {
				OS_TPrintf("Marumi-XɃf[^]\n");
				SendRAMDataToPC();
			}
		}
#endif

// -----------------------------------------------------------------------------

		GF_AssertMain();

// WIFI@ΐAUTOӰރfobN
#ifdef _WIFI_DEBUG_TUUSHIN
		wifiDebug();
#endif	// _WIFI_DEBUG_TUUSHIN

#ifdef PAD_DEBUG
		DebugPad();
#endif

        
		if ((sys.cont_org & (PAD_BUTTON_START|PAD_BUTTON_SELECT|PAD_BUTTON_L|PAD_BUTTON_R))
			==(PAD_BUTTON_START|PAD_BUTTON_SELECT|PAD_BUTTON_L|PAD_BUTTON_R)) {
            if(sys.DontSoftReset == 0){  // }BITOK
                ResetFunc(_SOFT_RESET_NORMAL);
            }
		}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł̖E^CAbvǉ

#ifdef PG5_TRIAL
		if (trialPlayFlag) {
			// 莞ԖȂ烊Zbg
			if (sys.cont_org || sys.tp_cont) noInputTime = 0;
			if (++noInputTime > NO_INPUT_TIME_MAX) {
				ResetFunc(0);
			}
			// 莞Ԍo߂ŋI
			if (++trialPlayTime > TRIAL_PLAY_TIME_MAX) {
				ForceEndResetCall(0);
			}
		}
#endif

// ----------------------------------------------------------------------------

        if(CommUpdateData()){  // f[^LʐM̒ʐM

			Main_CallProc();	//CvZXĂяo

			TCBSYS_Main( sys.mainTCBSys );
			TCBSYS_Main( sys.printTCBSys );
#ifndef TEST_60_FRAME
			if(!sys.vsync_flame_counter){
                OS_WaitIrq(TRUE, OS_IE_V_BLANK);	// uuN҂
                sys.vsync_counter++;	// uuNpJE^
            }
#endif
        }
		GF_RTC_Main();
		PlayTimeCtrl_Countup();

#ifdef _DELAY_DEBUG
        delayDebug();
#endif// _DELAY_DEBUG

		GF_G3_SwapBuffers();	// G3_SwapBuffersĂяo
#ifndef TEST_60_FRAME
		TCBSYS_Main( sys.printTCBSys );
#endif
        OS_WaitIrq(TRUE, OS_IE_V_BLANK); 	// uuN҂
		sys.vsync_counter++;	// uuNpJE^
		sys.vsync_flame_counter = 0;


		//===========================
		BrightnessChgMain();	//PxύXC
		WIPE_SYS_Main();		///<CvC
		if (sys.pVBlank != NULL) {
			sys.pVBlank(sys.pVBlankWork);
		}
		Snd_Main();

		TCBSYS_Main( sys.vwaitTCBSys );
    }
}


//=============================================================================
//
//
//		CvZX
//
//
//=============================================================================

//---------------------------------------------------------------------------
/**
 * @brief	CvZX
 */
//---------------------------------------------------------------------------
void Main_Init(void)
{
	main.ov_id = NO_OVERLAY_ID;
	main.proc = NULL;
	main.next_ov_id = NO_OVERLAY_ID;
	main.next_data = NULL;
}

//---------------------------------------------------------------------------
/**
 * @brief	CvZXs
 */
//---------------------------------------------------------------------------
static void Main_CallProc(void)
{
	BOOL result;

	if (main.proc == NULL) {
		if (main.next_data == NULL) {
			return;
		}
		if (main.next_ov_id != NO_OVERLAY_ID) {
			//Kvł΃I[o[C̃[hs
			Overlay_Load(main.next_ov_id, OVERLAY_LOAD_SYNCHRONIZE);
		}
		main.ov_id = main.next_ov_id;
		main.proc = PROC_Create(main.next_data, &main.work, HEAPID_BASE_SYSTEM);
		main.next_ov_id = NO_OVERLAY_ID;
		main.next_data = NULL;
	}

	result = ProcMain(main.proc);
	if (result) {
		PROC_Delete(main.proc);
		main.proc = NULL;
		if (main.ov_id != NO_OVERLAY_ID) {
			//Kvł΃I[o[C̃A[hs
			Overlay_UnloadID(main.ov_id);
		}
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	̃vZX̓o^
 * @param	ov_id		I[o[CID
 * @param	proc_data	PROC_DATAւ̃|C^
 */
//---------------------------------------------------------------------------
void Main_SetNextProc(FSOverlayID ov_id, const PROC_DATA * proc_data)
{
	GF_ASSERT(main.next_data == NULL);
	main.next_ov_id = ov_id;
	main.next_data = proc_data;
}

//---------------------------------------------------------------------------
/**
 * @brief	Zbg̑ҋ@Ԃ̎ɍŒKvȃ[v
 * @param	none
 */
//---------------------------------------------------------------------------

static void ResetUpdateVBlank(void)
{
    if(CommUpdateData()){  // f[^LʐM̒ʐM
    }
    OS_WaitIrq(TRUE, OS_IE_V_BLANK);
    sys.vsync_counter++;	// uuNpJE^
    sys.vsync_flame_counter = 0;
    if (sys.pVBlank != NULL) {
        sys.pVBlank(sys.pVBlankWork);
    }
}

//---------------------------------------------------------------------------
/**
 * @brief	Zbg̑ҋ@Ԃ̎ɍŒKvȃ[v Zbgۂɂ
 * @param	resetNo   OS_ResetSystemɓnZbg
 */
//---------------------------------------------------------------------------

static void ResetLoop(int resetNo)
{
    if(CommStateIsResetEnd()){ // ʐMI
        if(CARD_TryWaitBackupAsync()==TRUE){  //[J[hI
            OS_ResetSystem(resetNo);  // ؒfmFI
        }
    }
    ResetUpdateVBlank();
}

//---------------------------------------------------------------------------
/**
 * @brief	ʐMG[
 * @param	resetNo   OS_ResetSystemɓnZbg
 */
//---------------------------------------------------------------------------

static void ErrorCheckComm(void)
{
    int type = CommIsResetError();
    switch(type){
      case COMM_ERROR_RESET_SAVEPOINT:  // Zbg𔺂ʐMG[
        ResetErrorFunc(_SOFT_RESET_NETERROR,type);
        break;
      case COMM_ERROR_RESET_TITLE:  // ^Cg߂G[
        ResetErrorFunc(_SOFT_RESET_NORMAL,type);
        break;
      case COMM_ERROR_RESET_GTS:  // GTSL̃G[
        ResetErrorFunc(_SOFT_RESET_NETERROR,type);
        break;
    }
}

//---------------------------------------------------------------------------
/**
 * @brief	\tgEGAZbgNꍇ̏
 * @param	resetNo   OS_ResetSystemɓnZbg
 */
//---------------------------------------------------------------------------
static void ResetFunc(int resetNo)
{
	WIPE_SetBrightness( WIPE_DISP_MAIN,WIPE_FADE_WHITE );
	WIPE_SetBrightness( WIPE_DISP_SUB,WIPE_FADE_WHITE );
    if(CommStateExitReset()){  // ʐMZbgֈڍs
        SaveData_DivSave_Cancel(SaveData_GetPointer()); //Z[uĂLZĂȂƃZbgłȂ
    }
	while (1) {
        sleepFunc();   // X[v@\
        ResetLoop(resetNo);
    }
}

//---------------------------------------------------------------------------
/**
 * @brief	ʐMG[ɂ\tgEGAZbgNꍇ̏
 * @param	resetNo   OS_ResetSystemɓnZbg
 */
//---------------------------------------------------------------------------

static void ResetErrorFunc(int resetNo, int messageType)
{
    if(messageType==COMM_ERROR_RESET_GTS){
        ComErrorWarningResetCall(HEAPID_BASE_SYSTEM,COMM_ERRORTYPE_GTS,0);
    }
    else if(_SOFT_RESET_NORMAL == resetNo){
        ComErrorWarningResetCall(HEAPID_BASE_SYSTEM,COMM_ERRORTYPE_TITLE,0);
    }
    else{
        ComErrorWarningResetCall(HEAPID_BASE_SYSTEM,COMM_ERRORTYPE_ARESET,0);
    }
    CommStateExitReset();  // ʐMZbgֈڍs
    while(1){
        sleepFunc();   // X[v@\
		sys_MainKeyRead();	//L[ǂݎ
        if(sys.trg & PAD_BUTTON_DECIDE){
            break;
        }
        ResetUpdateVBlank();
    }
    ResetFunc(resetNo);  // Zbg
}

//=============================================================================
//=============================================================================
//---------------------------------------------------------------------------
/**
 * @brief	
 *
 * RTC̎ԂƃQ[JnVsyncJE^̒lŏsĂB
 * ꂼꂪgReLXgƂɃV[h⃏[NێĂꍇ́A
 * ꂼŏʓrs
 */
//---------------------------------------------------------------------------
void Main_InitRandom(void)
{
	RTCDate date;
	RTCTime time;
	u32 seed;
	GF_RTC_GetDateTime(&date, &time);
	seed = date.year + date.month * 0x100 * date.day * 0x10000
		+ time.hour * 0x10000 + (time.minute + time.second) * 0x1000000
		+ sys.vsync_counter;
	gf_mtSrand(seed);
	gf_srand(seed);
}



//---------------------------------------------------------------------------
/**
 * @brief	X[vԂ̊Ǘ
 * @param	none
 */
//---------------------------------------------------------------------------
void sleepFunc(void)
{
  PMBackLightSwitch up,down;
  PMWakeUpTrigger trigger;
    
  if(PAD_DetectFold()){ // ӂ܂Ă
    // ----------------------------------------------------------------------------
    // localize_spec_mark(LANG_ALL) imatake 2007/02/01
    // AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
    // localize_spec_mark(LANG_ALL) imatake 2007/02/07
    // Cpb`̕1ɓ
    // localize_spec_mark(LANG_ALL) imatake 2007/02/14
    // RTCJ[gbWɑΉ
    // iAFTERMASTER_070123_GBACARTRIDGE_BUF_FIX ^̏ꍇ̂݁j
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
    if(sys.DontSleep == 0){
      StopTP_Sleep();
      if(CTRDG_IsPulledOut() == TRUE)
	AGBCartridge_TriggerFlag = TRUE;
    SLEEPFUNCLOOP:
      trigger = PM_TRIGGER_COVER_OPEN|PM_TRIGGER_CARD;
      // AGBJ[gbWhĂꍇ̂ݕAɃJ[gbWݒ
      if(sys.AgbCasetteVersion && AGBCartridge_TriggerFlag == FALSE)
	trigger |= PM_TRIGGER_CARTRIDGE;
      //SLEEP
      PM_GoSleepMode( trigger, 0, 0 );
      // AAJ[hĂdOFF
      if(CARD_IsPulledOut()){
	PM_ForceToPowerOff();
      } else {
	// AAJ[gbWĂc
	if(PAD_DetectFold()){
	  // ܂ӂ܂ĂԂȂ΍ēxX[vɓɓdOFF
	  AGBCartridge_TriggerFlag = TRUE;
	  goto SLEEPFUNCLOOP;
	}
      }
      ReStartTP_Sleep();
    } else{
      //BK OFF
      PM_GetBackLight(&up,&down);
      if(PM_BACKLIGHT_ON == up){
	PM_SetBackLight(PM_LCD_ALL,PM_BACKLIGHT_OFF);
      }
    }
#else
    if(sys.DontSleep == 0){
      StopTP_Sleep();
      trigger = PM_TRIGGER_COVER_OPEN|PM_TRIGGER_CARD;
      // AGBJ[gbWhĂꍇ̂ݕAɃJ[gbWݒ
      if(sys.AgbCasetteVersion)
	trigger |= PM_TRIGGER_CARTRIDGE;
      //SLEEP
      PM_GoSleepMode( trigger, 0, 0 );
      // AAJ[hĂdOFF
      if(CARD_IsPulledOut()){
	PM_ForceToPowerOff();
      } else if((OS_GetIrqMask() & OS_IE_CARTRIDGE) && CTRDG_IsPulledOut()){
	// AAJ[gbWĂc
	if(PAD_DetectFold()){
	  // ܂ӂ܂ĂԂȂ΍ēxX[vɓɓdOFF
	  PM_GoSleepMode( PM_TRIGGER_COVER_OPEN|PM_TRIGGER_CARD, 0, 0 );
	  PM_ForceToPowerOff();
	} else {
	  // ӂJĂdOFF
	  PM_ForceToPowerOff();
	}
      }
      ReStartTP_Sleep();
    } else{
      // J[gbWꂽSLEEPdOFF
      if((OS_GetIrqMask() & OS_IE_CARTRIDGE) && CTRDG_IsPulledOut()){
	PM_GoSleepMode( PM_TRIGGER_COVER_OPEN|PM_TRIGGER_CARD, 0, 0 );
	PM_ForceToPowerOff();
      }
      //BK OFF
      PM_GetBackLight(&up,&down);
      if(PM_BACKLIGHT_ON == up){
	PM_SetBackLight(PM_LCD_ALL,PM_BACKLIGHT_OFF);
      }
    }
#endif
    // ----------------------------------------------------------------------------
  } else{  // JĂ
    PM_GetBackLight(&up,&down);
    if(PM_BACKLIGHT_OFF == up){
      // ----------------------------------------------------------------------------
      // localize_spec_mark(LANG_ALL) imatake 2007/01/24
      // ÑobNCgݒLĂ悤
      PM_SetBackLight(PM_LCD_ALL,backlightDefault);
      // ----------------------------------------------------------------------------
    }
  }
}


//---------------------------------------------------------------------------
/**
 * @brief	`x@fobO֐ 
 *  ̊֐g X[[VōĐ\Ȃ̂
 *  ǂȃt[œĂ邩킩܂
 */
//---------------------------------------------------------------------------
#ifdef	PM_DEBUG
static void delayDebug(void)
{
    static u8 trg = 0;
    static u8 speed = 5;
    int i;

    if(sys.cont & PAD_BUTTON_SELECT){
        if(sys.trg & PAD_BUTTON_Y){
            trg = 1 - trg;
            OS_TPrintf("DEBUG:`x %d\n", trg);
        }
    }
    if(trg){
        if(sys.trg & PAD_BUTTON_X){
            speed++;
            OS_TPrintf("speed %d\n",speed);
        }
        if(sys.trg & PAD_BUTTON_Y){
            speed--;
            OS_TPrintf("speed %d\n",speed);
        }
        for(i = 0; i < speed; i++){
            OS_WaitIrq(TRUE, OS_IE_V_BLANK);
        }
    }
}


// WIFI@ΐAUTOӰރfobN
#ifdef _WIFI_DEBUG_TUUSHIN
static void wifiDebug(void)
{
	if( sys.cont & PAD_BUTTON_L ){
		if( sys.trg & PAD_BUTTON_X ){
			sys.trg ^= PAD_BUTTON_X;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MODE = _WIFI_DEBUG_MODE_X;
			OS_TPrintf( "fobOWIFIӰށ@X\n" );
		}else if( sys.trg & PAD_BUTTON_Y ){

			sys.trg ^= PAD_BUTTON_Y;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MODE = _WIFI_DEBUG_MODE_Y;
			OS_TPrintf( "fobOWIFIӰށ@Y\n" );
		}
	}
	if( sys.trg & PAD_BUTTON_R ){
		OS_TPrintf( "fobOWIFIӰށ@OFF\n" );
		memset( &WIFI_DEBUG_BATTLE_Work, 0, sizeof(WIFI_DEBUG_BATTLE_WK) );
		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MODE = _WIFI_DEBUG_NONE;
	}

	if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MODE == _WIFI_DEBUG_NONE ){
		return ;
	}

	/* wifiXgʗp */
	if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_A_REQ == TRUE ){
		sys.trg |= PAD_BUTTON_A;
		sys.cont |= PAD_BUTTON_A;
	}
	if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_B_REQ == TRUE ){
		sys.trg |= PAD_BUTTON_B;
		sys.cont |= PAD_BUTTON_B;
	}
	if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_TOUCH_REQ == TRUE ){
		sys.tp_trg |= PAD_BUTTON_B;
		sys.tp_cont |= PAD_BUTTON_B;
		sys.tp_x	= 128;
		sys.tp_y	= 180;
	}

	/* tB[hp */
	switch( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_SEQ ){
	case 0:	// ҋ@
		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT = 0;
		break;

	case 1:
		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT ++;
		if( (WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT > 300) || (WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MODE == _WIFI_DEBUG_MODE_X) ){
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_SEQ ++;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT = 0;
		}
		break;

	case 2:	// E
		sys.trg |= PAD_KEY_RIGHT;
		sys.cont |= PAD_KEY_RIGHT;

		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT ++;
		if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT > 8 ){
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_SEQ ++;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT = 0;
		}
		break;

	case 3:
		sys.trg |= PAD_KEY_UP;
		sys.cont |= PAD_KEY_UP;

		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT ++;
		if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT > 16 ){
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_SEQ ++;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT = 0;
		}
		break;

	case 4:	// 
		sys.trg |= PAD_KEY_LEFT;
		sys.cont |= PAD_KEY_LEFT;

		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT ++;
		if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT > 16 ){
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_SEQ ++;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT = 0;
		}
		break;

	case 5:
		sys.trg |= PAD_KEY_UP;
		sys.cont |= PAD_KEY_UP;

		WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT ++;
		if( WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT > 16 ){
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_SEQ = 1;
			WIFI_DEBUG_BATTLE_Work.DEBUG_WIFI_MOVE_WAIT = 0;
		}
		break;
	}
}
#endif	// _WIFI_DEBUG_TUUSHIN

#endif // PM_DEBUG


#ifdef PAD_DEBUG

#include "../field/d_taya.h"

static int pad_wait=5;
static int pad_on=0;

static void DebugPad()
{
	if(pad_on){
		pad_wait--;
		if(pad_wait == 0){
			sys.trg |= PAD_BUTTON_X;
//			sys.trg |= PAD_BUTTON_A;
			pad_wait = gf_rand()%4+1;
		}
	}
	if((sys.cont & PAD_BUTTON_L) && (sys.trg & PAD_BUTTON_DEBUG)){
			pad_on^=1;
	}
}

#endif

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌ł̃^CAbvʂ̏ǉ

#ifdef PG5_TRIAL

//================================================================
//
//================================================================
static const GF_BGL_DISPVRAM vramSetTable = {
	GX_VRAM_BG_256_AB,				// C2DGWBG
	GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
	GX_VRAM_SUB_BG_NONE,			// Tu2DGWBG
	GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
	GX_VRAM_OBJ_NONE,				// C2DGWOBJ
	GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
	GX_VRAM_SUB_OBJ_NONE,			// Tu2DGWOBJ
	GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
	GX_VRAM_TEX_NONE,				// eNX`C[WXbg
	GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
};

static const GF_BGL_SYS_HEADER BGsys_data = {
	GX_DISPMODE_GRAPHICS,
	GX_BGMODE_0, GX_BGMODE_0,
	GX_BG0_AS_2D
};

static const GF_BGL_BGCNT_HEADER hd0 = {
	0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
	GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
};
static const GF_BGL_BGCNT_HEADER hd1 = {
	0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
	GX_BG_SCRBASE_0x0800, GX_BG_CHARBASE_0x18000, GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
};

//=================================================================================================
// pVIntr
//=================================================================================================
static void LocalVBlankIntr(void)
{
	OS_SetIrqCheckFlag(OS_IE_V_BLANK);

	MI_WaitDma(GX_DEFAULT_DMAID);
}


enum {
	RESET_BUTTON_WAIT_MIN =  1*60,	// {^ĂZbgȂԁi1bj
	RESET_BUTTON_WAIT_MAX = 60*60,	// ŃZbg鎞ԁi1j

	SCREEN_TILEWIDTH  = 32,
	SCREEN_TILEHEIGHT = 24,

	MSGWIN_TILEWIDTH  = 32,
	MSGWIN_TILEHEIGHT = 24,
};

//=================================================================================================
//
// ꊇR[
//
//=================================================================================================
void ForceEndResetCall( int heapID )
{
	GF_BGL_INI *bgl;
	GF_BGL_BMPWIN msgwin;
	
	int reset_button_wait = 0;

	Snd_PlayerPauseAll(TRUE);
	Snd_Main();

	WIPE_SetBrightness( WIPE_DISP_MAIN,WIPE_FADE_BLACK );
	WIPE_SetBrightness( WIPE_DISP_SUB,WIPE_FADE_BLACK );

    (void)OS_DisableIrqMask(OS_IE_V_BLANK);
	OS_SetIrqFunction(OS_IE_V_BLANK, LocalVBlankIntr);
    (void)OS_EnableIrqMask(OS_IE_V_BLANK);

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );		// HBlankZbg

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( GX_PLANEMASK_NONE );
	GXS_SetVisiblePlane( GX_PLANEMASK_NONE );
	sys_KeyRepeatSpeedSet( 4, 8 );
	sys.disp3DSW = DISP_3D_TO_MAIN;
	GF_Disp_DispSelect();
	G2_BlendNone();
	G2S_BlendNone();
	GX_SetVisibleWnd( GX_WNDMASK_NONE ); 
	GXS_SetVisibleWnd( GX_WNDMASK_NONE ); 

	GF_Disp_SetBank( &vramSetTable );		//uq`lݒ
	bgl = GF_BGL_BglIniAlloc( heapID );		//afCupm
	GF_BGL_InitBG( &BGsys_data );			// afVXeݒ

	GF_BGL_BGControlSet( bgl, GF_BGL_FRAME0_M, &hd0, GF_BGL_MODE_TEXT );

	GF_BGL_BmpWinAdd(bgl, &msgwin, GF_BGL_FRAME0_M, 0, 0, MSGWIN_TILEWIDTH, MSGWIN_TILEHEIGHT, 1, 0);
	GF_BGL_BmpWinFill(&msgwin, FBMP_COL_NULL, 0, 0, MSGWIN_TILEWIDTH*8, MSGWIN_TILEHEIGHT*8);

	{
		u32 xofs, yofs;
		STRBUF *msgstr = STRBUF_Create( 256, heapID );
		MSGDATA_MANAGER *msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_dp_festa_dat, heapID );

		MSGMAN_GetString( msgman, msg_festa_end, msgstr );
		xofs = (MSGWIN_TILEWIDTH * 8 - FontProc_GetPrintMaxLineWidth( FONT_SYSTEM, msgstr, 0)) / 2;
		yofs = (MSGWIN_TILEHEIGHT * 8 - FontProc_GetPrintLineNum( msgstr ) * 16) / 2;
		GF_STR_PrintColor( &msgwin, FONT_SYSTEM, msgstr, xofs, yofs, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(13,12,0), NULL );

		STRBUF_Delete( msgstr );
		MSGMAN_Delete( msgman );
	}

	GF_BGL_BmpWinOn(&msgwin);

	GF_BGL_BGControlSet( bgl, GF_BGL_FRAME1_M, &hd1, GF_BGL_MODE_TEXT );

	ArcUtil_ScrnSet( ARC_INTRO, NARC_intro_back_s_guide_NSCR, bgl, GF_BGL_FRAME1_M, 0, 0, 0, heapID );
	ArcUtil_BgCharSet( ARC_INTRO, NARC_intro_back_s_NCGR, bgl, GF_BGL_FRAME1_M, 0, 0, 0, heapID ); 
	ArcUtil_PalSet( ARC_INTRO, NARC_intro_back_s_d_NCLR, PALTYPE_MAIN_BG, 0, 0, heapID );

	GF_BGL_ScrPalChange( bgl, GF_BGL_FRAME1_M, 0, 0, SCREEN_TILEWIDTH, SCREEN_TILEHEIGHT, 3 );
	GF_BGL_LoadScreenReq( bgl, GF_BGL_FRAME1_M );

	GF_BGL_BackGroundColorSet( GF_BGL_FRAME0_S, GX_RGB(7,8,27) );

	GF_Disp_DispOn();
	WIPE_ResetBrightness( WIPE_DISP_MAIN );
	WIPE_ResetBrightness( WIPE_DISP_SUB );
	SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

	while(1){
		sleepFunc();
		sys_MainKeyRead();	//L[ǂݎ
		reset_button_wait++;
		if ( reset_button_wait > RESET_BUTTON_WAIT_MAX || (reset_button_wait > RESET_BUTTON_WAIT_MIN && (sys.trg & PAD_BUTTON_A))) {
			OS_ResetSystem(0);
		}
        OS_WaitIrq(TRUE, OS_IE_V_BLANK); 	// uuN҂
	}
	sys_FreeMemoryEz( bgl );
}

#endif

// ----------------------------------------------------------------------------
