//============================================================================================
/**
 * @file	msgdata_util.c
 * @brief	bZ[Wf[^֘A֗֐
 * @author	taya
 * @date	2005.12.05
 *
 * |PEUEACeA
 * ̃vOQƂAǗ҂Bȕ̎擾舵
 *
 *
 */
//============================================================================================
#include "common.h"
#include "system/msgdata_util.h"
#include "system/buflen.h"

#include "msgdata/msg.naix"



//=================================================================================
// 
//=================================================================================
#define  EXPAND_BUFFER_SIZE		(1024)		/// ǂȕWJłł낤TCY


//------------------------------------------------------------------
/**
 * bZ[Wf[^^OWJobt@쐬ĕԂB
 * OɌʂ̃^Oݒ菈sĂKvB
 * 쐬ꂽ̉͊eōsB
 *
 * @param   wordSet		^Oݒ肳ꂽPZbgW[
 * @param   msgMan		WJOǗĂ郁bZ[W}l[W
 * @param   strID		WJOID
 * @param   heapID		obt@쐬̃q[vID
 *
 * @retval  STRBUF*		쐬ꂽobt@
 */
//------------------------------------------------------------------
STRBUF* MSGDAT_UTIL_AllocExpandString( WORDSET* wordSet, MSGDATA_MANAGER* msgMan, u32 strID, u32 heapID )
{
	STRBUF* retbuf = NULL;
	STRBUF* exbuf;

	exbuf = STRBUF_Create(EXPAND_BUFFER_SIZE, HEAPID_BASE_SYSTEM);
	if(exbuf)
	{
		STRBUF* srcbuf = MSGMAN_AllocString( msgMan, strID );
		if( srcbuf )
		{
			WORDSET_ExpandStr(wordSet, exbuf, srcbuf);
			retbuf = STRBUF_CreateBufferCopy( exbuf, heapID );
			STRBUF_Delete(srcbuf);
		}
		STRBUF_Delete(exbuf);
	}

	return retbuf;
}


//------------------------------------------------------------------
/**
 * UAVKɍ쐬obt@ɃRs[ĕԂ
 * iobt@̍폜͊eōsj
 *
 * @param   wazaID		Uhc
 * @param   heapID		q[vhc
 *
 * @retval  STRBUF*		obt@isȂNULL)
 */
//------------------------------------------------------------------
STRBUF* MSGDAT_UTIL_GetWazaName( u32 wazaID, u32 heapID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_wazaname_dat, heapID);
	if( man )
	{
		STRBUF* wazaname = STRBUF_Create(BUFLEN_WAZA_NAME, heapID);
		if( wazaname )
		{
			MSGMAN_GetString(man, wazaID, wazaname);
		}
		MSGMAN_Delete(man);
		return wazaname;
	}
	return NULL;
}


//------------------------------------------------------------------
/**
 * |PAVKɍ쐬obt@ɃRs[ĕԂ
 * iobt@̍폜͊eōsj
 *
 * @param   monsno		|Pio[
 * @param   heapID		q[vhc
 *
 * @retval  STRBUF*		obt@isȂNULL)
 */
//------------------------------------------------------------------
STRBUF* MSGDAT_UTIL_GetMonsName( u32 monsno, u32 heapID )
{
	MSGDATA_MANAGER* man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, heapID );
	if( man )
	{
		STRBUF* buf = MSGMAN_AllocString( man, monsno );
		MSGMAN_Delete(man);
		return buf;
	}
	return NULL;
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/19
// |Pׂ͂đS啶
// ----------------------------------------------------------------------------
