//============================================================================================
/**
 * @file	placename.c
 * @brief	nf[^舵
 * @author	taya
 * @date	2006.05.20
 */
//============================================================================================
#include "common.h"


#include "system\placename.h"


//--------------------------------------------------------------
/**
 *	ߊlꏊ^CvƂ̊Jnl
 */
//--------------------------------------------------------------
enum {
	MAP_START_NUMBER = 0,
	GAME_EVENT_START_NUMBER = 2000,
	EXT_EVENT_START_NUMBER = 3000,
};

static const u16  TypeStartNumber[] = {
	MAP_START_NUMBER,
	GAME_EVENT_START_NUMBER,
	EXT_EVENT_START_NUMBER,
};

//------------------------------------------------------------------
/**
 * ߊlꏊio[ߊlꏊ^Cv擾
 *
 * @param   number		ߊlꏊio[i|Pp[^ƂăZbgĂlj
 *
 * @retval  PLACENAME_TYPE		ߊlꏊ^Cv
 */
//------------------------------------------------------------------
PLACENAME_TYPE  PlaceName_GetType( u32 number )
{
	int i;

	for(i=0; i<(PLACENAME_TYPE_MAX-1); i++)
	{
		if( number < TypeStartNumber[i+1] )
		{
			return i;
		}
	}
	return i;
}

//------------------------------------------------------------------
/**
 * ߊlꏊio[Aeߊlꏊ^CvƂ̃CfbNXlԂ
 * ߂lgmm當擾ۂ̃CfbNXƂĎg
 *
 * @param   number		ߊlꏊio[i|Pp[^ƂăZbgĂlj
 *
 * @retval  int		ߊlꏊ^CvƂ̃CfbNX
 */
//------------------------------------------------------------------
int PlaceName_GetIndex( u32 number )
{
	int type = PlaceName_GetType( number );
	return number - TypeStartNumber[type];
}


//------------------------------------------------------------------
/**
 * ߊlꏊ^CvCfbNXA|Pp[^ƂăZbg邽߂̒l쐬
 *
 * @param   type		ߊlꏊ^Cv
 * @param   index		^CvƂ̃CfbNX
 *
 * @retval  int			|Pp[^ƂăZbg邽߂̒l
 */
//------------------------------------------------------------------
int PlaceName_IndexToParamNumber( PLACENAME_TYPE type, int index )
{
	GF_ASSERT(type<PLACENAME_TYPE_MAX);
	return TypeStartNumber[type] + index;
}

