//============================================================================================
/**
 * @brief	playtime_ctrl.c
 * @brief	vCԏ̑
 * @date	2006.06.21
 * @author	taya
 */
//============================================================================================
#include "common.h"
#include "gflib\apptimer.h"
#include "savedata/playtime.h"

#include "system\playtime_ctrl.h"


static BOOL StartFlag = FALSE;
static u64  PassedTick = 0;
static u64  PassedSec = 0;
static u64  StartTick = 0;
static PLAYTIME*  PlayTimePointer = NULL;

//------------------------------------------------------------------
/**
 * iQ[C[v̑OɂP񂾂Ăԁj
 */
//------------------------------------------------------------------
void PlayTimeCtrl_Init( void )
{
	StartFlag = FALSE;
}

//------------------------------------------------------------------
/**
 * vCԂ̃JEgJniQ[JnɂP񂾂Ăԁj
 *
 */
//------------------------------------------------------------------
void PlayTimeCtrl_Start( PLAYTIME* pt )
{
	StartFlag = TRUE;
	PassedTick = 0;
	PassedSec = 0;
	PlayTimePointer = pt;
	StartTick = APTM_GetData();
}

//------------------------------------------------------------------
/**
 * vCԂ̃JEgiC[vŖĂԁj
 *
 * @param   time		vCԃZ[uf[^|C^
 *
 */
//------------------------------------------------------------------
void PlayTimeCtrl_Countup( void )
{
	if( StartFlag )
	{
		u64  sec = APTM_CalcSec( APTM_GetData() - StartTick );
		if( sec > PassedSec )
		{
			PLAYTIME_CountUp( PlayTimePointer, (sec - PassedSec) );
			PassedSec = sec;
		}
	}
}










