//==============================================================================
/**
 * @file	pm_overlay.c
 * @brief	I[o[C
 * @author	matsuda
 * @date	2005.06.16()
 */
//==============================================================================
#include <nitro.h>
#include <nitro/fs.h>
#include "common.h"
#include "pm_overlay.h"


#if 0
NitroStaticInitgpɂ
/*
 * NitroStaticInit()  static initializer Ɏw肷ɂ
 * ̃wb_CN[h܂.
 */
#include <nitro/sinit.h>

#endif


//==============================================================================
//	萔`
//==============================================================================
///eGAŁAxɃI[o[Co鐔
#define AREA_WORK_MAX		(8)

//--------------------------------------------------------------
//	fobOp`
//--------------------------------------------------------------
#ifdef PM_DEBUG
///`L̏ꍇ̓I[o[C̃A[hsɃA[ḧNA
#define DEBUG_OVELAY_UNLOAD_CLEAR
#endif


//==============================================================================
//	\̒`
//==============================================================================
typedef struct{
	FSOverlayID loaded_id;
	BOOL loaded;
}OVERLAY_WORK;

typedef struct{
	OVERLAY_WORK main[AREA_WORK_MAX];
	OVERLAY_WORK itcm[AREA_WORK_MAX];
	OVERLAY_WORK dtcm[AREA_WORK_MAX];
}OVERLAY_SYSTEM;

//==============================================================================
//	O[oϐ錾
//==============================================================================
static OVERLAY_SYSTEM OverlaySys;


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void Overlay_Unload(OVERLAY_WORK *ovwork);
static BOOL Overlay_CrossAreaCheck(const FSOverlayID id);
static OVERLAY_WORK * Overlay_AreaOverlayWorkPtrGet(int memory_area);
static BOOL Overlay_RamStartEndAdressGet(const FSOverlayID id, u32 *start, u32 *end);
static BOOL load_overlay_high(MIProcessor target, FSOverlayID id);
static BOOL load_overlay_middle(MIProcessor target, FSOverlayID id);
static BOOL load_overlay_low(MIProcessor target, FSOverlayID id);
void Overlay_SystemWorkInit(void);
void Overlay_Init(void);
void Overlay_UnloadID(const FSOverlayID id);
void Overlay_UnloadMain(void);
void Overlay_UnloadItcm(void);
void Overlay_UnloadDtcm(void);
void Overlay_UnloadAll(void);
int Overlay_MemoryAreaGet(const FSOverlayID id);
BOOL Overlay_Load(const FSOverlayID id, int load_type);
BOOL Overlay_Call(const FSOverlayID id, int load_type, void(*func)(void *), void * work);

//--------------------------------------------------------------
/**
 * @brief   I[o[C̃VXe[NNA
 */
//--------------------------------------------------------------
void Overlay_SystemWorkInit(void)
{
	MI_CpuClear32(&OverlaySys, sizeof(OVERLAY_SYSTEM));
}

//--------------------------------------------------------------
/**
 * @brief   ݓǂݍłSẴI[o[CA[hĂAVXe[NNA
 */
//--------------------------------------------------------------
void Overlay_Init(void)
{
	Overlay_UnloadAll();
	Overlay_SystemWorkInit();
}

//--------------------------------------------------------------
/**
 * @brief   I[o[CA[h܂
 * @param   ovwork		I[o[C[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Overlay_Unload(OVERLAY_WORK *ovwork)
{
	//ݓǂݍ܂ĂI[o[CW[A[h܂
	BOOL ret;
#ifdef DEBUG_OVELAY_UNLOAD_CLEAR
	u32 start, end;
#endif

	GF_ASSERT(ovwork->loaded == TRUE);

#ifdef DEBUG_OVELAY_UNLOAD_CLEAR
	//A[hI[o[C̈0NA邽߂ɉOɃAhX擾
	Overlay_RamStartEndAdressGet(ovwork->loaded_id, &start, &end);
#endif

	ret = FS_UnloadOverlay(MI_PROCESSOR_ARM9, ovwork->loaded_id);
	OS_Printf("overlay ܂ id = 0x%08X(10iF%d)\n", 
		ovwork->loaded_id, ovwork->loaded_id);
	GF_ASSERT(ret == TRUE);
	ovwork->loaded = FALSE;

#ifdef DEBUG_OVELAY_UNLOAD_CLEAR
	//A[hI[o[C̈NA
	OS_TPrintf("overlay unloade start address = 0x%08X\n", start);
	OS_TPrintf("overlay unloade end address = 0x%08X\n", end);
	//MI_CpuClear8((void*)start, end - start);
	MI_CpuFill8((void*)start, 0xff, end - start);
#endif
}

//--------------------------------------------------------------
/**
 * @brief   w肵I[o[CID̃I[o[CA[h܂
 *
 * @param   id		I[o[CID
 *
 * [hĂȂꍇ͉܂
 */
//--------------------------------------------------------------
void Overlay_UnloadID(const FSOverlayID id)
{
	OVERLAY_WORK *ovwork;
	int memory_area;
	int i;
	
	memory_area = Overlay_MemoryAreaGet(id);
	ovwork = Overlay_AreaOverlayWorkPtrGet(memory_area);
	
	for(i = 0; i < AREA_WORK_MAX; i++){
		if(ovwork[i].loaded == TRUE && ovwork[i].loaded_id == id){
			//ݓǂݍ܂ĂI[o[CW[A[h܂
			Overlay_Unload(&ovwork[i]);
			return;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   CɓWJĂI[o[CSăA[h܂
 */
//--------------------------------------------------------------
void Overlay_UnloadMain(void)
{
	int i;
	
	for(i = 0; i < AREA_WORK_MAX; i++){
		if(OverlaySys.main[i].loaded == TRUE){
			Overlay_Unload(&OverlaySys.main[i]);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ITCMɓWJĂI[o[CSăA[h܂
 */
//--------------------------------------------------------------
void Overlay_UnloadItcm(void)
{
	int i;
	
	for(i = 0; i < AREA_WORK_MAX; i++){
		if(OverlaySys.itcm[i].loaded == TRUE){
			Overlay_Unload(&OverlaySys.itcm[i]);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   DTCMɓWJĂI[o[CSăA[h܂
 */
//--------------------------------------------------------------
void Overlay_UnloadDtcm(void)
{
	int i;
	
	for(i = 0; i < AREA_WORK_MAX; i++){
		if(OverlaySys.dtcm[i].loaded == TRUE){
			Overlay_Unload(&OverlaySys.dtcm[i]);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   w肵I[o[CIDƓGAɓWJĂI[o[C̈
 *          SăA[h܂
 *
 * @param   id		I[o[CID
 */
//--------------------------------------------------------------
void Overlay_UnloadSameArea(const FSOverlayID id)
{
	int memory_area;
	
	memory_area = Overlay_MemoryAreaGet(id);
	switch(memory_area){
	case OVERLAY_AREA_MAIN:
		Overlay_UnloadMain();
		break;
	case OVERLAY_AREA_ITCM:
		Overlay_UnloadItcm();
		break;
	case OVERLAY_AREA_DTCM:
		Overlay_UnloadDtcm();
		break;
	default:
		GF_ASSERT(0);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   ݓǂݍłI[o[Cւ̃A[hASĂ̗̈ɑ΂čs
 */
//--------------------------------------------------------------
void Overlay_UnloadAll(void)
{
	Overlay_UnloadMain();
	Overlay_UnloadItcm();
	Overlay_UnloadDtcm();
}

//--------------------------------------------------------------
/**
 * @brief   wI[o[CID̓WJ惁GA擾
 * @param   id		I[o[CID
 * @retval  WJ惁GA(OVERLAY_AREA_???)
 */
//--------------------------------------------------------------
int Overlay_MemoryAreaGet(const FSOverlayID id)
{
	FSOverlayInfo info;
	BOOL ret;
	u32 ram_address;
	
	ret = FS_LoadOverlayInfo(&info, MI_PROCESSOR_ARM9, id);
	GF_ASSERT(ret == TRUE);
	
	ram_address = (u32)FS_GetOverlayAddress(&info);
	if(ram_address <= HW_ITCM_END && ram_address >= HW_ITCM_IMAGE){
		return OVERLAY_AREA_ITCM;
	}
	else if(ram_address <= HW_DTCM_END && ram_address >= HW_DTCM){
		return OVERLAY_AREA_DTCM;
	}
	return OVERLAY_AREA_MAIN;
}

//--------------------------------------------------------------
/**
 * @brief   w肵I[o[C[h
 *
 * @param   id				[hI[o[CID
 * @param   load_type		[h^Cv(OVERLAY_LOAD_???)
 *
 * @retval  TRUE:
 * @retval  FALSE:s
 *
 * ̃I[o[CsĂ鎞Ä悪ꍇ̓I[o[C͎s܂B
 * (fobOGF_ASSERTŒ~܂)
 *
 * [hFS_SetDefaultDMA(or FS_Init)Őݒ肳Ă@ōs܂B
 * gpDMA,CPUύXꍇ́Å֐sOFS_SetDefaultDMAŐݒsĂB
 * ITCM,DTCMւ̃[h͓ňꎞICPUɕύXă[hs܂B([h͌̐ݒɖ߂܂)
 */
//--------------------------------------------------------------
BOOL Overlay_Load(const FSOverlayID id, int load_type)
{
	BOOL ret;
	int memory_area;
	u32 dma_bak = FS_DMA_NOT_USE;
	OVERLAY_WORK *ovwork;
	int i;
	
//	Overlay_Unload(memory_area);	//̈gpĂI[o[CA[h
	if(Overlay_CrossAreaCheck(id) == FALSE){
		return FALSE;
	}

	//󂫃[NT[`
	memory_area = Overlay_MemoryAreaGet(id);
	ovwork = Overlay_AreaOverlayWorkPtrGet(memory_area);
	for(i = 0; i < AREA_WORK_MAX; i++){
		if(ovwork[i].loaded == FALSE){
			ovwork = &ovwork[i];
			ovwork->loaded = TRUE;
			ovwork->loaded_id = id;
			break;
		}
	}
	if(i >= AREA_WORK_MAX){
		GF_ASSERT(0);	//GAɃI[o[Co鐔𒴂Ă
		return FALSE;
	}
	
	if(memory_area == OVERLAY_AREA_ITCM || memory_area == OVERLAY_AREA_DTCM){
		//TCMւ݂̏DMAł͏oȂ̂ňꎞICPU֕ύX
		dma_bak = FS_SetDefaultDMA(FS_DMA_NOT_USE);
	}
	
	switch(load_type){
	case OVERLAY_LOAD_SYNCHRONIZE:
		ret = load_overlay_high(MI_PROCESSOR_ARM9, id);
		break;
	case OVERLAY_LOAD_SYNCHRONIZE_2:
		ret = load_overlay_middle(MI_PROCESSOR_ARM9, id);
		break;
	case OVERLAY_LOAD_NOT_SYNCHRONIZE:
		ret = load_overlay_low(MI_PROCESSOR_ARM9, id);
		break;
	default:		//sȃ[h^Cv
		GF_ASSERT(0);
		return FALSE;
	}

	if(memory_area == OVERLAY_AREA_ITCM || memory_area == OVERLAY_AREA_DTCM){
		//ꎞIɕύX̂ɖ߂
		FS_SetDefaultDMA(dma_bak);
	}

	if(ret == FALSE){	//[hs
		OS_Printf("overlay 0x%08X is not available!\n", id);
		GF_ASSERT(0);
		return FALSE;
	}

	OS_Printf("overlay [h܂ id = 0x%08X(10i:%d)\n", id, id);
	
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   w肵I[o[CID̗̈悪ݓWJĂI[o[C̈ƃAhX
 *          ĂȂ`FbN
 *
 * @param   id		I[o[CID
 *
 * @retval  TRUE:ĂȂB@FALSE:Ă(G[̏ꍇL)
 */
//--------------------------------------------------------------
static BOOL Overlay_CrossAreaCheck(const FSOverlayID id)
{
	int memory_area;
	u32 start, end, c_start, c_end;
	BOOL ret;
	OVERLAY_WORK *ovwork;
	int i;
	
	ret = Overlay_RamStartEndAdressGet(id, &start, &end);
	if(ret == FALSE){
		return FALSE;
	}
	
	memory_area = Overlay_MemoryAreaGet(id);
	ovwork = Overlay_AreaOverlayWorkPtrGet(memory_area);
	for(i = 0; i < AREA_WORK_MAX; i++){
		if(ovwork[i].loaded == TRUE){
			ret = Overlay_RamStartEndAdressGet(ovwork[i].loaded_id, &c_start, &c_end);
			if(ret == TRUE){
				if((start >= c_start && start < c_end) || (end > c_start && end <= c_end)
						|| (start <= c_start && end >= c_end)){
					OS_Printf("I[o[C̈ɏd܂I\n");
					OS_Printf("WJςID=%dAVKɓWJ悤ƂID=%d\n", 
						ovwork[i].loaded_id, id);
					GF_ASSERT(0);
					return FALSE;
				}
			}
		}
	}
	
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   w胁GAQƂI[o[C[N̐擪AhX擾
 * @param   memory_area		GA(OVERLAY_AREA_???)
 * @retval  w胁ɑΉI[o[C[N̐擪AhX
 */
//--------------------------------------------------------------
static OVERLAY_WORK * Overlay_AreaOverlayWorkPtrGet(int memory_area)
{
	OVERLAY_WORK *ovwork;
	
	switch(memory_area){
	case OVERLAY_AREA_MAIN:
	default:
		ovwork = OverlaySys.main;
		break;
	case OVERLAY_AREA_ITCM:
		ovwork = OverlaySys.itcm;
		break;
	case OVERLAY_AREA_DTCM:
		ovwork = OverlaySys.dtcm;
		break;
	}
	return ovwork;
}

//--------------------------------------------------------------
/**
 * @brief   wI[o[CID̃[hJnAhXƃ[hIAhX擾
 *
 * @param   id			I[o[CID
 * @param   start		擾[hJnAhX
 * @param   end			擾[hIAhX
 *
 * @retval  TRUE:IB@FALSE:s
 */
//--------------------------------------------------------------
static BOOL Overlay_RamStartEndAdressGet(const FSOverlayID id, u32 *start, u32 *end)
{
	FSOverlayInfo info;
	BOOL ret;
	
	ret = FS_LoadOverlayInfo(&info, MI_PROCESSOR_ARM9, id);
	if(ret == FALSE){
		GF_ASSERT(0);
		return FALSE;
	}
	
	*start = (u32)FS_GetOverlayAddress(&info);
	*end = *start + FS_GetOverlayTotalSize(&info);
	
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   SĂ𓯊IɎs
 *
 * @param   target		[hΏہiARM9vZbT/ARM7vZbTj
 * @param   id			I[o[CID
 *
 * @retval  TRUE:
 * @retval  FALSE:s
 */
//--------------------------------------------------------------
static BOOL load_overlay_high(MIProcessor target, FSOverlayID id)
{
	return FS_LoadOverlay(target, id);
}

//--------------------------------------------------------------
/**
 * @brief   IɎƂŎs (I)
 *
 * @param   target		[hΏہiARM9vZbT/ARM7vZbTj
 * @param   id			I[o[CID
 *
 * @retval  TRUE:
 * @retval  FALSE:s
 */
//--------------------------------------------------------------
static BOOL load_overlay_middle(MIProcessor target, FSOverlayID id)
{
	FSOverlayInfo info;

	if(!FS_LoadOverlayInfo(&info, target, id)){
		return FALSE;
	}
	if(!FS_LoadOverlayImage(&info)){
		return FALSE;
	}
	FS_StartOverlay(&info);
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   SĂƂŎs (񓯊I)
 *
 * @param   target		[hΏہiARM9vZbT/ARM7vZbTj
 * @param   id			I[o[CID
 *
 * @retval  TRUE:
 * @retval  FALSE:s
 */
//--------------------------------------------------------------
static BOOL load_overlay_low(MIProcessor target, FSOverlayID id)
{
	FSOverlayInfo info;
	
	//I[o[CW[̏[h܂
	if (!FS_LoadOverlayInfo(&info, target, id)){
		return FALSE;
	}
	
	{
		FSFile file;
		
		//FSFile\̂܂
		FS_InitFile(&file);
		(void)FS_LoadOverlayImageAsync(&info, &file);
		(void)FS_WaitAsync(&file);
		(void)FS_CloseFile(&file);
	}
	FS_StartOverlay(&info);
	return TRUE;
}

//--------------------------------------------------------------
/**
 */
//--------------------------------------------------------------
BOOL Overlay_Call(const FSOverlayID id, int load_type, void(*func)(void *), void * work)
{
	if (!Overlay_Load(id, load_type)) {
		return FALSE;
	}
	func(work);

	Overlay_UnloadID(id);
	return TRUE;
}

