//=============================================================================================
/**
 * @file	pmfprint.c
 * @brief	\֐
 * @author	tetsu
 * @date	2003.04.08
 *
 * @data	2004.11.04 AGB -> NDS
 * @author	Hiroyuki Nakamura
 */
//=============================================================================================
#include "common.h"
#include "fntsys.h"

#define __PMFPRINT_H_GLOBAL__
#include	"system/pmfprint.h"

#include	"system/snd_tool.h"
#include	"system\fontproc.h"
#include "../field/fld_bmp.h"




#define	CURSOR_WAIT_TIME		(8)

#define WRITE_SKIP_CURSOR_W		( 8)
#define WRITE_SKIP_CURSOR_H		(16)


extern void	BmpPrintMsg(MSG_DATA_HEADER* mdh_p);


#include "skip_cur.dat"			//J[\f[^

static MSG_PRINT_MODE msg_print_flag;


#define	AFF_FONT_POS_CHG		// gtHg̈ʒuύXiRgAEgŏ㑵j

#ifdef	AFF_FONT_POS_CHG
//#define	AFF_FONT_CENTER		// gtHg𒆑ŕ\iRgAEgŉj
#endif




//=============================================================================================
#define	PRINTSEQ_WRITE			(0)
#define	PRINTSEQ_TRGWAIT		(1)
#define	PRINTSEQ_TRGWAIT_CLEAR	(2)
#define	PRINTSEQ_TRGWAIT_SCROLL	(3)
#define	PRINTSEQ_SCROLL			(4)
#define	PRINTSEQ_SE_WAIT		(5)
#define	PRINTSEQ_FORCEWAIT		(6)

#define	SCR_SPEED_FAST		(4)
#define	SCR_SPEED_NORMAL	(2)
#define	SCR_SPEED_SLOW		(1)
static	const u8 scr_speed_value[] = {
	SCR_SPEED_SLOW,
	SCR_SPEED_NORMAL,
	SCR_SPEED_FAST,
};

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/06
// 炩ߓo^ĂFɌŕύXdg݂
// localize_spec_mark(LANG_ALL) imatake 2006/12/11
// F̓o^̎dg݂ύX
#define COLORSTACK_COLORNUM			(7)
#define COLORSTACK_COLOROFFSET		(100)
#define COLORSTACK_COLORMAX			(COLORSTACK_COLOROFFSET + COLORSTACK_COLORNUM)
#define COLORSTACK_SWAP				(255)
#define COLORSTACK_ISVALID(c)		(c >= COLORSTACK_COLOROFFSET && c < COLORSTACK_COLORMAX)
// ----------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
/*
 *	f[^擾
 *
 * @param	ini			BGLf[^
 * @param	mdh_p		bZ[Wf[^\̃|C^
 *
 * @retval	w_flag		擾p[^
 *
 */
//---------------------------------------------------------------------------------------------
PRINT_RESULT PokeFontPrint( MSG_DATA_HEADER * mdh_p )
{
	const MSG_FONT_DATA* font_bmp;
	MSG_PRINT_USER*	mpu_p;
	int msg_speed, scr_sp;
	u16	fcode;

//	mdh_p->mph->bmpwin->ini

	mpu_p = (MSG_PRINT_USER *)&(mdh_p->userwork[0]);

	switch(mdh_p->seq){

	case PRINTSEQ_WRITE:		//ʏ폈

		//ςȂ̏ꍇ̔(ŏ̃gK[oĂΗL)
		if( ( (sys.cont & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)) && (mpu_p->skip_f) ) ||
			( (sys.tp_cont) && (msg_print_flag.tp_f) ) ){
			mdh_p->waitwork = 0;
			if( mdh_p->wait != MSG_ALLPUT ){
				msg_print_flag.btl_skip_f = 1;
			}
		}
		if((mdh_p->waitwork)&&(mdh_p->wait)){
			(mdh_p->waitwork)--;

			if(msg_print_flag.skip_f){//XLbv@\L̏ꍇ̏
				//ŏ̃gK[o
				if( ( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ) ||
					( (sys.tp_trg) && (msg_print_flag.tp_f) ) ){
					mpu_p->skip_f = 1;
					mdh_p->waitwork = 0;
				}
			}
			return PRINT_RESULT_COMMAND;
		}

/*		ǁAXLbvtO𗧂Ăƃ{^ő̂ŁAEFCg̓vgxɈˑ
		if(msg_print_flag.auto_f){
			mdh_p->waitwork = AUTO_MSGWAIT;		//I[g̓EFCg
		}else{
			mdh_p->waitwork = mdh_p->wait;
		}
*/
		mdh_p->waitwork = mdh_p->wait;


		//tHgf[^擾
		fcode = *(u16*)(mdh_p->mph.msg);
		mdh_p->mph.msg++; 

		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/07
		// kꂽ̂܂ܕ\悤ƂĂXgbv
		GF_ASSERT_MSG(fcode != COMPRESSED_MARK, "k̂܂ܕ\悤Ƃ܂B\n");
		// ----------------------------------------------------------------------------

		switch(fcode){

		/* IR[h */
		case EOM_:	
			return PRINT_RESULT_END;

		/* sR[h */
		case CR_:	
			mdh_p->mph.write_x = mdh_p->mph.start_x;
			mdh_p->mph.write_y +=( FontHeaderGet( mdh_p->mph.fnt_index, FONT_HEADER_SIZE_Y ) + mdh_p->mph.space_y ); 
			return PRINT_RESULT_LOOP;

		/* wINDEXobt@̃bZ[WWJ	*/
		case I_MSG_:	
			//쐬(DATA = 1byte)
			mdh_p->mph.msg++; 
			return PRINT_RESULT_LOOP;


		/* tHgR}h */
		case _CTRL_TAG:
			// ^OR[hoʒu܂Ń|C^߂
			mdh_p->mph.msg--;

			fcode = STRCODE_GetTagType( mdh_p->mph.msg );

			switch( fcode ){
			case NC_FONT_COL_:				// tHgR[h
				{
					u16	 param = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );
					// ----------------------------------------------------------------------------
					// localize_spec_mark(LANG_ALL) imatake 2006/12/06
					// 炩ߓo^ĂFɌŕύXdg݂
					// localize_spec_mark(LANG_ALL) imatake 2006/12/11
					// F̓o^̎dg݂ύX
					if (param == COLORSTACK_SWAP) {
						u8 color_stack = mdh_p->mph.color_stack;
						mdh_p->mph.color_stack = (mdh_p->mph.f_col - 1) / 2 + COLORSTACK_COLOROFFSET;
						if (!COLORSTACK_ISVALID(color_stack)) break;	// lۑĂȂΌێ
						param = color_stack - COLORSTACK_COLOROFFSET;
					} else if (param >= COLORSTACK_COLOROFFSET) {
						mdh_p->mph.color_stack = param;
						break;
					}
					// ----------------------------------------------------------------------------
					mdh_p->mph.f_col = 1 + (param*2);
					mdh_p->mph.s_col = 1 + (param*2) + 1;
					FntDataColorSet(mdh_p->mph.f_col, mdh_p->mph.b_col, mdh_p->mph.s_col);
				}
				break;

			case NC_NOTE_ICON:		// ɒڃACRLq
				{
					u16	 param = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );
					GF_MSG_PrintDispIcon( mdh_p, mdh_p->mph.write_x, mdh_p->mph.write_y, param );
				}
				if( mdh_p->wait_flg != 0 ){
					GF_BGL_BmpWinOn( mdh_p->mph.bmpwin );
				}
				break;

			case NC_FORCE_WAIT:
				{
					mdh_p->waitwork = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );
					mdh_p->mph.msg = STRCODE_SkipTag( mdh_p->mph.msg );
					mdh_p->seq = PRINTSEQ_FORCEWAIT;
					return PRINT_RESULT_COMMAND;
				}
				break;

			case NC_CALLBACK_ARG:
				mdh_p->callback_arg = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );
				mdh_p->mph.msg = STRCODE_SkipTag( mdh_p->mph.msg );
				return PRINT_RESULT_COMMAND;

			case NC_WRITEPOS_CHANGE_X:
				mdh_p->mph.write_x = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );
				break;

			case NC_WRITEPOS_CHANGE_Y:
				mdh_p->mph.write_y = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );
				break;

			case NC_FONT_SIZE_:
				{
					u16 param = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );

					switch( param ) {
					case NC_FAFF_100_:		// TCYF100
						mdh_p->mph.dot_tbl = 0;
						mdh_p->mph.dot_wy = 0;
						break;
					case NC_FAFF_200_:		// TCYF200
						mdh_p->mph.dot_tbl = 0xfffc;
						mdh_p->mph.dot_wy = 0;
						break;
					}
				}
				break;

			case NC_MOVE_:				// 쐧R[h
				{
					u16	 c_move = STRCODE_GetTagParam( mdh_p->mph.msg, 0 );

					switch( c_move ){
					case NC_MV_CLEAR_:		// L[҂NA
						mdh_p->seq	= PRINTSEQ_TRGWAIT_CLEAR;
						PokeFontTriggerCursorAnimeInit(mdh_p);
						mdh_p->mph.msg = STRCODE_SkipTag( mdh_p->mph.msg );
						return PRINT_RESULT_COMMAND;
					case NC_MV_SCROLL_:		// L[҂XN[
						mdh_p->seq	= PRINTSEQ_TRGWAIT_SCROLL;
						PokeFontTriggerCursorAnimeInit(mdh_p);
						mdh_p->mph.msg = STRCODE_SkipTag( mdh_p->mph.msg );
						return PRINT_RESULT_COMMAND;
					}
				}
				break;
			}

			mdh_p->mph.msg = STRCODE_SkipTag( mdh_p->mph.msg );
			return PRINT_RESULT_LOOP;

		/* ""		gK[҂MSGGANA({`JnZbg) */
		case NORMAL_WAIT_:
			mdh_p->seq	= PRINTSEQ_TRGWAIT_CLEAR;
			PokeFontTriggerCursorAnimeInit(mdh_p);
			return PRINT_RESULT_COMMAND;
	
		/* ""		gK[҂sXN[({s) */
		case SCROLL_WAIT_:
			mdh_p->seq	= PRINTSEQ_TRGWAIT_SCROLL;
			PokeFontTriggerCursorAnimeInit(mdh_p);
			return PRINT_RESULT_COMMAND;

		}
		font_bmp = FontDataGet( mpu_p->fmode, fcode );

		//etHg`
		GF_BGL_BmpWinPrintMsgWide(
			mdh_p->mph.bmpwin, font_bmp->data,
			font_bmp->size_x, font_bmp->size_y,
			mdh_p->mph.write_x,mdh_p->mph.write_y, mdh_p->mph.dot_tbl );

		//̕̕`ʒuݒ
		mdh_p->mph.write_x += (font_bmp->size_x + mdh_p->mph.space_x);
		return PRINT_RESULT_WRITE;

	case PRINTSEQ_TRGWAIT:		//gK[҂
		if(PokeFontTriggerWait2(mdh_p)){
			PokeFontTriggerCursorAnimeExit2(mdh_p);
			mdh_p->seq	= PRINTSEQ_WRITE;
		}
		return PRINT_RESULT_COMMAND;

	case PRINTSEQ_TRGWAIT_CLEAR:		//gK[҂MSGGANA
		if(PokeFontTriggerWait(mdh_p)){
			//GANA
			PokeFontTriggerCursorAnimeExit2(mdh_p);	//œɃNA
			GF_BGL_BmpWinDataFill( mdh_p->mph.bmpwin, mdh_p->mph.b_col );
			mdh_p->mph.write_x = mdh_p->mph.start_x;
			mdh_p->mph.write_y = mdh_p->mph.start_y;
			mdh_p->seq	= PRINTSEQ_WRITE;
		}
		return PRINT_RESULT_COMMAND;

	case PRINTSEQ_TRGWAIT_SCROLL:		//gK[҂XN[
		if(PokeFontTriggerWait( mdh_p )){
			PokeFontTriggerCursorAnimeExit2(mdh_p);
			//XN[ݒ(Y̍ + \)
			mdh_p->scrwork	=( FontHeaderGet( mdh_p->mph.fnt_index, FONT_HEADER_SIZE_Y ) + mdh_p->mph.space_y ); 
			mdh_p->mph.write_x = mdh_p->mph.start_x;
			mdh_p->seq	= PRINTSEQ_SCROLL;
		}
		return PRINT_RESULT_COMMAND;

	case PRINTSEQ_SCROLL:				//XN[
		if( mdh_p->scrwork )
		{
			scr_sp = scr_speed_value[2];

			if(mdh_p->scrwork < scr_sp)
			{
				GF_BGL_BmpWinShift(
					mdh_p->mph.bmpwin, GF_BGL_BMPWIN_SHIFT_U,
					mdh_p->scrwork, (mdh_p->mph.b_col<<4)|mdh_p->mph.b_col );
				mdh_p->scrwork = 0;
			}
			else
			{
				GF_BGL_BmpWinShift(
					mdh_p->mph.bmpwin, GF_BGL_BMPWIN_SHIFT_U,
					scr_sp, (mdh_p->mph.b_col<<4)|mdh_p->mph.b_col );
				mdh_p->scrwork -= scr_sp;
			}

			GF_BGL_BmpWinOn( mdh_p->mph.bmpwin );

		}
		else
		{
			mdh_p->seq	= PRINTSEQ_WRITE;
		}
		return PRINT_RESULT_COMMAND;

	case PRINTSEQ_SE_WAIT:			//SEEFCg
		mdh_p->seq	= PRINTSEQ_WRITE;
		return PRINT_RESULT_COMMAND;

	case PRINTSEQ_FORCEWAIT:		//EFCg
		if( mdh_p->waitwork )
		{
			mdh_p->waitwork--;
		}
		else
		{
			mdh_p->seq	= PRINTSEQ_WRITE;
		}
		return PRINT_RESULT_COMMAND;
	}
	return PRINT_RESULT_END;
}

//=============================================================================================
/**
 *		gK[҂J[\\
 */
//=============================================================================================
static u16 TrgCursorCgxPos = 0;		// \EBhEg̃Lʒu

//--------------------------------------------------------------------------------------------
/**
 * gK[҂J[\\EBhEg̃Lʒuۑ
 *
 * @param	cgx		EBhEg̃Lʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PokeFontTrgCursorCgxSet( u16 cgx )
{
	TrgCursorCgxPos = cgx;
}

//--------------------------------------------------------------------------------------------
/**
 * gK[҂J[\Aj
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void		PokeFontTriggerCursorAnimeInit(MSG_DATA_HEADER* mdh_p)
{
	MSG_PRINT_USER*	mpu_p;

	mpu_p = (MSG_PRINT_USER*)&(mdh_p->userwork[0]);

	if(msg_print_flag.auto_f){
		mpu_p->rep_wait = 0;	//I[gEFCg[N
	}else{
		mpu_p->cur_anm  = 0;
		mpu_p->cur_wait = 0;
	}
}

static const u8 CursorAnmData[] = {0,1,2,1,};

//--------------------------------------------------------------------------------------------
/**
 * gK[҂J[\Aj
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PokeFontTriggerCursorAnime2( MSG_DATA_HEADER * mdh_p )
{
	MSG_PRINT_USER * mpu_p;
	void * cgx;

	mpu_p = (MSG_PRINT_USER *)&(mdh_p->userwork[0]);

	if(msg_print_flag.auto_f){
		return;
	}
	if(mpu_p->cur_wait){
		mpu_p->cur_wait--;
		return;
	}

	{
		u16	cgx;
		u8	frm, px, py, sx;

		frm = GF_BGL_BmpWinGet_Frame( mdh_p->mph.bmpwin );
		px  = GF_BGL_BmpWinGet_PosX( mdh_p->mph.bmpwin );
		py  = GF_BGL_BmpWinGet_PosY( mdh_p->mph.bmpwin );
		sx  = GF_BGL_BmpWinGet_SizeX( mdh_p->mph.bmpwin );
		cgx = TrgCursorCgxPos;

		GF_BGL_ScrFill(
			mdh_p->mph.bmpwin->ini, frm, cgx+18+(CursorAnmData[mpu_p->cur_anm]*4),
			px+sx+1, py+2, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_ScrFill(
			mdh_p->mph.bmpwin->ini, frm, cgx+19+(CursorAnmData[mpu_p->cur_anm]*4),
			px+sx+2, py+2, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_ScrFill(
			mdh_p->mph.bmpwin->ini, frm, cgx+20+(CursorAnmData[mpu_p->cur_anm]*4),
			px+sx+1, py+3, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_ScrFill(
			mdh_p->mph.bmpwin->ini, frm, cgx+21+(CursorAnmData[mpu_p->cur_anm]*4),
			px+sx+2, py+3, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_LoadScreenReq( mdh_p->mph.bmpwin->ini, frm );

		mpu_p->cur_wait = CURSOR_WAIT_TIME;
		mpu_p->cur_anm++;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * gK[҂J[\AjI
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PokeFontTriggerCursorAnimeExit2( MSG_DATA_HEADER* mdh_p )
{
	u16	cgx;
	u8	frm, px, py, sx;

	frm = GF_BGL_BmpWinGet_Frame( mdh_p->mph.bmpwin );
	px  = GF_BGL_BmpWinGet_PosX( mdh_p->mph.bmpwin );
	py  = GF_BGL_BmpWinGet_PosY( mdh_p->mph.bmpwin );
	sx  = GF_BGL_BmpWinGet_SizeX( mdh_p->mph.bmpwin );
	cgx = TrgCursorCgxPos;

	GF_BGL_ScrFill(
		mdh_p->mph.bmpwin->ini, frm, cgx+10, px+sx+1, py+2, 1, 2, GF_BGL_SCRWRT_PALNL );
	GF_BGL_ScrFill(
		mdh_p->mph.bmpwin->ini, frm, cgx+11, px+sx+2, py+2, 1, 2, GF_BGL_SCRWRT_PALNL );

	GF_BGL_LoadScreenReq( mdh_p->mph.bmpwin->ini, frm );
}


//============================================================================================
//	gK[҂
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * L[̓gK[҂֐
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = wait"
 */
//--------------------------------------------------------------------------------------------
static BOOL PokeFontTriggerWaitCheck( MSG_DATA_HEADER * mdh_p )
{
	if( ( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ) ||
		( (sys.tp_trg) && (msg_print_flag.tp_f) ) ){
		Snd_SePlay( SE_MSG_SKIP );
		msg_print_flag.btl_wait_f = 1;
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * I[ggK[҂֐
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = wait"
 */
//--------------------------------------------------------------------------------------------
BOOL PokeFontTriggerWaitReplayCheck(MSG_DATA_HEADER* mdh_p)
{
	MSG_PRINT_USER*	mpu_p;
	u16	wait_len;

	mpu_p = (MSG_PRINT_USER*)&(mdh_p->userwork[0]);

	wait_len = AUTO_MSGTRGWAIT;

	if(mpu_p->rep_wait == wait_len){	//vCEFCg
		return TRUE;
	}
	mpu_p->rep_wait++;

	if( msg_print_flag.auto_f_skip ){
		return PokeFontTriggerWaitCheck( mdh_p );
	}

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * gK[҂֐ (  )
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = wait"
 */
//--------------------------------------------------------------------------------------------
BOOL PokeFontTriggerWait( MSG_DATA_HEADER* mdh_p )
{
	BOOL flg = FALSE;

	if(msg_print_flag.auto_f){
		//I[gEFCg`FbN
		flg = PokeFontTriggerWaitReplayCheck(mdh_p);
	}else{
		PokeFontTriggerCursorAnime2(mdh_p);
		flg = PokeFontTriggerWaitCheck( mdh_p );
	}
	return flg;
}

//--------------------------------------------------------------------------------------------
/**
 * gK[҂֐ ( Ȃ )
 *
 * @param	mdh_p	bZ[Wf[^wb_
 *
 * @retval	"TRUE = "
 * @retval	"FALSE = wait"
 */
//--------------------------------------------------------------------------------------------
BOOL PokeFontTriggerWait2(MSG_DATA_HEADER* mdh_p)
{
	u8	flg = FALSE;

	if(msg_print_flag.auto_f){
		//I[gEFCg`FbN
		flg = PokeFontTriggerWaitReplayCheck(mdh_p);
	}else{
		flg = PokeFontTriggerWaitCheck( mdh_p );
	}
	return flg;
}



//=============================================================================================
//	`搧
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XLbvݒ
 *
 * @param	flg		tO
 *
 * @return	none
 *
 *	flg = MSG_SKIP_OFF : XLbv
 *	flg = MSG_SKIP_ON  : XLbvL
 */
//--------------------------------------------------------------------------------------------
void MsgPrintSkipFlagSet( int flg )
{
	msg_print_flag.skip_f = flg;
}

//--------------------------------------------------------------------------------------------
/**
 * ݒ
 *
 * @param	flg		tO
 *
 * @return	none
 *
 *	flg = MSG_AUTO_OFF     : 薳
 *	flg = MSG_AUTO_ON      : L
 *	flg = MSG_AOTO_SKIP_ON : L/{^XLbvL
 */
//--------------------------------------------------------------------------------------------
void MsgPrintAutoFlagSet( int flg )
{
	msg_print_flag.auto_f      = (flg&1);
	msg_print_flag.auto_f_skip = ((flg>>1)&1);
}

//--------------------------------------------------------------------------------------------
/**
 * ^b`plݒ
 *
 * @param	flg		tO
 *
 * @return	none
 *
 *	flg = MSG_TP_OFF : ^b`pl
 *	flg = MSG_TP_ON  : ^b`plL
 */
//--------------------------------------------------------------------------------------------
void MsgPrintTouchPanelFlagSet( int flg )
{
	msg_print_flag.tp_f = flg;
}


//--------------------------------------------------------------------------------------------
/**
 * 퓬pFXLbv
 *
 * @param	none
 *
 * @retval	"1 = 蒆"
 * @retval	"0 = ȊO"
 */
//--------------------------------------------------------------------------------------------
u8 MsgPrintBattleSkipPushFlagGet(void)
{
	return msg_print_flag.btl_skip_f;
}

//--------------------------------------------------------------------------------------------
/**
 * 퓬pFXLbv𔻒肷tONA
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MsgPrintBattleSkipPushFlagClear(void)
{
	msg_print_flag.btl_skip_f = 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 퓬pF𑗂
 *
 * @param	none
 *
 * @retval	"1 = 蒆"
 * @retval	"0 = ȊO"
 */
//--------------------------------------------------------------------------------------------
u8 MsgPrintBattleWaitPushFlagGet(void)
{
	return msg_print_flag.btl_wait_f;
}

//--------------------------------------------------------------------------------------------
/**
 * 퓬pF𑗂𔻒肷tONA
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MsgPrintBattleWaitPushFlagClear(void)
{
	msg_print_flag.btl_wait_f = 0;
}
