//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		render_oam.c
 *@brief	_[pO[oOAM}l[WVXe
 *@author	tomoya takahashi
 *@data		2005.09.09
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#include "gflib/clact.h"

#define	__RENDER_OAM_H_GLOBAL
#include "include/system/render_oam.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	O[oOAM}l[Wf[^
//	
//=====================================
typedef struct{
	NNSG2dOamManagerInstance MainMan;	// COAM
	NNSG2dOamManagerInstance SubMan;	// TuOAM
	int heap;
} REND_OAM_DATA;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static BOOL CallBackAddOamMain( const GXOamAttr* pOam, u16 affineIndex, BOOL /*bDoubleAffine*/ );
static BOOL CallBackAddOamSub( const GXOamAttr* pOam, u16 affineIndex, BOOL /*bDoubleAffine*/ );
static u16 CallBackAddAffineMain( const MtxFx22* mtx );
static u16 CallBackAddAffineSub( const MtxFx22* mtx );


// ͒ʐMACRpmۂ܂
static void	REND_OAMInit_Simple(int mainOamStart, int mainOamNum, int mainAffineStart, int mainAffineNum,  int subOamStart, int subOamNum, int subAffineStart, int subAffineNum, int heap);


//-----------------------------------------------------------------------------
/**
 *					O[oϐ錾
*/
//-----------------------------------------------------------------------------
static REND_OAM_DATA* RendOam;		//@_ŗpOAMf[^

//----------------------------------------------------------------------------
/**
 *
 *@brief	_gOAM}l[W̍쐬
 *
 *@param	mainOamStart		COAMǗJnԍ
 *@param	mainOamNum			COAMǗ
 *@param	mainAffineStart		CAtBǗJnԍ
 *@param	mainAffineNum		CAtBǗ
 *@param	subOamStart			TuOAMǗJnԍ
 *@param	subOamNum			TuOAMǗ
 *@param	subAffineStart		TuAtBǗJnԍ
 *@param	subAffineNum		TuAtBǗ
 *@param	heap				gpq[v
 *
 *@return	none
 *
 * ō쐬ꂽOAM}l[WFŎgp鎖ɂȂ܂B
 *
 *
 * Cʂ0`4ʐMACRgp邽߁@
 * ȂĂftHgŒʐMpɊmۂ܂
 *
 *
 */
//-----------------------------------------------------------------------------
void	REND_OAMInit(int mainOamStart, int mainOamNum, int mainAffineStart, int mainAffineNum,  int subOamStart, int subOamNum, int subAffineStart, int subAffineNum, int heap)
{
	int mo_start;
	int mo_num;
	int ma_start;
	int ma_num;
	
	// K4`124̊Ԃ̒lɂ
	if( mainOamStart < 4 ){
		mo_start = 4;

		if( mainOamNum > 124 ){
			mo_num	 = mainOamNum - (4 - mainOamStart);
		}else{
			mo_num = mainOamNum;
		}
	}else{
		mo_start = mainOamStart;
		mo_num	 = mainOamNum;
	}

	// K1`31̊Ԃ̒lɂ
	if( mainAffineStart < 1 ){
		ma_start = 1;

		if( mainAffineNum > 30 ){
			ma_num	 = mainAffineNum - (1 - mainAffineStart);
		}else{
			ma_num = mainAffineNum;
		}
	}else{
		ma_start = mainAffineStart;
		ma_num	 = mainAffineNum;
	}
	
	REND_OAMInit_Simple( mo_start, mo_num, ma_start, 
			ma_num,  subOamStart, subOamNum, subAffineStart, 
			subAffineNum, heap );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_gOAM}l[W̍쐬
 *
 *@param	mainOamStart		COAMǗJnԍ
 *@param	mainOamNum			COAMǗ
 *@param	mainAffineStart		CAtBǗJnԍ
 *@param	mainAffineNum		CAtBǗ
 *@param	subOamStart			TuOAMǗJnԍ
 *@param	subOamNum			TuOAMǗ
 *@param	subAffineStart		TuAtBǗJnԍ
 *@param	subAffineNum		TuAtBǗ
 *@param	heap				gpq[v
 *
 *@return	none
 *
 * ō쐬ꂽOAM}l[WFŎgp鎖ɂȂ܂B
 */
//-----------------------------------------------------------------------------
static void	REND_OAMInit_Simple(int mainOamStart, int mainOamNum, int mainAffineStart, int mainAffineNum,  int subOamStart, int subOamNum, int subAffineStart, int subAffineNum, int heap)
{
	BOOL result;
	
	GF_ASSERT(RendOam == NULL);

	// O[of[^쐬
	RendOam = sys_AllocMemory(heap, sizeof(REND_OAM_DATA));
	GF_ASSERT(RendOam);
	RendOam->heap = heap;

	// COAMobt@쐬
	result = NNS_G2dGetNewOamManagerInstance(
			&RendOam->MainMan,
			mainOamStart, mainOamNum,
			mainAffineStart, mainAffineNum,
			NNS_G2D_OAMTYPE_MAIN );

	GF_ASSERT( result );

	// TuOAMobt@쐬
	result = NNS_G2dGetNewOamManagerInstance(
			&RendOam->SubMan,
			subOamStart, subOamNum,
			subAffineStart, subAffineNum,
			NNS_G2D_OAMTYPE_SUB );

	GF_ASSERT( result );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_gpOAM}l[WOAM]s܂B
 *
 *@param	none
 *
 *@return	none
 *
 * ŜłPsővłB
 * ̊֐Pt[ŕĂԂƐɕ\܂B
 *
 */
//-----------------------------------------------------------------------------
void REND_OAMTrans(void)
{
	if(RendOam){
		NNS_G2dApplyAndResetOamManagerBuffer( &RendOam->MainMan );
		NNS_G2dApplyAndResetOamManagerBuffer( &RendOam->SubMan );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_p̃O[oOAM}l[Wf[^j
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void REND_OAM_Delete(void)
{
	GF_ASSERT(RendOam);
	
	// OAMWX^
	REND_OAM_UtilOamRamClear_Main( RendOam->heap );	
	REND_OAM_UtilOamRamClear_Sub( RendOam->heap );	

	sys_FreeMemoryEz(RendOam);
	RendOam = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[X
 *
 *@param	pSurface		T[tF[X̎̂̃|C^
 *@param	pRect			T[tF[X̋`
 *@param	type			T[tF[X^Cv
 *@param	pSetRenderer	̃T[tF[Xݒ肷郌_[iݒ肵ȂƂ́@NULLj
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void REND_OAM_SetSurface(NNSG2dRenderSurface* pSurface,
		NNSG2dViewRect* pRect,
		NNSG2dSurfaceType type,
		NNSG2dRendererInstance* pSetRenderer)
{
	GF_ASSERT(RendOam&&("Ă܂"));
	
	// T[tF[X
	if(type == NNS_G2D_SURFACETYPE_MAIN2D){
		RNDP_InitSurface(pSurface, pRect,
				CallBackAddOamMain, CallBackAddAffineMain,
				RNDP_CallBackCulling, type,
				pSetRenderer);
	}else{
		RNDP_InitSurface(pSurface, pRect,
				CallBackAddOamSub, CallBackAddAffineSub,
				RNDP_CallBackCulling, type,
				pSetRenderer);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_p̃O[oOAM}l[Wf[^쐬ς݂`FbN
 *
 *@param	none
 *
 *@retval	TURE		쐬Ă
 *@retval	FALSE		쐬ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL REND_OAM_Live(void)
{
	if(RendOam == NULL){
		return FALSE;
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM}l[WCX^X擾
 *
 *	@param	flag	CʗpTuʗp
 *
 *	@return	OAM}l[W[CX^X
 *
 * flag
	REND_OAM_MAIN,		// C
	REND_OAM_SUB,		// Tu
 */
//-----------------------------------------------------------------------------
NNSG2dOamManagerInstance* REND_OAM_GetOamManagerInstance( int flag )
{
	NNSG2dOamManagerInstance* p_ret;
	
	// Ă܂
	GF_ASSERT( RendOam );
	
	if( flag == REND_OAM_MAIN ){
		p_ret = &RendOam->MainMan;
	}else{
		p_ret = &RendOam->SubMan;
	}

	return p_ret;
}


//----------------------------------------------------------------------------
/**
 * [Cʗp]
 *	@brief	OAMRAM̃NA
 *
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void REND_OAM_UtilOamRamClear_Main( int heap )
{
	CLACT_UtilOamRamClear_Main( heap );
}

//----------------------------------------------------------------------------
/**
 * [Tuʗp]
 *	@brief	OAMRAM̃NA
 *
 *	@param	heap	q[v
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void REND_OAM_UtilOamRamClear_Sub( int heap )
{
	CLACT_UtilOamRamClear_Sub( heap );
}


//	Oam Affine o^֐쐬
//-----------------------------------------------------------------------------
/**
 *@brief				OAMǉ邽߂ɌĂ΂R[obN֐
 *
 *@param	pOamFǉׂOAMւ̃|C^
 *@param	affineIndexFOAMgpAffineCfbNX
 *@param	BOOL F{pAffineǂ
 *
 *@retval	FTRUE
 *@retval	sFFALSE
 *
 ----------------------------------------------------------------------------*/
// Cʗp
static BOOL CallBackAddOamMain( const GXOamAttr* pOam, u16 affineIndex, BOOL /*bDoubleAffine*/ )
{
	BOOL ret;
	ret = NNS_G2dEntryOamManagerOamWithAffineIdx( &RendOam->MainMan, pOam, affineIndex );
	GF_ASSERT( ret );		// o^I[o[

	return ret;
}

// Tuʗp
static BOOL CallBackAddOamSub( const GXOamAttr* pOam, u16 affineIndex, BOOL /*bDoubleAffine*/ )
{
	BOOL ret;
    ret = NNS_G2dEntryOamManagerOamWithAffineIdx( &RendOam->SubMan, pOam, affineIndex );
	GF_ASSERT( ret );		// o^I[o[

	return ret;
}


//-----------------------------------------------------------------------------
/**
 *@brief	Affinep[^ǉ邽߂ɌĂ΂֐łB
 *
 *@param	mtxFǉׂAffineϊsւ̃|C^
 *
 *@return	ǉAffinep[^Index
 *
 */
 //----------------------------------------------------------------------------
// Cʗp
static u16 CallBackAddAffineMain( const MtxFx22* mtx )
{
	u16 ret;
    ret =  NNS_G2dEntryOamManagerAffine( &RendOam->MainMan, mtx );
	GF_ASSERT( ret != NNS_G2D_OAM_AFFINE_IDX_NONE );
	
	return ret;
}

// Tuʗp
static u16 CallBackAddAffineSub( const MtxFx22* mtx )
{
	u16 ret;
    ret = NNS_G2dEntryOamManagerAffine( &RendOam->SubMan, mtx );
	GF_ASSERT( ret != NNS_G2D_OAM_AFFINE_IDX_NONE );

	return ret;
}
