//==============================================================================================
/**
 * @file	snd_perap.c
 * @brief	TEh ybv֐
 * @author	Satoshi Nohara
 * @date	2006.04.15
 */
//==============================================================================================
#include "common.h"
#include "snd_system.h"
#include "system/snd_tool.h"
#include "savedata/savedata.h"				//
#include "savedata/perapvoice.h"			//
#include "poketool/monsno.h"


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
BOOL Snd_MainPerapCheck( void );

BOOL Snd_PerapVoiceCheck( const PERAPVOICE* perap );
BOOL Snd_PerapVoicePlayingCheck( const PERAPVOICE* perap );

BOOL Snd_PerapVoicePlaySub( const PERAPVOICE* perap, u32 sex, int vol, int pan );
void Snd_PerapVoiceStop( void );

MICResult Snd_PerapVoiceRecStart( void );
MICResult Snd_PerapVoiceRecStop( void );

void Snd_PerapVoiceDataSave( PERAPVOICE* perap );

void Snd_PerapVoiceDefaultFlagSet( u8 no );

BOOL Snd_PerapVoicePlay( PERAPVOICE* perap, u32 sex, int vol, int pan );

int Snd_PerapVoiceWazaParamGet( PERAPVOICE* perap );
BOOL Snd_PerapVoicePMVoiceTypeCheck( int type );


//==============================================================================================
//
//	`
//
//==============================================================================================
#define PERAP_SAMPLING_RATE		(2000)									//TvO[g
#define PERAP_SAMPLING_TIME		(1)										//TvO鎞
#define PERAP_SAMPLING_SIZE		(PERAP_SAMPLING_RATE * PERAP_SAMPLING_TIME)	//Kvȃf[^

#define PERAP_MALE_WAVEOUT_SPD		(WAVEOUT_PLAY_SPDx1 - 4096)			//IX̍ĐXs[h
#define PERAP_FEMALE_WAVEOUT_SPD	(WAVEOUT_PLAY_SPDx1 + 9192)			//X̍ĐXs[h
#define PERAP_WAVEOUT_SPD_RAND	(8192)									//ĐXs[h̃_


//==============================================================================================
//
//	
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEhCĂ΂
 *			؃bv̘^f[^̍ĐIĎă`lJ
 *
 * @param	none
 *
 * @retval	"=TRUEAȂ=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_MainPerapCheck( void )
{
	u8* perap_play_flag	= Snd_GetParamAdrs(SND_W_ID_PERAP_PLAY_FLAG);

	//ybv̘^ĐĂ邩tO
	if( *perap_play_flag == 1 ){

		//g`ĐIĂ
		if( Snd_WaveOutIsPlaying(WAVEOUT_CH_NORMAL) == FALSE ){

			Snd_PerapVoiceStop();	//~

			return TRUE;
		}
	}

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	ybv̘^f[^Đ\`FbN
 *
 * @param	no		|Pio[
 *
 * @retval	"Đ\=TRUEAĐs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_PerapVoiceCheck( const PERAPVOICE* perap )
{
	u8* perap_default_flag	= Snd_GetParamAdrs(SND_W_ID_PERAP_DEFAULT_FLAG);

	//f[^݂邩ǂ̃`FbN
	if( PERAPVOICE_GetExistFlag(perap) == FALSE ){
		return FALSE;
	}

	//ftHg̖ĐtÕ`FbN
	if( *perap_default_flag == TRUE ){
		return FALSE;
	}

	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief	ybv̘^f[^ĐĂ邩`FbN
 *
 * @param	no		|Pio[
 *
 * @retval	"Đ=TRUEAĐĂȂ=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_PerapVoicePlayingCheck( const PERAPVOICE* perap )
{
	u8* perap_play_flag		= Snd_GetParamAdrs( SND_W_ID_PERAP_PLAY_FLAG );

	if( *perap_play_flag == 0 ){
		return FALSE;
	}

	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief	ybv̘^f[^Đ
 *
 * @param	perap	PERAPVOICE^̃|C^
 * @param	sex		
 * @param	vol		{[
 * @param	pan		p
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_PerapVoicePlaySub( const PERAPVOICE* perap, u32 sex, int vol, int pan )
{
	u16 add_spd;
	int ret,wave_pan;
	s8* sWaveBuffer			= Snd_GetWaveBufAdrs();
	u8* perap_play_flag		= Snd_GetParamAdrs( SND_W_ID_PERAP_PLAY_FLAG );

	//ybv̘^f[^Đs\`FbN
	if( Snd_PerapVoiceCheck(perap) == FALSE ){
		return FALSE;
	}

	//V[PXĐ̃p(-127 - 0 - 127)ƂȂĂ
	//g`Đ̃p(0 - 64 - 127)ƂȂĂ
	
	//g`Đp擾
	if( pan < 0 ){
		wave_pan = 64 + (pan / 2);		//0 - 64  ɂ
	}else{
		wave_pan = 64 + (pan / 2);		//64 - 127 ɂ
	}

	Snd_PMVoiceStop(0);		//~

	//ĐIOɁA
	//ēx̊֐Ă΂邱Ƃ̂ŁA
	//x~ĂAĐ֐iނ悤ɂ
	Snd_PerapVoiceStop();

	//g`Đp`lmۂ
	Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );

	//_ɉς
	//gf_srand( sys.vsync_counter );
	add_spd = ( gf_rand() % PERAP_WAVEOUT_SPD_RAND );

	//f[^̓WJ
	PERAPVOICE_ExpandVoiceData( sWaveBuffer, PERAPVOICE_GetVoiceData(perap) );

	{
		WAVEOUT_WORK waveout_wk;
		waveout_wk.handle			= Snd_WaveOutHandleGet(WAVEOUT_CH_NORMAL);	//g`Đnh
		waveout_wk.format			= NNS_SND_WAVE_FORMAT_PCM8;		//g`f[^tH[}bg

		waveout_wk.dataaddr			= Snd_GetWaveBufAdrs();			//g`f[^̐擪AhX

		waveout_wk.loopFlag			= FALSE;						//[vtO
		waveout_wk.loopStartSample	= 0;							//[vJnTvʒu
		waveout_wk.samples			= PERAP_SAMPLING_SIZE;			//g`f[^̃Tv
		waveout_wk.sampleRate		= PERAP_SAMPLING_RATE;			//g`f[^̃TvO[g
		waveout_wk.volume			= vol;							//
		waveout_wk.speed			= (WAVEOUT_PLAY_SPDx1+add_spd);	//ĐXs[h
		waveout_wk.pan				= wave_pan;						//p(0-127)
		ret = Snd_WaveOutStart( &waveout_wk, WAVEOUT_CH_NORMAL );

		//{CX`bg̉ʑΉ
		Snd_WaveOutSetVolume( WAVEOUT_CH_NORMAL, vol );
	}

#if 0
	//ς
	if( ret == TRUE ){
		if( sex == PM_MALE ){
			Snd_WaveOutSetSpeed( WAVEOUT_CH_NORMAL, PERAP_MALE_WAVEOUT_SPD );	//IX
		}else{
			Snd_WaveOutSetSpeed( WAVEOUT_CH_NORMAL, PERAP_FEMALE_WAVEOUT_SPD );	//X
		}
	}
#endif

	*perap_play_flag = 1;					//؃bv̘^ĐĂtOON
	Snd_PerapVoiceDefaultFlagSet( FALSE );	//؃bṽftHg̖ĐtOOFF

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	ybv̘^f[^~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PerapVoiceStop( void )
{
	u8* ch_normal_flag	= Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* perap_play_flag	= Snd_GetParamAdrs(SND_W_ID_PERAP_PLAY_FLAG);

	if( *ch_normal_flag == 1 ){										//CHmۂĂ
		Snd_WaveOutStopReverse( WAVEOUT_CH_NORMAL );				//bufJ
		Snd_WaveOutFreeChannel( WAVEOUT_CH_NORMAL );				//ch J
	}

	*perap_play_flag = 0;											//tONA
	return;
}

//--------------------------------------------------------------
/**
 * @brief	ybvf[^^Jn(TEhVXë̗Ɉꎞۑ)
 *
 * @param	none
 *
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
MICResult Snd_PerapVoiceRecStart( void )
{
	MICAutoParam mic;	//}CNp[^

	//g`Đp`lmۂ
	//Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );

	mic.type			= MIC_SAMPLING_TYPE_SIGNED_8BIT;	//TvO

	//obt@32oCgACꂽAhXłȂƃ_I
	mic.buffer			= Snd_GetWaveBufAdrs();

	mic.size			= PERAP_SAMPLING_SIZE;

	if( (mic.size&0x1f) != 0 ){
		mic.size &= 0xffffffe0;
	}

	//\IȃTvO[gARM7̃^C}[ɊZl̒`
	//mic.rate			= MIC_SAMPLING_RATE_8K;
	mic.rate			= HW_CPU_CLOCK_ARM7 / PERAP_SAMPLING_RATE;

	//ATvOɃobt@[vtO
	mic.loop_enable		= FALSE;

	//obt@OaۂɌĂяoR[obN֐ւ̃|C^
	mic.full_callback	= NULL;

	//obt@OaۂɌĂяoR[obN֐֓n
	mic.full_arg		= NULL;

	return Snd_MicStartAutoSampling( &mic );		//^Jn
}

//--------------------------------------------------------------
/**
 * @brief	ybvf[^^~
 *
 * @param	none
 *
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
MICResult Snd_PerapVoiceRecStop( void )
{
	return Snd_MicStopAutoSampling();
}

//--------------------------------------------------------------
/**
 * @brief	^f[^Z[uf[^ɃZbg
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PerapVoiceDataSave( PERAPVOICE* perap )
{
	PERAPVOICE_SetVoiceData( perap, (const s8*)Snd_GetWaveBufAdrs() );
	return;
}


/***********/
//~AĐ`FbNΉĂ邩mFI
/***********/


//==============================================================================================
//
//	TEhVXeŁA
//
//	؃bvio[`FbN
//	ftHg̖炷tO`FbN
//
//	^f[^Đ邩ɑΉ֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	؃bṽftHg̖ĐtO
 *
 * @param	no		tO
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PerapVoiceDefaultFlagSet( u8 no )
{
	u8* perap_default_flag	= Snd_GetParamAdrs(SND_W_ID_PERAP_DEFAULT_FLAG);
	*perap_default_flag		= no;
	return;
}


//==============================================================================================
//
//	ʐMmۂ؃bvf[^̃|C^󂯎AĐ֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	ybv̘^f[^Đ
 *
 * @param	perap	ybvf[^̃|C^
 * @param	sex		(PM_MALEȂ)
 * @param	vol		{[(0 ` 127)
 * @param	pan		p(-128 ` 127)
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_PerapVoicePlay( PERAPVOICE* perap, u32 sex, int vol, int pan )
{
	int ret;
	PERAPVOICE** my_p = Snd_GetParamAdrs( SND_W_ID_MY_PERAP_PTR );

	//ybv̘^f[^Đ
	if( perap == NULL ){
		ret = Snd_PerapVoicePlaySub( *my_p, sex, vol, pan );		//G[
	}else{
		ret = Snd_PerapVoicePlaySub( perap, sex, vol, pan );
	}

	//؃bv̘^f[^ĐoȂ
	if( ret == FALSE ){
		Snd_PerapVoiceDefaultFlagSet( TRUE );			//ftHgĐ

		//q[vIDw肵Ă邪mۂ͂ĂȂI(PV_NORMALŒȂ̂)
		ret = Snd_PMVoicePlayEx( PV_NORMAL, MONSNO_PERAPPU, pan, vol, HEAPID_WORLD );
	}

	//Snd_PMVoicePlayEx̒ŁASnd_PerapVoicePlaySubĂ΂邪A
	//ɓn̂́Â؃bvf[^Ȃ̂ŁAЂƂ܂Ƃ߂ɂĂ͂߁I
	//default_flagĂ̂ŁA؃bv̍Đɂ͂A
	//ftHg̖Ȃ悤ɂȂI
	
	return ret;
}


//==============================================================================================
//
//	Zuׂv
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Z̃p[^擾
 *
 * @param	perap		؃bvf[^̃|C^
 *
 * @retval	"p[^ 0`2"
 */
//--------------------------------------------------------------
int Snd_PerapVoiceWazaParamGet( PERAPVOICE* perap )
{
	const s8* voicedata;
	s8 num;

	//f[^݂邩ǂ̃`FbN
	if( PERAPVOICE_GetExistFlag(perap) == FALSE ){
		return 0;
	}

	//vf[15]ăp[^肷
	voicedata = PERAPVOICE_GetVoiceData(perap);
	num = voicedata[15];
	//OS_Printf( "voicedata[15] = %d\n", voicedata[15] );
	//OS_Printf( "num = %d\n", num );

	if( (-128 <= num) && (num < -30) ){
		return 1;
	}

	if( (30 <= num) && (num < 128) ){
		return 2;
	}

	return 0;
}


//--------------------------------------------------------------
/**
 * @brief	^f[^AftHgf[^ǂĐ邩`FbN
 *
 * @param	type		Đp^[
 *
 * @retval	"TRUE=^f[^ĐAFALSE=ftHg̖Đ"
 */
//--------------------------------------------------------------
BOOL Snd_PerapVoicePMVoiceTypeCheck( int type )
{
	switch( type ){
	case PV_NORMAL:				//ʏĐ
	case PV_HALF:				//ĐԒZkiQQogŃ|Poꎞj
	//case PV_FLDEVENT:			//{|PitB[hCxgj
	//case PV_W_TOOBOE:			//ZʉEƂڂp
	//case PV_W_HYPER1:			//ZʉEnCp[{CXpP
	case PV_POKEDOWN:			//|Pꂽ
	//case PV_W_HYPER2:			//ZʉEnCp[{CXpQ
	//case PV_W_HOERU1:			//ZʉEقP
	//case PV_W_HOERU2:			//ZʉEقQ
	//case PV_W_NAKIGOE1:		//ZʉEȂP
	//case PV_W_NAKIGOE2:		//ZʉEȂQ
	case PV_PINCHNORMAL:		//ʏĐ(CȂ)
	case PV_PINCHHALF:			//ĐԒZkiQQogŃ|Poꎞj(CȂ)
	//case PV_ZUKAN_CHORUS:		//}ӃR[XĐ(ǉ06.03.03)
	//case PV_ZUKAN_NORMAL:		//}Ӄm[}Đ(ǉ06.04.21)
		return TRUE;
	};

	return FALSE;
}

