//==============================================================================================
/**
 * @file	snd_system.c
 * @brief	TEhVXe
 * @author	Satoshi Nohara
 * @date	2005.11.08
 *
 * snd_tool,snd_play,(main)̂݃ANZX
 * snd_system
 *     |
 *     |
 * f[^ZbgȂǂ̏܂Ƃ߂	ĐA~Ȃǂ̏܂Ƃ߂
 * snd_tool								snd_play
 *     |
 *     |
 * efĂ΂(ɃtB[hCxg)
 * fld_bgm
 *
 * 
 * 퓬ŃQ[I[o[ɂȂāA|PZɖ߂鎞Ȃǂ́A
 * Snd_PauseClearAllĂŁA|[YtONAȂƂȂI
 */
//==============================================================================================
#include "common.h"
#include "snd_system.h"
#include "system/snd_tool.h"
#include "system/snd_perap.h"
#include "src_os_print.h"

#include "savedata/savedata.h"
#include "savedata/perapvoice.h"
#include "savedata/config.h"


//==============================================================================================
//
//	`
//
//==============================================================================================
//sound_data.smap̃TCY菭傫߂Ɋmۂ
#define SOUND_HEAP_SIZE		(0xbbc00)				//TEhq[vTCY(750k)
//#define SOUND_HEAP_SIZE	(0xbd000)				//TEhq[vTCY(750k)
//#define SOUND_HEAP_SIZE	(0xc0000)				//TEhq[vTCY(750k)
//#define SOUND_HEAP_SIZE	(0x80000)				//TEhq[vTCY(500k)


//==============================================================================================
//
//	\̐錾
//
//==============================================================================================
//TEhVXe[N
struct _SND_WORK{

	//VXe֘A
	NNSSndArc arc;									//TEhA[JCu
	NNSSndHeapHandle heap;							//TEhq[vnh
	u8 sndHeap[ SOUND_HEAP_SIZE ];					//TEhq[v
	NNSSndHandle Handle[ SND_HANDLE_MAX ];			//TEhnh
	NNSSndWaveOutHandle sWaveOutHandle[2];			//g`nh
	const NNSSndArcBankInfo* info;					//oN\

	//Lv`֘A
	u8 sCaptureBuffer[ CAPTURE_BUFSIZE ] ATTRIBUTE_ALIGN(32);	//Lv`obt@
	EffectCallbackInfo callbackInfo;				//GtFNg̃R[obNϐ

#ifdef STREAM_ON
	//Xg[֘A
	NNSSndStrmHandle strmHandle;
#endif
	
	u16 seq;										//V[PX
	u8	ctrl_bgm_flag;								//tB[hBGMŒtO(Z[uȂ)
	u8	dmy101;

	int fade_count;									//tF[hJE^[
	int next_wait;									//BGM炷܂ł̃EFCg
	int next_frame;									//BGM̃tF[hCt[

	u16 now_bgm_no;									//BGMio[
	u16 next_bgm_no;								//BGMio[

	u8	field_pause_flag;							//PLAYER_FIELD|[YĂ邩tO
	u8	bgm_pause_flag;								//PLAYER_BGM|[YĂ邩tO
	u16 me_wait;									//MEEFCg

	u8  reverse_flag;								//tĐgptO
	u8  waveout_ch_normal_flag;						//g`ŎgpCHmۂtO
	u8  waveout_ch_chorus_flag;						//g`ŎgpCHmۂtO(CHORUS)
	u8  chorus_flag;								//R[XgptO

	u8  bank_flag;									//邩tO
	//u8	wavearc_count;							//ǂݍ񂾔g`A[JCu
	u8	filter_size;								//tB^[TCY
	u8	scene_main;									//݂̃CV[
	u8  scene_sub;									//݂̃TuV[

	int heap_save[SND_HEAP_SAVE_MAX];				//TEhq[vKwx

	u8	perap_play_flag;							//ybv̘^ĐĂ邩tO
	u8	perap_default_flag;							//ybṽftHg̖ĐtO
	u16	zone_bgm;									//][BGMio[

	const SNDWaveData* wave_data;					//g`f[^̃|C^

	void* reverse_buf;								//tĐp̃obt@̃|C^

	int volume;										//BGM{[

	TCB_PTR length_tcb;								//ĐTCB

	PERAPVOICE*	my_perap_ptr;						//̂؃bv{CX̃|C^
	PERAPVOICE*	perap_ptr[4];						//؃bv{CX̃|C^
};


//==============================================================================================
//
//	`
//
//==============================================================================================


//==============================================================================================
//
//	ϐ
//
//==============================================================================================
static SND_WORK snd_work;							//TEhVXe[N
static int snd_status;								//TEhXe[^X

//gpȂBB
static NNSSndCaptureOutputEffectType stereo_mono;	//XeIm

//fobNp
u32 aki_size;										//TEhq[vTCYmF


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void Snd_AllInit( PERAPVOICE* perap, CONFIG* config );
void Snd_Main(void);
static void Snd_StatusCall(void);
void Snd_StatusSet( int status );
BOOL Snd_StatusCheck( int chg_status );
static BOOL Snd_MeUseCheck(void);

SND_WORK* Snd_GetSystemAdrs();
void* Snd_GetParamAdrs( int type );

int Snd_HeapSaveState(int* heap_lv);
void Snd_HeapLoadState( int level );
void Snd_UseHeapSizeOsPrint(void);
NNSSndHeapHandle* Snd_HeapHandleGet(void);

BOOL Snd_ArcLoadGroup( u16 no );
BOOL Snd_ArcLoadSeq( u16 no );
BOOL Snd_ArcLoadSeqEx( u16 no, u32 flag );
BOOL Snd_ArcLoadSeqArc( u16 no );
BOOL Snd_ArcLoadWaveArc( u16 no );
BOOL Snd_ArcLoadBank( u16 no );

NNSSndHandle * Snd_HandleGet( int type );
int Snd_GetHandleNoByPlayerNo( int player_no );

void Snd_PlayerPauseAll( BOOL flag );

//[J֐
static void Snd_WorkInit( SND_WORK* wk );
static void Snd_HandleInit( SND_WORK* wk );
static void Snd_GameStartLoad( SND_WORK* wk );
static void Snd_MicInit(void);

//PLAYER_BGM̒~Anh[X
static void Snd_PlayerBgmStop( void );


//==============================================================================================
//
//	vO
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEh
 *
 * @param	none
 *
 * @retval	none
 *
 * ̑SẴTEh֐ɌĂтĂB
 * A炩߁AOSĂKv܂B 
 *
 * IRQ荞݂͗LɂĂB܂Å֐̌ŁA
 * OS_SetIrqMask֐ ȂǂŊ荞݂̐ݒ㏑Ȃ悤ɂĂB 
 */
//--------------------------------------------------------------
void Snd_AllInit( PERAPVOICE* perap, CONFIG* config )
{
	SND_WORK* wk = Snd_GetSystemAdrs();

	//Snd_LocalWorkCreate();				//TEh[J[Nm
	
    NNS_SndInit();							//TEhCȕ

	Snd_MicInit();							//MIC

	Snd_WorkInit(wk);						//TEhVXe[N

	//TEhq[v̍쐬
    wk->heap = NNS_SndHeapCreate( &wk->sndHeap, sizeof(wk->sndHeap) );

	//TEhA[JCȕ
    NNS_SndArcInit( &wk->arc, "data/sound/sound_data.sdat", wk->heap, FALSE );

	//vC[̃ZbgAbv
	//TEhA[JCuŒ`ĂvC[ݒɊÂZbgAbv
    (void)NNS_SndArcPlayerSetup( wk->heap );

#ifdef STREAM_ON
	NNS_SndArcStrmInit( STREAM_THREAD_PRIO, wk->heap );

    NNS_SndStrmHandleInit( &wk->strmHandle );
#endif

    //TEhnh
    Snd_HandleInit(wk);

#ifdef SOUND_OS_PRINT_ON
	//aki_size = NNS_SndHeapGetFreeSize( wk->heap );
	aki_size = NNS_SndHeapGetSize( wk->heap );
	OS_Printf( "\n\n//========================================\n" );
	OS_Printf( "//\tTEh\n" );
	OS_Printf( "//========================================\n" );
	OS_Printf( "eʁTEhq[v = %d\n", aki_size );

	OS_Printf( "\nvC[q[v蓖ĕ\n" );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂

	OS_Printf( "Q[JñTEhf[^[h\n" );
#endif

	Snd_GameStartLoad(wk);								//Q[JñTEhf[^̃[h

	//o̓GtFNgݒ
	stereo_mono = NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL;	//ʏ̃XeI[h
	//Snd_CaptureStartOutputEffect( stereo_mono );
	
	//̂؃bṽ|C^ɂĂ(06.04.20)
	wk->my_perap_ptr = perap;

	//RtBOݒɕύX
	Snd_SetMonoFlag( config->sound_mode );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEht[[N
 *
 * @param	none
 *
 * @retval	none
 *
 * 1t[1xĂяo΁AǂŃR[Ă\Ȃ
 */
//--------------------------------------------------------------
void Snd_Main(void)
{
	SND_WORK* wk = Snd_GetSystemAdrs();

	//MEgp̎́ABGMXe[^X͂ȂI
	if( Snd_MeUseCheck() == FALSE ){

		//tF[hJEgfNg
		if( wk->fade_count > 0 ){
			wk->fade_count--;
		}
	
		//TEhXe[^XĂяo
		Snd_StatusCall();
	}

	//؃bv̘^ĐĂ邩tOĂA
	//g`ĐIĂ邩`FbNāAg`Đ`lJ
	Snd_MainPerapCheck();

	NNS_SndMain();
	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhXe[^XĂяo
 *
 * @param	status		Xe[^X(snd_system.hQ)
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_StatusCall(void)
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

	switch( snd_status ){

	//
	//case SND_STATUS_INIT:
	//	break;

	//~
	case SND_STATUS_STOP:
		//Ȃ
		break;

	//
	//case SND_STATUS_PLAYSTART:
	//	break;

	//Đ
	case SND_STATUS_PLAY:
		Snd_StatusSet( SND_STATUS_PLAING );					//Xe[^X(Đ)
		break;

	//Đ
	case SND_STATUS_PLAING:
		//Ȃ
		break;

	//tF[hC
	case SND_STATUS_FADEIN:
		if( Snd_FadeCheck() == 0 ){							//tF[hIĂ
			Snd_StatusSet( SND_STATUS_PLAING );				//Xe[^X(Đ)
		}
		break;

	//tF[hAEg
	case SND_STATUS_FADEOUT:
		//ɂ鎞ƁAʏ鎞I
		if( Snd_FadeCheck() == 0 ){							//tF[hIĂ
			Snd_StatusSet( SND_STATUS_PLAING );				//Xe[^X(Đ)
		}
		break;

	//
	//case SND_STATUS_FADENEXT:
	//	break;

	//
	//case SND_STATUS_FADENEXTFADE:
	//	break;

	//tF[hAEg  BGMĐ
	case SND_STATUS_FADEOUT_NEXT_PLAY:
		if( Snd_FadeCheck() == 0 ){							//tF[hI҂
			if( Snd_NextWaitCheck() == 0 ){					//BGM炷܂ł̃EFCg`FbN

				//PLAYER_BGM炵Ȃ}bvJڂ̑Ή
				//PLAYER_BGM|[YĂ󋵂́A
				//MEɌ肳AME͕K~A|[YI
				//ŕKAPLAYER_BGM~ĂȂI
				Snd_PlayerBgmStop();

				Snd_BgmPlay( wk->next_bgm_no );				//BGMĐ(Xe[^XĐ)
			}
		}
		break;

	//tF[hAEg  BGMtF[hC
	case SND_STATUS_FADEOUT_NEXT_FADEIN:
		if( Snd_FadeCheck() == 0 ){							//tF[hI҂
			if( Snd_NextWaitCheck() == 0 ){					//BGM炷܂ł̃EFCg`FbN

				//PLAYER_BGM炵Ȃ}bvJڂ̑Ή
				//PLAYER_BGM|[YĂ󋵂́A
				//MEɌ肳AME͕K~A|[YI
				//ŕKAPLAYER_BGM~ĂȂI
				Snd_PlayerBgmStop();

				Snd_BgmPlay( wk->next_bgm_no );				//BGMĐ(Xe[^XĐ)

				//tF[hC(Xe[^XtF[hC)
				Snd_BgmFadeIn( BGM_VOL_MAX, wk->next_frame, BGM_FADEIN_START_VOL_MIN );
			}
		}
		break;

	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhXe[^XZbg
 *
 * @param	status		Xe[^X(snd_system.hQ)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_StatusSet( int status )
{
	SND_WORK* wk = Snd_GetSystemAdrs();
	wk->seq = 0;
	snd_status = status;

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\ñ݂TEhXe[^X = %d\n\n", snd_status );
#endif

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhXe[^X`FbN
 *
 * @param	chg_status	Xe[^X(snd_system.hQ)
 *
 * @retval	"TRUE=AFALSE=s"
 */
//--------------------------------------------------------------
BOOL Snd_StatusCheck( int chg_status )
{
	//Xe[^X(tF[hAEgĐ)̎ɁAgbNtF[hɐ؂ւ邱Ƃ͕sI
	if( (snd_status == SND_STATUS_FADEOUT_NEXT_PLAY) && (chg_status == SND_STATUS_TRACKFADE ) ){
		return FALSE;
	}

	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief	MEgp`FbN
 *
 * @param	none
 *
 * @retval	"TRUE=gpAFALSE=gpĂȂ"
 */
//--------------------------------------------------------------
static BOOL Snd_MeUseCheck(void)
{
	SND_WORK* wk = Snd_GetSystemAdrs();

	if( Snd_PlayerCountPlayingSeq(PLAYER_ME) != 0 ){ return TRUE; }		//MEV[PX`FbN
	if( wk->me_wait != 0 ){ return TRUE; }								//MEEFCg`FbN

	return FALSE;
}


//==============================================================================================
//
//	TEhVXe[NANZX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEhVXe[ÑAhX擾
 *
 * @param	none
 *
 * @retval	"TEhVXe[ÑAhX"
 */
//--------------------------------------------------------------
SND_WORK* Snd_GetSystemAdrs()
{
	return (SND_WORK*)&snd_work;
}

//--------------------------------------------------------------
/**
 * @brief	TEhVXe[ÑõAhX擾
 *
 * @param	type	oID
 *
 * @retval	"õAhX"
 */
//--------------------------------------------------------------
void* Snd_GetParamAdrs( int type )
{
	SND_WORK* wk = Snd_GetSystemAdrs();

	switch( type ){

	case SND_W_ID_CTRL_BGM_FLAG:				//tB[hBGMŒtO
		return &wk->ctrl_bgm_flag;

	case SND_W_ID_WAVEOUT_HANDLE_NORMAL:		//g`nh
		return &wk->sWaveOutHandle[0];

	case SND_W_ID_WAVEOUT_HANDLE_CHORUS:		//g`nh
		return &wk->sWaveOutHandle[1];

	case SND_W_ID_BANK_INFO:					//oN\
		return &wk->info;

	case SND_W_ID_CAPTURE_BUF:					//Lv`obt@
		return &wk->sCaptureBuffer;

	case SND_W_ID_CALLBACK_INFO:				//GtFNg̃R[obNϐ
		return &wk->callbackInfo;

	case SND_W_ID_FADE_COUNT:					//tF[hJE^[
		return &wk->fade_count;

	case SND_W_ID_NEXT_WAIT:					//BGM炷܂ł̃EFCg
		return &wk->next_wait;

	case SND_W_ID_NEXT_FRAME:					//BGM̃tF[hCt[
		return &wk->next_frame;

	case SND_W_ID_NOW_BGM_NO:					//BGMio[
		return &wk->now_bgm_no;					//Z[uKvI(Ƃňړ)

	case SND_W_ID_NEXT_BGM_NO:					//BGMio[
		return &wk->next_bgm_no;				//Z[uKvI(Ƃňړ)

	case SND_W_ID_FIELD_PAUSE_FLAG:				//PLAYER_FIELD|[YĂ邩tO
		return &wk->field_pause_flag;

	case SND_W_ID_BGM_PAUSE_FLAG:				//PLAYER_BGM|[YĂ邩tO
		return &wk->bgm_pause_flag;

	case SND_W_ID_ME_WAIT:						//MEEFCg
		return &wk->me_wait;

	case SND_W_ID_REVERSE_FLAG:					//tĐgptO
		return &wk->reverse_flag;

	case SND_W_ID_WAVEOUT_CH_NORMAL_FLAG:		//g`ŎgpCHmۂtO
		return &wk->waveout_ch_normal_flag;

	case SND_W_ID_WAVEOUT_CH_CHORUS_FLAG:		//g`ŎgpCHmۂtO(CHORUS)
		return &wk->waveout_ch_chorus_flag;

	case SND_W_ID_CHORUS_FLAG:					//R[XgptO
		return &wk->chorus_flag;

	case SND_W_ID_BANK_FLAG:					//oN؂ւ邩tO
		return &wk->bank_flag;

	case SND_W_ID_FILTER_SIZE:					//tB^[TCY
		return &wk->filter_size;

	case SND_W_ID_SCENE_MAIN:					//݂̃CV[
		return &wk->scene_main;

	case SND_W_ID_SCENE_SUB:					//݂̃TuV[
		return &wk->scene_sub;

	case SND_W_ID_HEAP_SAVE_START:				//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_START];

	case SND_W_ID_HEAP_SAVE_GLOBAL:				//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_GLOBAL];

	case SND_W_ID_HEAP_SAVE_BGM_BANK:			//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_BGM_BANK];

	case SND_W_ID_HEAP_SAVE_SE:					//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_SE];

	case SND_W_ID_HEAP_SAVE_BGM:				//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_BGM];

	case SND_W_ID_HEAP_SAVE_SUB_SE:				//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_SUB_SE];

	case SND_W_ID_HEAP_SAVE_ME:					//TEhq[vKwx
		return &wk->heap_save[SND_HEAP_SAVE_ME];

	case SND_W_ID_PERAP_PLAY_FLAG:				//ybv̘^ĐĂ邩tO
		return &wk->perap_play_flag;

	case SND_W_ID_PERAP_DEFAULT_FLAG:			//ybṽftHg̖ĐtO
		return &wk->perap_default_flag;

	case SND_W_ID_ZONE_BGM:						//][BGMio[
		return &wk->zone_bgm;

	case SND_W_ID_WAVE_DATA:					//g`f[^̃|C^
		return &wk->wave_data;

	case SND_W_ID_REVERSE_BUF:					//tĐp̃obt@̃|C^
		return &wk->reverse_buf;

	case SND_W_ID_LENGTH_TCB:					//ĐTCB
		return &wk->length_tcb;

	case SND_W_ID_MY_PERAP_PTR:					//̂؃bv{CX̃|C^
		return &wk->my_perap_ptr;

	case SND_W_ID_PERAP_PTR1:					//؃bv{CX̃|C^
		return &wk->perap_ptr[0];

	case SND_W_ID_PERAP_PTR2:					//؃bv{CX̃|C^
		return &wk->perap_ptr[1];

	case SND_W_ID_PERAP_PTR3:					//؃bv{CX̃|C^
		return &wk->perap_ptr[2];

	case SND_W_ID_PERAP_PTR4:					//؃bv{CX̃|C^
		return &wk->perap_ptr[3];
	};

	GF_ASSERT( (0) && "słI" );
	return NULL;
}


//==============================================================================================
//
//	q[v֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	̏Ԃۑ
 *
 * @param	heap_lv		ۑ̏Ԃ̊KwxƂĂ[Nւ̃|C^
 *						(NULLƉȂ)
 *
 * @retval	"ۑ̊KwxAs-1"
 *
 * q[v쐬̊Kwx0ŁÅ֐ĂԖɁAKwxP܂B 
 * NNS_SndHeapLoadState֐ĂтƂŁA
 * w肵Kwx̕ۑ̏Ԃɕ邱Ƃł܂B 
 *
 * Ԃ̕ۑɂ́Aq[v܂Bq[v̋󂫗eʂȂꍇ́A֐Ɏs܂B 
 */
//--------------------------------------------------------------
int Snd_HeapSaveState( int* heap_lv )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

	ret = NNS_SndHeapSaveState(wk->heap);

	//s`FbN
	if( ret == -1 ){
		GF_ASSERT( (0) && "NNS_SndHeapSaveState ERRORI" );
	}

	if( heap_lv != NULL ){
		*heap_lv = ret;
	}

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "ԕۑɂ̓q[v܂\nۑ̊Kwx = %d\n", ret );
	Snd_UseHeapSizeOsPrint();						//ԕۑɂ̓q[v
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	̏Ԃ𕜌
 *
 * @param	level	Kwx
 *
 * @retval	none
 *
 * NNS_SndHeapSaveState֐Ă񂾒̏Ԃɖ߂Ƃo
 * Ȃ킿ANNS_SndHeapSaveState֐Ă񂾌Ƀ[hf[^폜
 * ̎A[hς݃TEhf[^gčĐĂ鉹͎~܂܂
 */
//--------------------------------------------------------------
void Snd_HeapLoadState( int level )
{
	SND_WORK* wk = Snd_GetSystemAdrs();

	NNS_SndHeapLoadState( wk->heap, level );

#ifdef SOUND_OS_PRINT_ON
	Snd_UseHeapSizeOsPrint();	//ǉTEhq[v̗eʂo͂
#endif

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ǉTEhq[v̗eʂƁA󂫗eʂo͂
 *
 * @param	none
 *
 * @retval	none
 *
 * vC[q[vmۂƁA̕eʂĂ̂ŒӁI
 */
//--------------------------------------------------------------
void Snd_UseHeapSizeOsPrint(void)
{
	u32 size;
	SND_WORK* wk = Snd_GetSystemAdrs();

#ifdef SOUND_OS_PRINT_ON
	size = NNS_SndHeapGetFreeSize( wk->heap );							//݂̋󂫗eʂ擾

	//TCYr
	if( aki_size < size ){
		OS_Printf( "JTEhq[v = %d\n", (size-aki_size) );//Jeʂ\
	}else if( aki_size == size ){
		OS_Printf( "TEhq[vʂɕωȂ\n" );
	}else{
		OS_Printf( "ǉTEhq[v = %d\n", (aki_size-size) );//ǉeʂ\
	}

	aki_size = size;
	OS_Printf( "TEhq[v̋󂫗e = %d\n\n", aki_size );			//󂫗eʂ\
#endif
	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhq[ṽAhX擾
 *
 * @param	none
 *
 * @retval	"TEhq[ṽAhX"
 */
//--------------------------------------------------------------
NNSSndHeapHandle* Snd_HeapHandleGet(void)
{
	SND_WORK* wk = Snd_GetSystemAdrs();
	return &wk->heap;
}


//==============================================================================================
//
//	f[^[h֘A
//
//	snd_tool.c
//	FILED,BATTLEȂǂ̃f[^Zbg֐ɌĂ΂
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	O[v[h
 *
 * @param	no		O[vio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_ArcLoadGroup( u16 no )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

	ret = NNS_SndArcLoadGroup( no, wk->heap );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "O[v[h O[vNo = %d =TRUEAs=FALSE =%d\n", no, ret );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXf[^AoNf[^Ag`f[^()Ƀ[h
 *
 * @param	no		V[PXio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_ArcLoadSeq( u16 no )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

    ret = NNS_SndArcLoadSeq( no, wk->heap );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "V[PX[h V[PXNo = %d =TRUEAs=FALSE =%d\n", no, ret );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXf[^AoNf[^Ag`f[^(I)[h
 *
 * @param	no		V[PXio[
 * @param	flag	ǂ̃f[^[h邩
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * [h`
 * V[PXf[^	NNS_SND_ARC_LOAD_SEQ 
 * oNf[^		NNS_SND_ARC_LOAD_BANK
 * g`A[JCu	NNS_SND_ARC_LOAD_WAVE
 */
//--------------------------------------------------------------
BOOL Snd_ArcLoadSeqEx( u16 no, u32 flag )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

    ret = NNS_SndArcLoadSeqEx( no, flag, wk->heap );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "V[PX[hꁄ V[PXNo = %d =TRUEAs=FALSE =%d\n", no, ret );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXA[JCu[h
 *
 * @param	no		V[PXA[JCuio[
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * V[PXA[JCúÃoNƊ֘A邽߁A
 * IɃoNf[^g`f[^̓[hȂ
 */
//--------------------------------------------------------------
BOOL Snd_ArcLoadSeqArc( u16 no )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

    ret = NNS_SndArcLoadSeqArc( no, wk->heap );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "V[PXARC[h SEQ_ARCNo = %d =TRUEAs=FALSE =%d\n", no, ret );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	g`A[JCu[h
 *
 * @param	no		g`A[JCuio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_ArcLoadWaveArc( u16 no )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

    ret = NNS_SndArcLoadWaveArc( no, wk->heap );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf("g`A[JCu[h oNNo = %d =TRUEAs=FALSE =%d\n", no, ret );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	oNf[^[h(KvȔg`f[^[h)
 *
 * @param	no		oNio[
 * @param	heap	q[vAhX
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_ArcLoadBank( u16 no )
{
	int ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

    ret = NNS_SndArcLoadBank( no, wk->heap );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "oN[h oNNo = %d =TRUEAs=FALSE =%d\n", no, ret );
	Snd_UseHeapSizeOsPrint();							//ǉTEhq[v̗eʂo͂
#endif

	return ret;
}


//==============================================================================================
//
//	TEhnhAg`nh֘A
//
//	snd_play.c
//	BGM,ME,SE,PMVOICE̍Đ֐ɌĂ΂
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEhnh̃AhX擾
 *
 * @param	type	TEhnh^Cv
 *
 * @retval	"TEhnh̃AhX"
 */
//--------------------------------------------------------------
NNSSndHandle * Snd_HandleGet( int type )
{
	SND_WORK* wk = Snd_GetSystemAdrs();

	if( type >= SND_HANDLE_MAX ){
		GF_ASSERT( (0) && "TEhnh^CvsłI" );
		type = SND_HANDLE_FIELD;
	}

	return &wk->Handle[type];
}

//--------------------------------------------------------------
/**
 * @brief	vC[io[Anhio[擾(nh̃AhXł͂Ȃ̂ŒӁI)
 *
 * @param	player_no	vC[io[
 *
 * @retval	"nhio["
 */
//--------------------------------------------------------------
int Snd_GetHandleNoByPlayerNo( int player_no )
{
	int type;

	//SEnhio[擾
	switch( player_no ){

	case PLAYER_FIELD:
		type = SND_HANDLE_FIELD;				//tB[hBGMTEhnh
		break;
		
	case PLAYER_PV:
		type = SND_HANDLE_PMVOICE;				//|PTEhnh
		break;

	case PLAYER_ME:
		type = SND_HANDLE_ME;					//METEhnh
		break;

	case PLAYER_SE_1:
		type = SND_HANDLE_SE_1;
		break;

	case PLAYER_SE_2:
		type = SND_HANDLE_SE_2;
		break;

	case PLAYER_SE_3:
		type = SND_HANDLE_SE_3;
		break;

	case PLAYER_SE_4:
		type = SND_HANDLE_SE_4;
		break;

	case PLAYER_BGM:
		type = SND_HANDLE_BGM;					//tB[hȊOBGMnh
		break;

	//case PLAYER_CHORUS:						//PLAYERƂĂ݂͑ȂI
	//	type = SND_HANDLE_CHORUS;				//R[X(p)nh
	//	break;

	default:
		GF_ASSERT( (0) && "vC[io[słI" );
		type = SND_HANDLE_SE_1;					//G[
		break;
	};

	return type;
}


//==============================================================================================
//
//	V[PX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	SĂ̍Đ̃V[PXꎞ~܂͍ĊJ
 *
 * @param	flag	TRUE=ꎞ~AFALSE=ĊJ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 * ԂςȂꍇAႦ΁AłɈꎞ~Ԃ̎Ɉꎞ~sĂA܂B 
 *
 * 
 * ꎞ~sƁẢ͋Iɒ~܂B
 * ĊJsĂẢĐ邱Ƃ͂܂̂ŒӂĂB
 * ĊJ́Ãm[gI特n߂܂B 
 */
//--------------------------------------------------------------
void Snd_PlayerPauseAll( BOOL flag )
{
	NNS_SndPlayerPauseAll( flag );
	return;
}


//==============================================================================================
//
//	[J֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEhVXe[N̏
 *
 * @param	wk		SND_WORK^̃AhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_WorkInit( SND_WORK* wk )
{
	int i;

	memset( wk, 0, sizeof(SND_WORK) );

	//Kwx
	for( i=0; i < SND_HEAP_SAVE_MAX ;i++ ){
		//Jn=1,풓=2,BGM_BANK=3,SE=4,BGM=5,SUB_SE=6,ME=7
		wk->heap_save[i] = (i+1);						//lZbg
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TEhnh
 *
 * @param	wk		SND_WORK^̃AhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_HandleInit( SND_WORK* wk )
{
	int i;

	for( i=0; i < SND_HANDLE_MAX ;i++ ){
		NNS_SndHandleInit( &wk->Handle[i] );
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	Q[JñTEhf[^̃[h
 *
 * @param	wk		SND_WORK^̃AhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_GameStartLoad( SND_WORK* wk )
{
	int ret;

	//O[v[h(=TRUEAs=FALSE)
	
	Snd_HeapSaveState(&wk->heap_save[SND_HEAP_SAVE_START]);		//Kwۑ(SďɎgp)
	ret = Snd_ArcLoadGroup( GROUP_GLOBAL );	//풓

	//basic.bnḱAS풓ɂĂ
	
	Snd_HeapSaveState(&wk->heap_save[SND_HEAP_SAVE_GLOBAL]);	//Kwۑ(풓ȊOɎgp)

	//́A^CgȂǂݍނƂɂȂI
	//V[()ς鎞̃TEhf[^Zbg
	//Snd_SceneDataSet( SND_SCENE_FIELD, SEQ_DP_TITLE, 0 );
	//title.cɓĂ̂ŊO

	return;
}

//--------------------------------------------------------------
/**
 * @brief	}CN(Ƃ肠QCȂǌŒ)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_MicInit(void)
{
	//MIC_Init֐̏́A2ڈȍ~̌Ăяo͖ɂȂ悤ɁA
	//tOŃ`FbNĂ܂
    MIC_Init();								//MIC_API
    
	//OS_Init()Ăԏꍇ́A̒Ă΂܂̂ŕKv܂B
    //PM_Init();							//PMIC}l[W(OS_INITłĂ΂Ă)
	
    (void)PM_SetAmp( PM_AMP_ON );			//vO}uQCAṽXCb`ON
    (void)PM_SetAmpGain( PM_AMPGAIN_80 );	//vO}uQCAṽQCݒ

	return;
}

//--------------------------------------------------------------
/**
 * @brief	PLAYER_BGM̒~
 *
 * @param	none
 *
 * @retval	none
 *
 * TEhnhɌтĂV[PX܂B
 * V[PXтĂȂꍇ́A܂B
 *
 * PLAYERɑ΂Ă̂ݒ~A[XĂ
 */
//--------------------------------------------------------------
static void Snd_PlayerBgmStop( void )
{
	NNS_SndPlayerStopSeqByPlayerNo( PLAYER_BGM, 0 );
	NNS_SndHandleReleaseSeq( Snd_HandleGet(SND_HANDLE_BGM) );
	return;
}


