//============================================================================================
/**
 * @file	startmenu.c	
 * @bfief	^Cgj[
 * @author	Satoshi Mitsuhara
 * @date	06.04.11
 *
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/main.h"
#include "system/wipe.h"
#include "system/wordset.h"
#include "system/msgdata_util.h"
#include "system/arc_util.h"
#include "system/window.h"
#include "system/snd_tool.h"
#include "system/snd_play.h"
#include "system/render_oam.h"

#include "gflib/bg_system.h"
#include "gflib/rebooter.h"

#include "savedata/savedata.h"
#include "savedata/zukanwork.h"
#include "savedata/playtime.h"
#include "savedata/fushigi_data.h"
#include "savedata/system_data.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_startmenu.h"
#include "msgdata/msg_bconfind.h"

#include "communication/comm_state.h"

#include "../fushigi/agbpoke_access.h"
#include "../fushigi/mysterylib.h"
#include "../fushigi/agbdownload.h"
#include "../fushigi/mystery.naix"

#include "msgdata/msg_wifi_system.h"
#include "wifi/dwc_rap.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
#include "application/backup.h"
#endif
// ----------------------------------------------------------------------------

/*
 * K\郁j[
 *
 *	Â͂߂
 *	傩͂߂
 *	WiFiĂ
 *
 * J[gbWhĂƕ\郁j[
 *
 *	ȂƂƂĂ(r[/Tt@CA/...)
 *
 * ɂĕ\郁j[
 *
 *	|PW[Ƃ
 *	WiiƂ̂
 *
 * j[Iɐڑ
 *
 *	_CNg
 *	WiFi
 *	r[R
 *
 */
/*
  ^Cgj[̍ŏ̎_ł肢܂B
  WIFȈ֐Ȃ̂łÅ֐̖߂l
  DWC_INIT_RESULT_DESTROY_OTHER_SETTING@̏ꍇɁA
  bZ[WoĂ̂łB
  Ȃ݂ɂ̃G[DS{̂̒ʐM񂪉ꂽꍇɏo܂B

  #include "msgdata/msg_wifi_system.h"
  #include "wifi/dwc_rap.h"

  ret = mydwc_init(HEAPID_BASE_APP);
  if(ret == DWC_INIT_RESULT_DESTROY_OTHER_SETTING){
    message (  dwc_message_0001 );
  }

  PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL Ŗ{̃^Cgֈړ

  ɂȂ܂B
*/

//
// BG0 - j[\
// BG1 - r[REۂɕ\郁j[(ꎞI\̂)
// BG2 - ʐMACR(BG0ƈꏏɃXN[)
//

#define WIICLIENT_FILE		"data/eoo.dat"

#define STARTMENU_FCHR1		1			// ʏt[
#define STARTMENU_FCOL1		2
#define STARTMENU_FCHR2		(STARTMENU_FCHR1 + 9)	// It[
#define STARTMENU_FCOL2		3


#define STARTMENU_WCHR		(STARTMENU_FCHR2 + 9)
#define STARTMENU_WCOL_SELECT	0
#define STARTMENU_WCOL_NORMAL	1

#define STARTMENU_WICON_PAL	4

#define STARTMENU_NOSELECT	-1

#define STARTMENU_FIRSTGAME_SELECT	0x80

#define RGB(r, g, b)	(((b)&31)<<10|((g)&31)<<5|((r)&31))

enum {
  // CV[PX
  STARTMENU_SEQ_INIT,
  STARTMENU_SEQ_CHECK_SYSTEM,		// eVXe`FbN
  STARTMENU_SEQ_DISP_ERROR,
  STARTMENU_SEQ_HARDINIT,
  STARTMENU_SEQ_CREATE_SCREEN,		// XN[쐬({`)
  STARTMENU_SEQ_MAIN,
  STARTMENU_SEQ_SELECT_FIRSTGAME,

  STARTMENU_SEQ_SELECT_MENU,		// j[Iꂽ̏

  STARTMENU_SEQ_FADE_WAIT,
  STARTMENU_SEQ_FINISH,			// 

  // r[R擾V[PX
  STARTMENU_BEACON_SEQ_INIT,		// 
  STARTMENU_BEACON_SEQ_INIT2,		// 
  STARTMENU_BEACON_SEQ_WAIT,		// CǂƂ܂ő҂
  STARTMENU_BEACON_SEQ_TIMER,		// ۂ̃r[RW
  STARTMENU_BEACON_SEQ_CANCEL,		// LZ[h

  // r[R擾̃bZ[W\
  BEACON_MSGSEQ_NOP,			// Ȃ
  BEACON_MSGSEQ_INIT,			// 
  BEACON_MSGSEQ_INIT_DISP,		// XN[
  BEACON_MSGSEQ_INIT_MAIN,		// L[͑҂
  BEACON_MSGSEQ_INIT_FINISH,		// I
  BEACON_MSGSEQ_FADE_WAIT,		// tF[h҂
  
  STARTMENU_SEQ_MAX
};


typedef struct _STARTMENU_DATA {
  int mark;
  int height;
  int msgid;
  // \ɌĂяot@NV
  BOOL (*func)(void */* STARTMENU_WORK */, int, MYSTERY_WIN *, int);
} STARTMENU_DATA;


static BOOL StartMenuAgbPokemon(void *, int, MYSTERY_WIN *, int);
static BOOL StartMenuCheckMystery(void *, int, MYSTERY_WIN *, int);
static BOOL StartMenuCheckRanger(void *, int, MYSTERY_WIN *, int);
static BOOL StartMenuCheckWii(void *, int, MYSTERY_WIN *, int);
static BOOL StartMenuSetWifi(void *, int, MYSTERY_WIN *, int);
static BOOL StartMenuContinue(void *, int, MYSTERY_WIN *, int);

enum {
  SEL_CANCEL = 0,
  SEL_CONTINUE,
  SEL_FIRSTGAME,
  SEL_MYSTERY,
  SEL_RANGER,
  SEL_AGBPOKEMON,
  SEL_WII,
  SEL_WIFI,
  SEL_MAX
};

enum {
  STARTMENU_DWC_ERROR = 0,		// DS{̂̒ʐM񂪉Ă
  STARTMENU_ERROR_MAX
};

typedef struct {
  int sx, sy, width, height;
  u32 arc, msgid;
  void (*func)(void */*STARTMENU_WORK* */);
} ERRORTABLE;

// QZbg̃G[\bZ[W
static ERRORTABLE ErrorMsgTable[] = {
  { 5, 5, 22, 14, NARC_msg_wifi_system_dat, dwc_message_0001, NULL/*DispErrorDwc*/ },
};


STARTMENU_DATA StartMenuWinTable[] = {
  // Â ͂߂
  { SEL_CONTINUE,   10, mes_startmenu_01,	StartMenuContinue },
  // 傩@͂߂
  { SEL_FIRSTGAME,   2, mes_startmenu_02,	NULL },
  // ӂȁ@
  { SEL_MYSTERY,     2, mes_startmenu_03,	StartMenuCheckMystery },
  // |PW[Ƃ́@
  { SEL_RANGER,      2, mes_startmenu_04, 	StartMenuCheckRanger },
  // ~~~@Ă
  { SEL_AGBPOKEMON,  2, NULL, 			StartMenuAgbPokemon },
  // WiiƁ@
  { SEL_WII,         2, mes_startmenu_11, 	StartMenuCheckWii },
  // Wi-FiĂ
  { SEL_WIFI,        2, mes_startmenu_12, 	StartMenuSetWifi },
};


static u32 StartMenuContinueTable[] = {
  mes_startmenu_01,			// Â@͂߂
  mes_startmenu_13,			// ザ񂱂
  mes_startmenu_14,			// vC
  mes_startmenu_16,			// ĂobW
  mes_startmenu_15,			// |P
};

// r[REƂ̃bZ[Wf[^
typedef struct {
  int sx, sy;
  int width, height;
  int msg;
} BEACON_MSG_TABLE;
BEACON_MSG_TABLE BeaconMsgTable[] = {
  { 4, 2, 24, 20, bcon_002 },		// ӂȂ̂𔭌Bj[őIł
  { 4, 4, 24, 16, bcon_004 },		// ӂȂ̂𔭌Bł܂_
  { 4, 1, 24, 22, bcon_001 },		// W[𔭌Bj[őIł
  { 4, 3, 24, 18, bcon_003 },		// W[𔭌Bł܂_
  // ꂾj[IbZ[W
  { 2, 1, 28, 22, bcon_006 },		// 傩͂߂ĂZ[ułH
};



// j[̍ő吔
#define MENU_WIN_MAX	(sizeof(StartMenuWinTable) / sizeof(STARTMENU_DATA))

// r[RW߂鎞
#define BEACON_GATHER_TIME	(2*60)

#define SetSeq(w, n)	(w = n)


typedef struct {
  GF_BGL_INI *bgl;
  SAVEDATA *sv;
  ZUKAN_WORK *zw;
  MYSTATUS *mst;
  PLAYTIME *ptime;
  FUSHIGI_DATA *fdata;				// ӂf[^ǂ񂾏ꏊ

  // CV[PX֌W

  int jiffy;
  int next_seq;
  int chrbase;			       	// EBhẼLN^x[X

  int agbpokemon;     			// hĂAGBJZbg̃^Cv(CASTYPE_xxx)
  int agbpokemoncheck;
  int pokemonranger;			// |PW[𔭌
  int wii;				// Wiĩr[R𔭌
  int mystery;				// ӂȁ@̃r[R

  int menu_flag;			// er[Rj[\H(PARTYGAME_xxx)
  int new_menu_flag;
  
  
  int beacon_status;
  int beacon_disp_status;
  int redrawflag;
  
  int zukangetflag;			// ĂȂTRUE
  int badgecount;			// Ăob`̐


  int cursor;				// ݂̃J[\ʒu

  int select;				// Iꂽ(-1ȂΉIĂȂ)
  
  GF_BGL_BMPWIN mwin[MENU_WIN_MAX];
  int menuflag[MENU_WIN_MAX];		// \ĂTRUE(default = FALSE)
  int iconflag[MENU_WIN_MAX];		// CXACR鎞TRUE

  fx32 scrolly;				// ݂̃XN[l
  fx32 target;				// ړIW

  // r[R擾֌W
  int beacon_seq;
  int beacon_wait;
  int beacon_msg_seq;			// r[R擾ɕ\郁bZ[WV[PX
  int beacon_msg_wait;
  int beacon_key_wait;
  int beacon_result;
  GF_BGL_BMPWIN beacon_win;
  
  int pass_start_menu;			// TRUEȂ΃X^[gj[\Ȃ
  int req_popup;

  // G[
  BOOL errorflag[STARTMENU_ERROR_MAX];
  GF_BGL_BMPWIN ewin;
  
  // J[\AN^[
  CLACT_WORK_PTR clcursor[2];		// 0 = @1 = 

  int anim_index;
} STARTMENU_WORK;






//============================================================================================
//	O֐`
//============================================================================================
extern FUSHIGI_DATA * SaveData_GetFushigiData(SAVEDATA * sv);
extern int CommPlayerNowFlagDataArraySize(void);
extern int MyStatus_GetWorkSize(void);
extern void CreateIndexData(int heapid);

//============================================================================================
//	萔`
//============================================================================================


//------------------------------------------------------------------
/**
 * @brief	VXeG[`FbN
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static int StartMenuCheckSystem(STARTMENU_WORK *wk)
{
  int max, ret;
  
  max = 0;
#if 0  //mainŌĂт܂̂ŁA͏܂
  // DS{̂̒ʐM񂪉ĂȂ`FbN
  ret = mydwc_init(HEAPID_BASE_APP);
#if 0	// fobOpł
  ret = DWC_INIT_RESULT_DESTROY_OTHER_SETTING;
#endif
  if(ret == DWC_INIT_RESULT_DESTROY_OTHER_SETTING){
    wk->errorflag[STARTMENU_DWC_ERROR] = TRUE;
    max++;
  }
#endif
  return max;
}


//------------------------------------------------------------------
/**
 * @brief	G[\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL StartMenuDisplayError(STARTMENU_WORK *wk)
{
  int i;
  ERRORTABLE *et;
  MYSTERY_WIN mw;

  // G[\EBhEĂ邩ǂŔfs
  if(GF_BGL_BmpWinAddCheck(&wk->ewin) == FALSE){
    for(i = 0; i < STARTMENU_ERROR_MAX; i++){
      if(wk->errorflag[i] == TRUE){
	wk->errorflag[i] = FALSE;
	et = &ErrorMsgTable[i];
	//ŃG[\s
	MysteryLib_WinInit1(&mw, &wk->ewin, STARTMENU_WCOL_SELECT, et->arc, STARTMENU_FCHR1, STARTMENU_FCOL1);
	MysteryLib_WinInit2(&mw, et->width, et->height, /*et->msgid,*/ STARTMENU_WCHR);
	MysteryLib_CreateWin(wk->bgl, &mw, et->sx, et->sy, et->msgid);
	return TRUE;
      }
    }
  } else {
    // G[EBhE̕\
    if(sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)){
      Snd_SePlay(SEQ_SE_DP_SELECT);
      BmpMenuWinClear(&wk->ewin, WINDOW_TRANS_ON);
      GF_BGL_BmpWinDel(&wk->ewin);
    }
    return TRUE;
  }



  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	`faJZbghĂ邩
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void AgbCartridgeInit(STARTMENU_WORK *wk)
{
  int pmv;
  int flag = agbpoke_init(NULL);

  wk->agbpokemon = FALSE;
  
  // AGB|PhĂȂΉȂ
  if(flag != AGBPOKE_ERROR_OK)
    return;

  // VXeփJZbg^Cvʒm
  pmv = 0;	// unknown
  switch(agbpoke_getPokemonType()){
  case CASTYPE_RUBY:	pmv = VERSION_RUBY;	break;
  case CASTYPE_SAPPHIRE:pmv = VERSION_SAPPHIRE; break;
  case CASTYPE_GREEN:	pmv = VERSION_GREEN;	break;
  case CASTYPE_RED:	pmv = VERSION_RED;	break;
  case CASTYPE_EMERALD:	pmv = VERSION_EMERALD;	break;
  }
  sys_InitAgbCasetteVer(pmv);
#ifdef DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("AGBJZbgo[W: %d\n", pmv);
#endif

#ifndef DEBUG_ONLY_FOR_mituhara
  // DP̑S񃂁[hONɂȂĂȂ΃|PJZbg̃j[͕\Ȃ
  if(ZukanWork_GetZenkokuZukanFlag(wk->zw) == FALSE)
    return;
#endif

  // DPƓłȂ΃j[͕\Ȃ
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/25
// AGBłȂ؍łł͓{łF
// localize_spec_mark(LANG_KOREA) imatake 2007/09/18
// ؍łł͉pAGBF悤
#if PM_LANG == LANG_KOREA
  if(agbpoke_getPokemonLanguage() != LANG_JAPAN && agbpoke_getPokemonLanguage() != LANG_ENGLISH)
#else
  if(agbpoke_getPokemonLanguage() != CasetteLanguage)
#endif
// ----------------------------------------------------------------------------
    return;

  // |P̃^Cvݒ肷
  wk->agbpokemon = agbpoke_getPokemonType() + 1;

#if 0
  // RTCt̃J[gbWŁARTC̓dr؂ꂽ̂͏OS_IE_CARTRIDGE荞݂
  // |Ă܂߁A^Cgʂł̓J[gbWȂ
  // u~~~@ĂvIɒ~悤ɂ
  // 2006.08.10(}X^[Abv)

  /* AGBJ[gbW̔oON */
  MysteryLib_SetAgbCartridgeIntr(TRUE);
#else
  /* X[ṽJ[gbWLɂ邽߂̊֐Ăяo */
  MysteryLib_SetAgbCartridgeIntr2();
#endif
}


//------------------------------------------------------------------
/**
 * @brief	r[R擾vZX
 * 		threadɂȂĂ킯ł͂܂
 */
//------------------------------------------------------------------
static void StartMenuBeacon_Proc(STARTMENU_WORK *wk)
{
  int flag;

  switch(wk->beacon_seq){
  case STARTMENU_BEACON_SEQ_WAIT:
    // OV[PXύXȂ蓮Ȃ
    break;

  case STARTMENU_BEACON_SEQ_INIT:
    wk->beacon_seq = STARTMENU_BEACON_SEQ_INIT2;
    break;
  case STARTMENU_BEACON_SEQ_INIT2:
    // * p[eB[Q[̒ʐMJniq@Ԃ̂݁j
    CommStateEnterPartyGameScanChild(wk->sv);
    wk->beacon_wait = BEACON_GATHER_TIME;
    wk->beacon_seq = STARTMENU_BEACON_SEQ_TIMER;
    wk->beacon_status = 0;
    // łɁuӂȁ@́vj[\Ă|bvAbv͂Ȃ
    if(FUSHIGIDATA_IsFushigiMenu(wk->fdata) == TRUE){
      wk->beacon_status |= PARTYGAME_MYSTERY_BCON;
      wk->beacon_disp_status |= PARTYGAME_MYSTERY_BCON;
    }
    
    break;

  case STARTMENU_BEACON_SEQ_TIMER:
    // łɃ|bvAbv\
    if(wk->beacon_msg_wait)	break;
    // r[RW
    flag = CommStateGetPartyGameBit();

#ifdef DEBUG_ONLY_FOR_mituhara
    // fobO
#if 1
    if(sys.trg & PAD_BUTTON_L)	flag |= PARTYGAME_RANGER_BCON;
    if(sys.trg & PAD_BUTTON_R)	flag |= PARTYGAME_WII_BCON;
    if(sys.trg & PAD_BUTTON_Y)	flag |= PARTYGAME_MYSTERY_BCON;
#else
    flag |= PARTYGAME_RANGER_BCON;
    flag |= PARTYGAME_WII_BCON;
    flag |= PARTYGAME_MYSTERY_BCON;
#endif
#endif
    
    // O܂ŕ\ĂȂrbĝݗĂ
    flag = ~wk->beacon_status & flag;
    // ̃r[REĂāA荞݃bZ[W\łȂāAłɗ\ς݂łȂāA܂\ĂȂꍇ
    if(flag && wk->beacon_msg_seq == BEACON_MSGSEQ_NOP && wk->beacon_msg_wait == 0 && wk->beacon_status != flag){
      wk->redrawflag = TRUE;
      if(flag & PARTYGAME_MYSTERY_BCON)	wk->mystery = TRUE,		flag = PARTYGAME_MYSTERY_BCON;
      if(flag & PARTYGAME_RANGER_BCON)	wk->pokemonranger = TRUE,	flag = PARTYGAME_RANGER_BCON;
      if(flag & PARTYGAME_WII_BCON)	wk->wii = TRUE,			flag = PARTYGAME_WII_BCON;
      // ӂr[RƃW[r[Ȑꍇ͊荞݃bZ[W\
      if(flag & (PARTYGAME_MYSTERY_BCON|PARTYGAME_RANGER_BCON))
	wk->req_popup = TRUE;
      // ł悤₭\ς݃tO̍XV
      wk->beacon_status |= flag;
    }
    if(--wk->beacon_wait == 0){
      // p[eB[Q[T[`̏I
      CommStateExitPartyGameScan();
      wk->beacon_seq = STARTMENU_BEACON_SEQ_WAIT;
    }
    break;

  case STARTMENU_BEACON_SEQ_CANCEL:
    // I(Q[JnꂽƂ)
    CommStateExitPartyGameScan();
    wk->beacon_seq = STARTMENU_BEACON_SEQ_WAIT;
    break;
  }
}


//------------------------------------------------------------------
/**
 * @brief	r[R擾ۂɕ\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL BeaconMessage_Proc(STARTMENU_WORK *wk)
{
  MYSTERY_WIN mw;
  BEACON_MSG_TABLE *tbl;
  int msg, status;

  switch(wk->beacon_msg_seq){
  case BEACON_MSGSEQ_NOP:
    if(wk->beacon_msg_wait == 0)	return FALSE;
    // r[REĂ琔t[ɔ
    if(--wk->beacon_msg_wait == 0)
      wk->beacon_msg_seq = BEACON_MSGSEQ_INIT;
    return TRUE;
    break;

  case BEACON_MSGSEQ_INIT:
    // 
    MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME1_M, STARTMENU_FCHR1, STARTMENU_FCOL1, 0, HEAPID_STARTMENU);
    GF_BGL_ScrClear(wk->bgl, GF_BGL_FRAME1_M);
    *((u16 *)HW_BG_PLTT + 33) = RGB(26, 26, 26);
    wk->beacon_msg_seq = BEACON_MSGSEQ_INIT_DISP;
    break;

  case BEACON_MSGSEQ_INIT_DISP:
    // XN[
    MysteryLib_WinInit1(&mw, &wk->beacon_win, STARTMENU_WCOL_SELECT, NARC_msg_bconfind_dat, STARTMENU_FCHR1, STARTMENU_FCOL1);

    // Px\j[͕\Ȃ߂ɕ\tOoĂ
    status = wk->beacon_status & ~wk->beacon_disp_status;

    if(status & PARTYGAME_MYSTERY_BCON){
      if(wk->menu_flag & PARTYGAME_MYSTERY_BCON)	tbl = &BeaconMsgTable[0];	// ӂǉ
      else						tbl = &BeaconMsgTable[1];	// ǉłȂ
    } else if(status & PARTYGAME_RANGER_BCON){
      if(wk->menu_flag & PARTYGAME_RANGER_BCON)		tbl = &BeaconMsgTable[2];	// W[ǉ
      else						tbl = &BeaconMsgTable[3];	// ǉłȂ
    } else if(status & STARTMENU_FIRSTGAME_SELECT){
      tbl = &BeaconMsgTable[4];	// 傩͂߂񂾎̃bZ[W
      status = 0;	// xł\̂ŊoȂ
    }
    wk->beacon_disp_status |= status;

    MysteryLib_WinInit2(&mw, tbl->width, tbl->height, STARTMENU_WCHR);
    mw.screen = GF_BGL_FRAME1_M;
    MysteryLib_CreateWin(wk->bgl, &mw, tbl->sx, tbl->sy, tbl->msg);

    GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME1_M,
			GF_BGL_BmpWinGet_PosX(mw.win),  GF_BGL_BmpWinGet_PosY(mw.win),
			GF_BGL_BmpWinGet_SizeX(mw.win), GF_BGL_BmpWinGet_SizeY(mw.win),
			STARTMENU_WCOL_SELECT);
    
    GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG0, VISIBLE_OFF);
    GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG2, VISIBLE_OFF);
    GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG1, VISIBLE_ON);
    wk->beacon_key_wait = 30;
    wk->beacon_msg_seq = BEACON_MSGSEQ_INIT_MAIN;
    break;

  case BEACON_MSGSEQ_INIT_MAIN:
    // L[͑҂
    if(wk->beacon_key_wait){
      wk->beacon_key_wait--;
    } else {
      if(sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)){
	GF_BGL_BmpWinDel(&wk->beacon_win);
	wk->beacon_msg_seq = BEACON_MSGSEQ_INIT_FINISH;
	wk->beacon_result = sys.trg;
	Snd_SePlay(SEQ_SE_DP_SELECT);
      }
    }
    break;

  case BEACON_MSGSEQ_INIT_FINISH:
    // I
    GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG0, VISIBLE_ON);
    GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG2, VISIBLE_ON);
    GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG1, VISIBLE_OFF);
    wk->beacon_msg_seq = BEACON_MSGSEQ_NOP;
    break;
  }
  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	t[s
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
// 򂵂ȂABS
#define ABS(x)		(((x) ^ ((x)>>31)) - ((x)>>31))
#define SCROLL_MAX_SPEED	(12 * FX32_ONE)
static void StartMenuProc(STARTMENU_WORK *wk)
{
  fx32 speed;

  // XN[
  if(wk->scrolly != wk->target){
    speed = (wk->target - wk->scrolly) / 4;
    if(ABS(speed) > SCROLL_MAX_SPEED){
      if(speed > 0)	speed =  SCROLL_MAX_SPEED;
      else		speed = -SCROLL_MAX_SPEED;
    }
    wk->scrolly += speed;

    if(ABS(wk->target - wk->scrolly) < FX32_ONE/8)
      wk->scrolly = wk->target;

    GF_BGL_ScrollReq(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCROLL_Y_SET, wk->scrolly / FX32_ONE);
    GF_BGL_ScrollReq(wk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCROLL_Y_SET, wk->scrolly / FX32_ONE);
  } 
}

//------------------------------------------------------------------
/**
 * @brief	XN[
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void InitStartMenuScreen(STARTMENU_WORK *wk)
{
  GF_BGL_DISPVRAM tbl = {
    GX_VRAM_BG_128_A,				// C2DGWBG
    GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
    GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
    GX_VRAM_SUB_BGEXTPLTT_NONE,			// Tu2DGWBGgpbg
    GX_VRAM_OBJ_64_E,				// C2DGWOBJ
    GX_VRAM_OBJEXTPLTT_NONE,			// C2DGWOBJgpbg
    GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
    GX_VRAM_SUB_OBJEXTPLTT_NONE,		// Tu2DGWOBJgpbg
    GX_VRAM_TEX_0_B,				// eNX`C[WXbg
    GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
  };
  GF_BGL_SYS_HEADER BGsys_data = { GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D };

  GF_Disp_SetBank( &tbl );

  /* BG SYSTEM */
  GF_BGL_InitBG( &BGsys_data );
  /* j[\BG */
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME0_M, GF_BGL_SCRSIZ_256x512, 0xF000, 0x0000); /* MAIN DISP BG0 */
  G2_SetBG0Priority(2);
  GF_BGL_ClearCharSet(GF_BGL_FRAME0_M, 32, 0, HEAPID_STARTMENU);
  /* r[R擾ɕ\郁bZ[WBG */
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME1_M, GF_BGL_SCRSIZ_256x256, 0xD800, 0x8000); /* MAIN DISP BG1 */
  G2_SetBG1Priority(1);
  GF_BGL_ClearCharSet(GF_BGL_FRAME1_M, 32, 0, HEAPID_STARTMENU);
  /* ʐMACR\BG */
  MysteryLib_BgInitFrame(wk->bgl, GF_BGL_FRAME2_M, GF_BGL_SCRSIZ_256x512, 0xE000, 0x0000); /* MAIN DISP BG2 */
  G2_SetBG2Priority(0);
  GF_BGL_ClearCharSet(GF_BGL_FRAME2_M, 32, 0, HEAPID_STARTMENU);

  MSG_PrintInit();

  /* bZ[W̃tHgJ[ݒ */
  SystemFontPaletteLoad(PALTYPE_MAIN_BG, STARTMENU_WCOL_NORMAL * 32, HEAPID_STARTMENU);
  SystemFontPaletteLoad(PALTYPE_MAIN_BG, STARTMENU_WCOL_SELECT * 32, HEAPID_STARTMENU);
  *((u16 *)HW_BG_PLTT +  0) = RGB( 0,  0,  0);

  *((u16 *)HW_BG_PLTT + 31) = RGB(26, 26, 26);	// EBhE̔wi
  //EBhEgLApbgZbg
  MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, STARTMENU_FCHR1, STARTMENU_FCOL1, 0, HEAPID_STARTMENU);
  MenuWinGraphicSet(wk->bgl, GF_BGL_FRAME0_M, STARTMENU_FCHR2, STARTMENU_FCOL2, 1, HEAPID_STARTMENU);
  // IĂȂEBhE̔C
  *((u16 *)HW_BG_PLTT + 33) = RGB(26, 26, 26);

}


//------------------------------------------------------------------
/**
 * @brief	XN[J[\̕\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void StartMenuInitClact(STARTMENU_WORK *wk)
{
  MysteryLib_InitCPManager();
  MysteryLib_InitClactSystem();
  MysteryLib_InitClact(ARC_MYSTERY_GRA,
		       NARC_mystery_title_cursor_lz_cngr,
		       NARC_mystery_title_cursol_nclr,
		       NARC_mystery_title_cursor_lz_ccer,
		       NARC_mystery_title_cursor_lz_canr,
		       GF_BGL_MAIN_DISP);
  wk->clcursor[0] = MysteryLib_MakeCLACT(GF_BGL_MAIN_DISP, wk->clcursor[0],  HW_LCD_WIDTH/2, 8, 0);
  CLACT_SetDrawFlag(wk->clcursor[0], 0);
  wk->clcursor[1] = MysteryLib_MakeCLACT(GF_BGL_MAIN_DISP, wk->clcursor[1],  HW_LCD_WIDTH/2, HW_LCD_HEIGHT - 8, 1);
  CLACT_SetDrawFlag(wk->clcursor[1], 0);
}


//------------------------------------------------------------------
/**
 * @brief	ʐMACR̃OtBbNX
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#define WIRELESS_CHR_BASE		0x0380
static void WirelessIconInit(STARTMENU_WORK *wk)
{
  // Cʂafpbg]
  ArcUtil_PalSet(ARC_MYSTERY_GRA, NARC_mystery_wicon_nclr, PALTYPE_MAIN_BG, STARTMENU_WICON_PAL*32, 32*1, HEAPID_STARTMENU);
  // CBG1L]
  ArcUtil_BgCharSet(ARC_MYSTERY_GRA, NARC_mystery_wicon_ncgr, wk->bgl,
		    GF_BGL_FRAME2_M, WIRELESS_CHR_BASE, 2*32*0x20, 0, HEAPID_STARTMENU);
}


//------------------------------------------------------------------
/**
 * @brief	wWɒʐMACR\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#define WIRELESS_ICON_BASE		((STARTMENU_WICON_PAL << 12) + WIRELESS_CHR_BASE + 0)
static void SetWirelessIcon(STARTMENU_WORK *wk, int sx, int sy, int flag)
{
  u16 *scrn = (u16 *)GF_BGL_ScreenAdrsGet(wk->bgl, GF_BGL_FRAME2_M);
  int base = WIRELESS_ICON_BASE;

  if(flag == 2)	base = WIRELESS_ICON_BASE + 2;
  
  scrn[sy * 32 + sx + 0] = base + 0;
  scrn[sy * 32 + sx + 1] = base + 1;
  sy++;
  scrn[sy * 32 + sx + 0] = base + 8;
  scrn[sy * 32 + sx + 1] = base + 9;
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME2_M);
}
static void ClrWirelessIcon(STARTMENU_WORK *wk, int sx, int sy)
{
  u16 *scrn = (u16 *)GF_BGL_ScreenAdrsGet(wk->bgl, GF_BGL_FRAME2_M);
  scrn[sy * 32 + sx + 0] = WIRELESS_ICON_BASE + 4;
  scrn[sy * 32 + sx + 1] = WIRELESS_ICON_BASE + 4;
  sy++;
  scrn[sy * 32 + sx + 0] = WIRELESS_ICON_BASE + 4;
  scrn[sy * 32 + sx + 1] = WIRELESS_ICON_BASE + 4;
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME2_M);
}


//------------------------------------------------------------------
/**
 * @brief	Â͂߂̓e\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#define STARTMENU_MARGIN_L	32
#define	STARTMENU_BLUE		(GF_PRINTCOLOR_MAKE(7, 8, 15))
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/18
// ؍łł͐ԂsN
#if PM_LANG == LANG_KOREA
#define	STARTMENU_RED		(GF_PRINTCOLOR_MAKE(11, 12, 15))
#else
#define	STARTMENU_RED		(GF_PRINTCOLOR_MAKE(3, 4, 15))
#endif
// ----------------------------------------------------------------------------

static void StartMenuContinueSub1(GF_BGL_BMPWIN *win, MSGDATA_MANAGER *msgman, WORDSET *word, GF_PRINTCOLOR color, u32 msgid, int y)
{
  int width, wsize;
  STRBUF * msg;

  msg = MSGDAT_UTIL_AllocExpandString(word, msgman, msgid, HEAPID_STARTMENU);
  width = FontProc_GetPrintStrWidth(FONT_SYSTEM, msg,	FontHeaderGet(FONT_SYSTEM, FONT_HEADER_SPACE_X));
  wsize = GF_BGL_BmpWinGet_SizeX(win) * 8 - (width + STARTMENU_MARGIN_L);
  GF_STR_PrintColor(win, FONT_SYSTEM, msg, wsize, y, MSG_NO_PUT, color, NULL);
  STRBUF_Delete(msg);
}
static void StartMenuContinueSub2(WORDSET *word, int value)
{
  int keta, type;
  if (value >= 100) { 	keta = 3; 	type = NUMBER_DISPTYPE_LEFT;  }
  else if (value >= 10) {	keta = 3;	type = NUMBER_DISPTYPE_SPACE; }
  else {			keta = 3 - 1;	type = NUMBER_DISPTYPE_SPACE; }
  WORDSET_RegisterNumber(word, 0, value, keta, type, NUMBER_CODETYPE_DEFAULT);
}

static BOOL StartMenuContinue(void *p, int index, MYSTERY_WIN *mw, int y)
{
  int i, width, wsize;
  STRBUF * msg;
  WORDSET *word;
  MSGDATA_MANAGER *msgman;
  STARTMENU_WORK *wk = (STARTMENU_WORK *)p;
  GF_PRINTCOLOR color;

  msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_startmenu_dat, HEAPID_STARTMENU);
  word = WORDSET_Create(HEAPID_STARTMENU);

  // (FEMALE)ȂԁAȊO(MALE, NEUTRAL)Ȃΐ
  if(MyStatus_GetMySex(wk->mst) == PM_FEMALE)	color = STARTMENU_RED;
  else						color = STARTMENU_BLUE;
  
  // ̂Ps\
  MysteryLib_CreateWin(wk->bgl, mw, 3, y, StartMenuWinTable[index].msgid);
  // Qsڈȍ~\
  for(i = 1; i < sizeof(StartMenuContinueTable) / sizeof(u32); i++){
    // ĂȂAڂ\Ȃ
    if(i == 4 && wk->zukangetflag == FALSE) continue;
    // ȊO͕ʂɕ\ėǂ
    msg = MSGDAT_UTIL_AllocExpandString(word, msgman, StartMenuContinueTable[i], HEAPID_STARTMENU);
    GF_STR_PrintColor(mw->win, FONT_SYSTEM, msg, STARTMENU_MARGIN_L, i*16, MSG_NO_PUT, color, NULL);
    STRBUF_Delete(msg);
  }
  
  // l̏\
  WORDSET_RegisterPlayerName(word, 0, wk->mst);
  StartMenuContinueSub1(mw->win, msgman, word, color, mes_startmenu_17, 16*1);
  // vCԂ\
  StartMenuContinueSub2(word, PLAYTIME_GetHour(wk->ptime));
  WORDSET_RegisterNumber(word, 1, PLAYTIME_GetMinute(wk->ptime), 2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
  StartMenuContinueSub1(mw->win, msgman, word, color, mes_startmenu_18, 16*2);
  // Ăob`
  WORDSET_RegisterNumber(word, 0, wk->badgecount, 1, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
  StartMenuContinueSub1(mw->win, msgman, word, color, mes_startmenu_20, 16*3);
  // |P\
  if(wk->zukangetflag){
    StartMenuContinueSub2(word, ZukanWork_GetZukanPokeSeeCount(wk->zw));
    StartMenuContinueSub1(mw->win, msgman, word, color, mes_startmenu_19, 16*4);
  }
  // ܂Ƃ߂ĕ\
  BmpMenuWinWrite(mw->win, WINDOW_TRANS_ON, mw->fchr, mw->fcol);
  // `tOON
  wk->menuflag[index] = StartMenuWinTable[index].mark;

  WORDSET_Delete(word);
  MSGMAN_Delete(msgman);

  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	`fa|P̗L𒲂ׂăj[\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL StartMenuAgbPokemon(void *p, int index, MYSTERY_WIN *mw, int y)
{
  int msg;
  STARTMENU_WORK *wk = (STARTMENU_WORK *)p;

  // AGBJ[gbW݂͕̑ʂ̃^C~OōsĂ܂
  if(wk->agbpokemon == FALSE)	return FALSE;

  // I
  switch(wk->agbpokemon - 1){
  case CASTYPE_RUBY:	msg = mes_startmenu_05; break;
  case CASTYPE_SAPPHIRE:msg = mes_startmenu_06; break;
  case CASTYPE_GREEN:	msg = mes_startmenu_07; break;
  case CASTYPE_RED:	msg = mes_startmenu_08; break;
  case CASTYPE_EMERALD:	msg = mes_startmenu_09; break;
  }    
  // j[\
  MysteryLib_CreateWin(wk->bgl, mw, 3, y, msg);
  ClrWirelessIcon(wk, 26, y);
  wk->menuflag[index] = StartMenuWinTable[index].mark;

  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	ӂȁ@̂\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL StartMenuCheckMystery(void *p, int index, MYSTERY_WIN *mw, int y)
{
  STARTMENU_WORK *wk = (STARTMENU_WORK *)p;

  // ӂȁ@̂IONɂꍇ̏
  if(wk->mystery == FALSE){
    // łɂӂȁ@͕̂\\H
    if(FUSHIGIDATA_IsFushigiMenu(wk->fdata) == TRUE)
      wk->mystery = TRUE;
    // Q[̂Ƃ΂ĂH
    if(SYSTEMDATA_GetWifiMPOpenFlag(SaveData_GetSystemData(wk->sv)) == TRUE)
      wk->mystery = TRUE;
    // AGBł̔zzpJZbghĂH
    // ----------------------------------------------------------------------------
    // localize_spec_mark(LANG_ALL) imatake 2007/01/15
    // Crypto CuŃmۂq[vݒ
    SetAgbCartridgeHeapID(HEAPID_STARTMENU);
    // ----------------------------------------------------------------------------
    if(GetAgbCartridgeDataSize()){
      wk->mystery = TRUE;
      MysteryLib_SetAgbCartridgeIntr(TRUE);	/* AGBJ[gbW̔oON */
    }
  }

  // ӂȁ@̂IOFFɂꍇ̏
  if(wk->mystery == TRUE){
    // ĂȂ΋IOFF
    if(wk->zukangetflag == FALSE)
      wk->mystery = FALSE;
  }

  // ۂ̃`FbNStartMenuBeacon_ProcōsĂ܂
  if(wk->mystery == TRUE){
    // j[\
    MysteryLib_CreateWin(wk->bgl, mw, 3, y, StartMenuWinTable[index].msgid);
#if 0
    SetWirelessIcon(wk, 26, y, 1);
    wk->iconflag[index] = 1;
#else
    ClrWirelessIcon(wk, 26, y);
#endif
    wk->menuflag[index] = StartMenuWinTable[index].mark;
    wk->menu_flag |= PARTYGAME_MYSTERY_BCON;
    FUSHIGIDATA_SetFushigiMenu(wk->fdata);
    return TRUE;
  }

  return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	|PW[Ƃ̐ڑ\
 * @param	NONE
 * @return	NONE
*/
//------------------------------------------------------------------
static BOOL StartMenuCheckRanger(void *p, int index, MYSTERY_WIN *mw, int y)
{
  STARTMENU_WORK *wk = (STARTMENU_WORK *)p;
  // ۂ̃`FbNStartMenuBeacon_ProcōsĂ܂

  if(wk->pokemonranger == TRUE && wk->zukangetflag == TRUE){
    // j[\
    MysteryLib_CreateWin(wk->bgl, mw, 3, y, StartMenuWinTable[index].msgid);
    SetWirelessIcon(wk, 26, y, 1);
    wk->iconflag[index] = 1;
    wk->menuflag[index] = StartMenuWinTable[index].mark;
    wk->menu_flag |= PARTYGAME_RANGER_BCON;
    return TRUE;
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	Wiĩj[\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL StartMenuCheckWii(void *p, int index, MYSTERY_WIN *mw, int y)
{
  STARTMENU_WORK *wk = (STARTMENU_WORK *)p;
  // ۂ̃`FbNStartMenuBeacon_ProcōsĂ܂

  if(wk->wii == TRUE){
    // j[\
    MysteryLib_CreateWin(wk->bgl, mw, 3, y, StartMenuWinTable[index].msgid);
    wk->iconflag[index] = 1;
    SetWirelessIcon(wk, 26, y, 1);
    wk->menuflag[index] = StartMenuWinTable[index].mark;
    return TRUE;
  }
  return FALSE;
}


//------------------------------------------------------------------
/**
 * @brief	Wi-Fiݒ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL StartMenuSetWifi(void *p, int index, MYSTERY_WIN *mw, int y)
{
  STARTMENU_WORK *wk = (STARTMENU_WORK *)p;
  // j[\
  MysteryLib_CreateWin(wk->bgl, mw, 3, y, StartMenuWinTable[index].msgid);
  wk->iconflag[index] = 2;
  SetWirelessIcon(wk, 26, y, 2);
  wk->menuflag[index] = StartMenuWinTable[index].mark;
  return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	j[쐬
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static BOOL CreateStartMenu(STARTMENU_WORK *wk)
{
  STARTMENU_DATA *smd;
  MYSTERY_WIN mw;
  int i, y, ret;

  ret = FALSE;
  y = 1;
  wk->chrbase = STARTMENU_WCHR;
  for(i = 0; i < MENU_WIN_MAX; i++){
    smd = &StartMenuWinTable[i];

    MysteryLib_WinInit1(&mw, &wk->mwin[i], STARTMENU_WCOL_NORMAL, NARC_msg_startmenu_dat, STARTMENU_FCHR1, STARTMENU_FCOL1);
    MysteryLib_WinInit2(&mw, 26, smd->height,/* NULL,*/ wk->chrbase);
    if(smd->func){
      // funcŕ\
      if(wk->menuflag[i]){
	GF_BGL_BmpWinSet_PosX(mw.win, 3);
	GF_BGL_BmpWinSet_PosY(mw.win, y);
	BmpMenuWinWrite(mw.win, WINDOW_TRANS_ON, mw.fchr, mw.fcol);
	if(wk->iconflag[i])	SetWirelessIcon(wk, 26, y, wk->iconflag[i]);
	else			ClrWirelessIcon(wk, 26, y);
	y += smd->height + 2;
	ret = TRUE;
      } else if(smd->func(wk, i, &mw, y) == TRUE){
	y += smd->height + 2;
	ret = TRUE;
      }
    } else {
      // ʏ\
      MysteryLib_CreateWin(wk->bgl, &mw, 3, y, smd->msgid);
      wk->menuflag[i] = smd->mark;
      y += smd->height + 2;
    }
    wk->chrbase += 26 * smd->height;
  }
  return ret;
}


//------------------------------------------------------------------
/**
 * @brief	EBhE̘g(t[)ĕ\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void RedrawWindowFrame(STARTMENU_WORK *wk, int select)
{
  int i;
  for(i = 0; i < sizeof(StartMenuWinTable) / sizeof(STARTMENU_DATA); i++){
    if(GF_BGL_BmpWinAddCheck(&wk->mwin[i]) == FALSE)	continue;

    if(i == select){
      BmpMenuWinWrite(&wk->mwin[i], WINDOW_TRANS_OFF, STARTMENU_FCHR2, STARTMENU_FCOL2);
      GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME0_M,
			  GF_BGL_BmpWinGet_PosX(&wk->mwin[i]),  GF_BGL_BmpWinGet_PosY(&wk->mwin[i]),
			  GF_BGL_BmpWinGet_SizeX(&wk->mwin[i]), GF_BGL_BmpWinGet_SizeY(&wk->mwin[i]),
			  STARTMENU_WCOL_SELECT);
    } else {
      BmpMenuWinWrite(&wk->mwin[i], WINDOW_TRANS_OFF, STARTMENU_FCHR1, STARTMENU_FCOL1);
      GF_BGL_ScrPalChange(wk->bgl, GF_BGL_FRAME0_M,
			  GF_BGL_BmpWinGet_PosX(&wk->mwin[i]),  GF_BGL_BmpWinGet_PosY(&wk->mwin[i]),
			  GF_BGL_BmpWinGet_SizeX(&wk->mwin[i]), GF_BGL_BmpWinGet_SizeY(&wk->mwin[i]),
			  STARTMENU_WCOL_NORMAL);
    }
  }
  // XN[̑Ŝē]
  GF_BGL_LoadScreenReq(wk->bgl, GF_BGL_FRAME0_M);
}


//------------------------------------------------------------------
/**
 * @brief	̃J[\ʒu
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void NextCursorPosition(STARTMENU_WORK *wk, int offset)
{
  int now = wk->cursor;

  while(1){
    now += offset;
    // I[o[t[
    if(now == -1)		now = 0;
    if(now == MENU_WIN_MAX)	now = MENU_WIN_MAX - 1;
    // ꏊȂΓȂ
    if(now == wk->cursor)
      break;
    // ꏊ猈
    if(wk->menuflag[now]){
      Snd_SePlay(SEQ_SE_DP_SELECT);
      break;
    }
  }

  wk->cursor = now;
}


//------------------------------------------------------------------
/**
 * @brief	J[\ʓɓ悤ɃXN[o^
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetCursorScroll(STARTMENU_WORK *wk)
{
  int cursory, height, basey;

  // hbgZ̃J[\ʒuZo
  cursory = (GF_BGL_BmpWinGet_PosY(&wk->mwin[wk->cursor] ) - 1) * 8;
  height = (GF_BGL_BmpWinGet_SizeY(&wk->mwin[wk->cursor] ) + 2) * 8;

  // ݂̃XN[l(ړIW)
  basey = wk->target / FX32_ONE;

  // ʂ̒ɓĂ邩

  // ʂ̏ɂ͂ݏoĂ̂ŉɃXN[Zbg
  if(basey > cursory){
    wk->target = cursory * FX32_ONE;
  }
  // ʂ̉ɂ͂ݏoĂ̂ŏɃXN[Zbg
  if(basey + HW_LCD_HEIGHT <= cursory){
    wk->target = ((cursory + height) - HW_LCD_HEIGHT) * FX32_ONE;
  }
}


//------------------------------------------------------------------
/**
 * @brief	㉺J[\̕\^\
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void SetCursorVisible(STARTMENU_WORK *wk)
{
  int i, du, dd;
  int cursory, height, basey;

  du = dd = FALSE;

  // ݂̃XN[l(ړIW)
  basey = wk->target / FX32_ONE;

  for(i = 0; i < MENU_WIN_MAX; i++){
    if(GF_BGL_BmpWinAddCheck(&wk->mwin[i]) == FALSE)
      continue;

    // hbgZ̃J[\ʒuZo
    cursory = (GF_BGL_BmpWinGet_PosY(&wk->mwin[i] ) - 1) * 8;
    height = (GF_BGL_BmpWinGet_SizeY(&wk->mwin[i] ) + 2) * 8;

    // ̂͂ݏo`FbN
    if(basey > cursory)
      du = TRUE;
    // ̂͂ݏo`FbN
    if(basey + HW_LCD_HEIGHT <= cursory)
      dd = TRUE;
  }

  CLACT_SetDrawFlag(wk->clcursor[0], du);
  CLACT_SetDrawFlag(wk->clcursor[1], dd);

}


//------------------------------------------------------------------
/**
 * @brief	̏I JȂ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static void StartMenuFinish(PROC *proc)
{
  int i;
  STARTMENU_WORK *wk = PROC_GetWork(proc);

  // AN^[֘ÅJ
  if(wk->clcursor[0] || wk->clcursor[1]){
    CLACT_Delete(wk->clcursor[0]);
    CLACT_Delete(wk->clcursor[1]);
    MysteryLib_RemoveClact();
  }
  
  // EBhEJ
  for(i = 0; i < MENU_WIN_MAX; i++){
    if(wk->mwin[i].ini){
      GF_BGL_BmpWinOff(&wk->mwin[i]);
      GF_BGL_BmpWinDel(&wk->mwin[i]);
    }
  }
  // BGLJ
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME0_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME1_M);
  GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME2_M);
  sys_FreeMemoryEz(wk->bgl);
  sys_VBlankFuncChange(NULL, NULL);
}


//------------------------------------------------------------------
/**
 * @brief	IEBhẼpbgAj
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
u16 animtable[] = {
  RGB( 1, 28, 20),  RGB( 3, 28, 20),  RGB( 5, 28, 20),  RGB( 7, 28, 20),
  RGB( 9, 28, 20),  RGB(11, 28, 20),  RGB(13, 28, 20),  RGB(15, 28, 20),
  RGB(17, 28, 20),  RGB(19, 28, 20),  RGB(21, 28, 20),  RGB(23, 28, 20),
  RGB(25, 28, 20),  RGB(27, 28, 20),  RGB(29, 28, 20),  RGB(31, 28, 20),
  RGB(29, 28, 20),  RGB(27, 28, 20),  RGB(25, 28, 20),  RGB(23, 28, 20),
  RGB(21, 28, 20),  RGB(19, 28, 20),  RGB(17, 28, 20),  RGB(15, 28, 20),
  RGB(13, 28, 20),  RGB(11, 28, 20),  RGB( 9, 28, 20),  RGB( 7, 28, 20),
  RGB( 5, 28, 20),  RGB( 3, 28, 20),
  0,
};
static void SelectPalAnim(STARTMENU_WORK *wk)
{
  u16 *col = (u16 *)0x0500006C;
  if(animtable[wk->anim_index] == 0)
    wk->anim_index = 0;
  *col = animtable[wk->anim_index++];
}

static void VBlankFunc(void *work)
{
  // ZAN^[Vram]}l[W[s
  DoVramTransferManager();
  // _LOAM}l[WVram]
  REND_OAMTrans();	
  GF_BGL_VBlankFunc( (GF_BGL_INI*)work );
  OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT StartMenuProc_Init(PROC * proc, int * seq)
{
  STARTMENU_WORK *wk;

  sys_CreateHeap( HEAPID_BASE_APP, HEAPID_STARTMENU, 0x40000);
  //  sys_PrintHeapFreeSize(HEAPID_STARTMENU);
  wk = PROC_AllocWork(proc, sizeof(STARTMENU_WORK), HEAPID_STARTMENU);
  // sǂ|̂Ń[N̓[NA
  memset(wk, 0, sizeof(STARTMENU_WORK));

  /* eϐ̏ */
  wk->bgl = GF_BGL_BglIniAlloc(HEAPID_STARTMENU);

  /* ʂ̏ݒ */
  WIPE_SetBrightness( WIPE_DISP_MAIN, WIPE_FADE_BLACK );
  WIPE_SetBrightness( WIPE_DISP_SUB, WIPE_FADE_BLACK );

  /* ϐ */
  wk->sv = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
  wk->fdata = SaveData_GetFushigiData(wk->sv);
  //  wk->cursor = 0;
  wk->scrolly = FX32_ONE * 0;
  wk->target  = FX32_ONE * 0;

  wk->mst = SaveData_GetMyStatus(wk->sv);
  wk->zw = SaveData_GetZukanWork(wk->sv);
  wk->ptime = SaveData_GetPlayTime(wk->sv);

  wk->zukangetflag = ZukanWork_GetZukanGetFlag(wk->zw);
  wk->badgecount = MyStatus_GetBadgeCount(wk->mst);
  wk->beacon_msg_seq = BEACON_MSGSEQ_NOP;
  
  // Cu
  MysteryLib_Init(HEAPID_STARTMENU);

  // Z[uf[^΃X^[gj[̂\Ȃ
  if(!SaveData_GetExistFlag(wk->sv)){
    wk->pass_start_menu = TRUE;
  }

  Snd_BgmChannelSetAndReverbSet( 0 );	// gp\`lAo[uݒ(NA)
  Snd_SceneSet( SND_SCENE_DUMMY );		// ̃V[Kǂݍ܂悤ɂĂI

#ifdef DEBUG_ONLY_FOR_mituhara
  OS_TPrintf("sizeof(POKEMON_PARAM) = %d\n", PokemonParam_GetWorkSize());
  OS_TPrintf("sizeof(_SEND_FLAG) = %d\n", CommPlayerNowFlagDataArraySize());
  OS_TPrintf("sizeof(MYSTATUS) = %d\n", MyStatus_GetWorkSize());
#endif

#ifdef CREATE_INDEX
  CreateIndexData(HEAPID_STARTMENU);
#endif

  
  return PROC_RES_FINISH;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT StartMenuProc_Main(PROC * proc, int * seq)
{
  int ret;
  STARTMENU_WORK *wk = PROC_GetWork(proc);
  wk->jiffy++;
  CTRDG_IsExisting();

  // r[RM̃bZ[W\V[PX
  if(BeaconMessage_Proc(wk) == TRUE){
    StartMenuBeacon_Proc(wk);
    StartMenuProc(wk);
    return PROC_RES_CONTINUE;
  }

  // IĂEBhEpbgAj[V
  SelectPalAnim(wk);

  switch(*seq){
  case STARTMENU_SEQ_INIT:
    // af֌W̕KvŒ̏
    InitStartMenuScreen(wk);
    SetSeq(*seq, STARTMENU_SEQ_CHECK_SYSTEM);
    break;

  case STARTMENU_SEQ_CHECK_SYSTEM:
    // eVXẽ`FbN(CɃ`FbNA\)
    if(StartMenuCheckSystem(wk) == 0){
      SetSeq(*seq, STARTMENU_SEQ_HARDINIT);
    } else {
      MysteryLib_RequestFade(WIPE_TYPE_FADEIN, STARTMENU_SEQ_DISP_ERROR, seq, STARTMENU_SEQ_FADE_WAIT);
      *((u16 *)HW_BG_PLTT +  0) = RGB(12, 12, 31);
    }
    break;

  case STARTMENU_SEQ_DISP_ERROR:
    // G[̂ŏڍׂ\܂
    if(StartMenuDisplayError(wk) == FALSE)
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, STARTMENU_SEQ_HARDINIT, seq, STARTMENU_SEQ_FADE_WAIT);
    break;
    
  case STARTMENU_SEQ_HARDINIT:
    wk->beacon_seq = STARTMENU_BEACON_SEQ_WAIT;
    // Z[uf[^Ȃ΃Q[̍ŏn߂
    if(wk->pass_start_menu == TRUE){
      wk->select = SEL_FIRSTGAME;
      MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, STARTMENU_SEQ_SELECT_MENU, seq, STARTMENU_SEQ_FADE_WAIT);
    } else {
      // AGBJ[gbW̏Ď̃V[PX
      AgbCartridgeInit(wk);
      SetSeq(*seq, STARTMENU_SEQ_CREATE_SCREEN);
    }
    break;

  case STARTMENU_SEQ_CREATE_SCREEN:
    // J[\IuWFNg̓ǂݍ
    StartMenuInitClact(wk);
    // CXACR̓ǂݍ
    WirelessIconInit(wk);
    sys_VBlankFuncChange(VBlankFunc, wk->bgl);

    // XN[쐬({`)
    CreateStartMenu(wk);
    RedrawWindowFrame(wk, wk->cursor);
    MysteryLib_RequestFade(WIPE_TYPE_FADEIN, STARTMENU_SEQ_MAIN, seq, STARTMENU_SEQ_FADE_WAIT);
    *((u16 *)HW_BG_PLTT +  0) = RGB(12, 12, 31);
    // r[R̎WJn
    wk->beacon_seq = STARTMENU_BEACON_SEQ_INIT;
    break;

  case STARTMENU_SEQ_MAIN:
    // {^ / LZ{^
    if(sys.trg & (PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL)){
      if(sys.trg & PAD_BUTTON_DECIDE){
	Snd_SePlay(SEQ_SE_DP_SELECT);
	wk->select = wk->menuflag[wk->cursor];

	// AGBJZbgAĂI񂾍ۂ̒~菈
	if(wk->select == SEL_AGBPOKEMON){
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/01
// AGBJ[gbWꂽƂ́Au[XN[ɑJڂ悤ɕύX
#if AFTERMASTER_070123_GBACARTRIDGE_BUF_FIX
	  // JZbgĂG[ʂ֔
	  if(CTRDG_IsPulledOut() == TRUE){
	    if(wk->beacon_seq != STARTMENU_BEACON_SEQ_WAIT)
	      CommStateExitPartyGameScan();
	    GbaCartridgeErrorWarningCall(HEAPID_STARTMENU);
	  }
#else
	  if(CTRDG_IsPulledOut() == TRUE)
	    CTRDG_TerminateForPulledOut();
#endif
// ----------------------------------------------------------------------------
	}
	
      } else {
	Snd_SePlay(SEQ_SE_DP_SELECT);
	wk->select = SEL_CANCEL;
	MysteryLib_ChangeFadeType(1);
      }
      if(wk->select == SEL_FIRSTGAME){
	// 傩͂߂Iꍇɂ͌xʂ\
	wk->beacon_status |= STARTMENU_FIRSTGAME_SELECT;
	wk->beacon_msg_wait = 1;
	SetSeq(*seq, STARTMENU_SEQ_SELECT_FIRSTGAME);
      } else {
	if(wk->select == SEL_WII)
	  MysteryLib_ChangeFadeType(1);
	MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, STARTMENU_SEQ_SELECT_MENU, seq, STARTMENU_SEQ_FADE_WAIT);
      }

      // r[RW狭I
      if(wk->beacon_seq == STARTMENU_BEACON_SEQ_TIMER)
	wk->beacon_seq = STARTMENU_BEACON_SEQ_CANCEL;
      break;
    }
    
    // ĕ`̕Kv΍ĕ`悷
    if(wk->redrawflag == TRUE){
      CreateStartMenu(wk);
      wk->redrawflag = FALSE;
      break;
    }

    // J[\ړ
    if(sys.trg & PAD_KEY_UP)
      NextCursorPosition(wk, -1);
    if(sys.trg & PAD_KEY_DOWN)
      NextCursorPosition(wk,  1);
    // XN[
    RedrawWindowFrame(wk, wk->cursor);
    // XN[
    SetCursorScroll(wk);
    // ㉺J[\̕\
    SetCursorVisible(wk);

    // XNGXgoĂ΃|bvAbvj[̓o^
    if(*seq == STARTMENU_SEQ_MAIN && wk->req_popup == TRUE){
      wk->req_popup = FALSE;
      wk->beacon_msg_wait = 1;
    }
    
    break;

  case STARTMENU_SEQ_SELECT_FIRSTGAME:
    // 傩͂߂I񂾎͌x\
    if(wk->beacon_msg_seq == BEACON_MSGSEQ_NOP){
      if(wk->beacon_result & PAD_BUTTON_CANCEL){
	SetSeq(*seq, STARTMENU_SEQ_MAIN);
      } else {
	MysteryLib_RequestFade(WIPE_TYPE_FADEOUT, STARTMENU_SEQ_SELECT_MENU, seq, STARTMENU_SEQ_FADE_WAIT);
      }
    }
    break;

    
  case STARTMENU_SEQ_SELECT_MENU:
    // QJ
    StartMenuFinish(proc);
    return PROC_RES_FINISH;
    break;

    
  case STARTMENU_SEQ_FADE_WAIT:
    // tF[hI܂ő҂Ď̃V[PX
    MysteryLib_FadeEndCheck(seq);
    break;

  case STARTMENU_SEQ_FINISH:
    return PROC_RES_FINISH;
    break;
  }

  StartMenuBeacon_Proc(wk);
  StartMenuProc(wk);
  MysteryLib_DoClact();
  
  return PROC_RES_CONTINUE;
}



//------------------------------------------------------------------
/**
 * @brief	Iꂽj[ɂď
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
#include "system/gamestart.h"
#include "demo/title.h"
FS_EXTERN_OVERLAY( title );
#define CHECK_OVERLAY
#ifdef CHECK_OVERLAY
FS_EXTERN_OVERLAY( startmenu );
#endif
extern const PROC_DATA MysteryGiftProcData;
extern const PROC_DATA AgbCartridgeProcData;
extern const PROC_DATA PokemonRangerProcData;
extern const PROC_DATA StartMenuWifiProcData;

static void StartMenuSetNextProc(STARTMENU_WORK *wk)
{
  switch(wk->select){
  case SEL_CONTINUE:	// Â@͂߂
    Main_SetNextProc(OVERLAY_ID_GAMESTART, &ContinueGameStartProcData);
    break;
  case SEL_FIRSTGAME:	// 傩@͂߂
    Main_SetNextProc(OVERLAY_ID_GAMESTART, &NewGameStartProcData);
    break;
  case SEL_MYSTERY:	// ӂȁ@
#ifdef CHECK_OVERLAY
    Main_SetNextProc(FS_OVERLAY_ID(startmenu), &MysteryGiftProcData);
#else
    Main_SetNextProc(NO_OVERLAY_ID, &MysteryGiftProcData);
#endif
    break;
  case SEL_AGBPOKEMON:	// ~~~@Ă
#ifdef CHECK_OVERLAY
    Main_SetNextProc(FS_OVERLAY_ID(startmenu), &AgbCartridgeProcData);
#else
    Main_SetNextProc(NO_OVERLAY_ID, &AgbCartridgeProcData);
#endif
    break;
  case SEL_RANGER:	// |PW[Ƃ́@
#ifdef CHECK_OVERLAY
    Main_SetNextProc(FS_OVERLAY_ID(startmenu), &PokemonRangerProcData);
#else
    Main_SetNextProc(OVERLAY_ID_GAMESTART, &PokemonRangerProcData);
#endif
    break;
  case SEL_WII:		// WiiƁ@
    rebooter(WIICLIENT_FILE);
    break;  case SEL_WIFI:	// Wi-FiĂ
    Snd_Stop();
    Main_SetNextProc(NO_OVERLAY_ID, &StartMenuWifiProcData);
    break;
  case SEL_CANCEL:	// LZ
    Main_SetNextProc( FS_OVERLAY_ID(title), &TitleProcData);
    break;
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT StartMenuProc_End(PROC * proc, int * seq)
{
  STARTMENU_WORK *wk = PROC_GetWork(proc);

  StartMenuSetNextProc(wk);

  PROC_FreeWork(proc);
  sys_DeleteHeap(HEAPID_STARTMENU);

  /* AGBJ[gbW̔oOFF */
  MysteryLib_SetAgbCartridgeIntr(FALSE);

  return PROC_RES_FINISH;
}


//--------------------------------------------------------------------------------------------
// ̒`src/demo/title.cQƂ܂
//--------------------------------------------------------------------------------------------
//FS_EXTERN_OVERLAY(startmenu);
const PROC_DATA StartMenuProcData = {
  StartMenuProc_Init,
  StartMenuProc_Main,
  StartMenuProc_End,
  NO_OVERLAY_ID,
};



/*  */
