//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		swsprite.c
 *	@brief		\tgEFAXvCg\VXe
 *	@author		tomoya takahashi
 *	@data		2005.09.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "string.h"

#define __SESPRITE_H_GLOBAL
#include "include/system/swsprite.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define	PLTT_16_SIZE	(32)		// 16FpbgTCY

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	LN^f[^
//
//=====================================
typedef struct SWSP_CHAR_tag{
	NNSGfdTexKey		vramKey;	// gpVram̈
	NNSG2dImageProxy	imgProxy;	// imagevNV
} SWSP_CHAR;

//-------------------------------------
//	
//	pbgf[^
//	
//=====================================
typedef struct SWSP_PLTT_tag{
	NNSGfdPlttKey			vramKey;	// gpVram̈
	NNSG2dImagePaletteProxy	imgProxy;	// imagevNV
} SWSP_PLTT;

//-------------------------------------
//	
//	\tgEFAXvCg\f[^
//	Pɂ܂Ƃ߂IuWFNgf[^
//	
//=====================================
typedef struct SWSP_OBJ_tag{
	NNSG2dSVec2		matrix;					// \ʒu
	NNSG2dSVec2		center;					// SW
    NNSG2dSVec2		size;					// TCY
	fx32			scale_x;				// gl
	fx32			scale_y;				// gl
	int				priority;				// \D揇
	int				rotZ;					// ]pZ
	BOOL			use;					// gp
	BOOL			draw;					// \邩
	NNSG2dImageAttr* tex_attr;				// eNX`Agr[g
	u32				tex_addr;				// eNX`AhX
	u32				pltt_addr;				// pbgAhX
	u32				pltt_offs;				// 16F
	BOOL			flipH;					// Htbv
	BOOL			flipV;					// Vtbv
	GXRgb			diffcolor;				// fBt[YJ[
	u8				alpha;					// At@
} SWSP_OBJ;

//-------------------------------------
//	
//	imageClipp
//	\tgEFAXvCg`VXe
//	f[^i[\
//=====================================
typedef struct SWSP_SYS_tag{
	SWSP_OBJ*	obj_tbl;		// IuWFe[u
	int				obj_num;		// IuWFe[u
	SWSP_CHAR*	char_tbl;		// LN^e[u
	int				char_num;		// LN^e[u
	SWSP_PLTT*	pltt_tbl;		// pbge[u
	int				pltt_num;		// pbge[u

}SWSP_SYS;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void cleanSys( SWSP_SYS* data );
static void cleanObj( SWSP_OBJ* data );
static void cleanChar( SWSP_CHAR* data );
static void cleanPltt( SWSP_PLTT* data );

static void darwObj( SWSP_OBJ* data );

static SWSP_OBJ* makeObjData( int num, int heap );
static SWSP_CHAR* makeCharData( int num, int heap );
static SWSP_PLTT* makePlttData( int num, int heap );

static SWSP_OBJ* getCleanObj( SWSP_SYS* sys );
static SWSP_CHAR* getCleanChar( SWSP_SYS* sys );
static SWSP_PLTT* getCleanPltt( SWSP_SYS* sys );

static NNSGfdTexKey getCharVramKey( NNSG2dCharacterData* pChar );
static NNSGfdPlttKey getPlttVramKey( int pltt_num );
static void transCharData( NNSG2dCharacterData* pChar, NNSGfdTexKey vramKey, NNSG2dImageProxy* proxy );
static void transPlttData( NNSG2dPaletteData* pPltt, NNSGfdPlttKey vramKey, NNSG2dImagePaletteProxy* proxy );

// XvCgf[^ݒA擾֐
static void setSpriteData( SWSP_OBJ_PTR obj, const SWSP_ADDDATA* add );

//-----------------------------------------------------------------------------
/**
*		O[o֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	imageClip`p\tgEFAVXe
 *
 *	@param	data		VXef[^
 *	@param	heap		gpq[v
 *
 *	@return	SWSPRITE_PTR	\tgEFAVXef[^
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_SYS_PTR SWSP_SysInit( const SWSP_SYSDATA* data )
{
	SWSP_SYS_PTR sys;
	int i;	// [vp

	sys = sys_AllocMemory( data->heap, sizeof(SWSP_SYS) );
	GF_ASSERT( sys );

	// IuWFNgf[^쐬
	sys->obj_tbl = makeObjData( data->obj_num, data->heap );
	sys->obj_num = data->obj_num;
	
	// LN^f[^쐬
	sys->char_tbl = makeCharData( data->char_num, data->heap );
	sys->char_num = data->char_num;
	
	// pbgf[^쐬
	sys->pltt_tbl = makePlttData( data->pltt_num, data->heap );
	sys->pltt_num = data->pltt_num;

	return sys;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCgVXej
 *
 *	@param	data	\tgEFAVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SysDelete( SWSP_SYS_PTR data )
{
	GF_ASSERT(data);
	GF_ASSERT(data->obj_tbl);
	GF_ASSERT(data->char_tbl);
	GF_ASSERT(data->pltt_tbl);

	// Sf[^j
	sys_FreeMemoryEz( data->obj_tbl );
	sys_FreeMemoryEz( data->char_tbl );
	sys_FreeMemoryEz( data->pltt_tbl );
	sys_FreeMemoryEz( data );
	data = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		\
 *
 *	@param		data VXe̕\IuWFNg\
 *
 *	@return		none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SysDraw( SWSP_SYS_PTR data )
{
	int i;		// [vp
	

	G3_PushMtx();
	
	
	for( i=0;i<data->obj_num;i++ ){
		if(data->obj_tbl[ i ].draw){
			darwObj( data->obj_tbl + i );
		}
	}

	G3_PopMtx(1);
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^̍\̃TCYԂ
 *
 *	@param	none
 *
 *	@return	int	TCY
 *
 *
 */
//-----------------------------------------------------------------------------
int SWSP_GetCharDataSize( void )
{
	return sizeof( SWSP_CHAR );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^\̂̃TCYԂ
 *
 *	@param	none
 *
 *	@return	int		TCY
 *
 *
 */
//-----------------------------------------------------------------------------
int SWSP_GetPlttDataSize( void )
{
	return sizeof( SWSP_PLTT );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgf[^\̂̃TCY擾
 *
 *	@param	none
 *
 *	@return	int		TCY
 *
 *
 */
//-----------------------------------------------------------------------------
int SWSP_GetSpriteDataSize( void )
{
	return sizeof( SWSP_OBJ );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	zŃIuWFNgi[̈pӂƂ̗vf̃f[^擾p֐
 *
 *	@param	obj		IuWFNg|C^i[Ăz
 *	@param	no		擾vf
 *
 *	@return	SWSP_CHAR_PTR	vf̃f[^
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_CHAR_PTR SWSP_GetCharDataNo( SWSP_CHAR_PTR obj, int no )
{
	return obj + no;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	zŃIuWFNgi[̈pӂƂ̗vf̃f[^擾p֐
 *
 *	@param	obj		IuWFNg|C^i[Ăz
 *	@param	no		擾vf
 *
 *	@return	SWSP_PLTT_PTR	vf̃f[^
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_PLTT_PTR SWSP_GetPlttDataNo( SWSP_PLTT_PTR obj, int no )
{
	return obj + no;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	zŃIuWFNgi[̈pӂƂ̗vf̃f[^擾p֐
 *
 *	@param	obj		IuWFNg|C^i[Ăz
 *	@param	no		擾vf
 *
 *	@return	SWSP_OBJ_PTR	vf̃f[^
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_OBJ_PTR SWSP_GetSpriteDataNo( SWSP_OBJ_PTR obj, int no )
{
	return obj + no;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCgpLN^f[^ǂݍ
 *
 *	@param	data	ǂݍރLN^f[^ 
 *
 *	@return	SWSP_CHAR_PTR	ǂݍ񂾃LN^f[^
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_CHAR_PTR SWSP_CharLoad( const SWSP_CHARDATA* data )
{
	SWSP_CHAR_PTR char_tbl;		// f[^i[

	// ̃LN^f[^e[u擾
	char_tbl = getCleanChar( data->s_sys );
	GF_ASSERT( char_tbl );

	// 2Dmap`FbN
	GF_ASSERT( data->res_file->mapingType == GX_OBJVRAMMODE_CHAR_2D );
	
	// LN^TCYvramKey擾
	char_tbl->vramKey = getCharVramKey( data->res_file );	
	GF_ASSERT( char_tbl->vramKey );
	
	// vramkeỹAhXɃf[^]
	transCharData( data->res_file, char_tbl->vramKey, &char_tbl->imgProxy );

	return char_tbl;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^j
 *
 *	@param	data	LN^f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_CharDelete( SWSP_CHAR_PTR data )
{
	// VramKeỷ
	NNS_GfdFreeTexVram( data->vramKey );

	// e[ucleanAbv
	cleanChar( data );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^Sj
 *
 *	@param	data		LN^f[^SjVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_CharDeleteAll( SWSP_SYS_PTR data )
{
	int i;		// [vp

	for(i=0;i<data->char_num;i++){
		if( data->char_tbl[ i ].vramKey ){
			SWSP_CharDelete( data->char_tbl + i );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCgppbgf[^ǂݍ
 *
 *	@param	data	ǂݍރpbgf[^ 
 *
 *	@return	SWSP_PLTT_PTR	ǂݍ񂾃pbgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_PLTT_PTR SWSP_PlttLoad( const SWSP_PLTTDATA* data )
{
	SWSP_PLTT_PTR pltt_tbl;		// pbgf[^i[

	// ̃pbge[u擾
	pltt_tbl = getCleanPltt( data->s_sys );
	GF_ASSERT( pltt_tbl );

	// VramKey擾
	pltt_tbl->vramKey = getPlttVramKey( data->load_num );
	GF_ASSERT(pltt_tbl->vramKey);

	// pbgf[^]
	transPlttData( data->res_file, pltt_tbl->vramKey, &pltt_tbl->imgProxy );

	return pltt_tbl;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCgppbgf[^j
 *
 *	@param	data	jpbgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_PlttDelete( SWSP_PLTT_PTR data )
{
	// VramKeỷ
	NNS_GfdFreePlttVram( data->vramKey );

	// e[ucleanAbv
	cleanPltt( data );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^Sj
 *
 *	@param	data		pbgf[^Sj\tgEFAXvCgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_PlttDeleteAll( SWSP_SYS_PTR data )
{
	int i;		// [vp

	for(i=0;i<data->pltt_num;i++){
		if( data->pltt_tbl[ i ].vramKey ){
			SWSP_PlttDelete( data->pltt_tbl + i );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCg\o^
 *
 *	@param	add		o^f[^
 *
 *	@return	SWSP_OBJ_PTR	\tgEFAXvCgIuWF
 *
 *
 */
//-----------------------------------------------------------------------------
SWSP_OBJ_PTR SWSP_Add( const SWSP_ADDDATA* add )
{
	SWSP_OBJ_PTR obj_tbl;	// f[^i[

	// 󂢂Ăe[u擾
	obj_tbl = getCleanObj( add->s_sys );
	GF_ASSERT( obj_tbl );

	// f[^ݒ
	// ݒ肷
	setSpriteData( obj_tbl, add );

	// gpɂ
	obj_tbl->use	= TRUE;
	obj_tbl->draw	= TRUE;

	return obj_tbl;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCg\f[^j
 *
 *	@param	sp_obj j\tgEFAXvCgIuWF
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_Delete( SWSP_OBJ_PTR sp_obj )
{

	cleanObj( sp_obj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCg\f[^Sj
 *
 *	@param	sys		\f[^IuWFSj\tgEFAXvCgVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_DeleteAll( SWSP_SYS_PTR sys )
{
	int i;		// [vp

	for(i=0;i<sys->obj_num;i++){
		if( sys->obj_tbl[ i ].use ){
			SWSP_Delete( sys->obj_tbl + i );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̕\/\ݒ
 *
 *	@param	obj		XvCgIuWFNg
 *	@param	draw	\/\		(TRUE / FALSE)
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteDraw( SWSP_OBJ_PTR obj, BOOL draw )
{
	GF_ASSERT( obj );
	obj->draw = draw;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̕\/\擾
 *
 *	@param	obj		XvCgIuWFNg
 *
 *	@retval	TRUE	\
 *	@retval	FALSE	\
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL SWSP_GetSpriteDraw( SWSP_OBJ_PTR obj )
{
	GF_ASSERT( obj );
	return obj->draw;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgWݒ
 *
 *	@param	obj		IuWF	
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpritePos( SWSP_OBJ_PTR obj, s16 x, s16 y )
{
	obj->matrix.x = x;
	obj->matrix.y = y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgW擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	NNSG2dSVec2 W(o s16 x  s16 y)
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dSVec2 SWSP_GetSpritePos( SWSP_OBJ_PTR obj )
{
	return obj->matrix;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgSWݒ
 *
 *	@param	obj		IuWF	
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteCenterPos( SWSP_OBJ_PTR obj, s16 x, s16 y )
{
	obj->center.x = x;
	obj->center.y = y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgSW擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	NNSG2dSVec2 W(o s16 x  s16 y)
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dSVec2 SWSP_GetSpriteCenterPos( SWSP_OBJ_PTR obj )
{
	return obj->center;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	gklݒ
 *
 *	@param	obj		XvCgIuWF
 *	@param	x		gkl
 *	@param	y		gkl
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteScale( SWSP_OBJ_PTR obj, fx32 x, fx32 y )
{
	obj->scale_x = x;
	obj->scale_y = y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	gkl擾
 *
 *	@param	obj		XvCgIuWF
 *	@param	x		W擾
 *	@param	y		W擾
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_GetSpriteScale( SWSP_OBJ_PTR obj, fx32* x, fx32* y )
{
	*x = obj->scale_x;
	*y = obj->scale_y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgTCYݒ
 *
 *	@param	obj		XvCgIuWF
 *	@param	x		TCY
 *	@param	y		TCY
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteSize( SWSP_OBJ_PTR obj, int x, int y )
{
	obj->size.x = x;
	obj->size.y = y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgTCY擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	NNSG2dSVec2	XvCgTCYio s16 x s16 yj
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dSVec2 SWSP_GetSpriteSize( SWSP_OBJ_PTR obj )
{
	return obj->size;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg\D揇ʂݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	priority	\D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpritePriority( SWSP_OBJ_PTR obj, int priority )
{
	obj->priority = priority;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̕\D揇ʂݒ
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	int		\D揇
 *
 *
 */
//-----------------------------------------------------------------------------
int SWSP_GetSpritePriority( SWSP_OBJ_PTR obj )
{
	return obj->priority;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̃lݒ
 *
 *	@param	obj		XvCgIuWF
 *	@param	alpha	l
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteAlpha( SWSP_OBJ_PTR obj, u8 alpha )
{
	obj->alpha = alpha;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̃l擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
u8 SWSP_GetSpriteAlpha( SWSP_OBJ_PTR obj )
{
	return obj->alpha;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		XvCg̐Fݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	color		fBt[YJ[
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteDiffColor( SWSP_OBJ_PTR obj, GXRgb color )
{
	obj->diffcolor = color;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		XvCg̃fBt[YF擾
 *
 *	@param	obj			XvCgIuWF
 *
 *	@retval	J[
 */
//-----------------------------------------------------------------------------
GXRgb SWSP_GetSpriteDiffColor( SWSP_OBJ_PTR obj )
{
	return obj->diffcolor;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̃eNX`Agr[gݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	tex_attr	eNX`Agr[g|C^
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteTexAttr( SWSP_OBJ_PTR obj, NNSG2dImageAttr* tex_attr )
{
	obj->tex_attr = tex_attr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̃eNX`Agr[g擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	NNSG2dImageAttr*	eNX`Agr[g
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImageAttr* SWSP_GetSpriteTexAttr( SWSP_OBJ_PTR obj )
{
	return obj->tex_attr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`AhXݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	tex_addr	eNX`AhX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteTexAddr( SWSP_OBJ_PTR obj, u32 tex_addr )
{
	obj->tex_addr = tex_addr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`AhX擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	u32		eNX`AhX
 *
 *
 */
//-----------------------------------------------------------------------------
u32 SWSP_GetSpriteTexAddr( SWSP_OBJ_PTR obj )
{
	return obj->tex_addr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̃pbgAhXݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	pltt_addr	pbgAhX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpritePlttAddr( SWSP_OBJ_PTR obj, u32 pltt_addr )
{
	obj->pltt_addr = pltt_addr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̃pbgAhX擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	u32		pbgAhX
 *
 *
 */
//-----------------------------------------------------------------------------
u32 SWSP_GetSpritePlttAddr( SWSP_OBJ_PTR obj )
{
	return obj->pltt_addr;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgItZbg
 *
 *	@param	obj			XvCgIuWF
 *	@param	pltt_offs	pbgItZbg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpritePlttOffs( SWSP_OBJ_PTR obj, u32 pltt_offs )
{
	obj->pltt_offs = pltt_offs;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgItZbg擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	u32		ItZbg
 *
 *
 */
//-----------------------------------------------------------------------------
u32 SWSP_GetSpritePlttOffs( SWSP_OBJ_PTR obj )
{
	return obj->pltt_offs;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgtbvݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	flip_flg	tbvtO
 *	@param	flip		tbv邩	TRUE@@FALSE@Ȃ
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteFlip( SWSP_OBJ_PTR obj, int flip_flg, BOOL flip )
{
	if(flip_flg == SWSP_FLIPH){
		obj->flipH = flip;
	}else{
		obj->flipV = flip;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		XvCg̃tbv擾
 *
 *	@param	obj			XvCgIuWF
 *	@param	flip_flg	HVtbvtO
 *
 *	@return	BOOL	TRUE	tbv	FALSE
 *
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL SWSP_GetSpriteFlip( SWSP_OBJ_PTR obj, int flip_flg )
{
	if(flip_flg == SWSP_FLIPH){
		return obj->flipH;
	}
	
	return obj->flipV;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]pzݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	rota		ݒ肷px
 *
 *	@return
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteRotZ( SWSP_OBJ_PTR obj, u16 rota )
{
	obj->rotZ = rota;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]pxZ擾
 *
 *	@param	obj			XvCgIuWF
 *
 *	@return	u16		]px
 *
 *
 */
//-----------------------------------------------------------------------------
u16 SWSP_GetSpriteRotZ( SWSP_OBJ_PTR obj )
{
	return obj->rotZ;
}


#if 0

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgcolorݒi|Scolorj
 *
 *	@param	obj		XvCgIuWF
 *	@param	color	|Scolor
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteColor( SWSP_OBJ_PTR obj, GXRgb color )
{
	obj->sprite.basicParams.color = color;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgcolor擾
 *
 *	@param	obj		XvCgIuWF
 *
 *	@return	GXRgb	colorf[^
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb SWSP_GetSpriteColor( SWSP_OBJ_PTR obj )
{
	return obj->sprite.basicParams.color;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgUVlݒ
 *
 *	@param	obj			XvCgIuWF
 *	@param	LR_flg		@EtO
 *	@param	u			Ul	ij
 *	@param	v			Vl	icj
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteUV( SWSP_OBJ_PTR obj, int LR_flg, fx32 u, f32 v )
{
	if( LR_flg == SWSP_UVUL ){
		obj->sprite.uvUL.x = u;
		obj->sprite.uvUL.y = v;
	}else{
		obj->sprite.uvLR.x = u;
		obj->sprite.uvLR.y = v;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgUVl擾
 *
 *	@param	obj			XvCgIuWF
 *	@param	LR_flg		AEtO
 *
 *	@return	NNSG2dFVec2 UVl	io x=u  y=vj
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dFVec2 SWSP_GetSpriteUV( SWSP_OBJ_PTR obj, int LR_flg  )
{
	if( LR_flg == SWSP_UVUL ){
		return obj->sprite.uvUL;
	}
	
	return obj->sprite.uvLR;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	]̒Sݒ
 *
 *	@param	obj		XvCgIuWF
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteRotO( SWSP_OBJ_PTR obj, s16 x, s16 y )
{
	obj->sprite.rotO.x = x;
	obj->sprite.rotO.y = y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCg̉]SW̎擾
 *
 *	@param	SWSP_OBJ_PTR obj	XvCgIuWFNg
 *
 *	@return	NNSG2dSVec2		]SW	
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG2dSVec2 SWSP_GetSpriteRotO( SWSP_OBJ_PTR obj )
{
	return obj->sprite.rotO;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]pݒ
 *
 *	@param	obj
 *	@param	XYZ_flg
 *	@param	rota 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void SWSP_SetSpriteRot( SWSP_OBJ_PTR obj, int XYZ_flg, u16 rota )
{
	switch(XYZ_flg){
	case SWSP_ROT_X:
		obj->sprite.rotX = rota;
		break;
	case SWSP_ROT_Y:
		obj->sprite.rotY = rota;
		break;
	case SWSP_ROT_Z:
		obj->sprite.basicParams.simpleParams.rotZ = rota;
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]px擾
 *
 *	@param	obj			XvCgIuWF
 *	@param	XYZ_flg		擾]px̃tO
 *
 *	@return	u16		]px
 *
 *
 */
//-----------------------------------------------------------------------------
u16 SWSP_GetSpriteRot( SWSP_OBJ_PTR obj, int XYZ_flg )
{
	switch(XYZ_flg){
	case SWSP_ROT_X:
		return obj->sprite.rotX;
		
	case SWSP_ROT_Y:
		return obj->sprite.rotY;
		
	case SWSP_ROT_Z:
		return obj->sprite.basicParams.simpleParams.rotZ;
	}

	return 0;
}
#endif

//-----------------------------------------------------------------------------
/**
*			vCx[g֐S		private
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAVXef[^	NA
 *
 *	@param	data	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanSys( SWSP_SYS* data )
{
	memset( data, 0, sizeof(SWSP_SYS) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNgf[^	NA
 *
 *	@param	data	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanObj( SWSP_OBJ* data )
{
	memset( data, 0, sizeof(SWSP_OBJ) );
	data->alpha	= 31;
	data->diffcolor = GX_RGB( 31, 31, 31 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^	NA
 *
 *	@param	data f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanChar( SWSP_CHAR* data )
{
	data->vramKey	= 0;
	NNS_G2dInitImageProxy( &data->imgProxy );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^	NA
 *
 *	@param	data	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanPltt( SWSP_PLTT* data )
{
	data->vramKey	= 0;
	NNS_G2dInitImagePaletteProxy( &data->imgProxy );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	SWSP_OBJe[u̍쐬
 *
 *	@param	num		e[u
 *	
 *	@return	SWSP_OBJ*	e[uf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_OBJ* makeObjData( int num, int heap )
{
	SWSP_OBJ* data;
	int i;	// [vp
	
	// IuWFNgf[^쐬
	data = sys_AllocMemory( heap, sizeof(SWSP_OBJ) * num );
	GF_ASSERT( data );

	for(i=0;i<num;i++){
		cleanObj( data + i );
	}

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^e[u쐬
 *
 *	@param	num		쐬
 *	@param	heap	gpq[v
 *
 *	@return	SWSP_CHAR*	쐬e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_CHAR* makeCharData( int num, int heap )
{
	SWSP_CHAR* data;
	int i;	// [vp
	
	// IuWFNgf[^쐬
	data = sys_AllocMemory( heap, sizeof(SWSP_CHAR) * num );
	GF_ASSERT( data );

	for(i=0;i<num;i++){
		cleanChar( data + i );
	}

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbge[u쐬
 *
 *	@param	num		쐬
 *	@param	heap	gpq[v
 *
 *	@return	SWSP_PLTT*	쐬e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_PLTT* makePlttData( int num, int heap )
{
	SWSP_PLTT* data;
	int i;	// [vp
	
	// IuWFNgf[^쐬
	data = sys_AllocMemory( heap, sizeof(SWSP_PLTT) * num );
	GF_ASSERT( data );

	for(i=0;i<num;i++){
		cleanPltt( data + i );
	}

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃IuWFf[^擾
 *
 *	@param	sys		擾XvCgVXef[^
 *
 *	@return	SWSP_OBJ*	̃IuWFNgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_OBJ* getCleanObj( SWSP_SYS* sys )
{
	int i;		// [vp

	for(i=0;i<sys->obj_num;i++ ){
		if( sys->obj_tbl[ i ].use == FALSE ){
			return ( sys->obj_tbl + i );
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃LN^f[^擾
 *
 *	@param	sys		\tgEFAXvCgVXef[^
 *
 *	@return	SWSP_CHAR*	̃LN^f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_CHAR* getCleanChar( SWSP_SYS* sys )
{
	int i;		// [vp

	for(i=0;i<sys->obj_num;i++ ){
		if( sys->char_tbl[ i ].vramKey == 0 ){
			return ( sys->char_tbl + i );
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃pbgf[^擾
 *
 *	@param	sys		\tgEFAXvCgVXef[^
 *
 *	@return	SWSP_PLTT*	̃pbg
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_PLTT* getCleanPltt( SWSP_SYS* sys )
{
	int i;		// [vp

	for(i=0;i<sys->obj_num;i++ ){
		if( sys->pltt_tbl[ i ].vramKey == 0 ){
			return ( sys->pltt_tbl + i );
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^]镪VramKey擾
 *
 *	@param	pChar	VramKey擾LN^
 *
 *	@return	NNSGfdTexKey	eNX`pVramKey
 *
 *
 */
//-----------------------------------------------------------------------------
static NNSGfdTexKey getCharVramKey( NNSG2dCharacterData* pChar )
{
	return NNS_GfdAllocTexVram( pChar->szByte, FALSE, 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbg{VramKey擾
 *
 *	@param	pltt_num	pbg{iPUFŌvZj
 *
 *	@return	NNSGfdPlttKey	pbgVramKey
 *
 *
 */
//-----------------------------------------------------------------------------
static NNSGfdPlttKey getPlttVramKey( int pltt_num )
{ 
	return NNS_GfdAllocPlttVram( pltt_num * PLTT_16_SIZE, FALSE, 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	LN^f[^]
 *
 *	@param	pChar		]LN^f[^
 *	@param	vramKey		]恕]TCY
 *	@param	proxy		vNV
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void transCharData( NNSG2dCharacterData* pChar, NNSGfdTexKey vramKey, NNSG2dImageProxy* proxy )
{
	// LN^f[^]
	NNS_G2dLoadImage2DMapping( 
			pChar,							// ]LN^f[^
			NNS_GfdGetTexKeyAddr(vramKey),	// ]
			NNS_G2D_VRAM_TYPE_3DMAIN,		// ]^Cv
			proxy );						// ]f[^i[
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^]
 *
 *	@param	pPltt		]pbgf[^
 *	@param	vramKey		]恕]TCY
 *	@param	proxy		vNV
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void transPlttData( NNSG2dPaletteData* pPltt, NNSGfdPlttKey vramKey, NNSG2dImagePaletteProxy* proxy )
{
	int tmp_size;		// TCYۑ
	
	// pbg]f[^TCYύX
	tmp_size = pPltt->szByte;
	pPltt->szByte = NNS_GfdGetPlttKeySize( vramKey );
	
	// pbgf[^]
	NNS_G2dLoadPalette( 
			pPltt,
			NNS_GfdGetPlttKeyAddr( vramKey ),
			NNS_G2D_VRAM_TYPE_3DMAIN,
			proxy
			);

	// pbgTCY߂
	pPltt->szByte = tmp_size;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	PIuWF̕\
 *
 *	@param	data	IuWFf[^
 *	@param	z_offs	ZItZbg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void darwObj( SWSP_OBJ* data )
{
	NNSG2dSVec2 uv0, uv1;
	
	G3_PushMtx();

	G3_MaterialColorDiffAmb(data->diffcolor,        // diffuse
							GX_RGB(31, 31, 31),        // ambient
							TRUE                       // use diffuse as vtx color if TRUE
							);

	G3_MaterialColorSpecEmi(GX_RGB(16, 16, 16),        // specular
							GX_RGB(0, 0, 0),           // emission
							FALSE                      // use shininess table if TRUE
							);
	
	
	// eNX`ݒ
	G3_TexImageParam( 
			data->tex_attr->fmt,		// eNX`tH[}bg
            GX_TEXGEN_TEXCOORD,         // eNX`R[h
            data->tex_attr->sizeS,      // eNX`TCY
            data->tex_attr->sizeT,      // eNX`TCY
            GX_TEXREPEAT_NONE,          // s[g邩
            GX_TEXFLIP_NONE,            // tbv邩
            data->tex_attr->plttUse,    // colorpbgO𔲂Fɂ邩
            data->tex_addr              // eNX`AhX
            );

	// pbgtH[}bgȂ...
	G3_TexPlttBase( (u32)(data->pltt_addr + (32 * data->pltt_offs)), data->tex_attr->fmt );                                
	
	// |SAgr[gݒ
	G3_PolygonAttr(GX_LIGHTMASK_NONE,           // disable lights
                   GX_POLYGONMODE_MODULATE,     // modulation mode
                   GX_CULL_NONE,                // cull back
                   0,							// polygon ID(0 - 63)
                   data->alpha,                 // alpha(0 - 31)
                   0                // OR of GXPolygonAttrMisc's value
                   );	
	
	// tbv
	if(data->flipH){
		uv0.x = data->size.x;
		uv1.x = 0;
	}else{
		uv1.x = data->size.x;
		uv0.x = 0;
	}
	
	if(data->flipV){
		uv0.y = data->size.y;
		uv1.y = 0;
	}else{
		uv1.y = data->size.y;
		uv0.y = 0;
	}
	
	// SWŉ]g
	G3_Translate( 
			(data->matrix.x + data->center.x) * FX32_ONE,
			(data->matrix.y + data->center.y) * FX32_ONE,
			data->priority * FX32_ONE );
	// Z]
    G3_RotZ( FX_SinIdx( data->rotZ ), FX_CosIdx( data->rotZ ) );
	// gkl
	G3_Scale( data->scale_x, data->scale_y, FX32_ONE );

	// Wݒij	C[WNbvȂǂŎgpĂ邽ߍύX邱Ƃ͂łȂ
	G3_Translate( 
			-data->center.x * FX32_ONE,
			-data->center.y * FX32_ONE,
			0 );

	
	// `
	NNS_G2dDrawSpriteFast( 
			0, 0, 0,
			data->size.x, data->size.y,
			uv0.x, uv0.y,
			uv1.x, uv1.y );

	G3_PopMtx(1);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgf[^ݒ肷
 *
 *	@param	obj			IuWFNgf[^
 *	@param	add			o^f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setSpriteData( SWSP_OBJ* obj, const SWSP_ADDDATA* add )
{
	int i;
	int size_x, size_y;
	fx32 l_u, l_v;	// UV
	fx32 r_u, r_v;	// EUV
	
	// UVlݒ
	size_x = 8;
	for(i=0;i<add->p_char->imgProxy.attr.sizeS;i++){
		size_x *= 2;
	}//*/
	size_y = 8;
	for(i=0;i<add->p_char->imgProxy.attr.sizeT;i++){
		size_y *= 2;
	}//*/
	
	l_u = 0;
	l_v = 0;
	r_u = size_x << FX32_SHIFT;
	r_v = size_y << FX32_SHIFT;

	// Wݒ
	SWSP_SetSpritePos( obj, add->m_x, add->m_y );

	// SW
	SWSP_SetSpriteCenterPos( obj, size_x / 2, size_y / 2 );

	// gkl
	obj->scale_x = FX32_ONE;
	obj->scale_y = FX32_ONE;

	// TCYݒ
	SWSP_SetSpriteSize( obj, size_x, size_y );

	//@D揇ʐݒ
	SWSP_SetSpritePriority( obj, add->pri );

	// lݒ
	SWSP_SetSpriteAlpha( obj, add->alpha );

	// eNX`Agr[gݒ
	SWSP_SetSpriteTexAttr( obj, &add->p_char->imgProxy.attr );

	// eNX`AhXݒ
	SWSP_SetSpriteTexAddr( obj, NNS_G2dGetImageLocation( &add->p_char->imgProxy, NNS_G2D_VRAM_TYPE_3DMAIN ) );

	// pbgAhXݒ
	SWSP_SetSpritePlttAddr( obj, NNS_G2dGetImagePaletteLocation( &add->p_pltt->imgProxy, NNS_G2D_VRAM_TYPE_3DMAIN ) );

	// pbgItZbgݒ
	SWSP_SetSpritePlttOffs( obj, add->pltt_offs );
	

	// tbvݒ
	SWSP_SetSpriteFlip( obj, SWSP_FLIPH, FALSE );
	SWSP_SetSpriteFlip( obj, SWSP_FLIPV, FALSE );

	SWSP_SetSpriteRotZ( obj, add->rota );
}

