//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		wipe.c
 *@brief	DPʐ؂ւVXe
 *@author	tomoya takahashi
 *@data		2005.08.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <string.h>
#include "system.h"
#include "tcb.h"
#include "assert.h"
#include "system/lib_pack.h"
#include "system/wipe_wnd.h"
#include "include/system/brightness.h"
#include "include/gflib/sdkdef.h"

#define	__WIPE_H_GLOBAL
#include "system/wipe.h"
#define __WIPE_DEF_H_GLOBAL
#define __WIPE_DEF_H_GLOBAL_VAL
#include "system/wipe_def.h"
#include "system/wipe_sub.h"




//-------------------------------------
//	
//	Vblankɓo^f[^
//	
//=====================================
typedef struct {
	WIPE_HBLANK* p_wipehb;
	void*	work;
	pHBFunc	func;
	int		disp;
} WIPE_V_HBLANK;

//-------------------------------------
//	
//	vblankɔjf[^
//	
//=====================================
typedef struct {
	WIPE_HBLANK* p_wipehb;
	int disp;
} WIPE_V_DELHBLANK;


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
// ʐ؂ւp^[萔
enum{
	WIPE_THE_SAME_TIME = 0,		// 
	WIPE_START_MAIN,			// CJn
	WIPE_START_SUB,				// TuJn
};


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	ʐ؂ւp^[e[u
//	
//=====================================
typedef struct {
	// ʐ؂ւp^[tO
	int wipe_pattern;
	
	// CTũCv̑݁A񑶍݃tO
	BOOL wipe_exist_m;	// CvIFALSEɂȂĂ܂	CvI`FbNp
	BOOL wipe_exist_s;	// CvIFALSEɂȂĂ܂	CvIp

	BOOL wipe_exist_m_check;	// CvIĂTRUÊ܂܂łB	Cv݃`FbNp
	BOOL wipe_exist_s_check;	// CvIĂTRUÊ܂܂łB	Cv݃`FbNp
} WIPE_SYS_PATTERN_DATA;


//-------------------------------------
//	
//	tF[hVXef[^
//	
//=====================================
typedef struct _WIPE_SYS_DATA{
	// tF[hp^[f[^
	WIPE_SYS_PATTERN_DATA	wipe_pattern_data;

	// Cvf[^
	WIPE_SYS_WIPE_WORK	wipe_m;
	WIPE_SYS_WIPE_WORK	wipe_s;

	// HBlank[N
	WIPE_HBLANK			wipehb;

	// wndsys[N
	WNDP_SYS	wnd_sys;

	// tO
	u16 move_flg;	
	u8 effect_flg_m;	// ʂɉeĂ邩
	u8 effect_flg_s;	// ʂɉeĂ邩

	// tF[hAEgJ[
	u16 fade_color;

} WIPE_SYS_DATA;	// size		316byte

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

static void endWipe(WIPE_SYS_DATA* scchg);
static void cleanWipeData( WIPE_SYS_DATA* p_wipe_data );

static void scchg_HBlankWorkSet( WIPE_HBLANK* p_wipehb );
static void scchg_HBlankFunc(void * work);
static void scchg_v_HBlankInit(TCB_PTR tcb, void* work);
static void scchg_v_HBlankDelete(TCB_PTR tcb, void* work);
static BOOL screenChangeSub(WIPE_SYS_PATTERN_DATA* pattern, WIPE_SYS_WIPE_WORK* wipe_m, WIPE_SYS_WIPE_WORK* wipe_s);

static void wipeFuncPack(BOOL* exist, WIPE_SYS_WIPE_WORK* wipe);
static BOOL wipeFunc(WIPE_SYS_WIPE_WORK* wipe);

static void setScreenChangePattern(int no, WIPE_SYS_PATTERN_DATA* pattern);
static void setWipeWork(WIPE_SYS_WIPE_WORK* wipe_w, int wipe_no, int division, int piece_sync, int sequence, void* work, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb,  int heap, u16 color);
static void patternDataSet(WIPE_SYS_PATTERN_DATA* pattern_data, int pattern, BOOL exist_m, BOOL exist_s);

static void setBackDropColor( u16 color );

static u16 getSetColor( WIPE_SYS_DATA* p_data, u16 color );
static u16 getSaveWiepColor( const WIPE_SYS_DATA* cp_data );
static void chgWnd_MstBrightnessCheck_Do( WIPE_SYS_WIPE_WORK* p_data );
static void resetMstBrightnessCheck_Do( WIPE_SYS_WIPE_WORK* p_data );


static BOOL WipeFadeInCheck( u32 wipe_type );

static void resetMstBrightnessVblank( TCB_PTR tcb, void* work );


//-----------------------------------------------------------------------------
/**
 *					O[o錾錾
*/
//-----------------------------------------------------------------------------
const static pWIPEFunc WipeFunc[] = {
	WipeFunc00,
	WipeFunc01,
	WipeFunc02,
	WipeFunc03,
	WipeFunc04,
	WipeFunc05,
	WipeFunc06,
	WipeFunc07,
	WipeFunc08,
	WipeFunc09,
	WipeFunc10,
	WipeFunc11,
	WipeFunc12,
	WipeFunc13,
	WipeFunc14,
	WipeFunc15,
	WipeFunc16,
	WipeFunc17,
	WipeFunc18,
	WipeFunc19,
	WipeFunc20,
	WipeFunc21,
	WipeFunc22,
	WipeFunc23,
	WipeFunc24,
	WipeFunc25,
	WipeFunc26,
	WipeFunc27,
	WipeFunc28,
	WipeFunc29,
	WipeFunc30,
	WipeFunc31,
	WipeFunc32,
	WipeFunc33,
	WipeFunc34,
	WipeFunc35,
	WipeFunc36,
	WipeFunc37,
	WipeFunc38,
	WipeFunc39,
	WipeFunc40,
	WipeFunc41,
};

//-------------------------------------
//
//	CvVXe[N
//	316byte
//	
//	̂̉ʂŎgpVXê
//	O[oɃ[NƂɂ܂
//=====================================
static WIPE_SYS_DATA WipeSysWork;

//----------------------------------------------------------------------------
/**
 *@brief	ʐ؂ւCvJn
 *
 *@param	pattern		؂ւp^[ԍ
 *@param	wipe_m		Cv@@CʃCvԍ
 *@param	wipe_s		Cv@@TuʃCvԍ
 *@param	color		Cv̐F
 *@param	division	eCv̕
 *@param	piece_sync	eCv̏𕪊PЂ̃VN
 *@param	heap		gpq[v
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
void WIPE_SYS_Start(int pattern, int wipe_m, int wipe_s, u16 color, int division, int piece_sync, int heap)
{
	WIPE_SYS_DATA* scw;
	u16 set_color;
	
	//"division Oł"
	GF_ASSERT(division);
	//"piece_sync Oł"
	GF_ASSERT(piece_sync);
	// 쒆ȂƂ߂
	GF_ASSERT( WipeSysWork.move_flg == FALSE );

	// [N|C^ݒ
	scw = &WipeSysWork;
	// [N
	cleanWipeData( scw );

	// ؂ւp^[f[^쐬
	setScreenChangePattern(pattern, &scw->wipe_pattern_data);

	// HBlank[N̏ݒ
	scchg_HBlankWorkSet( &scw->wipehb );

	// ݒJ[擾
	set_color = getSetColor( scw, color );
	
	// Cv[N̍쐬
	setWipeWork(&scw->wipe_m, wipe_m, division, piece_sync, 0, NULL, WIPE_DISP_MAIN, &scw->wnd_sys, &scw->wipehb, heap, set_color);
	setWipeWork(&scw->wipe_s, wipe_s, division, piece_sync, 0, NULL, WIPE_DISP_SUB, &scw->wnd_sys, &scw->wipehb, heap, set_color);

	scw->move_flg	= TRUE;			// 쒆ɂ	

	// ֐s
	// Pڂ̓͏ɂȂĂ
	// ŁAʂ̐ݒiEBhE}XNōAuCglX̏ݒȂj
	// ̂łŌĂ
	wipeFuncPack(&scw->wipe_pattern_data.wipe_exist_m, &scw->wipe_m);
	wipeFuncPack(&scw->wipe_pattern_data.wipe_exist_s, &scw->wipe_s);
		
	// tF[hC̎@@̂Ƃ@@EBhEgpCv
	// Ȃ΁AײȽݒOFF
	if( scw->wipe_pattern_data.wipe_exist_m_check ){
		resetMstBrightnessCheck_Do( &scw->wipe_m );
		scw->effect_flg_m = TRUE;
	}
	if( scw->wipe_pattern_data.wipe_exist_s_check ){
		resetMstBrightnessCheck_Do( &scw->wipe_s );
		scw->effect_flg_s = TRUE;
	}

}


//----------------------------------------------------------------------------
/**
 *	@brief	ʐ؂ւCvC֐
 *
 *	@param	none
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WIPE_SYS_Main( void )
{
	WIPE_SYS_DATA* scw = &WipeSysWork;
	BOOL	ret;

	// tOĂƂ̂ݓ
	if( scw->move_flg  ){
		ret = screenChangeSub(&scw->wipe_pattern_data, &scw->wipe_m, &scw->wipe_s);
		if(ret == TRUE){
			// CvI
			endWipe( scw );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ʐ؂ւCv@I`FbN
 *
 *	@param	none
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL WIPE_SYS_EndCheck( void )
{
	if( WipeSysWork.move_flg ){
		return FALSE;
	}
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Cv̋I
 *
 *	@param	none
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WIPE_SYS_ExeEnd( void )
{
	// HBLANK
	WIPE_HBlankDelete( &WipeSysWork.wipehb, WIPE_DISP_MAIN );
	WIPE_HBlankDelete( &WipeSysWork.wipehb, WIPE_DISP_SUB );
	// WND[Nj
	if( WipeSysWork.wipe_pattern_data.wipe_exist_m ){
		WipeSysWork.wipe_m.sequence = WIPE_END;	
	}
	if( WipeSysWork.wipe_pattern_data.wipe_exist_s ){
		WipeSysWork.wipe_s.sequence = WIPE_END;	
	}
	wipeFuncPack(&WipeSysWork.wipe_pattern_data.wipe_exist_m,
			&WipeSysWork.wipe_m);
	wipeFuncPack(&WipeSysWork.wipe_pattern_data.wipe_exist_s,
			&WipeSysWork.wipe_s);
	// CvI
	WipeSysWork.move_flg = FALSE;	// OFF
	WipeSysWork.effect_flg_m = FALSE;
	WipeSysWork.effect_flg_s = FALSE;
	// [ÑNA
	cleanWipeData( &WipeSysWork );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Cvʂɉe^Ă邩`FbN
 *
 *	@retval	TRUE	CvԃNAĂ
 *	@retval	FALSE	CvԃNAĂȂ
 */
//-----------------------------------------------------------------------------
BOOL WIPE_SYS_EffectCheck( void )
{
	if( (WipeSysWork.effect_flg_m == TRUE) ||
		(WipeSysWork.effect_flg_s == TRUE) ){
		return FALSE;
	}
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CvԂ
 *
 *	@param	disp	
 *	@param	heap	gpq[v
 *
 *	@return	none
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu
 *
 */
//-----------------------------------------------------------------------------
void WIPE_Reset( int disp )
{
	WIPE_ResetWndMask( disp );
	WIPE_ResetBrightness( disp );

	if( disp == WIPE_DISP_MAIN ){
		WipeSysWork.effect_flg_m = FALSE;
	}else{
		WipeSysWork.effect_flg_s = FALSE;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhE}XNԂ
 *
 *	@param	disp	
 *
 *	@return
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu
 *
 * ̊֐
 *	 n[hEFAEBhEgpCv
 * @uCglXgpCvɈڍs鎞ɁA
 * @n[hEFAEBhE̐ݒׂɎgp܂B
 * 
 */
//-----------------------------------------------------------------------------
void WIPE_ResetWndMask( int disp )
{
	// EBhE}XN
	WNDP_SetVisibleWnd(GX_WNDMASK_NONE, disp);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	uCglXԂ
 *
 *	@param	disp	
 *
 *	@return	none
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu
 *
 * ̊֐
 *	 uCglXgpCv
 * @n[hEFAEBhEgpCvɈڍs鎞ɁA
 * @uCglX̐ݒׂɎgp܂B
 */
//-----------------------------------------------------------------------------
void WIPE_ResetBrightness( int disp )
{
	// uCglX
	WIPE_SetMstBrightness( disp, BRIGHTNESS_NORMAL );
}

//----------------------------------------------------------------------------
/**
 *	@brief	CvuCglXԂݒ
 *
 *	@param	disp	ݒ肷
 *	@param	color	uCglXJ[
 *
 *	@return	none
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu

 *	color
			#define WIPE_FADE_WHITE		(0x7fff)	// zCgCEAEg
			#define WIPE_FADE_BLACK		(0x0000)	// ubNCEAEg
 */
//-----------------------------------------------------------------------------
void WIPE_SetBrightness( int disp, u16 color )
{
	int color_msk;

	if( color == WIPE_FADE_WHITE ){
		color_msk = BRIGHTNESS_WHITE;
	}else{
		color_msk = BRIGHTNESS_BLACK;
	}
	
	WIPE_SetMstBrightness( disp, color_msk);
}

//----------------------------------------------------------------------------
/**
 *	@brief	CvEBhE}XNԂݒ
 *
 *	@param	disp		ݒ肷
 *	@param	color		J[
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu

 *	color
			#define WIPE_FADE_WHITE		(0x7fff)	// zCgCEAEg
			#define WIPE_FADE_BLACK		(0x0000)	// ubNCEAEg
			#define WIPE_FADE_OUTCOLOR	(0xffff)	// 1ÕtF[hAEgJ[ŃCEAEg
 *
 *	̊֐́A
 *		^b`ygpʂ̏ꍇɁAtF[hCOɃ^b`y
 *		oȂǁAO܂B̂Ƃp̊֐ł
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WIPE_SetWndMask( int disp, u16 color )
{
	// obNhbvcolor̎w
	if( disp == WIPE_DISP_MAIN ){
		GX_LoadBGPltt((void*)&color, 0, sizeof(short));
	}else{
		GXS_LoadBGPltt((void*)&color, 0, sizeof(short));
	}
	
	// EBhEOʂŉʂ𕢂
	WNDP_V_SetVisibleWnd(&WipeSysWork.wnd_sys, GX_WNDMASK_W0, disp);
	WNDP_V_SetWndInsidePlane(&WipeSysWork.wnd_sys, GX_BLEND_ALL, FALSE, 0, disp);
	WNDP_V_SetWndPosition(&WipeSysWork.wnd_sys, 0,0,0,0,0, disp);	
	WNDP_V_SetWndOutsidePlane(&WipeSysWork.wnd_sys, GX_BLEND_PLANEMASK_BD, FALSE, disp);	
}




//----------------------------------------------------------------------------
/**
 *	@brief	wiʃpbgFݒ
 *
 *	@param	color	J[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WIPE_SetBackDropColor( u16 color )
{
	// obNhbvcolor̎w
	GX_LoadBGPltt((void*)&color, 0, sizeof(short));
	GXS_LoadBGPltt((void*)&color, 0, sizeof(short));
}

//----------------------------------------------------------------------------
/**
 *	@brief	uCglXlݒ֐
 *
 *	@param	disp	
 *	@param	no		ݒl
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WIPE_SetMstBrightness( int disp, int no )
{
	// uCglX
	if( disp == WIPE_DISP_MAIN ){
		GX_SetMasterBrightness(no);
	}else{
		GXS_SetMasterBrightness(no);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ʐ؂ւtF[hI
 *
 *@param	scchg	ʐ؂ւf[^
 *
 *@return	none
 *
 *
 * IɕKĂԕKv܂B
 *
 */
//-----------------------------------------------------------------------------
static void endWipe(WIPE_SYS_DATA* scchg)
{
	scchg->move_flg = FALSE;	// OFF
	
	// CvJ[̕ۑ
	scchg->fade_color = getSaveWiepColor( scchg );

	// tF[hAEg̎@@̂Ƃ@@EBhEgpCv
	// Ȃ΁AϽײȽݒ肵ăEBhEj
	if( scchg->wipe_pattern_data.wipe_exist_m_check ){
		chgWnd_MstBrightnessCheck_Do( &scchg->wipe_m );

		// tF[hCȂeffect_flgj
		if( scchg->wipe_m.fade_inout == WIPE_FADE_IN ){
			WipeSysWork.effect_flg_m = FALSE;
		}
	}
	if( scchg->wipe_pattern_data.wipe_exist_s_check ){
		chgWnd_MstBrightnessCheck_Do( &scchg->wipe_s );

		// tF[hCȂeffect_flgj
		if( scchg->wipe_m.fade_inout == WIPE_FADE_IN ){
			WipeSysWork.effect_flg_s = FALSE;
		}
	}

	// [ÑNA
	cleanWipeData( scchg );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ʐ؂ւTu֐
 *
 *@param	pattern		؂ւp^[
 *@param	wipe_m		CvC
 *@param	wipe_s		CvTu
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL screenChangeSub(WIPE_SYS_PATTERN_DATA* pattern, WIPE_SYS_WIPE_WORK* wipe_m, WIPE_SYS_WIPE_WORK* wipe_s)
{	
	switch(pattern->wipe_pattern){
	case WIPE_THE_SAME_TIME:	// 
		wipeFuncPack(&pattern->wipe_exist_m, wipe_m);
		wipeFuncPack(&pattern->wipe_exist_s, wipe_s);
		break;	
		
	case WIPE_START_MAIN:		// C
		if(pattern->wipe_exist_m){
			wipeFuncPack(&pattern->wipe_exist_m, wipe_m);
		}else{
			wipeFuncPack(&pattern->wipe_exist_s, wipe_s);
		}
		break;	
	case WIPE_START_SUB:		// Tu
		if(pattern->wipe_exist_s){
			wipeFuncPack(&pattern->wipe_exist_s, wipe_s);
		}else{
			wipeFuncPack(&pattern->wipe_exist_m, wipe_m);
		}	
		break;	
	}
	
	// ̃Cv̑݃tOFALSEɂȂI
	if((pattern->wipe_exist_m == FALSE) &&
		(pattern->wipe_exist_s == FALSE)){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cv֐pbN֐
 *	
 *@param	exist	݃tOiWIPE_SYS_PATTERN_DATAj
 *@param	wipe	Cv[N
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void wipeFuncPack(BOOL* exist, WIPE_SYS_WIPE_WORK* wipe)
{
	int ret;
	
	if(*exist){

		ret = wipeFunc(wipe);	

		if(ret == TRUE){
			*exist = FALSE;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cv֐s
 *
 *@param	wipe	Cvf[^
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL wipeFunc(WIPE_SYS_WIPE_WORK* wipe)
{
	return WipeFunc[wipe->wipe_no](wipe);	
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ʕύXp^[f[^쐬
 *
 *@param	no			p^[io[
 *@param	pattern_m	C̃p^[f[^i[̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setScreenChangePattern(int no, WIPE_SYS_PATTERN_DATA* pattern)
{
	switch(no){
	case WIPE_PATTERN_WMS:
		patternDataSet(pattern, WIPE_THE_SAME_TIME, TRUE, TRUE);
		break;
		
	case WIPE_PATTERN_FMAS:
		patternDataSet(pattern, WIPE_START_MAIN, TRUE, TRUE);
		break;
		
	case WIPE_PATTERN_FSAM:
		patternDataSet(pattern, WIPE_START_SUB, TRUE, TRUE);
		break;
		
	case WIPE_PATTERN_M:
		patternDataSet(pattern, WIPE_START_MAIN, TRUE, FALSE);
		break;
		
	case WIPE_PATTERN_S:
		patternDataSet(pattern, WIPE_START_SUB, FALSE, TRUE);
		break;
	};
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	p^[f[^ݒ
 *
 *@param	pattern_data	p^[f[^ݒ
 *@param	pattern			p^[
 *@param	exist_m			CCv݃tO
 *@param	exist_s			TuCv݃tO
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void patternDataSet(WIPE_SYS_PATTERN_DATA* pattern_data, int pattern, BOOL exist_m, BOOL exist_s)
{
	pattern_data->wipe_pattern = pattern;
	pattern_data->wipe_exist_m = exist_m;
	pattern_data->wipe_exist_s = exist_s;
	pattern_data->wipe_exist_m_check = exist_m;
	pattern_data->wipe_exist_s_check = exist_s;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cv[Nf[^ݒ
 *
 *@param	wipe_w		ݒ
 *@param	wipe_no		Cvio[
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	sequence	V[PX
 *@param	work		[N̈
 *@param	disp		
 *@param	wnd_sys		EBhEVXe|C^
 *@param	heap		gpq[v
 *@param	color		F
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void setWipeWork(WIPE_SYS_WIPE_WORK* wipe_w, int wipe_no, int division, int piece_sync, int sequence, void* work, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb,  int heap, u16 color)
{
	wipe_w->wipe_no		= wipe_no;
	wipe_w->division	= division;
	wipe_w->piece_sync	= piece_sync;
	wipe_w->sequence	= sequence;
	wipe_w->wipe_work	= work;
	wipe_w->disp		= disp;
	wipe_w->wnd_sys		= wnd_sys;
	wipe_w->p_wipehb	= p_wipehb;
	wipe_w->heap		= heap;
	wipe_w->color		= color;
}




//----------------------------------------------------------------------------
//
//
//	GtFNgpHuN֐S
//
//
//============================================================================

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuN[N̏lݒ
 *
 *	@param	p_wipehb	CvHuN[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_HBlankWorkSet( WIPE_HBLANK* p_wipehb )
{
	int i;
	for( i=0; i<2; i++ ){
		p_wipehb->work[ i ] = NULL;
		p_wipehb->func[ i ] = defaultHFunc;
		p_wipehb->flg[ i ]	= 0;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HBlank֐
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_HBlankFunc(void * work)
{
	int i;		// [vp
	WIPE_HBLANK* p_wipehb = work;

	for(i=0;i<2;i++){
		p_wipehb->func[i](p_wipehb->work[i]);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuN֐ݒ
 *
 *@param	p_wipehb	CvVXeHuN[N\
 *@param	work		[N
 *@param	func		HuN֐
 *@param	disp		\ʁiCTuj
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_HBlankInit(WIPE_HBLANK* p_wipehb, void* work, pHBFunc func, int disp)
{
	u8	result=TRUE;
	GF_ASSERT((p_wipehb->flg[disp] == 0));
	GF_ASSERT( p_wipehb->func[disp] != NULL );	// NULLƂ

	if((p_wipehb->flg[0] == 0) &&
		(p_wipehb->flg[1] == 0)){
		result = sys_HBlankIntrSet(scchg_HBlankFunc, p_wipehb);		// ֐ݒ
	}
	GF_ASSERT(result == TRUE);

	
	p_wipehb->work[disp] = work;
	if(func){
		p_wipehb->func[disp] = func;
	}else{
		p_wipehb->func[disp] = defaultHFunc;
	}
	p_wipehb->flg[disp] = WIPE_HBLANK_DO;

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNj
 *
 *@param	p_wipehb	CvHuN[N
 *@param	disp		\	CETu
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_HBlankDelete(WIPE_HBLANK* p_wipehb, int disp)
{
	p_wipehb->flg[disp] = WIPE_HBLANK_NONE;

	if((p_wipehb->flg[0] == 0) &&
		(p_wipehb->flg[1] == 0)){
		sys_HBlankIntrStop();		//HBlank荞ݒ~
	}
	
	p_wipehb->func[disp] = defaultHFunc;
	p_wipehb->work[disp] = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VuNԒHuN֐ݒ
 *
 *@param	work		[N
 *@param	func		HuN֐
 *@param	disp		\
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_V_HBlankInit(WIPE_HBLANK* p_wipehb, void* work, pHBFunc func, int disp, int heap)
{
	WIPE_V_HBLANK* data = sys_AllocMemoryLo(heap, sizeof(WIPE_V_HBLANK));
	
	data->p_wipehb = p_wipehb;
	data->work = work;
	data->func = func;
	data->disp = disp;
	VWaitTCB_Add( scchg_v_HBlankInit, data, WIPE_HBLANK_INIT_TCB);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNj
 *
 *@param	disp		\	CETu
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_V_HBlankDelete(WIPE_HBLANK* p_wipehb, int disp, int heap)
{
	WIPE_V_DELHBLANK* p_delhb = sys_AllocMemoryLo(heap, sizeof(WIPE_V_DELHBLANK));
	p_delhb->p_wipehb	= p_wipehb;
	p_delhb->disp		= disp;
	VWaitTCB_Add( scchg_v_HBlankDelete, p_delhb, WIPE_HBLANK_DELETE_TCB);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VblankԒHblank^XN
 *
 *@param	tcb		^XN|C^
 *@param	work	f[^	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_v_HBlankInit(TCB_PTR tcb, void* work)
{
	WIPE_V_HBLANK*	data = (WIPE_V_HBLANK*)work;
	
	WIPE_HBlankInit(data->p_wipehb, data->work, data->func, data->disp);

	TCB_Delete( tcb );
	sys_FreeMemoryEz( work );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VblankԒHblankj֐
 *
 *@param	tcb		^XN|C^
 *@param	work	jf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_v_HBlankDelete(TCB_PTR tcb, void* work)
{
	WIPE_V_DELHBLANK* p_delhb = (WIPE_V_DELHBLANK*)work;
	
	WIPE_HBlankDelete(p_delhb->p_wipehb, p_delhb->disp);
	
	TCB_Delete( tcb );
	sys_FreeMemoryEz( work );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuN֐	NULLnꂽݒ肳֐
 *
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void defaultHFunc( void* work )
{
}


//----------------------------------------------------------------------------
/**
 *	@brief	CvJ[擾
 *
 *	@param	p_data	Cvf[^
 *	@param	color	J[p[^
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
static u16 getSetColor( WIPE_SYS_DATA* p_data, u16 color )
{
	if( color == WIPE_FADE_OUTCOLOR ){
		return p_data->fade_color;
	}
	return color;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃Cvf[^̕ۑ
 *
 *	@param	cp_data	[N
 *
 *	@return	ۑJ[
 */
//-----------------------------------------------------------------------------
static u16 getSaveWiepColor( const WIPE_SYS_DATA* cp_data )
{
	const WIPE_SYS_WIPE_WORK* cp_wipe_w;
	
	// Cvł̃tF[hAEg̏ꍇ
	// Fۑ
	if( cp_data->wipe_pattern_data.wipe_exist_m_check == TRUE ){
		cp_wipe_w = &cp_data->wipe_m;
	}else{
		cp_wipe_w = &cp_data->wipe_s;
	}

	// CvFۑ
	if( cp_wipe_w->fade_inout == WIPE_FADE_OUT ){
		return cp_wipe_w->color;
	}
	return cp_data->fade_color;	// ̂܂
}

//----------------------------------------------------------------------------
/**
 *	@brief	VuNϽPxZbgTCB
 */
//-----------------------------------------------------------------------------
static void resetMstBrightnessVblank( TCB_PTR tcb, void* work )
{
	WIPE_SYS_WIPE_WORK* p_data = work;
	WIPE_SetMstBrightness( p_data->disp, 0 );	
	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	}X^[ײȽԂZbg
 *
 *	@param	p_data	[N
 */
//-----------------------------------------------------------------------------
static void resetMstBrightnessCheck_Do( WIPE_SYS_WIPE_WORK* p_data )
{
	// tF[hC̎@@̂Ƃ@@EBhEgpCv
	// Ȃ΁AײȽݒOFF
	if( (p_data->fade_inout == WIPE_FADE_IN) &&
		((p_data->color == WIPE_FADE_WHITE) || (p_data->color == WIPE_FADE_BLACK)) &&
		(p_data->wnd_br == WIPE_USE_WND) ){

		VWaitTCB_Add( resetMstBrightnessVblank, p_data, WIPE_VBLANK_BR_RESET_TCB );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hAEgŃEBhEݒ莞ɔ̂Ƃ́AϽ[ײȽɂ
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void chgWnd_MstBrightnessCheck_Do( WIPE_SYS_WIPE_WORK* p_data )
{
	// tF[hAEg̎@@̂Ƃ@@EBhEgpCv
	// Ȃ΁AϽײȽݒ肵ăEBhEj
	if( (p_data->fade_inout == WIPE_FADE_OUT) &&
		((p_data->color == WIPE_FADE_WHITE) || (p_data->color == WIPE_FADE_BLACK)) &&
		(p_data->wnd_br == WIPE_USE_WND) ){

		// ײȽݒ
		WIPE_SetBrightness( p_data->disp, p_data->color );

		// EBhEj
		WIPE_ResetWndMask( p_data->disp);
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Cvf[^ɂ
 *
 *	@param	p_wipe_data		Cvf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void cleanWipeData( WIPE_SYS_DATA* p_wipe_data )
{
	memset( &p_wipe_data->wipe_pattern_data, 0, sizeof(WIPE_SYS_PATTERN_DATA) );
	memset( &p_wipe_data->wipe_m, 0, sizeof(WIPE_SYS_WIPE_WORK) );
	memset( &p_wipe_data->wipe_s, 0, sizeof(WIPE_SYS_WIPE_WORK) );
	memset( &p_wipe_data->wipehb, 0, sizeof(WIPE_HBLANK) );
	memset( &p_wipe_data->wnd_sys, 0, sizeof(WNDP_SYS) );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hC
 *
 *	@param	wipe_type	Cv
 *
 *	@retval	TRUE	tF[hC
 *	@retval	FALSE	tF[hAEg
 */
//-----------------------------------------------------------------------------
static BOOL WipeFadeInCheck( u32 wipe_type )
{
	// z[AEgC߂́AtF[hC
	if( (wipe_type % 2) ){
		return TRUE;
	}
	return FALSE;
}

