//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		wipe_sub.c
 *@brief	ʂ肩Cv
 *@author	tomoya takahashi
 *@data		2005.08.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "string.h"
#include "calctool.h"
#include "system/wipe_def.h"
#include "system/wipe.h"
#include "include/gflib/sdkdef.h"
#include "include/system/brightness.h"

#define __WIPE_SUB_H_GLOBAL
#include "system/wipe_sub.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define SUM_NUM_MINI	(128)
#define ROTA_NUM(x)		((0xffff*(x))/360)

// hAp
// ̒l,̊JĂlƊpxoĂ
#define	WIPE_DOOR_ROTA_NUM	(21)
//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	}X^[uCglXtF[h[N
//	
//=====================================
typedef struct {
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg

	int set_num;
	int end_num;
	int add_num;
	int disp;
	
} WIPE_BRIGHTNESS_FADE;


//-------------------------------------
//	
//	EBhEWpbN
//	
//=====================================
typedef struct {
	int x1;
	int y1;
	int x2;
	int y2;
} WIPE_WND_POSITION;


//-------------------------------------
//	
//	EBhEό`\
//
//	Vb^[EC/AEg
//	XChEC/AEg
//	Vb^[EC/AEg
//	{bNXEC/AEg
//	p\̂łB
//	
//=====================================
typedef struct {
	WIPE_WND_POSITION st;	// JnW
	WIPE_WND_POSITION add;	// ZW
	WIPE_WND_POSITION ed;	// IW

	int disp;		// 
	int wnd_no;		// EBhEio[
	
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;
} WIPE_TYPE_WND_MOVE;

//-------------------------------------
//	
//	EBhEό`p
//	
//=====================================
typedef struct {
	WIPE_WND_POSITION st;	// JnW
	WIPE_WND_POSITION ed;	// IW

	u8 wnd_no;		// EBhEio[

	u8 in_wnd;		// EBhE̒
	u8 out_wnd;	// EBhE̊O

	u8 fade_flg;	// tF[htO

} WIPE_TYPE_WND_MOVE_FP;


//-------------------------------------
//	
//	EBhEό`\
//	EBhEQgƂ悤
//
//	XvbgEC/AEg
//	
//=====================================
typedef struct {
	WIPE_TYPE_WND_MOVE wnd0;
	WIPE_TYPE_WND_MOVE wnd1;
} WIPE_TYPE_WND_DMOVE;

//-------------------------------------
//	
//	HBlankwndf[^
//	\
//	
//=====================================
typedef struct {
	short	wnd_data[2][192];	// wndf[^
	short	wnd_tmp[2][192];		// C[vvZp
	
	int wnd_no;		// EBhEio[
} WIPE_TYPE_HB_WND_ONE;

//-------------------------------------
//	
//	Hblankwndf[^
//	˂\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND_ONE* data;
	int wnd_data_num;
	int disp;		// 
} WIPE_TYPE_HB_WND;


//-------------------------------------
//	
//	HBlankgp~wndŕ`VXe
//	\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND hb_circle;	// HblankCIRCLEf[^
	int	r;		// a
	int x;		// SW
	int y;
	int add_r;		// aωl
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int heap;		// gpq[v
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;	// EBhEݒf[^ۑ̈
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
} WIPE_TYPE_WND_CIRCLE;

//-------------------------------------
//	
//	HBlankgp~wndŕ`VXe
//	pbN֐̈
//	
//=====================================
typedef struct {
	int r;
	int e_r;
	short x;
	short y;
	u8 wnd_no;
	u8 in_wnd;
	u8 out_wnd;
	u8 fade_flg;
} WIPE_TYPE_WND_CIRCLE_FP;

//-------------------------------------
//	
//	HBlankgpJ[ewndŕ`VXe
//	\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND hb_c;	// Hblankf[^
	int rota;		// Jpx
	int rota_add;	// PŊJpx
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N

	int heap;		// gpq[v
} WIPE_TYPE_WND_CURTAIN;

//-------------------------------------
//	
//	HBlankgpJ[e\VXe
//	pbN֐̈
//	
//=====================================
typedef struct {
	int rota;
	int e_rota;
	u8 wnd_no;
	u8 in_wnd;
	u8 out_wnd;
	u8 fade_flg;
} WIPE_TYPE_WND_CURTAIN_FP;


//-------------------------------------
//	
//	HBlankgphAwndŕ`VXe
//	\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND hb_d;	// Hblankf[^
	int open_max;	// ő̊J
	int open_r;		// J]l
	int open_r_a;	// l
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
	int heap;		// gpq[v
} WIPE_TYPE_WND_DOOR;

//-------------------------------------
//	
//	HBlankgphA\VXe
//	pbN֐̈
//	
//=====================================
typedef struct {
	int s_d;
	int e_d;
	u8 wnd_no;
	u8 in_wnd;
	u8 out_wnd;
	u8 fade_flg;
} WIPE_TYPE_WND_DOOR_FP;

//-------------------------------------
//	
//	ꂽEBhE̊eX̐ݒ
//	
//=====================================
typedef struct {
	WIPE_WND_POSITION st;	// JnW
	WIPE_WND_POSITION add;	// ZW
	WIPE_WND_POSITION ed;	// IW
} WIPE_TYPE_WND_D_PIECE;

//-------------------------------------
//	
//	P̃EBhE𕡐̃EBhE
//	gpĂ邩̂悤Ɏgp
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND		hb_divi;		// Hblankݒf[^
	
	WIPE_TYPE_WND_D_PIECE* piece_tbl;		// f[^
	int						piece_num;		// EBhE

	int a_count;		// ωiiKj
	int piece_sync;		// PЂ̃VN
	int sync_c;			// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;	// EBhEVblankύXVXẽ[N
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
	int heap;			// gpq[v
} WIPE_TYPE_WND_DIVI;

//-------------------------------------
//	
//	P̃EBhE𕡐̃EBhE
//	gpĂ邩̂悤Ɏgp	
//	p
//=====================================
typedef struct {
	const WIPE_WND_POSITION* p_st;	// eX̊JnW	D揇ʁiOj
	const WIPE_WND_POSITION* p_ed;	// eX̏IW
	u8 divi_num;				// 
	u8 wnd_no;
	u8 in_wnd;
	u8 out_wnd;
	u8 fade_flg;
} WIPE_TYPE_WND_DIVI_FP;


//-------------------------------------
//	
//	XN[P̃f[^
//	
//=====================================
typedef struct {
	int	rota;		// ݂̉]p
	int s_rota;		// ]pxl
	int add_num_rota;	// ]px̍őωl
} WIPE_TYPE_WND_SCREW_ONE;

//-------------------------------------
//	
//	XN[f[^\
//
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND		hb;		// Hblankݒf[^
	
	WIPE_TYPE_WND_SCREW_ONE screw;	// XN[f[^

	int a_count_max;	// ωiiKjő吔
	int a_count;		// ωiiKjJEgl
	int piece_sync;		// PЂ̃VN
	int sync_c;			// VNJEg
	int fade_flg;		// tF[htO
	int heap;			// q[v

	WNDP_SYS_PTR wnd_sys;	// EBhEVblankύXVXẽ[N
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
} WIPE_TYPE_WND_SCREW;

//-------------------------------------
//	
//	XN[֐
//	
//=====================================
typedef struct {
	int	s_rota;		// Jn]p
	int	e_rota;		// I]p
	
	u8 in_wnd;
	u8 out_wnd;
	u8 fade_flg;
} WIPE_TYPE_WND_SCREW_FP;

//-------------------------------------
//	
//	tbVSf[^
//	
//=====================================
typedef struct {
	int	rota;		// ݂̉]p
	int s_rota;		// ]pxl
	int add_num_rota;	// ]px̍őωl
} WIPE_TYPE_WND_FLASH_FOUR_ONE;

//-------------------------------------
//	
//	tbVSf[^\
//
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND		hb;		// Hblankݒf[^
	
	WIPE_TYPE_WND_FLASH_FOUR_ONE screw;	// XN[f[^

	int a_count_max;	// ωiiKjő吔
	int a_count;		// ωiiKjJEgl
	int piece_sync;		// PЂ̃VN
	int sync_c;			// VNJEg
	int fade_flg;		// tF[htO
	int heap;			// q[v

	WNDP_SYS_PTR wnd_sys;	// EBhEVblankύXVXẽ[N
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
} WIPE_TYPE_WND_FLASH_FOUR;

//-------------------------------------
//	
//	tbVS֐
//	
//=====================================
typedef struct {
	int	s_rota;		// Jn]p
	int	e_rota;		// I]p
	
	u8 in_wnd;
	u8 out_wnd;
	u8 fade_flg;
} WIPE_TYPE_WND_FLASH_FOUR_FP;

//-------------------------------------
//	VWND@HuN[N
//=====================================
typedef struct {
	u8 in_out_write[ 192 ];	// in_wnd out_wndtO
	u8 in_out_read[ 192 ];	// in_wnd out_wndtO
	
	int wnd_no;
} WIPE_TYPE_WND_VMOVE_HDATA;

//-------------------------------------
//	VWND@˂f[^
//=====================================
typedef struct {
	WIPE_TYPE_WND_VMOVE_HDATA data[2];
	u8 wnd_data_num;	// EBhEgp(ő2)
	u8 disp;		// 
} WIPE_TYPE_WND_VMOVE;
enum{
	WIPE_WND_VMOVE_INWND,
	WIPE_WND_VMOVE_OUTWND
};

//-------------------------------------
//	
//	cHuNgpEBhE
//	VXe
//	
//=====================================
//-------------------------------------
//	f[^
//
//	in_ouẗ̗悪s_ye_yւƍLĂ܂
//=====================================
typedef struct {
	u8 s_y;		
	u8 e_y;
	u8 in_out;		// WIPE_WND_VMOVE_INWND, WIPE_WND_VMOVE_OUTWND
} WIPE_TYPE_WND_VMOVE_DATA;

//-------------------------------------
//	Ǘf[^
//=====================================
typedef struct {
	WIPE_TYPE_WND_VMOVE HblankData;	// HuNf[^

	const WIPE_TYPE_WND_VMOVE_DATA* p_param;
	int param_num;

	int a_count_max;	// ωiiKjő吔
	int a_count;		// ωiiKjJEgl
	int piece_sync;		// PЂ̃VN
	int sync_c;			// VNJEg
	int fade_flg;		// tF[htO
	int heap;			// q[v

	WNDP_SYS_PTR wnd_sys;	// EBhEVblankύXVXẽ[N
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
} WIPE_TYPE_WND_VMOVE_CONT;

//-------------------------------------
//	p[^
//=====================================
typedef struct {
	const WIPE_TYPE_WND_VMOVE_DATA* cp_data;
	u8 data_num;
	u8 fade_flg;
} WIPE_TYPE_WND_VMOVE_PARAM;


//-------------------------------------
//
//	
//		|PCv
//
//	
//=====================================
//-------------------------------------
//	p[^
//=====================================
typedef struct {
	WIPE_TYPE_WND_MOVE_FP wnd_move;
	WIPE_TYPE_WND_VMOVE_PARAM wnd_split;
	fx32 sync_div_par;	// VN̊iwnd_move̊j
} WIPE_TYPE_WND_PESOCOM_PARAM;

//-------------------------------------
//	[N
//=====================================
typedef struct {
	WIPE_TYPE_WND_MOVE wnd_move;
	WIPE_TYPE_WND_VMOVE_CONT wnd_split;
	WIPE_TYPE_WND_PESOCOM_PARAM* p_param;
	u8 sub_divi;
	u8 seq;	// V[PX
	u8 fade_flg;
	u8 dummy;
} WIPE_TYPE_WND_PESOCOM;




//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
// evZp
static fx32 sum_tan(int rota);
static int sub_rota_height_width_one( int rota, int height );
static void sum_rota_height_width(int rota, int* depth, int work_num, int s_h);
static int sum_triangle_height(int rota, int undefground);
static int sum_add_num(int st, int ed, int divi);
static int sum_add_wnd_width(int num1, int num2);
static void sum_add_wnd(WIPE_WND_POSITION* num, WIPE_WND_POSITION* add);
static void sum_set_wnd_position(WIPE_WND_POSITION* st, WIPE_WND_POSITION* ed, WIPE_WND_POSITION* add, const WIPE_WND_POSITION* set_st, const WIPE_WND_POSITION* set_ed, int division );

// EBhEp
static void scchg_WndEnd(int flag, WNDP_SYS_PTR wnd_sys, int disp);
static void scchg_h_Wnd(void* work);
static void scchg_h_WndMake(WIPE_TYPE_HB_WND* data, int flag, int disp, int heap);
static void scchg_h_WndDel(WIPE_TYPE_HB_WND* data);
static void scchg_v_h_WndDel( TCB_PTR tcb, void* work );
static void scchg_main_h_WndDel( WIPE_TYPE_HB_WND* data );
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndNoDataGet(WIPE_TYPE_HB_WND* data, int wnd_no);
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndIdxDataGet(WIPE_TYPE_HB_WND* data, int idx);
static void scchg_WndSwap(TCB_PTR tcb, void* work);
static void scchg_WndSetUp(WNDP_SYS_PTR wnd_sys, int in_wnd, int out_wnd, int wnd_no, int disp, int x1, int y1, int x2, int y2, int fade_flg);
static void scchg_WndVisible(WNDP_SYS_PTR wnd_sys, int plane, int disp, int fade_flg);

// EBhEY쏈p
static void scchg_h_VMoveWndInit( WIPE_TYPE_WND_VMOVE* p_wnddata, int disp, int data_num, int wnd_no0, int wnd_no1 );

static void scchg_h_VMoveWnd_SwapReq( WIPE_TYPE_WND_VMOVE* p_wnddata );
static void scchg_h_VMoveWnd_Start( WIPE_HBLANK* p_wipehb, WIPE_TYPE_WND_VMOVE* p_wnddata, u32 heap );
static void scchg_h_VMoveWnd_End( WIPE_HBLANK* p_wipehb, WIPE_TYPE_WND_VMOVE* p_wnddata, u32 heap );

static void scchg_h_VMoveWnd_Swap( TCB_PTR tcb, void* p_work );
static void scchg_h_VMoveWnd_Main( void* p_work );


// uCglXtF[hp
static void scchg_FadeInit(WIPE_SYS_WIPE_WORK* wipe, int fade_flag);
static BOOL scchg_FadePack(WIPE_SYS_WIPE_WORK* wipe);
static BOOL scchg_FadeCalcMain( WIPE_BRIGHTNESS_FADE* data );

// lp\EBhEp
static void scchg_WndMovePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram );
static BOOL scchg_WndMovePack(WIPE_SYS_WIPE_WORK* wipe);

static void scchg_WndMoveDoublePackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram1, const WIPE_TYPE_WND_MOVE_FP* pram2);
static BOOL scchg_WndMoveDoublePack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndMoveInit(WIPE_TYPE_WND_MOVE* data, const WIPE_TYPE_WND_MOVE_FP* pram, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys);
static BOOL scchg_WndMoveMain(WIPE_TYPE_WND_MOVE* data);

// ~\EBhEp
static void scchg_WndCirclePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CIRCLE_FP* param );
static BOOL scchg_WndCirclePack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndCircleInit(WIPE_TYPE_WND_CIRCLE* data, const WIPE_TYPE_WND_CIRCLE_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap);
static BOOL scchg_WndCircleMain(WIPE_TYPE_WND_CIRCLE* data);
static void scchg_WndCircleSum(WIPE_TYPE_WND_CIRCLE* work);

// J[e^EBhE\p
static void scchg_WndCurtainPackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CURTAIN_FP* param);
static BOOL scchg_WndCurtainPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndCurtainInit(WIPE_TYPE_WND_CURTAIN* data, const WIPE_TYPE_WND_CURTAIN_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndCurtainMain(WIPE_TYPE_WND_CURTAIN* data);
static void scchg_WndCurtainSum(WIPE_TYPE_WND_CURTAIN* work);

// hA^EBhE\p

static void scchg_WndDoorPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DOOR_FP* param);
static BOOL scchg_WndDoorPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndDoorInit(WIPE_TYPE_WND_DOOR* data, const WIPE_TYPE_WND_DOOR_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndDoorMain(WIPE_TYPE_WND_DOOR* data);
static void scchg_WndDoorSum(WIPE_TYPE_WND_DOOR* work);

// 1EBhEVXe
static void scchg_WndDivisionPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DIVI_FP* param);
static BOOL scchg_WndDivisionPack(WIPE_SYS_WIPE_WORK* wipe);
static BOOL scchg_WndDivisionMain(WIPE_TYPE_WND_DIVI* data);
static void scchg_WndDivisionInit(WIPE_TYPE_WND_DIVI* data, const WIPE_TYPE_WND_DIVI_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static void scchg_WndDivisionEnd(WIPE_TYPE_WND_DIVI* data);
static void scchg_WndDivisionSum(WIPE_TYPE_WND_DIVI* work);
static void scchg_WndDivisionMainSub(WIPE_TYPE_WND_DIVI* data);
static void scchg_WndDivisionSumSub(WIPE_TYPE_HB_WND* hb_divi, WIPE_WND_POSITION* set);

// XN[
static void scchg_WndScrewPackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_SCREW_FP* param);
static BOOL scchg_WndScrewPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndScrewInit(WIPE_TYPE_WND_SCREW* data, WIPE_TYPE_WND_SCREW_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndScrewMain(WIPE_TYPE_WND_SCREW* data);
static void scchg_WndScrewEnd(WIPE_TYPE_WND_SCREW* data);
static void scchg_WndScrewSum(WIPE_TYPE_WND_SCREW* work);
static void scchg_WndScrewOneAdd( WIPE_TYPE_WND_SCREW_ONE* p_data, int count, int count_max );

// tbV@S
static void scchg_WndFlashFourPackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_FLASH_FOUR_FP* param);
static BOOL scchg_WndFlashFourPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndFlashFourInit(WIPE_TYPE_WND_FLASH_FOUR* data, WIPE_TYPE_WND_FLASH_FOUR_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndFlashFourMain(WIPE_TYPE_WND_FLASH_FOUR* data);
static void scchg_WndFlashFourEnd(WIPE_TYPE_WND_FLASH_FOUR* data);
static void scchg_WndFlashFourSum(WIPE_TYPE_WND_FLASH_FOUR* work);
static void scchg_WndFlashFourOneAdd( WIPE_TYPE_WND_FLASH_FOUR_ONE* p_data, int count, int count_max );


// HuNgp	EBhEYړVXe
static void scchg_WndWndVMovePackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_VMOVE_PARAM* param);
static BOOL scchg_WndWndVMovePack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndWndVMoveInit(WIPE_TYPE_WND_VMOVE_CONT* data, WIPE_TYPE_WND_VMOVE_PARAM* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndWndVMoveMain(WIPE_TYPE_WND_VMOVE_CONT* data);
static void scchg_WndWndVMoveEnd(WIPE_TYPE_WND_VMOVE_CONT* data);
static void scchg_WndWndVMoveSum(WIPE_TYPE_WND_VMOVE_CONT* work);
static void scchg_WndWndVMoveSub_Core( const WIPE_TYPE_WND_VMOVE_DATA* p_one, WIPE_TYPE_WND_VMOVE_HDATA* p_buff, int count, int count_max );


// p\RCv
static void scchg_WndWndPesocomPackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_PESOCOM_PARAM* param);
static BOOL scchg_WndWndPesocomPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndWndPesocomInit(WIPE_TYPE_WND_PESOCOM* data, WIPE_TYPE_WND_PESOCOM_PARAM* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndWndPesocomMain(WIPE_TYPE_WND_PESOCOM* data, WIPE_SYS_WIPE_WORK* wipe );
static void scchg_WndWndPesocomOutInit(WIPE_TYPE_WND_PESOCOM* data, WIPE_TYPE_WND_PESOCOM_PARAM* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndWndPesocomOutMain(WIPE_TYPE_WND_PESOCOM* data, WIPE_SYS_WIPE_WORK* wipe );



//----------------------------------------------------------------------------
/**
 *
 *@brief	tF[hAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	BOOL	TRUEFI@FALSEFs
 *
 * tF[hAEg
 *	ʂXɈÂȂĂ
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc00(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_BRI;
		
		scchg_FadeInit(wipe, WIPE_FADE_OUT);
		return FALSE;
	}
	return scchg_FadePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tF[hC
 *
 *@param	wipe	Cvf[^
 *
 *@return	BOOL	TRUEFI@FALSEFs
 *
 *  tF[hC
 *		ʂXɖ邭ȂAʂ\
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc01(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_BRI;
		
		scchg_FadeInit(wipe, WIPE_FADE_IN);
		return FALSE;
	}
	return scchg_FadePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[AEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 *
 * ォ牺ւ̃Vb^[AEg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc02(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data = {
			0, 192, WIPE_WND_VMOVE_OUTWND
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			1,
			WIPE_FADE_OUT
		};
		param.cp_data = &move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[C
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * ォ牺ւ̃Vb^[C
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc03(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data = {
			0, 192, WIPE_WND_VMOVE_INWND
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			1,
			WIPE_FADE_IN
		};
		param.cp_data = &move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[AEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 *
 * ւ̃Vb^[AEg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc04(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data = {
			192, 0, WIPE_WND_VMOVE_OUTWND
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			1,
			WIPE_FADE_OUT
		};
		param.cp_data = &move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[C
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * ւ̃Vb^[C
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc05(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data = {
			192, 0, WIPE_WND_VMOVE_INWND
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			1,
			WIPE_FADE_IN
		};
		param.cp_data = &move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XChAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc06(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,192},
			{0,0,0,192},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XChC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc07(WIPE_SYS_WIPE_WORK* wipe)
{

	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,0,192},
			{0,0,255,192},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN	
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʏ㉺
 * 
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc08(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data[2] = {
			{ 0, 96, WIPE_WND_VMOVE_OUTWND },
			{ 192, 96, WIPE_WND_VMOVE_OUTWND },
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			2,
			WIPE_FADE_OUT
		};
		param.cp_data = move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʒ
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc09(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data[2] = {
			{ 96, 0, WIPE_WND_VMOVE_INWND },
			{ 96, 192, WIPE_WND_VMOVE_INWND },
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			2,
			WIPE_FADE_IN
		};
		param.cp_data = move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʒ
 * 
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc10(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data[2] = {
			{ 96, 0, WIPE_WND_VMOVE_OUTWND },
			{ 96, 192, WIPE_WND_VMOVE_OUTWND },
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			2,
			WIPE_FADE_OUT
		};
		param.cp_data = move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʏ㉺
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc11(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data[2] = {
			{ 0, 96, WIPE_WND_VMOVE_INWND },
			{ 192, 96, WIPE_WND_VMOVE_INWND },
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			2,
			WIPE_FADE_IN
		};
		param.cp_data = move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʍE
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc12(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,192},
			{128,0,128,192},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʒ
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc13(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{128,0,128,192},
			{0,0,255,192},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʒ
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc14(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_MOVE_FP param1 = {
			{128,0,128,192},
			{0,0,128,192},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_OUT
		};
		static const WIPE_TYPE_WND_MOVE_FP param2 = {
			{128,0,128,192},
			{128,0,255,192},
			WNDP_WND_1,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_OUT
		};
	
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMoveDoublePackInit(wipe, &param1, &param2);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndMoveDoublePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʍE
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc15(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_MOVE_FP param1 = {
			{0,0,128,192},
			{128,0,128,192},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_IN
		};
		static const WIPE_TYPE_WND_MOVE_FP param2 = {
			{128,0,255,192},
			{128,0,128,192},
			WNDP_WND_1,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_IN
		};
	
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMoveDoublePackInit(wipe, &param1, &param2);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndMoveDoublePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	z[EAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hAEg
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc16(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			256,0,
			128,96,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCirclePackInit( wipe, &param );

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	z[EC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hC
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc17(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			0,256,
			128,96,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCirclePackInit( wipe, &param );

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hAEg
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc18(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			512,0,
			128,288,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCirclePackInit( wipe, &param );

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hC
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc19(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			0,512,
			128,288,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCirclePackInit( wipe, &param );
		
		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	J[eEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc20(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CURTAIN_FP param = {
			ROTA_NUM(90),
			0,
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCurtainPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndCurtainPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	J[eEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc21(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CURTAIN_FP param = {
			0,
			ROTA_NUM(90),// tan90͒lsɂȂ̂ŁA90ɂĂ܂B
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCurtainPackInit(wipe, &param );

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndCurtainPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 * O璆
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc22(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,192},
			{128,96,128,96},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 * O
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc23(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{128,96,128,96},
			{0,0,255,192},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *	O
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc24(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{128,96,128,96},
			{0,0,255,192},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);
		
		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 * O璆
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc25(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,192},
			{128,96,128,96},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_IN
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc26(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_DOOR_FP param = {
			ROTA_NUM(90),
			ROTA_NUM(0),
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndDoorPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
		
	return scchg_WndDoorPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc27(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_DOOR_FP param = {
			ROTA_NUM(0),
			ROTA_NUM(90),
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndDoorPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndDoorPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I^l[gAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc28(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_WND_POSITION st[] = {
			{0,0,255,48},
			{0,47,255,96},
			{0,96,255,144},
			{0,144,255,192}
		};
		static const WIPE_WND_POSITION ed[] = {
			{0,0,0,48},
			{255,47,255,96},
			{0,96,0,144},
			{255,144,255,192}
		};
		WIPE_TYPE_WND_DIVI_FP param;
		
		param.p_st			= st;
		param.p_ed			= ed;
		param.divi_num		= 4;
		param.wnd_no		= WNDP_WND_0;
		param.in_wnd		= GX_BLEND_ALL;
		param.out_wnd		= GX_BLEND_PLANEMASK_BD;
		param.fade_flg		= WIPE_FADE_OUT;

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndDivisionPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	
	return scchg_WndDivisionPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I^l[gEC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc29(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_WND_POSITION st[] = {
			{255,0,255,48},
			{0,47,0,96},
			{255,96,255,144},
			{0,144,0,192}
		};
		static const WIPE_WND_POSITION ed[] = {
			{0,0,255,48},
			{0,47,255,96},
			{0,96,255,144},
			{0,144,255,192}
		};
		WIPE_TYPE_WND_DIVI_FP param;
		
		param.p_st			= st;
		param.p_ed			= ed;
		param.divi_num		= 4;
		param.wnd_no		= WNDP_WND_0;
		param.in_wnd		= GX_BLEND_ALL;
		param.out_wnd		= GX_BLEND_PLANEMASK_BD;
		param.fade_flg		= WIPE_FADE_IN;

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndDivisionPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	
	return scchg_WndDivisionPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	uChAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc30(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data[3] = {
			{ 0, 64, WIPE_WND_VMOVE_OUTWND },
			{ 64, 128, WIPE_WND_VMOVE_OUTWND },
			{ 128, 192, WIPE_WND_VMOVE_OUTWND },
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			3,
			WIPE_FADE_OUT
		};
		param.cp_data = move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	uChEC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc31(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_VMOVE_DATA move_data[3] = {
			{ 64, 0, WIPE_WND_VMOVE_INWND },
			{ 128, 64, WIPE_WND_VMOVE_INWND },
			{ 192, 128, WIPE_WND_VMOVE_INWND },
		};
		static WIPE_TYPE_WND_VMOVE_PARAM param = {
			NULL,
			3,
			WIPE_FADE_IN
		};
		param.cp_data = move_data;
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndVMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;

		return FALSE;
	}
	return scchg_WndWndVMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XN[EAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc32(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		WIPE_TYPE_WND_SCREW_FP param = {
			FX_GET_ROTA_NUM(0), FX_GET_ROTA_NUM(179),	
			GX_BLEND_PLANEMASK_BD,
			GX_BLEND_ALL,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndScrewPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndScrewPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XN[EC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc33(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		WIPE_TYPE_WND_SCREW_FP param = {
			FX_GET_ROTA_NUM(0), FX_GET_ROTA_NUM(179),	
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndScrewPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndScrewPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tbVEAEg@S
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc34(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		WIPE_TYPE_WND_FLASH_FOUR_FP param = {
			FX_GET_ROTA_NUM(0), FX_GET_ROTA_NUM(45), 
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndFlashFourPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndFlashFourPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tbVEC	S
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc35(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		WIPE_TYPE_WND_FLASH_FOUR_FP param = {
			FX_GET_ROTA_NUM(0), FX_GET_ROTA_NUM(45),	// 45ɂȂƌԂĂ܂B
			GX_BLEND_PLANEMASK_BD,
			GX_BLEND_ALL,
			WIPE_FADE_IN
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndFlashFourPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndFlashFourPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glEAEg	ォ
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hAEg
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc36(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			512,0,
			128,-80,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCirclePackInit( wipe, &param );

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glEC		ォ
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hC
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc37(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			0,512,
			128,-80,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		WIPE_SetBackDropColor( wipe->color );
		scchg_WndCirclePackInit( wipe, &param );

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XChAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc38(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,0,192},
			{0,0,255,192},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_OUT
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XChC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc39(WIPE_SYS_WIPE_WORK* wipe)
{

	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,192},
			{0,0,0,192},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_IN	
		};

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndMovePackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	p\R@AEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc40(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_VMOVE_DATA split_data[2] = {
			{0, 94, WIPE_WND_VMOVE_OUTWND},
			{192, 98, WIPE_WND_VMOVE_OUTWND},
		};
		static WIPE_TYPE_WND_PESOCOM_PARAM param ={
			{
				{0,94,255,98},
				{128,96,128,96},
				WNDP_WND_0,
				GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
				WIPE_FADE_OUT
			},
			{
				NULL,
				2,
				WIPE_FADE_OUT
			},
			FX32_CONST( 0.70f )
		};
		param.wnd_split.cp_data = split_data;

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndPesocomPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_OUT;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndWndPesocomPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	p\R@C
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc41(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_VMOVE_DATA split_data[2] = {
			{94, 0, WIPE_WND_VMOVE_INWND},
			{98, 192, WIPE_WND_VMOVE_INWND},
		};
		static WIPE_TYPE_WND_PESOCOM_PARAM param ={
			{
				{128,96,128,96},
				{0,94,255,98},
				WNDP_WND_0,
				GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
				WIPE_FADE_IN
			},
			{
				NULL,
				2,
				WIPE_FADE_IN
			},
			FX32_CONST( 0.70f )
		};
		param.wnd_split.cp_data = split_data;

		WIPE_SetBackDropColor( wipe->color );
		scchg_WndWndPesocomPackInit(wipe, &param);

		wipe->fade_inout	= WIPE_FADE_IN;
		wipe->wnd_br		= WIPE_USE_WND;
		return FALSE;
	}

	return scchg_WndWndPesocomPack(wipe);
}



//-----------------------------------------------------------------------------
//
//	eCvŎgp֐S
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	^WFgvZ
 *
 *@param	rota		]p
 *
 *@return	fx32		tan(rota)̒l
 *
 *	^WFg͊pxXÔƂ́AslɂȂ̂ŒӂĂ
 *
 *
 */
//-----------------------------------------------------------------------------
static fx32 sum_tan(int rota)
{
	return FX_Div(FX_SinIdx(rota), FX_CosIdx(rota));
}
//----------------------------------------------------------------------------
/**
 *	@brief	]pƍ畝߂
 *
 *	@param	rota		]px
 *	@param	height		
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
static int sub_rota_height_width_one( int rota, int height )
{
	fx32	tan;			// ^WFgvZp
	fx32	width;			// vZp

	// ^WFgvZ
	tan = sum_tan(rota);
	
	// ^WFggpÅpxŁA̎̕߂
	width = FX_Mul(tan, height << FX32_SHIFT);
	width >>= FX32_SHIFT;
	
	return width;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	]pobt@ɂ̊pxŁÂƂ̕߂
 *
 *@param	rota		]p
 *@param	depth		i[[N
 *@param	work_num	[N̔zvf
 *@param	s_h			Jnn_ivf[vł܂킷j
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void sum_rota_height_width(int rota, int* depth, int work_num, int s_h)
{
	int i;
	fx32	tan;			// ^WFgvZp
	fx32	width, height;	// vZp
	int st,ed;

	// ^WFgvZ
	tan = sum_tan(rota);
	
	// eYWł̕
	for(i=s_h;i<work_num;i++){
		// ^WFggpÅpxŁA̎̕߂
		height = i<<FX32_SHIFT;
		width = FX_Mul(tan, height);
		width >>= FX32_SHIFT;
		*(depth+i) = width;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Op`̊pxƒӂ獂߂
 *
 *@param	rota			px
 *@param	underground		ӂ̒
 *
 *@return	int		
 *
 *
 */
//-----------------------------------------------------------------------------
static int sum_triangle_height(int rota, int underground)
{
	fx32 tan;
	fx32 ug;
	int h;

	tan = sum_tan(rota);
	ug = (underground/2) << FX32_SHIFT;
	h = FX_Div(ug ,tan);
	return h;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Pɑl߂
 *
 *@param	st		Jn_
 *@param	ed		I_
 *@param	divi	
 *
 *@return	int		"SUM_NUM_MINI{ɂꂽ1ɑl"
 *
 *
 */
//-----------------------------------------------------------------------------
static int sum_add_num(int st, int ed, int divi)
{
	int add;

	add = ed - st;
	add *= SUM_NUM_MINI;
	add /= divi;
	return add;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEW𕝂O`QTT𒴂Ȃ悤ɑ
 *
 *@param	num1		lP
 *@param	num2		lQ
 *
 *@return	int		l
 *
 *
 */
//-----------------------------------------------------------------------------
static int sum_add_wnd_width(int num1, int num2)
{
	int num;

	num = num1+num2;
	if(num < 0){
		num = 0;
	}
	if(num > 255){
		num = 255;
	}

	return num;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	|WVf[^𑫂
 *
 *@param	num		ޒlւ̃|C^	
 *@param	add		lւ̃|C^
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void sum_add_wnd(WIPE_WND_POSITION* num, WIPE_WND_POSITION* add)
{
	num->x1 += add->x1;
	num->y1 += add->y1;
	num->x2 += add->x2;
	num->y2 += add->y2;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	f[^ݒ肷
 *
 *@param	st			Jn
 *@param	ed			I
 *@param	add			l
 *@param	set_st		JnWݒf[^
 *@param	set_ed		IWݒf[^
 *@param	division	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void sum_set_wnd_position(WIPE_WND_POSITION* st, WIPE_WND_POSITION* ed, WIPE_WND_POSITION* add, const WIPE_WND_POSITION* set_st, const WIPE_WND_POSITION* set_ed, int division )
{
	// Wݒ
	st->x1 = set_st->x1*SUM_NUM_MINI;
	st->y1 = set_st->y1*SUM_NUM_MINI;
	st->x2 = set_st->x2*SUM_NUM_MINI;
	st->y2 = set_st->y2*SUM_NUM_MINI;

	*ed = *set_ed;

	// ړlvZ
	add->x1 = sum_add_num(set_st->x1, set_ed->x1, division);
	add->y1 = sum_add_num(set_st->y1, set_ed->y1, division);
	add->x2 = sum_add_num(set_st->x2, set_ed->x2, division);
	add->y2 = sum_add_num(set_st->y2, set_ed->y2, division);
}


//----------------------------------------------------------------------------
/**
 *@brief	tF[hpbN֐	
 *
 *@param	wipe		Cv[N
 *@param	fade_flag	tF[hEC
						tF[hEAEg	tO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_FadeInit(WIPE_SYS_WIPE_WORK* wipe, int fade_flag)
{
	int start, end;					// JnAIuCglXl
	WIPE_BRIGHTNESS_FADE* data;

	wipe->wipe_work = sys_AllocMemory( wipe->heap, sizeof( WIPE_BRIGHTNESS_FADE ) );
	memset( wipe->wipe_work, 0, sizeof( WIPE_BRIGHTNESS_FADE ) );
	data = wipe->wipe_work;

	// uCglXݒ
	// JnuCglXl
	if( fade_flag == WIPE_FADE_IN ){
		if(wipe->color == WIPE_FADE_WHITE){
			start	= BRIGHTNESS_WHITE;
			end		= BRIGHTNESS_NORMAL;
		}else if(wipe->color == WIPE_FADE_BLACK){
			start	= BRIGHTNESS_BLACK;
			end		= BRIGHTNESS_NORMAL;
		}else{

			// ꉞ悤ɂĂ
			start	= BRIGHTNESS_BLACK;
			end		= BRIGHTNESS_NORMAL;
			// ȊO̐ݒ
			GF_ASSERT_MSG( 0, "color %x", wipe->color );
		}
	}else{
		if(wipe->color == WIPE_FADE_WHITE){
			start	= BRIGHTNESS_NORMAL;
			end		= BRIGHTNESS_WHITE;
		}else if(wipe->color == WIPE_FADE_BLACK){
			start	= BRIGHTNESS_NORMAL;
			end		= BRIGHTNESS_BLACK;
		}else{

			// ꉞ悤ɂĂ
			start	= BRIGHTNESS_NORMAL;
			end		= BRIGHTNESS_BLACK;
			// ȊO̐ݒ
			GF_ASSERT_MSG( 0, "color %x", wipe->color );
		}
	}
	WIPE_SetMstBrightness( wipe->disp, start );
	

	// uCglXωlp[^ݒ
	data->a_count		= wipe->division;
	data->piece_sync	= wipe->piece_sync;
	data->sync_c		= 0;
	data->set_num		= start * SUM_NUM_MINI;
	data->end_num		= end * SUM_NUM_MINI;
	data->add_num		= sum_add_num( start, end, wipe->division );
	data->disp			= wipe->disp;

	wipe->sequence++;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	tF[hpbN֐
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL	IFTRUE	sFFALSE
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_FadePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_BRIGHTNESS_FADE* data = wipe->wipe_work;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l

	
	switch(wipe->sequence){
	case WIPE_MAIN:
		ret = scchg_FadeCalcMain(data);
		if(ret == TRUE){
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;

	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	uCglXtF[hvZC
 *
 *	@param	data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL scchg_FadeCalcMain( WIPE_BRIGHTNESS_FADE* data )
{
	BOOL ret = FALSE;
	
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
	
			data->set_num += data->add_num;
		}else{
			data->set_num = data->end_num;
			ret = TRUE;
		}
		WIPE_SetMstBrightness( data->disp, data->set_num / SUM_NUM_MINI );
	}

	return ret;
}

// HuNp
static inline void wndp_setWndPosition_HBlank(int x1, int y1, int x2, int y2, int wnd_no, int disp)
{
	if(wnd_no == WNDP_WND_0){
		if(disp == WNDP_DISP_MAIN){
			if( GX_IsHBlank() ){
				G2_SetWnd0Position(x1,y1,x2,y2);
			}
		}else{
			if( GX_IsHBlank() ){
				G2S_SetWnd0Position(x1,y1,x2,y2);
			}
		}
	}else{
		if(disp == WNDP_DISP_MAIN){
			if( GX_IsHBlank() ){
				G2_SetWnd1Position(x1,y1,x2,y2);
			}
		}else{
			if( GX_IsHBlank() ){
				G2S_SetWnd1Position(x1,y1,x2,y2);
			}
		}
	}
}

static inline void set_H_WndData( WIPE_TYPE_HB_WND* shb, int v_c, int i )
{
	WIPE_TYPE_HB_WND_ONE* one;

	one = scchg_h_WndIdxDataGet(shb, i);	// CfbNX̃f[^擾
	wndp_setWndPosition_HBlank(one->wnd_data[0][v_c], 0, one->wnd_data[1][v_c], 192, one->wnd_no, shb->disp);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhE`Hblank֐
 *
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_h_Wnd(void* work)
{
	WIPE_TYPE_HB_WND* shb = (WIPE_TYPE_HB_WND*)work;
	int v_c;
	int i;

	GF_ASSERT(work);

	v_c = GX_GetVCount();

	if(v_c < 192){
		v_c ++;
		if( v_c > 191 ){
			v_c -= 192;
		}

		if( shb->wnd_data_num == 1 ){
			set_H_WndData( shb, v_c, 0 );
		}else{
			set_H_WndData( shb, v_c, 0 );
			set_H_WndData( shb, v_c, 1 );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNEBhEf[^쐬
 *
 *@param	data	f[^i[
 *@param	flag	EBhEf[^tO
 *@param	disp	\
 *@param	heap	gpq[v
 *
 *@return	noen
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_h_WndMake(WIPE_TYPE_HB_WND* data, int flag, int disp, int heap)
{
	switch(flag){
	case WNDP_WND_0:	// ǂ炩Е̂Ƃ
	case WNDP_WND_1:
		data->data = sys_AllocMemory(heap, sizeof(WIPE_TYPE_HB_WND_ONE));
		data->wnd_data_num	= 1;
		data->disp			= disp;
		data->data->wnd_no	= flag;		// flag = WNDio[
		break;
	case 2:
		{
			int i;
			data->data = sys_AllocMemory(heap, sizeof(WIPE_TYPE_HB_WND_ONE)*2);
			data->wnd_data_num	= 2;
			data->disp			= disp;
			for(i=0;i<2;i++){			// EBhEf[^ݒ
				data->data[i].wnd_no	= i;
			}
		}
		break;
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEf[^j
 *
 *@param	data	jEBhEf[^
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_h_WndDel(WIPE_TYPE_HB_WND* data)
{
//	VWaitTCB_Add( scchg_v_h_WndDel, data, WIPE_VBLANK_WND_DELETE_TCB );
	scchg_main_h_WndDel( data );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ۂVuNɃ[Nj֐
 *
 *	@param	tcb		^XN[N
 *	@param	work	f[^
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_v_h_WndDel( TCB_PTR tcb, void* work )
{
	WIPE_TYPE_HB_WND* data = work;

	scchg_main_h_WndDel( data );

	TCB_Delete(tcb);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ۂɃ[Nj֐
 *
 *	@param	data 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_main_h_WndDel( WIPE_TYPE_HB_WND* data )
{
	sys_FreeMemoryEz(data->data);	
	data->data = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEio[̃EBhEf[^擾
 *
 *@param	wnd_no	擾EBhEio[	
 *
 *@return	EBhEf[^	ƂNULL
 *
 *
 */
//-----------------------------------------------------------------------------
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndNoDataGet(WIPE_TYPE_HB_WND* data, int wnd_no)
{
	int i;

	for(i=0;i<data->wnd_data_num;i++){
		if(data->data[i].wnd_no == wnd_no){
			return (data->data + i);
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CfbNX̃EBhEf[^擾
 *
 *@param	data	擾
 *@param	idx		CfbNX
 *
 *@return	EBhEf[^	ƂNULL
 *
 *
 */
//-----------------------------------------------------------------------------
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndIdxDataGet(WIPE_TYPE_HB_WND* data, int idx)
{
	GF_ASSERT(data->wnd_data_num > idx);

	return (data->data + idx);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C[vŌvZEBhĚ`̃obt@
 *			fe[uɑ
 *
 *@param	tcb		^XN|C^
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndSwap(TCB_PTR tcb, void* work)
{
	WIPE_TYPE_HB_WND*	swc = (WIPE_TYPE_HB_WND*)work;
	WIPE_TYPE_HB_WND_ONE* one;
	int i;

	for(i=0;i<swc->wnd_data_num;i++){
		one = scchg_h_WndIdxDataGet(swc, i);		// CfbNX̃f[^擾
		memcpy(one->wnd_data, one->wnd_tmp, sizeof(short)*2*192);	// sizeof(short)*2*192
	}
	TCB_Delete( tcb );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhĚ㏈
 *
 *@param	flag		WIPE_FADE_IN:tF[hC	WIPE_FADE_OUT:tF[hAEg
 *@param	wnd_sys		EBhEVblank[N
 *@param	disp		\
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndEnd(int flag, WNDP_SYS_PTR wnd_sys, int disp)
{
	if(flag == WIPE_FADE_IN){
		// tF[hECIgpEBhE̕\It
		WNDP_V_SetVisibleWnd(wnd_sys, GX_WNDMASK_NONE, disp);

	}else{

		// EBhE0ʂςɍL
		WNDP_V_SetVisibleWnd(wnd_sys, GX_WNDMASK_W0, disp);
		WNDP_V_SetWndInsidePlane(wnd_sys, GX_BLEND_ALL, FALSE, 0, disp);
		WNDP_V_SetWndPosition(wnd_sys, 0,0,0,0,0, disp);	
		WNDP_V_SetWndOutsidePlane(wnd_sys, GX_BLEND_PLANEMASK_BD, FALSE, disp);	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEgpłԂɂ
 *
 *@param	wnd_sys		EBhEVblankݒVXep[N
 *@param	in_wnd		EBhEݒ
 *@param	out_wnd		EBhEOݒ
 *@param	wnd_no		EBhEio[
 *@param	disp		EBhE\
 *@param	x1			EBhEW
 *@param	y1
 *@param	x2
 *@param	y2
 *@param	fade_flg	tF[htO
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndSetUp(WNDP_SYS_PTR wnd_sys, int in_wnd, int out_wnd, int wnd_no, int disp, int x1, int y1, int x2, int y2, int fade_flg)
{
	// EBhE̓Oݒ
	if( fade_flg == WIPE_FADE_IN ){
		// tF[hC
		WNDP_SetWndInsidePlane(in_wnd, FALSE, wnd_no, disp);
		WNDP_SetWndOutsidePlane(out_wnd, FALSE, disp);
		WNDP_SetWndPosition(x1,y1,x2,y2, wnd_no, disp);
	}else{
		// tF[hAEg
		WNDP_V_SetWndInsidePlane(wnd_sys, in_wnd, FALSE, wnd_no, disp);
		WNDP_V_SetWndOutsidePlane(wnd_sys, out_wnd, FALSE, disp);
		WNDP_V_SetWndPosition(wnd_sys, x1,y1,x2,y2, wnd_no, disp);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		EBhE\\ݒ
 *
 *	@param	wnd_sys		EBhEVXe
 *	@param	plane		\EBhE
 *	@param	disp		\
 *	@param	fade_flg	tF[hCEAEgtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndVisible(WNDP_SYS_PTR wnd_sys, int plane, int disp, int fade_flg)
{
	if(fade_flg == WIPE_FADE_IN){

		WNDP_SetVisibleWnd( plane, disp );
	}else{

		WNDP_V_SetVisibleWnd(wnd_sys, plane, disp);
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	c@HuNgp@EBhE
 *
 *	@param	p_wnddata	[N
 *	@param	disp		
 *	@param	data_num	EBhEgp	(1 or 2)
 *	@param	wnd_no0		[NÕEBhEio[
 *	@param	wnd_no1		[NP̃EBhEio[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_h_VMoveWndInit( WIPE_TYPE_WND_VMOVE* p_wnddata, int disp, int data_num, int wnd_no0, int wnd_no1 )
{
	memset( p_wnddata, 0, sizeof(WIPE_TYPE_WND_VMOVE) );

	if( data_num == 1 ){
		p_wnddata->data[0].wnd_no	= wnd_no0;
		p_wnddata->wnd_data_num		= data_num;
		p_wnddata->disp				= disp;
	}else{
		p_wnddata->data[0].wnd_no = wnd_no0;
		p_wnddata->data[1].wnd_no = wnd_no1;
		p_wnddata->wnd_data_num		= data_num;
		p_wnddata->disp				= disp;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Xbvobt@NGXg
 *
 *	@param	p_wnddata	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_h_VMoveWnd_SwapReq( WIPE_TYPE_WND_VMOVE* p_wnddata )
{
	VWaitTCB_Add(scchg_h_VMoveWnd_Swap, p_wnddata, WIPE_VBLANK_WND_SWAP_TCB );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Jn@VuNJn܂B
 *
 *	@param	p_wnddata [N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_h_VMoveWnd_Start( WIPE_HBLANK* p_wipehb, WIPE_TYPE_WND_VMOVE* p_wnddata, u32 heap )
{
	// Hblank֐ݒ
	WIPE_V_HBlankInit(p_wipehb, p_wnddata, scchg_h_VMoveWnd_Main, p_wnddata->disp, heap);
}

//----------------------------------------------------------------------------
/**
 *	@brief	I
 *
 *	@param	p_wnddata	VuNI܂B
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_h_VMoveWnd_End( WIPE_HBLANK* p_wipehb, WIPE_TYPE_WND_VMOVE* p_wnddata, u32 heap )
{
	WIPE_V_HBlankDelete(p_wipehb, p_wnddata->disp, heap);
}


//----------------------------------------------------------------------------
/**
 *	@brief	Xbvobt@
 *
 *	@param	tcb			^XN|C^
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_h_VMoveWnd_Swap( TCB_PTR tcb, void* p_work )
{
	WIPE_TYPE_WND_VMOVE* p_wnddata = p_work;
	int i;
	
	for( i=0; i<2; i++ ){
		memcpy( p_wnddata->data[i].in_out_read, p_wnddata->data[i].in_out_write, sizeof(u8)*192 );
	}

	TCB_Delete( tcb );
}

static inline void wndp_SetWndOutsidePlane_HBlank( int wnd, BOOL effect, int disp )
{
	if(disp == WNDP_DISP_MAIN){
		if( GX_IsHBlank() ){
			G2_SetWndOutsidePlane(wnd, effect);
		}
	}else{
		if( GX_IsHBlank() ){
			G2S_SetWndOutsidePlane(wnd, effect);
		}
	}
}
static inline void wndp_SetWndInsidePlane_HBlank( int wnd, BOOL effect, int wnd_no, int disp )
{
	if(wnd_no == WNDP_WND_0){
		if(disp == WNDP_DISP_MAIN){
			if( GX_IsHBlank() ){
				G2_SetWnd0InsidePlane(wnd, effect);
			}
		}else{
			if( GX_IsHBlank() ){
				G2S_SetWnd0InsidePlane(wnd, effect);
			}
		}
	}else{
		if(disp == WNDP_DISP_MAIN){
			if( GX_IsHBlank() ){
				G2_SetWnd1InsidePlane(wnd, effect);
			}
		}else{
			if( GX_IsHBlank() ){
				G2S_SetWnd1InsidePlane(wnd, effect);
			}
		}
	}
}

static inline void set_H_VMoveWndData( WIPE_TYPE_WND_VMOVE* shb, int v_c, int i )
{
	WIPE_TYPE_WND_VMOVE_HDATA* one;

	one = &shb->data[ i ];
	if( one->in_out_read[ v_c ] == WIPE_WND_VMOVE_INWND ){
		wndp_SetWndOutsidePlane_HBlank( GX_BLEND_ALL, TRUE,  shb->disp );
		wndp_SetWndInsidePlane_HBlank( GX_BLEND_PLANEMASK_BD, TRUE, one->wnd_no, shb->disp );
	}else{
		wndp_SetWndOutsidePlane_HBlank( GX_BLEND_PLANEMASK_BD, TRUE,  shb->disp );
		wndp_SetWndInsidePlane_HBlank( GX_BLEND_ALL, TRUE, one->wnd_no, shb->disp );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	HuNf[^ݒ
 *
 *	@param	p_work	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_h_VMoveWnd_Main( void* p_work )
{
	WIPE_TYPE_WND_VMOVE* shb = (WIPE_TYPE_WND_VMOVE*)p_work;
	int v_c;
	int i;

	GF_ASSERT(p_work);

	v_c = GX_GetVCount();

	if(v_c < 192){
		
		v_c ++;
		if( v_c > 191 ){
			v_c -= 192;
		}
		
		if( shb->wnd_data_num == 1 ){
			set_H_VMoveWndData( shb, v_c, 0 );
		}else{
			set_H_VMoveWndData( shb, v_c, 0 );
			set_H_VMoveWndData( shb, v_c, 1 );
		}
	}
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhEpbN֐
 *
 *	@param	wipe	Cvf[^
 *	@param	param	EBhEf[^
 *
 * @return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndMovePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram )
{
	WIPE_TYPE_WND_MOVE* wwm;

	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_MOVE));
	
	wwm = (WIPE_TYPE_WND_MOVE*)wipe->wipe_work;
	
	scchg_WndMoveInit(wwm, pram, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys);
	
	// EBhEI
	if(pram->wnd_no == 0){
		scchg_WndVisible(wipe->wnd_sys, GX_WNDMASK_W0, wwm->disp, wwm->fade_flg);
	}else{
		scchg_WndVisible(wipe->wnd_sys,GX_WNDMASK_W1, wwm->disp, wwm->fade_flg);
	}
	
	wipe->sequence++;		// C
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEpbN
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndMovePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_MOVE* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_MOVE*)wipe->wipe_work;
	
	switch(wipe->sequence){
	case WIPE_MAIN:
		ret = scchg_WndMoveMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wipe->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;

	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Q̃EBhE𓯎ɓ֐̏
 *
 *@param	wipe		Cv\
 *@param	pram1		EBhEÖf[^
 *@param	pram2		EBhEP̈f[^
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndMoveDoublePackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram1, const WIPE_TYPE_WND_MOVE_FP* pram2)
{
	WIPE_TYPE_WND_DMOVE* wwm;

	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_DMOVE));
	wwm = (WIPE_TYPE_WND_DMOVE*)wipe->wipe_work;
	scchg_WndMoveInit(&wwm->wnd0, pram1, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys);
	scchg_WndMoveInit(&wwm->wnd1, pram2, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys);

	scchg_WndVisible(wipe->wnd_sys,GX_WNDMASK_W0|GX_WNDMASK_W1, wipe->disp, wwm->wnd0.fade_flg);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Q̃EBhE𓯎ɓ֐̏
 *
 *@param	wipe		Cv\
 *	
 *@retval	TRUE		I
 *@retval	FALSE		s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndMoveDoublePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_DMOVE* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_DMOVE*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndMoveMain(&wwm->wnd0);
		ret += scchg_WndMoveMain(&wwm->wnd1);
		if(ret == 2){
			scchg_WndEnd(wwm->wnd0.fade_flg, wipe->wnd_sys, wipe->disp);
//			scchg_WndEnd(wwm->wnd1.fade_flg, wipe->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEό`̏
 *
 *@param	data		f[^i[
 *@param	param		EBhEό`f[^
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	disp		\
 *@param	wnd_sys		EBhEVXe|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndMoveInit(WIPE_TYPE_WND_MOVE* data, const WIPE_TYPE_WND_MOVE_FP* pram, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys)
{
	// Wݒ
	sum_set_wnd_position(&data->st, &data->ed, &data->add, &pram->st, &pram->ed, division);

	// f[^ݒ
	data->disp			= disp;
	data->wnd_no		= pram->wnd_no;
	data->a_count		= division;
	data->piece_sync	= piece_sync;
	data->sync_c		= 0;
	data->wnd_sys		= wnd_sys;
	data->fade_flg		= pram->fade_flg;

	// EBhE̓Oݒ
	scchg_WndSetUp(wnd_sys, pram->in_wnd, pram->out_wnd, pram->wnd_no, disp,
			pram->st.x1,pram->st.y1,
			pram->st.x2,pram->st.y2,
			data->fade_flg);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhĚ`ό`
 *
 *@param	data	EBhEό`f[^
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndMoveMain(WIPE_TYPE_WND_MOVE* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
	
			// Z
			sum_add_wnd(&data->st, &data->add);
		}else{
			WNDP_V_SetWndPosition(data->wnd_sys, data->ed.x1,data->ed.y1,data->ed.x2,data->ed.y2, data->wnd_no, data->disp);

			return TRUE;
		}

		WNDP_V_SetWndPosition(data->wnd_sys, data->st.x1/SUM_NUM_MINI,data->st.y1/SUM_NUM_MINI,data->st.x2/SUM_NUM_MINI,data->st.y2/SUM_NUM_MINI, data->wnd_no, data->disp);//*/
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhEŉ~`VXe
 *
 *	@param	wipe	Cv[N
 *	@param	param	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCirclePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CIRCLE_FP* param )
{
	WIPE_TYPE_WND_CIRCLE* wwm;
	
	// CvJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_CIRCLE));
	wwm = (WIPE_TYPE_WND_CIRCLE*)wipe->wipe_work;
	scchg_WndCircleInit(wwm, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap);

	// C
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEŉ~`VXe
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL		TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCirclePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_CIRCLE* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_CIRCLE*)wipe->wipe_work;
	
	switch(wipe->sequence){
	case WIPE_MAIN:
		ret = scchg_WndCircleMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_h_WndDel(&wwm->hb_circle);	// EBhEݒf[^j
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
		
	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	~`VXe
 *
 *@param	data			f[^i[
 *@param	param			Cvf[^
 *@param	division		
 *@param	piece_sync		PЂ̃VN
 *@param	disp			\
 *@param	wnd_sys			EBhEVXe|C^
 *@param	heap			gpq[vID
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCircleInit(WIPE_TYPE_WND_CIRCLE* data, const WIPE_TYPE_WND_CIRCLE_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap)
{
	int add_r;
	WIPE_TYPE_HB_WND_ONE* one;

	// ωl߂
	add_r = sum_add_num(param->r, param->e_r, division);

	// f[^ݒ
	scchg_h_WndMake(&data->hb_circle, param->wnd_no, disp, heap);
	data->r					= param->r*SUM_NUM_MINI;
	data->x					= param->x;
	data->y					= param->y;
	data->add_r				= add_r;
	data->a_count			= division;
	data->piece_sync		= piece_sync;
	data->sync_c			= 0;
	data->wnd_sys			= wnd_sys;
	data->p_wipehb			= p_wipehb;
	data->heap				= heap;
	data->fade_flg			= param->fade_flg;
	
	scchg_WndCircleSum(data);	// 1vZ
	VWaitTCB_Add(scchg_WndSwap,&data->hb_circle, WIPE_VBLANK_WND_SWAP_TCB );

	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_circle, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, param->wnd_no, disp,
			one->wnd_tmp[0][0], 0, one->wnd_tmp[1][0], 192,
			data->fade_flg);

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible( wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg );
	}else{
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W1, disp, data->fade_flg);
	}
	
	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_circle, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	~`惁C
 *
 *@param	data	EBhEό`f[^
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCircleMain(WIPE_TYPE_WND_CIRCLE* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
			data->r += data->add_r;	
			scchg_WndCircleSum(data);
			VWaitTCB_Add(scchg_WndSwap,&data->hb_circle, WIPE_VBLANK_WND_SWAP_TCB );
		}else{

			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_circle.disp, data->heap);
			return TRUE;
		}
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	~f[^vZTu֐
 *
 *@param	c_r		aiSUM_NUM_MINIłlj
 *@param	c_x		SW
 *@param	c_y		SW
 *@param	n_h		̍
 *@param	st		EBhE̊Jn_
 *@param	ed		EBhȄI_
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCircleSumSub(int c_r, int c_x, int c_y, int n_h, int* st, int* ed)
{
	fx32 r;			// a
	fx32 height;	// 
	fx32 width;		// 

	// R̒藝ō̍~̕߂
	
	r = c_r / SUM_NUM_MINI;

	height = n_h - c_y;
	if(height < 0){
		height = -height;
	}
	
	if(height >= r){
		*st = 0;
		*ed = 0;
	}else{
		// a畝߂
		height <<= FX32_SHIFT;
		r <<= FX32_SHIFT;
		width = FX_Sqrt(FX_Mul(r,r) - FX_Mul(height,height));
		width >>= FX32_SHIFT;

		// EBhE̊Jn_ݒ
		*st = c_x - width;
		if(*st < 0){
			*st = 0;
		}
		*ed = *st + (width*2);
		if(*ed > 255){
			*ed = 255;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	~f[^̌vZs
 *
 *@param	work		~`VXẽf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCircleSum(WIPE_TYPE_WND_CIRCLE* work)
{
	WIPE_TYPE_HB_WND* shb = &work->hb_circle;
	int i;			// [vp
	int st;			// EBhEJn_
	int ed;			// EBhEI_
	int roop_end;
	WIPE_TYPE_HB_WND_ONE* one;

	// CfbNXÕEBhEf[^擾
	one = scchg_h_WndIdxDataGet(shb, 0);

	// aʓɂƂ
	// S܂ŕ߂牺̓Rs[悤ɂ
	for(i=0;i < 192;i++){
		if(i <= work->y){		// a܂ł͕ʂ̋߂
			scchg_WndCircleSumSub(work->r, work->x, work->y, i, &st, &ed);
		}else{
			if(i <= (work->y*2)){		// a甼âQ{܂ł,Rs[
				st = one->wnd_tmp[0][(work->y*2)-i];
				ed = one->wnd_tmp[1][(work->y*2)-i];
			}else{				// ͕̑ʂɋ߂
				scchg_WndCircleSumSub(work->r, work->x, work->y, i, &st, &ed);
			}
		}
		
		one->wnd_tmp[0][i] = st;
		one->wnd_tmp[1][i] = ed;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[ê悤ɕ\鏉֐
 *
 *@param	wipe		Cv[N
 *@param	param		֐
 *
 *	rota		Jnpx		px͂O`WXł肢܂
 *	e_rota		Ipx		܂WAlłKv܂B
 *	wnd_no		EBhEio[
 *	in_wnd		EBhE̖
 *	out_wnd		EBhEO̖
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCurtainPackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CURTAIN_FP* param)
{
	WIPE_TYPE_WND_CURTAIN* wwm;

	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_CURTAIN));
	wwm = (WIPE_TYPE_WND_CURTAIN*)wipe->wipe_work;
	scchg_WndCurtainInit(wwm, param,wipe->division, wipe->piece_sync,  wipe->disp,  wipe->wnd_sys, wipe->p_wipehb, wipe->heap);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[ê悤ɕ\
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL	TRUEFI	FALSEFs
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCurtainPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_CURTAIN* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_CURTAIN*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndCurtainMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_h_WndDel(&wwm->hb_c);
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEł̃J[e`Jn
 *
 *@param	data		J[e`f[^
 *@param	param		J[ef[^
 *@param	division	̕
 *@param	piece_sync	PЂ̃VN
 *@param	disp		EBhE\
 *@param	wnd_sys		EBhEVblankVXẽ[N
 *@param	p_wipehb	CvHuN[N
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCurtainInit(WIPE_TYPE_WND_CURTAIN* data, const WIPE_TYPE_WND_CURTAIN_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	WIPE_TYPE_HB_WND_ONE* one;
	
	data->rota_add = sum_add_num(param->rota, param->e_rota, division);

	// f[^ݒ
	scchg_h_WndMake(&data->hb_c, param->wnd_no, disp, heap);
	data->rota		= param->rota*SUM_NUM_MINI;
	data->a_count	= division;
	data->piece_sync = piece_sync;
	data->sync_c	= 0;
	data->wnd_sys	= wnd_sys;	
	data->p_wipehb	= p_wipehb;
	data->heap		= heap;
	data->fade_flg	= param->fade_flg;
	
	scchg_WndCurtainSum(data);	// 1vZ
	VWaitTCB_Add(scchg_WndSwap,&data->hb_c, WIPE_VBLANK_WND_SWAP_TCB );

	// EBhE\ݒ
	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_c, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd,
			param->wnd_no, disp, one->wnd_tmp[0][0], 0, one->wnd_tmp[1][0], 192,
			data->fade_flg);

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg);
	}else{
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W1, disp, data->fade_flg);
	}
	

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_c, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[e\̃C
 *
 *@param	data	EBhEf[^
 *	
 *@return	BOOL	TRUEFI	FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCurtainMain(WIPE_TYPE_WND_CURTAIN* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
			data->rota += data->rota_add;
			scchg_WndCurtainSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap,&data->hb_c, WIPE_VBLANK_WND_SWAP_TCB );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_c.disp, data->heap);
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[ê悤ɕ\f[^vZ
 *
 *@param	work		EBhEf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCurtainSum(WIPE_TYPE_WND_CURTAIN* work)
{
	int i;
	int st, ed;
	int width[192];
	WIPE_TYPE_HB_WND_ONE* one;

	// CfbNXÕEBhEf[^擾
	one = scchg_h_WndIdxDataGet(&work->hb_c, 0);

	// pxeł̕߂
	sum_rota_height_width(work->rota/SUM_NUM_MINI, width, 192, 0);

	// eYWł̕
	for(i=0;i<192;i++){
		one->wnd_tmp[0][i] = sum_add_wnd_width(128, -width[i]);
		one->wnd_tmp[1][i] = sum_add_wnd_width(128, width[i]);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAtF[hpbN֐	֐
 *
 *@param	wipe		Cv[N
 *@param	param		hAf[^
 *	s_d			JnJpx	iROTA_NUM(0)`ROTA_NUM(90)j
 *	e_d			IJpx	iROTA_NUM(0)`ROTA_NUM(90)j
 *	wnd_no		gpEBhEio[
 *	in_wnd		EBhEʐݒ
 *	out_wnd		EBhEOʐݒ
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDoorPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DOOR_FP* param)
{
	WIPE_TYPE_WND_DOOR* wwm;
	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_DOOR));
	wwm = (WIPE_TYPE_WND_DOOR*)wipe->wipe_work;
	scchg_WndDoorInit(wwm, param, wipe->division, wipe->piece_sync,  wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAtF[hpbN֐
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDoorPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_DOOR* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_DOOR*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndDoorMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_h_WndDel(&wwm->hb_d);
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEŃhAtF[h
 *
 *@param	data		f[^i[
 *@param	param		hAf[^
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	disp		EBhE\
 *@param	wnd_no		gpEBhEio[
 *@param	wnd_sys		EBhEVblankݒ胏[N
 *@param	wipe_hb		CvHuN[N
 *@param	heap		gpq[v
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDoorInit(WIPE_TYPE_WND_DOOR* data, const WIPE_TYPE_WND_DOOR_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	int add_num;
	WIPE_TYPE_HB_WND_ONE* one;

	// PŊJhA̋vZ
	add_num	= (param->e_d - param->s_d);
	add_num	/= division;

	// f[^ݒ
	scchg_h_WndMake(&data->hb_d, param->wnd_no, disp, heap);
	data->open_max		= 128*FX32_ONE;	// ̔̒lōl
	data->open_r		= param->s_d;
	data->open_r_a		= add_num;
	data->a_count	= division;
	data->piece_sync= piece_sync;
	data->sync_c	= 0;
	data->wnd_sys	= wnd_sys;
	data->p_wipehb	= p_wipehb;
	data->heap		= heap;
	data->fade_flg	= param->fade_flg;

	// hAvZ
	scchg_WndDoorSum(data);
	VWaitTCB_Add(scchg_WndSwap,&data->hb_d, WIPE_VBLANK_WND_SWAP_TCB );
	
	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_d, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, 
			param->wnd_no, disp,
			one->wnd_tmp[0][96], 0, one->wnd_tmp[1][96], 192,
			data->fade_flg);	// XUɂׂ

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg);
	}else{
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W1, disp, data->fade_flg);
	}

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_d, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAtF[hC
 *
 *@param	data		hAf[^
 *
 *@return	BOOL		TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDoorMain(WIPE_TYPE_WND_DOOR* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
			data->open_r += data->open_r_a;
			scchg_WndDoorSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap, &data->hb_d, WIPE_VBLANK_WND_SWAP_TCB );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_d.disp, data->heap);
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hA^̃EBhEvZ
 *
 *@param	work		hAf[^
 *
 *@return	noen
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDoorSum(WIPE_TYPE_WND_DOOR* work)
{
	int i;
	int tri_h;		// s\̂QӎOp`̍
	int rota;		// s\̂QӎOp`̒_̊px
	int tri_data[192];	// s\̂QӎOp`̌`f[^
	int tri_n;		// tri_datae[u̗vf
	int h_open;		// ̊JĂl̔
	int set_w;		// EBhEɐݒ肷镝
	int st, ed;		// Jn_AI_
	WIPE_TYPE_HB_WND_ONE* one;	// EBhEݒf[^

	// CfbNXÕEBhE擾
	one = scchg_h_WndIdxDataGet(&work->hb_d, 0);

	// ̊Jl߂
	h_open = FX_Mul(FX_SinIdx(work->open_r), work->open_max);
	h_open >>= FX32_SHIFT;
	
	rota = h_open*2;						// ̊Jl߂
	rota = rota / WIPE_DOOR_ROTA_NUM;		// QӎOp`̍ēx̊px߂
	rota += 1;								// 90x
	rota = 180 - (rota*2);					// Op`̒_̊px߂
	rota = ROTA_NUM(rota);					// FX̌vZŎgppx̒Pʂɂ
	rota /= 2;								// ߂邽ߔ̊pxɂ
	tri_h = sum_triangle_height(rota, 256);	// Op`̍擾
	tri_h >>= FX32_SHIFT;					// fx32int
	GF_ASSERT(tri_h < 192);

	sum_rota_height_width(rota, tri_data, tri_h, 0);	// Op`̌`f[^߂
	
	// hA^̃EBhEf[^쐬
	for(i=0;i<96;i++){

		// EBhEɐݒ肷镝߂
		tri_n = tri_h - (i+1);
		set_w = h_open;
		if(tri_n > 0){
			if(tri_data[tri_n] > set_w){
				set_w = tri_data[tri_n];
			}
		}

		// Jn_I_߂
		st = sum_add_wnd_width(128, -set_w);
		ed = sum_add_wnd_width(128, set_w);

		// EBhEɐݒ肷
		one->wnd_tmp[0][i] = st;
		one->wnd_tmp[1][i] = ed;
		one->wnd_tmp[0][191 - i] = st;
		one->wnd_tmp[1][191 - i] = ed;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	PEBhEtF[hpbN
 *
 *	@param	wipe		Cv[N
 *	@param	param		tF[hf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DIVI_FP* param)
{
	WIPE_TYPE_WND_DIVI* wwm;
	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_DIVI));
	wwm = (WIPE_TYPE_WND_DIVI*)wipe->wipe_work;
	scchg_WndDivisionInit(wwm, param, wipe->division, wipe->piece_sync,  wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	PEBhEtF[hpbN
 *
 *@param	wipe		Cv[N
 *	
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDivisionPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_DIVI* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_DIVI*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndDivisionMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_WndDivisionEnd(wwm);	// EBhEf[^j
		scchg_h_WndDel(&wwm->hb_divi);
		
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	PEBhEtF[h
 *
 *@param	data		f[^i[
 *@param	param		PEBhEf[^
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	disp		EBhE\
 *@param	wnd_sys		EBhEVblankݒVXe[N
 *@param	p_wipehb	CvpHuN[N
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionInit(WIPE_TYPE_WND_DIVI* data, const WIPE_TYPE_WND_DIVI_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	int i;
	WIPE_TYPE_HB_WND_ONE* one;
	
	// f[^쐬
	// AbN
	data->piece_tbl = sys_AllocMemory(heap, sizeof(WIPE_TYPE_WND_D_PIECE)*param->divi_num);
	GF_ASSERT(data->piece_tbl != NULL);
	data->piece_num = param->divi_num;

	// f[^i[
	for(i=0;i<param->divi_num;i++){

		sum_set_wnd_position(&data->piece_tbl[i].st, &data->piece_tbl[i].ed, &data->piece_tbl[i].add, (param->p_st+i), (param->p_ed+i), division);
	}

	// f[^ݒ
	scchg_h_WndMake(&data->hb_divi, param->wnd_no, disp, heap);
	data->a_count		= division;
	data->piece_sync	= piece_sync;
	data->sync_c		= 0;
	data->wnd_sys		= wnd_sys;
	data->p_wipehb		= p_wipehb;
	data->heap			= heap;
	data->fade_flg		= param->fade_flg;

	// vZ
	scchg_WndDivisionSum(data);
	VWaitTCB_Add(scchg_WndSwap,&data->hb_divi, WIPE_VBLANK_WND_SWAP_TCB );
	
	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_divi, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, param->wnd_no, disp,
			one->wnd_tmp[0][0], 0, one->wnd_tmp[1][0], 192,
			data->fade_flg);	// XUɂׂ

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible(data->wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg);
	}else{
		scchg_WndVisible(data->wnd_sys,GX_WNDMASK_W1, disp, data->fade_flg);
	}

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_divi, scchg_h_Wnd, disp, heap);
}
	

//----------------------------------------------------------------------------
/**
 *
 *@brief	1EBhE𕪊Ăꂼœ
 *
 *@param	data		EBhEf[^
 *
 *@return	BOOL		TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDivisionMain(WIPE_TYPE_WND_DIVI* data)
{
	
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;

			// 
			scchg_WndDivisionMainSub(data);			
			
			scchg_WndDivisionSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap,&data->hb_divi, WIPE_VBLANK_WND_SWAP_TCB );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_divi.disp, data->heap);
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eX̕f[^j
 *
 *@param	data	EBhEf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionEnd(WIPE_TYPE_WND_DIVI* data)
{
	// mۂ
	sys_FreeMemoryEz( data->piece_tbl);
	data->piece_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eX̃f[^EBhE̐ݒf[^ɕϊ
 *
 *@param	work		PEBhEf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionSum(WIPE_TYPE_WND_DIVI* work)
{
	int i;		// [vp
	WIPE_TYPE_HB_WND_ONE* one;
	
	one = scchg_h_WndIdxDataGet(&work->hb_divi, 0);
	memset(one->wnd_tmp, 0, 768);	// NA

	// vfOԗD揇ʂȂ悤ɍŌ̗vff[^ݒ肵Ă
	for(i = (work->piece_num-1); i >= 0; i--){
		scchg_WndDivisionSumSub(&work->hb_divi, &work->piece_tbl[i].st);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEf[^vZTu֐
 *
 *@param	hb_divi		HuNݒf[^
 *@param	set			ݒf[^
 *
 *@return	none
 *
 * ݒ肷
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionSumSub(WIPE_TYPE_HB_WND* hb_divi, WIPE_WND_POSITION* set)
{
	int i;		// [vp
	WIPE_TYPE_HB_WND_ONE* one;
	WIPE_WND_POSITION set_data;
	
	one = scchg_h_WndIdxDataGet(hb_divi, 0);

	set_data.x1 = set->x1 / SUM_NUM_MINI;
	set_data.y1 = set->y1 / SUM_NUM_MINI;
	set_data.x2 = set->x2 / SUM_NUM_MINI;
	set_data.y2 = set->y2 / SUM_NUM_MINI;

	for( i = set_data.y1; i < set_data.y2; i++ ){
		one->wnd_tmp[0][i] = set_data.x1;
		one->wnd_tmp[1][i] = set_data.x2;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C֐̓֐
 *
 *@param	data		f[^
 *
 *@return	none
 *
 * ۂɕꂽꂼ̃EBhE𓮂
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionMainSub(WIPE_TYPE_WND_DIVI* data)
{
	int i;		// [vp

	// ꂼꓮ
	for(i=0;i<data->piece_num;i++){
		sum_add_wnd(&data->piece_tbl[i].st, &data->piece_tbl[i].add);
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[֐
 *
 *	@param	wipe		Cv
 *	@param	param		p[^
 *	@param	flag		tF[hCAEgtO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndScrewPackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_SCREW_FP* param)
{
	WIPE_TYPE_WND_SCREW* data;

	wipe->wipe_work = sys_AllocMemory( wipe->heap, sizeof(WIPE_TYPE_WND_SCREW) );
	memset( wipe->wipe_work, 0, sizeof(WIPE_TYPE_WND_SCREW) );
	data = wipe->wipe_work;
	scchg_WndScrewInit( data, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap );

	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[CvC
 *
 *	@param	wipe		Cv
 *	
 *	@retval	TRUE		I
 *	@retval	FALSE		s
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndScrewPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_SCREW* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_SCREW*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndScrewMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_WndScrewEnd(wwm);	// EBhEf[^j
		scchg_h_WndDel(&wwm->hb);
		
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[֐
 *
 *	@param	data		[N
 *	@param	param		p[^
 *	@param	division	
 *	@param	piece_sync	VN
 *	@param	disp		
 *	@param	wnd_sys		EBhEVXe
 *	@param	p_wipehb	HuN֐VXe
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndScrewInit(WIPE_TYPE_WND_SCREW* data, WIPE_TYPE_WND_SCREW_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	WIPE_TYPE_HB_WND_ONE* one0;
	WIPE_TYPE_HB_WND_ONE* one1;

	// ωl߂
	data->screw.rota		= 0;
	data->screw.s_rota		= param->s_rota;
	data->screw.add_num_rota = param->e_rota - param->s_rota;

	// f[^ݒ
	scchg_h_WndMake(&data->hb, 2, disp, heap);
	data->a_count_max		= division;
	data->a_count			= 0;
	data->piece_sync		= piece_sync;
	data->sync_c			= 0;
	data->wnd_sys			= wnd_sys;
	data->p_wipehb			= p_wipehb;
	data->heap				= heap;
	data->fade_flg			= param->fade_flg;
	
	scchg_WndScrewOneAdd(&data->screw, data->a_count, data->a_count_max);
	scchg_WndScrewSum(data);	// 1vZ
	VWaitTCB_Add(scchg_WndSwap,&data->hb, WIPE_VBLANK_WND_SWAP_TCB );

	// EBhEݒ
	one0 = scchg_h_WndIdxDataGet(&data->hb, 0);
	one1 = scchg_h_WndIdxDataGet(&data->hb, 1);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, 0, disp,
			one0->wnd_tmp[0][0], 0, one0->wnd_tmp[1][0], 192,
			data->fade_flg);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, 1, disp,
			one1->wnd_tmp[0][0], 0, one1->wnd_tmp[1][0], 192,
			data->fade_flg);

	// EBhEI
	scchg_WndVisible( wnd_sys, GX_WNDMASK_W0|GX_WNDMASK_W1, disp, data->fade_flg );

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[C֐
 *
 *	@param	data	[N
 *
 *	@retval	TRUE		I
 *	@retval	FALSE		s
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndScrewMain(WIPE_TYPE_WND_SCREW* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count + 1) <= data->a_count_max){
			data->a_count++;

			// 
			scchg_WndScrewOneAdd(&data->screw, data->a_count, data->a_count_max);
			scchg_WndScrewSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap,&data->hb, WIPE_VBLANK_WND_SWAP_TCB );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb.disp, data->heap);
			return TRUE;
		}
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[[Nj֐
 *
 *	@param	data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndScrewEnd(WIPE_TYPE_WND_SCREW* data)
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	XN[f[^vZ֐
 *
 *	@param	work	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndScrewSum(WIPE_TYPE_WND_SCREW* work)
{
	WIPE_TYPE_HB_WND_ONE* one0;
	WIPE_TYPE_HB_WND_ONE* one1;
	u16 rota_num;
	int x1, x2;
	int i;


	// EBhE0	EBhE1 EŌvZ܂
	// EBhEe[uɒlݒ
	// EBhE0 I_128  n_128-(y*tan(rota))
	// EBhE1 n_128  I_128+(y*tan(rota))
	// px90ȏɂȂ
	// EBhE0 I_128-(y*tan(rota))  n_0
	// EBhE1 n_128+(y*tan(rota))  I_255
	
	rota_num = work->screw.rota % FX_GET_ROTA_NUM( 90 );
	
	one0 = scchg_h_WndIdxDataGet(&work->hb, 0);
	one1 = scchg_h_WndIdxDataGet(&work->hb, 1);
	// l₷̂ŁAEBhE1̕ŌvZ
	// vZʂTuXY]Đݒ肷
	for( i=0; i<96; i++ ){
		if( work->screw.rota < FX_GET_ROTA_NUM( 90 ) ){
			x1 = 128;

			// ]pƍRp`̕߂
			x2 = sub_rota_height_width_one( rota_num, (96 - i) );

			if( x2 > 127 ){
				x2 = 127;
			}
			
			one0->wnd_tmp[0][191 - i] = x1 - x2;
			one0->wnd_tmp[1][191 - i] = x1;

			one1->wnd_tmp[0][i] = x1;
			one1->wnd_tmp[1][i] = x1 + x2;
		}else{
			one0->wnd_tmp[0][191 - i] = 0;
			one0->wnd_tmp[1][191 - i] = 128;

			one1->wnd_tmp[0][i] = 128;
			one1->wnd_tmp[1][i] = 255;
		}
	}

	for( i=96; i<192; i++ ){
		if( work->screw.rota < FX_GET_ROTA_NUM( 90 ) ){
			one0->wnd_tmp[0][191 - i] = 128;
			one0->wnd_tmp[1][191 - i] = 128;

			one1->wnd_tmp[0][i] = 128;
			one1->wnd_tmp[1][i] = 128;
		}else{
			// ]pƍRp`̕߂
			x1 = sub_rota_height_width_one( FX_GET_ROTA_NUM( 90 ) - rota_num, (i - 96) );

			if( x1 > 127 ){
				x1 = 127;
			}
			
			one0->wnd_tmp[0][191 - i] = 0;
			one0->wnd_tmp[1][191 - i] = 128 - x1;
			
			one1->wnd_tmp[0][i] = 128 + x1;
			one1->wnd_tmp[1][i] = 255;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Pf[^̌vZ
 *
 *	@param	p_data		[N
 *	@param	count		ݶ
 *	@param	count_max	ő吔
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndScrewOneAdd( WIPE_TYPE_WND_SCREW_ONE* p_data, int count, int count_max )
{
	int rota_w;
	
	rota_w = p_data->add_num_rota * count;
	rota_w = rota_w / count_max;
	p_data->rota = rota_w + p_data->s_rota;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tbVCv@S
 *
 *	@param	wipe		Cv[N
 *	@param	param		p[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndFlashFourPackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_FLASH_FOUR_FP* param)
{
	WIPE_TYPE_WND_FLASH_FOUR* data;

	wipe->wipe_work = sys_AllocMemory( wipe->heap, sizeof(WIPE_TYPE_WND_FLASH_FOUR) );
	memset( wipe->wipe_work, 0, sizeof(WIPE_TYPE_WND_FLASH_FOUR) );
	data = wipe->wipe_work;
	scchg_WndFlashFourInit( data, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap );

	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tbV@S
 *
 *	@param	wipe	Cv[N
 *
 *	@retval	TRUE		I
 *	@retval	FALSE		s
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndFlashFourPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_FLASH_FOUR* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_FLASH_FOUR*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndFlashFourMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_WndFlashFourEnd(wwm);	// EBhEf[^j
		scchg_h_WndDel(&wwm->hb);
		
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tbV@S@
 *
 *	@param	data		[N
 *	@param	param		p[^
 *	@param	division	
 *	@param	piece_sync	VN
 *	@param	disp		
 *	@param	wnd_sys		EBhEVXe
 *	@param	p_wipehb	HuN֐VXe
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndFlashFourInit(WIPE_TYPE_WND_FLASH_FOUR* data, WIPE_TYPE_WND_FLASH_FOUR_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	WIPE_TYPE_HB_WND_ONE* one0;
	WIPE_TYPE_HB_WND_ONE* one1;
	
	// ωl߂
	data->screw.rota		= param->s_rota;
	data->screw.s_rota		= param->s_rota;
	data->screw.add_num_rota = param->e_rota - param->s_rota;

	// f[^ݒ
	scchg_h_WndMake(&data->hb, 2, disp, heap);
	data->a_count_max		= division;
	data->a_count			= 0;
	data->piece_sync		= piece_sync;
	data->sync_c			= 0;
	data->wnd_sys			= wnd_sys;
	data->p_wipehb			= p_wipehb;
	data->heap				= heap;
	data->fade_flg			= param->fade_flg;
	
	scchg_WndFlashFourSum(data);	// 1vZ
	VWaitTCB_Add(scchg_WndSwap,&data->hb, WIPE_VBLANK_WND_SWAP_TCB );

	// EBhEݒ
	one0 = scchg_h_WndIdxDataGet(&data->hb, 0);
	one1 = scchg_h_WndIdxDataGet(&data->hb, 1);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, 0, disp,
			0, 0, 255, 192,
			data->fade_flg);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, 1, disp,
			0, 0, 255, 192,
			data->fade_flg);

	// EBhEI
	scchg_WndVisible( wnd_sys, GX_WNDMASK_W0|GX_WNDMASK_W1, disp, data->fade_flg );

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *	@brief	tbV@SC֐
 *
 *	@param	data	[N
 *
 *	@retval	TRUE		I
 *	@retval	FALSE		s
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndFlashFourMain(WIPE_TYPE_WND_FLASH_FOUR* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count + 1) <= data->a_count_max){
			data->a_count++;

			// 
			scchg_WndFlashFourOneAdd(&data->screw, data->a_count, data->a_count_max);
			scchg_WndFlashFourSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap,&data->hb, WIPE_VBLANK_WND_SWAP_TCB );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb.disp, data->heap);
			return TRUE;
		}
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tbVSj֐
 *
 *	@param	data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndFlashFourEnd(WIPE_TYPE_WND_FLASH_FOUR* data)
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	tbVS֐	vZ
 *
 *	@param	work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndFlashFourSum(WIPE_TYPE_WND_FLASH_FOUR* work)
{
	WIPE_TYPE_HB_WND_ONE* one0;
	WIPE_TYPE_HB_WND_ONE* one1;
	u16 rota_num;
	int x1, x2;
	int i;

	rota_num = work->screw.rota;
	
	one0 = scchg_h_WndIdxDataGet(&work->hb, 0);
	one1 = scchg_h_WndIdxDataGet(&work->hb, 1);

	// E̕ɂS̃ubN̒lݒ肵Ă
	// O`STނŊSɕ
	for( i=0; i<96; i++ ){
		// ]pƍRp`̕߂
		x1 = sub_rota_height_width_one( rota_num, (96 - i) );
		x2 = sub_rota_height_width_one( FX_GET_ROTA_NUM(90) - rota_num, (96 - i) );
		if( x1 > 127 ){
			x1 = 127;
		}
		if( x2 > 127 ){
			x2 = 127;
		}

		// 
		one0->wnd_tmp[0][i] = 128 - x2;
		one0->wnd_tmp[1][i] = 128 - x1;
		
		// 
		one0->wnd_tmp[0][191 - i] = 128 - x2;
		one0->wnd_tmp[1][191 - i] = 128 - x1;
		
		// E
		one1->wnd_tmp[0][i] = 128 + x1;
		one1->wnd_tmp[1][i] = 128 + x2;
		
		// E
		one1->wnd_tmp[0][191 - i] = 128 + x1;
		one1->wnd_tmp[1][191 - i] = 128 + x2;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	pxvZ
 *
 *	@param	p_data		[N
 *	@param	count		ݶ
 *	@param	count_max	ő吔
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndFlashFourOneAdd( WIPE_TYPE_WND_FLASH_FOUR_ONE* p_data, int count, int count_max )
{
	int rota_w;
	
	rota_w = p_data->add_num_rota * count;
	rota_w = rota_w / count_max;
	
	p_data->rota = rota_w + p_data->s_rota;
}


//----------------------------------------------------------------------------
/**
 *	@brief	EBhEHuNgp@c@
 *
 *	@param	wipe		Cv[N
 *	@param	param		p[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndVMovePackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_VMOVE_PARAM* param)
{
	WIPE_TYPE_WND_VMOVE_CONT* data;

	wipe->wipe_work = sys_AllocMemory( wipe->heap, sizeof(WIPE_TYPE_WND_VMOVE_CONT) );
	memset( wipe->wipe_work, 0, sizeof(WIPE_TYPE_WND_VMOVE_CONT) );
	data = wipe->wipe_work;
	scchg_WndWndVMoveInit( data, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap );

	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *	@brief	EBhEHuNgp@c	
 *
 *	@param	wipe		Cv[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndWndVMovePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_VMOVE_CONT* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_VMOVE_CONT*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndWndVMoveMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_WndWndVMoveEnd(wwm);	// EBhEf[^j
		
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	EBhEHuNgp@c	
 *
 *	@param	data		[N
 *	@param	param		p[^
 *	@param	division	
 *	@param	piece_sync	VN
 *	@param	disp		
 *	@param	wnd_sys		EBhEVXe
 *	@param	p_wipehb	HuN֐VXe
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndVMoveInit(WIPE_TYPE_WND_VMOVE_CONT* data, WIPE_TYPE_WND_VMOVE_PARAM* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	// HuN[N
	scchg_h_VMoveWndInit( &data->HblankData, disp, 1, WNDP_WND_0, 0 );
	// [Nlݒ
	if( param->fade_flg == WIPE_FADE_IN ){
		memset( data->HblankData.data[0].in_out_write, WIPE_WND_VMOVE_OUTWND, sizeof( u8 ) * 192 );
		memset( data->HblankData.data[0].in_out_read, WIPE_WND_VMOVE_OUTWND, sizeof( u8 ) * 192 );
	}else{
		memset( data->HblankData.data[0].in_out_write, WIPE_WND_VMOVE_INWND, sizeof( u8 ) * 192 );
		memset( data->HblankData.data[0].in_out_read, WIPE_WND_VMOVE_INWND, sizeof( u8 ) * 192 );
	}


	// f[^e[uݒ
	data->p_param = param->cp_data;
	data->param_num = param->data_num;
	data->fade_flg = param->fade_flg;
	data->heap	= heap;

	// ωƃVNݒ
	data->a_count_max		= division;
	data->a_count			= 0;
	data->piece_sync		= piece_sync;
	data->sync_c			= 0;
	data->wnd_sys			= wnd_sys;
	data->p_wipehb		= p_wipehb;

	// HuN֐ݒ
	scchg_h_VMoveWnd_Start( p_wipehb, &data->HblankData, heap );


	// EBhEݒ
	if( param->fade_flg == WIPE_FADE_OUT ){
		scchg_WndSetUp(wnd_sys, GX_BLEND_PLANEMASK_BD, GX_BLEND_ALL, WNDP_WND_0, disp, 0, 0, 0, 0, param->fade_flg);
	}else{
		scchg_WndSetUp(wnd_sys, GX_BLEND_ALL, GX_BLEND_PLANEMASK_BD, WNDP_WND_0, disp, 0, 0, 0, 0, param->fade_flg);
	}

	// EBhEI
	scchg_WndVisible( wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg );

}

//----------------------------------------------------------------------------
/**
 *	@brief	C
 *
 *	@param	data	[N
 *
 *	@retval	 TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndWndVMoveMain(WIPE_TYPE_WND_VMOVE_CONT* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count + 1) <= data->a_count_max){
			data->a_count++;

			// 
			scchg_WndWndVMoveSum(data);		// vZ
			scchg_h_VMoveWnd_SwapReq( &data->HblankData );
		}else{
			// I
			scchg_h_VMoveWnd_End(data->p_wipehb, &data->HblankData, data->heap);
			return TRUE;
		}
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	j֐
 *	
 *	@param	data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndVMoveEnd(WIPE_TYPE_WND_VMOVE_CONT* data)
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	[NɃf[^ݒ֐
 *
 *	@param	work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndVMoveSum(WIPE_TYPE_WND_VMOVE_CONT* work)
{
	int i;
	WIPE_TYPE_WND_VMOVE_HDATA* p_buff;
	const WIPE_TYPE_WND_VMOVE_DATA* cp_one;

	// ݐobt@
	p_buff = &work->HblankData.data[0];

	for( i=0; i<work->param_num; i++ ){
		cp_one = &work->p_param[i];
		scchg_WndWndVMoveSub_Core( cp_one, p_buff, work->a_count, work->a_count_max );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	vZCore
 *
 *	@param	p_one		P̓f[^
 *	@param	p_buff		ݐobt@f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndVMoveSub_Core( const WIPE_TYPE_WND_VMOVE_DATA* p_one, WIPE_TYPE_WND_VMOVE_HDATA* p_buff, int count, int count_max )
{
	int i;
	int sum_work;	// vZ[N
	int e_y_sum;	// IYW̌vZ
	int min_y;
	int max_y;
	int set_wndmsk;

	sum_work = (p_one->e_y - p_one->s_y) * count;
	e_y_sum = sum_work / count_max;
	e_y_sum += p_one->s_y;

	// forł܂킷ߍŏYƍőY߂
	if( p_one->s_y <= p_one->e_y ){
		min_y = p_one->s_y;
		max_y = p_one->e_y;

		set_wndmsk = p_one->in_out;
	}else{
		min_y = p_one->e_y;
		max_y = p_one->s_y;
		if( p_one->in_out == WIPE_WND_VMOVE_INWND ){
			set_wndmsk = WIPE_WND_VMOVE_OUTWND;
		}else{
			set_wndmsk = WIPE_WND_VMOVE_INWND;
		}
	}

	for( i=min_y; i<max_y; i++ ){
		// }XN؂ւ
		if( i==e_y_sum ){
			if( set_wndmsk == WIPE_WND_VMOVE_INWND ){
				set_wndmsk = WIPE_WND_VMOVE_OUTWND;
			}else{
				set_wndmsk = WIPE_WND_VMOVE_INWND;
			}
		}
		p_buff->in_out_write[ i ] = set_wndmsk;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	p\R@Cv@@pbN
 *
 *	@param	wipe		Cv[N
 *	@param	param		p[^
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndPesocomPackInit(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_PESOCOM_PARAM* param)
{
	WIPE_TYPE_WND_PESOCOM* data;

	wipe->wipe_work = sys_AllocMemory( wipe->heap, sizeof(WIPE_TYPE_WND_PESOCOM) );
	memset( wipe->wipe_work, 0, sizeof(WIPE_TYPE_WND_PESOCOM) );
	data = wipe->wipe_work;


	if( param->wnd_move.fade_flg == WIPE_FADE_IN ){
		scchg_WndWndPesocomInit( data, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap );
	}else{
		scchg_WndWndPesocomOutInit( data, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap );
	}

	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *	@brief	p\RCv@C@pbN
 *
 *	@param	wipe	Cv[N
 *
 *	@retval	TRUE	I
 *	@ratval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndWndPesocomPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_PESOCOM* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_PESOCOM*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		if( wwm->fade_flg == WIPE_FADE_IN ){
			ret = scchg_WndWndPesocomMain(wwm, wipe);
		}else{
			ret = scchg_WndWndPesocomOutMain(wwm, wipe);
		}
		if(ret == TRUE){
			scchg_WndEnd(wipe->fade_inout, wipe->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		ret_num = TRUE;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	p\RCv@
 *
 *	@param	data		[N
 *	@param	param		p[^
 *	@param	division	
 *	@param	piece_sync	VN
 *	@param	disp		
 *	@param	wnd_sys		EBhEVXe
 *	@param	p_wipehb	HuN֐VXe
 *	@param	heap		q[v
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndPesocomInit(WIPE_TYPE_WND_PESOCOM* data, WIPE_TYPE_WND_PESOCOM_PARAM* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	int move_divi;

	move_divi = FX_Mul( division * FX32_ONE, param->sync_div_par ) >> FX32_SHIFT;
	data->sub_divi = division - move_divi;

	// p[^ۑ
	data->p_param = param;
	data->fade_flg = param->wnd_move.fade_flg;

	// wnd_move
	scchg_WndMoveInit(&data->wnd_move, &param->wnd_move, move_divi, piece_sync, disp, wnd_sys);
	if(param->wnd_move.wnd_no == 0){	// EBhEI
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W0,disp, param->wnd_move.fade_flg);
	}else{
		scchg_WndVisible(wnd_sys,GX_WNDMASK_W1, disp, param->wnd_move.fade_flg);
	}

	data->seq = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	p\R@Cv@C
 *
 *	@param	data
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndWndPesocomMain(WIPE_TYPE_WND_PESOCOM* data, WIPE_SYS_WIPE_WORK* wipe )
{
	BOOL result;
	BOOL ret = FALSE;
	
	switch( data->seq ){
	case 0:
		result = scchg_WndMoveMain( &data->wnd_move );
		if( result == TRUE ){
			data->seq ++;

			// split_divi
			scchg_WndWndVMoveInit(&data->wnd_split, &data->p_param->wnd_split, data->sub_divi, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap );
		}
		break;

	case 1:
		result = scchg_WndWndVMoveMain( &data->wnd_split );
		if( result == TRUE ){
			ret = TRUE;
			data->seq ++;
		}
		break;

	case 2:
		ret = TRUE;
		break;
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *	@brief	p\R@CvAEg@
 *
 *	@param	data		[N
 *	@param	param		p[^
 *	@param	division	
 *	@param	piece_sync	VN
 *	@param	disp		
 *	@param	wnd_sys		EBhEVXe
 *	@param	p_wipehb	HuN֐VXe
 *	@param	heap		q[v
 */
//-----------------------------------------------------------------------------
static void scchg_WndWndPesocomOutInit(WIPE_TYPE_WND_PESOCOM* data, WIPE_TYPE_WND_PESOCOM_PARAM* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	int split_divi;

	data->sub_divi = FX_Mul( division * FX32_ONE, param->sync_div_par ) >> FX32_SHIFT;
	split_divi = division - data->sub_divi;

	// p[^ۑ
	data->p_param = param;
	data->fade_flg = param->wnd_move.fade_flg;

	// split_divi
	scchg_WndWndVMoveInit(&data->wnd_split, &data->p_param->wnd_split, split_divi,piece_sync, disp, wnd_sys, p_wipehb, heap );

	data->seq = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	p\R@CvAEg@C
 *
 *	@param	data
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndWndPesocomOutMain(WIPE_TYPE_WND_PESOCOM* data, WIPE_SYS_WIPE_WORK* wipe )
{
	BOOL result;
	BOOL ret = FALSE;
	
	switch( data->seq ){
	case 0:
		result = scchg_WndWndVMoveMain( &data->wnd_split );
		if( result == TRUE ){
			data->seq ++;

			// wnd_move
			scchg_WndMoveInit(&data->wnd_move, &data->p_param->wnd_move, data->sub_divi, wipe->piece_sync, wipe->disp, wipe->wnd_sys);
			if(data->p_param->wnd_move.wnd_no == 0){	// EBhEI
				scchg_WndVisible(wipe->wnd_sys, GX_WNDMASK_W0, wipe->disp, data->p_param->wnd_move.fade_flg);
			}else{
				scchg_WndVisible(wipe->wnd_sys,GX_WNDMASK_W1, wipe->disp, data->p_param->wnd_move.fade_flg);
			}
		}
		break;

	case 1:
		result = scchg_WndMoveMain( &data->wnd_move );
		if( result == TRUE ){
			ret = TRUE;
			data->seq ++;
		}
		break;

	case 2:
		ret = TRUE;
		break;
	}

	return ret;
}

