//============================================================================================
/**
 * @file	wordset.c
 * @brief	PꃂW[
 * @author	taya
 * @date	2005.09.28
 */
//============================================================================================
#include "common.h"

#include "gflib\msg_print.h"
#include "gflib\fntsys.h"
#include "gflib\strbuf_family.h"
#include "system\gamedata.h"
#include "system\msgdata.h"
#include "system\pm_str.h"
#include "system\placename.h"
#include "application\wifi_country.h"
#include "savedata\mystatus.h"
#include "savedata\randomgroup.h"
#include "savedata\misc.h"
#include "msgdata\msg_sodateya.h"
#include "msgdata\msg_common_scr.h"
#include "msgdata\msg_supportname.h"
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/29
// ̖Oi̒Zk`j񋓂gmmǉ
#include "msgdata\msg_month.h"
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_EURO) imatake 2007/03/15
// K\̗񋓂܂gmmǉ
#include "msgdata\msg_ev_win.h"
// ----------------------------------------------------------------------------

#include "battle\battle_common.h"

#include "msgdata\msg.naix"
#include "system\wordset.h"


/*----------------------------------*/
/** @                          */
/*----------------------------------*/
enum {
	WORDSET_GRAMMER_NONE,		///< gpȂ
	WORDSET_GRAMMER_MALE,		///< j
	WORDSET_GRAMMER_FEMALE,		///< 
	WORDSET_GRAMMER_NEUTRAL,	///< 
};


/*----------------------------------*/
/** Pp[^                  */
/*----------------------------------*/
typedef struct {
	u8  def_article;		///< 芥hc
	u8  indef_article;		///< s芥hc
	u8  preposition;		///< Ouhc
	u8  grammer : 7;		///< @
	u8  form : 1;			///< PEi0 = Pj
}WORDSET_PARAM;


typedef struct {
	WORDSET_PARAM	param;
	STRBUF*			str;
}WORD;



struct _WORDSET{

	u32			max;
	u32			heapID;
	WORD*		word;
	STRBUF*		tmpBuf;

};




//==============================================================
// Prototype
//==============================================================
static void RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* str, const WORDSET_PARAM* param );
static void InitParam(WORDSET_PARAM* param);
static void RegistWord(u32 idx, const STRBUF* str, const WORDSET_PARAM* param);

//======================================================================================================
// VXeEI
//======================================================================================================

//------------------------------------------------------------------
/**
 * PZbgW[쐬
 *
 * @param   heapID			쐬q[vhc
 *
 * @retval  WORDSET*		PZbg
 */
//------------------------------------------------------------------
WORDSET*  WORDSET_Create( u32 heapID )
{
	return WORDSET_CreateEx( WORDSET_DEFAULT_SETNUM, WORDSET_DEFAULT_BUFLEN, heapID );
}

//------------------------------------------------------------------
/**
 * PZbgW[쐬io^PꐔE񒷂̎wŁj
 *
 * @param   word_max		
 * @param   buflen			
 * @param   heapID			
 *
 * @retval  WORDSET*		
 */
//------------------------------------------------------------------
WORDSET* WORDSET_CreateEx( u32 word_max, u32 buflen, u32 heapID )
{
	WORDSET* wordset = NULL;
	u32 i;

	GF_ASSERT_RETURN(word_max, NULL);
	GF_ASSERT_RETURN(buflen, NULL);

	do {
		WORDSET* wordset = sys_AllocMemoryLo( heapID, sizeof(WORDSET) );
		if( wordset == NULL ){ break; }

		wordset->max = word_max;
		wordset->heapID = heapID;

		wordset->tmpBuf = STRBUF_Create(buflen, heapID );
		if( wordset->tmpBuf == NULL ){ break; }

		wordset->word = sys_AllocMemoryLo( heapID, sizeof(WORD)*word_max );
		if( wordset->word == NULL ){ break; }

		for(i=0; i<word_max; i++)
		{
			InitParam(&(wordset->word[i].param));
			wordset->word[i].str = STRBUF_Create( buflen, heapID );
			if( wordset->word[i].str == NULL ){
				break;
			}
		}

		if( i == word_max )
		{
			return wordset;
		}

	}while(0);

	if( wordset )
	{
		WORDSET_Delete(wordset);
	}
	return NULL;
}

//------------------------------------------------------------------
/**
 * PZbgj
 *
 * @param   wordset		
 *
 */
//------------------------------------------------------------------
void WORDSET_Delete( WORDSET* wordset )
{
	u32 i;

	GF_ASSERT(wordset->max);

	if( wordset->word )
	{
		for(i=0; i<wordset->max; i++)
		{
			if( wordset->word[i].str )
			{
				STRBUF_Delete( wordset->word[i].str );
			}
			else
			{
				break;
			}
		}
		sys_FreeMemoryEz(wordset->word);
	}

	if( wordset->tmpBuf )
	{
		STRBUF_Delete(wordset->tmpBuf);
	}

	wordset->max = 0;
	sys_FreeMemoryEz(wordset);
}


//------------------------------------------------------------------
/**
 * Pp[^
 *
 * @param   param		p[^\̂ւ̃|C^
 *
 */
//------------------------------------------------------------------
static void InitParam(WORDSET_PARAM* param)
{
	// ȂɂĂȂ
}

//======================================================================================================
// PZbgW[ɊePo^
//======================================================================================================

//------------------------------------------------------------------
/**
 * Pꕶ񁕃p[^wobt@ɓo^
 *
 * @param   wordset		PZbgW[
 * @param   bufID		obt@hc
 * @param   str			
 * @param   param		ɕtp[^
 *
 */
//------------------------------------------------------------------
static void RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* str, const WORDSET_PARAM* param )
{
	GF_ASSERT_MSG( bufID < wordset->max, "bufID=%d, wordmax=%d", bufID, wordset->max );

	if( bufID < wordset->max )
	{
		if( param != NULL )
		{
			wordset->word[bufID].param = *param;
		}
		STRBUF_Copy( wordset->word[bufID].str, str );
	}
}



//------------------------------------------------------------------
/**
 * Cӕp[^tœo^
 *
 * @param   wordset			PZbg
 * @param   bufID			obt@ID
 * @param   word			
 * @param   sex				ʃR[h
 * @param	singular_flag	P^iTRUEŒPj
 * @param   lang			R[h
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* word, u32 sex, BOOL singular_flag, u32 lang )
{
	RegisterWord( wordset, bufID, word, NULL );
}


//------------------------------------------------------------------
/**
 * vC[o^
 *
 * @param   wordset		PZbgIuWFNg
 * @param   bufID		obt@ID
 * @param   status		
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPlayerName( WORDSET* wordset, u32 bufID, const MYSTATUS* status )
{
	const STRCODE * name;
	name = MyStatus_GetMyName( status );

	STRBUF_SetStringCode( wordset->tmpBuf, name );

	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * Coo^
 *
 * @param   wordset		PZbgW[
 * @param   bufID			obt@ID
 * @param   savedata		Z[uf[^ւ̃|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterRivalName( WORDSET* wordset,  u32 bufID, const SAVEDATA * savedata )
{
#if 0
	static const STRCODE name[] = {
		PA_, bou_, RU_, EOM_,
	};

	// [[[ ͌Œ薼Rs[Ă邾Bg[i[QƂĂ낢B
	STRBUF_SetStringCode( wordset->tmpBuf, name );
#endif
	const STRCODE * rivalname = MISC_GetRivalName(SaveData_GetMiscReadOnly(savedata));
	STRBUF_SetStringCode( wordset->tmpBuf, rivalname );

	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * T|[gLwobt@ɓo^
 *
 * @param   bufID			obt@ID
 * @param   savedata		Z[uf[^ւ̃|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSupportName( WORDSET* wordset, u32 bufID, const SAVEDATA * savedata )
{
	const MYSTATUS*  myStatus = SaveData_GetMyStatus( (SAVEDATA*)savedata );

	MSGDATA_MANAGER* man;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_supportname_dat, wordset->heapID );

	if( MyStatus_GetMySex( myStatus ) == PM_MALE )
	{
		MSGMAN_GetString( man, support_name_female, wordset->tmpBuf );
	}
	else
	{
		MSGMAN_GetString( man, support_name_male, wordset->tmpBuf );
	}

	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
	MSGMAN_Delete(man);
}
//------------------------------------------------------------------
/**
 * Δ̖Owobt@ɓo^
 *
 * @param	wordset	
 * @param   bufID			obt@ID
 * @param   savedata		Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
void WORDSET_RegisterMonumentName( WORDSET* wordset, u32 bufID, const SAVEDATA * savedata )
{
	const MISC * misc = SaveData_GetMiscReadOnly( savedata );
	STRBUF_SetStringCode( wordset->tmpBuf, MISC_GetMonumentName( misc ) );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|Po^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeMonsName( WORDSET* wordset, u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	MSGDATA_MANAGER* man;
	u32 monsno;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, wordset->heapID );

	// [[[Ń|P̐ʓ`FbNł]]]
	monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
	MSGMAN_GetString( man, monsno, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);

	MSGMAN_Delete(man);
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/11
// s芥t̃|PĂ֐ǉ

void WORDSET_RegisterPokeMonsNameIndefinate( WORDSET* wordset, u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	u32 monsno;

	monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
	WORDSET_RegisterPokeMonsNameIndefinateByNo( wordset, bufID, monsno );
}

void WORDSET_RegisterPokeMonsNameIndefinateByNo( WORDSET* wordset, u32 bufID, u32 monsno )
{
	MSGDATA_MANAGER* man;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, wordset->heapID );
#else
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_ind_dat, wordset->heapID );
#endif
// ----------------------------------------------------------------------------

	MSGMAN_GetString( man, monsno, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);

	MSGMAN_Delete(man);
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̃jbNl[o^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeNickName( WORDSET* wordset, u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	// [[[Ń|P̐ʓ`FbNł]]]
	PokePasoParaGet( ppp, ID_PARA_nickname_buf, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̐eo^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeOyaName( WORDSET* wordset,  u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	// [[[Őe̐ʂ`FbNł]]]
	PokePasoParaGet( ppp, ID_PARA_oyaname_buf, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);

}

//------------------------------------------------------------------
/**
 * wobt@ɐo^
 *
 * @param   bufID		obt@ID
 * @param   number		l
 * @param   keta		
 * @param   dispType	`^Cv
 * @param   codeType	R[h^Cv
 *
 * dispType :  NUMBER_DISPTYPE_LEFT    l
 *             NUMBER_DISPTYPE_SPACE   El߁iXy[X߁j
 *             NUMBER_DISPTYPE_ZERO    El߁i[߁j
 *
 *
 * codeType :  NUMBER_CODETYPE_DEFAULT  [JCỸftHgi{Sp^COpjɂȂ
 *             NUMBER_CODETYPE_ZENKAKU  Spw
 *             NUMBER_CODETYPE_HANKAKU  pw
 */
//------------------------------------------------------------------
void WORDSET_RegisterNumber( WORDSET* wordset, u32 bufID, s32 number, u32 keta, NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType )
{
	STRBUF_SetNumber( wordset->tmpBuf, number, keta, dispType, codeType );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@ɃUo^
 *
 * @param   bufID			obt@ID
 * @param   wazaID			UID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterWazaName( WORDSET* wordset, u32 bufID, u32 wazaID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_wazaname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString(man, wazaID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ{o^
 *
 * @param   bufID			obt@ID
 * @param   ribbonID		{ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterRibbonName( WORDSET* wordset, u32 bufID, u32 ribbonID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_ribbon_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString(man, ribbonID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̂Ƃo^
 *
 * @param   bufID			obt@ID
 * @param   tokuseiID		ƂID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTokuseiName( WORDSET* wordset, u32 bufID, u32 tokuseiID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_tokusei_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString(man, tokuseiID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̂o^
 *
 * @param   bufID			obt@ID
 * @param   seikakuID		ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSeikaku( WORDSET * wordset, u32 bufID, u32 seikakuID )
{
	MSGDATA_MANAGER * man;
	
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_chr_dat, wordset->heapID );
	
	MSGMAN_GetString( man, seikakuID, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );

	MSGMAN_Delete(man);
}

//------------------------------------------------------------------
/**
 * wobt@ɃACeo^
 *
 * @param   bufID			obt@ID
 * @param   itemID			ACeID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterItemName( WORDSET* wordset, u32 bufID, u32 itemID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, itemID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/13
// tE`̃ACeĂXNvg߂ǉ

void WORDSET_RegisterItemNameIndefinate( WORDSET* wordset, u32 bufID, u32 itemID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/22
// tACe dat t@Cpӂł̂ł悤
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_ind_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------
	if( man )
	{
		MSGMAN_GetString( man, itemID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

void WORDSET_RegisterItemNamePlural( WORDSET* wordset, u32 bufID, u32 itemID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/22
// `ACe dat t@Cpӂł̂ł悤
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_plu_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------
	if( man )
	{
		MSGMAN_GetString( man, itemID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@ɃACe|Pbgo^
 *
 * @param   bufID			obt@ID
 * @param   wazaID			|PbgID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterItemPocketName( WORDSET* wordset, u32 bufID, u32 pocketID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itempocket_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, pocketID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃACe|PbgiACRtjo^
 *
 * @param   bufID			obt@ID
 * @param   wazaID			|PbgID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterItemPocketWithIcon( WORDSET* wordset, u32 bufID, u32 pocketID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itempocket_icon_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, pocketID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}


//------------------------------------------------------------------
/**
 * wobt@Ƀ|PiUj^Cvo^
 *
 * @param   bufID			obt@ID
 * @param   typeID			^CvID
 * @param   msgManager		^CvGMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeTypeName( WORDSET* wordset, u32 bufID, u32 typeID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_typename_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, typeID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
//------------------------------------------------------------------
/**
 * wobt@Ƀ|PXe[^Xo^
 *
 * @param   bufID			obt@ID
 * @param   statusID		Xe[^XID
 * @param   msgManager		Xe[^XGMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeStatusName( WORDSET* wordset, u32 bufID, u32 statusID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_status_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, statusID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
//------------------------------------------------------------------
/**
 * wobt@ɏԈُ햼o^
 *
 * @param   bufID			obt@ID
 * @param   conditionID		ԈُID
 * @param   msgManager		Ԉُ햼GMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterBadConditionName( WORDSET* wordset, u32 bufID, u32 conditionID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_condition_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, conditionID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɖ؂̖̎o^
 *
 * @param   bufID			obt@ID
 * @param   tasteID			؂̖̎ID
 * @param   msgManager		؂̖̎GMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSeedTasteName( WORDSET* wordset, u32 bufID, u32 tasteID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_taste_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, tasteID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɒno^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		nID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPlaceName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_place_name_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|Pb`Avo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		AvID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPoketchAppName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_poketch_app_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀg[i[ʂo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		g[i[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTrTypeName( WORDSET* wordset, u32 bufID, u32 strID )
{
	//poketool/tr_tool.hCN[h
	//TT_TrainerTypeSexGet(strID)Ƃ邱ƂŃg[i[̐ʂ擾ł܂
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trtype_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/19
// s芥t̃g[i[^CvĂXNvg߂ǉ
void WORDSET_RegisterTrTypeNameIndefinate( WORDSET* wordset, u32 bufID, u32 strID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trtype_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trtype_ind_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@Ƀg[i[ʂo^i퓬pj
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		g[i[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTrTypeNameBattle( WORDSET* wordset, u32 bufID, TRAINER_DATA *tr_data )
{
	//poketool/tr_tool.hCN[h
	//TT_TrainerTypeSexGet(tr_data->tr_type)Ƃ邱ƂŃg[i[̐ʂ擾ł܂
	
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trtype_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, tr_data->tr_type, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀg[i[o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		g[i[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTrainerName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀg[i[o^i퓬pj
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		g[i[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTrainerNameBattle( WORDSET* wordset, u32 bufID, TRAINER_DATA *tr_data )
{
	//poketool/tr_tool.hCN[h
	//TT_TrainerTypeSexGet(tr_data->tr_type)Ƃ邱ƂŃg[i[̐ʂ擾ł܂

	STRBUF_SetStringCode( wordset->tmpBuf, &tr_data->name[0] );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@ɒnACei΁jo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		nACei΁jID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterUGItemName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergrounditem_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/27
// s芥t̒nACeĂ֐ǉ
void WORDSET_RegisterUGItemNameIndefinate( WORDSET* wordset, u32 bufID, u32 strID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergrounditem_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergrounditem_ind_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------

	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@ɒn㩖o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		nID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterUGTrapName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundtrap_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/27
// s芥t̒n㩖Ă֐ǉ
void WORDSET_RegisterUGTrapNameIndefinate( WORDSET* wordset, u32 bufID, u32 strID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundtrap_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundtrap_ind_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@ɐRo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		RID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterJudgeName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_judge_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃReXgNo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		NID(CAMSG_CONRANK_NORMAL, CAMSG_CONRANK_SUPER, )
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterContestRank( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_acting_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * ReXg^Cv(ReXg)Ƀ^Cvo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		^CvID(CAMSG_CONTYPE_STYLE, )
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterContestType( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_acting_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɔ閧̎o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		閧̎ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSecretQuestion( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undersecretquestion_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɔ閧̎̓o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		閧̎̓ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSecretAnswer( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undersecretanswer_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃObYo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		ObYID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterUGGoodsName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundgoods_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/27
// s芥t̒nObYĂ֐ǉ
void WORDSET_RegisterUGGoodsNameIndefinate( WORDSET* wordset, u32 bufID, u32 strID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundgoods_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundgoods_ind_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@Ƀ|Pʖo^
 *
 * @param   bufID		obt@ID
 * @param   sex			
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeMonsSex( WORDSET* wordset, u32 bufID, u8 sex)
{
	MSGDATA_MANAGER* man;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_common_scr_dat, wordset->heapID );

	switch(sex){
	case PARA_MALE:
		MSGMAN_GetString( man, msg_mons_sex_osu, wordset->tmpBuf );
		break;
	case PARA_FEMALE:
		MSGMAN_GetString( man, msg_mons_sex_mesu, wordset->tmpBuf );
		break;
	default:
		STRBUF_Clear( wordset->tmpBuf );
	}
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
	MSGMAN_Delete(man);

}

//------------------------------------------------------------------
/**
 * wobt@Ƀ{bNX̃gCo^
 *
 * @param   wordset		[hZbgIuWFNg|C^
 * @param   bufID		obt@ID
 * @param   boxData		{bNXf[^|C^
 * @param   u32         gCio[
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterBoxTrayName( WORDSET* wordset, u32 bufID, const BOX_DATA* boxData, u32 trayNumber )
{
	BOXDAT_GetBoxName( boxData, trayNumber, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
}

//------------------------------------------------------------------
/**
 * wobt@ɃWo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		ObYID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterGymName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_gym_name_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ɏԑтo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		ObYID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTimeType( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_time_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɍo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterCountryName( WORDSET* wordset, u32 bufID, u32 countryID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_wifi_place_msg_world_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, countryID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɒn於o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   countryID	ID
 * @param   placeID		nID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterLocalPlaceName( WORDSET* wordset, u32 bufID, u32 countryID, u32 placeID )
{
	u32  datID;

	datID = WIFI_COUNTRY_CountryCodeToPlaceMsgDataID(countryID);
	if( datID )
	{
		if( placeID )
		{
			MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, datID, wordset->heapID);
			if( man )
			{
				MSGMAN_GetString( man, placeID, wordset->tmpBuf );
				RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
				MSGMAN_Delete(man);
			}
		}
	}
}


//------------------------------------------------------------------
/**
 * wobt@ɊȈՉbPo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   word		ȈՉbPio[
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPMSWord( WORDSET* wordset, u32 bufID, PMS_WORD word )
{
	PMSW_GetStr( word, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
}


//------------------------------------------------------------------
/**
 * wobt@ɃV[o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		V[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSealName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_bc_seal_name_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/26
// `̃V[Ă֐ǉ

void WORDSET_RegisterSealNamePlural( WORDSET* wordset, u32 bufID, u32 strID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_bc_seal_name_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_bc_seal_name_plu_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@Ƀ|Pߊlꏊo^
 *
 * @param   wordset			[hZbgIuWFNg
 * @param   bufID			Ԃ̃obt@ɓo^邩
 * @param   placeNumber		ߊlꏊio[
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeGetPlace( WORDSET* wordset, u32 bufID, u32 placeNumber )
{
	static const u16 placenameFileID[] = {
		NARC_msg_place_name_dat,
		NARC_msg_place_name_tokusyu_dat,
		NARC_msg_place_name_haihu_dat,
	};

	PLACENAME_TYPE type;
	int strID;
	MSGDATA_MANAGER* man;

	type = PlaceName_GetType( placeNumber );
	strID = PlaceName_GetIndex( placeNumber );

	man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, placenameFileID[type], wordset->heapID);
	if( man )
	{
		if( strID < MSGMAN_GetMessageCount(man) )
		{
			MSGMAN_GetString( man, strID, wordset->tmpBuf );
			RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
			MSGMAN_Delete( man );
		}
		else
		{
			MSGMAN_Delete( man );
			man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, placenameFileID[0], wordset->heapID);
			if( man )
			{
				MSGMAN_GetString( man, 0, wordset->tmpBuf );
				RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
				MSGMAN_Delete( man );
			}
		}
	}
}


//------------------------------------------------------------------
/**
 * wobt@Ƀ|go^
 *
 * @param   wordset			[hZbgIuWFNg
 * @param   bufID			Ԃ̃obt@ɓo^邩
 * @param   porutoID		|gID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPorutoName( WORDSET* wordset, u32 bufID, u32 porutoID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_porutoname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, porutoID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃANZTiC[WNbvjo^
 *
 * @param   wordset			[hZbgIuWFNg
 * @param   bufID			Ԃ̃obt@ɓo^邩
 * @param   porutoID		ANZTID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterAccessoryName( WORDSET* wordset, u32 bufID, u32 acID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_imageclip_acce_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, acID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/11
// s芥t̃ANZT[Ă֐ǉ

void WORDSET_RegisterAccessoryNameIndefinate( WORDSET* wordset, u32 bufID, u32 acID )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/12
// ؍ł͕sEʂȂ
#if PM_LANG == LANG_KOREA
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_imageclip_acce_dat, wordset->heapID);
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_imageclip_acce_ind_dat, wordset->heapID);
#endif
// ----------------------------------------------------------------------------

	if( man )
	{
		MSGMAN_GetString( man, acID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * wobt@ɃC[WNbvwi̖Oo^
 *
 * @param   wordset		
 * @param   bufID		
 * @param   bgID		
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterImageClibBgName( WORDSET* wordset, u32 bufID, u32 bgID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_imageclip_bg_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, bgID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * @brief	O[vE[_[̒Po^
 * @param	ws			WORDSETւ̃|C^
 * @param	sv			Z[uf[^ւ̃|C^
 * @param	gid			O[vwID
 * @param	bufID		obt@wID
 * @param	name_type	RANDOMGROUP_NAME_GROUP or RANDOMGROUP_NAME_LEADER
 */
//------------------------------------------------------------------
void WORDSET_RegisterGroupName(WORDSET * ws, SAVEDATA * sv, int gid, int bufID, int name_type)
{
	int sex, region_code;
	STRBUF * strbuf;
	RANDOM_GROUP * rg = SaveData_GetRandomGroup(sv);
	sex = RandomGroup_GetSex(rg, gid);
	region_code = RandomGroup_GetRegionCode(rg, gid);
	strbuf = STRBUF_Create(64, HEAPID_FIELD);	//obt@ĂƁ[
	STRBUF_SetStringCode(strbuf, RandomGroup_GetNamePtr(rg, gid, name_type));
	WORDSET_RegisterWord(ws, bufID, strbuf, sex, TRUE, region_code);
	STRBUF_Delete(strbuf);
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/29
// ̖Oi̒Zk`jĂ֐ǉ
// localize_spec_mark(LANG_ALL) imatake 2007/01/26
// month  1 ` 12 ȊOƂɂ _NULL_ Zbg悤ɕύX

void WORDSET_RegisterMonthName( WORDSET* wordset, u32 bufID, u32 month )
{
#if PM_LANG == LANG_KOREA
	GF_ASSERT_MSG( 0, "WORDSET_RegisterMonthName() is available no more.\n" );

	WORDSET_RegisterNumber( wordset, bufID, month, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
#else
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_month_dat, wordset->heapID);

	if( man )
	{
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/01/26
		// month  1 ` 12 ȊOƂɂ́uPvZbg悤ɕύX
		if (month < 1 || month > 12) month = 1;
		// ----------------------------------------------------------------------------

		MSGMAN_GetString( man, month - 1 + msg_month_01, wordset->tmpBuf );		// 풓邱ƂlAe[u͎Ȃ
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
#endif
}

// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/24
// wobt@̐擪Ls^CY֐ǉ

void WORDSET_Capitalize( WORDSET* wordset, u32 bufID )
{
	STRBUF_Capitalize(wordset->word[bufID].str);
}

// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_EURO) imatake 2007/03/15
// K\Ă֐ǉ

void WORDSET_RegisterFloorName( WORDSET* wordset, u32 bufID, u32 floor )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_ev_win_dat, wordset->heapID);

	GF_ASSERT( floor >= 1 && floor <= 5 );	// gmmt@CɗpӂĂeLXg5K܂

	if( man )
	{
		MSGMAN_GetString( man, floor - 1 + msg_ev_win_113, wordset->tmpBuf );	// 풓邱ƂlAe[u͎Ȃ
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

// ----------------------------------------------------------------------------

//======================================================================================================
// WJ
//======================================================================================================

//------------------------------------------------------------------
/**
 * o^ꂽPgĕWJ
 *
 * @param   dst		WJobt@
 * @param   src		WJ
 *
 */
//------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/07
// }OɐF߂tOɑΉ
#if PM_LANG == LANG_KOREA
#define COLOR0_FLAG		(0x0010)
#endif
// ----------------------------------------------------------------------------
void WORDSET_ExpandStr( const WORDSET* wordset, STRBUF* dstbuf, const STRBUF* srcbuf )
{
	const STRCODE* src;
	STRCODE *dst;

	src = STRBUF_GetStringCodePointer(srcbuf);
	STRBUF_Clear( dstbuf );

	while( *src != EOM_ )
	{
		if( *src == _CTRL_TAG )
		{
			if( STRCODE_CheckWordSetTagType(src) )
			{
				u32 word_id;

				word_id = STRCODE_GetTagParam(src, 0);

				GF_ASSERT( word_id < wordset->max );

				// [[[COłł̓p[^̉߂Kv]]]
				// ----------------------------------------------------------------------------
				// localize_spec_mark(LANG_ALL) imatake 2006/12/06
				// kꂽ͓WJČ悤ɕύX
				STRBUF_AddCompStr( dstbuf, wordset->word[ word_id ].str );
				// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/11
// ؍̏̕ωɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/09/25
// ʊ֐ʉ
// localize_spec_mark(LANG_KOREA) imatake 2007/11/07
// }OɐF߂tOɑΉ
#if PM_LANG == LANG_KOREA
				{
					STRCODE last_char   = STRBUF_GetLastChar(dstbuf);
					int     particle_id = STRCODE_GetTagParam(src, 1);
					STRCODE particle    = WORDSET_GetParticle(last_char, particle_id);

					if (particle_id & COLOR0_FLAG) {
						STRBUF_AddChar(dstbuf, _CTRL_TAG);
						STRBUF_AddChar(dstbuf, NC_FONT_COL_);
						STRBUF_AddChar(dstbuf, 1);		// p[^
						STRBUF_AddChar(dstbuf, 0);		// Fwij
					}

					if (particle) STRBUF_AddChar(dstbuf, particle);
				}
#endif
// ----------------------------------------------------------------------------
				src = STRCODE_SkipTag(src);
			}
			else
			{
				const STRCODE* p = src;

				src = STRCODE_SkipTag(src);
				while(p < src)
				{
					STRBUF_AddChar( dstbuf, *p++ );
				}
				
			}
		}
		else
		{
			STRBUF_AddChar( dstbuf, *src++ );
		}
	}
}




//======================================================================================================
// obt@NA
//======================================================================================================

//------------------------------------------------------------------
/**
 * obt@Sċ󕶎ŃNA
 *
 * @param   wordset		WORDSETւ̃|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_ClearAllBuffer( WORDSET* wordset )
{
	u32 i;
	for(i=0; i<wordset->max; i++)
	{
		STRBUF_Clear( wordset->word[i].str );
	}
}




// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/11
// ؍̏̕ωɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/09/25
// ʊ֐ʉ
// localize_spec_mark(LANG_KOREA) imatake 2007/10/15
// nOȊO̕i܃nOjpb`Ȃƈ悤ɕύX
// localize_spec_mark(LANG_KOREA) imatake 2007/10/19
// ɑ΂鏕̏oɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/11/07
// }OɐF߂tOɑΉ

#if PM_LANG == LANG_KOREA

enum {
	STRCODE_HANGUL_MIN = 0x401,
	STRCODE_HANGUL_MAX = 0xD70,
	STRCODE_NUMBER_MIN = h_n0_,
	STRCODE_NUMBER_MAX = h_n9_,

	PARTICLE_ID_MASK = 0x000F,
	PARTICLE_ID_NUM  = 8,
	PARTICLE_ID_NI   = 5,

	PATCHIM_BITS_NUMBER    = 0x1CB,		// 0,1,3,6,7,8 c pb`  2,4,5,9 c pb`Ȃ
	PATCHIM_BITS_NUMBER_NI = 0x049,		// 1,7,8 c pb`uȁvȂ̂ŗO
};

#define IS_HANGUL(strcode)	(strcode >= STRCODE_HANGUL_MIN && strcode <= STRCODE_HANGUL_MAX)
#define IS_NUMBER(strcode)	(strcode >= STRCODE_NUMBER_MIN && strcode <= STRCODE_NUMBER_MAX)

static const STRCODE particle_table[2][PARTICLE_ID_NUM] = {
	// Ȃ, ,    ,    ,    ,    ,    ,    
	{ 0,     0x59A, 0x6F6, 0x401, 0x9AF, 0,     0,     0x963 },	// pb`Ȃ
	{ 0,     0x9FA, 0x9FB, 0xA0C, 0x45A, 0x9F8, 0xA0C, 0x94A },	// pb`
};

static u8 patchim_table[] = {
	0xFE,0xFF,0xFB,0xF7,0xED,0xFF,0xF7,0xF7,0x7F,0xEF,0xFF,0xFD,0xFB,0xFE,0xDE,0xFF,
	0xFB,0xFA,0xED,0x3F,0xFF,0xF7,0x7F,0xFF,0xF6,0xDF,0xF7,0xF9,0xDF,0xDB,0xE7,0xBF,
	0xFB,0x3D,0xFF,0xF7,0xF7,0xFF,0xEF,0xDF,0xF7,0xFF,0xFE,0xFD,0xEB,0x7F,0xF7,0xFD,
	0xFE,0xE5,0x7D,0xFF,0xB7,0xFF,0xFE,0xFF,0xFB,0xE7,0xFF,0xFB,0xF7,0xFA,0x7F,0xEB,
	0xF3,0x57,0xDF,0xFB,0xCF,0xFF,0xFE,0xFB,0xF7,0x7F,0xFF,0x7A,0xE9,0xE7,0xFB,0x7B,
	0xBF,0xFF,0xFB,0xF7,0xFE,0xFB,0xFB,0x77,0x7F,0xF7,0xFB,0xFE,0xF2,0xFB,0xFB,0xDF,
	0xDF,0xFF,0xEF,0xBF,0xFB,0xDF,0xBF,0x3F,0xFF,0xDD,0xF7,0xFE,0xBF,0x67,0xEF,0xFD,
	0xBF,0xFF,0xDF,0x7F,0xF7,0xBF,0xFF,0xFE,0xF5,0x6F,0x7D,0xFD,0xBF,0x79,0xDF,0xEF,
	0x7F,0xFF,0xFB,0xB7,0x7F,0xFD,0x7E,0xFA,0xF5,0xFE,0xFE,0xBF,0x7F,0x7F,0xEF,0xFF,
	0xF7,0xEF,0xDF,0xFD,0xEF,0x7D,0xDF,0xDF,0xFF,0xF5,0xFD,0x7D,0xFF,0xFE,0xF7,0xDF,
	0xBF,0x7F,0xF7,0xEF,0x7A,0x7E,0xD9,0xDF,0xFD,0xFD,0xFF,0xFD,0xFB,0xDF,0xFD,0xFF,
	0xFB,0xFB,0xFF,0xFB,0xFD,0xBF,0x7F,0xDF,0xDF,0xDF,0x7F,0x7F,0xBF,0xBF,0x7F,0xFF,
	0xBF,0xF7,0xFF,0xFD,0xBF,0x7F,0xBF,0xFD,0xF7,0xF7,0xF3,0x7F,0xDF,0x7E,0xF7,0x5F,
	0x7E,0xF7,0xF7,0xFF,0xFE,0xF7,0x6F,0xFF,0xEA,0xDF,0xF5,0xFD,0xC6,0xFD,0xFB,0xDF,
	0xBF,0xEF,0xDF,0xDF,0xF6,0x77,0xBF,0xFE,0xEA,0xF7,0xFE,0xFE,0xFB,0xFB,0xB7,0xFF,
	0xFE,0xFE,0xFC,0x7D,0xE5,0xEF,0xFA,0xBB,0xDF,0xDF,0x7F,0xFF,0xFA,0xEF,0x6F,0xFD,
	0xCB,0xF9,0xCB,0xEF,0xFD,0x7B,0x7F,0xFF,0xF7,0xAF,0x7F,0x7F,0xBF,0xFB,0xAB,0xF7,
	0x5F,0xEF,0xFB,0xFE,0xFE,0xFD,0xEB,0xDF,0xDF,0xBF,0xFB,0xEF,0x7B,0xBF,0xF7,0xF7,
	0xDE,0xDF,0xEF,0xFF,0xBE,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// u`Ɂvp̃e[uBpb`uȁv̂Ƃ́Apb`ȂƓ
static u8 patchim_table_ni[] = {
	0xEE,0xFF,0xDB,0xB7,0xE5,0xFE,0xD7,0xF7,0x7E,0xED,0xFE,0xED,0xEB,0xF6,0xDA,0xFD,
	0xDB,0xDA,0xE5,0x3E,0xF7,0x77,0x7F,0xFB,0x72,0xDF,0xD7,0xB9,0x5F,0x5B,0x67,0x3F,
	0xDB,0x35,0xF7,0xB7,0xF7,0xFE,0x6F,0xDF,0x76,0xFF,0xF6,0xED,0x6B,0x7F,0xD5,0xED,
	0xEE,0xA5,0x75,0xFB,0x97,0xFD,0xDE,0xFF,0xDB,0xE7,0xFD,0xDB,0xD7,0xBA,0x7F,0xA9,
	0xB3,0x57,0x5D,0xBB,0xCF,0xFD,0xF6,0xDB,0xB7,0x7F,0xFB,0x5A,0x68,0xA7,0xBB,0x6B,
	0xBD,0xFD,0xDB,0xF7,0xF6,0xDB,0xDB,0x77,0x7B,0xD7,0xEB,0xF6,0xB2,0xDB,0xDB,0xDF,
	0xDE,0xFB,0x6F,0xBF,0xDA,0xDF,0xBE,0x3D,0xF7,0x5D,0xD7,0xDE,0xBF,0x26,0xAD,0xDD,
	0xBF,0xEF,0xDF,0x7E,0x77,0xBF,0xFB,0xF6,0x75,0x6F,0x6D,0xDD,0x3F,0x59,0xDD,0x6E,
	0x7F,0xFB,0xDB,0xB7,0x7B,0xFD,0x76,0xDA,0xD5,0xF6,0xDE,0xBF,0x7D,0x7B,0xED,0xFB,
	0xB7,0x6F,0x5F,0xDD,0x6F,0x75,0xDD,0xDE,0xFD,0xB5,0xED,0x75,0xFB,0xEE,0x77,0xDF,
	0xBE,0x7D,0x75,0xEF,0x6A,0x76,0xD9,0x5E,0xED,0xBD,0xFF,0xED,0xDB,0x5F,0xBD,0xFF,
	0xDB,0xBB,0xFF,0xEB,0xED,0xBF,0x7D,0xDF,0xDE,0xDE,0x7E,0x7B,0xBB,0xBD,0x7D,0xFB,
	0xBF,0xB6,0xFF,0xBD,0xBF,0x7D,0xB7,0xEC,0xB7,0xD7,0xB3,0x7F,0xDD,0x7A,0xB7,0x5F,
	0x76,0xB5,0x77,0xFF,0xEE,0xB7,0x6F,0xFB,0x6A,0x5F,0xD5,0xED,0xC6,0xED,0xBB,0xDF,
	0xBE,0x6D,0xDF,0xDE,0xB6,0x57,0xBD,0xF6,0xAA,0xD7,0xF6,0xEE,0xDB,0xDB,0xB7,0xFB,
	0xF6,0xFA,0xEC,0x6D,0x61,0xAF,0xDA,0xAB,0xDD,0xDE,0x7E,0xFB,0xDA,0x6F,0x6F,0xED,
	0xCB,0xD9,0xCB,0xAE,0xDD,0x6B,0x7B,0xF7,0xB7,0xAF,0x7D,0x7B,0x3D,0xDB,0xAB,0x76,
	0x5F,0xAD,0xEB,0xF6,0xF6,0xED,0x6B,0xDF,0xDE,0xBE,0xDA,0x6F,0x7B,0xBB,0xB6,0xD7,
	0xD6,0xDE,0xEE,0xFD,0xBA,0x3D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

STRCODE WORDSET_GetParticle(STRCODE last_char, int particle_id) {
	BOOL has_patchim;

	particle_id &= PARTICLE_ID_MASK;
	GF_ASSERT(particle_id < PARTICLE_ID_NUM);

	if (IS_HANGUL(last_char)) {
		last_char -= STRCODE_HANGUL_MIN;
		if (particle_id == PARTICLE_ID_NI) {
			has_patchim = (patchim_table_ni[last_char / 8] >> (last_char % 8)) & 1;
		} else {
			has_patchim = (patchim_table   [last_char / 8] >> (last_char % 8)) & 1;
		}
	} else if (IS_NUMBER(last_char)) {
		if (particle_id == PARTICLE_ID_NI) {
			has_patchim = (PATCHIM_BITS_NUMBER_NI >> (last_char - STRCODE_NUMBER_MIN)) & 1;
		} else {
			has_patchim = (PATCHIM_BITS_NUMBER    >> (last_char - STRCODE_NUMBER_MIN)) & 1;
		}
	} else {
		has_patchim = FALSE;
	}

	return particle_table[has_patchim][particle_id];
}

#endif

// ----------------------------------------------------------------------------
