//=============================================================================
/**
 * @file	dwc_rap.c
 * @bfief	DWCbp[BI[o[CW[ɒu
 * @author	kazuki yoshihara
 * @date	06/02/23
 */
//=============================================================================

#include "common.h"
#include "communication/comm_def.h"
#include "communication/comm_state.h"
#include "wifi/dwc_rap.h"
#include "wifi/vchat.h"
#include "system/pm_debug_wifi.h"
#include <vct.h>


// bԒʐM͂Ȃƃ^CAEgƔf邩
#define MYDWC_TIMEOUTSEC 10


// t[MȂƁAKEEP_ALIVEg[N𑗂邩B
#define KEEPALIVE_TOKEN_TIME 120

// {CX`bg𗘗pꍇ͒`B
#define MYDWC_USEVCHA

#ifdef MYDWC_USEVCHA
// ڑĎIɃ{CX`bgX^[gꍇɒ`B
#define VCHAT_AUTOSTQART
#endif

//#define YOSHIHARA_VCHAT_ONOFFTEST


// q[v̈̍őgpʂĎꍇ`
#define CHEAK_HEAPSPACE

// fobOo͂ʂɓfoꍇ`
//#define DEBUGPRINT_ON

#ifdef DEBUGPRINT_ON
#define MYDWC_DEBUGPRINT(...) \
    (void) ((OS_TPrintf(__VA_ARGS__)))
#else
#define MYDWC_DEBUGPRINT(...)           ((void) 0)
#endif


// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/09/07
// ڑ version t@C PG5_WIFIRELEASE = yes/no Ő؂ւ悤
// ----------------------------------------------------------------------------

// thXg̃TCY
#define FRIENDLIST_MAXSIZE 32

// Pt[ɉl̃f[^XV邩B
#define FRIENDINFO_UPDATA_PERFRAME 4

// WiFiŎgHeap̃TCY(128KoCgAj+7000
#define MYDWC_HEAPSIZE (0x2B000)

#define MYDWC_HEAPID HEAPID_WIFIMENU

// ̕ӂ̓eXgpBɊ蓖ĂꂽAw肷B
#define GAME_NAME        "pokemondpds"  // gpQ[
#define GAME_SECRET_KEY  "1vTlwb"  // gpV[NbgL[
#define GAME_PRODUCTID   10727         // gpv_NgID

#define SIZE_RECV_BUFFER (4 * 1024)
#define SIZE_SEND_BUFFER 256

typedef struct
{
	u8 recvBuffer[ SIZE_RECV_BUFFER ];
	u8 sendBuffer[ SIZE_SEND_BUFFER ];
	DWCFriendData *keyList;  // DWC`̗FBXg	
	DWCFriendsMatchControl stDwcCnt;    // DWC\	
    DWCUserData *myUserData;		// DWC̃[Uf[^ĩf[^j
	DWCInetControl stConnCtrl;
    SAVEDATA* pSaveData;   // 2006.04.07 k.ohno  Z[uf[^ێ
	
	void *heapPtr;
	NNSFndHeapHandle headHandle;

	MYDWCReceiverFunc serverCallback;
	MYDWCReceiverFunc clientCallback;
	
	void (*fetalErrorCallback)(int);
	
	u8 friend_status[FRIENDLIST_MAXSIZE];
	void *friendinfo;	
	int infosize;	
	u32 friendupdate_index;	
	
	int state;
	int matching_type;
	
	int sendbufflag;
	
	int op_aid;			// aid
	
	int heapID;
	
	int isvchat;
	int friendindex;
	BOOL newFriendConnect;  // ڑĂTRUE 2006.05.24 k.ohno
    BOOL bDelay;     // xeXg
    BOOL bVChat;     // VCHATONOFFeXg
	
	int vchatcodec;
	
	int timeoutflag;
	
	int sendintervaltime;		// Of[^𑗐MẴt[B
	
	int myvchaton;				// ̃{CX`bgIIt
	int opvchaton;				// ̃{CX`bgIIt
	
	u8 myseqno;				// MpPbg̃V[PXNo
	u8 opseqno;				// 肪ŌɑĂpPbg̃V[PXNo
    u8 bHeapError;  // HEAPmێs̏ꍇ
	
	u16 firstflag;
	
	// eXgp
	int s_param;
} MYDWC_WORK;

// {CX`bg̃g[NƍȂ悤ɂ邽߁A
// {CX`bgƈႤRQoCg̐pPbg̐擪ɂB
#define MYDWC_PACKETYPE_MASK 0x000000ff
#define MYDWC_PACKET_VCHAT_MASK 0x00000100
#define MYDWC_PACKET_VCHAT_SHIFT 8
#define MYDWC_PACKET_SEQNO_POS 2

#define MYDWC_GAME_PACKET 0x0001

// ^CAEgh߁A莞ԑMȂꍇA
// ̃f[^𑗂B̂Ƃ̐
#define MYDWC_KEEPALIVE_PACKET 0x0002

enum{
	MDSTATE_INIT,	
	MDSTATE_CONNECTING,
	MDSTATE_CONNECTED,
	MDSTATE_TRYLOGIN,
	MDSTATE_LOGIN,
	
	MDSTATE_MATCHING,
	MDSTATE_CANCEL,	
	MDSTATE_MATCHED,	
	MDSTATE_CANCELFINISH,	
	
	MDSTATE_FAIL,			// 2006.7.4 yoshiharaǉ
	MDSTATE_FAILFINISH,	
	
	MDSTATE_ERROR,
	MDSTATE_ERROR_FM,
	MDSTATE_ERROR_DISCONNECT,
	MDSTATE_ERROR_FETAL,
	
	MDSTATE_DISCONNECTTING,	
	MDSTATE_DISCONNECT,	
	
	MDSTATE_TIMEOUT,
	
	MDSTATE_LAST
};

enum {
	MDTYPE_RANDOM,
	MDTYPE_PARENT,
	MDTYPE_CHILD
};
	

void *_dWork_temp = NULL;
static MYDWC_WORK *_dWork = NULL;


static void LoginCallback(DWCError error, int profileID, void *param);
static void UpdateServersCallback(DWCError error, BOOL isChanged, void* param);
static void FriendStatusCallback(int index, u8 status, const char* statusString, void* param);
static void DeleteFriendListCallback(int deletedIndex, int srcIndex, void* param);
static void BuddyFriendCallback(int index, void* param);

static void ConnectToAnybodyCallback(DWCError error, BOOL cancel, void* param);
static void SendDoneCallback( int size, u8 aid );
static void UserRecvCallback( u8 aid, u8* buffer, int size );
static void ConnectionClosedCallback(DWCError error, BOOL isLocal, BOOL isServer, u8  aid, int index, void* param);
//static int handleError();
static int EvaluateAnybodyCallback(int index, void* param);

static void recvTimeoutCallback(u8 aid);

static void mydwc_updateFriendInfo( );

#ifdef _WIFI_DEBUG_TUUSHIN

#define _USER_PARAM_MAGIC (55)

static void _NNSFndHeapVisitor(void* memBlock, NNSFndHeapHandle heap, u32 userParam)
{
    if(userParam == _USER_PARAM_MAGIC){
        GF_ASSERT(NNS_FndCheckExpHeap(heap, NNS_FND_HEAP_ERROR_PRINT));
        GF_ASSERT(NNS_FndCheckForMBlockExpHeap(memBlock, heap, NNS_FND_HEAP_ERROR_PRINT));
    }
}

#endif


//==============================================================================
/**
 * C^[lbg֐ڑJn
 * @param   userdata ̃OCf[^ւ̃|C^
 * @param   list thXg̐擪|C^
 * @retval  MYDWC_STARTCONNECT_OK c OK
 * @retval  MYDWC_STARTCONNECT_FIRST c ߂ĐڑꍇBibZ[W\̕KvL
 * @retval  MYDWC_STARTCONNECT_DIFFERENTDS c قȂcrŐڑ悤ĂꍇBivxj
 */
//==============================================================================
int mydwc_startConnect(SAVEDATA* pSaveData, int heapID)
{
    // q[v̈悩烏[N̈mہB
	GF_ASSERT( _dWork_temp == NULL );
#ifdef _WIFI_DEBUG_TUUSHIN
#ifdef DEBUGPRINT_ON
	DWC_SetReportLevel(DWC_REPORTFLAG_ALL);
#endif
#endif
    
    OS_TPrintf("dwcrasp   %d \n",sizeof(MYDWC_WORK) + 32);
    
	_dWork_temp = sys_AllocMemory(heapID, sizeof(MYDWC_WORK) + 32);
	_dWork = (MYDWC_WORK *)( ((u32)_dWork_temp + 31) / 32 * 32 );
    // 2006.04.07 k.ohno Z[uf[^|C^ێ
    _dWork->pSaveData = pSaveData;
	_dWork->serverCallback = NULL;
	_dWork->clientCallback = NULL;	
	_dWork->fetalErrorCallback = NULL;
	_dWork->state = MDSTATE_INIT;
	_dWork->heapID = heapID;
	_dWork->heapPtr = sys_AllocMemory(heapID, MYDWC_HEAPSIZE + 32);
	_dWork->headHandle = NNS_FndCreateExpHeap( (void *)( ((u32)_dWork->heapPtr + 31) / 32 * 32 ), MYDWC_HEAPSIZE);
	_dWork->vchatcodec = VCHAT_NONE;
	_dWork->friendindex = -1;
	_dWork->friendupdate_index = 0;
    _dWork->op_aid = -1;
    _dWork->newFriendConnect = -1;
    _dWork->bDelay = FALSE;
    _dWork->bVChat = TRUE;
    _dWork->bHeapError = FALSE;
    
    // 2006.7.22 yoshihara ŁASeqnoZbg
    _dWork->myseqno = 0;
    _dWork->opseqno = 0;
    _dWork->myvchaton = 1;
    _dWork->opvchaton = 1;
    
    // 2006.04.07 k.ohno ύX Z[uf[^瓾
    if(pSaveData!=NULL){
        _dWork->myUserData = WifiList_GetMyUserInfo(SaveData_GetWifiListData(_dWork->pSaveData));
        _dWork->keyList = (DWCFriendData*)WifiList_GetDwcDataPtr(SaveData_GetWifiListData(_dWork->pSaveData),0);
    }

#ifdef PM_DEBUG
    DWC_ReportUserData(_dWork->myUserData);
#endif

#ifdef DEBUG_ONLY_FOR_ohno
   if( !DWC_CheckUserData( _dWork->myUserData ) ){
       GF_ASSERT(0);  //CmF̂ߓĂk.ohno
   }
#endif

	_dWork->friendinfo = NULL;
	{
		int i;
		for( i = 0; i < FRIENDLIST_MAXSIZE; i++ )
		{
			_dWork->friend_status[i] = DWC_STATUS_OFFLINE;
		}
	}
	

	// [Uf[^̏Ԃ`FbNB
	mydwc_showFriendInfo();	
	

	if( !DWC_CheckHasProfile( _dWork->myUserData ) ) 
	{
		// ܂̃f[^ňxveɌqłȂB
		return MYDWC_STARTCONNECT_FIRST;
	}
	
	if( !DWC_CheckValidConsole( _dWork->myUserData ) )
	{
		// {̏񂪈ႤႤcrŐڑ悤ƂĂB
		return 	MYDWC_STARTCONNECT_DIFFERENTDS;
	}
	


	return MYDWC_STARTCONNECT_OK;
}

//==============================================================================
/**
 * dwc_rap.cmۂ̈JB
 * @param   none
 * @retval  none
 */
//==============================================================================
void mydwc_free()
{
    if(_dWork){

        NNS_FndDestroyExpHeap( _dWork->headHandle );
        sys_FreeMemory( _dWork->heapID, _dWork->heapPtr  );
        sys_FreeMemory( _dWork->heapID, _dWork_temp  );
        _dWork_temp = NULL;
        _dWork = NULL;
        OS_TPrintf("dwcrapI\n");
    }
	DWC_ClearError();
}

//==============================================================================
/**
 * C^[lbgڑɖt[Ăяo֐
 * @param   userdata ̃OCf[^ւ̃|C^
 * @param   list thXg̐擪|C^
 * @retval  cڑBOcڑBcG[iG[R[hԂj
 */
//==============================================================================
int mydwc_connect()
{

    switch( _dWork->state )
	{
		case MDSTATE_INIT:
		// 
		{
		    // mۊ֐ݒ
		    DWC_SetMemFunc( mydwc_AllocFunc, mydwc_FreeFunc );
		    
		    // lbgڑ
            DWC_InitInetEx(&_dWork->stConnCtrl,COMM_DMA_NO,COMM_POWERMODE,COMM_SSL_PRIORITY);

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/09/07
// version t@C PG5_WIFIRELEASE = yes 錾ĂA
// Wi-Fi̐ڑeXgT[opubNT[oɐ؂ւ

#ifdef PG5_WIFIRELEASE
	        OS_TPrintf("Connecting to Release Server...\n");
	        DWC_SetAuthServer(DWC_CONNECTINET_AUTH_RELEASE);
#else
	        OS_TPrintf("Connecting to Test Server...\n");
	        DWC_SetAuthServer(DWC_CONNECTINET_AUTH_TEST);
#endif

// ----------------------------------------------------------------------------
			
			// 񓯊Ƀlbgɐڑ
			DWC_ConnectInetAsync();
			
			_dWork->state = MDSTATE_CONNECTING;
			_dWork->isvchat = 0;
		}
		
		case MDSTATE_CONNECTING:
		{
			// 肵󋵂ɂȂ܂ő҂B
			if( DWC_CheckInet() )
			{
				if( DWC_GetInetStatus() == DWC_CONNECTINET_STATE_CONNECTED )
				{
					_dWork->state = MDSTATE_CONNECTED;
				}
				else
				{
					_dWork->state = MDSTATE_ERROR;
				}
			}
			else
			{
				// ڑ
		        DWC_ProcessInet();
  
				break;	
			}
		}
		
		case MDSTATE_CONNECTED:
			// G[ĂȂ
			{
				int ret = mydwc_HandleError();
				if( ret < 0 ) return ret;
			}
			// OC
			// Ƃ肠AFBXg͏ԂɂĂB   k.ohno 4.16C
//			MI_CpuClear32( &(_dWork->keyList[0]), sizeof(_dWork->keyList) );

			// thCu
		    DWC_InitFriendsMatch(&(_dWork->stDwcCnt), (_dWork->myUserData), 
		    			 GAME_PRODUCTID, GAME_NAME,
                         GAME_SECRET_KEY, 0, 0,
                         _dWork->keyList, FRIENDLIST_MAXSIZE);

            // Ƃ肠AIPL̃[UgăOC
		    {
		    	// ̃[UkB
				OSOwnerInfo info;
				OS_GetOwnerInfo( &info );
			    DWC_LoginAsync( &(info.nickName[0]), NULL, LoginCallback, NULL);       
		    }
		    _dWork->state = MDSTATE_TRYLOGIN;
		
		case MDSTATE_TRYLOGIN:
			// OC܂ő҂B
			DWC_ProcessFriendsMatch();
			break;
			
		case MDSTATE_LOGIN:
            DWC_ProcessFriendsMatch();   // 2006.04.07 k.ohno OC̏Ԃ
			return 1;
	}
	return mydwc_HandleError();	
}

//==============================================================================
/**
 * MƂ̃R[obNݒ肷֐
 * @param client c NCAgƂẴR[obN֐
 * @param server c T[oƂẴR[obN֐
 * @retval  none
 */
//==============================================================================
void mydwc_setReceiver( MYDWCReceiverFunc server, MYDWCReceiverFunc client )
{
	_dWork->serverCallback = server;
	_dWork->clientCallback = client;	
}

//==============================================================================
/**
 * _ΐs֐B_}b`͐\t[ԂĂȂƂB
 * @retval  cBOcsB
 */
//==============================================================================
static char randommatch_query[] = "gn = 'pe'";
int mydwc_startmatch( )
{
	if( _dWork->state != MDSTATE_LOGIN ) return 0;

    (void)DWC_AddMatchKeyString(0,"gn","pe");
                              
    _dWork->state = MDSTATE_MATCHING;
    DWC_ConnectToAnybodyAsync
    (
    	2,
        randommatch_query,
        ConnectToAnybodyCallback,
        NULL,
        EvaluateAnybodyCallback,
        NULL
    );
	_dWork->matching_type = MDTYPE_RANDOM;
    // MR[obN̐ݒ	
    DWC_SetUserSendCallback( SendDoneCallback ); 

    // MR[obN̐ݒ	
    DWC_SetUserRecvCallback( UserRecvCallback ); 
    
    // RlNVN[YR[obNݒ
    DWC_SetConnectionClosedCallback(ConnectionClosedCallback, NULL);
    
    // ^CAEgR[obN̐ݒ
    DWC_SetUserRecvTimeoutCallback( recvTimeoutCallback );
    
    _dWork->sendbufflag = 0;
    
	// eXgp
	_dWork->s_param = 0;    
    
    return 1;    
}

// 2006.7.4 yoshihara ǉ
static void finishcancel()
{
    if( _dWork->state == MDSTATE_FAIL ){
		_dWork->state = MDSTATE_FAILFINISH;
    }
    else
    {
		_dWork->state = MDSTATE_CANCELFINISH;
    }	
}

//==============================================================================
/**
 * _ΐ}b`Oɖt[Ă΂֐B
 * @retval  
 	STEPMATCH_CONTINUEc}b`O
 	STEPMATCH_SUCCESSc
 	STEPMATCH_CANCELcLZ
 	STEPMATCH_FAIL  c肪e߂߁Aڑ𒆒f
 	cG[
 */
//==============================================================================
int mydwc_stepmatch( int isCancel )
{
	switch ( _dWork->state )
	{
		case MDSTATE_MATCHING:
			// ݒT
			if( isCancel ) 
			{
				_dWork->state = MDSTATE_CANCEL;
			}
			// 2006.7.4 yoshiharaC 
			// q@̏ꍇAȂɂĂe݂T[o[hǂ`FbNB
			if( _dWork->matching_type == MDTYPE_CHILD )
			{
				if( _dWork->friendindex >= 0 ) // if͔Ô
				{
					if( _dWork->friend_status[_dWork->friendindex] != DWC_STATUS_MATCH_SC_SV )
					{
						OS_TPrintf("肪T[o߂Ă܂̂ŁALZ܂B\n");
						// ɐełȂȂĂ܂ĂBLZֈڍ
						_dWork->state = MDSTATE_FAIL;	
					}
				}
			}
			// 2006.7.4 yoshiharaC ܂
			
			break;
			
      case MDSTATE_CANCEL:
      case MDSTATE_FAIL:      
			if( _dWork->state == MDTYPE_RANDOM)
			{
				// _}b`
				// LZ
				if( !DWC_CancelMatching() )
				{
				}
				break;
			} else {
				int ret;
				ret = DWC_CloseAllConnectionsHard();
				if( ret == 1 )
				{
					// q@ȂR[obNŏI
		            // 2006.7.4 yoshihara C
					finishcancel();	
				}
				else if (ret == 0)
				{
					// R[obNAĂĂ͂
				}
				else
				{
		            // 2006.7.4 yoshihara C
					finishcancel();	
//					MYDWC_DEBUGPRINT("Now unable to disconnect.\n");
				}
			}
        break;    //@@OO   06.05.12ǉ
		case MDSTATE_MATCHED:
			// B
			{
				_dWork->firstflag = 1;
#ifdef VCHAT_AUTOSTQART
			// yoshiharaύX@06.6.15
//                if(_dWork->bVChat){
                    mydwc_startvchat();
//                }

                if(_dWork->bVChat)
                {
	                _dWork->myvchaton = 1;
                }
                else{
	                _dWork->myvchaton = 0;
                }

#else
				if( _dWork->vchatcodec != VCHAT_NONE ) mydwc_startvchat();
#endif
				return STEPMATCH_SUCCESS;	
			}
			break;
		case MDSTATE_CANCELFINISH:
			// OC̏Ԃ
			_dWork->state = MDSTATE_LOGIN;
			_dWork->sendbufflag = 0;
            _dWork->newFriendConnect = -1;
            OS_TPrintf("LZ\n");
			return STEPMATCH_CANCEL;
		case MDSTATE_FAILFINISH:
			// OC̏Ԃ
			_dWork->state = MDSTATE_LOGIN;
			_dWork->sendbufflag = 0;
            _dWork->newFriendConnect = -1;
            OS_TPrintf("tBjbV\n");
			return STEPMATCH_FAIL;			
		case MDSTATE_ERROR:
			{
				int ret;
				
				ret = mydwc_HandleError();
				return ret;
			}	
			
		default:
			break;		
//			return handleError();
	}
	return mydwc_step();	
		
//    DWC_ProcessFriendsMatch();  // DWCʐMXV			
//	return handleError();
}



//==============================================================================
/**
 * T[oɃf[^MsƂł邩
 * @retval  1 - @ 0 - siMobt@l܂Ă铙j
 */
//==============================================================================
BOOL mydwc_canSendToServer()
{
	return ( DWC_GetMyAID() == 0 || ( _dWork->sendbufflag == 0 && DWC_IsSendableReliable( 0 ) ) );
}

//==============================================================================
/**
 * NCAgɃf[^MsƂł邩
 * @retval  1 - @ 0 - siMobt@l܂Ă铙j
 */
//==============================================================================
BOOL mydwc_canSendToClient()
{
	return ( _dWork->sendbufflag == 0 && DWC_IsSendableReliable( 1 ) );
}

//==============================================================================
/**
 * T[oɃf[^Ms֐
 * @param   data - Mf[^ւ̃|C^Bsize - Mf[^̃TCY
 * @retval  1 - @ 0 - siMobt@l܂Ă铙j
 */
//==============================================================================
int mydwc_sendToServer(void *data, int size)
{
    if( !(size < SIZE_SEND_BUFFER) ){
        return 0;
    }

    
	MYDWC_DEBUGPRINT("mydwc_sendToServer(data=%d)\n", *((u32*)data));

	if( DWC_GetMyAID() == 0 )
	{
		// e
		// R[obNŏ\lAdataRs[ĂB
//		void *buf = mydwc_AllocFunc( NULL, size, 32 );
//		MI_CpuCopy8	( data, buf, size );
		
		// g̃T[oMR[obNĂяoB
		if( _dWork->serverCallback != NULL ) _dWork->serverCallback(0, data, size);
		
		// R[obNĂяo炷ɊJB
//		mydwc_FreeFunc( NULL, buf, size );
		
		return 1;
	}
	else
	{
		// 肪eBɑ΂ăf[^MB
		if( _dWork->sendbufflag || !DWC_IsSendableReliable( 0 ) ) // Mobt@`FbNB
		{
			// Mobt@ςȂǂőȂB
			return 0;
		}
		
		// Mobt@ɃRs[
		*((u32*)&(_dWork->sendBuffer[0])) = MYDWC_GAME_PACKET | (_dWork->myvchaton << MYDWC_PACKET_VCHAT_SHIFT);
		_dWork->sendBuffer[MYDWC_PACKET_SEQNO_POS] = ++_dWork->myseqno;
		MI_CpuCopy8( data, &(_dWork->sendBuffer[4]), size );
		_dWork->sendbufflag = 1;
		
		// e@ɌđM
		DWC_SendReliable( 0, &(_dWork->sendBuffer[0]), size + 4);
//		OS_TPrintf("-");
		return 1;
	}
}

//==============================================================================
/**
 * e@q@Ƀf[^Ms֐
 * @param   data - Mf[^ւ̃|C^Bsize - Mf[^̃TCY
 * @retval  1 - @ 0 - siMobt@l܂Ă铙j
 */
//==============================================================================
int mydwc_sendToClient(void *data, int size)
{
    if( !(size < SIZE_SEND_BUFFER) ){
        return 0;
    }
	// e@͍̓sȂ͂B
    if( !(DWC_GetMyAID() == 0) ){
        return 0;
    }
	
	MYDWC_DEBUGPRINT("sendToClient(data=%d)\n", *((u32*)data));
	
	{
		// ɑ΂ăf[^MB
		if( _dWork->sendbufflag || !DWC_IsSendableReliable( 1 ) ) // Mobt@`FbNB
		{
            OS_TPrintf("wifi failed %d\n",size);
			// Mobt@ςȂǂőȂB
			return 0;
		}
		
		// Mobt@ɃRs[
		*((u32*)&(_dWork->sendBuffer[0])) = MYDWC_GAME_PACKET | (_dWork->myvchaton << MYDWC_PACKET_VCHAT_SHIFT);
		_dWork->sendBuffer[MYDWC_PACKET_SEQNO_POS] = ++_dWork->myseqno;
		MI_CpuCopy8( data, &(_dWork->sendBuffer[4]), size );
        _dWork->sendbufflag = 1;
		
		// q@ɌđM
        if(!DWC_SendReliable( 1, &(_dWork->sendBuffer[0]), size + 4)){
            OS_TPrintf("wifi failed %d\n",size);
			// Mobt@ςȂǂőȂB
            _dWork->sendbufflag = 0;
            return 0;
        }
//		OS_TPrintf("-");
	}	
	
	{
		// ɑ΂đM
//		// R[obNŏ\lAdataRs[ĂB
//		void *buf = mydwc_AllocFunc( NULL, size, 32 );
//		MI_CpuCopy8	( data, buf, size );
		
		// g̃T[oMR[obNĂяoB
		if( _dWork->clientCallback != NULL ) _dWork->clientCallback(0, data, size);
		
		// R[obNĂяo炷ɊJB
//		mydwc_FreeFunc( NULL, buf, size );
	}  
	
	return 1;
}
/*---------------------------------------------------------------------------*
  OCR[obN֐
 *---------------------------------------------------------------------------*/
static void LoginCallback(DWCError error, int profileID, void *param)
{
    BOOL result;

    // stUserDataXVĂ邩ǂmFB
    if ( DWC_CheckDirtyFlag( (_dWork->myUserData)) )
    {
	    // K̃^C~OŃ`FbNāAdirty flagLɂȂĂA
	    // DWCUserDataDSJ[h̃obNAbvɕۑ悤ɂĂB
	    // 2006.04.07 k.ohno  Z[uGAɓ
	    DWCUserData *userdata = NULL;
	    DWC_ClearDirtyFlag(_dWork->myUserData);
	    SaveData_SaveParts(_dWork->pSaveData, SVBLK_ID_NORMAL);  //Z[u k.ohno 06.06.05
	    
	//          userdata = WifiList_GetMyUserInfo(SaveData_GetWifiListData(_dWork->pSaveData));
	//          MI_CpuCopy32( &_dWork->myUserData, userdata,  sizeof(_dWork->myUserData) );	
	    OS_TPrintf("̃thR[hύX\n");
    }

    if (error == DWC_ERROR_NONE){
        // FؐAvt@CID擾


       
        result = DWC_UpdateServersAsync(NULL, //iߋƂ̌݊̂߁AKNULL)
                                        UpdateServersCallback, _dWork->myUserData,
                                        FriendStatusCallback, param,
                                        DeleteFriendListCallback, param);

        if (result == FALSE){
            // ĂłԁiOCĂȂԁjŌĂ񂾎̂
            // FALSEԂĂ̂ŁAʂTRUE
            OS_TPrintf("DWC_UpdateServersAsync error teminated.\n");
            CommStateSetError(COMM_ERROR_RESET_SAVEPOINT);
            return;
        }

        // GameSpyT[oofBR[obNo^
        DWC_SetBuddyFriendCallback(BuddyFriendCallback, NULL);
        
    }
    else
    {
        // F؎s
		_dWork->state = MDSTATE_ERROR;
    }
}

/*---------------------------------------------------------------------------*
  ^CAEgR[obN֐
 *---------------------------------------------------------------------------*/
static void recvTimeoutCallback(u8 aid)
{
	OS_TPrintf("^CAEg - ");
	// RlNV
	if( _dWork->timeoutflag )
	{
		OS_TPrintf("ڑؒf܂\n");
		DWC_CloseAllConnectionsHard( );
        _dWork->newFriendConnect = -1;
		// ^CAEg
		_dWork->state = MDSTATE_TIMEOUT;	
	}
}

/*---------------------------------------------------------------------------*
  GameSpyT[oAbvf[gR[obN֐
 *---------------------------------------------------------------------------*/
static void UpdateServersCallback(DWCError error, BOOL isChanged, void* param)
{
#pragma unused(param)
    if (error == DWC_ERROR_NONE){
        if (isChanged){
            // FBXgύXĂ
        }
       	_dWork->state = MDSTATE_LOGIN;		// OC  
    }
    else {
        // OCsɂƂH
        _dWork->state = MDSTATE_ERROR;
    }
}


/*---------------------------------------------------------------------------*
  FBԕωʒmR[obN֐
 *---------------------------------------------------------------------------*/
static void FriendStatusCallback(int index, u8 status, const char* statusString, void* param)
{
#pragma unused(param)

    MYDWC_DEBUGPRINT("Friend[%d] changed status -> %d (statusString : %s).\n",
               index, status, statusString);
            
}


/*---------------------------------------------------------------------------*
  FBXg폜R[obN֐
 *---------------------------------------------------------------------------*/
static void DeleteFriendListCallback(int deletedIndex, int srcIndex, void* param)
{
#pragma unused(param)
	// thXg폜ꂽB
	
    MYDWC_DEBUGPRINT("friend[%d] was deleted (equal friend[%d]).\n",
               deletedIndex, srcIndex);

    OS_TPrintf("friend[%d] was deleted (equal friend[%d]).\n",
               deletedIndex, srcIndex);
    // ߂
    MI_CpuCopy8(_dWork->keyList,WifiList_GetDwcDataPtr(SaveData_GetWifiListData(_dWork->pSaveData), 0),FRIENDLIST_MAXSIZE * sizeof(DWCFriendData));
    WifiList_DataMarge(SaveData_GetWifiListData(_dWork->pSaveData),
                       deletedIndex, srcIndex);

}


/*---------------------------------------------------------------------------*
  GameSpyofBR[obN֐
 *---------------------------------------------------------------------------*/
static void BuddyFriendCallback(int index, void* param)
{
#pragma unused(param)

    MYDWC_DEBUGPRINT("I was authorized by friend[%d].\n", index);
}

static void setConnectionBuffer()
{
	_dWork->state = MDSTATE_MATCHED;
    // Mobt@Zbg  // lΐƌ߂
    if( DWC_GetMyAID() == 0 )
    {
        _dWork->op_aid = 1;
    } 
    else
    {
    	_dWork->op_aid = 0;
	}   
    DWC_SetRecvBuffer( _dWork->op_aid, &(_dWork->recvBuffer[0]), SIZE_RECV_BUFFER );	
   	DWC_SetRecvTimeoutTime( _dWork->op_aid, MYDWC_TIMEOUTSEC * 1000 );
	_dWork->timeoutflag = 0;
	_dWork->sendintervaltime = 0;

#ifdef PM_DEBUG  // fobOx
    if(_dWork->bDelay){
        DWC_SetRecvDelay( 1000, _dWork->op_aid );
    }
    else{
        DWC_SetRecvDelay( 0, _dWork->op_aid );
    }
#endif
}

/*---------------------------------------------------------------------------*
  FBwڑR[obN֐
 *---------------------------------------------------------------------------*/
static void ConnectToAnybodyCallback(DWCError error, BOOL cancel, void* param)
{
#pragma unused(param)
    if (error == DWC_ERROR_NONE){
        if (!cancel){
            // mʐlƂ̃RlNVݗ
            MYDWC_DEBUGPRINT("ڑ\n\n");
            setConnectionBuffer();
        }
        else {
            MYDWC_DEBUGPRINT("LZ\n");
            // OCԂɖ߂
            
            // 2006.7.4 yoshihara C
			finishcancel();	
        }
    }
    else {
        MYDWC_DEBUGPRINT("}b`OɃG[܂B %d\n\n", error);
		_dWork->state = MDSTATE_ERROR; 
    }
}

/*---------------------------------------------------------------------------*
  FBw}b`OvC[]R[obN֐
 *---------------------------------------------------------------------------*/
static int  EvaluateAnybodyCallback(int index, void* param)
{
#pragma unused(param, index)
	return 1;
}


/** -------------------------------------------------------------------------
  MR[obN  
  ---------------------------------------------------------------------------*/
static void SendDoneCallback( int size, u8 aid )
{
#pragma unused(size)
	// Mobt@
	_dWork->sendbufflag = 0;
	_dWork->sendintervaltime = 0;
//	MYDWC_DEBUGPRINT( "M\n" );
//	OS_TPrintf( "*" );
}

/** -------------------------------------------------------------------------
  MR[obN  
  ---------------------------------------------------------------------------*/
static void UserRecvCallback( u8 aid, u8* buffer, int size )
{
#pragma unused( aid, buffer, size )

//	OS_TPrintf("[%d,%d,%d,%d]", buffer[0], buffer[1], buffer[2], buffer[3]);

	u32 topcode;
	topcode = (buffer[3] << 24) | (buffer[2] << 16) | (buffer[1] << 8) | buffer[0];

	// xMĂ͂߂ă^CAEgݒ肷B
	_dWork->timeoutflag = 1;

	// ܂A擪̂SoCg݂āAQ[̏񂩂ǂ𔻒f
	if( (topcode & MYDWC_PACKETYPE_MASK) == MYDWC_GAME_PACKET ){
		if( topcode & MYDWC_PACKET_VCHAT_MASK ) 
		{
			// ̃{CX`bg̓I
			_dWork->opvchaton = 1;		
		}
		else
		{
			// ̃{CX`bg̓I
			_dWork->opvchaton = 0;		
		}
		
		// 2006.7.22 yoshiharaǉB̃V[PXNoєтɂȂĂȂmF
        // ʒʐMrł͌ołȂ̂ŃRgɕύX 7.28 k.ohno
//		GF_ASSERT( _dWork->firstflag == 1 || buffer[MYDWC_PACKET_SEQNO_POS] == (u8)( _dWork->opseqno + 1 ) );
        _dWork->firstflag = 0;
		_dWork->opseqno = buffer[MYDWC_PACKET_SEQNO_POS];
		
		
	}
	else {
#ifdef MYDWC_USEVCHA		
		if( myvct_checkData( aid, buffer,size ) ) return;
#endif	
		// ӖȏiRlNVێ邽߂̂̂Ǝvj
		if( topcode & MYDWC_PACKET_VCHAT_MASK ) 
		{
			// ̃{CX`bg̓I
			_dWork->opvchaton = 1;		
		}
		else
		{
			// ̃{CX`bg̓I
			_dWork->opvchaton = 0;		
		}		
		return;
	}
	MYDWC_DEBUGPRINT( "M(%d)\n",*((s32*)buffer) );
	_dWork->s_param = *((s32*)buffer);
	
	// ACgmɂ邽߂ɁARs[
	{
		u16 *temp = (u16*)mydwc_AllocFunc( NULL, size - 4, 4);
        if(temp==NULL){
            return;
        }
        
		MI_CpuCopy8(buffer + 4, (void*)temp, size - 4);
		
		if( DWC_GetMyAID() == 0 )
		{	
			// ȅꍇcNCgT[oɑ΂đĂ̂ƔfB
			// T[opM֐ĂяoB
			if( _dWork->serverCallback != NULL ) _dWork->serverCallback(aid, temp, size-4);
		} else {
			// T[oNCAgɑ΂đĂ̂ƔfB	
			if( _dWork->clientCallback != NULL ) _dWork->clientCallback(aid, temp, size-4);
		}
		
		mydwc_FreeFunc(NULL, temp, size - 4);
	}
}

/*---------------------------------------------------------------------------*
  RlNVN[YR[obN֐
 *---------------------------------------------------------------------------*/
static void ConnectionClosedCallback(DWCError error,
                                     BOOL isLocal,
                                     BOOL isServer,
                                     u8  aid,
                                     int index,
                                     void* param)
{
#pragma unused(param, index)
    if (error == DWC_ERROR_NONE){

        if (!isLocal && isServer){
//            // T[oNCAg^}b`OŁANCAg̎ɁA
//            // T[oRlNVN[YB
        }
        
        if (DWC_GetNumConnectionHost() == 1){
            // SẴRlNVN[Yꂽꍇ         
          
            // LZȂ΁ALZB
			if(	_dWork->state == MDSTATE_CANCEL )
			{
				_dWork->state = MDSTATE_CANCELFINISH;
			}
			else {
				_dWork->state = MDSTATE_DISCONNECT;
			}
			
			if( _dWork->isvchat )
			{
				// ܂{CX`bgCuĂȂꍇB
				myvct_free();
			}
			
        }
        
        if (isLocal){
            MYDWC_DEBUGPRINT("Closed connection to aid %d (friendListIndex = %d) Rest %d.\n",
                       aid, index, DWC_GetNumConnectionHost());
        }
        else {
            MYDWC_DEBUGPRINT("Connection to aid %d (friendListIndex = %d) was closed. Rest %d.\n",
                       aid, index, DWC_GetNumConnectionHost());
        }
    }
    else {
        OS_TPrintf("Failed to close connections. %d\n\n", error);
    }
}

#ifdef CHEAK_HEAPSPACE
static int _heapspace = MYDWC_HEAPSIZE;
static int _heapmaxspace = MYDWC_HEAPSIZE;
#endif

/*---------------------------------------------------------------------------*
  mۊ֐
 *---------------------------------------------------------------------------*/
void*
mydwc_AllocFunc( DWCAllocType name, u32   size, int align )
{
#pragma unused( name )
    void * ptr;
    OSIntrMode old;

#ifdef _WIFI_DEBUG_TUUSHIN
#ifdef DEBUGPRINT_ON
    OS_TPrintf("HEAP擾(%d, %d) from %p %x\n", size, align, _dWork->headHandle, _dWork->headHandle->signature);
#endif
#endif
    
    old = OS_DisableInterrupts();
    ptr = NNS_FndAllocFromExpHeapEx( _dWork->headHandle, size, align );

    if(ptr == NULL){
#ifdef _WIFI_DEBUG_TUUSHIN
//        GF_ASSERT_MSG(ptr,"HEAP faqiled");
#endif
        // q[vꍇ̏C
        CommStateSetError(COMM_ERROR_RESET_SAVEPOINT);  // G[ɂ
        OS_RestoreInterrupts( old );
        return NULL;//sys_AllocMemory(HEAPID_COMMUNICATION,size);  // jZm܂ARM9ǂ܂𔭐Ȃ
    }

    
#ifdef CHEAK_HEAPSPACE
#ifdef _WIFI_DEBUG_TUUSHIN
    {
		int hspace = NNS_FndGetTotalFreeSizeForExpHeap( _dWork->headHandle );
		if( hspace < _heapspace )
		{
			OS_TPrintf("q[vcF%d\n", hspace);
			_heapspace = hspace;
		}
	}
	{
		int maxspace = NNS_FndGetAllocatableSizeForExpHeap( _dWork->headHandle );
		if( maxspace < _heapmaxspace )
		{
			OS_TPrintf("q[vcF%d\n", maxspace);
			_heapmaxspace = maxspace;
		}		
	}
#endif	
#endif	
    OS_RestoreInterrupts( old );
#ifdef DEBUGPRINT_ON
//	OS_TPrintf("dwc_rap:q[v擾isize = %djFc%d\n", size, NNS_FndGetTotalFreeSizeForExpHeap( _dWork->headHandle ) );
#endif
    return ptr;
}

/*---------------------------------------------------------------------------*
  J֐
 *---------------------------------------------------------------------------*/
void
mydwc_FreeFunc( DWCAllocType name, void* ptr,  u32 size  )
{
#pragma unused( name, size )
    OSIntrMode old;

    if ( !ptr ) return;
//    OS_TPrintf("HEAP(%p) to %p\n", ptr, _dWork->headHandle);    
    old = OS_DisableInterrupts();
    NNS_FndFreeToExpHeap( _dWork->headHandle, ptr );
    OS_RestoreInterrupts( old );
}

//==============================================================================
/**
 * G[NĂȂ`FbNAG[ɉĒʐM鏈B
 *  EAEog^[ŌĂяo߂ɑ k.ohno 06.06.08
 * @retval  OcG[ȂBcG[
 * iG[R[hԂBG[R[hȌꍇERRORCODE_0j
 */
//==============================================================================
int mydwc_HandleError(void)
{
	int errorCode;
	DWCErrorType myErrorType;
	int ret;
	

#ifdef _WIFI_DEBUG_TUUSHIN
    if(_dWork){
        OSIntrMode old;
        // q[veXg
        old = OS_DisableInterrupts();
        NNS_FndVisitAllocatedForExpHeap(_dWork->headHandle, _NNSFndHeapVisitor, _USER_PARAM_MAGIC);
        OS_RestoreInterrupts( old );
    }
#endif

    ret = DWC_GetLastErrorEx( &errorCode, &myErrorType );

	if( ret != 0 )
	{
		// 炩̃G[B
		OS_TPrintf("error occured!(%d, %d, %d)\n", ret, errorCode, myErrorType); 	
		
		switch(myErrorType)
		{
			case DWC_ETYPE_LIGHT:
				// Q[ŗL̕\݂̂ŁAG[R[h\͕KvȂB
				// DWC_ClearError()Ăяo΁AA\B
				DWC_ClearError();
                if(ret >= DWC_ERROR_FRIENDS_SHORTAGE) return ret; // yx̃G[͂̂܂ܕԂ k.ohno
				if( errorCode == 0 ) return ERRORCODE_0;
				break;
			case DWC_ETYPE_SHUTDOWN_FM:
				// DWC_ShutdownFriendsMatch()ĂяoāAFriendsMatchIKvB
				// G[R[h̕\KvB
				// ̏ꍇAƂ肠DWC_ETYPE_DISCONNECTƓĂB
			case DWC_ETYPE_DISCONNECT:
				//FriendsMatchȂDWC_ShutdownFriendsMatch()ĂяoA
				//XDWC_CleanupInet()ŒʐM̐ؒfsKvB
				//G[R[h̕\KvB 
				if(_dWork){
					switch( _dWork->state )
					{			
						case MDSTATE_TRYLOGIN:
						case MDSTATE_LOGIN:		
						case MDSTATE_MATCHING:
						case MDSTATE_CANCEL:
						case MDSTATE_MATCHED:
						case MDSTATE_CANCELFINISH:
						case MDSTATE_ERROR:
						case MDSTATE_TIMEOUT:
						case MDSTATE_DISCONNECTTING:
						case MDSTATE_DISCONNECT:
							DWC_ShutdownFriendsMatch(  );
						case MDSTATE_INIT:	
						case MDSTATE_CONNECTING:
						case MDSTATE_CONNECTED:
							// ܂̎_ł́Ath}b`Cu͌Ă΂ĂȂB
							DWC_CleanupInet( );
					}
					
					DWC_ClearError();
				}
				if(_dWork){
                    _dWork->state = MDSTATE_ERROR_DISCONNECT;
                }
				if( errorCode == 0 ) return ERRORCODE_0;
				return errorCode;
				
			case DWC_ETYPE_FATAL:
				// FatalErrorȂ̂ŁAdOFF𑣂KvB
				if(_dWork){
                    _dWork->state = MDSTATE_ERROR_FETAL;
				// ̃R[obN珈ĂȂ͂B
                    if( _dWork->fetalErrorCallback != NULL ){
                        _dWork->fetalErrorCallback( -errorCode );
                    }
                }
				
				if( errorCode == 0 ) return ERRORCODE_0;
				return errorCode;
				break;
		}
	}

    if(_dWork->bHeapError){
        return ERRORCODE_HEAP;        
    }
	return 0;
}

static int _buffer;

static void _sendData(int param)
{
	_buffer = param;
	if( !DWC_IsSendableReliable( _dWork->op_aid ) ) // Mobt@`FbNB
	{
		DWC_SendReliable( _dWork->op_aid, &(_buffer), 4 );
	}	
}

#ifdef YOSHIHARA_VCHAT_ONOFFTEST		

static u16 debug_trg;
static u16 debug_cont = 0;

static void vchat_onoff()
{
	{
	    u16 ReadData = PAD_Read();
	    debug_trg  = (u16)(ReadData & (ReadData ^ debug_cont));            // gK 
	    debug_cont = ReadData;      	
	}	
	
	if( debug_trg & PAD_BUTTON_R )
	{
		if( _dWork->myvchaton )
		{
			mydwc_VChatPause();
		}
		else
		{
			mydwc_VChatRestart();
		}
	}
}

#endif

static void sendKeepAlivePacket()
{
	
    OS_TPrintf("keep   %d %d\n",_dWork->sendbufflag,DWC_IsSendableReliable( 1-DWC_GetMyAID() ) );
    
	if( (_dWork->sendbufflag == 0) && DWC_IsSendableReliable( 1-DWC_GetMyAID() ) ) // Mobt@`FbNB
	{
		_dWork->sendbufflag = 1;
		*((u32*)&(_dWork->sendBuffer[0])) = MYDWC_KEEPALIVE_PACKET | (_dWork->myvchaton << MYDWC_PACKET_VCHAT_SHIFT);;
		DWC_SendReliable( _dWork->op_aid, &(_dWork->sendBuffer[0]), 4);
		_dWork->sendintervaltime = 0;
		OS_TPrintf("SEND KEEP ALIVE PACKET\n");	
	}	
}

// ʐMmAt[ĂяoĂB
//==============================================================================
/**
 * DWCʐMXVs
 * @param none
 * @retval 0c, cG[ 1c^CAEg 2c肩ؒfꂽ
 */
//==============================================================================
int mydwc_step()
{
	DWC_ProcessFriendsMatch();  // DWCʐMXV
	mydwc_updateFriendInfo( );	
	
#ifdef MYDWC_USEVCHA
	if( _dWork->isvchat ) 
	{
#ifdef YOSHIHARA_VCHAT_ONOFFTEST		
		vchat_onoff();
#endif		
		if( _dWork->myvchaton == 1 && _dWork->opvchaton == 1 )
		{
			myvct_onVchat();
		}
		else
		{
			myvct_offVchat();
		}
				
		myvct_main();
	}
#endif
	if( _dWork->state == MDSTATE_TIMEOUT ) return 1;
	if( _dWork->state == MDSTATE_DISCONNECT ) return 2;
	
	if( _dWork->state == MDSTATE_MATCHED ) 
	{
		if( _dWork->sendintervaltime++ >= KEEPALIVE_TOKEN_TIME && _dWork->sendbufflag == 0) 
		{
			sendKeepAlivePacket();
		}
	}
	
	return mydwc_HandleError();
}

//==============================================================================
/**
 * aidԂ܂Bڑ܂ł-1Ԃ܂B
 * @retval  aidBڑO-1
 */
//==============================================================================
int mydwc_getaid()
{
    if(_dWork){
        if( _dWork->state == MDSTATE_MATCHED || _dWork->state == MDSTATE_DISCONNECTTING )
        {
            return DWC_GetMyAID();
        }
    }
	return -1;
}

// {CX`bg̐ؒfR[obNB
static void vct_endcallback(){
	_dWork->isvchat = 0;
}

//==============================================================================
/**
 * ʐMmA{CX`bgJn܂B
 * @param none
 * @retval none
 */
//==============================================================================
void mydwc_startvchat()
{
	switch( _dWork->vchatcodec ){
		case VCHAT_G711_ULAW:
			myvct_init( _dWork->heapID, VCT_CODEC_G711_ULAW );
		break;
		case VCHAT_2BIT_ADPCM:
			myvct_init( _dWork->heapID, VCT_CODEC_2BIT_ADPCM );
		break;
		case VCHAT_3BIT_ADPCM:
			myvct_init( _dWork->heapID, VCT_CODEC_3BIT_ADPCM );
		break;
		case VCHAT_4BIT_ADPCM:		
			myvct_init( _dWork->heapID, VCT_CODEC_4BIT_ADPCM );
		break;
		default:
			myvct_init( _dWork->heapID, VCT_CODEC_4BIT_ADPCM );   //VCT_CODEC_8BIT_RAW
		break;
	}
	myvct_setDisconnectCallback( vct_endcallback );
	_dWork->isvchat = 1;
}

//==============================================================================
/**
 * {CX`bg̃R[fbNw肵܂B
 * RlNVmOɃR[fbNw肵ĂƁA
 * RlNVmɎIɃ{CX`bgJn܂B
 * @param R[fbÑ^Cv
 * @retval none
 */
//==============================================================================
void mydwc_setVchat(int codec){
	_dWork->vchatcodec = codec;

	if( _dWork->isvchat ){
		switch( _dWork->vchatcodec ){
			case VCHAT_G711_ULAW:
				myvct_setCodec( VCT_CODEC_G711_ULAW );
			break;
			case VCHAT_2BIT_ADPCM:
				myvct_setCodec( VCT_CODEC_2BIT_ADPCM );
			break;
			case VCHAT_3BIT_ADPCM:
				myvct_setCodec( VCT_CODEC_3BIT_ADPCM );
			break;
			case VCHAT_4BIT_ADPCM:		
				myvct_setCodec( VCT_CODEC_4BIT_ADPCM );
			break;
			case VCHAT_8BIT_RAW:
				myvct_setCodec( VCT_CODEC_8BIT_RAW );
			break;
		}
	}
}

//==============================================================================
/**
 * DWCG[ԍɑΉ郁bZ[WIDԂ܂B
 * @param code - G[R[hi̒lĂ
 * @retval bZ[W^Cv
 */
//==============================================================================
int mydwc_errorType(int code)
{
    // ----------------------------------------------------------------------------
    // localize_spec_mark(LANG_ALL) imatake 2007/02/15
    // G[R[h̃JeSCY Message List Ver. 1.20 ɕύX

	int code100 = code / 100;
	int code1000 = code / 1000;

	if( code == 20100 ) return 0;
	if( code >= 20102 && code <= 20107 ) return 0;
	if( code == 20109 ) return 0;
	if( code >= 20111 && code <= 20999 ) return 0;
	if( code >= 52004 && code <= 52099 ) return 0;
	if( code >= 52104 && code <= 52199 ) return 0;
	if( code >= 52204 && code <= 52299 ) return 0;
	if( code100 == 523 ) return 0;
	if( code100 == 530 ) return 0;
	if( code100 == 531 ) return 0;
	if( code100 == 532 ) return 0;

    if( code == 20101 ) return 1;
	if( code1000 == 23 ) return 1;

	if( code == 20108 ) return 2;

	if( code == 20110 ) return 3;

	if( code100 == 512 ) return 4;

	if( code100 == 500 ) return 5;

	if( code >= 51000 && code <= 51102 ) return 6;
	if( code >= 51104 && code <= 51199 ) return 6;
	if( code100 == 513 ) return 6;

	if( code == 51103 ) return 7;

	if( code >= 52000 && code <= 52003 ) return 8;
	if( code >= 52100 && code <= 52103 ) return 8;
	if( code >= 52200 && code <= 52203 ) return 8;

	if( code == 80430 ) return 9;

	if( code1000 == 24 ) return 10;
	if( code1000 == 25 ) return 10;
	if( code1000 == 31 ) return 10;
	if( code1000 == 54 ) return 10;
	if( code >= 60000 && code <= 99999 ) return 10;

    if( code < 10000 ) return 11; // G[R[hPOOOȌꍇ́AG[R[h̕\̕KvȂB

    return -1;

    // ----------------------------------------------------------------------------
}

//==============================================================================
/**
 * ʐMؒf܂B
 * @param sync c 0 = ؒfɂB1 = 肪ؒf̂҂B
 * @retval @@@ 1 = ڑB0 = ؒfB
 */
//==============================================================================
int mydwc_disconnect( int sync )
{
	if( sync == 0 ){
        OS_TPrintf(" state %d \n",_dWork->state);
		switch( _dWork->state )
		{
            case MDSTATE_MATCHING:   // k.ohno 06.07.08  ǉ
            case MDSTATE_MATCHED:
			{
				if( _dWork->isvchat )
				{
					// {CX`bgғ
					// ~߂
                    OS_TPrintf("{CX`bgғ ~߂\n");
					myvct_endConnection();
					_dWork->state = MDSTATE_DISCONNECTTING;
				}
                else{// ғĖȂI
					DWC_CloseAllConnectionsHard( );
					_dWork->state = MDSTATE_DISCONNECT;
                    return 1;
                }
				break;
			}	
	
			case MDSTATE_DISCONNECTTING:
			{
				// {CX`bg̏I҂Ă
				if( _dWork->isvchat == 0 )
				{
					// {CX`bg̐ؒfB
					// ʐM̂؂B
                    OS_TPrintf("{CX`bg̐ؒfB\n");
					DWC_CloseAllConnectionsHard( );
					_dWork->state = MDSTATE_DISCONNECT;
					return 1;
				}
//                else{
//					myvct_endConnection();  //ؒf k.ohno  ł͌Ă΂Ȃ悤ɏC
//                }
				break;
			}	
            case MDSTATE_LOGIN:     //e@ؒfɓ킹邽߂ɒǉ k.ohno 06.07.04
            case MDSTATE_ERROR_DISCONNECT:
			case MDSTATE_DISCONNECT:
			case MDSTATE_TIMEOUT:
			{
				return 1;
				break;
			}
		}
	} else {
		switch( _dWork->state )
		{
            case MDSTATE_LOGIN:     //e@ؒfɓ킹邽߂ɒǉ k.ohno 06.07.04
			case MDSTATE_DISCONNECT:
			case MDSTATE_TIMEOUT:
			{
				return 1;
				break;
			}			
		}		
	}
	
	return 0;
}

//==============================================================================
/**
 * ʐMؒfÅ֐ĂԂƂœԂOC̏Ԃɂ܂B
 * @param 	nonte
 * @retval  1 = B0 = sB
 */
//==============================================================================
int mydwc_returnLobby()
{
    if( _dWork->state == MDSTATE_DISCONNECT || _dWork->state == MDSTATE_TIMEOUT ) {
        _dWork->op_aid = -1;
        _dWork->state = MDSTATE_LOGIN;
        _dWork->newFriendConnect = -1;
        return 1;
	 }
	 return 0;
}

//==============================================================================
/**
 * fetal errorɌĂ΂֐ÃR[obN̒ŏƂ߂ĉB
 * @param 	nonte
 * @retval  1 = B0 = sB
 */
//==============================================================================
void mydwc_setFetalErrorCallback( void (*func)(int) )
{
    if(_dWork){
        _dWork->fetalErrorCallback = func;
    }
}



//-----2006.04.11 k.ohno
//==============================================================================
/**
 * OAEg
 * @param 	none
 * @retval  none
 */
//==============================================================================

void mydwc_Logout(void)
{
    DWC_ShutdownFriendsMatch();
    DWC_CleanupInet();
    myvct_free();
    mydwc_free();
}


//==============================================================================
/**
 * IC̗FBT[oɃAbvĂ߂zw肵܂B
 * ̔zmydwc_step, mydwc_stepmatchĂяoۂɍXV\܂B
 * @param 	array - f[^߂z̐擪
 * @param 	size  - l̃f[^TCY
 * @retval  none
 */
//==============================================================================
void mydwc_setFriendStateBuffer( void *array, int size )
{
	_dWork->friendinfo = array;	
	_dWork->infosize = size;
	

}

// FRIENDINFO_UPDATA_PERFRAMEl̃f[^XVB
static void mydwc_updateFriendInfo( )
{
	int i;
	if( _dWork->friendinfo == NULL ) return;
	for(i = 0; i < FRIENDINFO_UPDATA_PERFRAME; i++)
	{
		int index = _dWork->friendupdate_index % FRIENDLIST_MAXSIZE;
		int size;
	
		if( DWC_IsBuddyFriendData( &(_dWork->keyList[index]) ) ) 
		{
			_dWork->friend_status[index] = 
				DWC_GetFriendStatusData( 
					&_dWork->keyList[ index ], 
					(void *)(((u32)_dWork->friendinfo) + _dWork->infosize * index),
					&size
				);
				
			if( size > _dWork->infosize )
			{
				OS_TPrintf("\n!!!!!!!!!!!!!!!size > _dWork->infosize!!!!!!!!!!!!!!!!\n");
			}
		}
			
		_dWork->friendupdate_index = (_dWork->friendupdate_index + 1) % FRIENDLIST_MAXSIZE;
	}
}

//==============================================================================
/**
 * ̏ԂT[oɃAbv܂B
 * @param 	data - f[^ւ̃|C^
 * @param 	size  - f[^TCY
 * @retval  ̉
 */
//==============================================================================
BOOL mydwc_setMyInfo( const void *data, int size )
{
	OS_TPrintf("upload status change(%p, %d)\n", data, size);
	return DWC_SetOwnStatusData( data, size );
}

//==============================================================================
/**
 * FBT[oɃAbvĂ擾܂i[JɃLbVĂ̂\܂jB
 * @param 	index thXg̔ԍ
 * @retval  f[^ւ̃|C^Bg͏ȂŉB
 */
//==============================================================================
void *mydwc_getFriendInfo( int index )
{
	return (void *)(((u32)_dWork->friendinfo) + _dWork->infosize * index);
}

//==============================================================================
/**
 * FBT[oɃAbvĂ擾܂i[JɃLbVĂ̂\܂jB
 * @param 	index thXg̔ԍ
 * @retval  FB̏ԁBDWC_GetFriendStatusData̕ԂlƓ
 */
//==============================================================================
u8 mydwc_getFriendStatus( int index )
{
	return _dWork->friend_status[index];
}


static void SetupGameServerCallback(DWCError error, BOOL cancel, BOOL self, BOOL isServer, int  index, void* param);
static void ConnectToGameServerCallback(DWCError error, BOOL cancel, BOOL self, BOOL isServer, int  index, void* param);
static void NewClientCallback(int index, void* param);

//==============================================================================
/**
 * Q[WEQs֐B
 * @target   cŃQ[JÁBOȏcڑɍśAthXg̈ʒu
 * @retval  cBOcsB
 */
//==============================================================================
int mydwc_startgame( int target )
{
	if( _dWork->state != MDSTATE_LOGIN ) return 0;

	_dWork->friendindex = target;

	if ( target < 0 ){
	    DWC_SetupGameServerAsync(
	    	(u8)2,			// lΐ
	        SetupGameServerCallback,
	        NULL,
	        NewClientCallback,
	        NULL
	    );
	    
	    _dWork->matching_type = MDTYPE_PARENT;
    } else {
        DWC_ConnectToGameServerAsync(target,
                                     ConnectToGameServerCallback,
                                     NULL,
                                     NewClientCallback,
                                     NULL);	    
                                     
	    _dWork->matching_type = MDTYPE_CHILD;
    }

                              
    _dWork->state = MDSTATE_MATCHING;
  
    // MR[obN̐ݒ	
    DWC_SetUserSendCallback( SendDoneCallback ); 

    // MR[obN̐ݒ	
    DWC_SetUserRecvCallback( UserRecvCallback ); 
    
    // RlNVN[YR[obNݒ
    DWC_SetConnectionClosedCallback(ConnectionClosedCallback, NULL);
    
    // ^CAEgR[obN̐ݒ
    DWC_SetUserRecvTimeoutCallback( recvTimeoutCallback );
    
    _dWork->sendbufflag = 0;
    
	// eXgp
	_dWork->s_param = 0;    

    
    return 1;    
}

//==============================================================================
/**
 * ڑĂFB̃thXg̈ʒuԂ܂B
 * ܂AڑĂȂĂFBԍԂƂ܂̂ŁAڑ
 * ̔ɂ͎gȂłB
 * @retval  OȏcFBԍB|Pc܂ڑĂȂB
 */
//==============================================================================
int mydwc_getFriendIndex()
{
    if(_dWork){
        // ڑĂFB̃thXg̈ʒuԂ܂B
        return _dWork->friendindex;
    }
    return -1;
}
/*---------------------------------------------------------------------------*
  Q[T[oNR[obN֐
 *---------------------------------------------------------------------------*/
static void SetupGameServerCallback(DWCError error,
                                    BOOL cancel,
                                    BOOL self,
                                    BOOL isServer,
                                    int  index,
                                    void* param)
{
#pragma unused(isServer, param, index)
    if (error == DWC_ERROR_NONE){
        if (!cancel){
            // lbg[NɐVKNCAg
            OS_TPrintf("FBڑĂ܂BiCfbNX%dj\n", index);
			_dWork->friendindex = index;
            // obt@̊m
            setConnectionBuffer();
        }
        else 
        {
            if (self){
                // }b`OLZ
                OS_TPrintf("}b`ÕLZ܂B\n\n");
	            // OCԂɖ߂
//				s_dwcstate = MYDWCSTATE_MATCH_CANCELFINISH;  
            }
            else {
                // qłq@AڑLZB
                OS_TPrintf("Client (friendListIndex = %d) canceled matching.\n\n", index);
                // qłq@ȂȂB2006.7.3 yoshihara
                _dWork->newFriendConnect = -1;
            }
        }
    }
    else {
        // G[BG[R[h́Astep֐̒ŏEB
        OS_TPrintf("Game server error occured. %d\n\n", error);

//        s_dwcstate = MYDWCSTATE_MATCH_CANCELFINISH; 
    }
}

/*---------------------------------------------------------------------------*
  Q[T[oڑR[obN֐
 *---------------------------------------------------------------------------*/
static void ConnectToGameServerCallback(DWCError error,
                                        BOOL cancel,
                                        BOOL self,
                                        BOOL isServer,
                                        int  index,
                                        void* param)
{
#pragma unused(param)
    if (error == DWC_ERROR_NONE){
        if (!cancel){
            if (self){
                // Q[T[oƂɂłĂlbg[Nւ̐ڑ
                // ꍇ
                OS_TPrintf("ڑɐ܂\n\n");
            }
            else {
                // lbg[NɐVKNCAgꍇB
                // lΐȂ̂ŁAɂ͂Ȃ͂B
            }

            // Mobt@Zbg
            setConnectionBuffer();
        }
        else {
            if (self){
                // }b`OLZ
                OS_TPrintf("LZ܂B\n\n");
                // OCԂɖ߂
//                s_dwcstate = MYDWCSTATE_MATCH_CANCELFINISH;  
            }
            else {
                if (isServer){
                    // Q[T[o}b`OLZ
                    OS_TPrintf("eڑLZ܂\n\n");
                    // }b`OIăOCԂɖ߂
//                    s_dwcstate = MYDWCSTATE_MATCH_CANCELFINISH;
                }
                else {
                    // ̃NCAg}b`OLZB
                    // lΐȂ炱ɂȂ͂B
                }
            }
        }
    }
    else {
        // G[BG[R[h́Astep֐̒ŏEB
        OS_TPrintf("Game server error occured. %d\n\n", error);

        // xŏB
//        s_dwcstate = MYDWCSTATE_MATCH_ERRORFINISH; 
    }

//    s_blocking = 0;
}

/*---------------------------------------------------------------------------*
  T[oNCAg^}b`O̐VKڑNCAgʒmR[obN֐
 *---------------------------------------------------------------------------*/
static void NewClientCallback(int index, void* param)
{
#pragma unused(param)
    // VKڑNCAg̐ڑI܂ł́A
    // Rg[֎~
//    s_blocking = 1;

    _dWork->newFriendConnect = index;
    
    OS_TPrintf("VlڑĂ܂B\n");
    if (index != -1){
        OS_TPrintf("FB[%d].\n", index);
    }
    else {
        OS_TPrintf("FBł͂Ȃ.\n");
    }
}

//==============================================================================
/**
 * ̃mCYJbgx𒲐܂iOANZX̂ŁAɁj
 * @param   d c 臒l邩Aグ邩iقǏE₷Ȃj
 * @retval  none
 */
//==============================================================================
void mydwc_changeVADLevel(int d)
{
//	myvct_changeVADLevel(d);
}

//==============================================================================
/**
 * ݂̃thXg\܂BifobOpj
 * @param 	none
 * @retval  none
 */
//==============================================================================
void mydwc_showFriendInfo()
{
	int i;
	
	if( !DWC_CheckHasProfile( _dWork->myUserData ) ) 
	{
		DWCFriendData token;
		u32 *ptr;

		DWC_CreateExchangeToken( _dWork->myUserData, &token ); 
		ptr = (u32*)&token;
		OS_TPrintf("܂Avt@Chc擾O\nOChc:(%d, %d, %d)\n\n", ptr[0], ptr[1], ptr[2] );		
	}
	else
	{
		// ڑς	
		DWCFriendData token;
		DWC_CreateExchangeToken( _dWork->myUserData, &token );
		OS_TPrintf("vt@Chc:%d \n\n", DWC_GetGsProfileId( _dWork->myUserData, &token ) );	
	}
	
	for( i = 0; i < FRIENDLIST_MAXSIZE; i++ )
	{
		int ret = DWC_GetFriendDataType( &(_dWork->keyList[i]) );
		u32 *ptr = (u32*)(&_dWork->keyList[i]);
		switch(ret)
		{
			case DWC_FRIENDDATA_LOGIN_ID:
				OS_TPrintf("%d:OChc:(%d, %d, %d)",i, ptr[0], ptr[1], ptr[2] );
				break;

			case DWC_FRIENDDATA_FRIEND_KEY:
				OS_TPrintf("%d:thR[h:(%d)", i, DWC_GetGsProfileId( _dWork->myUserData, &_dWork->keyList[i] ) );			
				break;

			case DWC_FRIENDDATA_GS_PROFILE_ID:
				OS_TPrintf("%d:vt@Chc:(%d)", i, DWC_GetGsProfileId( _dWork->myUserData, &_dWork->keyList[ i ]) );
				break;

			case DWC_FRIENDDATA_NODATA:
			default:
				OS_TPrintf("%d:", i);
				break;
		}			
		
		if( DWC_IsBuddyFriendData( &(_dWork->keyList[i]) ) )
		{
			OS_TPrintf("(v)");
		}
		OS_TPrintf("\n");
	}
}


// MǂԂ܂
BOOL mydwc_IsSendVoiceAndInc(void)
{
    return myvct_IsSendVoiceAndInc();
}


//==============================================================================
/**
 * {CX`bgԂǂԂ܂   k.ohno 06.05.23 07.22 tO
 * @retval  TRUEc{CX`bg   FALSEc{CX`bgł͂Ȃ 
 */
//==============================================================================
BOOL mydwc_IsVChat(void)
{
    if(_dWork){
        return _dWork->bVChat;
    }
    return FALSE;
}

//==============================================================================
/**
 * ڑĂǂԂ܂    k.ohno 06.05.24
 * @retval  TRUEcڑJnȂ̂ŃL[ubN   FALSEc
 */
//==============================================================================
BOOL mydwc_IsNewPlayer(void)
{
    if(_dWork){
        return _dWork->newFriendConnect;
    }
    return FALSE;
}

//==============================================================================
/**
 * ڑĂǂtO𗎂Ƃ܂ k.ohno 06.08.04
 * @retval  none
 */
//==============================================================================
void mydwc_ResetNewPlayer(void)
{
    if(_dWork){
        _dWork->newFriendConnect = -1;
    }
}

//==============================================================================
/**
 * xONOFF     k.ohno 06.05.30
 */
//==============================================================================
BOOL mydwc_toggleDelay(void)
{
    _dWork->bDelay = 1 - _dWork->bDelay;
    return _dWork->bDelay;
}

//==============================================================================
/**
 * VCHATONOFF     k.ohno 06.05.24
 */
//==============================================================================
void mydwc_setVChat(BOOL bVChat)
{
    _dWork->bVChat = bVChat;
}

static void sendPacket()
{
	if( _dWork->sendbufflag || !DWC_IsSendableReliable( DWC_GetMyAID() ) ) // Mobt@`FbNB
	{
		_dWork->sendbufflag = 1;
		*((u32*)&(_dWork->sendBuffer[0])) = MYDWC_KEEPALIVE_PACKET | (_dWork->myvchaton << MYDWC_PACKET_VCHAT_SHIFT);;
		DWC_SendReliable( _dWork->op_aid, &(_dWork->sendBuffer[0]), 4);
		_dWork->sendintervaltime = 0;
	}
}

void mydwc_VChatPause()
{
	if( _dWork->myvchaton != 0 )
	{
		_dWork->myvchaton = 0;
		sendPacket();
	}
}

void mydwc_VChatRestart()
{
	if( _dWork->myvchaton != 1 )
	{
		_dWork->myvchaton = 1;
		sendPacket();
	}
}