//=============================================================================
/**
 * @file	dwc_rapcommon.c
 * @bfief	DWCbp[B풓W[ɒu
 * @author	kazuki yoshihara  -> k.ohno
 * @date	06/02/23
 */
//=============================================================================

#include "common.h"
#include <dwc.h>
#include "wifi/dwc_rap.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/03
// ؍łƏ]łƂł͂ƂʐM}b`OȂ悤
#if PM_LANG == LANG_KOREA
#define USERDATA_GAMECODE	'ADAK'
#else
#define USERDATA_GAMECODE	'ADAJ'
#endif
// ----------------------------------------------------------------------------

//==============================================================================
/**
 * DWCCu
 * @param   WIFI_LIST  [U[f[^Ȃꍇ쐬
 * @retval  DS{̂ɕۑ郆[UID̃`FbNE쐬ʁB
 */
//==============================================================================
int mydwc_init(int heapID)
{
	int ret;
    u8* pWork;
    u8* pTemp;

    pWork = sys_AllocMemory(heapID, DWC_INIT_WORK_SIZE+32);
    pTemp = (u8 *)( ((u32)pWork + 31) / 32 * 32 );
    // DWCCu
    ret = DWC_Init( pTemp );
    sys_FreeMemoryEz(pWork);

	return ret;
}


//==============================================================================
/**
 * DWC  UserData
 * @param   WIFI_LIST  [U[f[^Ȃꍇ쐬
 * @retval  DS{̂ɕۑ郆[UID̃`FbNE쐬ʁB
 */
//==============================================================================
void mydwc_createUserData( WIFI_LIST *pWifiList )
{
    // [Uf[^쐬B    
    DWCUserData *userdata = WifiList_GetMyUserInfo(pWifiList);
    if( !DWC_CheckUserData( userdata ) ){
        // ----------------------------------------------------------------------------
        // localize_spec_mark(LANG_KOREA) imatake 2007/09/03
        // ؍łƏ]łƂł͂ƂʐM}b`OȂ悤
        DWC_CreateUserData( userdata, USERDATA_GAMECODE );
        // ----------------------------------------------------------------------------
        DWC_ClearDirtyFlag( userdata );
        OS_TPrintf("WIFI[Uf[^쐬\n");
    }
}

//==============================================================================
/**
 * GSID擾
 * @param   WIFI_LIST  
 * @retval  OƁ|P͎s   ̒l͐
 */
//==============================================================================

int mydwc_getMyGSID(WIFI_LIST *pWifiList)
{
    DWCUserData *userdata = WifiList_GetMyUserInfo(pWifiList);
    DWCFriendData friendData;

    DWC_CreateExchangeToken(userdata,&friendData);
    return DWC_GetGsProfileId( userdata,&friendData);
}

//==============================================================================
/**
 * GSID̂
 * @param   WIFI_LIST  
 * @retval  TRUE
 */
//==============================================================================

BOOL mydwc_checkMyGSID(SAVEDATA *pSV)
{
    WIFI_LIST* pList = SaveData_GetWifiListData(pSV);
    DWCUserData *userdata = WifiList_GetMyUserInfo(pList);

    if( DWC_CheckHasProfile( userdata )
       && DWC_CheckValidConsole( userdata ) ){
       return TRUE;
   }
   return FALSE;
}

