//=============================================================================
/**
 * @file	dwc_test.c
 * @bfief	DWCbp[̃eXgp
 * @date	06/02/24
 */
//=============================================================================

#include "common.h"
#include "wifi/dwc_test.h"
#include "wifi/dwc_rap.h"

#define MYDWC_HEAPID HEAPID_COMMUNICATION

#define SERVERBUF_SIZE 16

typedef struct{
	u32 aid;
	u32 data;
} T_SERVERCOM;

typedef struct
{
	// T[oɗ܂Ăf[^̃L[
	T_SERVERCOM serverbuf[SERVERBUF_SIZE];
	
	int start;			// L[̐擪
	int end;			// L[̍Ō
	
	int state;
	int heapID;
	
	int ret;			// ڑ
	
	MATHRandContext16 context;
	int index;
} DWCTEST_WORK;

static DWCTEST_WORK *_testWork;

enum {
	DWCTESTSTATE_INIT,
	DWCTESTSTATE_CONNECTING,
	DWCTESTSTATE_LOGIN,
	DWCTESTSTATE_MATCHING,
	DWCTESTSTATE_CANCELING,
	DWCTESTSTATE_CONNECT,
	DWCTESTSTATE_DISCONNECTING,
	DWCTESTSTATE_END,	
	DWCTESTSTATE_DISCONNECTED,
		
	DWCTESTSTATE_ERROR,
	DWCTESTSTATE_LAST
};

static void serverCallback(u16 aid, u16 *data, u16 size);
static void clientCallback(u16 aid, u16 *data, u16 size);
static void testMain();
static void fetal_error( int errorcode );

static u32 getRand32()
{
	u32 buffer[8];
	u32 ans;
	MATHCRC32Table table;
	MATH_CRC32InitTable( &table );

	OS_GetLowEntropyData( buffer );
	ans = MATH_CalcCRC32( &table, buffer, sizeof(buffer) );
	OS_TPrintf("my id = %d\n", ans);
	return ans;
}


void dwctest_init( int heapID )
{
	_testWork = (DWCTEST_WORK *) sys_AllocMemory( heapID, sizeof(DWCTEST_WORK) );
	_testWork->start = 0;
	_testWork->end = 0;
	_testWork->state = DWCTESTSTATE_INIT;
	_testWork->index = 0;
	_testWork->heapID = heapID;
	
	MATH_InitRand16( &_testWork->context, getRand32() );
}

static void dwctest_reinit(){
	_testWork->start = 0;
	_testWork->end = 0;
	_testWork->state = DWCTESTSTATE_INIT;
	_testWork->index = 0;
}

static const char* _mesType[] = {
	// G[R[hPOOOOȉ̏ꍇ́AG[R[h̕\̕KvȂB
	"Wi-FiRlNV ڑł܂B ڂ͎戵 BiG[R[h%dj",
	"qlWi-FiRlNVID͒ gpȂߍ폜܂B ڂ͎戵BiG[R[h%dj",
	"̃\tg Wi-FiRlNVT[rX I܂B p肪Ƃ܂BiG[R[h%dj",
	"ڑłANZX|Cg ܂B Wi-FiRlNVݒ ڑ̐ݒmFBiG[R[h%dj",
	"Wi-FiRlNV ڑł܂B Wi-FiRlNVݒ ڑ̐ݒmFBiG[R[h%dj",
	"jeh[Wi-FiRlN^ ڑł܂B Wi-FiRlNVݒ jeh[Wi-FiRlN^ ڑmFBiG[R[h%dj",
	"ANZX|Cg܂B ANZX|Cgɋ߂Â x߂BiG[R[h%dj",
	"Wi-FiRlNVݍĂ邩 T[rX~Ă邽߂ ڑł܂B ΂炭҂Ă蒼ĂBG[R[h%dj",
	"ANZX|CgݍĂ邽 ڑł܂B ΂炭҂Ă蒼ĂBiG[R[h%dj",
	"v|eRlNVؒf܂BiG[R[hF%dj",
	"lbg[Nؒf܂B"
};

void dwctest_main(  )
{
	switch( _testWork->state )
	{
		case DWCTESTSTATE_INIT:
		{
			// ԁB
			_testWork->ret = mydwc_startConnect(NULL, _testWork->heapID);
			// tF[^G[iċNs\̃G[jۂɌĂ΂֐w肵܂B
			mydwc_setFetalErrorCallback( fetal_error );
			_testWork->state = DWCTESTSTATE_CONNECTING;
			if( _testWork->ret == MYDWC_STARTCONNECT_OK )
			{
				OS_TPrintf("uv|eRlNVɐڑ܂H[Y/N]v\n");				
			} 
			else if ( _testWork->ret == MYDWC_STARTCONNECT_FIRST )
			{
				OS_TPrintf("uv|eRlNVł́AcrJ[hƂcr{̂Zbgň܂B\n");
				OS_TPrintf("gp̂cr{̂łv|eRlNVɐڑ܂H[Y/N]v\n");
			} else if( _testWork->ret == MYDWC_STARTCONNECT_DIFFERENTDS ) {
				OS_TPrintf("uDS{̂DSJ[hWi-Fi[U񂪂Wi-FiRlNVɐڑł܂Bv\n");
				OS_TPrintf("uDSJ[hɕۑĂWi-Fi[UXV܂H܂Wi-FiRlNVłgɂȂĂf[^͎Ă܂܂B[Y/N]v\n");
				OS_TPrintf("u(Q[Ǝ̏Cp\)v\n");
				OS_TPrintf("u{ɍXVĂ낵łH[Y/N]v\n");
			}
			OS_TPrintf("uWi-FiRlNVɐڑĂ܂B΂炭҂Bv\n");
			break;
		}
		
		case DWCTESTSTATE_CONNECTING:
		{
			// ڑ
			int ret = mydwc_connect();
			if( ret < 0 ){
				OS_TPrintf(_mesType[mydwc_errorType(-ret)], -ret);
				OS_TPrintf("`{^ƍēxڑ݂܂B\n");
				_testWork->state = DWCTESTSTATE_ERROR;
			}
			else if ( ret > 0 ) 
			{
				if( _testWork->ret != MYDWC_STARTCONNECT_OK ) {				
					OS_TPrintf("uDSJ[hɂgpDS{̂Wi-Fi[Uۑ܂BWi-FiRlNVւ̐ڑ́AgpDS{̂gpv\n");
				}
				OS_TPrintf("WiFiRlNVɐڑ܂B\n	");
				OS_TPrintf("A{^ƃ}b`OJn܂B\n");	
				_testWork->state = DWCTESTSTATE_LOGIN;
			}
			
			break;
		}
		
		case DWCTESTSTATE_LOGIN:
		{
			// ڑB
			int ret = mydwc_step( );
				
			if( ret < 0 ){ // G[
				OS_TPrintf(_mesType[mydwc_errorType(-ret)], -ret);
				OS_TPrintf("`{^ƍēxڑ݂܂B\n");
				_testWork->state = DWCTESTSTATE_ERROR;
			}			
			
			if(sys.trg & PAD_BUTTON_A)
			{
				// }b`O܂łɃR[obNݒ肷Kv̂ŁAłĂA
				mydwc_setReceiver( serverCallback, clientCallback );
				// }b`OIɊJnB	
				if( mydwc_startmatch( ) ){
					OS_TPrintf("}b`OJn\n");
					_testWork->state = DWCTESTSTATE_MATCHING;
				}
			}
			break;
		}
		
		case DWCTESTSTATE_MATCHING:
		{
			int ret;
			if( sys.trg & PAD_BUTTON_B )
			{
				// }b`OLZ
				ret = mydwc_stepmatch( 1 );
			} 
			else
			{
				ret = mydwc_stepmatch( 0 );				
			}
				
			if( ret < 0 ){
				OS_TPrintf(_mesType[mydwc_errorType(-ret)], -ret);
				OS_TPrintf("`{^ƍēxڑ݂܂B\n");
				_testWork->state = DWCTESTSTATE_ERROR;
			}
			else if ( ret == 1 ) 
			{
				OS_TPrintf("ΐ푊肪܂B\n");
				_testWork->state = DWCTESTSTATE_CONNECT;
			}
			else if ( ret == 2 )
			{
				OS_TPrintf("LZ܂B\n");	
				OS_TPrintf("A{^ƃ}b`OJn܂B\n");	
				_testWork->state = DWCTESTSTATE_LOGIN;							
			}
			break;
		}
		
		case DWCTESTSTATE_DISCONNECTING:
		// ؒf܂ŁAt[mydwc_disconnectĂяoĂB
		// ̌Amydwc_stepĂԕKv܂B
		if( mydwc_disconnect( 0 ) ) {
			_testWork->state = DWCTESTSTATE_DISCONNECTED;
			break;
		}
		case DWCTESTSTATE_CONNECT:
		{
			// ڑ	
			int ret;
			
			if( (_testWork->state == DWCTESTSTATE_CONNECT) && (sys.trg & PAD_BUTTON_START) ){			
				_testWork->state = DWCTESTSTATE_DISCONNECTING;
				break;	
			}
			testMain();
			ret = mydwc_step();

			if( ret < 0 ){
				// G[B
				OS_TPrintf(_mesType[mydwc_errorType(-ret)], -ret);
				OS_TPrintf("`{^ƍēxڑ݂܂B\n");
				_testWork->state = DWCTESTSTATE_ERROR;
			}		
			else if( ret == 1 )
			{
				// ^CAEgi肩PObȏチbZ[W͂Ȃj
				// 莞ԑMȂꍇ́Ãf[^őMĂ܂B
				OS_TPrintf("^CAEg܂B\n");	
				_testWork->state = DWCTESTSTATE_DISCONNECTED;			
			}
			else if(ret == 2)
			{
				// ؒfꂽB
				OS_TPrintf("肩ؒf܂B\n");
				_testWork->state = DWCTESTSTATE_DISCONNECTED;
			}	
			break;
		}
		
		case DWCTESTSTATE_DISCONNECTED:
		{
			// ؒfB	
			OS_TPrintf("Ƃ̒ʐMI܂B\n");
			OS_TPrintf("A{^ƍēx}b`OJn܂B\n");
			mydwc_returnLobby();
			_testWork->state = DWCTESTSTATE_LOGIN;			
		}
		
		case DWCTESTSTATE_ERROR:
		{
			if(sys.trg & PAD_BUTTON_A)
			{
				// xJ
				mydwc_free();
				
				dwctest_reinit();
			}
		}
		break;
	}
}

static void serverCallback(u16 aid, u16 *data, u16 size)
{
	// f[^M
	_testWork->serverbuf[_testWork->end].aid = aid;
	_testWork->serverbuf[_testWork->end].data = *((u32*)data);
	_testWork->end++;
	if( _testWork->end >= SERVERBUF_SIZE ) _testWork->end = 0;
	if( _testWork->end == _testWork->start )
	{
		// obt@I[o[t[
		OS_TPrintf("!!!!!!!!!!!I[o[t[!!!!!!!!!!!!!!!!");	
	}
}

static void clientCallback(u16 aid, u16 *data, u16 size)
{
	T_SERVERCOM *comm;
	
	comm = (T_SERVERCOM*) data;
	
	// Pɕ\邾B
	if( comm->aid == 0 ){
		OS_TPrintf("%d\n", comm->data);
	}else{
		OS_TPrintf("        %d\n", comm->data);
	}
}

static void testMain()
{
	// T[opL[Ƀf[^cĂꍇAMB
	if( _testWork->end != _testWork->start )
	{
		if( mydwc_sendToClient( &(_testWork->serverbuf[_testWork->start]), sizeof(T_SERVERCOM) ))
		{
			// M
			_testWork->start++;
			if( _testWork->start >= SERVERBUF_SIZE ) _testWork->start = 0;
		}
	}
	
	// QOt[Ɉx炢AMB
//	if( MATH_Rand16( &_testWork->context, 20 ) == 0 )
	// {^
	if( sys.trg )
	{
		if ( mydwc_sendToServer( &(_testWork->index), 4) )
		{
			_testWork->index++;
		}
	}
}

static void fetal_error( int errorcode ){
	OS_TPrintf(_mesType[mydwc_errorType(errorcode)], errorcode);
	OS_TPrintf("d؂ĂB\n");	
	while(1){}
}