//=============================================================================
/**
 * @file	vchat.c
 * @bfief	{CX`bgbp[Bldb[hp
 * @author	kazuki yoshihara
 * @date	06/02/27
 */
//=============================================================================

#include "common.h"
#include "wifi/dwc_rap.h"
#include "wifi/vchat.h"
#include <vct.h>

#define MYNNSFORMAT NNS_SND_STRM_FORMAT_PCM16

#define VCHAT_SAMPLING_RATE       8000   // Hz
#define SAMPLING_BYTE        2      // byte = 16bit
#define MAX_SAMPLING_TIME   68     // ms
#define MAX_CHANNELS 1
#define VCHAT_WAVE_SAMPLE ((int) (VCHAT_SAMPLING_RATE * MAX_SAMPLING_TIME * SAMPLING_BYTE) / 1000)

//#define VCFINFO_SHOW
//#define VCT_ERROR_NONE (VCT_SUCCESS)

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/10
// libVCT 1.1.0 ΉɏCiGR[LZ͏펞gpj
// ----------------------------------------------------------------------------

// }CNQCݒ
#define MY_AMPGAIN PM_AMPGAIN_160
//#define MY_AMPGAIN PM_AMPGAIN_80
//#define MY_AMPGAIN PM_AMPGAIN_40
//#define MY_AMPGAIN PM_AMPGAIN_20

// t[܂ŗāA`FbN邩
#define HAWLING_CHECKFRAME 16

typedef struct{
	u8 stAudioBuffer[VCT_AUDIO_BUFFER_SIZE * VCT_DEFAULT_AUDIO_BUFFER_COUNT ];
	u8 sPlayBuffer[VCHAT_WAVE_SAMPLE * 2 * MAX_CHANNELS];
    // TEhƂēnp̃obt@iɂOj
    u8 sSilentBuffer[VCHAT_WAVE_SAMPLE * 2 * MAX_CHANNELS];
	u8  *sRecBuffer;
	
	void (*disconnectCallback)();
	VCTSession sSession[2];
	int state;
	int off_flag;
	int heapID;
	struct NNSSndStrm sSndStream;
	VCTSession *session;
    u8 bSendVoice;
    u8 firstCallback;
    u16 dummy;
    MICAutoParam micParam;
    
    // nEOANbvo܂
    int hc_state;
    int hc_ampgain;
    int hc_ampchangeflag;
    int hc_seqcount;
    int hc_hawlingflag;			// xnEOĂA܂xL[͂ȂB
    u16 hc_check[HAWLING_CHECKFRAME];
    int hc_index;
    
}MYVCT_WORK;

enum{
	VCTSTATE_INIT,
	VCTSTATE_WAIT,
	VCTSTATE_CALLING
};

static void* _vWork_temp;
static MYVCT_WORK* _vWork = NULL;

static void StartSoundLoop();

// BeqʁBZbVmɌĂ΂B
//
// n̏iŏ̂P̂݁j
//

static u8 *_test_buffer;
static u32 _test_buffer_index;
#define TEST_BUFFER_SIZE 0x100000

static OSTick _tick_time;
static int _difftime = 0;

static void InitFirst()
{
    OS_TPrintf("Init sound system\n");
    // }CN֘Ȁ
    //
    MIC_Init();
    PM_Init();

#if 0
	sys_CreateHeapLo( HEAPID_BASE_APP, HEAPID_VCTTEST, TEST_BUFFER_SIZE + 0x1000 );
	_test_buffer = sys_AllocMemory(HEAPID_VCTTEST, TEST_BUFFER_SIZE);
	MI_CpuClear8( _test_buffer, TEST_BUFFER_SIZE);
 	_test_buffer_index = 0;
#endif
    {
	    u32 ret;
	    ret = PM_SetAmp(PM_AMP_ON);
	    if( ret == PM_RESULT_SUCCESS )
	    {
		    OS_TPrintf("AMPIɂ܂B\n");
	    }
	    else
	    {
		    OS_TPrintf("AMP̏Ɏsi%dj", ret);
	    }
    }

    {
	    u32 ret;
	    ret = PM_SetAmpGain(MY_AMPGAIN);
	    if( ret == PM_RESULT_SUCCESS )
	    {
		    OS_TPrintf("AMP̃QCݒ肵܂B\n");
	    }
	    else
	    {
		    OS_TPrintf("AMP̃QCݒɎsi%dj", ret);
	    }
    }
    
	_vWork->hc_state    = 0;
	_vWork->hc_seqcount = 0;    
	_vWork->hc_ampgain  = 0;
	_vWork->hc_ampchangeflag = 0;
	_vWork->hc_hawlingflag = 0;
	{
		int i;
		for( i = 0; i < HAWLING_CHECKFRAME; i++ )
		{
			_vWork->hc_check[i] = 0;
		}
    	_vWork->hc_index = 0;		
	}
	// p~ɂȂƏĂ̂ō폜 2006/05/08 k.ohno
	//VCT_SetVADParams( MY_AMPGAIN, VCT_MIC_INTERNAL );
    //{  // vg邾Ȃ̂ō폜 p[^[ȂȂĂ 2006/05/08 k.ohno
	//	VCTVADInfo outInfo;
	//	VCT_GetVADInfo( &outInfo );
		
	//	OS_TPrintf("soundLevel = %d, noiseLevel = %d\n", outInfo.soundLevel, outInfo.noiseLevel);
	//}
	VCT_EnableVAD( TRUE );
//	VCT_EnableVAD( FALSE );
    // TEhVXȅ
    //
    NNS_SndInit();
    NNS_SndStrmInit(&_vWork->sSndStream);

	MI_CpuClearFast(_vWork->sSilentBuffer, sizeof(_vWork->sSilentBuffer) );
    OS_TPrintf("Init sound system done.\n");
    
    _difftime = 0;
}



#define HAWLING_SEQ_A 4
#define HAWLING_SEQ_B 8
#define HAWLING_SEQ_C 12
#define HAWLING_SEQ_D 100
#define HAWLING_SEQ_E 4
// nEOo[`
// HAWLING_SEQ_At[AŋKlA𒴂ꍇA}CNQCPiKB
// ɂ̂܂HAWLING_SEQ_Bt[nEOA
// HAWLING_SEQ_Ct[A}CN̑MƂ߂
// HAWLING_SEQ_Dt[AŋKlA𒴂邱ƂȂA͂΃QCPiKグB
// ԂlPȂA͂͂OB

#define HAWLING_BORDER_1 0x0300
#define HAWLING_BORDER_2 0x0200
#define HAWLING_BORDER_3 0x0100

#if 0
static int is_clip( int c1, int c2, int c3 )
{
	int ans = (c1 >= 5 || c2 >= 2 || c3 > 0 );
	OS_TPrintf("(%d, %d, %d) - %d\n", c1, c2, c3, ans);
	return ans;	
}
#else
static int is_clip( )
{
	int i;
	int count = 0;
	for(i = 0; i < HAWLING_CHECKFRAME; i++ )
	{
		count += _vWork->hc_check[i];
	}
	
	return (count >= 5 * HAWLING_CHECKFRAME);
}
#endif

static void change_gain(int d)
{
	if( d < 0 ) d = 0;
	if( d >= 4 ) d = 3;
	
	_vWork->hc_ampgain = d;
	_vWork->hc_ampchangeflag = 1;
}

// Q[͂΁AɓBƂ肠APAD_KEY_READ̓͂΂ƂĂB
static int hasGameInput()
{
	return PAD_Read();	
}

static int check_hawling(s16 *data, int length)
{
    int i;
    u16 *ptr;
//    int c1 = 0;
//    int c2 = 0;
//    int c3 = 0;
    ptr = _vWork->hc_check + _vWork->hc_index;
    *ptr = 0;
    _vWork->hc_index = ( _vWork->hc_index + 1 ) % HAWLING_CHECKFRAME;
    for( i = 0; i < length / 2; i++)
    {
	    if( data[i] < -(0x8000 - HAWLING_BORDER_1) || data[i] > (0x8000 - HAWLING_BORDER_1)) (*ptr)++;
//    	if( data[i] < -(0x8000 - HAWLING_BORDER_1) || data[i] > (0x8000 - HAWLING_BORDER_1)) c1++;
//    	if( data[i] < -(0x8000 - HAWLING_BORDER_2) || data[i] > (0x8000 - HAWLING_BORDER_2)) c2++;
//    	if( data[i] < -(0x8000 - HAWLING_BORDER_3) || data[i] > (0x8000 - HAWLING_BORDER_3)) c3++;
    }
    
//    if( is_clip( c1, c2, c3 ) )
    if( is_clip( ) )
    {
    	if( _vWork->hc_state == 0 )
    	{
    		// ܂ł͐
    		_vWork->hc_state = 1;
    		_vWork->hc_seqcount = 0;
    	}
    	else if( _vWork->hc_state == 1 )
    	{
    		// Olz
    		if( _vWork->hc_seqcount++ >= HAWLING_SEQ_A )
    		{
    			// HAWLING_SEQ_Aȏlz
    			// AviK
    			change_gain( _vWork->hc_ampgain + 1 );
    			OS_TPrintf("ʂ̓͂莞ԋKl𒴂Ă܂B}CÑQCiK܂(%d)\n", _vWork->hc_ampgain);
	    		_vWork->hc_state = 2;
	    		_vWork->hc_seqcount = HAWLING_SEQ_E;
	    		_vWork->hc_hawlingflag = 1;
    		}
    	}
    	else if( _vWork->hc_state == 2 )
    	{
    		// QCĂAĊz
    		if( _vWork->hc_seqcount++ >= HAWLING_SEQ_B )
    		{
    			// 񉹂~߂郂[hֈڍs
    			OS_TPrintf("QCĂ܂Kl𒴂Ă܂BnEŐꂪ̂ňU}CN~߂܂B(%d)\n", _vWork->hc_ampgain);
	    		_vWork->hc_state = 3;
	    		_vWork->hc_seqcount = 0;
    		}
    	}
    }
    else
    {
    	if( _vWork->hc_state == 0 )
    	{
    		// 
    		if( _vWork->hc_seqcount++ >= HAWLING_SEQ_D && (hasGameInput() || _vWork->hc_hawlingflag == 0) ) 
    		{
  				// QCiKグ
  				if( _vWork->hc_ampgain > 0 )
  				{
	    			change_gain( _vWork->hc_ampgain - 1 );
	    			if( _vWork->hc_hawlingflag == 1 )
	    			{
		    			OS_TPrintf("莞ԋK܂ł̂ŁAL[͂ƓɃQC܂(%d)\n", _vWork->hc_ampgain);
			    		_vWork->hc_hawlingflag = 0;	    			
	    			}
	    			else
	    			{
		    			OS_TPrintf("莞ԋK܂ł̂ŁAQC܂(%d)\n", _vWork->hc_ampgain);
	    			}
	    				
  				}
	    		_vWork->hc_seqcount = 0;
    		}
    	}
    	else if( _vWork->hc_state == 1 ) 
    	{
    		// O͊z
    		_vWork->hc_state = 0; 
    		_vWork->hc_seqcount = 0;    		
    	}
    	else if (_vWork->hc_state == 2 )
    	{
    		if( _vWork->hc_seqcount-- <= 0 )
    		{
	    		_vWork->hc_state = 0; 
	    		_vWork->hc_seqcount = 0;    		
    		}
    	}
    	else if( _vWork->hc_state == 3 )
    	{
    		// Ƃ߂ĂŒ
    		if( _vWork->hc_seqcount++ >= HAWLING_SEQ_C )
    		{
    			// ~ߏI
    			OS_TPrintf("}CN͂𕜋A܂\n");
	    		_vWork->hc_state = 0; 
	    		_vWork->hc_seqcount = 0;        				
    		}
    	}
    }
    
//    OS_TPrintf("{%d-%d}\n", _vWork->hc_state, _vWork->hc_seqcount);
    
    if( _vWork->hc_state == 3 )
   	{
   		// Ƃ߂ĂŒ
   		return 1;
   	}
   	
   	return 0;
}
//
// R[obNiNitroSystem NNS_SndStrm𗘗pj
//
static void micCallback(MICResult result, void *arg)
{
#pragma unused(result, arg)
}

static void SndCallback(NNSSndStrmCallbackStatus sts,
                        int nChannels,
                        void* buffer[],
                        u32 length,
                        NNSSndStrmFormat format,
                        void* arg)
{
#pragma unused(format)

	OSTick      start;
    const void *micAddr;
    u32         offset;
    u8*         micSrc;
    u32         ch;

	
    micSrc = (u8*)arg;

 
    
    if (sts == NNS_SND_STRM_CALLBACK_SETUP) {
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/10/11
		// libVCT 1.1.0 ΉɏC
        MI_CpuClear8(buffer[0], length);
		// ----------------------------------------------------------------------------
        return;
    }
    
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/10
	// libVCT 1.1.0 ΉɏCiGR[LZ͏펞gpj
    if (_vWork->firstCallback) {
        MIC_StartAutoSamplingAsync( &(_vWork->micParam), micCallback, NULL);
        _vWork->firstCallback = 0;
    }
	// ----------------------------------------------------------------------------
       
    micAddr = MIC_GetLastSamplingAddress();
    offset  = (u32)((u8*)micAddr - micSrc);

    if ( offset < length ) {
        micSrc = micSrc + length;
    }

#if 0    
    MI_CpuCopy8( micSrc, _test_buffer + _test_buffer_index, length );
    _test_buffer_index += length;
#endif


	if( PAD_DetectFold() )
	{
		// DSꍇ
   		micSrc = _vWork->sSilentBuffer;
	}

    // M͎M͏ɍs܂BVADSSP̃Xe[gǗɂāAZbVƂ̂
    // ۂɑMEMs܂B
    //
    // length͌݃I[fBĨTvO[gErbgɉ32msɂ̂ݑΉĂ܂B
    // iF8KHz, 8Bit 256oCgjBȊÕTCYnassertion܂B
    //
    
    if( _vWork->off_flag == 0 ) 
    {
#if 0	    
    	if( check_hawling((s16*)micSrc, length) )
    	{
    		micSrc = _vWork->sSilentBuffer;
    	}
#endif    	

	    VCT_SendAudio(micSrc, length);
	  
//	    OS_TPrintf("");  
    }else{
//   	    OS_TPrintf("~");
    }  

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/10
	// libVCT 1.1.0 ΉɏC
    VCT_ReceiveAudio(buffer[0], length, NULL);
	// ----------------------------------------------------------------------------

    _vWork->bSendVoice = 2;	  
    return;
}



static void ClearSession(VCTSession *session);

/////////////////////////////////////////////////////////////////////////////////////
//
// dbB
//

static int startCall( u8 aid )
{
	BOOL ret;
	if (_vWork->session == NULL) {
        VCTSession *session = VCT_CreateSession(aid);
        if (session == NULL) {
            // ZbVg؂ĂA܂aidg̏ꍇ
            // CraeteSession s܂
            OS_TPrintf("Can't create session!\n");
            return 0;
        }
	
        ret = VCT_Request(session, VCT_REQUEST_INVITE);
        if (ret != VCT_ERROR_NONE){                 // VCT_SUCCESS) {  2006.05.08 k.ohno `ύXH炵̂ŕύX
            OS_TPrintf("Can't request Invite [%d]\n", ret);
            VCT_DeleteSession(session);
            return 0;
        }
        else {
            _vWork->session = session;
        }
        
        return 1;
    }
    
    return 0;
}

static int receiveCall( u8 aid )
{
	BOOL ret;
	if ( _vWork->session != NULL && _vWork->session->state == VCT_STATE_INCOMING ) {
         // ̒[bvꍇAOKԂăXg[~OJn
        
        ret = VCT_Response(_vWork->session, VCT_RESPONSE_OK);
        if (ret != VCT_ERROR_NONE){                 // VCT_SUCCESS) {  2006.05.08 k.ohno `ύXH炵̂ŕύX
            OS_TPrintf("Can't send response OK [%d]\n", ret);
            return 0;
        }
        
        if( !VCT_StartStreaming(_vWork->session) )
        {
	        OS_TPrintf("can't start session! %d\n", _vWork->session->aid);
	        return 0;	        
        } else {
   	        OS_TPrintf("Xg[~OJn܂%d\n", _vWork->session->aid);	        
		}
	        
                
        return 1;
    }
    
    return 0;

}

/////////////////////////////////////////////////////////////////////////////////////
//
// VoiceChat̃CxgR[obN֐
//
static void VoiceChatEventCallback(u8 aid, VCTEvent event, VCTSession *session, void *data)
{
#pragma unused(aid, data)
    
    int ret;

    switch (event) {
    case VCT_EVENT_INCOMING:
        if (_vWork->session) {
            OS_TPrintf("Return busy to %d\n", session->aid);
            ret = VCT_Response(session, VCT_RESPONSE_BUSY_HERE);
            VCT_DeleteSession(session);
            break;
        }
            
        OS_TPrintf("Invite From %d\n", session->aid);
        _vWork->session = session;
        break;

    case VCT_EVENT_RESPONDBYE:
        OS_TPrintf("Bye From %d\n", session->aid);
        ret = VCT_Response(session, VCT_RESPONSE_OK);
        if (ret != VCT_ERROR_NONE){                 // VCT_SUCCESS) {  2006.05.08 k.ohno `ύXH炵̂ŕύX
            OS_TPrintf("Can't send response Ok [%d]\n", ret);
        }
        ClearSession(session);
        myvct_free();
        break;

    case VCT_EVENT_DISCONNECTED:
        OS_TPrintf("Disconnected\n");
        ClearSession(session);
        myvct_free();
        break;

    case VCT_EVENT_CANCEL:
        OS_TPrintf("Cancel From %d\n", session->aid);
        ret = VCT_Response(session, VCT_RESPONSE_TERMINATED);
        if (ret != VCT_ERROR_NONE){                 // VCT_SUCCESS) {  2006.05.08 k.ohno `ύXH炵̂ŕύX
            OS_TPrintf("Can't send response RequestTerminated [%d]\n", ret);
        }
        ClearSession(session);
        break;

    case VCT_EVENT_CONNECTED:
        OS_TPrintf("200 OK From %d\n", session->aid);
        if( VCT_StartStreaming(session) )
        {
	        OS_TPrintf("Xg[~OJn܂%d\n", session->aid);	        
	        _vWork->state = VCTSTATE_CALLING;
        } else 
        {
	        OS_TPrintf("can't start session! %d\n", session->aid);	        
        }
        break;

    case VCT_EVENT_REJECT:
        OS_TPrintf("Reject From %d\n", session->aid);
        ClearSession(session);
        break;

    case VCT_EVENT_BUSY:
    case VCT_EVENT_TIMEOUT:
    case VCT_EVENT_ABORT:
        OS_TPrintf("Clear session by '%d'\n", event);
        ClearSession(session);
        break;

    default:
        OS_TPrintf(" not handler (%d)\n", event);
        break;
    }
}

/////////////////////////////////////////////////////////////////////////////////////
//
// ZbṼNA
//
static void ClearSession(VCTSession *session)
{
    if (session == _vWork->session) {
        VCT_StopStreaming(session);
        VCT_DeleteSession(session);
        _vWork->session = NULL;
    }
    else {
        SDK_WARNING(FALSE, "What is this session??\n");
        VCT_DeleteSession(session);
    }
}


#ifdef VCFINFO_SHOW
static int s_count = 0;
#endif

// t[Ă΂B
void myvct_main( )
{
    // Q[t[ɈxĂяoC֐B
	OSTick      start;
    start = OS_GetTick(); 
//    OS_TPrintf("VCT_Main[%d]", OS_TicksToMicroSeconds32(start - _tick_time) );
    _difftime += OS_TicksToMicroSeconds32(start - _tick_time) - 1000 * 1000 / 60;
    if( _difftime < -10000 ) _difftime = 0;
    
    _tick_time = start;    
    VCT_Main();
    
    while( _difftime >= 1000 * 1000 / 60 )
    {
//	    OS_TPrintf("!");
	    VCT_Main();
	    _difftime -= 1000 * 1000 / 60 ;
    }
//    OS_TPrintf("\n");
	if( _vWork->hc_ampchangeflag )
	{
		switch(_vWork->hc_ampgain)
		{
			case 0:
				PM_SetAmpGain(PM_AMPGAIN_160);
				break;
			case 1:
				PM_SetAmpGain(PM_AMPGAIN_80);
				break;
			case 2:
				PM_SetAmpGain(PM_AMPGAIN_40);
				break;
			case 3:
				PM_SetAmpGain(PM_AMPGAIN_20);
				break;
		}
		_vWork->hc_ampchangeflag = 0;
	}
    
    
#ifdef VCFINFO_SHOW
    if( s_count++ % 60 == 0 )
    {
	    VCTVADInfo outInfo;
	    VCT_GetVADInfo( &outInfo );
	    OS_TPrintf("VCTVADInfo[%d][%d(%d,%d)]\n", outInfo.activity, outInfo.level, outInfo.Ts, outInfo.Tn);
    }
#endif	    
	switch( _vWork->state )
	{
		case VCTSTATE_INIT:
		{
			if( mydwc_getaid() == 0 ){
				// edbB
				if( startCall(1) ) {
					// ̔҂
					_vWork->state = VCTSTATE_WAIT;
				}
			}
			else if(mydwc_getaid() == 1)
			{
				// edbĂ̂҂
				if( receiveCall(0) )
				{
					// Ă
					_vWork->state = VCTSTATE_CALLING;
				}
			}
			break;
		}
		
		case VCTSTATE_WAIT:
		 // q@dbɏô҂ĂB
		 break;
		 
		case VCTSTATE_CALLING:
			// db
			break;
	}
}


BOOL myvct_checkData( int aid, void *data, int size )
{
	if( _vWork == NULL ) return FALSE;
	
	if( VCT_HandleData (aid, data, size ) ){
#ifdef VCFINFO_SHOW
	    OS_TPrintf(".");
#endif
	    return TRUE;
    }
	return FALSE;
}

static void* AllocFunc( u32 size )
{
	return mydwc_AllocFunc( NULL, size, 32 );
//	return sys_AllocMemory( _vWork->heapID, size );
}

static void FreeFunc(void *ptr, u32 size)
{
#pragma unused(size)
	mydwc_FreeFunc( NULL, ptr,  size  );
//	sys_FreeMemory(  _vWork->heapID, ptr );
}

static u8 _sRecBuffer[VCHAT_WAVE_SAMPLE * 2 * MAX_CHANNELS] ATTRIBUTE_ALIGN(32);

void *_audio_buffer;

void myvct_init( int heapID, int codec )
{
    u8 cArray[3] = {13, 13, 13};
    u32 length;
    BOOL ret;
       
	if( _vWork == NULL )
	{
		_vWork_temp = sys_AllocMemory( heapID, sizeof(MYVCT_WORK) + 32 );
		_vWork = (MYVCT_WORK *) (( (u32)_vWork_temp + 31 ) / 32 * 32);
		_vWork->heapID = heapID;
		_vWork->sRecBuffer = _sRecBuffer;
		_vWork->disconnectCallback = NULL;
		
		InitFirst();
	}
	
	// }CN̏
	
    length = (u32)(VCHAT_SAMPLING_RATE * VCT_AUDIO_FRAME_LENGTH * SAMPLING_BYTE) / 1000;
    
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/10
	// libVCT 1.1.0 ΉɏCiGR[LZ͏펞gpj

    _vWork->micParam.type   = MIC_SAMPLING_TYPE_SIGNED_12BIT;
    _vWork->micParam.buffer = _vWork->sRecBuffer;
    _vWork->micParam.size   = length * 2;
    _vWork->micParam.rate = (u32)((NNS_SND_STRM_TIMER_CLOCK / VCHAT_SAMPLING_RATE) * 64);
    _vWork->micParam.loop_enable = TRUE;
    _vWork->micParam.full_callback = NULL;
    _vWork->micParam.full_arg = NULL;
    _vWork->firstCallback = 1;

	// ----------------------------------------------------------------------------
        
    // TEhXg[Đ̏BP΂Pb
    NNS_SndStrmAllocChannel(&_vWork->sSndStream, 1, cArray);
    NNS_SndStrmSetVolume(&_vWork->sSndStream, 0);

    
    ret = NNS_SndStrmSetup(&_vWork->sSndStream,
                           NNS_SND_STRM_FORMAT_PCM16,
                           _vWork->sPlayBuffer,
                           length * 2 * 1,
                           NNS_SND_STRM_TIMER_CLOCK / VCHAT_SAMPLING_RATE,
                           2,
                           SndCallback,
                           _vWork->sRecBuffer);
    SDK_ASSERT(ret);
    
    _vWork->state = VCTSTATE_INIT;
	_vWork->session = NULL;
		
	{
	    VCTConfig config;
	    
	    config.mode         = VCT_MODE_PHONE;
	    config.session      = _vWork->sSession;
	    config.numSession   = 2;
	    config.aid          = mydwc_getaid();
	    config.callback     = VoiceChatEventCallback;
	    config.userData     = NULL;

		config.audioBuffer     = _vWork->stAudioBuffer;
		config.audioBufferSize = sizeof(_vWork->stAudioBuffer);
//		4 * VCT_AUDIO_BUFFER_SIZE;
	    
//	    config.alloc        = AllocFunc;
//	    config.free         = FreeFunc;
//	    config.numBuffer    = VCT_DEFAULT_AUDIO_BUFFER_COUNT;
//	    config.frameLength  = VCT_AUDIO_FRAME_LENGTH;

//	    OS_TPrintf("SDK %s\n", VCT_Version());  // ȂȂĂ悤Ȃ̂ō폜 2005.05.08 k.ohno
	    
	    if (!VCT_Init(&config)) {
	        OS_TPrintf("ERROR: Can't initialize VoiceChat!!!\n");
	    }	    
	}

	_vWork->off_flag = 0;
	
	VCT_SetCodec( codec );
	StartSoundLoop();
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/10
	// libVCT 1.1.0 ΉɏCiGR[LZ͏펞gpj
    VCT_EnableEchoCancel( TRUE );
	// ----------------------------------------------------------------------------

    return;	
}

static void StartSoundLoop()
{
    NNS_SndStrmStart(&_vWork->sSndStream);
}

void myvct_setCodec( int codec )
{
	VCT_SetCodec( codec );
}




//==============================================================================
/**
 * bIv܂B܂ʘbłĂȂƂ͑ɏI܂B
 * myvct_setDisconnectCallbackŐݒ肳ꂽR[obNĂяo܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
void myvct_endConnection(){
	int ret;
	
	// ܂bvoOŁA󂯎O
	if( _vWork->session == NULL || _vWork->state == VCTSTATE_INIT ) {  //sSession  session ֕ύX k.ohno
		myvct_free();
		return;
	}
	
	if( _vWork->state == VCTSTATE_WAIT )
	{
		// bvoĂ܂ԎOB
		ret = VCT_Request( _vWork->session, VCT_REQUEST_CANCEL );     //sSession  session ֕ύX k.ohno
        if (ret != VCT_ERROR_NONE){                 // VCT_SUCCESS) {  2006.05.08 k.ohno `ύXH炵̂ŕύX
			OS_TPrintf("Can't request Cancel [%d]\n", ret);
			myvct_free();
			return;
		}			
	}

	// bBbIvoB
	ret = VCT_Request( _vWork->session, VCT_REQUEST_BYE );          //sSession  session ֕ύX k.ohno
    if (ret != VCT_ERROR_NONE){                 // VCT_SUCCESS) {  2006.05.08 k.ohno `ύXH炵̂ŕύX
		OS_TPrintf("Can't request Bye [%d]\n", ret);
		myvct_free();
		return;
	}
	return;
}

//==============================================================================
/**
 * bIR[obNݒ肵܂B
 * 肩؂ꂽꍇĂяo܂B
 * ̊֐Ăяo钼OɁAvchat.cp̃[N܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
void myvct_setDisconnectCallback( void (*disconnectCallback)() )
{
	_vWork->disconnectCallback = disconnectCallback;
}

//==============================================================================
/**
 * CuI
 * @param   none
 * @retval  none
 */
//==============================================================================
void myvct_free(){
	void (*callback)();
	
	if( _vWork_temp != NULL )
	{
		callback = _vWork->disconnectCallback;
		
		// }CÑTvOƃXg[Ƃ߂B
	    (void)MIC_StopAutoSampling();
	    NNS_SndStrmStop(&_vWork->sSndStream);	
		NNS_SndStrmFreeChannel(&_vWork->sSndStream);
	
		// VCTCuI	
		VCT_Cleanup();
		
		// 
		sys_FreeMemory( _vWork->heapID, _vWork_temp  );
		_vWork_temp = NULL;
		_vWork = NULL;
		
		// R[obŇĂяoB
		if( callback != NULL ) callback();
	}
}

//==============================================================================
/**
 * ̃mCYJbgx𒲐܂
 * @param   d c 臒l邩Aグ邩iقǏE₷Ȃj
 * @retval  none
 */
//==============================================================================
void myvct_changeVADLevel(int d)
{
#if 0  // CVgTue, 02 May 2006 18:27:13 +0900[ɂč폜
    VCTVADInfo outInfo;
	VCT_GetVADInfo( &outInfo );
	if( outInfo.noiseLevel + d <= 0 )
	{
		OS_TPrintf("VAD𖳌ɂ܂B\n");
		OS_TPrintf("soundLevel = %d, noiseLevel = %d\n", outInfo.soundLevel, outInfo.noiseLevel);
		VCT_EnableVAD( FALSE );
	}
	else
	{
		VCT_SetVADLevel( outInfo.soundLevel + d, outInfo.noiseLevel + d );		
		OS_TPrintf("ύX[soundLevel = %d, noiseLevel = %d]\n", outInfo.soundLevel, outInfo.noiseLevel);
		VCT_EnableVAD( TRUE );
	}
	VCT_GetVADInfo( &outInfo );
#endif
}

//==============================================================================
/**
 * Êǂ𒲂ׂ   k.ohno 쐬
 * @param   
 * @retval  ETRUE
 */
//==============================================================================

BOOL myvct_IsSendVoiceAndInc(void)
{
    if(_vWork){
        VCTVADInfo outInfo;
        VCT_GetVADInfo( &outInfo );
        if(outInfo.scale > 2){
            return outInfo.activity;
        }
    }
    return FALSE;
}

void myvct_offVchat()
{
	_vWork->off_flag = 1;	
}

void myvct_onVchat()
{
	_vWork->off_flag = 0;	
}

BOOL myvct_isVchatOn(){
	return ( _vWork->off_flag == 0 );
}