﻿package letter_order;

use XML::Parser;
use Encode;

require 'tool.pl';


$NULL_STR = "00e0";

#-------------------------------------------------------
# 文字→enumシンボル名のテーブル
#-------------------------------------------------------
my %EnumCodeTbl = (
	'　',	'spc_',		# 0x3000
	'ぁ',	'aa_',		# 0x3041
	'あ',	'a_',		# 0x3042
	'ぃ',	'ii_',		# 0x3043
	'い',	'i_',		# 0x3044
	'ぅ',	'uu_',		# 0x3045
	'う',	'u_',		# 0x3046
	'ぇ',	'ee_',		# 0x3047
	'え',	'e_',		# 0x3048
	'ぉ',	'oo_',		# 0x3049
	'お',	'o_',		# 0x304a
	'か',	'ka_',		# 0x304b
	'が',	'ga_',		# 0x304c
	'き',	'ki_',		# 0x304d
	'ぎ',	'gi_',		# 0x304e
	'く',	'ku_',		# 0x304f
	'ぐ',	'gu_',		# 0x3050
	'け',	'ke_',		# 0x3051
	'げ',	'ge_',		# 0x3052
	'こ',	'ko_',		# 0x3053
	'ご',	'go_',		# 0x3054
	'さ',	'sa_',		# 0x3055
	'し',	'si_',		# 0x3057
	'す',	'su_',		# 0x3059
	'せ',	'se_',		# 0x305b
	'そ',	'so_',		# 0x305d
	'た',	'ta_',		# 0x305f
	'ち',	'ti_',		# 0x3061
	'っ',	'ttu_',		# 0x3064
	'つ',	'tu_',		# 0x3064
	'て',	'te_',		# 0x3066
	'と',	'to_',		# 0x3068
	'な',	'na_',		# 0x306a
	'に',	'ni_',		# 0x306b
	'ぬ',	'nu_',		# 0x306c
	'ね',	'ne_',		# 0x306d
	'の',	'no_',		# 0x306e
	'は',	'ha_',		# 0x306f
	'ひ',	'hi_',		# 0x3072
	'ふ',	'hu_',		# 0x3075
	'へ',	'he_',		# 0x3078
	'ほ',	'ho_',		# 0x307b
	'ま',	'ma_',		# 0x307e
	'み',	'mi_',		# 0x307f
	'む',	'mu_',		# 0x3080
	'め',	'me_',		# 0x3081
	'も',	'mo_',		# 0x3082
	'ゃ',	'yya_',		# 0x3083
	'や',	'ya_',		# 0x3084
	'ゅ',	'yyu_',		# 0x3085
	'ゆ',	'yu_',		# 0x3086
	'ょ',	'yyo_',		# 0x3087
	'よ',	'yo_',		# 0x3088
	'ら',	'ra_',		# 0x3089
	'り',	'ri_',		# 0x308a
	'る',	'ru_',		# 0x308b
	'れ',	're_',		# 0x308c
	'ろ',	'ro_',		# 0x308d
	'わ',	'wa_',		# 0x308f
	'を',	'wo_',		# 0x3092
	'ん',	'n_',		# 0x3093
	'ざ',	'za_',		# 0x3056
	'じ',	'zi_',		# 0x3058
	'ず',	'zu_',		# 0x305a
	'ぜ',	'ze_',		# 0x305c
	'ぞ',	'zo_',		# 0x305e
	'だ',	'da_',		# 0x3060
	'ぢ',	'di_',		# 0x3062
	'づ',	'du_',		# 0x3065
	'で',	'de_',		# 0x3067
	'ど',	'do_',		# 0x3069
	'ば',	'ba_',		# 0x3070
	'び',	'bi_',		# 0x3073
	'ぶ',	'bu_',		# 0x3076
	'べ',	'be_',		# 0x3079
	'ぼ',	'bo_',		# 0x307c
	'ぱ',	'pa_',		# 0x3071
	'ぴ',	'pi_',		# 0x3074
	'ぷ',	'pu_',		# 0x3077
	'ぺ',	'pe_',		# 0x307a
	'ぽ',	'po_',		# 0x307d
	'ア',	'A_',		# 0x30a2
	'イ',	'I_',		# 0x30a4
	'ウ',	'U_',		# 0x30a6
	'エ',	'E_',		# 0x30a8
	'オ',	'O_',		# 0x30aa
	'カ',	'KA_',		# 0x30ab
	'キ',	'KI_',		# 0x30ad
	'ク',	'KU_',		# 0x30af
	'ケ',	'KE_',		# 0x30b1
	'コ',	'KO_',		# 0x30b3
	'サ',	'SA_',		# 0x30b5
	'シ',	'SI_',		# 0x30b7
	'ス',	'SU_',		# 0x30b9
	'セ',	'SE_',		# 0x30bb
	'ソ',	'SO_',		# 0x30bd
	'タ',	'TA_',		# 0x30bf
	'チ',	'TI_',		# 0x30c1
	'ツ',	'TU_',		# 0x30c4
	'テ',	'TE_',		# 0x30c6
	'ト',	'TO_',		# 0x30c8
	'ナ',	'NA_',		# 0x30ca
	'ニ',	'NI_',		# 0x30cb
	'ヌ',	'NU_',		# 0x30cc
	'ネ',	'NE_',		# 0x30cd
	'ノ',	'NO_',		# 0x30ce
	'ハ',	'HA_',		# 0x30cf
	'ヒ',	'HI_',		# 0x30d2
	'フ',	'HU_',		# 0x30d5
	'ヘ',	'HE_',		# 0x30d8
	'ホ',	'HO_',		# 0x30db
	'マ',	'MA_',		# 0x30de
	'ミ',	'MI_',		# 0x30df
	'ム',	'MU_',		# 0x30e0
	'メ',	'ME_',		# 0x30e1
	'モ',	'MO_',		# 0x30e2
	'ヤ',	'YA_',		# 0x30e4
	'ユ',	'YU_',		# 0x30e6
	'ヨ',	'YO_',		# 0x30e8
	'ラ',	'RA_',		# 0x30e9
	'リ',	'RI_',		# 0x30ea
	'ル',	'RU_',		# 0x30eb
	'レ',	'RE_',		# 0x30ec
	'ロ',	'RO_',		# 0x30ed
	'ワ',	'WA_',		# 0x30ef
	'ヲ',	'WO_',		# 0x30f2
	'ン',	'N_',		# 0x30f3
	'ァ',	'AA_',		# 0x30a1
	'ィ',	'II_',		# 0x30a3
	'ゥ',	'UU_',		# 0x30a5
	'ェ',	'EE_',		# 0x30a7
	'ォ',	'OO_',		# 0x30a9
	'ャ',	'YYA_',		# 0x30e3
	'ュ',	'YYU_',		# 0x30e5
	'ョ',	'YYO_',		# 0x30e7
	'ガ',	'GA_',		# 0x30ac
	'ギ',	'GI_',		# 0x30ae
	'グ',	'GU_',		# 0x30b0
	'ゲ',	'GE_',		# 0x30b2
	'ゴ',	'GO_',		# 0x30b4
	'ザ',	'ZA_',		# 0x30b6
	'ジ',	'ZI_',		# 0x30b8
	'ズ',	'ZU_',		# 0x30ba
	'ゼ',	'ZE_',		# 0x30bc
	'ゾ',	'ZO_',		# 0x30be
	'ダ',	'DA_',		# 0x30c0
	'ヂ',	'DI_',		# 0x30c2
	'ヅ',	'DU_',		# 0x30c5
	'デ',	'DE_',		# 0x30c7
	'ド',	'DO_',		# 0x30c9
	'バ',	'BA_',		# 0x30d0
	'ビ',	'BI_',		# 0x30d3
	'ブ',	'BU_',		# 0x30d6
	'ベ',	'BE_',		# 0x30d9
	'ボ',	'BO_',		# 0x30dc
	'パ',	'PA_',		# 0x30d1
	'ピ',	'PI_',		# 0x30d4
	'プ',	'PU_',		# 0x30d7
	'ペ',	'PE_',		# 0x30da
	'ポ',	'PO_',		# 0x30dd
	'ッ',	'TTU_',		# 0x30c3
	'０',	'n0_',		# 0xff10
	'１',	'n1_',		# 0xff11
	'２',	'n2_',		# 0xff12
	'３',	'n3_',		# 0xff13
	'４',	'n4_',		# 0xff14
	'５',	'n5_',		# 0xff15
	'６',	'n6_',		# 0xff16
	'７',	'n7_',		# 0xff17
	'８',	'n8_',		# 0xff18
	'９',	'n9_',		# 0xff19
	'ａ',	'a__',		# 0x0061
	'ｂ',	'b__',		# 0x0062
	'ｃ',	'c__',		# 0x0063
	'ｄ',	'd__',		# 0x0064
	'ｅ',	'e__',		# 0x0065
	'ｆ',	'f__',		# 0x0066
	'ｇ',	'g__',		# 0x0067
	'ｈ',	'h__',		# 0x0068
	'ｉ',	'i__',		# 0x0069
	'ｊ',	'j__',		# 0x006a
	'ｋ',	'k__',		# 0x006b
	'ｌ',	'l__',		# 0x006c
	'ｍ',	'm__',		# 0x006d
	'ｎ',	'n__',		# 0x006e
	'ｏ',	'o__',		# 0x006f
	'ｐ',	'p__',		# 0x0070
	'ｑ',	'q__',		# 0x0071
	'ｒ',	'r__',		# 0x0072
	'ｓ',	's__',		# 0x0073
	'ｔ',	't__',		# 0x0074
	'ｕ',	'u__',		# 0x0075
	'ｖ',	'v__',		# 0x0076
	'ｗ',	'w__',		# 0x0077
	'ｘ',	'x__',		# 0x0078
	'ｙ',	'y__',		# 0x0079
	'ｚ',	'z__',		# 0x007a
	'Ａ',	'A__',		# 0x0041
	'Ｂ',	'B__',		# 0x0042
	'Ｃ',	'C__',		# 0x0043
	'Ｄ',	'D__',		# 0x0044
	'Ｅ',	'E__',		# 0x0045
	'Ｆ',	'F__',		# 0x0046
	'Ｇ',	'G__',		# 0x0047
	'Ｈ',	'H__',		# 0x0048
	'Ｉ',	'I__',		# 0x0049
	'Ｊ',	'J__',		# 0x004a
	'Ｋ',	'K__',		# 0x004b
	'Ｌ',	'L__',		# 0x004c
	'Ｍ',	'M__',		# 0x004d
	'Ｎ',	'N__',		# 0x004e
	'Ｏ',	'O__',		# 0x004f
	'Ｐ',	'P__',		# 0x0050
	'Ｑ',	'Q__',		# 0x0051
	'Ｒ',	'R__',		# 0x0052
	'Ｓ',	'S__',		# 0x0053
	'Ｔ',	'T__',		# 0x0054
	'Ｕ',	'U__',		# 0x0055
	'Ｖ',	'V__',		# 0x0056
	'Ｗ',	'W__',		# 0x0057
	'Ｘ',	'X__',		# 0x0058
	'Ｙ',	'Y__',		# 0x0059
	'Ｚ',	'Z__',		# 0x005a
	'0',	'h_n0_',		# 0xff10
	'1',	'h_n1_',		# 0xff11
	'2',	'h_n2_',		# 0xff12
	'3',	'h_n3_',		# 0xff13
	'4',	'h_n4_',		# 0xff14
	'5',	'h_n5_',		# 0xff15
	'6',	'h_n6_',		# 0xff16
	'7',	'h_n7_',		# 0xff17
	'8',	'h_n8_',		# 0xff18
	'9',	'h_n9_',		# 0xff19
	'a',	'h_a__',		# 0x0061
	'b',	'h_b__',		# 0x0062
	'c',	'h_c__',		# 0x0063
	'd',	'h_d__',		# 0x0064
	'e',	'h_e__',		# 0x0065
	'f',	'h_f__',		# 0x0066
	'g',	'h_g__',		# 0x0067
	'h',	'h_h__',		# 0x0068
	'i',	'h_i__',		# 0x0069
	'j',	'h_j__',		# 0x006a
	'k',	'h_k__',		# 0x006b
	'l',	'h_l__',		# 0x006c
	'm',	'h_m__',		# 0x006d
	'n',	'h_n__',		# 0x006e
	'o',	'h_o__',		# 0x006f
	'p',	'h_p__',		# 0x0070
	'q',	'h_q__',		# 0x0071
	'r',	'h_r__',		# 0x0072
	's',	'h_s__',		# 0x0073
	't',	'h_t__',		# 0x0074
	'u',	'h_u__',		# 0x0075
	'v',	'h_v__',		# 0x0076
	'w',	'h_w__',		# 0x0077
	'x',	'h_x__',		# 0x0078
	'y',	'h_y__',		# 0x0079
	'z',	'h_z__',		# 0x007a
	'A',	'h_A__',		# 0x0041
	'B',	'h_B__',		# 0x0042
	'C',	'h_C__',		# 0x0043
	'D',	'h_D__',		# 0x0044
	'E',	'h_E__',		# 0x0045
	'F',	'h_F__',		# 0x0046
	'G',	'h_G__',		# 0x0047
	'H',	'h_H__',		# 0x0048
	'I',	'h_I__',		# 0x0049
	'J',	'h_J__',		# 0x004a
	'K',	'h_K__',		# 0x004b
	'L',	'h_L__',		# 0x004c
	'M',	'h_M__',		# 0x004d
	'N',	'h_N__',		# 0x004e
	'O',	'h_O__',		# 0x004f
	'P',	'h_P__',		# 0x0050
	'Q',	'h_Q__',		# 0x0051
	'R',	'h_R__',		# 0x0052
	'S',	'h_S__',		# 0x0053
	'T',	'h_T__',		# 0x0054
	'U',	'h_U__',		# 0x0055
	'V',	'h_V__',		# 0x0056
	'W',	'h_W__',		# 0x0057
	'X',	'h_X__',		# 0x0058
	'Y',	'h_Y__',		# 0x0059
	'Z',	'h_Z__',		# 0x005a
	'＋',	'Plus__',		# 0x002b
	'，',	'comma_',		# 0xff0c
	'ー',	'bou_',			# 0x30fc
	'／',	'sura_',		# 0xff0f
	'．',	'period_',		# 0xff0e
	'（',	'MaruKako__',	# 0xff08
	'）',	'MaruKakot__',	# 0xff09
	'：',	'colon_',		# 0xff1a
	'；',	'semicolon_',	# 0xff1b
	'！',	'gyoe_',		# 0xff01
	'？',	'hate_',		# 0xff1f
	'「',	'kako_',		#				0x300c		/*  */
	'」',	'kakot_',		#				0x300d		/*  */
	'『',	'kako2_',		#				0x300e		/*  */
	'』',	'kakot2_',		#				0x300f		/*  */
	'、',	'ten_',			#				0x002e		/*  */
	'。',	'kten_',		#				0x3002		/*  */
	'…',	'tenten_',		#				0x2026		/*  */
	' ',	'h_spc_',
	'+',	'h_plus_',	# 
	',',	'h_comma_',
	'-',	'h_bou_',
	'.',	'h_period_',
	'/',	'h_sura_',
	'(',	'h_MaruKako__',
	')',	'h_MaruKakot__',
	':',	'h_colon_',
	';',	'h_semicolon_',
	'!',	'h_gyoe_',
	'?',	'h_hate_',
	'♂',	'osu_',
	'♀',	'mesu_',
	'円',	'yen_',
	'$',	'pokedoru_',
	'←',	'ArrowL__',	#		0x2190		/*  */
	'↑',	'ArrowU__',	#		0x2191		/*  */
	'→',	'ArrowR__',	#		0x2192		/*  */
	'↓',	'ArrowD__',	#		0x2193		/*  */
	'①',	'MARU1__',	#			0x2460		/*  */
	'②',	'MARU2__',	#			0x2461		/*  */
	'③',	'MARU3__',	#			0x2462		/*  */
	'④',	'MARU4__',	#			0x2463		/*  */
	'⑤',	'MARU5__',	#			0x2464		/*  */
	'⑥',	'MARU6__',	#			0x2465		/*  */
	'⑦',	'MARU7__',	#			0x2466		/*  */
	'⑧',	'MARU8__',	#			0x2467		/*  */
	'⑨',	'MARU9__',	#			0x2468		/*  */
	'×',	'times_',	#			0x2468		/*  */
	'÷',	'divide_',
	'À',	'Agrave_',	# Aアクサングラーブ 
	'Á',	'Aacute_',	# Aアクサンテギュ 
	'Â',	'Acirc_',	# Aサーカムフレックス 
	'Ã',	'Atilde_',	# Aティルド 
	'Ä',	'Auml_',	# Aウムラウト 
	'Å',	'Aring_',	# Aリング 
	'Æ',	'AElig_',	# AE合字 
	'Ç',	'Ccedil_',	# Cセディラ 
	'È',	'Egrave_',	# Eアクサングラーブ 
	'É',	'Eacute_',	# Eアクサンテギュ 
	'Ê',	'Ecirc_',	# Eサーカムフレックス 
	'Ë',	'Euml_',	# Eウムラウト 
	'Ì',	'Igrave_',	# Iアクサングラーブ 
	'Í',	'Iacute_',	# Iアクサンテギュ 
	'Î',	'Icirc_',	# Iサーカムフレックス 
	'Ï',	'Iuml_',	# Iウムラウト 
	'Ð',	'ETH_',		# 音声記号eth 
	'Ñ',	'Ntilde_',	# Nティルド 
	'Ò',	'Ograve_',	# Oアクサングラーブ 
	'Ó',	'Oacute_',	# Oアクサンテギュ 
	'Ô',	'Ocirc_',	# Oサーカムフレックス 
	'Õ',	'Otilde_',	# Oティルド 
	'Ö',	'Ouml_',	# Oウムラウト 
	'Ø',	'Oslash_',	# Oスラッシュ 
	'Ù',	'Ugrave_',	# Uアクサングラーブ 
	'Ú',	'Uacute_',	# Uアクサンテギュ 
	'Û',	'Ucirc_',	# Uサーカムフレックス 
	'Ü',	'Uuml_',	# Uウムラウト 
	'Ý',	'Yacute_',	# Yアクサンテギュ 
	'Þ',	'THORN_',	# 音声記号th 
	'ß',	'szlig_',	# sz合字 
	'à',	'agrave_',	# aアクサングラーブ 
	'á',	'aacute_',	# aアクサンテギュ 
	'â',	'acirc_',	# aサーカムフレックス 
	'ã',	'atiled_',	# aティルド 
	'ä',	'auml_',	# aウムラウト 
	'å',	'aring_',	# aリング 
	'æ',	'aelig_',	# ae合字 
	'ç',	'ccedil_',	# cセディラ 
	'è',	'egrave_',	# eアクサングラーブ 
	'é',	'eacute_',	# eアクサンテギュ 
	'ê',	'ecirc_',	# eサーカムフレックス 
	'ë',	'euml_',	# eウムラウト 
	'ì',	'igrave_',	# iアクサングラーブ 
	'í',	'iacute_',	# iアクサンテギュ 
	'î',	'icirc_',	# iサーカムフレックス 
	'ï',	'iuml_',	# iウムラウト 
	'ð',	'eth_',		# eth合字 
	'ñ',	'ntiled_',	# nティルド 
	'ò',	'ograve_',	# oアクサングラーブ 
	'ó',	'oacute_',	# oアクサンテギュ 
	'ô',	'ocirc_',	# oサーカムフレックス 
	'õ',	'otilde_',	# oティルド 
	'ö',	'ouml_',	# oウムラウト 
	'ø',	'oslash_',	# oスラッシュ 
	'ù',	'ugrave_',	# uアクサングラーブ 
	'ú',	'uacute_',	# uアクサンテギュ 
	'û',	'ucirc_',	# uサーカムフレックス 
	'ü',	'uuml_',	# uウムラウト 
	'ý',	'yacute_',	# yアクサンテギュ 
	'þ',	'thorn_',	# 音声記号th 
	'ÿ',	'yuml_',	# yウムラウト 
	'Œ',	'OElig_',	# OE合字 
	'œ',	'oelig_',	# oe合字 
	'Ş',	'Scedil_',	# Sセディラ 
	'ş',	'scedil_',	# sセディラ 
	'¡',	'rgyoe_',	# 反転！
	'¿',	'rhate_',	# 反転？
	'・',	'nakag_',	# 中黒
	'･',	'h_nakag_',	# 半角中黒
	'～',	'wave_',	# 波線
	'►',	'cursor_',	# カーソル

	'＝',	'equal_',
	'=',	'h_equal_',
	'＠',	'atmark_',	# 
	'○',	'circle_',
	'◎',	'double_circle_',
	'□',	'square_',
	'△',	'triangle_',
	'◇',	'lozenge__',
	'♪',	'note_',
	'％',	'percent_',
	'%',	'h_percent_',
	'♠',	'spade_',
	'♣',	'club_',
	'♥',	'heart_',
	'♦',	'diamond_',
	'★',	'star_',
	'☀',	'sun_',
	'☁',	'cloud_',
	'☂',	'rain_',
	'☃',	'snow_',

	'㌇',	'pocket_item',
	'㌈',	'pocket_keyitem',
	'㌉',	'pocket_wazamachine',
	'㌊',	'pocket_seal',
	'㌋',	'pocket_medicine',
	'㌌',	'pocket_nut',
	'㌍',	'pocket_ball',
	'㌎',	'pocket_battle',
	

	'㌀',	'org_face_normal_',
	'㌁',	'org_face_smile_',
	'㌂',	'org_face_cry_',
	'㌃',	'org_face_angry_',
	'㌄',	'org_upper_',
	'㌅',	'org_downer_',
	'㌆',	'org_sleep_',

	'‘',	'us__quote1_',
	'’',	'us_quote1d_',		# 0x2019
	'“',	'us_quote2_',
	'”',	'us_quote2d_',
	'\'',	'us_h_quote1_',
	'"',	'us_h_quote2_',
	'„',	'ger_quote2_',
	'‚',	'ger_quote1_',
	'«',	'fre_quote_',
	'»',	'fre_quoted_',
	'<',	'h_osu_',
	'>',	'h_mesu_',

	'▼',	'charcode_reserve1_',
	'▽',	'charcode_reserve2_',
	'■',	'charcode_reserve3_',

);

#-------------------------------------------------------
# コメント定義
# Ｃソースになった時のコメント。
# 定義しない文字は、その文字がそのままコメントになる。
#(shift-jisで表記できないものは必ずここで定義すること）
#-------------------------------------------------------
my %CodeCommentTbl = (
	'À',	'Aアクサングラーブ ',
	'Á',	'Aアクサンテギュ ',
	'Â',	'Aサーカムフレックス ',
	'Ã',	'Aティルド ',
	'Ä',	'Aウムラウト ',
	'Å',	'Aリング ',
	'Æ',	'AE合字 ',
	'Ç',	'Cセディラ ',
	'È',	'Eアクサングラーブ ',
	'É',	'Eアクサンテギュ ',
	'Ê',	'Eサーカムフレックス ',
	'Ë',	'Eウムラウト ',
	'Ì',	'Iアクサングラーブ ',
	'Í',	'Iアクサンテギュ ',
	'Î',	'Iサーカムフレックス ',
	'Ï',	'Iウムラウト ',
	'Ð',	'音声記号eth ',
	'Ñ',	'Nティルド ',
	'Ò',	'Oアクサングラーブ ',
	'Ó',	'Oアクサンテギュ ',
	'Ô',	'Oサーカムフレックス ',
	'Õ',	'Oティルド ',
	'Ö',	'Oウムラウト ',
	'Ø',	'Oスラッシュ ',
	'Ù',	'Uアクサングラーブ ',
	'Ú',	'Uアクサンテギュ ',
	'Û',	'Uサーカムフレックス ',
	'Ü',	'Uウムラウト ',
	'Ý',	'Yアクサンテギュ ',
	'Þ',	'音声記号th ',
	'ß',	'sz合字 ',
	'à',	'aアクサングラーブ ',
	'á',	'aアクサンテギュ ',
	'â',	'aサーカムフレックス ',
	'ã',	'aティルド ',
	'ä',	'aウムラウト ',
	'å',	'aリング ',
	'æ',	'ae合字 ',
	'ç',	'cセディラ ',
	'è',	'eアクサングラーブ ',
	'é',	'eアクサンテギュ ',
	'ê',	'eサーカムフレックス ',
	'ë',	'eウムラウト ',
	'ì',	'iアクサングラーブ ',
	'í',	'iアクサンテギュ ',
	'î',	'iサーカムフレックス ',
	'ï',	'iウムラウト ',
	'ð',	'eth合字 ',
	'ñ',	'nティルド ',
	'ò',	'oアクサングラーブ ',
	'ó',	'oアクサンテギュ ',
	'ô',	'oサーカムフレックス ',
	'õ',	'oティルド ',
	'ö',	'oウムラウト ',
	'ø',	'oスラッシュ ',
	'ù',	'uアクサングラーブ ',
	'ú',	'uアクサンテギュ ',
	'û',	'uサーカムフレックス ',
	'ü',	'uウムラウト ',
	'ý',	'yアクサンテギュ ',
	'þ',	'音声記号th ',
	'ÿ',	'yウムラウト ',
	'Œ',	'OE合字 ',
	'œ',	'oe合字 ',
	'Ş',	'Sセディラ ',
	'ş',	'sセディラ ',
	'¡',	'反転！',
	'¿',	'反転？',
	'①',	'マル数字１',
	'②',	'マル数字２',
	'③',	'マル数字３',
	'④',	'マル数字４',
	'⑤',	'マル数字５',
	'⑥',	'マル数字６',
	'⑦',	'マル数字７',
	'⑧',	'マル数字８',
	'⑨',	'マル数字９',
	'$',	'ポケドル',
	'‘',	'英語全角引用符（開き）／独語引用符（閉じ）',
	'’',	'英語全角引用符（閉じ）／アポストロフィー',
	'“',	'英語全角２重引用符（開き）／独語２重引用符（閉じ）',
	'”',	'英語全角２重引用符（閉じ）',
	'\'',	'英語半角引用符／アポストロフィー',
	'"',	'英語半角２重引用符',
	'‚',	'独語引用符（開き）',
	'„',	'独語２重引用符（開き）',
	'«',	'仏語引用符（開き）',
	'»',	'仏語引用符（閉じ）',
	'►',	'カーソル',

	'♠',	'トランプのスペード',
	'♣',	'トランプのクラブ',
	'♥',	'トランプのハート',
	'♦',	'トランプのダイヤ',
	'★',	'星形',
	'☀',	'晴れマーク',
	'☁',	'くもりマーク',
	'☂',	'雨マーク',
	'☃',	'雪マーク',
	'㌇',	'ポケットアイコン：どうぐ',
	'㌈',	'ポケットアイコン：だいじなもの',
	'㌉',	'ポケットアイコン：わざマシン',
	'㌊',	'ポケットアイコン：シール',
	'㌋',	'ポケットアイコン：くすり',
	'㌌',	'ポケットアイコン：きのみ',
	'㌍',	'ポケットアイコン：モンスターボール',
	'㌎',	'ポケットアイコン：戦闘用',
	'㌀',	'顔マーク：すまし',
	'㌁',	'顔マーク：えがお',
	'㌂',	'顔マーク：泣き',
	'㌃',	'顔マーク：怒り',
	'㌄',	'上カーブやじるし',
	'㌅',	'下カーブやじるし',
	'㌆',	'熟睡マーク',


);


my $Letters = "";

#=======================================================
# 文字オーダーデータゲット
#
# input 0: 文字オーダー定義ファイルパス（xlorファイル）
#
# return   文字が配置順に並んだutf16-le文字列
#          失敗なら空文字列
#
#=======================================================
sub  get {
	my $filename = shift;
	my $data;
	

	if( open(ORDERFILE, "<$filename") )
	{
		my @stat = stat(ORDERFILE);
		read(ORDERFILE, $data, $stat[7]);
		close(ORDERFILE);
	}
	else
	{
		return "";
	}

	$Letters = "";

# パーサにかけて $Letters に対象文字を順番に格納する
	my $parser = new XML::Parser;

	$parser->setHandlers(	Start => \&StartHandler,
							End => \&EndHandler,
							Char => \&CharHandler
						);

	$parser->parse( $data );

	$Letters = &tool::enc_u16($Letters);

#	my $t = $Letters;
#	Encode::from_to($t, 'utf16-le', 'shift-jis');
#	print "[$t]\n";

	return $Letters;

}

#=======================================================
# 文字オーダー順 enum 定義ファイルを出力
#=======================================================
sub enumcode_output {
	$filename = shift;

	my $letter;
	my $code;
	my $str;
	my $info;
	my $len;
	my $u16_scode;

	my $letterMax = length($Letters) / 2;

	if( open(ENUMFILE, ">$filename") )
	{
		my $def_symbol = make_def_symbol($filename);


		print ENUMFILE &tool::enc_sjis("#ifndef $def_symbol\n");
		print ENUMFILE &tool::enc_sjis("#define $def_symbol\n");
		print ENUMFILE &tool::enc_sjis("enum {\n");
		print ENUMFILE &tool::enc_sjis("\tEOM_ = 0xffff,\n");
		for(my $i = 0; $i < $letterMax; $i++)
		{
			$letter = substr($Letters, $i*2, 2);

			$u16_scode = ord(substr($letter,0,1)) + ord(substr($letter,1,1))*256;

			if($u16_scode == NULL_VALUE)
			{
				next;
			}

			Encode::from_to($letter, 'utf16-le', 'utf8');

			if( $EnumCodeTbl{$letter} ne "" )
			{
				if($CodeCommentTbl{$letter} eq "")
				{
					$info = "\"$letter\"";
				}
				else
				{
					$info = $CodeCommentTbl{$letter};
				}
				$str = sprintf("\t$EnumCodeTbl{$letter} = 0x%02x,", ($i+1));

				print ENUMFILE &tool::enc_sjis($str);

				$len = 16 - length($str);
				while($len > 0)
				{
					print ENUMFILE " ";
					$len--;
				}
				print ENUMFILE &tool::enc_sjis("//\t$info\n");

				$u16_scode = sprintf ( "scode= 0x%04x\n", $u16_scode);
				print $u16_scode;
			}
			else
			{
				print ("enum file make error!\n");
				printf("[$i th charcter = ");
				$u16_scode = sprintf ( "0x%04x]\n", $u16_scode);
				print $u16_scode;
				close(ENUMFILE);
				return;
			}
		}
		print ENUMFILE &tool::enc_sjis("\tSTRCODE_END,\n");
		print ENUMFILE &tool::enc_sjis("};\n\n");
		print ENUMFILE &tool::enc_sjis("#endif\n");
		close(ENUMFILE);
		print "-> $filename\n";
	}
	else
	{
		die("$filename 作成できない");
	}

}

#==============================================================
# XML タグ開始ハンドラ
# <order> 中に現れた <sp> タグで半角スペースをLettersに追加
#==============================================================
sub StartHandler {
	my $expat = shift;
	my $tag = shift;
	my %elems = ();
	my @ary;

	for(my $i = 0; $i < @_; $i += 2)
	{
		$elems{$_[$i]} = $_[$i+1];
	}

	@ary = @{$expat->{Context}};
	if( $ary[ @ary-1 ] eq "order" )
	{
		if( $tag eq "sp" )
		{
			$Letters .= " ";
		}
		if ($tag eq "null")
		{
			$Letters .= pack('H', $NULL_STR);
		}
	}

}
#==============================================================
# XML タグ終了ハンドラ
# 特に何もしていない
#==============================================================
sub EndHandler {
	my $expat = shift;
	my $tag = shift;

}
#==============================================================
# XML タグ要素ハンドラ
# <order>要素はタブ・半角スペースをカットして全てLettersに追加
#==============================================================
sub CharHandler {
	my $expat = shift;
	my $tag = shift;
	my @ary;

	@ary = @{$expat->{Context}};
	if( $ary[ @ary-1 ] eq "order" )
	{
		$tag =~ s/[ \t\n]//g;
		if($tag ne ""){
			$Letters .= $tag;
		}
	}
}

#==============================================================
# ヘッダの多重インクルード防止定義用文字列を作成
# input 0 : ファイル名
#==============================================================
sub make_def_symbol {
	my $name = shift;
	$name = &tool::get_filename_from_path( $name );

	$name = uc($name);
	$name =~ s/[\.]/_/g;
	$name = '__' . $name . '__';
	return $name;
}


return 1;
