//============================================================================================
/**
 * @file	bag.h
 * @bfief	obOʏ
 * @author	Hiroyuki Nakamura
 * @date	05.08.03
 */
//============================================================================================
#ifndef BAG_H
#define BAG_H
#undef GLOBAL
#ifdef BAG_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
#include "application/bag_def.h"

typedef struct _BAG_DATA	BAG_DATA;

enum {
	BAG_MODE_FIELD = 0,
	BAG_MODE_BATTLE,
	BAG_MODE_ITEMSET,
	BAG_MODE_ITEMSALE,
	BAG_MODE_KINOMI,
};

enum {
	BAG_RET_USE = 0,
	BAG_RET_TAG,
	BAG_RET_ITEMSET,		// j[uv
	BAG_RET_POKEITEMSET,	// |PXguv
	BAG_RET_CANCEL
};


//============================================================================================
//	O[oϐ
//============================================================================================
#ifndef BAG_H_GLOBAL
GLOBAL const PROC_DATA BagProcData;		// vZX`f[^
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃f[^̈m
 *
 * @param	mode	擾[h
 *
 * @return	mۂ̈̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL BAG_DATA * BagSystemDataAlloc( u8 mode );
GLOBAL u32 BagSystemDataSizeGet(void);

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̏f[^쐬
 *
 * @param	dat		f[^ݒꏊ
 * @param	page	y[W
 * @param	mode	obOʂ̖
 * @param	mysy	MYSTATUS
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagSystemDataSet( BAG_DATA * dat, u8 page, u8 mode, void * myst );

//--------------------------------------------------------------------------------------------
/**
 * |Pbgf[^쐬
 *
 * @param	dat		obOʂ̃f[^
 * @param	item	QƂACef[^
 * @param	type	|Pbg^Cv
 * @param	poke	|Pbgԍ
 * @param	cur		J[\ʒu
 * @param	scr		XN[JE^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagPocketDataMake(
				BAG_DATA * dat, MINEITEM * item, u8 type, u8 poke, u16 cur, u16 scr );

//--------------------------------------------------------------------------------------------
/**
 * ]ԃtOZbg
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagCycleFlagSet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * nړ`FbNtOZbg
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagUnderCheckFlagSet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾F݂̃|Pbgԍ
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	݂̃|Pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BagSysNowPocketNumGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOʂ̖
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOʂ̖
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BagSysModeGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOŎ擾ACe
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOŎ擾ACe
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 BagSysReturnItemGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobO̖߂l
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obO̖߂l
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 BagSysReturnModeGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾F
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BagSysMyGoldGet( BAG_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FJ[\ʒuAXN[JE^
 *
 * @param	dat		obOʂ̃f[^
 * @param	poke	|Pbgԍ
 * @param	cur		J[\ʒu
 * @param	scr		XN[JE^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagCursorPosGet( BAG_DATA * dat, u8 poke, u16 * cur, u16 * scr );





#undef GLOBAL
#endif	/* BAG_H */
