//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_poke_obj.h
 *	@brief		C[WNbv|P f[^
 *	@author		tomoya takahashi
 *	@data		2005.09.26
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#ifndef __IMC_POKE_OBJ_H__
#define __IMC_POKE_OBJ_H__

#include "system.h"
#include "system/gamedata.h"
#include "touchpanel.h"
#include "system/softsprite.h"
#include "poketool/poke_tool.h"
#include "include/application/imageClip/imc_drawsys.h"

#undef GLOBAL
#ifdef	__IMC_POKE_OBJ_H_GLOBAL
#define	GLOBAL	/* */
#else
#define	GLOBAL	extern
#endif

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_POKE_INIT_X			(188)
#define IMC_POKE_INIT_Y			(56)
#define	IMC_POKE_DEFAULT_PRI	(0)

#define	IMC_POKE_ANM_NUM		(2)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	Hł悢TCYe[u
//	
//=====================================
typedef struct {
	u16	x_no;
	u16	y_no;
} IMC_POKE_INS_DAT;

//-------------------------------------
//	
//	C[WNbv|P\
//	
//=====================================
typedef struct {
	SOFT_SPRITE*		sprite;		// XvCgf[^

	TP_HIT_TBL hit_tbl;	// 蔻f[^
	
	u8	ins_x;			// pbgɐHł悢TCYX
	u8	ins_y;			// pbgɐHł悢TCYY
	
	// |Pf[^
	POKEMON_PARAM* poke_para;

} IMC_POKE;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P̃LN^f[^`VXeɓo^
 *
 *	@param	poke_para		|Pp[^\
 *	@param	drawData		`VXef[^
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_CharSet( IMC_DRAW_DATA* drawData, SOFT_SPRITE_ARC* arc_data );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv@|Pf[^쐬
 *
 *	@param	poke			C[WNbv@|Pf[^
 *	@param	sprite_man		\tgEFAXvCg}l[W
 *	@param	poke_para		|Pp[^\
 *	@param	arc_data		A[JCut@Cf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_Init( IMC_POKE* poke,  SOFT_SPRITE_MANAGER* sprite_man, POKEMON_PARAM* poke_para, SOFT_SPRITE_ARC* arc_data );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv@|Pf[^j
 *
 *	@param	poke			C[WNbv@|Pf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_Delete( IMC_POKE* poke );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\D揇ʂݒ
 *
 *	@param	poke		|Pf[^
 *	@param	priority	D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_DrawPrioritySet( IMC_POKE* poke, int priority );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\D揇ʂ擾
 *
 *	@param	poke		|Pf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL int IMC_POKE_DrawPriorityGet( IMC_POKE* poke );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Wݒ
 *
 *	@param	poke		|Pf[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_MatrixSet( IMC_POKE* poke, int x, int y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PW擾
 *
 *	@param	poke		|Pf[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_MatrixGet( IMC_POKE* poke, int* x, int* y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PTCY擾
 *
 *	@param	poke		|Pf[^
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_SizeGet( IMC_POKE* poke, int* x, int* y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pƃ^b`pl̓蔻
 *
 *	@param	poke	|Pf[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_POKE_TPHit( IMC_POKE* poke );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PƎwW̓蔻
 *
 *	@param	poke	|Pf[^
 *	@param	x		W
 *	@param	y		W
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_POKE_TPHitSelf( IMC_POKE* poke, int x, int y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻ׂs
 *
 *	@param	poke		IuWFNgf[^
 *	@param	offs_x		ォ̃ItZbgW
 *	@param	offs_y		ォ̃ItZbgW
 *	@param	char_data	LN^f[^	
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ	iItZbgWsj
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_POKE_TPHitEx( IMC_POKE* poke, int* offs_x, int* offs_y, NNSG2dCharacterData* char_data );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻ׂs	Ww
 *
 *	@param	poke		IuWFNgf[^
 *	@param	x			ォ̃ItZbgW
 *	@param	y			ォ̃ItZbgW
 *	@param	char_data	LN^f[^	
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ	iItZbgWsj
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL BOOL IMC_POKE_TPHitExSelf( IMC_POKE* poke, int x, int y, NNSG2dCharacterData* char_data );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P̐Hł悢TCY擾
 *
 *	@param	poke		IuWFNgf[^
 *	@param	ins_x		Hł悢TCY擾̈
 *	@param	ins_y		Hł悢TCY擾̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
GLOBAL void IMC_POKE_InSizeGet( IMC_POKE* poke, int* ins_x, int* ins_y );


#undef	GLOBAL
#endif		// __IMC_POKE_OBJ_H__
