//============================================================================================
/**
 * @file	p_status.h
 * @brief	|PXe[^X
 * @author	Hiroyuki Nakamura
 * @date	2005.10.26
 */
//============================================================================================
#ifndef P_STATUS_H
#define P_STATUS_H
#undef GLOBAL
#ifdef P_STATUS_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
typedef struct {
	void * ppd;		// |Pf[^

	u8	ppt;		// p[^^Cv
	u8	mode;		// [h
	u8	max;		// ő吔
	u8	pos;		// Ԗڂ̃f[^

	u8	page_flg;	// y[WtO
	u8	ret_sel;	// IꂽZʒu
	u8	ret_mode;
	u16	waza;
}PSTATUS_DATA;

// [h
enum {
	PST_MODE_NORMAL = 0,	// ʏ
	PST_MODE_WAZAADD,		// Zo/ZY
	PST_MODE_PORUTO,		// |ggp
	PST_MODE_CONDITION,		// RfBVύXf
};

// p[^^Cv
enum {
	PST_PP_TYPE_POKEPARAM = 0,		// POKEMON_PARAM
	PST_PP_TYPE_POKEPARTY,			// POKEPARTY
	PST_PP_TYPE_POKEPASO,			// POKEMON_PASO_PARAM
};

// ߂
enum {
	PST_RET_DECIDE = 0,
	PST_RET_CANCEL,
};


// y[WID
enum {
	PST_PAGE_INFO = 0,		// u|P傤قv
	PST_PAGE_MEMO,			// ug[i[v
	PST_PAGE_PARAM,			// u|P̂傭v
	PST_PAGE_CONDITION,		// uRfBVv
	PST_PAGE_B_SKILL,		// u킴v
	PST_PAGE_C_SKILL,		// uReXg킴v
	PST_PAGE_RET,			// uǂv
	PST_PAGE_MAX
};

enum {
	ST_ICON_POKERUS = 0,	// |PX
	ST_ICON_MAHI,			// 
	ST_ICON_KOORI,			// X
	ST_ICON_NEMURI,			// 
	ST_ICON_DOKU,			// 
	ST_ICON_YAKEDO,			// Ώ
	ST_ICON_HINSI,			// m

	ST_ICON_NONE,			// ԈُȂ
};


//============================================================================================
//	O[oϐ
//============================================================================================
#ifndef P_STATUS_H_GLOBAL
GLOBAL const PROC_DATA PokeStatusProcData;	// vZX`f[^
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * y[W쐬
 *
 * @param	dat		Xe[^Xʃf[^
 * @param	tbl		y[We[u
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void PokeStatus_PageSet( PSTATUS_DATA * dat, const u8 * tbl );

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR̃A[JCuCfbNX擾iLj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BadStatusIconCharArcGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR̃A[JCuCfbNX擾ipbgj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BadStatusIconPlttArcGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR̃A[JCuCfbNX擾iZj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BadStatusIconCellArcGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR̃A[JCuCfbNX擾iZAjj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BadStatusIconCanmArcGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ԈُACR̃Ajԍ擾
 *
 * @param	pp		|Pf[^
 *
 * @return	Ajԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BadStatusIconAnmGet( POKEMON_PARAM * pp );


#undef GLOBAL
#endif	/* P_STATUS_H */
