/**
 *	@file	poru_tool.h
 *	@brief	|gc[
 *	@author	Miyuki Iwasawa
 *	@date	06.03.14
 */

#ifndef __H_PORU_TOOL_H__
#define __H_PORU_TOOL_H__

#include "savedata/savedata_def.h"
#include "savedata/poruto_util.h"
#include "savedata/mystatus.h"
#include "system/gamedata.h"
#include "itemtool/myitem.h"
#include "poketool/pokeparty.h"
#include "application/p_status.h"
#include "application/pokelist.h"

///|gf[^Xg\
typedef struct _PORU_LIST{
	u8	id;			///f[^ID
	u8	level;		///<|g̃x
	u8	flavor;		///<|g̎
	u8	taste;		///<Ȃ߂炩

	union{
		struct{
		u8	spicy:1;	///<Ă閡
		u8	astr:1;
		u8	sweet:1;
		u8	bitter:1;
		u8	sour:1;
		u8	view:1;	///<`tO
		u8	del:1;		///<폜tO
		u8	valid:1;	///<L/tO
		};
		u8 flags;
	};
	u8	myid;
	u8	prev;
	u8	next;

	STRBUF	*lvbuf;
}PORU_LIST;

///|gĂяo[N
typedef struct _PORUTO_PARAM{
	u8		porunum;	///<Ăяõ|g̐
	u8		selID;
	u16		ret_mode;	///<^[l
	u16		listPos;	///<Xg|WV
	u16		curPos;		///<J[\|WV
	
	PORUTO_BLOCK* poruSave;	///<|gZ[uf[^
	MYSTATUS	*mySave;	///<Xe[^X
	POKEPARTY	*ppSave;	///<|Pp[eB
	MYITEM		*itemSave;	///<ACe

	PORU_LIST	list[PORUTO_STOCK_MAX];	///<f[^
}PORUTO_PARAM;

///I[o[CvZXOQƐ錾
extern const PROC_DATA PorutoSysProcData;

/**
 *	@brief	|gVXeĂяo[Nf[^쐬
 *
 *	K PorutoSys_ReleaseCallWork()֐ŉ邱ƁI
 */
extern PORUTO_PARAM* PorutoSys_CreateCallWork(SAVEDATA* savedata,int heapID);

/**
 *	@brief	|gP[XĂяo[N
 */
extern void PorutoSys_ReleaseCallWork(PORUTO_PARAM* pp);

#endif	//__H_PORU_TOOL_H__

