#ifndef	_TRAINER_CARD_H_
#define _TRAINER_CARD_H_

#include "common.h"
#include "system/procsys.h"
#include "system/buflen.h"
#include "system/mystatus.h"

typedef enum{
	TR_CARD_RANK_NORMAL,
	TR_CARD_RANK_BRO,
	TR_CARD_RANK_KAP,
	TR_CARD_RANK_SIL,
	TR_CARD_RANK_GOL,
	TR_CARD_RANK_BLACK,
}TR_CARD_RANK;

extern  const PROC_DATA TrCardProcData;		// vZX`f[^
extern PROC_RESULT TrCardProc_Init( PROC * proc, int * seq );
extern PROC_RESULT TrCardProc_Main( PROC * proc, int * seq );
extern PROC_RESULT TrCardProc_End( PROC * proc, int * seq );

typedef struct TR_BADGE_DATA_tag
{
	u8 GymReaderNo;			//W[_[ʃio[
	u8 BadgeType;			//obWʃio[
	u8 BadgeLevel;			//obWx
	u8 BadgeHold;			//obWtO
	int BadgeScruchCount;	//
	
}TR_BADGE_DATA;

typedef struct TR_CARD_DATA_tag
{
	u8 Version;
	u8 CardRank;
	u8 BrushValid;		//obWAvLtO
	u8 TrSex;
	const STRCODE *TrainerName;
	u32 Money;
	u32 PokeBook;
	u32 Score;
	u16 TrainerID;
	u16 PlayTime_h;
	u8 PlayTime_m;
	u8 PlayTime_s;
	u16 StartTime_h;
	u8 StartTime_m;
	u8 StartTime_s;
	u16 ClearTime_h;
	u8 ClearTime_m;
	u8 ClearTime_s;
	
	u32 CommNum;
	u32 CommBattleWin;
	u32 CommBattleLose;
	u32 CommTrade;
	TR_BADGE_DATA	BadgeData[8];

}TR_CARD_DATA;
/**
extern TR_CARD_DATA *MakeTrainerCardData(	const u8 inBadgeBrushFlg,
											const u8 inVersion,
											const u8 inCardRank,
											const MYSTATUS *inMyStatus,
											const int inMoney,
											const int inBook,
											const int inScore,
											const int inStartTime,
											const int inClearTime,
											const int inCommNum,
											const int inBtlWin,
											const int inBtlLose,
											const int inTrade,
											const u16 inHeapID);
*/
#endif //_TRAINER_CARD_H_
