
//============================================================================================
/**
 * @file	fight_tool.h
 * @bfief	퓬VXepc[vO
 * @author	HisashiSogabe
 * @date	05.07.22
 */
//============================================================================================

#ifndef __FIGHT_TOOL_H_
#define __FIGHT_TOOL_H_

#include	"battle/battle_common.h"
#include	"poketool/poke_tool.h"
#include	"poketool/pokeparty.h"
#include	"system/softsprite.h"
#include	"system/clact_tool.h"
#include	"wazaeffect/we_mana.h"
#include	"battle/battle_input.h"
#include	"system/numfont.h"
#include	"battle/ground.h"
#include	"system/mystatus.h"
#include	"system/msgdata.h"
#include	"system/palanm.h"
#include	"system/wordset.h"

extern	GF_BGL_INI			*BattleWorkGF_BGL_INIGet(BATTLE_WORK *bw);
extern	GF_BGL_BMPWIN		*BattleWorkGF_BGL_BMPWINGet(BATTLE_WORK *bw);
extern	u32					BattleWorkFightTypeGet(BATTLE_WORK *bw);
extern	SERVER_PARAM		*BattleWorkServerParamGet(BATTLE_WORK *bw);
extern	CLIENT_PARAM		*BattleWorkClientParamGet(BATTLE_WORK *bw,int client_no);
extern	int					BattleWorkClientSetMaxGet(BATTLE_WORK *bw);
extern	POKEPARTY			*BattleWorkPokePartyGet(BATTLE_WORK *bw,int client_no);
extern	int					BattleWorkPokeCountGet(BATTLE_WORK *bw,int client_no);
extern	POKEMON_PARAM		*BattleWorkPokemonParamGet(BATTLE_WORK *bw,int client_no,int sel_mons_no);
extern	SOFT_SPRITE_MANAGER	*BattleWorkSoftSpriteManagerGet(BATTLE_WORK *bw);
extern	WE_SYS_PTR			BattleWorkWE_SYS_PTRGet(BATTLE_WORK *bw);
extern	CATS_SYS_PTR		BattleWorkCATS_SYS_PTRGet(BATTLE_WORK *bw);
extern	CATS_RES_PTR		BattleWorkCATS_RES_PTRGet(BATTLE_WORK *bw);
extern	GROUND_WORK			*BattleWorkGroundWorkGet(BATTLE_WORK *bw,int ground_no);
extern	BI_PARAM_PTR		BattleWorkGF_BGL_BIPGet(BATTLE_WORK *bw);
extern	NUMFONT				*BattleWorkGF_BGL_NumFontHPGet(BATTLE_WORK *bw);
extern	NUMFONT				*BattleWorkGF_BGL_NumFontLVGet(BATTLE_WORK *bw);
extern	MSGDATA_MANAGER		*BattleWorkFightMsgGet(BATTLE_WORK *bw);
extern	MSGDATA_MANAGER		*BattleWorkAttackMsgGet(BATTLE_WORK *bw);
extern	PALETTE_FADE_PTR	BattleWorkPfdGet(BATTLE_WORK *bw);
extern	u8					*BattleWorkSioSendBufGet(BATTLE_WORK *bw);
extern	u8					*BattleWorkSioRecvBufGet(BATTLE_WORK *bw);
extern	u16					*BattleWorkSioSendReadGet(BATTLE_WORK *bw);
extern	u16					*BattleWorkSioSendWriteGet(BATTLE_WORK *bw);
extern	u16					*BattleWorkSioSendOverGet(BATTLE_WORK *bw);
extern	u16					*BattleWorkSioRecvReadGet(BATTLE_WORK *bw);
extern	u16					*BattleWorkSioRecvWriteGet(BATTLE_WORK *bw);
extern	u16					*BattleWorkSioRecvOverGet(BATTLE_WORK *bw);
extern	EXCHR_PARAM			*BattleWorkExChrParamGet(BATTLE_WORK *bw);
extern	WORDSET				*BattleWorkWORDSETGet(BATTLE_WORK *bw);
extern	STRBUF				*BattleWorkSTRBUFGet(BATTLE_WORK *bw);
extern	u16					BattleWorkTrainerIDGet(BATTLE_WORK *bw,int client_no);
extern	MYSTATUS			*BattleWorkMyStatusGet(BATTLE_WORK *bw,int client_no);
extern	MYITEM				*BattleWorkMyItemGet(BATTLE_WORK *bw);
extern	u32					BattleWorkMySexGet(BATTLE_WORK *bw,int client_no);
extern	u8					BattleWorkClientTypeGet(BATTLE_WORK *bw,int client_no);
extern	u8					BattleWorkMineEnemyCheck(BATTLE_WORK *bw,int client_no);
extern	void				*BattleWorkMsgIconGet(BATTLE_WORK *bw);
extern	BOX_DATA			*BattleWorkBoxDataGet(BATTLE_WORK *bw);
extern	int					BattleWorkGroundIDGet(BATTLE_WORK *bw);
extern	int					BattleWorkBGIDGet(BATTLE_WORK *bw);
extern	int					BattleWorkPartnerClientNoGet(BATTLE_WORK *bw,int client_no);
extern	BOOL				BattleWorkStatusRecover(BATTLE_WORK *bw,int client_no,int sel_mons_no,int waza_pos,int item_no);
extern	u32					BattleWorkBattleStatusFlagGet(BATTLE_WORK *bw);

extern	EXCHR_PARAM			*BattleWorkExChrClientParamGet(BATTLE_WORK *bw, int no);
extern	u8					*ExChrParamExChrBufferGet(EXCHR_PARAM *ep,int no);
extern	int					ExChrParamPalIndexGet(EXCHR_PARAM *ep,int no);
extern	void				ExChrParamPalIndexSet(EXCHR_PARAM *ep,int no,int data);
extern	int					ExChrParamHeightGet(EXCHR_PARAM *ep,int no);
extern	void				ExChrParamHeightSet(EXCHR_PARAM *ep,int no,int data);

extern	void				BattleWorkProcModeSet(BATTLE_WORK *bw,int mode);
extern	void				BattleWorkTSSSeqNoAdrsSet(BATTLE_WORK *bw,u8 *seq_no);
extern	void				BattleWorkTSRSeqNoAdrsSet(BATTLE_WORK *bw,u8 *seq_no);
extern	void				BattleWorkTSSSeqNoSet(BATTLE_WORK *bw,u8 seq_no);
extern	void				BattleWorkTSRSeqNoSet(BATTLE_WORK *bw,u8 seq_no);
extern	void				BattleWorkFightEndFlagSet(BATTLE_WORK *bw,u8 data);
extern	void				BattleWorkGaugeOn(BATTLE_WORK *bw);
extern	void				BattleWorkGaugeOff(BATTLE_WORK *bw);

extern	void				BattleClientNoBufMake(BATTLE_WORK *bw,u8 *buf);
extern	void				BattleClientTypeBufMake(BATTLE_WORK *bw,u8 *buf);
extern	void				BattleSoftSpriteBufMake(BATTLE_WORK *bw,SOFT_SPRITE **buf);

extern	void				BattleGaugePriSet(BATTLE_WORK *bw,int pri);
extern	u32					CalcLosePenalty(POKEPARTY *ppt,MYSTATUS *my_status);

extern	void				FT_ZukanFlagSetSee(BATTLE_WORK *bw,int client_no);
extern	void				FT_ZukanFlagSetGet(BATTLE_WORK *bw,int client_no);
extern	BOOL				FT_ZukanFlagCheckGet(BATTLE_WORK *bw,int mons_no);

extern	void				BattleDefaultBlendSet(void);

extern	u8					TrainerMSG_Print(BATTLE_WORK *bw,GF_BGL_BMPWIN *win,int tr_id,int msg_type,int wait);
extern	u8					BattleMSG_Print(BATTLE_WORK *bw,GF_BGL_BMPWIN *win,MSGDATA_MANAGER *msg_m,MESSAGE_PARAM *mp,int wait);

extern	u32					No2Bit(int no);
extern	int					Bit2No(u32 bit);

#endif __FIGHT_TOOL_H_
