//=============================================================================
/**
 * @file	comm_system.h
 * @brief	ʐMVXe
 * @author	Katsumi Ohno
 * @date    2005.07.08
 */
//=============================================================================

#ifndef _COMM_SYSTEM_H_
#define _COMM_SYSTEM_H_


#include "gflib/tcb.h" //TCB_PTR̂
#include "savedata/mystatus.h"

//==============================================================================
// extern錾
//==============================================================================

// Kvȃ[NTCYԂ܂ AllocēnĂ
extern u32 CommGetWorkSize(void);
//e@̏܂BȂɂq@҂܂
#if PM_DEBUG
extern BOOL CommParentModeInit(BOOL bAlloc, int serviceNo, int regulationNo, int soloDebugNo, BOOL bTGIDChange, int packetSizeMax);
#else
extern BOOL CommParentModeInit(BOOL bAlloc, int serviceNo, int regulationNo, BOOL bTGIDChange, int packetSizeMax);
#endif
// q@̏܂Bɐe@Tɍs܂
#if PM_DEBUG
extern BOOL CommChildModeInit(BOOL bAlloc, int serviceNo, int regulationNo, int soloDebugNo, BOOL bBconInit, int packetSizeMax);
#else
extern BOOL CommChildModeInit(BOOL bAlloc, int serviceNo, int regulationNo, BOOL bBconInit, int packetSizeMax);
#endif

/// ܂ǃobt@NA
extern void CommSystemReset(void);

/// ʐMI
extern void CommFinalize(void);
// e@̐Ԃ܂
extern int CommGetParentCount(void);
// e@݂ȂĂ䐔Ԃ
extern int CommGetParentConnectionNum(int index);
// e@̃XLXgɍXVꍇTRUE
extern BOOL CommIsScanListChange(void);
// q@@f[^VFAOԂŐڑ-- CC_CONNECT_STARTINGAĂ琬ł
extern int CommChildNameAndIDConnect(STRBUF* pStrBuff, u32 pokeID);
// q@@f[^VFAOԂŐڑ-- TRUEAĂ琬ł
extern BOOL CommChildIndexConnect(u16 index);
// q@ e@BCOÑ^CAEgĎ܂
extern void CommParentBconCheck(void);
// MM̏s܂BVBlankɓĂĂт܂傤
extern BOOL CommUpdateData(void);
// MR[obNq@p
extern void CommRecvCallback(u16 aid, u16 *data, u16 size);
/// MR[obNe@p
extern void CommRecvParentCallback(u16 aid, u16 *data, u16 size);

// ԂɂĒʐMɕKvȏ
extern void CommStateProcess(TCB_PTR tcb, void* work);
// ʐMǂԂ
extern BOOL CommIsConnect(u16 netID);
// Mobt@̎cʂ𒲂ׂ܂
extern int CommGetSendRestSize(void);
// T[ȏMobt@̎cʂ𒲂ׂ܂
extern int CommGetSendRestSize_ServerSide(void);
// Mf[^ɖړĨR}h邩ǂ
extern BOOL CommGetRecvData_ServerSide(int netID,int chkCommand, int* retSize, u8* data);
// ڑl𒲂ׂ܂
extern int CommGetConnectNum(void);
/// Ă邩ǂ𒲂ׂ܂
extern BOOL CommIsInitialize(void);
/// ʐM؂ւsieq]ɕKvȏj
extern BOOL CommSwitchParentChild(void);

/// pbhgK[Ԃ
extern u16 CommGetPadTrg(int netID);
/// pbhRg[Ԃ
extern u16 CommGetPadCont(int netID);

// e@EtOZbg
extern void CommResetScanChangeFlag(void);
// ړf[^𑗐M邱Ƃ
extern void CommEnableSendMoveData(void);
// ړf[^𑗐M邱Ƃ֎~
extern void CommDisableSendMoveData(void);

// f[^𑗂
extern BOOL CommSendData(int command, const void* data, int size);
// eʃf[^𑗂
extern BOOL CommSendHugeData(int command, const void* data, int size);
// eʂŃTCYŒ̃f[^𑗂
extern BOOL CommSendFixHugeSizeData(int command, const void* data);
/// TCYŒ̃f[^𑗂
extern BOOL CommSendFixSizeData(int command, const void* data);
/// R}ĥ݂̃f[^𑗂
extern BOOL CommSendFixData(int command);
/// T[õf[^Sq@ɑ
extern BOOL CommSendData_ServerSide(int command, const void* data, int size);
// T[o[֌ŒTCỸf[^𑗂
extern BOOL CommSendFixSizeData_ServerSide(int command, const void* data);
// T[o[eʃf[^𑗂
extern BOOL CommSendHugeData_ServerSide(int command, const void* data, int size);
// T[o[TCYŒ̑eʃf[^𑗂
extern BOOL CommSendFixHugeSizeData_ServerSide(int command, const void* data);

// L[ɑ\̃f[^߂
extern BOOL CommSetSendQueue_ServerSide(int command, const void* data, int size);
// L[ɑ\̃f[^߂
extern BOOL CommSetSendQueue(int command, const void* data, int size);
/// cL[̐
extern int CommGetRestQueueNum(void);

/// _ɃL[𔭐
extern void CommSetKeyRandMode(void);
extern void CommSetKeyReverseMode(void);
extern void CommResetKeyRandMode(void);

/// DS[hMP[h̐؂ւ
extern void CommSetTransmissonTypeDS(void);
extern void CommSetTransmissonTypeMP(void);
extern int CommGetTransmissonType(void);
// ʐM[hؑւ̃R[obN
extern void CommRecvDSMPChange(int netID, int size, void* pData, void* pWork);
extern void CommRecvDSMPChangeReq(int netID, int size, void* pData, void* pWork);
extern void CommRecvDSMPChangeEnd(int netID, int size, void* pData, void* pWork);
// ̋@netIDԂ
extern u16 CommGetCurrentID(void);

/// f[^Mobt@ɂ邩ǂmF
extern BOOL CommRecvData(int netID,int chkCommand, int* retSize, u8* data);
/// WHCuŁ@ԂIDLEɂȂĂ邩mF
extern BOOL CommIsWHStateIdle(void);
/// q@ȂǂmF
extern BOOL CommIsChildsConnecting(void);
/// e@ؒfꍇTRUE
extern BOOL CommParentDisconnect(void);
/// VRAMDɃCNj[
extern void CommVRAMDInitialize(void);
/// VRAMD̃CNj[̂҂
extern BOOL CommIsVRAMDInitialize(void);
/// G[NTRUEԂ
extern BOOL CommIsError(void);
/// q@ȂG[ɂꍇZbg
extern void CommSetNoChildError(BOOL bOn);
/// T[rXɑΉMoCg𓾂
extern u16 CommGetServiceMaxChildSendByte(u16 serviceNo);
/// őڑl𓾂
extern int CommGetMaxEntry(int service);
/// ŏڑl𓾂
extern int CommGetMinEntry(int service);

/// DSpMf[^̓Ce[^[ 
extern void CommRecvDSIteratorInitialize(int netID);
/// DSpMf[^̓Ce[^[ f[^邩ǂ
extern BOOL CommRecvDSIteratorHasNext(int netID);
/// DSpMf[^̓Ce[^[ f[^oɐi
extern BOOL CommRecvDSIteratorNext(int netID,int *pCommand, int* pSize, u8* pData);
/// r[Rf[^𓾂
extern WMBssDesc* CommGetWMBssDesc(int index);
/// r[Rf[^
extern void CommResetWMBssDesc(int index);
/// MYSTATUS𓾂
extern MYSTATUS* CommGetMyStatus(void);
/// BCONɊ܂܂MYSTATUSԂ
extern MYSTATUS* CommGetBconMyStatus(int index);
/// ؒf[hɓǂԂ
extern BOOL CommIsAutoExit(void);
/// ؒf[hON
extern void CommSetAutoExit(void);

/// lŒʐM郂[h̐ݒ
extern void CommSetAloneMode(BOOL bAlone);
/// lŒʐM郂[hǂ̎擾
extern BOOL CommGetAloneMode(void);

extern void CommSetBackupMacAddress(u8* pMac, int netID);
/// T[rXԍ擾
extern int CommGetServiceNo(void);

/// ̎
extern void CommRandSeedInitialize(MATHRandContext32* pRand);

/// R}hMꂽǂmF
extern BOOL CommIsSendCommand_ServerSize(int command);
extern BOOL CommIsSendCommand(int command);


/// L[ۂǂ
BOOL CommIsEmptyQueue_ServerSize(void);
/// L[ۂǂ
BOOL CommIsEmptyQueue(void);
// DS[hǂ
BOOL CommIsTransmissonDSType(void);


// 퓬ɓO̓G̗ʒuݒ
extern void CommSetStandNo(int no, int netID);
// 퓬ɓO̓G̗ʒu𓾂
extern int CommGetStandNo(int netID);


#if PM_DEBUG
extern void CommSwitchAutoMove_Debug(void);
#endif



#endif // _COMM_SYSTEM_H_

