//=============================================================================
/**
 * @file	comm_tool.h
 * @brief	ʐMVXegʐMc[
 * @author	Katsumi Ohno
 * @date    2006.03.14
 */
//=============================================================================

#ifndef __COMM_TOOL_H__
#define __COMM_TOOL_H__

extern void CommToolInitialize(int heapID);
extern void CommToolFinalize(void);


extern void CommRecvTimingSync(int netID, int size, void* pData, void* pWork);
extern void CommRecvTimingSyncEnd(int netID, int size, void* pData, void* pWork);
extern void CommTimingSyncStart(u8 no);
extern BOOL CommIsTimingSync(u8 no);

extern void CommSpritDataSendFunc(void);
extern void CommRecvSpritData(int netID, int size, void* pData, void* pWork);
extern int CommGetSpritDataPacketSize(void);
extern BOOL CommIsSpritDataRecv(int netID);
extern void CommSetSpritDataRecvBuff(int recvNetID,void* pBuff,int size);
extern void CommSendSpritData(void* pBuff,int size);

extern void CommRecvListNo(int netID, int size, void* pData, void* pWork);
extern int CommGetListNoSize(void);
extern void CommListSet(u8 no,u8 listNo);
extern int CommListGet(int netID, u8 no);
extern void CommListReset(void);


#define  INVALID_LIST_NO  (-1)

#endif  //__COMM_TOOL_H__


